/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.PGSQLBase;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSyntaxMySQL;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;

class SQLSyntaxPG
extends SQLSyntax {
    private static final Pattern NOW_PTRN = Pattern.compile("\\(?'now'::text\\)?(::timestamp)");

    SQLSyntaxPG() {
        super(SQLSystem.POSTGRESQL);
        this.typeNames.putAll(Boolean.class, "boolean", "bool", "bit");
        this.typeNames.putAll(Integer.class, "integer", "int", "int4");
        this.typeNames.putAll(Long.class, "bigint", "int8");
        this.typeNames.putAll(BigInteger.class, "bigint");
        this.typeNames.putAll(BigDecimal.class, "decimal", "numeric");
        this.typeNames.putAll(Float.class, "real", "float4");
        this.typeNames.putAll(Double.class, "double precision", "float8");
        this.typeNames.putAll(Timestamp.class, "timestamp", "timestamp without time zone");
        this.typeNames.putAll(Date.class, "time", "time without time zone", "date");
        this.typeNames.putAll(Blob.class, "bytea");
        this.typeNames.putAll(Clob.class, "varchar", "char", "character varying", "character", "text");
        this.typeNames.putAll(String.class, "varchar", "char", "character varying", "character", "text");
    }

    @Override
    public String getIDType() {
        return " int";
    }

    @Override
    public String getAuto() {
        return " serial";
    }

    @Override
    public SQLBase createBase(SQLServer server, String name, String login, String pass, IClosure<SQLDataSource> dsInit) {
        return new PGSQLBase(server, name, login, pass, dsInit);
    }

    @Override
    public String getNullIsDataComparison(String x, boolean eq, String y) {
        return String.valueOf(x) + (eq ? " IS NOT DISTINCT FROM " : " IS DISTINCT FROM ") + y;
    }

    @Override
    public String getFunctionQuery(SQLBase b, Set<String> schemas) {
        return "SELECT ROUTINE_SCHEMA as \"schema\", ROUTINE_NAME as \"name\", ROUTINE_DEFINITION as \"src\" FROM \"information_schema\".ROUTINES where ROUTINE_CATALOG='" + b.getMDName() + "' and ROUTINE_SCHEMA in (" + SQLSyntaxPG.quoteStrings(b, schemas) + ")";
    }

    @Override
    public String getTriggerQuery(SQLBase b, Set<String> schemas, Set<String> tables) throws SQLException {
        return "SELECT tgname as \"TRIGGER_NAME\", n.nspname as \"TABLE_SCHEMA\", c.relname as \"TABLE_NAME\", tgfoid as \"ACTION\", pg_get_triggerdef(t.oid) as \"SQL\" \nFROM pg_catalog.pg_trigger t\nLEFT join pg_catalog.pg_class c on t.tgrelid = c.oid\nLEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace\nwhere not t." + (b.getVersion()[0] >= 9 ? "tgisinternal" : "tgisconstraint") + " and " + this.getInfoSchemaWhere(b, "n.nspname", schemas, "c.relname", tables);
    }

    private final String getInfoSchemaWhere(SQLBase b, String schemaCol, Set<String> schemas, String tableCol, Set<String> tables) {
        String tableWhere = tables == null ? "" : " and " + tableCol + " in (" + SQLSyntaxPG.quoteStrings(b, tables) + ")";
        return String.valueOf(schemaCol) + " in ( " + SQLSyntaxPG.quoteStrings(b, schemas) + ") " + tableWhere;
    }

    @Override
    public String getColumnsQuery(SQLBase b, Set<String> schemas, Set<String> tables) {
        return "SELECT TABLE_SCHEMA as \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(0) + "\", TABLE_NAME as \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(1) + "\", COLUMN_NAME as \"" + (String)INFO_SCHEMA_NAMES_KEYS.get(2) + "\" , CHARACTER_SET_NAME as \"CHARACTER_SET_NAME\", COLLATION_NAME as \"COLLATION_NAME\" from INFORMATION_SCHEMA.COLUMNS where " + this.getInfoSchemaWhere(b, "TABLE_SCHEMA", schemas, "TABLE_NAME", tables);
    }

    @Override
    public List<Map<String, Object>> getConstraints(SQLBase b, Set<String> schemas, Set<String> tables) throws SQLException {
        String sel = "select nsp.nspname as \"TABLE_SCHEMA\", rel.relname as \"TABLE_NAME\", c.conname as \"CONSTRAINT_NAME\", c.oid as cid, \ncase c.contype when 'u' then 'UNIQUE' when 'c' then 'CHECK' when 'f' then 'FOREIGN KEY' when 'p' then 'PRIMARY KEY' end as \"CONSTRAINT_TYPE\", att.attname as \"COLUMN_NAME\", c.conkey as \"colsNum\", att.attnum as \"colNum\"\nfrom pg_catalog.pg_constraint c\njoin pg_namespace nsp on nsp.oid = c.connamespace\nleft join pg_class rel on rel.oid = c.conrelid\nleft join pg_attribute att on  att.attrelid = c.conrelid and att.attnum = ANY(c.conkey)\nwhere " + this.getInfoSchemaWhere(b, "nsp.nspname", schemas, "rel.relname", tables) + "\norder by nsp.nspname, rel.relname, c.conname";
        List<Map<String, Object>> res = this.sort((List)b.getDBSystemRoot().getDataSource().execute(sel, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false)));
        SQLSyntaxMySQL.mergeColumnNames(res);
        return res;
    }

    private List<Map<String, Object>> sort(List<Map<String, Object>> sortedByConstraint) {
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>(sortedByConstraint.size());
        Comparator<Map<String, Object>> comp = new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                return CompareUtils.compareInt(this.getIndex(o1), this.getIndex(o2));
            }

            private final int getIndex(Map<String, Object> o) {
                int colNum = ((Number)o.get("colNum")).intValue();
                try {
                    Object[] array = (Integer[])((Array)o.get("colsNum")).getArray();
                    int i = 0;
                    while (i < array.length) {
                        if (array[i] == colNum) {
                            return i;
                        }
                        ++i;
                    }
                    throw new IllegalStateException(String.valueOf(colNum) + " was not found in " + Arrays.toString(array));
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        int prevID = -1;
        ArrayList<Map<String, Object>> currentConstr = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> m : sortedByConstraint) {
            int currentID = ((Number)m.get("cid")).intValue();
            if (currentConstr.size() > 0 && currentID != prevID) {
                res.addAll(this.sort(currentConstr, comp));
                currentConstr.clear();
            }
            currentConstr.add(m);
            prevID = currentID;
        }
        res.addAll(this.sort(currentConstr, comp));
        return res;
    }

    private final List<Map<String, Object>> sort(List<Map<String, Object>> currentConstr, Comparator<Map<String, Object>> comp) {
        Collections.sort(currentConstr, comp);
        int i = 0;
        while (i < currentConstr.size()) {
            currentConstr.get(i).put("ORDINAL_POSITION", i + 1);
            currentConstr.get(i).remove("cid");
            currentConstr.get(i).remove("colNum");
            currentConstr.get(i).remove("colsNum");
            ++i;
        }
        return currentConstr;
    }

    @Override
    public String getUpdate(SQLTable t, List<String> tables, Map<String, String> setPart) {
        String res = String.valueOf(t.getSQLName().quote()) + " SET\n" + CollectionUtils.join(setPart.entrySet(), ",\n", new ITransformer<Map.Entry<String, String>, String>(){

            @Override
            public String transformChecked(Map.Entry<String, String> input) {
                return String.valueOf(SQLBase.quoteIdentifier(input.getKey())) + " = " + input.getValue();
            }
        });
        if (tables.size() > 0) {
            res = String.valueOf(res) + " FROM " + CollectionUtils.join(tables, ", ");
        }
        return res;
    }
}

