/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSyntaxMySQL;
import org.openconcerto.sql.model.SQLSystem;

class SQLSyntaxMS
extends SQLSyntax {
    private static final Pattern nullPatrn = Pattern.compile("\\N", 16);
    private static final Pattern backSlashPatrn = Pattern.compile("\\\"", 16);
    private static final Pattern newlinePatrn = Pattern.compile("\n");
    private static final Pattern newlineAndIDPatrn = Pattern.compile("\n(?=\\p{Digit}+\\|)");
    private static final Pattern commaSepPatrn = Pattern.compile("(?<!\\\\)\",\"");
    private static final Pattern firstLastQuotePatrn = Pattern.compile("(^\")|(\"$)", 8);
    private static final Pattern boolTPatrn = Pattern.compile("(?<=\\|)t\\|");
    private static final Pattern boolFPatrn = Pattern.compile("(?<=\\|)f\\|");
    private static final Pattern boolTEndPatrn = Pattern.compile("\\|t$", 8);
    private static final Pattern boolFEndPatrn = Pattern.compile("\\|f$", 8);
    private static final Pattern dateWithOffsetPatrn = Pattern.compile("(\\|\\p{Digit}{4}-\\p{Digit}{2}-\\p{Digit}{2} \\p{Digit}{2}:\\p{Digit}{2}:\\p{Digit}{2}(.\\p{Digit}{1,3})?)\\+\\p{Digit}{2}");

    SQLSyntaxMS() {
        super(SQLSystem.MSSQL);
        this.typeNames.putAll(Boolean.class, "bit");
        this.typeNames.putAll(Integer.class, "tinyint", "smallint", "unsigned smallint", "int", "unsigned int");
        this.typeNames.putAll(Long.class, "bigint");
        this.typeNames.putAll(BigDecimal.class, "unsigned bigint", "decimal", "numeric", "smallmoney", "money");
        this.typeNames.putAll(Float.class, "real");
        this.typeNames.putAll(Double.class, "float");
        this.typeNames.putAll(Timestamp.class, "smalldatetime", "datetime");
        this.typeNames.putAll(Date.class, "date");
        this.typeNames.putAll(Time.class, "time");
        this.typeNames.putAll(Blob.class, "image", "varbinary", "binary");
        this.typeNames.putAll(Clob.class, "text", "ntext", "unitext");
        this.typeNames.putAll(String.class, "char", "varchar", "nchar", "nvarchar", "unichar", "univarchar");
    }

    @Override
    public String getAuto() {
        return " int IDENTITY";
    }

    @Override
    public String getNullIsDataComparison(String x, boolean eq, String y) {
        return SQLSystem.H2.getSyntax().getNullIsDataComparison(x, eq, y);
    }

    @Override
    public String getFunctionQuery(SQLBase b, Set<String> schemas) {
        return "  select name, schema_name(schema_id) as \"schema\", cast(OBJECT_DEFINITION(object_id) as varchar(4096)) as \"src\"\n  FROM " + new SQLName(b.getName(), "sys", "objects") + "\n" + "  where type IN ('FN', 'IF', 'TF') and SCHEMA_NAME( schema_id ) in (" + SQLSyntaxMS.quoteStrings(b, schemas) + ") ";
    }

    @Override
    public String getTriggerQuery(SQLBase b, Set<String> schemas, Set<String> tables) {
        String tableWhere = tables == null ? "" : " and tabl.name in (" + SQLSyntaxMS.quoteStrings(b, tables) + ")";
        return "SELECT  trig.name as \"TRIGGER_NAME\", SCHEMA_NAME( tabl.schema_id ) as \"TABLE_SCHEMA\", tabl.name as \"TABLE_NAME\",  null as \"ACTION\", cast(OBJECT_DEFINITION(trig.object_id) as varchar(4096)) as \"SQL\"\nFROM " + new SQLName(b.getName(), "sys", "triggers") + " trig\n" + "join " + new SQLName(b.getName(), "sys", "objects") + " tabl on trig.parent_id = tabl.object_id\n" + "where SCHEMA_NAME( tabl.schema_id ) in (" + SQLSyntaxMS.quoteStrings(b, schemas) + ") " + tableWhere;
    }

    @Override
    public String getColumnsQuery(SQLBase b, Set<String> schemas, Set<String> tables) {
        return null;
    }

    private final String getInfoSchemaWhere(SQLBase b, String schemaCol, Set<String> schemas, String tableCol, Set<String> tables) {
        String tableWhere = tables == null ? "" : " and " + tableCol + " in (" + SQLSyntaxMS.quoteStrings(b, tables) + ")";
        return String.valueOf(schemaCol) + " in ( " + SQLSyntaxMS.quoteStrings(b, schemas) + ") " + tableWhere;
    }

    @Override
    public List<Map<String, Object>> getConstraints(SQLBase b, Set<String> schemas, Set<String> tables) throws SQLException {
        String where = "where " + this.getInfoSchemaWhere(b, "SCHEMA_NAME(t.schema_id)", schemas, "t.name", tables);
        String sel = "SELECT SCHEMA_NAME(t.schema_id) AS \"TABLE_SCHEMA\", t.name AS \"TABLE_NAME\", k.name AS \"CONSTRAINT_NAME\", case k.type when 'UQ' then 'UNIQUE' when 'PK' then 'PRIMARY KEY' end as \"CONSTRAINT_TYPE\", col_name(c.object_id, c.column_id) AS \"COLUMN_NAME\", c.key_ordinal AS \"ORDINAL_POSITION\"\nFROM sys.key_constraints k\nJOIN sys.index_columns c ON c.object_id = k.parent_object_id AND c.index_id = k.unique_index_id\nJOIN sys.tables t ON t.object_id = k.parent_object_id\n" + where + "\nUNION ALL\n" + "SELECT SCHEMA_NAME(t.schema_id) AS \"TABLE_SCHEMA\", t.name AS \"TABLE_NAME\", k.name AS \"CONSTRAINT_NAME\", 'CHECK' as \"CONSTRAINT_TYPE\", col.name AS \"COLUMN_NAME\", 1 AS \"ORDINAL_POSITION\"\n" + "FROM sys.check_constraints k\n" + "join sys.tables t on k.parent_object_id = t.object_id\n" + "left join sys.columns col on k.parent_column_id = col.column_id and col.object_id = t.object_id\n" + where;
        List res = (List)b.getDBSystemRoot().getDataSource().execute(sel, new IResultSetHandler(SQLDataSource.MAP_LIST_HANDLER, false));
        SQLSyntaxMySQL.mergeColumnNames(res);
        return res;
    }
}

