/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSyntaxH2;
import org.openconcerto.sql.model.SQLSyntaxMS;
import org.openconcerto.sql.model.SQLSyntaxMySQL;
import org.openconcerto.sql.model.SQLSyntaxPG;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;

public abstract class SQLSyntax {
    private static final Map<SQLSystem, SQLSyntax> instances = new HashMap<SQLSystem, SQLSyntax>();
    private final SQLSystem sys;
    protected final CollectionMap<Class, String> typeNames;
    private static final Set<String> nonStandardTimeFunctions;
    public static final List<String> INFO_SCHEMA_NAMES_KEYS;

    static {
        SQLSyntax.register(new SQLSyntaxPG());
        SQLSyntax.register(new SQLSyntaxH2());
        SQLSyntax.register(new SQLSyntaxMySQL());
        SQLSyntax.register(new SQLSyntaxMS());
        nonStandardTimeFunctions = CollectionUtils.createSet("now()", "transaction_timestamp()", "current_timestamp()");
        INFO_SCHEMA_NAMES_KEYS = Arrays.asList("TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME");
    }

    private static void register(SQLSyntax s) {
        instances.put(s.getSystem(), s);
    }

    public static final SQLSyntax get(DBStructureItem<?> sql) {
        return SQLSyntax.get(sql.getServer().getSQLSystem());
    }

    public static final SQLSyntax get(SQLSystem system) {
        SQLSyntax res = instances.get((Object)system);
        if (res == null) {
            throw new IllegalArgumentException("unsupported system: " + (Object)((Object)system));
        }
        return res;
    }

    protected SQLSyntax(SQLSystem sys) {
        this.sys = sys;
        this.typeNames = new CollectionMap(new HashSet(4));
    }

    public final SQLSystem getSystem() {
        return this.sys;
    }

    public abstract String getAuto();

    public String getIDType() {
        return " int";
    }

    public String getPrimaryIDDefinitionShort() {
        return this.getAuto();
    }

    public final String getPrimaryIDDefinition() {
        return String.valueOf(this.getPrimaryIDDefinitionShort()) + " PRIMARY KEY";
    }

    public String getArchiveType() {
        return " int";
    }

    public String getArchiveDefinition() {
        return String.valueOf(this.getArchiveType()) + " DEFAULT 0 NOT NULL";
    }

    public final String getOrderType() {
        return " DECIMAL(" + this.getOrderPrecision() + "," + this.getOrderScale() + ")";
    }

    public final int getOrderPrecision() {
        return 16;
    }

    public final int getOrderScale() {
        return 8;
    }

    public final Object getOrderDefault() {
        return null;
    }

    public final String getOrderDefinition() {
        return String.valueOf(this.getOrderType()) + " DEFAULT " + this.getOrderDefault() + " UNIQUE";
    }

    public String getFK(String constraintPrefix, List<String> fk, SQLName refTable, List<String> referencedFields) {
        return String.valueOf(SQLSelect.quote("CONSTRAINT %i FOREIGN KEY ( " + SQLSyntax.quoteIdentifiers(fk) + " ) REFERENCES %i ", String.valueOf(constraintPrefix) + CollectionUtils.join(fk, "__") + "_fkey", refTable)) + "( " + SQLSyntax.quoteIdentifiers(referencedFields) + " )";
    }

    public String getCreateTableSuffix() {
        return "";
    }

    SQLBase createBase(SQLServer server, String name, String login, String pass, IClosure<SQLDataSource> dsInit) {
        return new SQLBase(server, name, login, pass, dsInit);
    }

    public abstract String getNullIsDataComparison(String var1, boolean var2, String var3);

    public abstract String getColumnsQuery(SQLBase var1, Set<String> var2, Set<String> var3);

    public abstract String getFunctionQuery(SQLBase var1, Set<String> var2);

    public abstract List<Map<String, Object>> getConstraints(SQLBase var1, Set<String> var2, Set<String> var3) throws SQLException;

    protected static final String quoteStrings(final SQLBase b, Collection<String> c) {
        return CollectionUtils.join(c, ", ", new ITransformer<String, String>(){

            @Override
            public String transformChecked(String s) {
                return b.quoteString(s);
            }
        });
    }

    public static final String quoteIdentifiers(Collection<String> c) {
        return CollectionUtils.join(c, ", ", new ITransformer<String, String>(){

            @Override
            public String transformChecked(String s) {
                return SQLBase.quoteIdentifier(s);
            }
        });
    }

    public abstract String getTriggerQuery(SQLBase var1, Set<String> var2, Set<String> var3) throws SQLException;

    public String getUpdate(SQLTable t, List<String> tables, Map<String, String> setPart) throws UnsupportedOperationException {
        if (tables.size() > 0) {
            throw new UnsupportedOperationException();
        }
        return t.getSQLName() + "\nSET " + CollectionUtils.join(setPart.entrySet(), ",\n", new ITransformer<Map.Entry<String, String>, String>(){

            @Override
            public String transformChecked(Map.Entry<String, String> input) {
                return String.valueOf(input.getKey()) + " = " + input.getValue();
            }
        });
    }
}

