/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.Collections;
import java.util.List;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;

public class SQLBackgroundTableCacheItem
implements SQLTableModifiedListener {
    private SQLTable table;
    private int timeout;
    private List<SQLRow> rows;
    private long lastReload;

    @Override
    public void tableModified(SQLTableEvent evt) {
        this.lastReload = 0L;
        this.reloadFromDbIfNeeded();
    }

    public synchronized void reloadFromDbIfNeeded() {
        long delta = System.currentTimeMillis() - this.lastReload;
        if (delta / 1000L > (long)this.timeout) {
            SQLSelect sel = new SQLSelect(this.table.getBase());
            sel.addSelectStar(this.table);
            this.rows = Collections.unmodifiableList((List)this.table.getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel, this.table)));
            this.lastReload = System.currentTimeMillis();
        }
    }

    public synchronized SQLRow getFirstRowContains(int id, SQLField field) {
        for (SQLRow r : this.rows) {
            if (r.getInt(field.getName()) != id) continue;
            return r;
        }
        return null;
    }

    public synchronized SQLRow getRowFromId(int i) {
        return this.getFirstRowContains(i, this.table.getKey());
    }
}

