/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.Collections;
import org.openconcerto.sql.model.DBStructureItemDB;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.DatabaseGraph;

public final class DBRoot
extends DBStructureItemDB {
    private DatabaseGraph graph = null;
    private final PropertyChangeListener l = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("graph")) {
                DBRoot.this.clearGraph();
            }
        }
    };

    DBRoot(DBStructureItemJDBC delegate) {
        super(delegate);
        this.getDBSystemRoot().addListener(this.l);
    }

    @Override
    protected void onDrop() {
        this.getDBSystemRoot().rmListener(this.l);
        this.clearGraph();
        super.onDrop();
    }

    public final SQLBase getBase() {
        return this.getJDBC().getAncestor(SQLBase.class);
    }

    public SQLTable getTable(String name) {
        return (SQLTable)DBRoot.getJDBC(this.getChild(name));
    }

    public SQLTable findTable(String name) {
        return this.findTable(name, false);
    }

    public SQLTable findTable(String name, boolean mustExist) {
        if (this.contains(name)) {
            return this.getTable(name);
        }
        return this.getDBSystemRoot().findTable(name, mustExist);
    }

    public final String getMetadata(String name) {
        return this.getSchema().getFwkMetadata(name);
    }

    public final SQLSchema getSchema() {
        return (SQLSchema)this.getJDBC().getNonNullDBParent();
    }

    private synchronized void clearGraph() {
        this.graph = null;
    }

    public synchronized DatabaseGraph getGraph() {
        if (this.graph == null) {
            this.graph = new DatabaseGraph(this.getDBSystemRoot().getGraph(), this);
        }
        return this.graph;
    }

    public void refetch() throws SQLException {
        if (this.getJDBC() instanceof SQLBase) {
            ((SQLBase)this.getJDBC()).fetchTables();
        } else if (this.getJDBC() instanceof SQLSchema) {
            this.getBase().fetchTables(Collections.singleton(this.getName()));
        } else {
            throw new IllegalStateException();
        }
    }
}

