/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLTable;

class AliasedTables {
    final Map<String, AliasedTable> tables;

    private AliasedTables(Map<String, AliasedTable> m) {
        this.tables = new LinkedHashMap<String, AliasedTable>(m);
    }

    public AliasedTables() {
        this(Collections.emptyMap());
    }

    AliasedTables(AliasedTables at) {
        this(at.tables);
    }

    public AliasedTable add(String alias, SQLTable t) {
        AliasedTable res;
        if (alias == null) {
            alias = t.getName();
        }
        if (!this.contains(alias)) {
            res = new AliasedTable(t, alias);
            this.tables.put(alias, res);
        } else {
            if (this.getTable(alias) != t) {
                throw new IllegalArgumentException(t.getSQLName() + " can't be aliased to " + alias + " : " + this.getTable(alias).getSQLName() + " already is");
            }
            res = this.getAliasedTable(alias);
        }
        return res;
    }

    public AliasedTable add(SQLTable t) {
        return this.add(t.getName(), t);
    }

    public AliasedTable add(FieldRef f) {
        return this.add(f.getAlias(), f.getField().getTable());
    }

    public SQLTable getTable(String alias) {
        return this.getAliasedTable(alias).getTable();
    }

    public List<AliasedTable> getAliases(SQLTable t) {
        ArrayList<AliasedTable> res = new ArrayList<AliasedTable>();
        for (AliasedTable at : this.tables.values()) {
            if (!at.getTable().equals(t)) continue;
            res.add(at);
        }
        return res;
    }

    private AliasedTable getAliasedTable(String alias) {
        return this.tables.get(alias);
    }

    public boolean contains(String alias) {
        return this.tables.containsKey(alias);
    }

    public LinkedHashSet<String> getAliases() {
        return new LinkedHashSet<String>(this.tables.keySet());
    }
}

