/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLUtils;

public class RowItemViewMetadata {
    private final SQLTable table;
    private List<SQLRowValues> groups;
    private Map<String, List<SQLRowValues>> metas = new HashMap<String, List<SQLRowValues>>();

    public static SQLTable getMetaTable(final DBRoot root) throws SQLException {
        if (!root.contains("RIV_METADATA")) {
            final SQLDataSource ds = root.getDBSystemRoot().getDataSource();
            SQLUtils.executeAtomic(ds, new SQLUtils.SQLFactory<Object>(){

                @Override
                public Object create() throws SQLException {
                    SQLCreateTable createValueT = new SQLCreateTable(root, "RIV_METADATA");
                    createValueT.setPlain(true);
                    createValueT.addColumn("ID", createValueT.getSyntax().getPrimaryIDDefinition());
                    createValueT.addVarCharColumn("ELEMENT_ID", 80);
                    createValueT.addVarCharColumn("COMPONENT_ID", 80);
                    createValueT.addVarCharColumn("GROUP_ID", 80);
                    createValueT.addVarCharColumn("ITEM_ID", 80);
                    createValueT.addVarCharColumn("LABEL", 256);
                    createValueT.addVarCharColumn("COLUMN_TITLE", 256);
                    createValueT.addVarCharColumn("DOCUMENTATION", 8192);
                    ds.execute(createValueT.asString());
                    SQLTable.setUndefID(root.getSchema(), createValueT.getName(), null);
                    root.getSchema().updateVersion();
                    return null;
                }
            });
            root.refetch();
        }
        return root.getTable("RIV_METADATA");
    }

    public RowItemViewMetadata(DBRoot root) throws SQLException {
        this.table = RowItemViewMetadata.getMetaTable(root);
        this.fetchAllGroups();
    }

    private void fetchAllGroups() {
        SQLRowValues graph = new SQLRowValues(this.table);
        graph.put("ELEMENT_ID", null);
        graph.put("COMPONENT_ID", null);
        graph.put("GROUP_ID", null);
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(graph);
        this.groups = fetcher.fetch();
    }
}

