/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.erp.preferences.TemplatePreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.cc.ITransformer;

public class PanelOOSQLComponent
extends JPanel {
    private final JCheckBox checkImpression = new JCheckBox("Imprimer");
    private final JCheckBox checkVisu = new JCheckBox("Visualiser");

    public PanelOOSQLComponent(final BaseSQLComponent comp) {
        super(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = -1;
        this.setOpaque(false);
        if (TemplateNXProps.getInstance().getBooleanValue(TemplatePreferencePanel.MULTIMOD, false)) {
            if (comp.getElement().getTable().getFieldsName().contains("ID_MODELE")) {
                JLabel labelModele = new JLabel(comp.getLabelFor("ID_MODELE"));
                ElementComboBox boxModele = new ElementComboBox();
                comp.addView(boxModele, "ID_MODELE");
                boxModele.getRequest().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect input) {
                        SQLTable table = Configuration.getInstance().getDirectory().getElement("TYPE_MODELE").getTable();
                        Where w = new Where((FieldRef)table.getField("TABLE"), "=", (Object)comp.getElement().getTable().getName());
                        input.setWhere(w);
                        System.err.println(input.asString());
                        return input;
                    }
                });
                this.add((Component)labelModele, c);
                this.add((Component)boxModele, c);
            } else {
                System.err.println("Impossible d'ajouter la combo pour le choix des mod\u00e8les car le champ ID_MODELE n'est pas pr\u00e9sent dans la table " + comp.getElement().getTable().getName());
                Thread.dumpStack();
            }
        }
        this.add((Component)this.checkImpression, c);
        this.add((Component)this.checkVisu, c);
    }

    public boolean isVisualisationSelected() {
        return this.checkVisu.isSelected();
    }

    public boolean isImpressionSelected() {
        return this.checkImpression.isSelected();
    }
}

