/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.util.Map;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieVenteFacture;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationMvtTicketCaisse
extends GenerationEcritures
implements Runnable {
    public static final Integer journal = 3;
    private SQLRow rowTicket;
    private static final SQLTable ticketTable = base.getTable("TICKET_CAISSE");
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtTicketCaisse(SQLRow ticket) {
        System.err.println("********* init GeneRation");
        this.idMvt = 1;
        this.rowTicket = ticket;
    }

    private void genereMouvement() throws IllegalArgumentException {
        int idCompteClient;
        SQLRow clientRow = this.rowTicket.getForeignRow("ID_CLIENT");
        PrixTTC prixTTC = new PrixTTC((Long)this.rowTicket.getObject("TOTAL_TTC"));
        PrixHT prixTVA = new PrixHT((Long)this.rowTicket.getObject("TOTAL_TVA"));
        PrixHT prixHT = new PrixHT((Long)this.rowTicket.getObject("TOTAL_HT"));
        this.date = this.rowTicket.getDate("DATE").getTime();
        this.nom = "Ticket " + this.rowTicket.getString("NUMERO");
        this.mEcritures.put("DATE", this.date);
        this.mEcritures.put("NOM", this.nom);
        this.mEcritures.put("ID_JOURNAL", GenerationMvtSaisieVenteFacture.journal);
        this.mEcritures.put("ID_MOUVEMENT", 1);
        if (this.idMvt == 1) {
            this.getNewMouvement("TICKET_CAISSE", this.rowTicket.getID(), 1, this.nom);
        } else {
            this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
        }
        long produitHT = prixHT.getLongValue();
        if (produitHT >= 0L && produitHT > 0L) {
            int idCompteVenteProduit = 1;
            if (idCompteVenteProduit <= 1 && (idCompteVenteProduit = rowPrefsCompte.getInt("ID_COMPTE_PCE_VENTE_PRODUIT")) <= 1) {
                try {
                    idCompteVenteProduit = ComptePCESQLElement.getIdComptePceDefault("VentesProduits");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mEcritures.put("ID_COMPTE_PCE", idCompteVenteProduit);
            this.mEcritures.put("DEBIT", 0L);
            this.mEcritures.put("CREDIT", produitHT);
            this.ajoutEcriture();
        }
        if (prixTVA.getLongValue() > 0L) {
            int idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_VENTE");
            if (idCompteTVA <= 1) {
                try {
                    idCompteTVA = ComptePCESQLElement.getIdComptePceDefault("TVACollectee");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Map<Integer, Long> m = this.getMultiTVAFromRow(this.rowTicket, this.rowTicket.getTable().getTable("SAISIE_VENTE_FACTURE_ELEMENT"));
            long allTaxe = 0L;
            for (Integer i : m.keySet()) {
                Long l = m.get(i);
                if (l == null || l <= 0L) continue;
                int idCpt = i;
                if (idCpt <= 1) {
                    idCpt = idCompteTVA;
                }
                this.mEcritures.put("ID_COMPTE_PCE", idCpt);
                this.mEcritures.put("DEBIT", 0L);
                this.mEcritures.put("CREDIT", Long.valueOf(l));
                this.ajoutEcriture();
                allTaxe += l.longValue();
            }
            if (allTaxe < prixTVA.getLongValue()) {
                this.mEcritures.put("ID_COMPTE_PCE", idCompteTVA);
                this.mEcritures.put("DEBIT", 0L);
                this.mEcritures.put("CREDIT", prixTVA.getLongValue() - allTaxe);
                this.ajoutEcriture();
            }
        }
        if ((idCompteClient = clientRow.getInt("ID_COMPTE_PCE")) <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
            try {
                idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mEcritures.put("ID_COMPTE_PCE", idCompteClient);
        this.mEcritures.put("DEBIT", prixTTC.getLongValue());
        this.mEcritures.put("CREDIT", 0L);
        this.ajoutEcriture();
        SQLRowValues valTicket = new SQLRowValues(ticketTable);
        valTicket.put("ID_MOUVEMENT", (Object)this.idMvt);
        try {
            if (valTicket.getInvalid() == null) {
                valTicket.update(this.rowTicket.getID());
            }
        }
        catch (SQLException e) {
            System.err.println("Erreur \u00e0 l'insertion dans la table " + valTicket.getTable().getName() + " : " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            System.err.println("****Start genere Mouvement");
            this.genereMouvement();
            System.err.println("****End genere Mouvement");
        }
        catch (IllegalArgumentException e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
            e.printStackTrace();
        }
    }
}

