/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.generationEcritures.GenerationMvtReglementAvoir;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationMvtAvoirClient
extends GenerationEcritures {
    private static final Integer journal = 3;
    private int idAvoirClient;
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtAvoirClient(int idAvoirClient) {
        this.idMvt = 1;
        this.idAvoirClient = idAvoirClient;
    }

    public GenerationMvtAvoirClient(int idAvoirClient, int idMvt) {
        this.idMvt = idMvt;
        this.idAvoirClient = idAvoirClient;
    }

    public int genereMouvement() {
        int idJrnlFactor;
        SQLTable avoirClientTable = base.getTable("AVOIR_CLIENT");
        SQLRow avoirRow = avoirClientTable.getRow(this.idAvoirClient);
        boolean affacturage = avoirRow.getBoolean("AFFACTURE");
        SQLRow rowClient = avoirRow.getForeignRow("ID_CLIENT");
        PrixTTC prixTTC = new PrixTTC((Long)avoirRow.getObject("MONTANT_TTC"));
        PrixHT prixHT = new PrixHT((Long)avoirRow.getObject("MONTANT_HT"));
        PrixHT prixTVA = new PrixHT((Long)avoirRow.getObject("MONTANT_TVA"));
        PrixHT prixService = new PrixHT((Long)avoirRow.getObject("MONTANT_SERVICE"));
        this.date = (Date)avoirRow.getObject("DATE");
        this.nom = avoirRow.getObject("NOM").toString();
        this.mEcritures.put("DATE", new java.sql.Date(this.date.getTime()));
        this.mEcritures.put("NOM", "Avoir Client : " + avoirRow.getString("NUMERO") + " " + rowClient.getString("NOM"));
        this.mEcritures.put("ID_JOURNAL", journal);
        if (affacturage && (idJrnlFactor = rowPrefsCompte.getInt("ID_JOURNAL_FACTOR")) > 1) {
            this.mEcritures.put("ID_JOURNAL", idJrnlFactor);
        }
        this.mEcritures.put("ID_MOUVEMENT", 1);
        if (this.idMvt == 1) {
            this.getNewMouvement("AVOIR_CLIENT", this.idAvoirClient, 1, "Avoir Client : " + avoirRow.getString("NUMERO"));
        } else {
            this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
        }
        int idCompteVenteService = avoirRow.getInt("ID_COMPTE_PCE_SERVICE");
        if (idCompteVenteService <= 1 && (idCompteVenteService = rowPrefsCompte.getInt("ID_COMPTE_PCE_VENTE_SERVICE")) <= 1) {
            try {
                idCompteVenteService = ComptePCESQLElement.getIdComptePceDefault("VentesServices");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            int idCompteTVA;
            long produitHT = prixHT.getLongValue() - prixService.getLongValue();
            if (produitHT >= 0L) {
                if (produitHT > 0L) {
                    int idCompteVenteProduit = rowPrefsCompte.getInt("ID_COMPTE_PCE_VENTE_PRODUIT");
                    if (idCompteVenteProduit <= 1) {
                        try {
                            idCompteVenteProduit = ComptePCESQLElement.getIdComptePceDefault("VentesProduits");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.mEcritures.put("ID_COMPTE_PCE", idCompteVenteProduit);
                    this.mEcritures.put("DEBIT", produitHT);
                    this.mEcritures.put("CREDIT", 0L);
                    this.ajoutEcriture();
                }
                if (prixService.getLongValue() > 0L) {
                    this.mEcritures.put("ID_COMPTE_PCE", idCompteVenteService);
                    this.mEcritures.put("DEBIT", prixService.getLongValue());
                    this.mEcritures.put("CREDIT", 0L);
                    this.ajoutEcriture();
                }
            } else {
                this.mEcritures.put("ID_COMPTE_PCE", idCompteVenteService);
                this.mEcritures.put("DEBIT", prixHT.getLongValue());
                this.mEcritures.put("CREDIT", 0L);
                this.ajoutEcriture();
            }
            if ((idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_VENTE")) <= 1) {
                try {
                    idCompteTVA = ComptePCESQLElement.getIdComptePceDefault("TVACollectee");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mEcritures.put("ID_COMPTE_PCE", idCompteTVA);
            this.mEcritures.put("DEBIT", prixTVA.getLongValue());
            this.mEcritures.put("CREDIT", 0L);
            this.ajoutEcriture();
            int idCompteClient = avoirRow.getForeignRow("ID_CLIENT").getInt("ID_COMPTE_PCE");
            if (idCompteClient <= 1 && (idCompteClient = rowPrefsCompte.getInt("ID_COMPTE_PCE_CLIENT")) <= 1) {
                try {
                    idCompteClient = ComptePCESQLElement.getIdComptePceDefault("Clients");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mEcritures.put("ID_COMPTE_PCE", idCompteClient);
            this.mEcritures.put("DEBIT", 0L);
            this.mEcritures.put("CREDIT", prixTTC.getLongValue());
            this.ajoutEcriture();
            SQLRowValues valAvoir = new SQLRowValues(avoirClientTable);
            valAvoir.put("ID_MOUVEMENT", (Object)this.idMvt);
            try {
                if (valAvoir.getInvalid() == null) {
                    valAvoir.update(this.idAvoirClient);
                }
            }
            catch (SQLException e) {
                System.err.println("Erreur \u00e0 l'insertion dans la table " + avoirClientTable.getName() + " : " + e);
                e.printStackTrace();
            }
            if (affacturage) {
                this.mEcritures.put("ID_COMPTE_PCE", idCompteClient);
                this.mEcritures.put("DEBIT", prixTTC.getLongValue());
                this.mEcritures.put("CREDIT", 0L);
                this.ajoutEcriture();
                int idComptefactor = rowPrefsCompte.getInt("ID_COMPTE_PCE_FACTOR");
                if (idComptefactor <= 1 && (idComptefactor = rowPrefsCompte.getInt("ID_COMPTE_PCE_FACTOR")) <= 1) {
                    try {
                        idComptefactor = ComptePCESQLElement.getIdComptePceDefault("Factor");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.mEcritures.put("ID_COMPTE_PCE", idComptefactor);
                this.mEcritures.put("DEBIT", 0L);
                this.mEcritures.put("CREDIT", prixTTC.getLongValue());
                this.ajoutEcriture();
            }
            if (avoirRow.getInt("ID_MODE_REGLEMENT") > 1) {
                new GenerationMvtReglementAvoir(this.idAvoirClient, this.idMvt);
            } else {
                valAvoir.put("SOLDE", Boolean.FALSE);
                try {
                    valAvoir.update(this.idAvoirClient);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IllegalArgumentException e) {
            ExceptionHandler.handle("Erreur pendant la g\u00e9n\u00e9rations des \u00e9critures comptables", e);
            e.printStackTrace();
        }
        return this.idMvt;
    }
}

