/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.ui;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import org.openconcerto.erp.core.common.ui.DeviseNiceTableCellRenderer;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.utils.CollectionUtils;

public class ArticleRowValuesRenderer
extends DeviseNiceTableCellRenderer {
    private List<Integer> listColorModeVente;
    private static final Color light = new Color(232, 238, 250);
    private static final Color lightGrey = new Color(211, 220, 222);
    private static final Color darker = new Color(170, 180, 183);
    private static final Color lightBlack = new Color(192, 192, 192);
    private static final Color lightBlackGrey = new Color(155, 155, 155);
    private static final Color lightBlackDarker = new Color(128, 128, 128);

    public ArticleRowValuesRenderer(List<Integer> l) {
        this.listColorModeVente = l;
        AlternateTableCellRenderer.setBGColorMap(this, CollectionUtils.createMap(light, lightGrey, lightBlack, lightBlackGrey));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (table instanceof RowValuesTable) {
            RowValuesTableModel model = ((RowValuesTable)table).getRowValuesTableModel();
            SQLRowValues rowVals = model.getRowValuesAt(row);
            Number mode = (Number)rowVals.getObject("ID_MODE_VENTE_ARTICLE");
            if (mode != null && this.listColorModeVente != null && this.listColorModeVente.contains(mode.intValue())) {
                if (!isSelected) {
                    comp.setBackground(light);
                } else {
                    comp.setBackground(darker);
                }
                return comp;
            }
            if (!model.isCellEditable(row, column)) {
                if (!isSelected) {
                    comp.setBackground(lightBlack);
                } else {
                    comp.setBackground(lightBlackDarker);
                }
                return comp;
            }
        }
        return comp;
    }
}

