/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openconcerto.erp.core.sales.pos.Caisse;
import org.openconcerto.erp.core.sales.pos.io.DefaultTicketPrinter;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Categorie;
import org.openconcerto.erp.core.sales.pos.model.Paiement;
import org.openconcerto.erp.core.sales.pos.model.TicketLine;
import org.openconcerto.erp.core.sales.pos.ui.TicketCellRenderer;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.Pair;

public class Ticket {
    private static boolean inited = false;
    private List<Paiement> paiements = new ArrayList<Paiement>();
    private final List<Pair<Article, Integer>> items = new ArrayList<Pair<Article, Integer>>();
    private Date date;
    private int number;
    private int caisseNumber;

    public static Ticket getTicketFromCode(String code) {
        File file;
        int nA;
        int nM;
        int nJ;
        Calendar c;
        Ticket t;
        block12: {
            StringBuilder b = new StringBuilder();
            int i = 0;
            while (i < code.length()) {
                char c2 = code.charAt(i);
                if (Character.isDigit(c2)) {
                    b.append(c2);
                }
                ++i;
            }
            code = b.toString();
            t = new Ticket(-1);
            c = Calendar.getInstance();
            int nCaisse = Integer.parseInt(code.substring(0, 2));
            nJ = Integer.parseInt(code.substring(2, 4));
            nM = Integer.parseInt(code.substring(4, 6));
            nA = 2000 + Integer.parseInt(code.substring(6, 8));
            int nNumber = Integer.parseInt(code.substring(8, 13));
            c.setTimeInMillis(0L);
            c.set(nA, nM - 1, nJ, 0, 0, 0);
            t.caisseNumber = nCaisse;
            t.date.setTime(c.getTimeInMillis());
            t.number = nNumber;
            File dir = t.getOutputDir();
            file = new File(dir, String.valueOf(code.replace(' ', '_')) + ".xml");
            if (file.exists()) break block12;
            return null;
        }
        try {
            SAXBuilder sxb = new SAXBuilder();
            Document document = sxb.build(file);
            Element root = document.getRootElement();
            String h = root.getAttributeValue("hour");
            String m = root.getAttributeValue("minute");
            c.set(nA, nM - 1, nJ, Integer.parseInt(h), Integer.parseInt(m), 0);
            t.date.setTime(c.getTimeInMillis());
            List children = root.getChildren("article");
            for (Element element : children) {
                int qte = Integer.parseInt(element.getAttributeValue("qte"));
                int prix_unitaire_cents_ht = Integer.parseInt(element.getAttributeValue("prixHT"));
                int idTaxe = Integer.parseInt(element.getAttributeValue("idTaxe"));
                int prix_unitaire_cents = Integer.parseInt(element.getAttributeValue("prix"));
                String categorie = element.getAttributeValue("categorie");
                String name = element.getValue();
                String codebarre = element.getAttributeValue("codebarre");
                String codeArt = element.getAttributeValue("code");
                Categorie cat = new Categorie(categorie);
                Article art = new Article(cat, name);
                art.priceInCents = prix_unitaire_cents;
                art.setCode(codeArt);
                art.setPriceHTInCents(prix_unitaire_cents_ht);
                art.setIdTaxe(idTaxe);
                art.barCode = codebarre;
                Pair<Article, Integer> line = new Pair<Article, Integer>(art, qte);
                t.items.add(line);
            }
            children = root.getChildren("paiement");
            for (Element element : children) {
                String type = element.getAttributeValue("type");
                int montant_cents = Integer.parseInt(element.getAttributeValue("montant"));
                if (montant_cents <= 0) continue;
                int tp = 1;
                if (type.equals("CB")) {
                    tp = 3;
                } else if (type.equals("CHEQUE")) {
                    tp = 2;
                } else if (type.equals("ESPECES")) {
                    tp = 1;
                }
                Paiement p = new Paiement(tp);
                p.setMontantInCents(montant_cents);
                t.paiements.add(p);
            }
        }
        catch (Exception e) {
            System.err.println("Error with ticket code : " + code);
            e.printStackTrace();
            return null;
        }
        return t;
    }

    public Ticket(int caisse) {
        this.caisseNumber = caisse;
        this.date = Calendar.getInstance().getTime();
        this.initNumber();
    }

    private void initNumber() {
        if (!inited) {
            this.number = 1;
            String[] files = this.getCompatibleFileNames();
            int i = 0;
            while (i < files.length) {
                String name = files[i];
                String nb = name.substring(8, 13);
                System.out.println("Found:" + nb);
                int n = Integer.parseInt(nb);
                if (n >= this.number) {
                    this.number = n + 1;
                }
                ++i;
            }
        }
    }

    public String[] getCompatibleFileNames() {
        File dir = this.getOutputDir();
        final String codeStart = this.getPrefixCode();
        String[] files = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(codeStart) && name.endsWith(".xml");
            }
        });
        return files;
    }

    String getPrefixCode() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.date);
        int j = cal.get(5);
        int m = cal.get(2) + 1;
        int a = cal.get(1) - 2000;
        String code = "";
        code = String.valueOf(code) + Ticket.format(2, this.getCaisseNumber());
        code = String.valueOf(code) + Ticket.format(2, j) + Ticket.format(2, m) + Ticket.format(2, a);
        return code;
    }

    public String getCode() {
        String code = this.getPrefixCode();
        code = String.valueOf(code) + Ticket.format(5, this.getNumber());
        return code;
    }

    public int getNumber() {
        return this.number;
    }

    private int getCaisseNumber() {
        return this.caisseNumber;
    }

    public void save() {
        int hour = Calendar.getInstance().get(11);
        int minute = Calendar.getInstance().get(12);
        File dir = this.getOutputDir();
        File f = new File(dir, String.valueOf(this.getCode().replace(' ', '_')) + ".xml");
        Element topLevel = new Element("ticket");
        topLevel.setAttribute(new Attribute("code", this.getCode()));
        topLevel.setAttribute("hour", String.valueOf(hour));
        topLevel.setAttribute("minute", String.valueOf(minute));
        for (Pair<Article, Integer> item : this.items) {
            Element e = new Element("article");
            e.setAttribute("qte", String.valueOf(item.getSecond()));
            e.setAttribute("prix", String.valueOf(item.getFirst().getPriceInCents()));
            e.setAttribute("prixHT", String.valueOf(item.getFirst().getPriceHTInCents()));
            e.setAttribute("idTaxe", String.valueOf(item.getFirst().getIdTaxe()));
            e.setAttribute("categorie", item.getFirst().getCategorie().getName());
            e.setAttribute("codebarre", item.getFirst().getBarCode());
            e.setAttribute("code", item.getFirst().getCode());
            e.setText(item.getFirst().getName());
            topLevel.addContent(e);
        }
        for (Paiement paiement : this.paiements) {
            int montantInCents = paiement.getMontantInCents();
            if (montantInCents <= 0) continue;
            Element e = new Element("paiement");
            String type = "";
            if (paiement.getType() == 3) {
                type = "CB";
            } else if (paiement.getType() == 2) {
                type = "CHEQUE";
            } else if (paiement.getType() == 1) {
                type = "ESPECES";
            }
            e.setAttribute("type", type);
            e.setAttribute("montant", String.valueOf(montantInCents));
            topLevel.addContent(e);
        }
        try {
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            out.output(topLevel, (OutputStream)new FileOutputStream(f));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void print(TicketPrinter prt) {
        int maxWidth = Caisse.getTicketWidth();
        int MAX_PRICE_WIDTH = 8;
        int MAX_QTE_WIDTH = 5;
        List<TicketLine> headers = Caisse.getHeaders();
        for (TicketLine line : headers) {
            prt.addToBuffer(line);
        }
        prt.addToBuffer("");
        SimpleDateFormat df = new SimpleDateFormat("EEEE d MMMM yyyy \u00e0 HH:mm");
        prt.addToBuffer(DefaultTicketPrinter.formatRight(maxWidth, "Le " + df.format(this.getCreationDate())));
        prt.addToBuffer("");
        for (Pair<Article, Integer> item : this.items) {
            prt.addToBuffer(String.valueOf(DefaultTicketPrinter.formatRight(MAX_QTE_WIDTH, String.valueOf(item.getSecond()))) + " " + DefaultTicketPrinter.formatLeft(maxWidth - 2 - MAX_PRICE_WIDTH - MAX_QTE_WIDTH, item.getFirst().getName()) + " " + DefaultTicketPrinter.formatRight(MAX_PRICE_WIDTH, TicketCellRenderer.centsToString(item.getFirst().getPriceInCents())));
        }
        StringBuilder spacer = new StringBuilder();
        int i = 0;
        while (i <= MAX_QTE_WIDTH) {
            spacer.append(' ');
            ++i;
        }
        i = 0;
        while (i < maxWidth - MAX_QTE_WIDTH - 1) {
            spacer.append('=');
            ++i;
        }
        prt.addToBuffer(spacer.toString());
        prt.addToBuffer(String.valueOf(DefaultTicketPrinter.formatRight(maxWidth - 8, "Total")) + DefaultTicketPrinter.formatRight(MAX_PRICE_WIDTH, TicketCellRenderer.centsToString(this.getTotal())), 1);
        prt.addToBuffer("");
        for (Paiement paiement : this.paiements) {
            String type = "";
            if (paiement.getType() == 3) {
                type = "Paiement CB";
            } else if (paiement.getType() == 2) {
                type = "Paiement par ch\u00e8que";
            } else if (paiement.getType() == 1) {
                type = "Paiement en esp\u00e8ces";
            }
            int montantInCents = paiement.getMontantInCents();
            if (montantInCents <= 0) continue;
            type = String.valueOf(type) + " de " + TicketCellRenderer.centsToString(montantInCents);
            type = montantInCents > 100 ? String.valueOf(type) + " euros" : String.valueOf(type) + " euro";
            prt.addToBuffer(type);
        }
        if (this.getTotal() < this.getPaidTotal()) {
            int montantInCents = this.getPaidTotal() - this.getTotal();
            String type = "Rendu : " + TicketCellRenderer.centsToString(montantInCents);
            type = montantInCents > 100 ? String.valueOf(type) + " euros" : String.valueOf(type) + " euro";
            prt.addToBuffer(type);
        }
        prt.addToBuffer("");
        List<TicketLine> footers = Caisse.getFooters();
        for (TicketLine line : footers) {
            prt.addToBuffer(line);
        }
        prt.addToBuffer("");
        prt.addToBuffer(this.getCode(), 10);
        prt.addToBuffer("");
        prt.addToBuffer("Nous utilisons le logiciel OpenConcerto.");
        prt.addToBuffer("Logiciel libre, open source et gratuit!");
        try {
            prt.printBuffer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File getOutputDir() {
        File outputDirDay;
        File outputDirMonth;
        File outputDirYear;
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.date);
        int j = cal.get(5);
        int m = cal.get(2) + 1;
        int a = cal.get(1);
        TemplateNXProps nxprops = (TemplateNXProps)TemplateNXProps.getInstance();
        String defaultLocation = nxprops.getDefaultStringValue();
        File defaultDir = new File(defaultLocation);
        File outputDir = new File(defaultDir, "Tickets");
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        if (!(outputDirYear = new File(outputDir, Ticket.format(4, a))).exists()) {
            outputDirYear.mkdir();
        }
        if (!(outputDirMonth = new File(outputDirYear, Ticket.format(2, m))).exists()) {
            outputDirMonth.mkdir();
        }
        if (!(outputDirDay = new File(outputDirMonth, Ticket.format(2, j))).exists()) {
            outputDirDay.mkdir();
        }
        if (!outputDirDay.exists()) {
            ExceptionHandler.handle("Impossible de cr\u00e9er le dossier des tickets.\n\n" + outputDirDay.getAbsolutePath());
        }
        return outputDirDay;
    }

    public Date getCreationDate() {
        return this.date;
    }

    private static String format(int l, int value) {
        return Ticket.format(l, String.valueOf(value));
    }

    private static String format(int l, String string) {
        if (string.length() > l) {
            string = string.substring(0, l);
        }
        StringBuffer str = new StringBuffer(l);
        int stop = l - string.length();
        int i = 0;
        while (i < stop) {
            str.append('0');
            ++i;
        }
        str.append(string);
        return str.toString();
    }

    public void addPaiement(Paiement p1) {
        this.paiements.add(p1);
    }

    public void addArticle(Article a) {
        boolean alreadyExist = false;
        for (Pair<Article, Integer> line : this.items) {
            if (!line.getFirst().equals(a)) continue;
            alreadyExist = true;
            break;
        }
        if (!alreadyExist) {
            Pair<Article, Integer> line;
            line = new Pair<Article, Integer>(a, 1);
            this.items.add(line);
        }
    }

    public void incrementArticle(Article a) {
        boolean alreadyExist = false;
        for (Pair<Article, Integer> line : this.items) {
            if (!line.getFirst().equals(a)) continue;
            alreadyExist = true;
            line.setSecond(line.getSecond() + 1);
            break;
        }
        if (!alreadyExist) {
            Pair<Article, Integer> line;
            line = new Pair<Article, Integer>(a, 1);
            this.items.add(line);
        }
    }

    public List<Paiement> getPaiements() {
        return this.paiements;
    }

    public int getTotal() {
        int total = 0;
        for (Pair<Article, Integer> line : this.items) {
            int count = line.getSecond();
            int price = line.getFirst().priceInCents;
            total += count * price;
        }
        return total;
    }

    public List<Pair<Article, Integer>> getArticles() {
        return this.items;
    }

    public void clearArticle(Article article) {
        Pair<Article, Integer> toRemove = null;
        for (Pair<Article, Integer> line : this.items) {
            if (!line.getFirst().equals(article)) continue;
            toRemove = line;
            break;
        }
        if (toRemove != null) {
            this.items.remove(toRemove);
        }
    }

    public void setArticleCount(Article article, int count) {
        if (count <= 0) {
            this.clearArticle(article);
            return;
        }
        Pair<Article, Integer> toModify = null;
        for (Pair<Article, Integer> line : this.items) {
            if (!line.getFirst().equals(article)) continue;
            toModify = line;
            break;
        }
        if (toModify != null) {
            toModify.setSecond(count);
        }
    }

    public int getItemCount(Article article) {
        for (Pair<Article, Integer> line : this.items) {
            if (!line.getFirst().equals(article)) continue;
            return line.getSecond();
        }
        return 0;
    }

    public int getPaidTotal() {
        int paid = 0;
        for (Paiement p : this.paiements) {
            paid += p.getMontantInCents();
        }
        return paid;
    }

    public String toString() {
        return "Ticket " + this.getCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Ticket) {
            Ticket t = (Ticket)obj;
            return t.getCode().equals(this.getCode());
        }
        return false;
    }

    public int hashCode() {
        return this.getCode().hashCode();
    }

    public void deleteTicket() {
        File dir = this.getOutputDir();
        String name = String.valueOf(this.getCode().replace(' ', '_')) + ".xml";
        File f = new File(dir, name);
        f.renameTo(new File(dir, String.valueOf(name) + "_deleted"));
    }
}

