/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.element;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.TreePath;
import org.openconcerto.erp.core.common.ui.SQLJavaEditor;
import org.openconcerto.erp.core.humanresources.payroll.component.FormuleTreeNode;
import org.openconcerto.erp.core.humanresources.payroll.component.VariableTree;
import org.openconcerto.erp.core.humanresources.payroll.element.RubriqueSQLComponent;
import org.openconcerto.erp.core.humanresources.payroll.element.SalarieSQLElement;
import org.openconcerto.erp.core.humanresources.payroll.element.VariablePayeSQLElement;
import org.openconcerto.sql.element.ConfSQLElement;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class RubriqueCommSQLElement
extends ConfSQLElement {
    public RubriqueCommSQLElement() {
        super("RUBRIQUE_COMM", "une rubrique de commentaire", "rubriques de commentaire");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        return l;
    }

    @Override
    protected List<String> getPrivateFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_PERIODE_VALIDITE");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new RubriqueSQLComponent(this){
            private SQLJavaEditor formuleBase;
            private SQLJavaEditor formuleTxSal;
            private SQLJavaEditor formuleTxPat;
            private SQLJavaEditor formuleMontantSalAd;
            private SQLJavaEditor formuleMontantSalDed;
            private SQLJavaEditor formuleMontantPat;

            @Override
            protected boolean newline() {
                return false;
            }

            @Override
            protected void addViews(GridBagConstraints c) {
                JCheckBox checkAffichNom = new JCheckBox(this.getLabelFor("NOM_VISIBLE"));
                ++c.gridx;
                c.gridwidth = 1;
                c.weightx = 0.0;
                this.add((Component)checkAffichNom, c);
                checkAffichNom.setSelected(true);
                JPanel panelCalcul = new JPanel();
                panelCalcul.setLayout(new GridBagLayout());
                DefaultGridBagConstraints cPanel = new DefaultGridBagConstraints();
                final VariableTree tree = new VariableTree();
                JScrollPane paneTree = new JScrollPane(tree);
                cPanel.gridheight = 0;
                cPanel.weighty = 1.0;
                cPanel.weightx = 1.0;
                cPanel.fill = 1;
                cPanel.fill = 2;
                cPanel.weighty = 0.0;
                cPanel.weightx = 0.0;
                cPanel.gridheight = 1;
                ++cPanel.gridx;
                Map<String, List<?>> mapTree = VariablePayeSQLElement.getMapTree();
                this.formuleBase = new SQLJavaEditor(mapTree);
                this.formuleBase.setVarAssign("BASE");
                final JRadioButton radioBase = new JRadioButton(this.getLabelFor("NB_BASE"));
                panelCalcul.add((Component)radioBase, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)((Object)this.formuleBase), cPanel);
                ++cPanel.gridy;
                cPanel.gridx = 1;
                this.formuleTxSal = new SQLJavaEditor(mapTree);
                this.formuleTxSal.setVarAssign("SAL");
                JRadioButton radioTxSal = new JRadioButton(this.getLabelFor("TAUX_SAL"));
                panelCalcul.add((Component)radioTxSal, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)((Object)this.formuleTxSal), cPanel);
                ++cPanel.gridy;
                cPanel.gridx = 1;
                this.formuleMontantSalAd = new SQLJavaEditor(mapTree);
                this.formuleMontantSalAd.setVarAssign("MONTANT");
                final JRadioButton radioMontantsalAd = new JRadioButton(this.getLabelFor("MONTANT_SAL_AJ"));
                panelCalcul.add((Component)radioMontantsalAd, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)((Object)this.formuleMontantSalAd), cPanel);
                ++cPanel.gridy;
                cPanel.gridx = 1;
                this.formuleMontantSalDed = new SQLJavaEditor(mapTree);
                this.formuleMontantSalDed.setVarAssign("MONTANT");
                final JRadioButton radioMontantSalDed = new JRadioButton(this.getLabelFor("MONTANT_SAL_DED"));
                panelCalcul.add((Component)radioMontantSalDed, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)((Object)this.formuleMontantSalDed), cPanel);
                ++cPanel.gridy;
                cPanel.gridx = 1;
                this.formuleTxPat = new SQLJavaEditor(mapTree);
                this.formuleTxPat.setVarAssign("PAT");
                final JRadioButton radioTxPat = new JRadioButton(this.getLabelFor("TAUX_PAT"));
                panelCalcul.add((Component)radioTxPat, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)((Object)this.formuleTxPat), cPanel);
                ++cPanel.gridy;
                cPanel.gridx = 1;
                this.formuleMontantPat = new SQLJavaEditor(mapTree);
                this.formuleMontantPat.setVarAssign("MONTANT");
                final JRadioButton radioMontantPat = new JRadioButton(this.getLabelFor("MONTANT_PAT"));
                panelCalcul.add((Component)radioMontantPat, cPanel);
                ++cPanel.gridx;
                panelCalcul.add((Component)((Object)this.formuleMontantPat), cPanel);
                ButtonGroup group1 = new ButtonGroup();
                group1.add(radioBase);
                group1.add(radioTxPat);
                group1.add(radioTxSal);
                group1.add(radioMontantPat);
                group1.add(radioMontantsalAd);
                group1.add(radioMontantSalDed);
                radioBase.setSelected(true);
                ++cPanel.gridy;
                cPanel.gridx = 1;
                JLabel labelSelSal = new JLabel("Salari\u00e9");
                labelSelSal.setHorizontalAlignment(4);
                panelCalcul.add((Component)labelSelSal, cPanel);
                SalarieSQLElement eltSal = new SalarieSQLElement();
                final ElementComboBox selSalarie = new ElementComboBox(false);
                ++cPanel.gridx;
                selSalarie.init(eltSal);
                panelCalcul.add((Component)selSalarie, cPanel);
                JPanel panelProp = new JPanel();
                panelProp.setLayout(new GridBagLayout());
                cPanel.gridx = 0;
                cPanel.gridy = 0;
                cPanel.weightx = 0.0;
                cPanel.weighty = 0.0;
                cPanel.gridwidth = 1;
                cPanel.gridheight = 1;
                cPanel.fill = 2;
                cPanel.anchor = 18;
                cPanel.insets = new Insets(2, 2, 1, 2);
                this.addView("ID_PERIODE_VALIDITE", "required;notdecorated;noseparator");
                ElementSQLObject eltInfosPaye = (ElementSQLObject)this.getView("ID_PERIODE_VALIDITE");
                cPanel.gridy = 0;
                cPanel.gridx = 0;
                cPanel.gridheight = 0;
                JPanel panelPeriodeVal = new JPanel();
                panelPeriodeVal.setBorder(BorderFactory.createTitledBorder("P\u00e9riode de validit\u00e9"));
                panelPeriodeVal.add(eltInfosPaye);
                cPanel.fill = 0;
                cPanel.weightx = 0.0;
                cPanel.weighty = 1.0;
                panelProp.add((Component)panelPeriodeVal, cPanel);
                cPanel.weightx = 0.0;
                cPanel.weighty = 0.0;
                cPanel.gridheight = 1;
                cPanel.fill = 2;
                JLabel labelSelTypeImpression = new JLabel("Impression");
                ++cPanel.gridy;
                cPanel.gridx = 1;
                cPanel.weightx = 0.0;
                panelProp.add((Component)labelSelTypeImpression, cPanel);
                ElementComboBox comboSelTypeImpression = new ElementComboBox(false);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelProp.add((Component)comboSelTypeImpression, cPanel);
                JTabbedPane tab = new JTabbedPane();
                tab.add("Calcul", new JSplitPane(1, paneTree, panelCalcul));
                tab.add("Propri\u00e9t\u00e9s", panelProp);
                c.gridwidth = 0;
                ++c.gridy;
                c.gridx = 0;
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.add((Component)tab, c);
                tree.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (e.getClickCount() == 2 && e.getButton() == 1) {
                            TreePath path = tree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y);
                            Object obj = path.getLastPathComponent();
                            if (obj == null) {
                                return;
                            }
                            if (obj instanceof FormuleTreeNode) {
                                FormuleTreeNode n = (FormuleTreeNode)obj;
                                if (radioBase.isSelected()) {
                                    int start = formuleBase.getSelectionStart();
                                    String tmp = formuleBase.getText();
                                    formuleBase.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                                } else if (radioTxPat.isSelected()) {
                                    int start = formuleTxPat.getSelectionStart();
                                    String tmp = formuleTxPat.getText();
                                    formuleTxPat.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                                } else if (radioMontantPat.isSelected()) {
                                    int start = formuleMontantPat.getSelectionStart();
                                    String tmp = formuleMontantPat.getText();
                                    formuleMontantPat.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                                } else if (radioMontantsalAd.isSelected()) {
                                    int start = formuleMontantSalAd.getSelectionStart();
                                    String tmp = formuleMontantSalAd.getText();
                                    formuleMontantSalAd.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                                } else if (radioMontantSalDed.isSelected()) {
                                    int start = formuleMontantSalDed.getSelectionStart();
                                    String tmp = formuleMontantSalDed.getText();
                                    formuleMontantSalDed.setText(String.valueOf(tmp.substring(0, start)) + n.getTextValue() + tmp.substring(start, tmp.length()));
                                }
                            }
                        }
                    }
                });
                this.addSQLObject((JComponent)((Object)this.formuleBase), "NB_BASE");
                this.addSQLObject((JComponent)((Object)this.formuleTxPat), "TAUX_PAT");
                this.addSQLObject((JComponent)((Object)this.formuleTxSal), "TAUX_SAL");
                this.addSQLObject((JComponent)((Object)this.formuleMontantPat), "MONTANT_PAT");
                this.addSQLObject((JComponent)((Object)this.formuleMontantSalAd), "MONTANT_SAL_AJ");
                this.addSQLObject((JComponent)((Object)this.formuleMontantSalDed), "MONTANT_SAL_DED");
                this.addRequiredSQLObject(comboSelTypeImpression, "ID_IMPRESSION_RUBRIQUE");
                this.addRequiredSQLObject(checkAffichNom, "NOM_VISIBLE");
                selSalarie.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        formuleBase.setSalarieID(selSalarie.getSelectedId());
                        formuleTxPat.setSalarieID(selSalarie.getSelectedId());
                        formuleTxSal.setSalarieID(selSalarie.getSelectedId());
                        formuleMontantPat.setSalarieID(selSalarie.getSelectedId());
                        formuleMontantSalAd.setSalarieID(selSalarie.getSelectedId());
                        formuleMontantSalDed.setSalarieID(selSalarie.getSelectedId());
                    }
                });
            }
        };
    }
}

