/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;

public class InfosSalariePayeSQLElement
extends ComptaSQLConfElement {
    public InfosSalariePayeSQLElement() {
        super("INFOS_SALARIE_PAYE", "des informations salari\u00e9-paye", "informations salari\u00e9s-payes");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_IDCC");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_IDCC");
        return l;
    }

    @Override
    protected List<String> getPrivateFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_CONTRAT_SALARIE");
        l.add("ID_CLASSEMENT_CONVENTIONNEL");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private JTextField dureeMois;
            private JTextField dureeHebdo;
            private DocumentListener listenerMois;
            private DocumentListener listenerHebdo;
            {
                this.listenerMois = new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.updateHebdo();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.updateHebdo();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.updateHebdo();
                    }
                };
                this.listenerHebdo = new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.updateMois();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.updateMois();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.updateMois();
                    }
                };
            }

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelConvention = new JLabel(this.getLabelFor("ID_IDCC"));
                labelConvention.setHorizontalAlignment(4);
                ElementComboBox comboConvention = new ElementComboBox();
                this.add((Component)labelConvention, c);
                ++c.gridx;
                c.gridwidth = 0;
                c.weightx = 1.0;
                this.add((Component)comboConvention, c);
                c.gridwidth = 1;
                c.fill = 1;
                JPanel panelClassement = new JPanel();
                panelClassement.setOpaque(false);
                panelClassement.setBorder(BorderFactory.createTitledBorder("Classement conventionnel"));
                panelClassement.setLayout(new GridBagLayout());
                this.addView("ID_CLASSEMENT_CONVENTIONNEL", "required;notdecorated;noseparator");
                ElementSQLObject eltClassement = (ElementSQLObject)this.getView("ID_CLASSEMENT_CONVENTIONNEL");
                c.gridx = 0;
                c.gridy = 0;
                c.weightx = 1.0;
                panelClassement.add((Component)eltClassement, c);
                c.gridy = 1;
                c.gridx = 0;
                c.gridwidth = 2;
                c.weightx = 0.0;
                this.add((Component)panelClassement, c);
                c.gridwidth = 1;
                c.fill = 1;
                JPanel panelContrat = new JPanel();
                panelContrat.setOpaque(false);
                panelContrat.setBorder(BorderFactory.createTitledBorder("Contrat de travail"));
                panelContrat.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
                c2.fill = 2;
                c2.weighty = 1.0;
                c2.weightx = 1.0;
                c2.anchor = 11;
                this.addView("ID_CONTRAT_SALARIE", "required;notdecorated;noseparator");
                ElementSQLObject eltContrat = (ElementSQLObject)this.getView("ID_CONTRAT_SALARIE");
                panelContrat.add((Component)eltContrat, c2);
                c.gridx = 2;
                c.gridy = 1;
                c.gridheight = 2;
                c.gridwidth = 0;
                c.weightx = 1.0;
                this.add((Component)panelContrat, c);
                c.gridwidth = 1;
                c.gridheight = 1;
                JPanel panelEntreeSortie = new JPanel();
                panelEntreeSortie.setOpaque(false);
                panelEntreeSortie.setBorder(BorderFactory.createTitledBorder("Entr\u00e9e/Sortie"));
                panelEntreeSortie.setLayout(new GridBagLayout());
                JLabel labelDateArrive = new JLabel(this.getLabelFor("DATE_ARRIVE"));
                labelDateArrive.setHorizontalAlignment(4);
                JDate dateArrive = new JDate(true);
                c.gridy = 0;
                c.gridx = 0;
                c.weightx = 0.0;
                c.fill = 2;
                panelEntreeSortie.add((Component)labelDateArrive, c);
                ++c.gridx;
                panelEntreeSortie.add((Component)((Object)dateArrive), c);
                JLabel labelDateSortie = new JLabel(this.getLabelFor("DATE_SORTIE"));
                labelDateSortie.setHorizontalAlignment(4);
                JDate dateSortie = new JDate();
                ++c.gridy;
                c.gridx = 0;
                c.fill = 2;
                panelEntreeSortie.add((Component)labelDateSortie, c);
                ++c.gridx;
                panelEntreeSortie.add((Component)((Object)dateSortie), c);
                c.gridx = 0;
                c.gridy = 2;
                c.gridwidth = 2;
                this.add((Component)panelEntreeSortie, c);
                c.gridwidth = 1;
                JPanel panelBase = new JPanel();
                panelBase.setOpaque(false);
                panelBase.setBorder(BorderFactory.createTitledBorder("Valeurs de base"));
                panelBase.setLayout(new GridBagLayout());
                JLabel labelDureeMois = new JLabel(this.getLabelFor("DUREE_MOIS"));
                labelDureeMois.setHorizontalAlignment(4);
                this.dureeMois = new JTextField();
                c.gridy = 0;
                c.gridx = 0;
                c.gridheight = 1;
                c.fill = 2;
                panelBase.add((Component)labelDureeMois, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelBase.add((Component)this.dureeMois, c);
                JLabel labelDureeHebdo = new JLabel(this.getLabelFor("DUREE_HEBDO"));
                labelDureeHebdo.setHorizontalAlignment(4);
                this.dureeHebdo = new JTextField();
                ++c.gridx;
                c.weightx = 0.0;
                panelBase.add((Component)labelDureeHebdo, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelBase.add((Component)this.dureeHebdo, c);
                JLabel labelSalaireBase = new JLabel(this.getLabelFor("SALAIRE_MOIS"));
                labelSalaireBase.setHorizontalAlignment(4);
                JTextField salaireBase = new JTextField();
                ++c.gridx;
                c.weightx = 0.0;
                panelBase.add((Component)labelSalaireBase, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelBase.add((Component)salaireBase, c);
                JLabel labelTauxAT = new JLabel(this.getLabelFor("TAUX_AT"));
                labelTauxAT.setHorizontalAlignment(4);
                JTextField tauxAT = new JTextField();
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                panelBase.add((Component)labelTauxAT, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelBase.add((Component)tauxAT, c);
                JLabel labelConges = new JLabel(this.getLabelFor("CONGES_PAYES"));
                labelConges.setHorizontalAlignment(4);
                JTextField conges = new JTextField();
                ++c.gridx;
                c.weightx = 0.0;
                panelBase.add((Component)labelConges, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelBase.add((Component)conges, c);
                JLabel labelCodeAT = new JLabel(this.getLabelFor("CODE_AT"));
                labelCodeAT.setHorizontalAlignment(4);
                JTextField CodeAT = new JTextField();
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                panelBase.add((Component)labelCodeAT, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelBase.add((Component)CodeAT, c);
                this.addView(CodeAT, "CODE_AT");
                JLabel labelSectionAT = new JLabel(this.getLabelFor("CODE_SECTION_AT"));
                labelSectionAT.setHorizontalAlignment(4);
                JTextField sectionAT = new JTextField();
                ++c.gridx;
                c.weightx = 0.0;
                panelBase.add((Component)labelSectionAT, c);
                ++c.gridx;
                c.weightx = 1.0;
                panelBase.add((Component)sectionAT, c);
                this.addView(sectionAT, "CODE_SECTION_AT");
                c.gridy = 3;
                c.gridx = 0;
                c.gridwidth = 0;
                c.weighty = 1.0;
                c.weightx = 1.0;
                c.anchor = 18;
                this.add((Component)panelBase, c);
                this.addRequiredSQLObject(comboConvention, "ID_IDCC");
                this.addRequiredSQLObject((JComponent)((Object)dateArrive), "DATE_ARRIVE");
                this.addSQLObject((JComponent)((Object)dateSortie), "DATE_SORTIE");
                this.addRequiredSQLObject(this.dureeHebdo, "DUREE_HEBDO");
                this.addRequiredSQLObject(this.dureeMois, "DUREE_MOIS");
                this.addRequiredSQLObject(tauxAT, "TAUX_AT");
                this.addRequiredSQLObject(conges, "CONGES_PAYES");
                this.addRequiredSQLObject(salaireBase, "SALAIRE_MOIS");
                this.dureeMois.getDocument().addDocumentListener(this.listenerMois);
                this.dureeHebdo.getDocument().addDocumentListener(this.listenerHebdo);
            }

            private void updateHebdo() {
                if (this.dureeMois.getText().trim().length() == 0) {
                    return;
                }
                this.dureeHebdo.getDocument().removeDocumentListener(this.listenerHebdo);
                this.dureeHebdo.setText(String.valueOf(new PrixHT((double)Float.parseFloat(this.dureeMois.getText()) / 4.333333333333333).getValue()));
                this.dureeHebdo.getDocument().addDocumentListener(this.listenerHebdo);
            }

            private void updateMois() {
                if (this.dureeHebdo.getText().trim().length() == 0) {
                    return;
                }
                this.dureeMois.getDocument().removeDocumentListener(this.listenerMois);
                this.dureeMois.setText(String.valueOf(new PrixHT((double)Float.parseFloat(this.dureeHebdo.getText()) * 4.333333333333333).getValue()));
                this.dureeMois.getDocument().addDocumentListener(this.listenerMois);
            }

            @Override
            public void select(SQLRowAccessor r) {
                this.dureeMois.getDocument().removeDocumentListener(this.listenerMois);
                this.dureeHebdo.getDocument().removeDocumentListener(this.listenerHebdo);
                super.select(r);
                this.dureeMois.getDocument().addDocumentListener(this.listenerMois);
                this.dureeHebdo.getDocument().addDocumentListener(this.listenerHebdo);
            }
        };
    }
}

