/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.warning.JLabelWarning;
import org.openconcerto.utils.ExceptionHandler;

public class SuppressionEcrituresPanel
extends JPanel {
    public SuppressionEcrituresPanel(final int idMvt) {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableMouvement = base.getTable("MOUVEMENT");
        SQLRow rowMvt = tableMouvement.getRow(idMvt);
        JLabel label = new JLabel("Vous allez supprimer la pi\u00e9ce n\u00b0" + rowMvt.getInt("ID_PIECE"));
        JLabelWarning warning = new JLabelWarning();
        JPanel panelLabel = new JPanel();
        panelLabel.add(warning);
        panelLabel.add(label);
        c.gridwidth = 0;
        this.add((Component)panelLabel, c);
        int[] idS = this.getMouvement(rowMvt.getInt("ID_PIECE"));
        if (idS == null) {
            ExceptionHandler.handle("Aucun mouvement associ\u00e9 \u00e0 la pi\u00e9ce n\u00b0" + (rowMvt != null ? Integer.valueOf(rowMvt.getInt("ID_PIECE")) : "mouvement nul"));
        } else {
            StringBuffer s = new StringBuffer();
            s.append("Elle est compos\u00e9e par les mouvements : (");
            JLabel labelMouv = new JLabel();
            ++c.gridy;
            c.gridx = 0;
            this.add((Component)labelMouv, c);
            s.append(idS[0]);
            int i = 1;
            while (i < idS.length) {
                s.append(", ");
                s.append(idS[i]);
                ++i;
            }
            s.append(')');
            labelMouv.setText(s.toString());
        }
        JButton buttonOK = new JButton("OK");
        JButton buttonCancel = new JButton("Annuler");
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)buttonOK, c);
        ++c.gridx;
        this.add((Component)buttonCancel, c);
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EcritureSQLElement elt = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement("ECRITURE");
                elt.archiveMouvement(idMvt);
                ((JFrame)SwingUtilities.getRoot(SuppressionEcrituresPanel.this)).dispose();
            }
        });
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(SuppressionEcrituresPanel.this)).dispose();
            }
        });
    }

    private int[] getMouvement(int idPiece) {
        int[] idS = null;
        SQLBase b = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableMvt = b.getTable("MOUVEMENT");
        SQLSelect sel = new SQLSelect(b);
        sel.addSelect(tableMvt.getField("NUMERO"));
        sel.setWhere("MOUVEMENT.ID_PIECE", "=", idPiece);
        List l = (List)b.getDataSource().execute(sel.asString(), new ArrayListHandler());
        if (l.size() > 0) {
            idS = new int[l.size()];
        }
        int i = 0;
        while (i < l.size()) {
            Object[] tmp = (Object[])l.get(i);
            idS[i] = Integer.parseInt(tmp[0].toString());
            ++i;
        }
        return idS;
    }
}

