/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.accounting.element.SaisieKmSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class MouvementSQLElement
extends ComptaSQLConfElement {
    public MouvementSQLElement() {
        super("MOUVEMENT", "un mouvement", "mouvements");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> list = new ArrayList<String>(3);
        list.add("NUMERO");
        list.add("ID_PIECE");
        list.add("SOURCE");
        return list;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("ID_PIECE");
        return list;
    }

    @Override
    protected Set<String> getChildren() {
        HashSet<String> set = new HashSet<String>(1);
        set.add("ECRITURE");
        return set;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                JLabel labelSource = new JLabel("Source ");
                this.add((Component)labelSource, c);
                ++c.gridx;
                JTextField source = new JTextField();
                this.add((Component)source, c);
                this.addSQLObject(source, "SOURCE");
            }
        };
    }

    @Override
    protected void archive(SQLRow row, boolean cutLinks) throws SQLException {
        if (MouvementSQLElement.isEditable(row.getID())) {
            super.archive(row, cutLinks);
            String source = row.getString("SOURCE");
            int idSource = row.getInt("IDSOURCE");
            if (source.trim().length() > 0 && idSource > 1) {
                Configuration.getInstance().getDirectory().getElement(source).archive(idSource);
            }
        } else {
            System.err.println("impossible d'arichiver le mouvement d'id [" + row.getID() + "] car il est valid\u00e9.");
        }
    }

    public static final int getSourceId(int idMvt) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableMvt = base.getTable("MOUVEMENT");
        SQLRow row = tableMvt.getRow(idMvt);
        if (row.getInt("ID_MOUVEMENT_PERE") != 1) {
            return MouvementSQLElement.getSourceId(row.getInt("ID_MOUVEMENT_PERE"));
        }
        return idMvt;
    }

    public static final void showSource(int idMvt) {
        int id = MouvementSQLElement.getSourceId(idMvt);
        if (id != 1) {
            EditFrame f;
            int mode;
            SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
            SQLTable tableMvt = base.getTable("MOUVEMENT");
            String stringTableSource = tableMvt.getRow(id).getString("SOURCE").trim();
            int n = mode = MouvementSQLElement.isEditable(id) ? 1 : 2;
            if (stringTableSource.length() != 0 && tableMvt.getRow(id).getInt("IDSOURCE") != 1) {
                if (mode == 1) {
                    f = new EditFrame(Configuration.getInstance().getDirectory().getElement(stringTableSource), EditPanel.MODIFICATION);
                    f.getPanel().disableDelete();
                } else {
                    f = new EditFrame(Configuration.getInstance().getDirectory().getElement(stringTableSource), EditPanel.READONLY);
                }
                f.selectionId(tableMvt.getRow(id).getInt("IDSOURCE"));
            } else {
                f = mode == 1 ? new EditFrame(new SaisieKmSQLElement(), EditPanel.MODIFICATION) : new EditFrame(new SaisieKmSQLElement(), EditPanel.READONLY);
                f.selectionId(SaisieKmSQLElement.createSaisie(id));
            }
            f.pack();
            f.setVisible(true);
        } else {
            System.err.println("Aucun mouvement associ\u00e9, impossible de modifier ou d'acc\u00e9der \u00e0 la source de cette ecriture!");
        }
    }

    public static final boolean isEditable(int idMvt) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableEcriture = base.getTable("ECRITURE");
        SQLSelect sel = new SQLSelect(base);
        sel.addSelect(tableEcriture.getField("VALIDE"));
        Where w = new Where((FieldRef)tableEcriture.getField("ID_MOUVEMENT"), "=", idMvt);
        sel.setWhere(w);
        String req = sel.asString();
        Object ob = base.getDataSource().execute(req, new ArrayListHandler());
        List myList = (List)ob;
        int size = myList.size();
        int i = 0;
        while (i < size) {
            Object[] objTmp = (Object[])myList.get(i);
            if (((Boolean)objTmp[0]).booleanValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

