/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

public class ValueShort
extends Value {
    private final short value;

    private ValueShort(short s) {
        this.value = s;
    }

    public Value add(Value value) {
        ValueShort valueShort = (ValueShort)value;
        return this.checkRange(this.value + valueShort.value);
    }

    private ValueShort checkRange(int n) {
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw DbException.get(90110, DataType.getDataType((int)3).name);
        }
        return ValueShort.get((short)n);
    }

    public int getSignum() {
        return Integer.signum(this.value);
    }

    public Value negate() {
        return this.checkRange(-this.value);
    }

    public Value subtract(Value value) {
        ValueShort valueShort = (ValueShort)value;
        return this.checkRange(this.value - valueShort.value);
    }

    public Value multiply(Value value) {
        ValueShort valueShort = (ValueShort)value;
        return this.checkRange(this.value * valueShort.value);
    }

    public Value divide(Value value) {
        ValueShort valueShort = (ValueShort)value;
        if (valueShort.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueShort.get((short)(this.value / valueShort.value));
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 3;
    }

    public short getShort() {
        return this.value;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueShort valueShort = (ValueShort)value;
        return MathUtils.compareInt(this.value, valueShort.value);
    }

    public String getString() {
        return String.valueOf(this.value);
    }

    public long getPrecision() {
        return 5L;
    }

    public int hashCode() {
        return this.value;
    }

    public Object getObject() {
        return this.value;
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setShort(n, this.value);
    }

    public static ValueShort get(short s) {
        return (ValueShort)Value.cache(new ValueShort(s));
    }

    public int getDisplaySize() {
        return 6;
    }

    public boolean equals(Object object) {
        return object instanceof ValueShort && this.value == ((ValueShort)object).value;
    }
}

