/*
 * Decompiled with CFR 0.152.
 */
package jpos.loader.simple;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceInstance;
import jpos.loader.JposServiceInstanceFactory;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public class SimpleServiceConnection
implements JposServiceConnection {
    private static Hashtable siFactoryTable = new Hashtable();
    private JposServiceInstance service = null;
    private JposEntry entry = null;
    private String logicalName = null;
    private String siFactoryClassName = null;
    private Tracer tracer = TracerFactory.getInstance().createTracer("SimpleServiceConnection");

    SimpleServiceConnection(String string, JposEntry jposEntry, String string2) {
        this.logicalName = string;
        this.entry = jposEntry;
        this.siFactoryClassName = string2;
    }

    public JposServiceInstance getService() {
        return this.service;
    }

    public void connect() throws JposException {
        try {
            Class[] classArray = new Class[]{Class.forName("java.lang.String"), Class.forName("jpos.config.JposEntry")};
            JposServiceInstanceFactory jposServiceInstanceFactory = null;
            if (siFactoryTable.containsKey(this.siFactoryClassName)) {
                jposServiceInstanceFactory = (JposServiceInstanceFactory)siFactoryTable.get(this.siFactoryClassName);
            } else {
                Class<?> clazz = Class.forName(this.siFactoryClassName);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                jposServiceInstanceFactory = (JposServiceInstanceFactory)constructor.newInstance(new Object[0]);
                siFactoryTable.put(this.siFactoryClassName, jposServiceInstanceFactory);
            }
            this.service = jposServiceInstanceFactory.createInstance(this.logicalName, this.entry);
        }
        catch (Exception exception) {
            String string = "Could not connect to service with logicalName = " + this.logicalName + ": Exception.message=" + exception.getMessage();
            this.tracer.println(string);
            throw new JposException(104, string, exception);
        }
    }

    public void disconnect() throws JposException {
        if (this.service != null) {
            this.service.deleteInstance();
            this.service = null;
        }
        this.tracer.println("Disconnected to service OK");
    }

    protected void finalize() throws JposException {
        this.disconnect();
    }
}

