/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;

public class PEMImporter {
    public static SSLServerSocketFactory createSSLFactory(File privateKeyPem, File certificatePem, String password) throws IOException, GeneralSecurityException {
        SSLContext context = SSLContext.getInstance("TLS");
        KeyStore keystore = PEMImporter.createKeyStore(privateKeyPem, certificatePem, password);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keystore, password.toCharArray());
        KeyManager[] km = kmf.getKeyManagers();
        context.init(km, null, null);
        return context.getServerSocketFactory();
    }

    public static KeyStore createKeyStore(File privateKeyPem, File certificatePem, String password) throws IOException, GeneralSecurityException {
        if (!privateKeyPem.exists()) {
            throw new IllegalArgumentException("private key file missing : " + privateKeyPem.getAbsolutePath());
        }
        if (!certificatePem.exists()) {
            throw new IllegalArgumentException("certificate file missing : " + certificatePem.getAbsolutePath());
        }
        Certificate[] cert = PEMImporter.createCertificates(certificatePem);
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null);
        PrivateKey key = PEMImporter.createPrivateKey(privateKeyPem);
        keystore.setKeyEntry(privateKeyPem.getName(), key, password.toCharArray(), cert);
        return keystore;
    }

    private static PrivateKey createPrivateKey(File privateKeyPem) throws IOException, GeneralSecurityException {
        BufferedReader r = new BufferedReader(new FileReader(privateKeyPem));
        String s = r.readLine();
        if (s == null || !s.contains("BEGIN PRIVATE KEY")) {
            r.close();
            throw new IllegalArgumentException("No PRIVATE KEY found");
        }
        StringBuilder b = new StringBuilder();
        s = "";
        while (s != null) {
            if (s.contains("END PRIVATE KEY")) break;
            b.append(s);
            s = r.readLine();
        }
        r.close();
        String hexString = b.toString();
        byte[] bytes = Base64.getMimeDecoder().decode(hexString);
        return PEMImporter.generatePrivateKeyFromDER(bytes);
    }

    private static X509Certificate[] createCertificates(File certificatePem) throws IOException, CertificateException {
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        BufferedReader r = new BufferedReader(new FileReader(certificatePem));
        String s = r.readLine();
        if (s == null || !s.contains("BEGIN CERTIFICATE")) {
            r.close();
            throw new IllegalArgumentException("No CERTIFICATE found");
        }
        StringBuilder b = new StringBuilder();
        while (s != null) {
            if (s.contains("END CERTIFICATE")) {
                String hexString = b.toString();
                byte[] bytes = Base64.getMimeDecoder().decode(hexString);
                X509Certificate cert = PEMImporter.generateCertificateFromDER(bytes);
                result.add(cert);
                b = new StringBuilder();
            } else if (!s.startsWith("----")) {
                b.append(s);
            }
            s = r.readLine();
        }
        r.close();
        return result.toArray(new X509Certificate[result.size()]);
    }

    private static RSAPrivateKey generatePrivateKeyFromDER(byte[] keyBytes) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)factory.generatePrivate(spec);
    }

    private static X509Certificate generateCertificateFromDER(byte[] certBytes) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certBytes));
    }
}

