/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.util.Arrays;
import java.util.List;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.UISQLComponent;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.ListMap;

public class RightSQLElement
extends SQLElement {
    public static final String TABLE_NAME = "RIGHT";

    public static SQLCreateTable getCreateTable(DBRoot root) {
        SQLCreateTable res = new SQLCreateTable(root, TABLE_NAME);
        res.addVarCharColumn("CODE", 128);
        res.addVarCharColumn("NOM", 256);
        res.addVarCharColumn("DESCRIPTION", 500);
        return res;
    }

    public RightSQLElement(DBRoot root) {
        super(root.findTable(TABLE_NAME), null, "sql.right");
    }

    @Override
    public boolean isShared() {
        return true;
    }

    @Override
    protected List<String> getListFields() {
        return Arrays.asList("CODE", "NOM", "DESCRIPTION");
    }

    @Override
    protected List<String> getComboFields() {
        return Arrays.asList("NOM");
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, "NOM");
    }

    @Override
    public SQLComponent createComponent() {
        return new UISQLComponent(this, 2, 1){

            @Override
            public void addViews() {
                this.addView("CODE");
                this.addView("NOM");
                this.addView(new ITextArea(), "DESCRIPTION", (Object)"2");
            }
        };
    }
}

