/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.openconcerto.erp.core.sales.product.component.BatchSelectorFrame;
import org.openconcerto.erp.core.sales.product.ui.QtyRowValuesRenderer;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;

public class DeliveryNoteQtyRowValuesRenderer
extends QtyRowValuesRenderer {
    private final ImageIcon iOk = new ImageIcon(BatchSelectorFrame.class.getResource("batch.png"));
    private final ImageIcon iError = new ImageIcon(BatchSelectorFrame.class.getResource("batch_error.png"));

    public DeliveryNoteQtyRowValuesRenderer() {
        super(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (table instanceof RowValuesTable) {
            RowValuesTable rowValuesTable = (RowValuesTable)table;
            JLabel text = (JLabel)comp;
            RowValuesTableModel model = rowValuesTable.getRowValuesTableModel();
            SQLRowValues rowValsBonLivraisonItem = model.getRowValuesAt(row);
            List<String> batchField = Arrays.asList("DLC_REQUIS", "DLUO_REQUIS", "NUMERO_LOT_REQUIS", "NUMERO_SERIE_REQUIS");
            boolean productRequireBatch = false;
            SQLRowAccessor foreign = rowValsBonLivraisonItem.getNonEmptyForeign("ID_ARTICLE");
            if (foreign != null) {
                for (String field : batchField) {
                    if (!foreign.getBoolean(field).booleanValue()) continue;
                    productRequireBatch = true;
                    break;
                }
            }
            if (productRequireBatch) {
                Collection<SQLRowValues> referentRows = rowValsBonLivraisonItem.getReferentRows(rowValsBonLivraisonItem.getTable().getTable("LOT_LIVRAISON"));
                boolean batchMissing = referentRows.isEmpty();
                JLabel label = new JLabel(" ");
                if (batchMissing) {
                    label.setIcon(this.iError);
                } else {
                    label.setIcon(this.iOk);
                }
                JPanel p = new JPanel();
                p.setLayout(new BorderLayout());
                p.add((Component)text, "Center");
                p.add((Component)label, "West");
                p.setBackground(text.getBackground());
                label.setOpaque(false);
                return p;
            }
        }
        return comp;
    }
}

