/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.GestionDevise;

public class RepartitionAnalytiqueSheetXML
extends AbstractListeSheetXml {
    protected static final SQLTable tableAssoc = base.getTable("ASSOCIATION_ANALYTIQUE");
    protected static final SQLTable tablePoste = base.getTable("POSTE_ANALYTIQUE");
    private static final SQLTable tableEcriture = base.getTable("ECRITURE");
    private final DateFormat dateFormat = DateFormat.getDateInstance(2);
    private final DateFormat dateFormatEcr = DateFormat.getDateInstance(3);
    private SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
    private Date dateDu;
    private Date dateAu;
    public static String TEMPLATE_ID = "RepartitionAnalytique";
    public static String TEMPLATE_PROPERTY_NAME = "LocationJournaux";
    Date date;
    private int size;

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    public String getName() {
        if (this.date == null) {
            this.date = new Date();
        }
        return "R\u00e9partitionAnalytique" + this.date.getTime();
    }

    @Override
    protected String getStoragePathP() {
        return "R\u00e9partition Analytique";
    }

    public RepartitionAnalytiqueSheetXML(Date du, Date au) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(au);
        this.printer = PrinterNXProps.getInstance().getStringProperty("JournauxPrinter");
        this.dateAu = au;
        this.dateDu = du;
    }

    private void makeSousTotal(Map<String, Object> line, Map<Integer, String> style, int pos, long debit, long credit) {
        style.put(pos, "Titre 1");
        line.put("DEBIT", Double.valueOf(GestionDevise.currencyToString(debit, false)));
        line.put("CREDIT", Double.valueOf(GestionDevise.currencyToString(credit, false)));
        line.put("SOLDE", Double.valueOf(GestionDevise.currencyToString(debit - credit, false)));
    }

    @Override
    protected void createListeValues() {
        SQLSelect sel = new SQLSelect();
        sel.addSelect(tablePoste.getField("NOM"));
        sel.addSelect(tableAssoc.getField("MONTANT"), "SUM");
        sel.addSelect(tableEcriture.getField("COMPTE_NUMERO"));
        sel.addSelect(tableEcriture.getField("COMPTE_NOM"));
        Where w = new Where((FieldRef)tableEcriture.getField("DATE"), this.dateDu, (Object)this.dateAu);
        w = w.and(new Where((FieldRef)tableAssoc.getField("ID_POSTE_ANALYTIQUE"), "=", tablePoste.getKey()));
        w = w.and(new Where((FieldRef)tableAssoc.getField("ID_ECRITURE"), "=", tableEcriture.getKey()));
        sel.setWhere(w);
        sel.addFieldOrder(tablePoste.getField("NOM"));
        sel.addFieldOrder(tableEcriture.getField("COMPTE_NUMERO"));
        sel.addGroupBy(tablePoste.getField("NOM"));
        sel.addGroupBy(tableEcriture.getField("COMPTE_NUMERO"));
        sel.addGroupBy(tableEcriture.getField("COMPTE_NOM"));
        List list = tableAssoc.getDBSystemRoot().getDataSource().executeA(sel.asString());
        this.size = list.size();
        long totalDebit = 0L;
        long totalCredit = 0L;
        long sousTotalCredit = 0L;
        long sousTotalDebit = 0L;
        long totalCreditAntC = 0L;
        long totalDebitAntC = 0L;
        long totalCreditAntF = 0L;
        long totalDebitAntF = 0L;
        Object[] rowFirstEcr = null;
        boolean setTitle = true;
        boolean setLine = false;
        String numClasseFirst = "";
        String titre3 = "Titre 3";
        ArrayList<HashMap<String, Object>> tableauVals = new ArrayList<HashMap<String, Object>>();
        this.listAllSheetValues.put(0, tableauVals);
        HashMap<Integer, String> style = new HashMap<Integer, String>();
        this.styleAllSheetValues.put(0, style);
        setTitle = true;
        setLine = false;
        int i = 0;
        while (i < this.size) {
            Double doubleZero = Double.valueOf("0");
            Object[] line = (Object[])list.get(i);
            String nomPoste = line[0].toString();
            String compteNumero = line[2].toString();
            String compteNom = line[3].toString();
            HashMap<String, Object> ooLine = new HashMap<String, Object>();
            if (setTitle) {
                if (!setLine) {
                    tableauVals.add(ooLine);
                    style.put(tableauVals.size() - 1, "Titre 1");
                    ooLine.put("CLASSE", "");
                    ooLine.put("POSTE_CODE", "");
                    ooLine.put("POSTE_NOM", nomPoste);
                    ooLine.put("DEBIT", "");
                    ooLine.put("CREDIT", "");
                    ooLine.put("SOLDE", "");
                    setTitle = false;
                    setLine = true;
                    if (rowFirstEcr != null) continue;
                    rowFirstEcr = line;
                    numClasseFirst = nomPoste;
                    continue;
                }
                tableauVals.add(ooLine);
                style.put(tableauVals.size() - 1, "Normal");
                setLine = false;
                continue;
            }
            if (rowFirstEcr != null && !nomPoste.equals(numClasseFirst)) {
                rowFirstEcr = line;
                ooLine.put("POSTE_CODE", "Total");
                ooLine.put("POSTE_NOM", numClasseFirst);
                numClasseFirst = nomPoste;
                tableauVals.add(ooLine);
                this.makeSousTotal(ooLine, style, tableauVals.size() - 1, sousTotalDebit, sousTotalCredit);
                sousTotalCredit = 0L;
                sousTotalDebit = 0L;
                setTitle = true;
                continue;
            }
            long l = ((BigDecimal)line[1]).longValue();
            long cred = l >= 0L ? 0L : -l;
            long deb = l <= 0L ? 0L : l;
            ooLine.put("POSTE_CODE", compteNumero);
            ooLine.put("POSTE_NOM", compteNom);
            totalCredit += cred;
            totalDebit += deb;
            long solde = (sousTotalDebit += deb) - (sousTotalCredit += cred);
            ooLine.put("DEBIT", deb == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(deb, false)));
            ooLine.put("CREDIT", cred == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(cred, false)));
            ooLine.put("SOLDE", solde == 0L ? doubleZero : Double.valueOf(GestionDevise.currencyToString(solde, false)));
            tableauVals.add(ooLine);
            style.put(tableauVals.size() - 1, "Normal");
            ++i;
        }
        HashMap<String, Object> sheetVals = new HashMap<String, Object>();
        this.mapAllSheetValues.put(0, sheetVals);
        if (this.size > 0) {
            HashMap<String, Object> ooLine = new HashMap<String, Object>();
            tableauVals.add(ooLine);
            ooLine.put("POSTE_CODE", "Total");
            ooLine.put("POSTE_NOM", numClasseFirst);
            this.makeSousTotal(ooLine, style, tableauVals.size() - 1, sousTotalDebit, sousTotalCredit);
            sheetVals.put("TOTAL_DEBIT", totalDebit == 0L ? 0.0 : new Double(GestionDevise.currencyToString(totalDebit, false)));
            sheetVals.put("TOTAL_CREDIT", totalCredit == 0L ? 0.0 : new Double(GestionDevise.currencyToString(totalCredit, false)));
            sheetVals.put("TOTAL_SOLDE", totalDebit - totalCredit == 0L ? 0.0 : new Double(GestionDevise.currencyToString(totalDebit - totalCredit, false)));
        }
        sheetVals.put("TITRE_1", "R\u00e9partition analytique " + this.rowSociete.getString("TYPE") + " " + this.rowSociete.getString("NOM"));
        sheetVals.put("DATE_EDITION", new Date());
        sheetVals.put("TITRE_2", "P\u00e9riode du " + this.dateFormatEcr.format(this.dateDu) + " au " + this.dateFormatEcr.format(this.dateAu) + ".");
    }

    @Override
    public String getTemplateId() {
        return TEMPLATE_ID;
    }

    public int getSize() {
        return this.size;
    }
}

