/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking.sheet;

import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.openconcerto.erp.generationDoc.AbstractSheetXMLWithDate;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;

public class PickingSheetXML
extends AbstractSheetXMLWithDate {
    public static final String TEMPLATE_ID = "Picking";
    public static final String TEMPLATE_PROPERTY_NAME = "Picking";

    public PickingSheetXML(SQLRow row) {
        super(row);
        PrintService printer = PrintServiceLookup.lookupDefaultPrintService();
        this.printer = printer.getName();
        this.elt = Configuration.getInstance().getDirectory().getElement("COMMANDE_CLIENT");
    }

    public String getTemplateId() {
        return this.getDefaultTemplateId();
    }

    public String getReference() {
        return this.row.getString("NOM");
    }

    public SQLRow getRowLanguage() {
        SQLRow rowClient = this.row.getForeignRow("ID_CLIENT");
        if (rowClient.getTable().contains("ID_LANGUE")) {
            return rowClient.getForeignRow("ID_LANGUE");
        }
        return super.getRowLanguage();
    }

    public String getDefaultTemplateId() {
        return "Picking";
    }

    public String getName() {
        return "Picking_" + this.row.getString("NUMERO");
    }
}

