/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking.server;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openconcerto.erp.order.picking.server.Order;
import org.openconcerto.utils.StreamUtils;

public class Test {
    public static final String ip = "127.0.0.1";
    public static final int port = 8088;

    public static String getContent(String path) throws IOException {
        URL getNextUrl = new URL("HTTP", ip, 8088, path);
        HttpURLConnection getNextCon = (HttpURLConnection)getNextUrl.openConnection();
        getNextCon.setRequestMethod("GET");
        InputStream response = getNextCon.getInputStream();
        String xml = new String(StreamUtils.read((InputStream)response), "UTF8");
        response.close();
        getNextCon.disconnect();
        return xml;
    }

    public static void main(String[] args) {
        try {
            Test.testGetOrdersToPrepare();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void testGetOrderCount() throws IOException {
        System.out.println("\nConnecting to webservice getOrderCount");
        String count = Test.getContent("/getOrderCount");
        System.out.println("Sending 'GET' request for get order count");
        System.out.println("Response : " + count);
    }

    public static Order testGetNext() throws IOException, JDOMException, Exception {
        System.out.println("Connecting to webservice getNext");
        String xml = Test.getContent("/getNextOrder?userId=2");
        System.out.println(xml);
        SAXBuilder sb = new SAXBuilder();
        Document xmlResponse = sb.build((Reader)new StringReader(xml));
        Order order = new Order(xmlResponse.getRootElement());
        System.out.println("Sending 'GET' request for get next order");
        System.out.println("Response : " + order.orderNumber);
        return order;
    }

    public static void testGetOrdersToPrepare() throws IOException, JDOMException, Exception {
        System.out.println("Connecting to webservice getNext");
        String xml = Test.getContent("/getOrdersToPrepare?userId=2");
        System.out.println(xml);
    }

    public static void testValidateOrder(Order order) throws IOException, MalformedURLException, ProtocolException {
        System.out.println("\nConnecting to webservice notifyOrder: Validate order");
        HttpURLConnection postNotifyCon = (HttpURLConnection)new URL("HTTP", ip, 8088, "/notifyOrder").openConnection();
        postNotifyCon.setRequestMethod("POST");
        Element root = new Element("order");
        Document xmlQuery = new Document(root);
        root.setAttribute("state", "ok");
        root.setAttribute("ref", order.orderNumber);
        root.setAttribute("boxType", "lettre");
        root.setAttribute("boxNumber", "000000");
        root.setAttribute("idUser", "2");
        postNotifyCon.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(postNotifyCon.getOutputStream());
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        xmlOutput.output(xmlQuery, (OutputStream)wr);
        wr.flush();
        wr.close();
        int responseCode = postNotifyCon.getResponseCode();
        System.out.println("Sending 'POST' request for validate");
        System.out.println("Response Code : " + responseCode);
        BufferedReader in = new BufferedReader(new InputStreamReader(postNotifyCon.getInputStream()));
        StringBuffer bufferResponse = new StringBuffer();
        String inputLine = "";
        while ((inputLine = in.readLine()) != null) {
            bufferResponse.append(inputLine);
        }
        in.close();
        System.out.println("Response : " + bufferResponse.toString());
    }

    public void testCancelOrder() {
    }
}

