/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking.server;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.openconcerto.erp.order.picking.server.GetNextOrderHandler;
import org.openconcerto.erp.order.picking.server.GetOrderCountHandler;
import org.openconcerto.erp.order.picking.server.HeadlessOpenConcerto;
import org.openconcerto.erp.order.picking.server.PostNotifyOrderHandler;
import org.openconcerto.erp.order.picking.server.ServerUtils;
import org.openconcerto.sql.Configuration;

public class OrderPickingServer {
    public void startWebServer(int port) throws Exception {
        Server server = new Server(port);
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(new Handler[]{new GetNextOrderHandler(), new GetOrderCountHandler(), new PostNotifyOrderHandler()});
        server.setHandler((Handler)handlerCollection);
        server.start();
    }

    public static void main(String[] args) {
        System.setProperty("file.encoding", "UTF-8");
        Properties properties = new Properties();
        int port = -1;
        int idCompany = -1;
        int idUser = -1;
        try {
            properties.load(new FileInputStream("Configuration/pickingserver.properties"));
            port = Integer.parseInt(properties.getProperty("port"));
            idCompany = Integer.parseInt(properties.getProperty("idCompany"));
            idUser = Integer.parseInt(properties.getProperty("idUser"));
        }
        catch (IOException ex) {
            System.out.println(ServerUtils.printLog("ERROR", "Impossible to find properties file. | Configuration/pickingserver.properties |"));
            return;
        }
        OrderPickingServer server = new OrderPickingServer();
        System.out.println(ServerUtils.printLog("OK", "Connecting to company id:" + idCompany + ". | "));
        HeadlessOpenConcerto h = new HeadlessOpenConcerto(idUser, idCompany);
        ServerUtils.directory = Configuration.getInstance().getDirectory();
        ServerUtils.defaultUserId = idUser;
        if (h.getCompanyRoot() == null || ServerUtils.directory == null || ServerUtils.defaultUserId == -1) {
            System.out.println(ServerUtils.printLog("ERROR", "Openconcerto can't start. | "));
            return;
        }
        System.out.println(ServerUtils.printLog("OK", "Connected to company id:" + idCompany + " with user:" + idUser + ". | "));
        try {
            System.out.println(ServerUtils.printLog("OK", "Connecting to OpenConcerto webservice on port " + port + ". |"));
            server.startWebServer(port);
            System.out.println(ServerUtils.printLog("OK", "OpenConcerto webservices ready and listening on port " + port + ". |"));
        }
        catch (Exception ex) {
            System.out.println(ServerUtils.printLog("ERROR", "The server can't start. |"));
            ex.printStackTrace();
        }
    }
}

