/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking.server;

import org.jdom.Element;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;

public class OrderLine {
    private String barcode;
    private String sku;
    private String name;
    private int quantity;

    public OrderLine(SQLRowValues itemRow) throws IllegalArgumentException {
        SQLRowAccessor productRow = itemRow.getForeign("ID_ARTICLE");
        this.barcode = productRow.getString("CODE_BARRE");
        this.sku = productRow.getString("SKU");
        this.name = productRow.getString("NOM");
        this.quantity = itemRow.getInt("QTE");
    }

    public Element getXML() {
        Element xml = new Element("item");
        xml.setAttribute("barcode", this.barcode);
        xml.setAttribute("sku", this.sku);
        xml.setAttribute("quantity", String.valueOf(this.quantity));
        xml.setAttribute("name", this.name);
        return xml;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public String getName() {
        return this.name;
    }
}

