/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking.server;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.openconcerto.erp.core.sales.order.element.TransfertCommandeAutoUtils;
import org.openconcerto.erp.core.sales.order.ui.EtatCommandeClient;
import org.openconcerto.erp.order.picking.server.OrderLine;
import org.openconcerto.erp.order.picking.server.ServerUtils;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.Where;

public class Order {
    public String orderNumber;
    public String state;
    public String boxType;
    public String boxNumber;
    private Date date;
    private List<OrderLine> items = new ArrayList<OrderLine>();
    private int idUser;
    private int totalWeight;
    private String shippingType;
    private String deliveryAddress;
    private SQLRow orderRow;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Order(Element xml) throws Exception {
        Attribute attRef = xml.getAttribute("ref");
        Attribute attState = xml.getAttribute("state");
        Attribute attUserId = xml.getAttribute("userId");
        Attribute attAddress = xml.getAttribute("deliveryAddress");
        if (attRef == null) throw new IllegalArgumentException("Attribut ref manquant.");
        this.orderNumber = attRef.getValue();
        System.out.println("commande n:" + this.orderNumber);
        if (attState == null) throw new IllegalArgumentException("Commande n\u00b0" + this.orderNumber + " : attribut state manquant.");
        this.state = attState.getValue();
        this.idUser = attUserId != null ? attUserId.getIntValue() : ServerUtils.defaultUserId;
        if (this.state.equals("cancelled")) {
            this.cancelOrder();
        } else if (this.state.equals("ok")) {
            Attribute attBoxType = xml.getAttribute("boxType");
            Attribute attBoxNumber = xml.getAttribute("boxNumber");
            if (attBoxType == null || attBoxNumber == null) throw new IllegalArgumentException("Commande n\u00b0" + this.orderNumber + " : attribut boxType ou boxNumber manquant.");
            this.boxType = attBoxType.getValue();
            this.boxNumber = attBoxNumber.getValue();
            try {
                this.validateOrder();
            }
            catch (Exception ex) {
                throw new Exception("Commande n\u00b0" + this.orderNumber + " : " + ex.getMessage());
            }
        }
        if (attAddress == null) return;
        this.deliveryAddress = attAddress.getValue();
    }

    public Order(SQLRowValues orderRow, int userId) throws Exception {
        this.orderRow = orderRow.asRow();
        this.orderNumber = orderRow.getString("NUMERO");
        this.date = orderRow.getDate("DATE").getTime();
        this.idUser = userId;
        this.totalWeight = (int)(orderRow.getFloat("T_POIDS") * 1000.0f);
        this.shippingType = orderRow.getString("TYPE_EXPEDITION");
        SQLRowAccessor rAddress = orderRow.getForeign("ID_ADRESSE_LIVRAISON");
        if (rAddress.isUndefined()) {
            rAddress = orderRow.getForeign("ID_ADRESSE");
        }
        if (rAddress.isUndefined()) {
            rAddress = orderRow.getForeign("ID_CLIENT").getForeign("ID_ADRESSE_L");
        }
        if (rAddress.isUndefined()) {
            rAddress = orderRow.getForeign("ID_CLIENT").getForeign("ID_ADRESSE");
        }
        this.deliveryAddress = this.getAddress(orderRow.getForeign("ID_CLIENT"), rAddress);
        SQLTable salesItemsTable = ServerUtils.directory.getElement("COMMANDE_CLIENT_ELEMENT").getTable();
        Collection itemsRow = orderRow.getReferentRows(salesItemsTable);
        for (SQLRowValues sqlRowValues : itemsRow) {
            this.items.add(new OrderLine(sqlRowValues));
        }
    }

    public void setInPreparation() throws Exception, SQLException {
        this.createDeliveryOrder(ServerUtils.directory.getElement("COMMANDE_CLIENT").getTable(), this.orderRow.asRowValues());
        SQLRowValues orderRowVal = this.orderRow.asRowValues();
        orderRowVal.put("ETAT_COMMANDE", EtatCommandeClient.EN_PREPARATION.getId());
        orderRowVal.put("ID_USER_COMMON_MODIFY", this.idUser);
        orderRowVal.put("MODIFICATION_DATE", (Object)new Date());
        if (orderRowVal.getID() != -1) {
            SQLRow finalOrderRow = orderRowVal.update();
            if (finalOrderRow == null) {
                throw new Exception("Commande n\u00b0" + this.orderNumber + " | La mise \u00e0 jour du statut n'a pas fonctionner.");
            }
        } else {
            throw new IllegalArgumentException("Commande n\u00b0" + this.orderNumber + " | L'ID n'est pas renseign\u00e9.");
        }
    }

    public Order(String orderNumber, int userId) throws Exception {
        this.orderNumber = orderNumber;
        this.idUser = userId;
        this.cancelOrder();
    }

    public Element createXML() {
        int itemsCount = this.items.size();
        Element root = new Element("order");
        root.setAttribute("date", Order.couvertDateToISO(this.date));
        root.setAttribute("ref", this.orderNumber);
        root.setAttribute("shipping", this.shippingType);
        root.setAttribute("weight", String.valueOf(this.totalWeight));
        root.setAttribute("deliveryAddress", this.deliveryAddress);
        int i = 0;
        while (i < itemsCount) {
            OrderLine item = this.items.get(i);
            root.addContent((Content)item.getXML());
            ++i;
        }
        return root;
    }

    private void cancelOrder() throws Exception {
        SQLTable salesTable = ServerUtils.directory.getElement("COMMANDE_CLIENT").getTable();
        SQLRow orderRow = this.getSQLRow(salesTable);
        if (orderRow != null) {
            SQLRowValues orderRowVal = orderRow.asRowValues();
            List trRows = orderRow.getReferentRows(salesTable.getTable("TR_COMMANDE_CLIENT"));
            if (!trRows.isEmpty()) {
                SQLElement elementBL = ServerUtils.directory.getElement("BON_DE_LIVRAISON");
                for (SQLRow sqlRow : trRows) {
                    if (sqlRow.isForeignEmpty("ID_BON_DE_LIVRAISON")) continue;
                    elementBL.archive(sqlRow.getForeignID("ID_BON_DE_LIVRAISON"));
                }
            }
            orderRowVal.put("ETAT_COMMANDE", EtatCommandeClient.BLOQUE.getId());
            orderRowVal.put("ID_USER_COMMON_MODIFY", this.idUser);
            orderRowVal.put("MODIFICATION_DATE", (Object)new Date());
            SQLRow finalOrderRow = orderRowVal.update();
            if (finalOrderRow == null) {
                throw new Exception("Commande n\u00b0" + this.orderNumber + " : erreur de mise \u00e0 jour du statut.");
            }
        } else {
            throw new IllegalArgumentException("Le num\u00e9ro de commande " + this.orderNumber + " n'existe pas.");
        }
    }

    private void createDeliveryOrder(SQLTable salesTable, SQLRowValues orderRowVal) throws Exception {
        TransfertCommandeAutoUtils transfert = new TransfertCommandeAutoUtils(salesTable);
        transfert.transfertBL(new Date(), orderRowVal);
    }

    private void createInvoice(SQLTable salesTable, SQLRowValues orderRowVal) throws Exception {
        ArrayList<SQLRowValues> orderRowVals = new ArrayList<SQLRowValues>();
        TransfertCommandeAutoUtils transfert = new TransfertCommandeAutoUtils(salesTable);
        orderRowVals.add(orderRowVal);
        transfert.transfertFacture(orderRowVals);
    }

    private void validateOrder() throws Exception {
        SQLTable salesTable = ServerUtils.directory.getElement("COMMANDE_CLIENT").getTable();
        SQLRow orderRow = this.getSQLRow(salesTable);
        if (orderRow != null) {
            SQLRowValues orderRowVal = orderRow.asRowValues();
            this.createInvoice(salesTable, orderRowVal);
            orderRowVal.put("ETAT_COMMANDE", EtatCommandeClient.LIVREE.getId());
            orderRowVal.put("EMBALLAGE", (Object)this.boxType);
            orderRowVal.put("NUMERO_EXPEDITION", (Object)this.boxNumber);
            orderRowVal.put("ID_USER_COMMON_MODIFY", this.idUser);
            orderRowVal.put("MODIFICATION_DATE", (Object)new Date());
            SQLRow finalRow = orderRowVal.update();
            if (finalRow == null) {
                throw new Exception("Commande n\u00b0" + this.orderNumber + " : erreur de mise \u00e0 jour du statut ");
            }
        } else {
            throw new IllegalArgumentException("Le num\u00e9ro de commande " + this.orderNumber + " n'existe pas.");
        }
    }

    private SQLRow getSQLRow(SQLTable salesTable) {
        SQLSelect select = new SQLSelect();
        select.addSelectStar((TableRef)salesTable);
        select.setWhere(new Where((FieldRef)salesTable.getField("NUMERO"), "=", (Object)this.orderNumber));
        List selectResult = SQLRowListRSH.execute((SQLSelect)select);
        if (!selectResult.isEmpty()) {
            return (SQLRow)selectResult.get(0);
        }
        return null;
    }

    public static final String couvertDateToISO(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        return df.format(date);
    }

    public String getAddress(SQLRowAccessor rowCustomer, SQLRowAccessor rAddress) {
        String result = "";
        result = String.valueOf(rowCustomer.getString("NOM")) + "\n";
        if (rAddress.getString("LIBELLE").trim().length() > 0) {
            result = String.valueOf(rAddress.getString("LIBELLE")) + "\n";
        }
        if (rAddress.getString("DEST").trim().length() > 0) {
            result = String.valueOf(rAddress.getString("DEST")) + "\n";
        }
        if (rAddress.getString("RUE").trim().length() > 0) {
            result = String.valueOf(result) + rAddress.getString("RUE") + "\n";
        }
        result = String.valueOf(result) + "\n" + rAddress.getString("CODE_POSTAL");
        result = String.valueOf(result) + " ";
        if (rAddress.getTable().contains("DISTRICT")) {
            result = String.valueOf(result) + rAddress.getString("DISTRICT") + " ";
        }
        result = String.valueOf(result) + rAddress.getString("VILLE");
        if (rAddress.getBoolean("HAS_CEDEX").booleanValue()) {
            result = String.valueOf(result) + " Cedex";
            String cedex = rAddress.getString("CEDEX");
            if (cedex != null && cedex.trim().length() > 0) {
                result = String.valueOf(result) + " " + cedex;
            }
        }
        if (rAddress.getTable().contains("PROVINCE")) {
            result = String.valueOf(result) + "\n";
            if (rAddress.getString("PROVINCE").trim().length() > 0) {
                result = String.valueOf(result) + rAddress.getString("PROVINCE") + " ";
            }
            if (rAddress.getTable().contains("DEPARTEMENT")) {
                result = String.valueOf(result) + rAddress.getString("DEPARTEMENT");
            }
        }
        if (rAddress.getString("PAYS").trim().length() > 0) {
            result = String.valueOf(result) + "\n" + rAddress.getString("PAYS");
        }
        return result;
    }
}

