/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking.server;

import java.util.Locale;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.MainFrame;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.utils.i18n.TranslationManager;

public class HeadlessOpenConcerto {
    final ComptaPropsConfiguration comptaPropsConfiguration;

    public HeadlessOpenConcerto(int userId, int companyId) {
        System.setProperty("java.awt.headless", "true");
        System.setProperty("org.openconcerto.sql.structure.useXML", "true");
        ComptaPropsConfiguration conf = ComptaPropsConfiguration.create();
        if (conf == null) {
            throw new IllegalStateException("null ComptaPropsConfiguration");
        }
        TranslationManager.getInstance().addTranslationStreamFromClass(MainFrame.class);
        TranslationManager.getInstance().setLocale(Locale.getDefault());
        Configuration.setInstance((Configuration)conf);
        try {
            conf.getBase();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Unable to configure database connection", e);
        }
        try {
            this.comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
            this.comptaPropsConfiguration.getUserManager().setCurrentUserID((Number)userId);
            this.comptaPropsConfiguration.setUpSocieteDataBaseConnexion(companyId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Unable to configure connection for userId: " + userId + " companyId: " + companyId, e);
        }
        System.out.println("HeadlessOpenConcerto ready");
        System.out.println("Connected to " + conf.getServerIp() + " on " + conf.getSystemRootName() + "/" + conf.getSocieteBaseName());
    }

    public ComptaPropsConfiguration getComptaPropsConfiguration() {
        return this.comptaPropsConfiguration;
    }

    public DBRoot getCompanyRoot() {
        return this.comptaPropsConfiguration.getRootSociete();
    }

    public DBRoot getCommonRoot() {
        return this.comptaPropsConfiguration.getRoot();
    }
}

