/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking.server;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openconcerto.erp.core.sales.order.element.CommandeClientSQLElement;
import org.openconcerto.erp.core.sales.order.ui.EtatCommandeClient;
import org.openconcerto.erp.order.picking.server.Order;
import org.openconcerto.erp.order.picking.server.ServerUtils;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.cc.ITransformer;

public class GetNextOrderHandler
extends AbstractHandler {
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block14: {
            String pathInfo = request.getPathInfo();
            try {
                try {
                    response.setContentType("text/xml");
                    response.setCharacterEncoding("UTF-8");
                    int userId = ServerUtils.defaultUserId;
                    String param = request.getParameter("userId");
                    if (param != null && !param.isEmpty()) {
                        userId = Integer.parseInt(param);
                    }
                    if (pathInfo.equals("/getNextOrder")) {
                        SQLRowValues row = this.getNextOrderToPrepare();
                        if (row != null) {
                            Order order = new Order(row, userId);
                            order.setInPreparation();
                            Document xml = new Document(order.createXML());
                            XMLOutputter xmlOutput = new XMLOutputter();
                            xmlOutput.setFormat(Format.getPrettyFormat());
                            xmlOutput.output(xml, (Writer)response.getWriter());
                        }
                        break block14;
                    }
                    if (pathInfo.equals("/getOrdersToPrepare")) {
                        List<SQLRowValues> rows = this.getNextOrdersToPrepare();
                        Element root = new Element("orders");
                        if (rows != null) {
                            for (SQLRowValues row : rows) {
                                Order order = new Order(row, userId);
                                root.addContent((Content)order.createXML());
                            }
                        }
                        Document xml = new Document(root);
                        XMLOutputter xmlOutput = new XMLOutputter();
                        xmlOutput.setFormat(Format.getPrettyFormat());
                        xmlOutput.output(xml, (Writer)response.getWriter());
                        break block14;
                    }
                    if (!pathInfo.equals("/getOrder")) break block14;
                    List<SQLRowValues> rows = this.getNextOrdersToPrepare();
                    String ref = request.getParameter("ref");
                    SQLRowValues row = null;
                    if (ref != null && !ref.isEmpty()) {
                        for (SQLRowValues sqlRowValues : rows) {
                            if (!sqlRowValues.getString("NUMERO").equalsIgnoreCase(ref)) continue;
                            row = sqlRowValues;
                            break;
                        }
                    }
                    if (row != null) {
                        Order order = new Order(row, userId);
                        order.setInPreparation();
                        Document xml = new Document(order.createXML());
                        XMLOutputter xmlOutput = new XMLOutputter();
                        xmlOutput.setFormat(Format.getPrettyFormat());
                        xmlOutput.output(xml, (Writer)response.getWriter());
                        break block14;
                    }
                    System.out.println(ServerUtils.printLog("WARNING", "/getOrder ref=" + ref + " not found"));
                }
                catch (Exception ex) {
                    response.setContentType("text/plain");
                    System.out.println(ServerUtils.printLog("ERROR", ex.getMessage()));
                    ex.printStackTrace();
                    response.setStatus(400);
                    baseRequest.setHandled(true);
                    System.out.println(ServerUtils.printLog("OK", pathInfo));
                }
            }
            finally {
                baseRequest.setHandled(true);
                System.out.println(ServerUtils.printLog("OK", pathInfo));
            }
        }
    }

    public SQLRowValues getNextOrderToPrepare() {
        List<SQLRowValues> result = this.getNextOrdersToPrepare();
        if (result == null || result.size() == 0) {
            return null;
        }
        return result.get(0);
    }

    public List<SQLRowValues> getNextOrdersToPrepare() {
        CommandeClientSQLElement element = (CommandeClientSQLElement)ServerUtils.directory.getElement(CommandeClientSQLElement.class);
        final SQLTable tableCmd = element.getTable();
        SQLRowValues graph = new SQLRowValues(tableCmd);
        String[] adresseFields = new String[]{"LIBELLE", "DEST", "RUE", "CODE_POSTAL", "VILLE", "HAS_CEDEX", "CEDEX", "PROVINCE", "PAYS"};
        graph.putNulls(new String[]{tableCmd.getKey().getName(), "NUMERO", "DATE", "T_HT", "T_TVA", "T_TTC", "PORT_HT", "REMISE_HT", "T_POIDS", "TYPE_EXPEDITION", "ETAT_COMMANDE"});
        graph.putRowValues("ID_ADRESSE").putNulls(adresseFields);
        graph.putRowValues("ID_ADRESSE_LIVRAISON").putNulls(adresseFields);
        SQLRowValues rClient = graph.putRowValues("ID_CLIENT");
        rClient.putNulls(new String[]{"NOM"});
        rClient.putRowValues("ID_ADRESSE").putNulls(adresseFields);
        rClient.putRowValues("ID_ADRESSE_L").putNulls(adresseFields);
        SQLRowValues cmdItem = new SQLRowValues(tableCmd.getTable("COMMANDE_CLIENT_ELEMENT"));
        cmdItem.put("ID_COMMANDE_CLIENT", (Object)graph);
        cmdItem.putNulls(new String[]{"QTE"});
        cmdItem.putRowValues("ID_ARTICLE").putNulls(new String[]{"CODE_BARRE", "SKU", "NOM"});
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create((SQLRowValues)graph, (boolean)false);
        fetcher.setSelTransf((ITransformer)new ITransformer<SQLSelect, SQLSelect>(){

            public SQLSelect transformChecked(SQLSelect sel) {
                sel.addFieldOrder(sel.getAlias(tableCmd.getField("DATE")));
                sel.addFieldOrder(sel.getAlias(tableCmd.getField("ID_CLIENT")));
                sel.addFieldOrder(sel.getAlias(tableCmd.getField("T_HT")));
                sel.andWhere(new Where((FieldRef)tableCmd.getField("ETAT_COMMANDE"), "=", EtatCommandeClient.A_PREPARER.getId()));
                return sel;
            }
        });
        List result = fetcher.fetch();
        if (result == null || result.size() == 0) {
            return null;
        }
        return result;
    }
}

