/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.List;
import org.openconcerto.utils.StringUtils;

public class SerialBalanceAdam {
    private String port;
    private final SerialPort serialPort;
    private final OutputStream out;
    private final InputStream in;
    private Integer lastWeight;

    public SerialBalanceAdam(String port) throws IOException, Exception {
        port = port.trim();
        if (port.endsWith(":")) {
            port = port.substring(0, port.length() - 1);
        }
        this.port = port;
        this.serialPort = this.getSerialPort();
        this.out = this.serialPort.getOutputStream();
        this.in = this.serialPort.getInputStream();
        this.lastWeight = null;
    }

    public synchronized Integer getWeight() throws Exception {
        this.out.write(80);
        this.out.write(13);
        this.out.write(10);
        Integer g = null;
        int i = 0;
        while (i < 3) {
            try {
                Thread.sleep(300L);
                byte[] readBuffer = new byte[600];
                StringBuffer buffer = new StringBuffer();
                int available = this.in.available();
                while (available > 0) {
                    this.in.read(readBuffer, 0, available);
                    String s = new String(readBuffer);
                    buffer.append(s);
                    available = this.in.available();
                }
                List l = StringUtils.fastSplit((String)buffer.toString().trim(), (char)'\n');
                for (String line : l) {
                    if (!(line = line.trim()).startsWith("Net Wt") && !line.startsWith("Pds Net") && !line.startsWith("Pds Brut") && !line.startsWith("Net-Gew") && !line.startsWith("Pso Net") && !line.startsWith("Gross Wt")) continue;
                    List lParts = StringUtils.fastSplit((String)line, (char)' ');
                    String unit = (String)lParts.get(lParts.size() - 1);
                    String w = (String)lParts.get(lParts.size() - 2);
                    BigDecimal b = new BigDecimal(w);
                    if (unit.equalsIgnoreCase("kg")) {
                        b = b.multiply(new BigDecimal(1000));
                    }
                    this.lastWeight = g = Integer.valueOf(b.intValue());
                    System.err.println("SerialBalanceAdam.getWeight() thread:" + Thread.currentThread().getId() + ", got : " + g + "g from " + line);
                    break;
                }
                if (g != null) break;
                System.err.println("SerialBalanceAdam.getWeight() buffer: " + buffer.toString());
                System.err.println("SerialBalanceAdam.getWeight() retrying reading");
                Thread.sleep(700L);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (g == null) {
            return this.lastWeight;
        }
        return g;
    }

    private SerialPort getSerialPort() throws Exception {
        if (this.port == null || this.port.length() == 0) {
            throw new IllegalStateException("Invalid serial port name: " + this.port);
        }
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)this.port);
        if (portIdentifier.isCurrentlyOwned()) {
            throw new IllegalAccessError("Port " + this.port + " is currently in use");
        }
        int timeOutMs = 2000;
        CommPort commPort = portIdentifier.open("SerialBalanceAdam", 2000);
        if (!(commPort instanceof SerialPort)) {
            throw new IllegalStateException("Invalid serial port: " + this.port);
        }
        SerialPort serialPort = (SerialPort)commPort;
        serialPort.setSerialPortParams(9600, 8, 1, 0);
        return serialPort;
    }

    public static void main(String[] args) throws IOException, Exception {
        SerialBalanceAdam.listPorts();
        SerialBalanceAdam prt = new SerialBalanceAdam("COM10:");
        try {
            int i = 0;
            while (i < 100) {
                int g = prt.getWeight();
                System.out.println(g);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void listPorts() {
        Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
        while (portEnum.hasMoreElements()) {
            CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
            System.out.println("Port: " + portIdentifier.getName());
        }
    }

    public String toString() {
        return "SerialBalanceAdam port " + this.port;
    }
}

