/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking;

public class ProductAndQuantity {
    private String name;
    private int qty;
    private boolean isInBox;
    private String barCode;
    private String sku;

    ProductAndQuantity(String barCode, String sku, String name, int qty, boolean isInBox) {
        if (barCode == null || barCode.isEmpty()) {
            throw new IllegalArgumentException("Empty barcode");
        }
        if (sku == null) {
            throw new IllegalArgumentException("Empty sku");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Empty name");
        }
        if (qty <= 0) {
            throw new IllegalArgumentException("Invalid quantity : " + qty);
        }
        this.barCode = barCode;
        this.sku = sku;
        this.name = name;
        this.qty = qty;
        this.isInBox = isInBox;
    }

    public String getBarCode() {
        return this.barCode;
    }

    public boolean isInBox() {
        return this.isInBox;
    }

    public String getName() {
        return this.name;
    }

    public String getSku() {
        return this.sku;
    }

    public int getQty() {
        return this.qty;
    }

    public void addQty(int i) {
        this.qty += i;
    }

    public String toString() {
        return String.valueOf(this.barCode) + " " + this.qty + "x" + this.name + " inBox:" + this.isInBox;
    }
}

