/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking;

import java.awt.GridLayout;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.order.picking.Order;
import org.openconcerto.erp.order.picking.OrderListCellRenderer;
import org.openconcerto.erp.order.picking.OrderListModel;

public class OrderToPrepareList
extends JPanel {
    private final OrderListModel model = new OrderListModel();
    final JList list = new JList();

    public OrderToPrepareList() {
        this.list.setModel(this.model);
        this.list.setCellRenderer(new OrderListCellRenderer());
        this.list.setSelectionMode(0);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.list);
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                OrderToPrepareList.this.firePropertyChange("selection", -1, e.getFirstIndex());
            }
        });
    }

    public void setOrders(List<Order> l) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalArgumentException("Must be called in AWT");
        }
        this.model.setOrders(l);
        this.selectFirstLine();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalArgumentException("Must be called in AWT");
        }
        super.setEnabled(enabled);
        this.list.setEnabled(enabled);
        this.selectFirstLine();
    }

    public void selectFirstLine() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalArgumentException("Must be called in AWT");
        }
        if (this.list.getSelectedIndex() < 0 && this.list.getModel().getSize() > 0) {
            this.list.setSelectedIndex(0);
        }
    }

    public String getSelectedOrderRef() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalArgumentException("Must be called in AWT");
        }
        Object o = this.list.getSelectedValue();
        if (o == null) {
            return null;
        }
        return ((Order)o).getReference();
    }
}

