/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.order.picking.Order;
import org.openconcerto.erp.order.picking.OrderListener;
import org.openconcerto.erp.order.picking.OrderPicking;
import org.openconcerto.erp.order.picking.SerialBalanceAdam;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.JImage;

public class OrderStatePanel
extends JPanel {
    private final SerialBalanceAdam balance;
    final JLabel textWeight = new JLabel("Poids : ---- g", 0);
    private Order order;
    private Thread balanceThread;

    public OrderStatePanel(final Order order, SerialBalanceAdam balance) {
        this.order = order;
        this.balance = balance;
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JImage logoComponent = new JImage(this.getClass().getResource("box.png"));
        logoComponent.setOpaque(false);
        this.add((Component)logoComponent, c);
        c.anchor = 10;
        ++c.gridy;
        this.textWeight.setFont(this.textWeight.getFont().deriveFont(20.0f));
        final JLabel textState = new JLabel(String.valueOf(order.getInBoxQty()) + " / " + order.getNumberOfProducts(), 0);
        textState.setFont(textState.getFont().deriveFont(32.0f));
        this.add((Component)textState, c);
        ++c.gridy;
        this.textWeight.setFont(this.textWeight.getFont().deriveFont(20.0f));
        this.textWeight.setForeground(Color.DARK_GRAY);
        this.add((Component)this.textWeight, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 0.0;
        c.fill = 0;
        final JButton validationButton = new JButton("Valider");
        validationButton.setFont(validationButton.getFont().deriveFont(18.0f));
        validationButton.setOpaque(false);
        validationButton.setEnabled(false);
        validationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (order.alertIfNotReady(OrderStatePanel.this)) {
                    return;
                }
                OrderPicking.getInstance().openOrderDeliveryInfoFrame(order);
                SwingUtilities.getWindowAncestor(OrderStatePanel.this).dispose();
            }
        });
        this.add((Component)validationButton, c);
        ++c.gridy;
        order.addOrderListener(new OrderListener(){

            @Override
            public void orderModified() {
                textState.setText(String.valueOf(order.getInBoxQty()) + " / " + order.getNumberOfProducts());
                validationButton.setEnabled(order.getInBoxQty() == order.getNumberOfProducts());
            }
        });
    }

    public synchronized void startUpdate() {
        if (this.balance == null || this.balanceThread != null) {
            return;
        }
        this.balanceThread = new Thread("Balance checker"){

            @Override
            public void run() {
                boolean stop = false;
                while (!stop) {
                    String label = "Poids : ";
                    try {
                        int g = OrderStatePanel.this.balance.getWeight();
                        OrderStatePanel.this.order.setWeight(g);
                        label = String.valueOf(label) + g + " g";
                    }
                    catch (Exception e) {
                        label = String.valueOf(label) + "---- g";
                        e.printStackTrace();
                    }
                    final String l = label;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).OrderStatePanel.this.textWeight != null) {
                                (this).OrderStatePanel.this.textWeight.setText(l);
                            }
                        }
                    });
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        stop = true;
                    }
                }
            }
        };
        this.balanceThread.setDaemon(true);
        this.balanceThread.setPriority(1);
        this.balanceThread.start();
    }

    public synchronized void stopUpdate() {
        if (this.balanceThread != null) {
            this.balanceThread.interrupt();
        }
    }
}

