/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.erp.order.picking.Order;
import org.openconcerto.erp.order.picking.OrderProductsListModel;
import org.openconcerto.erp.order.picking.ProductAndQuantity;
import org.openconcerto.ui.touch.ScrollableList;

public class OrderProductPanel
extends JPanel {
    public OrderProductPanel(final Order order) {
        this.setLayout(new GridLayout(1, 1));
        final Font f1 = new JLabel().getFont().deriveFont(20.0f);
        final Font f2 = new JLabel().getFont().deriveFont(18.0f);
        final Image imageToScan = new ImageIcon(this.getClass().getResource("barcode_icon.png")).getImage();
        final Image imageInBox = new ImageIcon(this.getClass().getResource("box_icon.png")).getImage();
        final OrderProductsListModel orderProductsListModel = new OrderProductsListModel(order);
        final ScrollableList ticketList = new ScrollableList(orderProductsListModel){

            public void paintCell(Graphics g, Object object, int index, boolean isSelected, int posY) {
                ProductAndQuantity o = (ProductAndQuantity)object;
                g.setFont(f2);
                g.setColor(Color.WHITE);
                g.fillRect(0, posY, this.getWidth(), this.getCellHeight());
                g.setColor(Color.GRAY);
                g.drawLine(0, posY + this.getCellHeight() - 1, this.getWidth(), posY + this.getCellHeight() - 1);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(Color.BLACK);
                String label = o.getName();
                if (o.getSku() != null && !o.getSku().isEmpty()) {
                    label = String.valueOf(label) + "\n [" + o.getSku() + "]";
                }
                int leftMargin = 90;
                int maxWidth = (this.getWidth() - 80 - leftMargin) / 9;
                if (maxWidth < 5) {
                    maxWidth = 5;
                }
                if (label.length() > maxWidth * 2) {
                    label = String.valueOf(label.substring(0, maxWidth * 2)) + "...";
                }
                String label2 = null;
                if (label.length() > maxWidth) {
                    String t = label.substring(0, maxWidth).trim();
                    int lastSpace = t.lastIndexOf(32);
                    if (lastSpace <= 0) {
                        lastSpace = maxWidth;
                    }
                    label2 = label.substring(lastSpace).trim();
                    label = label.substring(0, lastSpace).trim();
                    if (label2.length() > maxWidth) {
                        label2 = String.valueOf(label2.substring(0, maxWidth)) + "...";
                    }
                }
                String sQty = String.valueOf(o.getQty()) + " x  ";
                int wQty = (int)g.getFontMetrics().getStringBounds(sQty, g).getWidth();
                g.drawString(sQty, leftMargin - wQty, posY + 39);
                if (label2 == null) {
                    g.drawString(label, leftMargin, posY + 39);
                } else {
                    g.setFont(f1);
                    g.drawString(label, leftMargin, posY + 26);
                    g.drawString(label2, leftMargin, posY + 52);
                }
                if (!o.isInBox()) {
                    g.drawImage(imageToScan, this.getWidth() - 64, posY, null);
                } else {
                    g.drawImage(imageInBox, this.getWidth() - 64, posY, null);
                }
            }
        };
        ticketList.setCellHeight(70);
        ticketList.setOpaque(true);
        this.add((Component)ticketList);
        ticketList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    int index = ticketList.getIndexFromY(e.getY());
                    ProductAndQuantity p = (ProductAndQuantity)orderProductsListModel.getElementAt(index);
                    if (!p.isInBox()) {
                        order.addToBox(p.getBarCode());
                    } else {
                        order.removeFromBox(p.getBarCode());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }
}

