/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.erp.core.sales.pos.ui.BarcodeListener;
import org.openconcerto.erp.order.picking.Order;
import org.openconcerto.erp.order.picking.OrderPicking;
import org.openconcerto.erp.order.picking.OrderPickingPanel;
import org.openconcerto.erp.order.picking.SerialBalanceAdam;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ExceptionHandler;

public class OrderPickingFrame
extends JFrame
implements BarcodeListener {
    private final OrderPickingPanel pickingPanel;
    private final JPanel pMenu = new JPanel();
    private Order order;

    OrderPickingFrame(SerialBalanceAdam balance, final Order order, String userName) {
        this.order = order;
        order.reorder();
        this.setLayout(new BorderLayout());
        JPanel menu = new JPanel();
        menu.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        c.insets = new Insets(10, 10, 10, 10);
        JButton b = new JButton("Menu"){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(new Color(0, 98, 159));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
            }
        };
        b.setFocusable(false);
        b.setOpaque(true);
        b.setContentAreaFilled(false);
        b.setBorderPainted(false);
        b.setFocusPainted(false);
        b.setFont(b.getFont().deriveFont(16.0f));
        b.setForeground(Color.WHITE);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderPickingFrame.this.showMenu();
            }
        });
        menu.add((Component)b, c);
        ++c.gridx;
        c.anchor = 13;
        c.weightx = 1.0;
        JLabel label = new JLabel(userName);
        label.setFont(label.getFont().deriveFont(14.0f));
        label.setForeground(Color.WHITE);
        menu.add((Component)label, c);
        menu.setOpaque(true);
        menu.setBackground(new Color(83, 129, 172));
        this.add((Component)menu, "North");
        this.pickingPanel = new OrderPickingPanel(order, balance);
        this.add(this.pickingPanel);
        int mWidth = 1024;
        int mHeight = 768;
        try {
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            mWidth = gd.getDisplayMode().getWidth();
            mHeight = gd.getDisplayMode().getHeight();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (mWidth > 1024) {
            mWidth -= 20;
        }
        if (mHeight > 768) {
            mHeight = 768;
        }
        this.setSize(mWidth, mHeight);
        this.pMenu.setOpaque(true);
        this.pMenu.setBackground(Color.WHITE);
        this.pMenu.setLayout(new GridBagLayout());
        DefaultGridBagConstraints cMenu = new DefaultGridBagConstraints();
        cMenu.fill = 0;
        cMenu.anchor = 10;
        cMenu.insets = new Insets(20, 20, 20, 20);
        JButton bPrint = new JButton("Impression du bon de pr\u00e9paration");
        this.pMenu.add((Component)bPrint, cMenu);
        bPrint.setFocusable(false);
        bPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    order.printPickingSheet();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((String)"Impossible d'imprimer", (Throwable)ex);
                }
                OrderPickingFrame.this.showPicking();
            }
        });
        JButton bCancel = new JButton("Annuler la pr\u00e9paration de commande en cours");
        ++cMenu.gridy;
        this.pMenu.add((Component)bCancel, cMenu);
        bCancel.setFocusable(false);
        bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    order.commitAndDestroy(true, OrderPicking.getInstance().getUserId());
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((String)"Impossible d'annuler la commande", (Throwable)ex);
                }
                OrderPickingFrame.this.dispose();
                OrderPicking.getInstance().waitNextOrder();
            }
        });
        JButton backMenu = new JButton("Quitter le menu");
        backMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderPickingFrame.this.showPicking();
            }
        });
        ++cMenu.gridy;
        this.pMenu.add((Component)backMenu, cMenu);
        OrderPicking.getInstance().getBarcodeReader().addBarcodeListener((BarcodeListener)this);
    }

    protected void showMenu() {
        this.invalidate();
        this.remove(this.pickingPanel);
        this.add(this.pMenu);
        this.validate();
        this.repaint();
    }

    protected void showPicking() {
        this.invalidate();
        this.remove(this.pMenu);
        this.add(this.pickingPanel);
        this.validate();
        this.repaint();
    }

    @Override
    public void dispose() {
        System.err.println("OrderPickingFrame.dispose()");
        OrderPicking.getInstance().getBarcodeReader().removeBarcodeListener((BarcodeListener)this);
        this.pickingPanel.dispose();
        super.dispose();
    }

    public void barcodeRead(String code) {
        System.err.println("OrderPickingFrame.barcodeRead()" + code);
        if (code.trim().startsWith("VALIDER")) {
            if (this.order.alertIfNotReady(this.pickingPanel)) {
                return;
            }
            OrderPicking.getInstance().openOrderDeliveryInfoFrame(this.order);
            this.dispose();
        } else {
            this.order.addToBox(code.trim());
        }
    }

    public void keyReceived(KeyEvent ee) {
    }
}

