/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking;

import java.awt.Container;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.MainFrame;
import org.openconcerto.erp.core.sales.pos.io.BarcodeReader;
import org.openconcerto.erp.order.picking.NewOrderWaitingPanel;
import org.openconcerto.erp.order.picking.Order;
import org.openconcerto.erp.order.picking.OrderDeliveryInfoFrame;
import org.openconcerto.erp.order.picking.OrderPickingFrame;
import org.openconcerto.erp.order.picking.SerialBalanceAdam;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.preferences.UserProps;
import org.openconcerto.sql.ui.ConnexionPanel;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.JImage;
import org.openconcerto.utils.i18n.TranslationManager;

public class OrderPicking {
    private static OrderPicking instance = new OrderPicking();
    private SerialBalanceAdam balance;
    final Properties properties = new Properties();
    private BarcodeReader barcodeReader;
    private String userName = "";
    private int userId = 2;
    ConnexionPanel p;

    public OrderPicking() {
        try {
            System.out.println("Loading configuration");
            this.loadConfiguration();
        }
        catch (Exception e) {
            ExceptionHandler.handle((String)"Error loading configuration", (Throwable)e);
        }
        System.out.println("Configuring ticket printer and scales");
        try {
            if (this.getTicketPrinterPort() != null && !this.getTicketPrinterPort().isEmpty()) {
                System.out.println("Using serial port for ticket : " + this.getTicketPrinterPort());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Erreur de communication avec l'imprimante ticket.\nPort " + this.getTicketPrinterPort());
            e.printStackTrace();
        }
        try {
            System.out.println("Using serial port for scales : " + this.getScalesPort());
            this.balance = new SerialBalanceAdam(this.getScalesPort());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Erreur de communication avec la balance.\nPort " + this.getScalesPort());
            e.printStackTrace();
        }
    }

    public String getScalesPort() {
        return this.properties.getProperty("scales.port", "COM1:");
    }

    public String getTicketPrinterPort() {
        return this.properties.getProperty("ticket.port", "COM2:");
    }

    public static void main(String[] args) throws IOException {
        OrderPicking picking = OrderPicking.getInstance();
        picking.start();
    }

    public static synchronized OrderPicking getInstance() {
        return instance;
    }

    private void start() {
        System.setProperty("file.encoding", "UTF-8");
        System.out.println("BarCode reader");
        int barCodeDelay = this.getBarCodeDelay();
        System.out.println("Using inter key delay: " + barCodeDelay);
        this.barcodeReader = new BarcodeReader(barCodeDelay);
        System.setProperty("redirectToFile", "true");
        System.setProperty("org.openconcerto.sql.structure.useXML", "true");
        System.setProperty("org.openconcerto.oo.useODSViewer", "true");
        long t1 = System.currentTimeMillis();
        final ComptaPropsConfiguration conf = ComptaPropsConfiguration.create((boolean)false);
        Configuration.setInstance((Configuration)conf);
        TranslationManager.getInstance().addTranslationStreamFromClass(MainFrame.class);
        TranslationManager.getInstance().setLocale(UserProps.getInstance().getLocale());
        try {
            conf.getBase();
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionHandler.die((String)"Erreur de connexion \u00e0 la base de donn\u00e9es", (Throwable)e);
        }
        System.out.println("OpenConcerto started in " + (System.currentTimeMillis() - t1) + "ms");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                OrderPicking.this.barcodeReader.start();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("User Id : " + UserManager.getUserID());
                        OrderPicking.this.userId = UserManager.getUserID();
                        conf.setUpSocieteDataBaseConnexion((this).OrderPicking.this.p.getSelectedSociete());
                        ((TemplateNXProps)TemplateNXProps.getInstance()).register("Picking", "Picking", null);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                OrderPicking.this.waitNextOrder();
                            }
                        });
                    }
                };
                OrderPicking.this.p = new ConnexionPanel(r, new JImage(this.getClass().getResource("logo.png")), true, false);
                JFrame f = new JFrame("Connexion");
                f.setContentPane((Container)OrderPicking.this.p);
                f.pack();
                f.setLocationRelativeTo(null);
                FrameUtil.showPacked((Frame)f);
            }
        });
    }

    private int getBarCodeDelay() {
        return Integer.parseInt(this.properties.getProperty("barcode.delay", "80"));
    }

    private void loadConfiguration() throws IOException {
        File file = new File("picking.properties");
        if (!file.exists()) {
            System.err.println("Unable to find configuration file : " + file.getAbsolutePath());
            JOptionPane.showMessageDialog(null, "picking.properties not found");
            System.exit(1);
        }
        this.properties.load(new FileInputStream(file));
    }

    public String getIp() {
        return this.properties.getProperty("server.ip", "127.0.0.1");
    }

    public String getPort() {
        return this.properties.getProperty("server.port", "80");
    }

    public BarcodeReader getBarcodeReader() {
        return this.barcodeReader;
    }

    public void startPicking(String selectedOrderRef) {
        Order nextOrder;
        if (selectedOrderRef == null) {
            try {
                nextOrder = Order.getNewOrder(this.getUserId());
            }
            catch (Exception e) {
                nextOrder = null;
                ExceptionHandler.handle((String)"Impossible de r\u00e9cuperer la commande", (Throwable)e);
            }
        } else {
            try {
                nextOrder = Order.getOrder(selectedOrderRef);
                if (nextOrder == null) {
                    JOptionPane.showMessageDialog(null, "Commande " + selectedOrderRef + " d\u00e9j\u00e0 en pr\u00e9paration");
                    return;
                }
            }
            catch (Exception e) {
                nextOrder = null;
                ExceptionHandler.handle((String)"Impossible de r\u00e9cuperer la commande", (Throwable)e);
            }
        }
        final Order order = nextOrder;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (order == null) {
                    JOptionPane.showMessageDialog(new JFrame(), "Impossible de traiter la commande");
                    OrderPicking.this.waitNextOrder();
                } else {
                    OrderPickingFrame orderPickingFrame = new OrderPickingFrame(OrderPicking.this.balance, order, OrderPicking.this.getUserName());
                    orderPickingFrame.setDefaultCloseOperation(0);
                    orderPickingFrame.setLocationRelativeTo(null);
                    orderPickingFrame.setVisible(true);
                    order.printPickingSheet();
                }
            }
        });
    }

    public String getUserName() {
        return this.userName;
    }

    public void waitNextOrder() {
        JFrame f = new JFrame("Commandes \u00e0 pr\u00e9parer");
        NewOrderWaitingPanel p = new NewOrderWaitingPanel();
        f.setDefaultCloseOperation(0);
        f.setContentPane(p);
        f.pack();
        f.setLocationRelativeTo(null);
        FrameUtil.showPacked((Frame)f);
        p.start();
    }

    public int getUserId() {
        return this.userId;
    }

    public void openOrderDeliveryInfoFrame(Order order) {
        OrderDeliveryInfoFrame f = new OrderDeliveryInfoFrame(order);
        f.pack();
        f.setLocationRelativeTo(null);
        FrameUtil.showPacked((Frame)f);
    }
}

