/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.text.SimpleDateFormat;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.openconcerto.erp.order.picking.Order;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class OrderListCellRenderer
implements ListCellRenderer {
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel p = new JPanel();
        Order order = (Order)value;
        p.setLayout(new GridBagLayout());
        if (isSelected && list.isEnabled()) {
            p.setBackground(list.getSelectionBackground());
            p.setForeground(list.getSelectionForeground());
        } else {
            p.setBackground(list.getBackground());
            p.setForeground(list.getForeground());
        }
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        if (!list.isEnabled()) {
            p.setForeground(Color.DARK_GRAY);
        }
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 2;
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        JLabel dateLabel = this.createLabel(p, df.format(order.getDate()));
        dateLabel.setFont(dateLabel.getFont().deriveFont(1));
        dateLabel.setMinimumSize(new Dimension(100, 10));
        dateLabel.setPreferredSize(new Dimension(100, 10));
        p.add((Component)dateLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        JLabel labelRef = this.createLabel(p, order.getReference());
        labelRef.setFont(labelRef.getFont().deriveFont(1));
        p.add((Component)labelRef, c);
        ++c.gridx;
        c.weightx = 0.0;
        p.add((Component)this.createLabel(p, order.getTheoricalShipping()), c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        int numberOfProducts = order.getNumberOfProducts();
        String textQty = numberOfProducts == 0 ? "Aucun article" : (numberOfProducts == 1 ? "Un article" : String.valueOf(numberOfProducts) + " articles");
        JLabel labelQty = this.createLabel(p, textQty);
        if (numberOfProducts < 1) {
            labelQty.setForeground(Color.ORANGE);
        }
        p.add((Component)labelQty, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        p.add((Component)this.createLabel(p, order.getDeliveryAddress().replace('\n', ' ')), c);
        return p;
    }

    private JLabel createLabel(JPanel p, String text) {
        JLabel l = new JLabel();
        l.setText(text);
        l.setOpaque(false);
        l.setFont(p.getFont());
        l.setForeground(p.getForeground());
        return l;
    }
}

