/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.text.DateFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.erp.order.picking.Order;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.JImage;

public class OrderInfoPanel
extends JPanel {
    public OrderInfoPanel(Order order) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        File customerIconFile = new File("logo.png");
        if (customerIconFile.exists()) {
            JImage logoComponent = new JImage("logo.png");
            logoComponent.setOpaque(false);
            c.insets = new Insets(2, 3, 30, 2);
            this.add((Component)logoComponent, c);
            c.insets = new Insets(2, 3, 3, 2);
            ++c.gridy;
        }
        JLabel title = new JLabel("Commande en pr\u00e9paration");
        title.setForeground(Color.BLACK);
        title.setFont(title.getFont().deriveFont(18.0f));
        this.add((Component)title, c);
        ++c.gridy;
        JLabel ref = new JLabel("N\u00b0 " + order.getReference());
        ref.setFont(ref.getFont().deriveFont(16.0f));
        this.add((Component)ref, c);
        ++c.gridy;
        JLabel date = new JLabel("Date : " + DateFormat.getDateInstance(1).format(order.getDate()));
        date.setFont(date.getFont().deriveFont(16.0f));
        this.add((Component)date, c);
        ++c.gridy;
        ITextArea addr = new ITextArea(order.getDeliveryAddress());
        addr.setFont(ref.getFont());
        addr.setBorder(null);
        addr.setEditable(false);
        this.add((Component)addr, c);
        ++c.gridy;
        JLabel tShipping = new JLabel("Transport : " + order.getTheoricalShipping());
        tShipping.setFont(tShipping.getFont().deriveFont(16.0f));
        this.add((Component)tShipping, c);
        ++c.gridy;
        JLabel tWeight = new JLabel("Poids th\u00e9orique : " + order.getTheoricalWeight() + " g");
        tWeight.setFont(tWeight.getFont().deriveFont(16.0f));
        this.add((Component)tWeight, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.anchor = 16;
        JImage logoOpenConcertoComponent = new JImage(this.getClass().getResource("openconcerto.png"));
        logoOpenConcertoComponent.setOpaque(false);
        this.add((Component)logoOpenConcertoComponent, c);
    }
}

