/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.order.picking.NewOrderWaitingPanel;
import org.openconcerto.erp.order.picking.Order;
import org.openconcerto.erp.order.picking.OrderPicking;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.JImage;

public class OrderDeliveryInfoPanel
extends JPanel {
    final JTextField textType = new JTextField(20);
    final JTextField textNumber = new JTextField(20);
    private Order order;

    public OrderDeliveryInfoPanel(Order order) {
        this.order = order;
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        Font f1 = new JLabel().getFont().deriveFont(20.0f);
        Font f2 = new JLabel().getFont().deriveFont(18.0f);
        Image imageInBox = new ImageIcon(this.getClass().getResource("box_icon.png")).getImage();
        JImage im = new JImage(imageInBox);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.add((Component)im, c);
        ++c.gridx;
        JLabel labelTitle = new JLabel("Exp\u00e9dition");
        labelTitle.setFont(f1);
        this.add((Component)labelTitle, c);
        ++c.gridy;
        JLabel labelType = new JLabel("Type de colis");
        labelType.setFont(f2);
        this.add((Component)labelType, c);
        ++c.gridy;
        this.textType.setFont(f2);
        this.add((Component)this.textType, c);
        ++c.gridy;
        JLabel labelNumber = new JLabel("Num\u00e9ro de suivi");
        labelNumber.setFont(f2);
        this.add((Component)labelNumber, c);
        ++c.gridy;
        this.textNumber.setFont(f2);
        this.add((Component)this.textNumber, c);
        ++c.gridy;
        JButton button = new JButton("Valider");
        button.setFont(f2);
        c.fill = 0;
        c.anchor = 14;
        c.insets = new Insets(10, 0, 20, 10);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderDeliveryInfoPanel.this.validOrder();
            }
        });
        this.add((Component)button, c);
        ++c.gridy;
    }

    public void validOrder() {
        if (this.order.alertIfNotReady(this)) {
            return;
        }
        this.order.setBoxType(this.textType.getText());
        this.order.setBoxNumber(this.textNumber.getText());
        try {
            this.order.commitAndDestroy(false, OrderPicking.getInstance().getUserId());
            try {
                this.order.printTicket();
                this.order.destroy();
            }
            catch (Exception e) {
                ExceptionHandler.handle((String)"Erreur globale d'impression", (Throwable)e);
            }
            SwingUtilities.getWindowAncestor(this).dispose();
            JFrame f = new JFrame("Analyse des commandes \u00e0 pr\u00e9parer");
            NewOrderWaitingPanel p = new NewOrderWaitingPanel();
            f.setDefaultCloseOperation(0);
            f.setContentPane(p);
            f.pack();
            f.setLocationRelativeTo(null);
            FrameUtil.showPacked((Frame)f);
            p.start();
        }
        catch (Exception e1) {
            ExceptionHandler.handle((String)"Impossible d'envoyer les \u00e9l\u00e9ments au serveur", (Throwable)e1);
        }
    }

    public void setBoxType(String t) {
        this.textType.setText(t);
    }

    public void setBoxNumber(String t) {
        this.textNumber.setText(t);
    }

    public String getBoxType() {
        return this.textType.getText();
    }
}

