/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking;

import java.awt.Component;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openconcerto.erp.core.sales.pos.io.ESCSerialPrinter;
import org.openconcerto.erp.core.sales.pos.model.TicketLine;
import org.openconcerto.erp.order.picking.OrderListener;
import org.openconcerto.erp.order.picking.OrderPicking;
import org.openconcerto.erp.order.picking.ProductAndQuantity;
import org.openconcerto.erp.order.picking.sheet.PickingSheetXML;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.utils.ExceptionHandler;

public class Order {
    private String ref;
    private Date date;
    private ArrayList<ProductAndQuantity> list = new ArrayList();
    private int totalQty = 0;
    private int inBoxQty = 0;
    private List<OrderListener> listeners = new ArrayList<OrderListener>();
    private String boxType = "";
    private String boxNumber = "";
    private int weight;
    private int tWeight;
    private String tShipping;
    private String deliveryAddress;

    public Order(String ref, Date d, int tWeight, String tShipping, String deliveryAddress) {
        this.ref = ref;
        this.date = d;
        this.tWeight = tWeight;
        this.tShipping = tShipping;
        this.deliveryAddress = deliveryAddress;
        this.reorder();
    }

    public synchronized void add(ProductAndQuantity productAndQuantity) {
        this.list.add(productAndQuantity);
        this.totalQty += productAndQuantity.getQty();
        if (productAndQuantity.isInBox()) {
            this.inBoxQty += productAndQuantity.getQty();
        }
    }

    public synchronized void addToBox(String barcode) {
        ProductAndQuantity toUpdate = null;
        for (ProductAndQuantity p : this.list) {
            if (!p.getBarCode().equals(barcode) || p.isInBox()) continue;
            toUpdate = p;
        }
        if (toUpdate == null) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, "Attention, cet article ne doit pas \u00eatre mis dans le colis!!!");
            return;
        }
        ProductAndQuantity productInBox = null;
        for (ProductAndQuantity p : this.list) {
            if (!p.getBarCode().equals(barcode) || !p.isInBox()) continue;
            productInBox = p;
        }
        if (productInBox == null) {
            productInBox = new ProductAndQuantity(barcode, toUpdate.getSku(), toUpdate.getName(), 1, true);
            this.add(productInBox);
        } else {
            productInBox.addQty(1);
        }
        System.out.println(productInBox);
        if (toUpdate.getQty() > 1) {
            toUpdate.addQty(-1);
        } else {
            this.list.remove(toUpdate);
        }
        this.reorder();
        this.fireModification();
    }

    public synchronized void removeFromBox(String barcode) {
        ProductAndQuantity toUpdate = null;
        for (ProductAndQuantity p : this.list) {
            if (!p.getBarCode().equals(barcode) || !p.isInBox()) continue;
            toUpdate = p;
        }
        if (toUpdate == null) {
            return;
        }
        ProductAndQuantity productNotInBox = null;
        for (ProductAndQuantity p : this.list) {
            if (!p.getBarCode().equals(barcode) || p.isInBox()) continue;
            productNotInBox = p;
        }
        if (productNotInBox == null) {
            productNotInBox = new ProductAndQuantity(barcode, toUpdate.getSku(), toUpdate.getName(), 1, false);
            this.add(productNotInBox);
        } else {
            productNotInBox.addQty(1);
        }
        System.out.println(productNotInBox);
        if (toUpdate.getQty() > 1) {
            toUpdate.addQty(-1);
        } else {
            this.list.remove(toUpdate);
        }
        this.reorder();
        this.fireModification();
    }

    private synchronized void fireModification() {
        for (OrderListener l : this.listeners) {
            l.orderModified();
        }
    }

    public synchronized String getReference() {
        return this.ref;
    }

    public synchronized Date getDate() {
        return this.date;
    }

    public synchronized int getNumberOfProducts() {
        return this.totalQty;
    }

    public synchronized int getInBoxQty() {
        return this.inBoxQty;
    }

    public synchronized void reorder() {
        Collections.sort(this.list, new Comparator<ProductAndQuantity>(){

            @Override
            public int compare(ProductAndQuantity o1, ProductAndQuantity o2) {
                if (o1.isInBox() && !o2.isInBox()) {
                    return 1;
                }
                if (!o1.isInBox() && o2.isInBox()) {
                    return -1;
                }
                return (String.valueOf(o1.getSku()) + o1.getName()).compareTo(String.valueOf(o2.getSku()) + o2.getName());
            }
        });
        this.inBoxQty = 0;
        this.totalQty = 0;
        for (ProductAndQuantity p : this.list) {
            if (p.isInBox()) {
                this.inBoxQty += p.getQty();
            }
            this.totalQty += p.getQty();
        }
    }

    public synchronized List<ProductAndQuantity> getMissingProducts() {
        ArrayList<ProductAndQuantity> l = new ArrayList<ProductAndQuantity>();
        for (ProductAndQuantity p : this.list) {
            if (p.isInBox()) continue;
            l.add(p);
        }
        return l;
    }

    public synchronized int getSize() {
        return this.list.size();
    }

    public synchronized ProductAndQuantity getElementAt(int index) {
        return this.list.get(index);
    }

    public synchronized void addOrderListener(OrderListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeOrderListener(OrderListener l) {
        this.listeners.remove(l);
    }

    public synchronized void setBoxType(String text) {
        this.boxType = text;
    }

    public synchronized void setBoxNumber(String text) {
        this.boxNumber = text;
    }

    public synchronized void commitAndDestroy(boolean cancelled, int userId) throws Exception {
        String inputLine;
        Element root = new Element("order");
        Document doc = new Document(root);
        if (!cancelled) {
            root.setAttribute("state", "ok");
            root.setAttribute("boxType", this.boxType);
            root.setAttribute("boxNumber", this.boxNumber);
        } else {
            root.setAttribute("state", "cancelled");
        }
        root.setAttribute("ref", this.ref);
        root.setAttribute("userId", String.valueOf(userId));
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        xmlOutput.output(doc, (OutputStream)bOut);
        byte[] byteArray = bOut.toByteArray();
        OrderPicking p = OrderPicking.getInstance();
        String url = "http://" + p.getIp() + ":" + p.getPort() + "/notifyOrder";
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setRequestProperty("Content-type", "text/xml");
        DataOutputStream wr = new DataOutputStream(con.getOutputStream());
        System.err.println("Order.commitAndDestroy()" + byteArray.length + " bytes");
        wr.write(byteArray);
        wr.flush();
        wr.close();
        int responseCode = con.getResponseCode();
        System.out.println("Sending 'POST' request to URL : " + url + " Cancelled:" + cancelled + " UserId:" + userId);
        System.out.println("XML:" + bOut.toString("UTF8"));
        System.out.println("Response Code : " + responseCode);
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        System.out.println("Response:" + response.toString());
    }

    public void destroy() {
        this.listeners.clear();
        this.list.clear();
    }

    public static int getRemainingOrderCount() throws Exception {
        String str = Order.getFromServer("/getOrderCount");
        return Integer.parseInt(str);
    }

    public static Order getNewOrder(int userId) throws Exception {
        String str = Order.getFromServer("/getNextOrder?userId=" + userId);
        if (str.length() == 0) {
            return null;
        }
        SAXBuilder sxb = new SAXBuilder();
        Document doc = sxb.build((Reader)new StringReader(str));
        Element root = doc.getRootElement();
        Order order = Order.getOrderFromElement(root);
        return order;
    }

    public static Order getOrder(String ref) throws Exception {
        String str = Order.getFromServer("/getOrder?ref=" + ref);
        if (str.length() == 0) {
            return null;
        }
        SAXBuilder sxb = new SAXBuilder();
        Document doc = sxb.build((Reader)new StringReader(str));
        Element root = doc.getRootElement();
        Order order = Order.getOrderFromElement(root);
        return order;
    }

    public static List<Order> getOrdersToPrepare(int userId) throws Exception {
        String str = Order.getFromServer("/getOrdersToPrepare?userId=" + userId);
        if (str.length() == 0) {
            return null;
        }
        SAXBuilder sxb = new SAXBuilder();
        Document doc = sxb.build((Reader)new StringReader(str));
        Element root = doc.getRootElement();
        List l = root.getChildren();
        ArrayList<Order> result = new ArrayList<Order>();
        for (Element orderElement : l) {
            Order order = Order.getOrderFromElement(orderElement);
            result.add(order);
        }
        return result;
    }

    public static Order getOrderFromElement(Element orderElement) throws ParseException {
        String date = orderElement.getAttributeValue("date");
        String ref = orderElement.getAttributeValue("ref");
        Date d = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'").parse(date);
        int tWeight = Integer.parseInt(orderElement.getAttributeValue("weight", "0"));
        String tShipping = orderElement.getAttributeValue("shipping");
        String address = orderElement.getAttributeValue("deliveryAddress");
        Order order = new Order(ref, d, tWeight, tShipping, address);
        List chidren = orderElement.getChildren("item");
        for (Element object : chidren) {
            String qtyStr = object.getAttributeValue("quantity");
            int qty = Integer.parseInt(qtyStr);
            String barcode = object.getAttributeValue("barcode");
            if (barcode == null || barcode.isEmpty()) {
                barcode = "000";
            }
            if (barcode.equals("000")) continue;
            if (order.getProductFromBarCode(barcode) != null) {
                order.getProductFromBarCode(barcode).addQty(qty);
                continue;
            }
            ProductAndQuantity productAndQuantity = new ProductAndQuantity(barcode, object.getAttributeValue("sku"), object.getAttributeValue("name"), qty, false);
            order.add(productAndQuantity);
        }
        return order;
    }

    private ProductAndQuantity getProductFromBarCode(String barcode) {
        for (ProductAndQuantity p : this.list) {
            if (!p.getBarCode().equals(barcode)) continue;
            return p;
        }
        return null;
    }

    private static String getFromServer(String path) throws IOException {
        String inputLine;
        OrderPicking p = OrderPicking.getInstance();
        String url = "http://" + p.getIp() + ":" + p.getPort() + path;
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        int responseCode = con.getResponseCode();
        System.out.println("Sending 'GET' request to URL : " + url);
        System.out.println("Response Code : " + responseCode);
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    public synchronized void printTicket() {
        ESCSerialPrinter prt = new ESCSerialPrinter(OrderPicking.getInstance().getTicketPrinterPort());
        String d = DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime());
        prt.addToBuffer(new TicketLine(d, "normal"));
        prt.addToBuffer("");
        prt.addToBuffer("Votre commande :");
        prt.addToBuffer("Ref. : " + this.ref);
        prt.addToBuffer("Pr\u00e9p. : " + UserManager.getUser().getNickName());
        prt.addToBuffer("");
        int qtyTotal = 0;
        for (ProductAndQuantity item : this.list) {
            qtyTotal += item.getQty();
            String string = String.valueOf(item.getQty()) + " x ";
            String txt = String.valueOf(string) + item.getBarCode();
            prt.addToBuffer(txt);
            String spacer = "";
            int length = string.length();
            int i = 0;
            while (i < length) {
                spacer = String.valueOf(spacer) + " ";
                ++i;
            }
            prt.addToBuffer(String.valueOf(spacer) + " " + item.getName());
        }
        if (qtyTotal > 1) {
            prt.addToBuffer("Total : " + qtyTotal + " articles");
        } else {
            prt.addToBuffer("Total : " + qtyTotal + " article");
        }
        if (this.weight >= 0) {
            prt.addToBuffer("Poids : " + this.weight + " g");
        }
        prt.addToBuffer("");
        prt.addToBuffer("");
        try {
            prt.printBuffer();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Impossible d'imprimer le ticket.\nPort " + OrderPicking.getInstance().getTicketPrinterPort());
            e.printStackTrace();
        }
    }

    public synchronized void setWeight(int grams) {
        this.weight = grams;
    }

    public synchronized int getWeight() {
        return this.weight;
    }

    public synchronized int getTheoricalWeight() {
        return this.tWeight;
    }

    public synchronized String getTheoricalShipping() {
        return this.tShipping;
    }

    public void printPickingSheet() {
        SQLSelect sel = new SQLSelect();
        SQLTable tableCmd = Configuration.getInstance().getRoot().findTable("COMMANDE_CLIENT");
        System.out.println(Configuration.getInstance().getRoot().getDBRoot().getChildrenNames());
        System.out.println(tableCmd);
        sel.addSelectStar((TableRef)tableCmd);
        sel.setWhere(new Where((FieldRef)tableCmd.getField("NUMERO"), "=", (Object)this.getReference()));
        List result = SQLRowListRSH.execute((SQLSelect)sel);
        if (result.size() == 1) {
            PickingSheetXML sheet = new PickingSheetXML((SQLRow)result.get(0));
            try {
                sheet.createDocument();
                sheet.printDocument();
            }
            catch (Exception e) {
                ExceptionHandler.handle((String)"Impression impossible", (Throwable)e);
            }
        } else {
            String ex = "Impression du bordereau de livraison impossible.";
            ex = result.size() == 0 ? " Aucune commande associ\u00e9e au num\u00e9ro " + this.getReference() + " dans la base de donn\u00e9es." : " Il y a plus d'une commande associ\u00e9e au num\u00e9ro " + this.getReference() + " dans la base de donn\u00e9es.";
            throw new IllegalStateException(ex);
        }
    }

    public boolean alertIfNotReady(Component parent) {
        this.reorder();
        if (!this.getMissingProducts().isEmpty()) {
            String s = "Certains articles sont manquants :\n";
            List<ProductAndQuantity> l = this.getMissingProducts();
            for (ProductAndQuantity productAndQuantity : l) {
                s = String.valueOf(s) + productAndQuantity.getQty() + " x " + productAndQuantity.getName() + "\n";
            }
            JOptionPane.showMessageDialog(parent, s);
            return true;
        }
        return false;
    }

    public String getDeliveryAddress() {
        return this.deliveryAddress;
    }
}

