/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.order.picking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openconcerto.erp.core.sales.pos.ui.BarcodeListener;
import org.openconcerto.erp.order.picking.Order;
import org.openconcerto.erp.order.picking.OrderPicking;
import org.openconcerto.erp.order.picking.OrderToPrepareList;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.ReloadPanel;
import org.openconcerto.utils.JImage;

public class NewOrderWaitingPanel
extends JPanel
implements BarcodeListener {
    private static final String PREPARER_UNE_COMMANDE = "Pr\u00e9parer une commande";
    private ReloadPanel reloadPanel;
    private JLabel title = new JLabel("R\u00e9cup\u00e9ration des commandes depuis le serveur");
    private JButton bOrder = new JButton("Pr\u00e9parer une commande");
    private boolean isToClose = false;
    private Thread t;
    private static boolean modeAuto = true;
    private OrderToPrepareList orderToPrepareList;

    NewOrderWaitingPanel() {
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 3;
        c.fill = 0;
        c.anchor = 10;
        File customerIconFile = new File("logo.png");
        JImage logoComponent = customerIconFile.exists() ? new JImage("logo.png") : new JImage(this.getClass().getResource("logo.png"));
        logoComponent.setOpaque(false);
        c.insets = new Insets(20, 20, 20, 20);
        this.add((Component)logoComponent, c);
        ++c.gridy;
        c.insets = new Insets(10, 20, 10, 20);
        this.reloadPanel = new ReloadPanel();
        this.add((Component)this.reloadPanel, c);
        ++c.gridy;
        this.title.setForeground(Color.BLACK);
        this.title.setFont(this.title.getFont().deriveFont(18.0f));
        this.add((Component)this.title, c);
        this.orderToPrepareList = new OrderToPrepareList();
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        JScrollPane scroll = new JScrollPane(this.orderToPrepareList);
        scroll.setPreferredSize(new Dimension(450, 300));
        this.orderToPrepareList.setEnabled(!modeAuto);
        this.orderToPrepareList.addPropertyChangeListener("selection", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewOrderWaitingPanel.this.updateButton();
            }
        });
        this.add((Component)scroll, c);
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        c.anchor = 14;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 10, 10, 10);
        final JCheckBox b = new JCheckBox("Mode manuel");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewOrderWaitingPanel.this.setModeAuto(!b.isSelected());
            }
        });
        b.setOpaque(false);
        b.setSelected(!modeAuto);
        this.add((Component)b, c);
        c.weightx = 0.0;
        ++c.gridx;
        this.bOrder.setOpaque(false);
        this.add((Component)this.bOrder, c);
        JButton bQuit = new JButton("Quitter");
        bQuit.setOpaque(false);
        bQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        ++c.gridx;
        this.add((Component)bQuit, c);
        this.bOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewOrderWaitingPanel.this.startPicking();
            }
        });
    }

    protected void setModeAuto(boolean b) {
        modeAuto = b;
        this.invalidate();
        this.orderToPrepareList.setEnabled(!modeAuto);
        this.revalidate();
        this.repaint();
        if (b) {
            this.bOrder.setText(PREPARER_UNE_COMMANDE);
        }
        this.updateButton();
    }

    public void start() {
        OrderPicking.getInstance().getBarcodeReader().addBarcodeListener((BarcodeListener)this);
        this.t = new Thread("Loading..."){

            @Override
            public void run() {
                System.out.println("Polling new order");
                boolean stop = false;
                int o = 0;
                while (!stop) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NewOrderWaitingPanel.this.bOrder.setEnabled(false);
                            NewOrderWaitingPanel.this.reloadPanel.setMode(0);
                        }
                    });
                    try {
                        o = Order.getRemainingOrderCount();
                        final String txt = o == 0 ? "Aucune commande \u00e0 pr\u00e9parer" : (o == 1 ? "Une commande \u00e0 pr\u00e9parer !" : String.valueOf(o) + " commandes \u00e0 pr\u00e9parer !");
                        final List<Order> orders = Order.getOrdersToPrepare(OrderPicking.getInstance().getUserId());
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NewOrderWaitingPanel.this.orderToPrepareList.setOrders(orders);
                            }
                        });
                        final int nb = o;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (nb > 0) {
                                    NewOrderWaitingPanel.this.bOrder.setEnabled(true);
                                }
                                NewOrderWaitingPanel.this.title.setText(txt);
                                NewOrderWaitingPanel.this.reloadPanel.setMode(2);
                            }
                        });
                    }
                    catch (Exception e1) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NewOrderWaitingPanel.this.title.setText("Erreur de communication avec le serveur");
                                NewOrderWaitingPanel.this.reloadPanel.setMode(1);
                            }
                        });
                        e1.printStackTrace();
                    }
                    if (NewOrderWaitingPanel.this.isToClosed()) {
                        stop = true;
                        continue;
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                System.out.println("Polling new order END");
            }
        };
        this.t.setDaemon(true);
        this.t.start();
    }

    protected synchronized boolean isToClosed() {
        return this.isToClose;
    }

    public synchronized void setToClose(boolean isToClose) {
        this.isToClose = isToClose;
        if (isToClose) {
            OrderPicking.getInstance().getBarcodeReader().removeBarcodeListener((BarcodeListener)this);
            this.t.interrupt();
            SwingUtilities.getWindowAncestor(this).dispose();
        }
    }

    public static void main(String[] args) {
        System.setProperty("file.encoding", "UTF-8");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                JFrame f = new JFrame("Commandes \u00e0 pr\u00e9parer");
                NewOrderWaitingPanel p = new NewOrderWaitingPanel();
                f.setDefaultCloseOperation(2);
                f.setContentPane(p);
                f.setLocationRelativeTo(null);
                FrameUtil.showPacked((Frame)f);
                p.start();
            }
        });
    }

    public void barcodeRead(String code) {
        System.out.println("NewOrderWaitingPanel.barcodeRead() : " + code);
        if (code.startsWith("PREP") && this.bOrder.isEnabled()) {
            this.startPicking();
        }
    }

    private void startPicking() {
        System.out.println("Start picking");
        this.setToClose(true);
        if (!modeAuto) {
            String selectedOrderRef = this.orderToPrepareList.getSelectedOrderRef();
            if (selectedOrderRef != null && !selectedOrderRef.isEmpty()) {
                OrderPicking.getInstance().startPicking(selectedOrderRef);
            } else {
                JOptionPane.showMessageDialog(this, "Merci de s\u00e9lectionener une commande");
            }
        } else {
            OrderPicking.getInstance().startPicking(null);
        }
    }

    public void keyReceived(KeyEvent ee) {
    }

    public void updateButton() {
        if (!modeAuto) {
            String ref = this.orderToPrepareList.getSelectedOrderRef();
            if (ref != null) {
                this.bOrder.setText("Pr\u00e9parer la commande " + ref);
            } else {
                this.bOrder.setText(PREPARER_UNE_COMMANDE);
            }
        }
    }
}

