--
-- PostgreSQL database dump
--

-- Dumped from database version 9.5.14
-- Dumped by pg_dump version 9.5.14

-- Started on 2018-12-22 16:23:40 CET

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;

--
-- TOC entry 9 (class 2615 OID 36388163)
-- Name: Common; Type: SCHEMA; Schema: -; Owner: openconcerto
--

CREATE SCHEMA "Common";


ALTER SCHEMA "Common" OWNER TO openconcerto;

--
-- TOC entry 21347 (class 0 OID 0)
-- Dependencies: 9
-- Name: SCHEMA "Common"; Type: COMMENT; Schema: -; Owner: openconcerto
--

COMMENT ON SCHEMA "Common" IS 'Standard public schema';


--
-- TOC entry 10 (class 2615 OID 36388164)
-- Name: Default; Type: SCHEMA; Schema: -; Owner: openconcerto
--

CREATE SCHEMA "Default";


ALTER SCHEMA "Default" OWNER TO openconcerto;

--
-- TOC entry 21349 (class 0 OID 0)
-- Dependencies: 10
-- Name: SCHEMA "Default"; Type: COMMENT; Schema: -; Owner: openconcerto
--

COMMENT ON SCHEMA "Default" IS 'Standard public schema';


--
-- TOC entry 7 (class 2615 OID 36388165)
-- Name: OpenConcerto42; Type: SCHEMA; Schema: -; Owner: openconcerto
--

CREATE SCHEMA "OpenConcerto42";


ALTER SCHEMA "OpenConcerto42" OWNER TO openconcerto;

--
-- TOC entry 8 (class 2615 OID 36388166)
-- Name: OpenConcerto48; Type: SCHEMA; Schema: -; Owner: openconcerto
--

CREATE SCHEMA "OpenConcerto48";


ALTER SCHEMA "OpenConcerto48" OWNER TO openconcerto;

--
-- TOC entry 1 (class 3079 OID 12363)
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- TOC entry 21353 (class 0 OID 0)
-- Dependencies: 1
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


--
-- TOC entry 1349 (class 1255 OID 36388167)
-- Name: plpgsql_call_handler(); Type: FUNCTION; Schema: Common; Owner: openconcerto
--

CREATE FUNCTION "Common".plpgsql_call_handler() RETURNS language_handler
    LANGUAGE c
    AS '$libdir/plpgsql', 'plpgsql_call_handler';


ALTER FUNCTION "Common".plpgsql_call_handler() OWNER TO openconcerto;

--
-- TOC entry 1350 (class 1255 OID 36388168)
-- Name: plpgsql_validator(oid); Type: FUNCTION; Schema: Common; Owner: openconcerto
--

CREATE FUNCTION "Common".plpgsql_validator(oid) RETURNS void
    LANGUAGE c
    AS '$libdir/plpgsql', 'plpgsql_validator';


ALTER FUNCTION "Common".plpgsql_validator(oid) OWNER TO openconcerto;

--
-- TOC entry 1351 (class 1255 OID 36388169)
-- Name: next_ordret(); Type: FUNCTION; Schema: Default; Owner: openconcerto
--

CREATE FUNCTION "Default".next_ordret() RETURNS numeric
    LANGUAGE sql
    AS $$ UPDATE ordreT_generator set tmpVal = currentVal, currentVal = currentVal + inc ;SELECT tmpVal from ordreT_generator; $$;


ALTER FUNCTION "Default".next_ordret() OWNER TO openconcerto;

--
-- TOC entry 1352 (class 1255 OID 36388170)
-- Name: reset_ordret(); Type: FUNCTION; Schema: Default; Owner: openconcerto
--

CREATE FUNCTION "Default".reset_ordret() RETURNS numeric
    LANGUAGE sql
    AS $$ update ordreT_generator set currentVal = minVal ;select currentVal from ordreT_generator; $$;


ALTER FUNCTION "Default".reset_ordret() OWNER TO openconcerto;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 185 (class 1259 OID 36388171)
-- Name: ACCES_SOCIETE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."ACCES_SOCIETE" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON" integer DEFAULT 1,
    "ID_SOCIETE_COMMON" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."ACCES_SOCIETE" OWNER TO openconcerto;

--
-- TOC entry 186 (class 1259 OID 36388178)
-- Name: ACCES_SOCIETE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."ACCES_SOCIETE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."ACCES_SOCIETE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21354 (class 0 OID 0)
-- Dependencies: 186
-- Name: ACCES_SOCIETE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."ACCES_SOCIETE_ID_seq" OWNED BY "Common"."ACCES_SOCIETE"."ID";


--
-- TOC entry 187 (class 1259 OID 36388180)
-- Name: ADRESSE_COMMON; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."ADRESSE_COMMON" (
    "ID" integer NOT NULL,
    "RUE" character varying(2048) DEFAULT ''::text NOT NULL,
    "CODE_POSTAL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PAYS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "VILLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "CEDEX" integer,
    "HAS_CEDEX" boolean DEFAULT false
);


ALTER TABLE "Common"."ADRESSE_COMMON" OWNER TO openconcerto;

--
-- TOC entry 188 (class 1259 OID 36388193)
-- Name: ADRESSE_COMMON_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."ADRESSE_COMMON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."ADRESSE_COMMON_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21355 (class 0 OID 0)
-- Dependencies: 188
-- Name: ADRESSE_COMMON_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."ADRESSE_COMMON_ID_seq" OWNED BY "Common"."ADRESSE_COMMON"."ID";


--
-- TOC entry 189 (class 1259 OID 36388195)
-- Name: AYANT_DROIT_TYPE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."AYANT_DROIT_TYPE" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."AYANT_DROIT_TYPE" OWNER TO openconcerto;

--
-- TOC entry 190 (class 1259 OID 36388205)
-- Name: AYANT_DROIT_TYPE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."AYANT_DROIT_TYPE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."AYANT_DROIT_TYPE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21356 (class 0 OID 0)
-- Dependencies: 190
-- Name: AYANT_DROIT_TYPE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."AYANT_DROIT_TYPE_ID_seq" OWNED BY "Common"."AYANT_DROIT_TYPE"."ID";


--
-- TOC entry 191 (class 1259 OID 36388207)
-- Name: CAISSE_COTISATION; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."CAISSE_COTISATION" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_ADRESSE_COMMON" integer DEFAULT 1 NOT NULL,
    "TEL" character varying(32) DEFAULT ''::character varying NOT NULL,
    "MAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_PORTABLE" character varying(32) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "NUMERO_COMPTE_PCE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "NUMERO_COMPTE_PCE_CHARGES" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ORG_PROTECTION_SOCIALE" boolean DEFAULT false NOT NULL,
    "URSSAF" boolean DEFAULT false NOT NULL,
    "DGFIP" boolean DEFAULT false
);


ALTER TABLE "Common"."CAISSE_COTISATION" OWNER TO openconcerto;

--
-- TOC entry 192 (class 1259 OID 36388224)
-- Name: CAISSE_COTISATION_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."CAISSE_COTISATION_ID_seq"
    START WITH 9
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."CAISSE_COTISATION_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21357 (class 0 OID 0)
-- Dependencies: 192
-- Name: CAISSE_COTISATION_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."CAISSE_COTISATION_ID_seq" OWNED BY "Common"."CAISSE_COTISATION"."ID";


--
-- TOC entry 193 (class 1259 OID 36388226)
-- Name: CAISSE_COTISATION_RENSEIGNEMENT; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."CAISSE_COTISATION_RENSEIGNEMENT" (
    "ID" integer NOT NULL,
    "IDENTIFIANT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "SIRET" character varying(256) DEFAULT ''::character varying NOT NULL,
    "BIC" character varying(256) DEFAULT ''::character varying NOT NULL,
    "IBAN" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ENTITE_AFFECTATION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ORGANISME_COMPLEMENTAIRE" boolean DEFAULT false NOT NULL,
    "PAIEMENT_TRIMESTRIEL" boolean DEFAULT false NOT NULL,
    "CODE_DELEGATAIRE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_CAISSE_MODE_PAIEMENT" integer DEFAULT 1,
    "ID_CAISSE_COTISATION" integer DEFAULT 1,
    "ID_SOCIETE_COMMON" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "JOUR_PAIEMENT" integer DEFAULT 0 NOT NULL
);


ALTER TABLE "Common"."CAISSE_COTISATION_RENSEIGNEMENT" OWNER TO openconcerto;

--
-- TOC entry 194 (class 1259 OID 36388246)
-- Name: CAISSE_COTISATION_RENSEIGNEMENT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."CAISSE_COTISATION_RENSEIGNEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."CAISSE_COTISATION_RENSEIGNEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21358 (class 0 OID 0)
-- Dependencies: 194
-- Name: CAISSE_COTISATION_RENSEIGNEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."CAISSE_COTISATION_RENSEIGNEMENT_ID_seq" OWNED BY "Common"."CAISSE_COTISATION_RENSEIGNEMENT"."ID";


--
-- TOC entry 195 (class 1259 OID 36388248)
-- Name: CAISSE_MODE_PAIEMENT; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."CAISSE_MODE_PAIEMENT" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."CAISSE_MODE_PAIEMENT" OWNER TO openconcerto;

--
-- TOC entry 196 (class 1259 OID 36388258)
-- Name: CAISSE_MODE_PAIEMENT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."CAISSE_MODE_PAIEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."CAISSE_MODE_PAIEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21359 (class 0 OID 0)
-- Dependencies: 196
-- Name: CAISSE_MODE_PAIEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."CAISSE_MODE_PAIEMENT_ID_seq" OWNED BY "Common"."CAISSE_MODE_PAIEMENT"."ID";


--
-- TOC entry 197 (class 1259 OID 36388260)
-- Name: CODE_BASE_ASSUJETTIE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."CODE_BASE_ASSUJETTIE" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."CODE_BASE_ASSUJETTIE" OWNER TO openconcerto;

--
-- TOC entry 198 (class 1259 OID 36388270)
-- Name: CODE_BASE_ASSUJETTIE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."CODE_BASE_ASSUJETTIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."CODE_BASE_ASSUJETTIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21360 (class 0 OID 0)
-- Dependencies: 198
-- Name: CODE_BASE_ASSUJETTIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."CODE_BASE_ASSUJETTIE_ID_seq" OWNED BY "Common"."CODE_BASE_ASSUJETTIE"."ID";


--
-- TOC entry 199 (class 1259 OID 36388272)
-- Name: CODE_CAISSE_TYPE_RUBRIQUE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."CODE_CAISSE_TYPE_RUBRIQUE" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "CAISSE_COTISATION" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."CODE_CAISSE_TYPE_RUBRIQUE" OWNER TO openconcerto;

--
-- TOC entry 200 (class 1259 OID 36388283)
-- Name: CODE_CAISSE_TYPE_RUBRIQUE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."CODE_CAISSE_TYPE_RUBRIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."CODE_CAISSE_TYPE_RUBRIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21361 (class 0 OID 0)
-- Dependencies: 200
-- Name: CODE_CAISSE_TYPE_RUBRIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."CODE_CAISSE_TYPE_RUBRIQUE_ID_seq" OWNED BY "Common"."CODE_CAISSE_TYPE_RUBRIQUE"."ID";


--
-- TOC entry 201 (class 1259 OID 36388285)
-- Name: CODE_COTISATION_ETABLISSEMENT; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."CODE_COTISATION_ETABLISSEMENT" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."CODE_COTISATION_ETABLISSEMENT" OWNER TO openconcerto;

--
-- TOC entry 202 (class 1259 OID 36388295)
-- Name: CODE_COTISATION_ETABLISSEMENT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."CODE_COTISATION_ETABLISSEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."CODE_COTISATION_ETABLISSEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21362 (class 0 OID 0)
-- Dependencies: 202
-- Name: CODE_COTISATION_ETABLISSEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."CODE_COTISATION_ETABLISSEMENT_ID_seq" OWNED BY "Common"."CODE_COTISATION_ETABLISSEMENT"."ID";


--
-- TOC entry 203 (class 1259 OID 36388297)
-- Name: CODE_COTISATION_INDIVIDUELLE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."CODE_COTISATION_INDIVIDUELLE" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."CODE_COTISATION_INDIVIDUELLE" OWNER TO openconcerto;

--
-- TOC entry 204 (class 1259 OID 36388307)
-- Name: CODE_COTISATION_INDIVIDUELLE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."CODE_COTISATION_INDIVIDUELLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."CODE_COTISATION_INDIVIDUELLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21363 (class 0 OID 0)
-- Dependencies: 204
-- Name: CODE_COTISATION_INDIVIDUELLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."CODE_COTISATION_INDIVIDUELLE_ID_seq" OWNED BY "Common"."CODE_COTISATION_INDIVIDUELLE"."ID";


--
-- TOC entry 205 (class 1259 OID 36388309)
-- Name: CODE_PENIBILITE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."CODE_PENIBILITE" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."CODE_PENIBILITE" OWNER TO openconcerto;

--
-- TOC entry 206 (class 1259 OID 36388319)
-- Name: CODE_PENIBILITE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."CODE_PENIBILITE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."CODE_PENIBILITE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21364 (class 0 OID 0)
-- Dependencies: 206
-- Name: CODE_PENIBILITE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."CODE_PENIBILITE_ID_seq" OWNED BY "Common"."CODE_PENIBILITE"."ID";


--
-- TOC entry 207 (class 1259 OID 36388321)
-- Name: CODE_TYPE_RUBRIQUE_BRUT; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."CODE_TYPE_RUBRIQUE_BRUT" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "TYPE" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."CODE_TYPE_RUBRIQUE_BRUT" OWNER TO openconcerto;

--
-- TOC entry 208 (class 1259 OID 36388332)
-- Name: CODE_TYPE_RUBRIQUE_BRUT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."CODE_TYPE_RUBRIQUE_BRUT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."CODE_TYPE_RUBRIQUE_BRUT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21365 (class 0 OID 0)
-- Dependencies: 208
-- Name: CODE_TYPE_RUBRIQUE_BRUT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."CODE_TYPE_RUBRIQUE_BRUT_ID_seq" OWNED BY "Common"."CODE_TYPE_RUBRIQUE_BRUT"."ID";


--
-- TOC entry 209 (class 1259 OID 36388334)
-- Name: COMPLETION; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."COMPLETION" (
    "CHAMP" character varying(100) DEFAULT ''::character varying NOT NULL,
    "LABEL" character varying(200) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Common"."COMPLETION" OWNER TO openconcerto;

--
-- TOC entry 210 (class 1259 OID 36388339)
-- Name: COMPTE_PCE_DEFAULT; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."COMPTE_PCE_DEFAULT" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "NUMERO_DEFAULT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."COMPTE_PCE_DEFAULT" OWNER TO openconcerto;

--
-- TOC entry 211 (class 1259 OID 36388346)
-- Name: COMPTE_PCE_DEFAULT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."COMPTE_PCE_DEFAULT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."COMPTE_PCE_DEFAULT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21366 (class 0 OID 0)
-- Dependencies: 211
-- Name: COMPTE_PCE_DEFAULT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."COMPTE_PCE_DEFAULT_ID_seq" OWNED BY "Common"."COMPTE_PCE_DEFAULT"."ID";


--
-- TOC entry 212 (class 1259 OID 36388348)
-- Name: CONNEXION; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."CONNEXION" (
    "LOGIN" character varying(45),
    "MDP" character varying(2048),
    "DATE" timestamp with time zone,
    "IP" character varying(2048),
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID" integer NOT NULL,
    "FAILED" boolean DEFAULT false
);


ALTER TABLE "Common"."CONNEXION" OWNER TO openconcerto;

--
-- TOC entry 213 (class 1259 OID 36388357)
-- Name: CONNEXION_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."CONNEXION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."CONNEXION_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21367 (class 0 OID 0)
-- Dependencies: 213
-- Name: CONNEXION_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."CONNEXION_ID_seq" OWNED BY "Common"."CONNEXION"."ID";


--
-- TOC entry 214 (class 1259 OID 36388359)
-- Name: CONTRAT_DETACHE_EXPATRIE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."CONTRAT_DETACHE_EXPATRIE" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."CONTRAT_DETACHE_EXPATRIE" OWNER TO openconcerto;

--
-- TOC entry 215 (class 1259 OID 36388369)
-- Name: CONTRAT_DETACHE_EXPATRIE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."CONTRAT_DETACHE_EXPATRIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."CONTRAT_DETACHE_EXPATRIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21368 (class 0 OID 0)
-- Dependencies: 215
-- Name: CONTRAT_DETACHE_EXPATRIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."CONTRAT_DETACHE_EXPATRIE_ID_seq" OWNED BY "Common"."CONTRAT_DETACHE_EXPATRIE"."ID";


--
-- TOC entry 216 (class 1259 OID 36388371)
-- Name: CONTRAT_DISPOSITIF_POLITIQUE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."CONTRAT_DISPOSITIF_POLITIQUE" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."CONTRAT_DISPOSITIF_POLITIQUE" OWNER TO openconcerto;

--
-- TOC entry 217 (class 1259 OID 36388381)
-- Name: CONTRAT_DISPOSITIF_POLITIQUE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."CONTRAT_DISPOSITIF_POLITIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."CONTRAT_DISPOSITIF_POLITIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21369 (class 0 OID 0)
-- Dependencies: 217
-- Name: CONTRAT_DISPOSITIF_POLITIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."CONTRAT_DISPOSITIF_POLITIQUE_ID_seq" OWNED BY "Common"."CONTRAT_DISPOSITIF_POLITIQUE"."ID";


--
-- TOC entry 218 (class 1259 OID 36388383)
-- Name: CONTRAT_MODALITE_TEMPS; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."CONTRAT_MODALITE_TEMPS" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."CONTRAT_MODALITE_TEMPS" OWNER TO openconcerto;

--
-- TOC entry 219 (class 1259 OID 36388393)
-- Name: CONTRAT_MODALITE_TEMPS_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."CONTRAT_MODALITE_TEMPS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."CONTRAT_MODALITE_TEMPS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21370 (class 0 OID 0)
-- Dependencies: 219
-- Name: CONTRAT_MODALITE_TEMPS_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."CONTRAT_MODALITE_TEMPS_ID_seq" OWNED BY "Common"."CONTRAT_MODALITE_TEMPS"."ID";


--
-- TOC entry 220 (class 1259 OID 36388395)
-- Name: CONTRAT_MOTIF_RECOURS; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."CONTRAT_MOTIF_RECOURS" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."CONTRAT_MOTIF_RECOURS" OWNER TO openconcerto;

--
-- TOC entry 221 (class 1259 OID 36388405)
-- Name: CONTRAT_MOTIF_RECOURS_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."CONTRAT_MOTIF_RECOURS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."CONTRAT_MOTIF_RECOURS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21371 (class 0 OID 0)
-- Dependencies: 221
-- Name: CONTRAT_MOTIF_RECOURS_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."CONTRAT_MOTIF_RECOURS_ID_seq" OWNED BY "Common"."CONTRAT_MOTIF_RECOURS"."ID";


--
-- TOC entry 222 (class 1259 OID 36388407)
-- Name: CONTRAT_REGIME_MALADIE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."CONTRAT_REGIME_MALADIE" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."CONTRAT_REGIME_MALADIE" OWNER TO openconcerto;

--
-- TOC entry 223 (class 1259 OID 36388417)
-- Name: CONTRAT_REGIME_MALADIE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."CONTRAT_REGIME_MALADIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."CONTRAT_REGIME_MALADIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21372 (class 0 OID 0)
-- Dependencies: 223
-- Name: CONTRAT_REGIME_MALADIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."CONTRAT_REGIME_MALADIE_ID_seq" OWNED BY "Common"."CONTRAT_REGIME_MALADIE"."ID";


--
-- TOC entry 224 (class 1259 OID 36388419)
-- Name: CONTRAT_REGIME_VIEILLESSE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."CONTRAT_REGIME_VIEILLESSE" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."CONTRAT_REGIME_VIEILLESSE" OWNER TO openconcerto;

--
-- TOC entry 225 (class 1259 OID 36388429)
-- Name: CONTRAT_REGIME_VIEILLESSE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."CONTRAT_REGIME_VIEILLESSE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."CONTRAT_REGIME_VIEILLESSE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21373 (class 0 OID 0)
-- Dependencies: 225
-- Name: CONTRAT_REGIME_VIEILLESSE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."CONTRAT_REGIME_VIEILLESSE_ID_seq" OWNED BY "Common"."CONTRAT_REGIME_VIEILLESSE"."ID";


--
-- TOC entry 226 (class 1259 OID 36388431)
-- Name: DEVISE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."DEVISE" (
    "ID" integer NOT NULL,
    "CODE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "LIBELLE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "LIBELLE_CENT" character varying(128) DEFAULT ''::character varying NOT NULL,
    "TAUX" numeric(16,8) DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "TAUX_COMMERCIAL" numeric(16,8) DEFAULT 1 NOT NULL
);


ALTER TABLE "Common"."DEVISE" OWNER TO openconcerto;

--
-- TOC entry 227 (class 1259 OID 36388445)
-- Name: DEVISE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."DEVISE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."DEVISE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21374 (class 0 OID 0)
-- Dependencies: 227
-- Name: DEVISE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."DEVISE_ID_seq" OWNED BY "Common"."DEVISE"."ID";


--
-- TOC entry 228 (class 1259 OID 36388447)
-- Name: DSN_NATURE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."DSN_NATURE" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."DSN_NATURE" OWNER TO openconcerto;

--
-- TOC entry 229 (class 1259 OID 36388457)
-- Name: DSN_NATURE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."DSN_NATURE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."DSN_NATURE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21375 (class 0 OID 0)
-- Dependencies: 229
-- Name: DSN_NATURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."DSN_NATURE_ID_seq" OWNED BY "Common"."DSN_NATURE"."ID";


--
-- TOC entry 230 (class 1259 OID 36388459)
-- Name: DSN_REGIME_LOCAL; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."DSN_REGIME_LOCAL" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."DSN_REGIME_LOCAL" OWNER TO openconcerto;

--
-- TOC entry 231 (class 1259 OID 36388469)
-- Name: DSN_REGIME_LOCAL_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."DSN_REGIME_LOCAL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."DSN_REGIME_LOCAL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21376 (class 0 OID 0)
-- Dependencies: 231
-- Name: DSN_REGIME_LOCAL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."DSN_REGIME_LOCAL_ID_seq" OWNED BY "Common"."DSN_REGIME_LOCAL"."ID";


--
-- TOC entry 232 (class 1259 OID 36388471)
-- Name: DSN_TYPE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."DSN_TYPE" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."DSN_TYPE" OWNER TO openconcerto;

--
-- TOC entry 233 (class 1259 OID 36388481)
-- Name: DSN_TYPE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."DSN_TYPE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."DSN_TYPE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21377 (class 0 OID 0)
-- Dependencies: 233
-- Name: DSN_TYPE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."DSN_TYPE_ID_seq" OWNED BY "Common"."DSN_TYPE"."ID";


--
-- TOC entry 234 (class 1259 OID 36388483)
-- Name: ECO_CONTRIBUTION; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."ECO_CONTRIBUTION" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ID_FAMILLE_ECO_CONTRIBUTION" integer DEFAULT 1,
    "TAUX" numeric(16,2) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."ECO_CONTRIBUTION" OWNER TO openconcerto;

--
-- TOC entry 235 (class 1259 OID 36388495)
-- Name: ECO_CONTRIBUTION_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."ECO_CONTRIBUTION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."ECO_CONTRIBUTION_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21378 (class 0 OID 0)
-- Dependencies: 235
-- Name: ECO_CONTRIBUTION_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."ECO_CONTRIBUTION_ID_seq" OWNED BY "Common"."ECO_CONTRIBUTION"."ID";


--
-- TOC entry 236 (class 1259 OID 36388497)
-- Name: EXERCICE_COMMON; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."EXERCICE_COMMON" (
    "ID" integer NOT NULL,
    "DATE_DEB" date,
    "DATE_FIN" date,
    "NUMERO" integer DEFAULT 1 NOT NULL,
    "CLOTURE" boolean DEFAULT false NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "DATE_CLOTURE" date,
    "ID_SOCIETE_COMMON" integer DEFAULT 1
);


ALTER TABLE "Common"."EXERCICE_COMMON" OWNER TO openconcerto;

--
-- TOC entry 237 (class 1259 OID 36388505)
-- Name: EXERCICE_COMMON_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."EXERCICE_COMMON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."EXERCICE_COMMON_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21379 (class 0 OID 0)
-- Dependencies: 237
-- Name: EXERCICE_COMMON_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."EXERCICE_COMMON_ID_seq" OWNED BY "Common"."EXERCICE_COMMON"."ID";


--
-- TOC entry 238 (class 1259 OID 36388507)
-- Name: FAMILLE_ECO_CONTRIBUTION; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."FAMILLE_ECO_CONTRIBUTION" (
    "ID" integer NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."FAMILLE_ECO_CONTRIBUTION" OWNER TO openconcerto;

--
-- TOC entry 239 (class 1259 OID 36388516)
-- Name: FAMILLE_ECO_CONTRIBUTION_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."FAMILLE_ECO_CONTRIBUTION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."FAMILLE_ECO_CONTRIBUTION_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21380 (class 0 OID 0)
-- Dependencies: 239
-- Name: FAMILLE_ECO_CONTRIBUTION_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."FAMILLE_ECO_CONTRIBUTION_ID_seq" OWNED BY "Common"."FAMILLE_ECO_CONTRIBUTION"."ID";


--
-- TOC entry 240 (class 1259 OID 36388518)
-- Name: FWK_RIV_METADATA; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."FWK_RIV_METADATA" (
    "ID" integer NOT NULL,
    "ELEMENT_CODE" character varying(80),
    "COMPONENT_CODE" character varying(80),
    "ITEM" character varying(80) NOT NULL,
    "LABEL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "COLUMN_TITLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DOCUMENTATION" character varying(8192) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Common"."FWK_RIV_METADATA" OWNER TO openconcerto;

--
-- TOC entry 241 (class 1259 OID 36388527)
-- Name: FWK_RIV_METADATA_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."FWK_RIV_METADATA_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."FWK_RIV_METADATA_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21381 (class 0 OID 0)
-- Dependencies: 241
-- Name: FWK_RIV_METADATA_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."FWK_RIV_METADATA_ID_seq" OWNED BY "Common"."FWK_RIV_METADATA"."ID";


--
-- TOC entry 242 (class 1259 OID 36388529)
-- Name: FWK_SCHEMA_METADATA; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."FWK_SCHEMA_METADATA" (
    "NAME" character varying(100) DEFAULT ''::character varying NOT NULL,
    "VALUE" character varying(250) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Common"."FWK_SCHEMA_METADATA" OWNER TO openconcerto;

--
-- TOC entry 243 (class 1259 OID 36388534)
-- Name: FWK_UNDEFINED_IDS; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."FWK_UNDEFINED_IDS" (
    "TABLENAME" character varying(250) DEFAULT ''::character varying NOT NULL,
    "UNDEFINED_ID" integer
);


ALTER TABLE "Common"."FWK_UNDEFINED_IDS" OWNER TO openconcerto;

--
-- TOC entry 244 (class 1259 OID 36388538)
-- Name: IMPRESSION_RUBRIQUE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."IMPRESSION_RUBRIQUE" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."IMPRESSION_RUBRIQUE" OWNER TO openconcerto;

--
-- TOC entry 245 (class 1259 OID 36388544)
-- Name: IMPRESSION_RUBRIQUE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."IMPRESSION_RUBRIQUE_ID_seq"
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."IMPRESSION_RUBRIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21382 (class 0 OID 0)
-- Dependencies: 245
-- Name: IMPRESSION_RUBRIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."IMPRESSION_RUBRIQUE_ID_seq" OWNED BY "Common"."IMPRESSION_RUBRIQUE"."ID";


--
-- TOC entry 246 (class 1259 OID 36388546)
-- Name: INDICE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."INDICE" (
    "ANNEE" integer,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "JANVIER" bigint DEFAULT 0,
    "FEVRIER" bigint DEFAULT 0,
    "MARS" bigint DEFAULT 0,
    "AVRIL" bigint DEFAULT 0,
    "MAI" bigint DEFAULT 0,
    "JUIN" bigint DEFAULT 0,
    "JUILLET" bigint DEFAULT 0,
    "AOUT" bigint DEFAULT 0,
    "SEPTEMBRE" bigint DEFAULT 0,
    "OCTOBRE" bigint DEFAULT 0,
    "NOVEMBRE" bigint DEFAULT 0,
    "DECEMBRE" bigint DEFAULT 0
);


ALTER TABLE "Common"."INDICE" OWNER TO openconcerto;

--
-- TOC entry 247 (class 1259 OID 36388563)
-- Name: INDICE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."INDICE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."INDICE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21383 (class 0 OID 0)
-- Dependencies: 247
-- Name: INDICE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."INDICE_ID_seq" OWNED BY "Common"."INDICE"."ID";


--
-- TOC entry 248 (class 1259 OID 36388565)
-- Name: MOTIF_ARRET_TRAVAIL; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."MOTIF_ARRET_TRAVAIL" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."MOTIF_ARRET_TRAVAIL" OWNER TO openconcerto;

--
-- TOC entry 249 (class 1259 OID 36388575)
-- Name: MOTIF_ARRET_TRAVAIL_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."MOTIF_ARRET_TRAVAIL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."MOTIF_ARRET_TRAVAIL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21384 (class 0 OID 0)
-- Dependencies: 249
-- Name: MOTIF_ARRET_TRAVAIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."MOTIF_ARRET_TRAVAIL_ID_seq" OWNED BY "Common"."MOTIF_ARRET_TRAVAIL"."ID";


--
-- TOC entry 250 (class 1259 OID 36388577)
-- Name: MOTIF_FIN_CONTRAT; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."MOTIF_FIN_CONTRAT" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."MOTIF_FIN_CONTRAT" OWNER TO openconcerto;

--
-- TOC entry 251 (class 1259 OID 36388587)
-- Name: MOTIF_FIN_CONTRAT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."MOTIF_FIN_CONTRAT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."MOTIF_FIN_CONTRAT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21385 (class 0 OID 0)
-- Dependencies: 251
-- Name: MOTIF_FIN_CONTRAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."MOTIF_FIN_CONTRAT_ID_seq" OWNED BY "Common"."MOTIF_FIN_CONTRAT"."ID";


--
-- TOC entry 252 (class 1259 OID 36388589)
-- Name: MOTIF_REPRISE_ARRET_TRAVAIL; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."MOTIF_REPRISE_ARRET_TRAVAIL" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."MOTIF_REPRISE_ARRET_TRAVAIL" OWNER TO openconcerto;

--
-- TOC entry 253 (class 1259 OID 36388599)
-- Name: MOTIF_REPRISE_ARRET_TRAVAIL_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."MOTIF_REPRISE_ARRET_TRAVAIL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."MOTIF_REPRISE_ARRET_TRAVAIL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21386 (class 0 OID 0)
-- Dependencies: 253
-- Name: MOTIF_REPRISE_ARRET_TRAVAIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."MOTIF_REPRISE_ARRET_TRAVAIL_ID_seq" OWNED BY "Common"."MOTIF_REPRISE_ARRET_TRAVAIL"."ID";


--
-- TOC entry 254 (class 1259 OID 36388601)
-- Name: OBJET; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."OBJET" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."OBJET" OWNER TO openconcerto;

--
-- TOC entry 255 (class 1259 OID 36388611)
-- Name: OBJET_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."OBJET_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."OBJET_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21387 (class 0 OID 0)
-- Dependencies: 255
-- Name: OBJET_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."OBJET_ID_seq" OWNED BY "Common"."OBJET"."ID";


--
-- TOC entry 256 (class 1259 OID 36388613)
-- Name: PERIODE_VALIDITE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."PERIODE_VALIDITE" (
    "ID" integer NOT NULL,
    "JANVIER" boolean DEFAULT true NOT NULL,
    "FEVRIER" boolean DEFAULT true NOT NULL,
    "MARS" boolean DEFAULT true NOT NULL,
    "AVRIL" boolean DEFAULT true NOT NULL,
    "MAI" boolean DEFAULT true NOT NULL,
    "JUIN" boolean DEFAULT true NOT NULL,
    "JUILLET" boolean DEFAULT true NOT NULL,
    "AOUT" boolean DEFAULT true NOT NULL,
    "SEPTEMBRE" boolean DEFAULT true NOT NULL,
    "OCTOBRE" boolean DEFAULT true NOT NULL,
    "NOVEMBRE" boolean DEFAULT true NOT NULL,
    "DECEMBRE" boolean DEFAULT true NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."PERIODE_VALIDITE" OWNER TO openconcerto;

--
-- TOC entry 257 (class 1259 OID 36388630)
-- Name: PERIODE_VALIDITE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."PERIODE_VALIDITE_ID_seq"
    START WITH 95
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."PERIODE_VALIDITE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21388 (class 0 OID 0)
-- Dependencies: 257
-- Name: PERIODE_VALIDITE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."PERIODE_VALIDITE_ID_seq" OWNED BY "Common"."PERIODE_VALIDITE"."ID";


--
-- TOC entry 258 (class 1259 OID 36388632)
-- Name: PREF_NODE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."PREF_NODE" (
    "ID" integer NOT NULL,
    "ID_PARENT" integer,
    "NAME" character varying(80) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Common"."PREF_NODE" OWNER TO openconcerto;

--
-- TOC entry 259 (class 1259 OID 36388636)
-- Name: PREF_NODE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."PREF_NODE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."PREF_NODE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21389 (class 0 OID 0)
-- Dependencies: 259
-- Name: PREF_NODE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."PREF_NODE_ID_seq" OWNED BY "Common"."PREF_NODE"."ID";


--
-- TOC entry 260 (class 1259 OID 36388638)
-- Name: PREF_VALUE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."PREF_VALUE" (
    "ID_NODE" integer NOT NULL,
    "NAME" character varying(80) DEFAULT ''::character varying NOT NULL,
    "VALUE" character varying(8192) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Common"."PREF_VALUE" OWNER TO openconcerto;

--
-- TOC entry 261 (class 1259 OID 36388646)
-- Name: PROFIL_PAYE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."PROFIL_PAYE" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."PROFIL_PAYE" OWNER TO openconcerto;

--
-- TOC entry 262 (class 1259 OID 36388652)
-- Name: PROFIL_PAYE_ELEMENT; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."PROFIL_PAYE_ELEMENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_PROFIL_PAYE" integer DEFAULT 1 NOT NULL,
    "SOURCE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "IDSOURCE" integer DEFAULT 1 NOT NULL,
    "POSITION" integer DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."PROFIL_PAYE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 263 (class 1259 OID 36388662)
-- Name: PROFIL_PAYE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."PROFIL_PAYE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."PROFIL_PAYE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21390 (class 0 OID 0)
-- Dependencies: 263
-- Name: PROFIL_PAYE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."PROFIL_PAYE_ELEMENT_ID_seq" OWNED BY "Common"."PROFIL_PAYE_ELEMENT"."ID";


--
-- TOC entry 264 (class 1259 OID 36388664)
-- Name: PROFIL_PAYE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."PROFIL_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."PROFIL_PAYE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21391 (class 0 OID 0)
-- Dependencies: 264
-- Name: PROFIL_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."PROFIL_PAYE_ID_seq" OWNED BY "Common"."PROFIL_PAYE"."ID";


--
-- TOC entry 265 (class 1259 OID 36388666)
-- Name: RIGHT; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."RIGHT" (
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "CODE" character varying(128) DEFAULT ''::character varying,
    "NOM" character varying(256) DEFAULT ''::character varying,
    "DESCRIPTION" character varying(500) DEFAULT ''::character varying
);


ALTER TABLE "Common"."RIGHT" OWNER TO openconcerto;

--
-- TOC entry 266 (class 1259 OID 36388676)
-- Name: RIGHT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."RIGHT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."RIGHT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21392 (class 0 OID 0)
-- Dependencies: 266
-- Name: RIGHT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."RIGHT_ID_seq" OWNED BY "Common"."RIGHT"."ID";


--
-- TOC entry 267 (class 1259 OID 36388678)
-- Name: RUBRIQUE_BRUT; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."RUBRIQUE_BRUT" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "BASE" character varying(2048) DEFAULT ''::text NOT NULL,
    "TAUX" character varying(2048) DEFAULT ''::text NOT NULL,
    "MONTANT" character varying(2048) DEFAULT ''::text NOT NULL,
    "ID_PERIODE_VALIDITE" integer DEFAULT 1 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_TYPE_RUBRIQUE_BRUT" integer DEFAULT 1 NOT NULL,
    "IMPOSABLE" boolean DEFAULT false NOT NULL,
    "PART_BRUT" boolean DEFAULT false NOT NULL,
    "PART_CP" boolean DEFAULT false NOT NULL,
    "ID_IMPRESSION_RUBRIQUE" integer DEFAULT 1 NOT NULL,
    "ID_CODE_CAISSE_TYPE_RUBRIQUE" integer DEFAULT 1,
    "ID_CODE_TYPE_RUBRIQUE_BRUT" integer DEFAULT 1,
    "COTISABLE" boolean DEFAULT true NOT NULL,
    "TAXABLE_CM" boolean DEFAULT true NOT NULL,
    "AVANTAGE_NATURE" boolean DEFAULT false NOT NULL
);


ALTER TABLE "Common"."RUBRIQUE_BRUT" OWNER TO openconcerto;

--
-- TOC entry 268 (class 1259 OID 36388702)
-- Name: RUBRIQUE_BRUT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."RUBRIQUE_BRUT_ID_seq"
    START WITH 42
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."RUBRIQUE_BRUT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21393 (class 0 OID 0)
-- Dependencies: 268
-- Name: RUBRIQUE_BRUT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."RUBRIQUE_BRUT_ID_seq" OWNED BY "Common"."RUBRIQUE_BRUT"."ID";


--
-- TOC entry 269 (class 1259 OID 36388704)
-- Name: RUBRIQUE_COMM; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."RUBRIQUE_COMM" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NB_BASE" character varying(2048) DEFAULT ''::text NOT NULL,
    "TAUX_SAL" character varying(2048) DEFAULT ''::text NOT NULL,
    "TAUX_PAT" character varying(2048) DEFAULT ''::text NOT NULL,
    "MONTANT_SAL_AJ" character varying(2048) DEFAULT ''::text NOT NULL,
    "MONTANT_SAL_DED" character varying(2048) DEFAULT ''::text NOT NULL,
    "MONTANT_PAT" character varying(2048) DEFAULT ''::text NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ID_PERIODE_VALIDITE" integer DEFAULT 1 NOT NULL,
    "ID_IMPRESSION_RUBRIQUE" integer DEFAULT 1 NOT NULL,
    "NOM_VISIBLE" boolean DEFAULT true NOT NULL,
    "MONTANT" real DEFAULT 0 NOT NULL,
    "REDUCTION_GVT_COM" boolean DEFAULT false NOT NULL
);


ALTER TABLE "Common"."RUBRIQUE_COMM" OWNER TO openconcerto;

--
-- TOC entry 270 (class 1259 OID 36388725)
-- Name: RUBRIQUE_COMM_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."RUBRIQUE_COMM_ID_seq"
    START WITH 10
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."RUBRIQUE_COMM_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21394 (class 0 OID 0)
-- Dependencies: 270
-- Name: RUBRIQUE_COMM_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."RUBRIQUE_COMM_ID_seq" OWNED BY "Common"."RUBRIQUE_COMM"."ID";


--
-- TOC entry 271 (class 1259 OID 36388727)
-- Name: RUBRIQUE_COTISATION; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."RUBRIQUE_COTISATION" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_CAISSE_COTISATION" integer DEFAULT 1 NOT NULL,
    "BASE" character varying(2048) DEFAULT ''::text NOT NULL,
    "TX_SAL" character varying(2048) DEFAULT ''::text NOT NULL,
    "TX_PAT" character varying(2048) DEFAULT ''::text NOT NULL,
    "IMPOSABLE" boolean DEFAULT false NOT NULL,
    "PART_CSG" boolean DEFAULT false NOT NULL,
    "BRUT" boolean DEFAULT false NOT NULL,
    "ID_PERIODE_VALIDITE" integer DEFAULT 1 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_IMPRESSION_RUBRIQUE" integer DEFAULT 1 NOT NULL,
    "PART_CSG_SANS_ABATTEMENT" boolean DEFAULT false NOT NULL,
    "PART_PAT_IMPOSABLE" boolean DEFAULT false NOT NULL,
    "REDUCTION_FILLON" boolean DEFAULT false NOT NULL,
    "ASSIETTE_PLAFONNEE" boolean DEFAULT false NOT NULL,
    "ID_CODE_CAISSE_TYPE_RUBRIQUE" integer DEFAULT 1,
    "ID_CODE_BASE_ASSUJETTIE" integer DEFAULT 1,
    "ID_TYPE_COMPOSANT_BASE_ASSUJETTIE" integer DEFAULT 1,
    "ID_CODE_COTISATION_INDIVIDUELLE" integer DEFAULT 1,
    "ID_CODE_COTISATION_ETABLISSEMENT" integer DEFAULT 1,
    "TAXABLE_CM" boolean DEFAULT false NOT NULL,
    "ALLEGEMENT_COTISATION" boolean DEFAULT false NOT NULL,
    "LIGNE_PAYE_SIMPLIFIEE" character varying(256) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Common"."RUBRIQUE_COTISATION" OWNER TO openconcerto;

--
-- TOC entry 272 (class 1259 OID 36388758)
-- Name: RUBRIQUE_COTISATION_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."RUBRIQUE_COTISATION_ID_seq"
    START WITH 43
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."RUBRIQUE_COTISATION_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21395 (class 0 OID 0)
-- Dependencies: 272
-- Name: RUBRIQUE_COTISATION_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."RUBRIQUE_COTISATION_ID_seq" OWNED BY "Common"."RUBRIQUE_COTISATION"."ID";


--
-- TOC entry 273 (class 1259 OID 36388760)
-- Name: RUBRIQUE_NET; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."RUBRIQUE_NET" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "BASE" character varying(2048) DEFAULT ''::text NOT NULL,
    "TAUX" character varying(2048) DEFAULT ''::text NOT NULL,
    "MONTANT" character varying(2048) DEFAULT ''::text NOT NULL,
    "IMPOSABLE" boolean DEFAULT false NOT NULL,
    "FRAIS_PERS" boolean DEFAULT false NOT NULL,
    "BRUT" boolean DEFAULT false NOT NULL,
    "ID_PERIODE_VALIDITE" integer DEFAULT 1 NOT NULL,
    "ID_TYPE_RUBRIQUE_NET" integer DEFAULT 1 NOT NULL,
    "ID_IMPRESSION_RUBRIQUE" integer DEFAULT 1 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "NUMERO_COMPTE_PCE_CHARGES" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_CODE_CAISSE_TYPE_RUBRIQUE" integer DEFAULT 1,
    "ID_CODE_TYPE_RUBRIQUE_BRUT" integer DEFAULT 1,
    "ID_CODE_COTISATION_INDIVIDUELLE" integer DEFAULT 1,
    "ID_TYPE_COMPOSANT_BASE_ASSUJETTIE" integer DEFAULT 1,
    "ID_CODE_BASE_ASSUJETTIE" integer DEFAULT 1,
    "ID_CAISSE_COTISATION" integer DEFAULT 1,
    "PAS" boolean DEFAULT false,
    "PAS_CDD" boolean DEFAULT false
);


ALTER TABLE "Common"."RUBRIQUE_NET" OWNER TO openconcerto;

--
-- TOC entry 274 (class 1259 OID 36388786)
-- Name: RUBRIQUE_NET_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."RUBRIQUE_NET_ID_seq"
    START WITH 6
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."RUBRIQUE_NET_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21396 (class 0 OID 0)
-- Dependencies: 274
-- Name: RUBRIQUE_NET_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."RUBRIQUE_NET_ID_seq" OWNED BY "Common"."RUBRIQUE_NET"."ID";


--
-- TOC entry 275 (class 1259 OID 36388788)
-- Name: SERVICE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."SERVICE" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."SERVICE" OWNER TO openconcerto;

--
-- TOC entry 276 (class 1259 OID 36388798)
-- Name: SERVICE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."SERVICE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."SERVICE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21397 (class 0 OID 0)
-- Dependencies: 276
-- Name: SERVICE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."SERVICE_ID_seq" OWNED BY "Common"."SERVICE"."ID";


--
-- TOC entry 277 (class 1259 OID 36388800)
-- Name: SOCIETE_COMMON; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."SOCIETE_COMMON" (
    "ID" integer NOT NULL,
    "DATABASE_NAME" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "NUM_SIRET" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NUM_NII" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NUM_APE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_EXERCICE_COMMON" integer DEFAULT 1 NOT NULL,
    "NUM_TEL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NUM_FAX" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_ADRESSE_COMMON" integer DEFAULT 1 NOT NULL,
    "TYPE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "NUMERO_URSSAF" character varying(256) DEFAULT ''::character varying NOT NULL,
    "RCS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CAPITAL" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "IBAN" character varying(256) DEFAULT ''::character varying NOT NULL,
    "BIC" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ORG_PROTECTION_SOCIAL_ID" character varying(256) DEFAULT ''::character varying NOT NULL,
    "SITE_WEB" character varying(128) DEFAULT ''::character varying NOT NULL,
    "SEPA_CREDITOR_ID" character varying(16) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Common"."SOCIETE_COMMON" OWNER TO openconcerto;

--
-- TOC entry 278 (class 1259 OID 36388828)
-- Name: SOCIETE_COMMON_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."SOCIETE_COMMON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."SOCIETE_COMMON_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21398 (class 0 OID 0)
-- Dependencies: 278
-- Name: SOCIETE_COMMON_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."SOCIETE_COMMON_ID_seq" OWNED BY "Common"."SOCIETE_COMMON"."ID";


--
-- TOC entry 279 (class 1259 OID 36388830)
-- Name: STOCK; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."STOCK" (
    "ID" integer NOT NULL,
    "QTE_REEL" real DEFAULT 0 NOT NULL,
    "QTE_TH" real DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."STOCK" OWNER TO openconcerto;

--
-- TOC entry 280 (class 1259 OID 36388837)
-- Name: STOCK_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."STOCK_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."STOCK_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21399 (class 0 OID 0)
-- Dependencies: 280
-- Name: STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."STOCK_ID_seq" OWNED BY "Common"."STOCK"."ID";


--
-- TOC entry 281 (class 1259 OID 36388839)
-- Name: TACHE_COMMON; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."TACHE_COMMON" (
    "ID" integer NOT NULL,
    "PRIORITE" integer DEFAULT 0 NOT NULL,
    "FAIT" boolean DEFAULT false NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text NOT NULL,
    "DATE_ENTREE" timestamp without time zone,
    "DATE_FAIT" timestamp without time zone,
    "DATE_EXP" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1 NOT NULL,
    "ID_USER_COMMON_TO" integer DEFAULT 1 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "COMMENT" character varying(2048),
    "ID_USER_COMMON_ASSIGN_BY" integer DEFAULT 1,
    "ID_SOCIETE_COMMON" integer DEFAULT 1,
    "TYPE" character varying(128) DEFAULT ''::character varying,
    "COOKIE" character varying(128) DEFAULT ''::character varying
);


ALTER TABLE "Common"."TACHE_COMMON" OWNER TO openconcerto;

--
-- TOC entry 282 (class 1259 OID 36388856)
-- Name: TACHE_COMMON_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."TACHE_COMMON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."TACHE_COMMON_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21400 (class 0 OID 0)
-- Dependencies: 282
-- Name: TACHE_COMMON_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."TACHE_COMMON_ID_seq" OWNED BY "Common"."TACHE_COMMON"."ID";


--
-- TOC entry 283 (class 1259 OID 36388858)
-- Name: TACHE_LISTENER_COMMON; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."TACHE_LISTENER_COMMON" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON" integer DEFAULT 1 NOT NULL,
    "ID_USER_COMMON_LISTENTO" integer DEFAULT 1 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."TACHE_LISTENER_COMMON" OWNER TO openconcerto;

--
-- TOC entry 284 (class 1259 OID 36388865)
-- Name: TACHE_LISTENER_COMMON_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."TACHE_LISTENER_COMMON_ID_seq"
    START WITH 4
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."TACHE_LISTENER_COMMON_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21401 (class 0 OID 0)
-- Dependencies: 284
-- Name: TACHE_LISTENER_COMMON_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."TACHE_LISTENER_COMMON_ID_seq" OWNED BY "Common"."TACHE_LISTENER_COMMON"."ID";


--
-- TOC entry 285 (class 1259 OID 36388867)
-- Name: TACHE_RIGHTS; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."TACHE_RIGHTS" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON" integer DEFAULT 1 NOT NULL,
    "ID_USER_COMMON_TO" integer DEFAULT 1 NOT NULL,
    "READ" boolean DEFAULT false NOT NULL,
    "MODIFY" boolean DEFAULT false NOT NULL,
    "ADD" boolean DEFAULT false NOT NULL,
    "VALIDATE" boolean DEFAULT false NOT NULL,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "Common"."TACHE_RIGHTS" OWNER TO openconcerto;

--
-- TOC entry 286 (class 1259 OID 36388877)
-- Name: TACHE_RIGHTS_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."TACHE_RIGHTS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."TACHE_RIGHTS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21402 (class 0 OID 0)
-- Dependencies: 286
-- Name: TACHE_RIGHTS_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."TACHE_RIGHTS_ID_seq" OWNED BY "Common"."TACHE_RIGHTS"."ID";


--
-- TOC entry 287 (class 1259 OID 36388879)
-- Name: TYPE_COMPOSANT_BASE_ASSUJETTIE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."TYPE_COMPOSANT_BASE_ASSUJETTIE" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."TYPE_COMPOSANT_BASE_ASSUJETTIE" OWNER TO openconcerto;

--
-- TOC entry 288 (class 1259 OID 36388889)
-- Name: TYPE_COMPOSANT_BASE_ASSUJETTIE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."TYPE_COMPOSANT_BASE_ASSUJETTIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."TYPE_COMPOSANT_BASE_ASSUJETTIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21403 (class 0 OID 0)
-- Dependencies: 288
-- Name: TYPE_COMPOSANT_BASE_ASSUJETTIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."TYPE_COMPOSANT_BASE_ASSUJETTIE_ID_seq" OWNED BY "Common"."TYPE_COMPOSANT_BASE_ASSUJETTIE"."ID";


--
-- TOC entry 289 (class 1259 OID 36388891)
-- Name: TYPE_MODELE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."TYPE_MODELE" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "TABLE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "DEFAULT_MODELE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."TYPE_MODELE" OWNER TO openconcerto;

--
-- TOC entry 290 (class 1259 OID 36388899)
-- Name: TYPE_MODELE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."TYPE_MODELE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."TYPE_MODELE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21404 (class 0 OID 0)
-- Dependencies: 290
-- Name: TYPE_MODELE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."TYPE_MODELE_ID_seq" OWNED BY "Common"."TYPE_MODELE"."ID";


--
-- TOC entry 291 (class 1259 OID 36388901)
-- Name: TYPE_PREAVIS; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."TYPE_PREAVIS" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Common"."TYPE_PREAVIS" OWNER TO openconcerto;

--
-- TOC entry 292 (class 1259 OID 36388911)
-- Name: TYPE_PREAVIS_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."TYPE_PREAVIS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."TYPE_PREAVIS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21405 (class 0 OID 0)
-- Dependencies: 292
-- Name: TYPE_PREAVIS_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."TYPE_PREAVIS_ID_seq" OWNED BY "Common"."TYPE_PREAVIS"."ID";


--
-- TOC entry 293 (class 1259 OID 36388913)
-- Name: TYPE_RUBRIQUE_BRUT; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."TYPE_RUBRIQUE_BRUT" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 1 NOT NULL
);


ALTER TABLE "Common"."TYPE_RUBRIQUE_BRUT" OWNER TO openconcerto;

--
-- TOC entry 294 (class 1259 OID 36388919)
-- Name: TYPE_RUBRIQUE_BRUT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."TYPE_RUBRIQUE_BRUT_ID_seq"
    START WITH 6
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."TYPE_RUBRIQUE_BRUT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21406 (class 0 OID 0)
-- Dependencies: 294
-- Name: TYPE_RUBRIQUE_BRUT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."TYPE_RUBRIQUE_BRUT_ID_seq" OWNED BY "Common"."TYPE_RUBRIQUE_BRUT"."ID";


--
-- TOC entry 295 (class 1259 OID 36388921)
-- Name: TYPE_RUBRIQUE_NET; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."TYPE_RUBRIQUE_NET" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."TYPE_RUBRIQUE_NET" OWNER TO openconcerto;

--
-- TOC entry 296 (class 1259 OID 36388927)
-- Name: TYPE_RUBRIQUE_NET_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."TYPE_RUBRIQUE_NET_ID_seq"
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."TYPE_RUBRIQUE_NET_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21407 (class 0 OID 0)
-- Dependencies: 296
-- Name: TYPE_RUBRIQUE_NET_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."TYPE_RUBRIQUE_NET_ID_seq" OWNED BY "Common"."TYPE_RUBRIQUE_NET"."ID";


--
-- TOC entry 1276 (class 1259 OID 36414191)
-- Name: TYPE_TAUX_PAS; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."TYPE_TAUX_PAS" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Common"."TYPE_TAUX_PAS" OWNER TO openconcerto;

--
-- TOC entry 1275 (class 1259 OID 36414189)
-- Name: TYPE_TAUX_PAS_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."TYPE_TAUX_PAS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."TYPE_TAUX_PAS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21408 (class 0 OID 0)
-- Dependencies: 1275
-- Name: TYPE_TAUX_PAS_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."TYPE_TAUX_PAS_ID_seq" OWNED BY "Common"."TYPE_TAUX_PAS"."ID";


--
-- TOC entry 297 (class 1259 OID 36388929)
-- Name: USER_COMMON; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."USER_COMMON" (
    "ID" integer NOT NULL,
    "LOGIN" character varying(128) DEFAULT ''::character varying NOT NULL,
    "PASSWORD" character varying(128) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "PRENOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "SURNOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "SUPERUSER" boolean DEFAULT false,
    "ADMIN" boolean DEFAULT false,
    "MAIL" character varying(2048) DEFAULT ''::text,
    "DISABLED" boolean DEFAULT false NOT NULL,
    "TEL" character varying(128) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Common"."USER_COMMON" OWNER TO openconcerto;

--
-- TOC entry 298 (class 1259 OID 36388947)
-- Name: USER_COMMON_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."USER_COMMON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."USER_COMMON_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21409 (class 0 OID 0)
-- Dependencies: 298
-- Name: USER_COMMON_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."USER_COMMON_ID_seq" OWNED BY "Common"."USER_COMMON"."ID";


--
-- TOC entry 299 (class 1259 OID 36388949)
-- Name: USER_RIGHT; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."USER_RIGHT" (
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON" integer DEFAULT 1,
    "HAVE_RIGHT" boolean,
    "CODE" character varying(128) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying,
    "DESCRIPTION" character varying(500) DEFAULT ''::character varying,
    "ID_RIGHT" integer DEFAULT 1,
    "OBJECT" character varying(256)
);


ALTER TABLE "Common"."USER_RIGHT" OWNER TO openconcerto;

--
-- TOC entry 300 (class 1259 OID 36388961)
-- Name: USER_RIGHT_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."USER_RIGHT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."USER_RIGHT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21410 (class 0 OID 0)
-- Dependencies: 300
-- Name: USER_RIGHT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."USER_RIGHT_ID_seq" OWNED BY "Common"."USER_RIGHT"."ID";


--
-- TOC entry 301 (class 1259 OID 36388963)
-- Name: VARIABLE_PAYE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."VARIABLE_PAYE" (
    "ID" integer NOT NULL,
    "VALEUR" real DEFAULT 0 NOT NULL,
    "FORMULE" character varying(2048) DEFAULT ''::text NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "CATEGORIE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "INFOS" character varying(2048) DEFAULT ''::text NOT NULL
);


ALTER TABLE "Common"."VARIABLE_PAYE" OWNER TO openconcerto;

--
-- TOC entry 302 (class 1259 OID 36388976)
-- Name: VARIABLE_PAYE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."VARIABLE_PAYE_ID_seq"
    START WITH 51
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."VARIABLE_PAYE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21411 (class 0 OID 0)
-- Dependencies: 302
-- Name: VARIABLE_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."VARIABLE_PAYE_ID_seq" OWNED BY "Common"."VARIABLE_PAYE"."ID";


--
-- TOC entry 303 (class 1259 OID 36388978)
-- Name: VILLE; Type: TABLE; Schema: Common; Owner: openconcerto
--

CREATE TABLE "Common"."VILLE" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048),
    "CODE_POSTAL" character varying(2048),
    "X_LAMBERT" bigint DEFAULT 0,
    "Y_LAMBERT" bigint DEFAULT 0,
    "POPULATION" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "Common"."VILLE" OWNER TO openconcerto;

--
-- TOC entry 304 (class 1259 OID 36388989)
-- Name: VILLE_ID_seq; Type: SEQUENCE; Schema: Common; Owner: openconcerto
--

CREATE SEQUENCE "Common"."VILLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Common"."VILLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21412 (class 0 OID 0)
-- Dependencies: 304
-- Name: VILLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Common; Owner: openconcerto
--

ALTER SEQUENCE "Common"."VILLE_ID_seq" OWNED BY "Common"."VILLE"."ID";


--
-- TOC entry 305 (class 1259 OID 36388991)
-- Name: ACOMPTE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ACOMPTE" (
    "ID" integer NOT NULL,
    "ID_SALARIE" integer DEFAULT 1,
    "MONTANT" real DEFAULT 0,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."ACOMPTE" OWNER TO openconcerto;

--
-- TOC entry 306 (class 1259 OID 36389000)
-- Name: ACOMPTE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ACOMPTE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ACOMPTE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21413 (class 0 OID 0)
-- Dependencies: 306
-- Name: ACOMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ACOMPTE_ID_seq" OWNED BY "Default"."ACOMPTE"."ID";


--
-- TOC entry 307 (class 1259 OID 36389002)
-- Name: ADRESSE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ADRESSE" (
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_ADRESSE" integer NOT NULL,
    "RUE" character varying(2048) DEFAULT ''::text,
    "PAYS" character varying(100) DEFAULT ''::character varying,
    "VILLE" character varying(2048) DEFAULT ''::text,
    "HAS_CEDEX" boolean DEFAULT false,
    "CEDEX" integer,
    "DEST" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_CLIENT" integer DEFAULT 1,
    "CODE_POSTAL" character varying(256) DEFAULT ''::character varying,
    "PROVINCE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "LIBELLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TYPE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "EMAIL_CONTACT" character varying(256) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Default"."ADRESSE" OWNER TO openconcerto;

--
-- TOC entry 308 (class 1259 OID 36389022)
-- Name: ADRESSE_ID_ADRESSE_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ADRESSE_ID_ADRESSE_seq"
    START WITH 9
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ADRESSE_ID_ADRESSE_seq" OWNER TO openconcerto;

--
-- TOC entry 21414 (class 0 OID 0)
-- Dependencies: 308
-- Name: ADRESSE_ID_ADRESSE_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ADRESSE_ID_ADRESSE_seq" OWNED BY "Default"."ADRESSE"."ID_ADRESSE";


--
-- TOC entry 309 (class 1259 OID 36389024)
-- Name: ARRET_TRAVAIL; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ARRET_TRAVAIL" (
    "ID" integer NOT NULL,
    "ID_SALARIE" integer DEFAULT 1,
    "DATE_DERNIER_JOUR_TRAV" timestamp without time zone,
    "DATE_FIN_PREV" timestamp without time zone,
    "SUBROGATION" boolean DEFAULT false NOT NULL,
    "DATE_DEBUT_SUBROGATION" timestamp without time zone,
    "DATE_FIN_SUBROGATION" timestamp without time zone,
    "ID_MOTIF_ARRET_TRAVAIL" integer DEFAULT 1,
    "ID_MOTIF_REPRISE_ARRET_TRAVAIL" integer DEFAULT 1,
    "DATE_REPRISE" timestamp without time zone,
    "DATE_ACCIDENT" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "DATE" timestamp without time zone,
    "COMMENTAIRES" character varying(2048) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Default"."ARRET_TRAVAIL" OWNER TO openconcerto;

--
-- TOC entry 310 (class 1259 OID 36389037)
-- Name: ARRET_TRAVAIL_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ARRET_TRAVAIL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ARRET_TRAVAIL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21415 (class 0 OID 0)
-- Dependencies: 310
-- Name: ARRET_TRAVAIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ARRET_TRAVAIL_ID_seq" OWNED BY "Default"."ARRET_TRAVAIL"."ID";


--
-- TOC entry 311 (class 1259 OID 36389039)
-- Name: ARTICLE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ARTICLE" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "CREATION_AUTO" boolean DEFAULT false,
    "PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_STOCK" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "SERVICE" boolean DEFAULT false NOT NULL,
    "OBSOLETE" boolean DEFAULT false,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "CODE_BARRE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "GESTION_STOCK" boolean DEFAULT true,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "QTE_MIN" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_DEVISE_HA" integer DEFAULT 1,
    "PA_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "SKU" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ID_TAXE_COMPLEMENTAIRE" integer DEFAULT 1,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "ID_FABRICANT" integer DEFAULT 1,
    "TARE" numeric(16,8) DEFAULT 0,
    "IFCO" integer DEFAULT 0 NOT NULL,
    "MASQUE_CAISSE" boolean DEFAULT false NOT NULL,
    "ADDITIONAL_TICKET_COPY" boolean DEFAULT false NOT NULL,
    "MATIERE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1 NOT NULL,
    "ID_COUT_REVIENT" integer DEFAULT 1,
    "MARGE_WITH_COUT_REVIENT" boolean DEFAULT false NOT NULL,
    "AUTO_PRIX_ACHAT_NOMENCLATURE" boolean DEFAULT false NOT NULL,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "Default"."ARTICLE" OWNER TO openconcerto;

--
-- TOC entry 1344 (class 1259 OID 36417567)
-- Name: ARTICLE_CATEGORIE_COMPTABLE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ARTICLE_CATEGORIE_COMPTABLE" (
    "ID" integer NOT NULL,
    "ID_CATEGORIE_COMPTABLE" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_TAXE_ACHAT" integer DEFAULT 1,
    "ID_TAXE_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."ARTICLE_CATEGORIE_COMPTABLE" OWNER TO openconcerto;

--
-- TOC entry 1343 (class 1259 OID 36417565)
-- Name: ARTICLE_CATEGORIE_COMPTABLE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ARTICLE_CATEGORIE_COMPTABLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ARTICLE_CATEGORIE_COMPTABLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21416 (class 0 OID 0)
-- Dependencies: 1343
-- Name: ARTICLE_CATEGORIE_COMPTABLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ARTICLE_CATEGORIE_COMPTABLE_ID_seq" OWNED BY "Default"."ARTICLE_CATEGORIE_COMPTABLE"."ID";


--
-- TOC entry 312 (class 1259 OID 36389096)
-- Name: ARTICLE_CODE_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ARTICLE_CODE_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "CODE" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."ARTICLE_CODE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 313 (class 1259 OID 36389107)
-- Name: ARTICLE_CODE_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ARTICLE_CODE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ARTICLE_CODE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21417 (class 0 OID 0)
-- Dependencies: 313
-- Name: ARTICLE_CODE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ARTICLE_CODE_CLIENT_ID_seq" OWNED BY "Default"."ARTICLE_CODE_CLIENT"."ID";


--
-- TOC entry 314 (class 1259 OID 36389109)
-- Name: ARTICLE_DESIGNATION; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ARTICLE_DESIGNATION" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1,
    "NOM" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."ARTICLE_DESIGNATION" OWNER TO openconcerto;

--
-- TOC entry 315 (class 1259 OID 36389120)
-- Name: ARTICLE_DESIGNATION_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ARTICLE_DESIGNATION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ARTICLE_DESIGNATION_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21418 (class 0 OID 0)
-- Dependencies: 315
-- Name: ARTICLE_DESIGNATION_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ARTICLE_DESIGNATION_ID_seq" OWNED BY "Default"."ARTICLE_DESIGNATION"."ID";


--
-- TOC entry 316 (class 1259 OID 36389122)
-- Name: ARTICLE_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ARTICLE_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_ARTICLE_PARENT" integer DEFAULT 1,
    "QTE" integer DEFAULT 1 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1 NOT NULL,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."ARTICLE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 317 (class 1259 OID 36389132)
-- Name: ARTICLE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ARTICLE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ARTICLE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21419 (class 0 OID 0)
-- Dependencies: 317
-- Name: ARTICLE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ARTICLE_ELEMENT_ID_seq" OWNED BY "Default"."ARTICLE_ELEMENT"."ID";


--
-- TOC entry 318 (class 1259 OID 36389134)
-- Name: ARTICLE_FOURNISSEUR; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ARTICLE_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying NOT NULL,
    "CODE_BARRE" character varying(45) DEFAULT ''::character varying NOT NULL,
    "CODE_DOUANIER" character varying(45) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0,
    "PRIX_METRIQUE_HA_2" numeric(16,8) DEFAULT 0,
    "PRIX_METRIQUE_HA_3" numeric(16,8) DEFAULT 0,
    "PRIX_METRIQUE_VT_1" numeric(16,8) DEFAULT 0,
    "PRIX_METRIQUE_VT_2" numeric(16,8) DEFAULT 0,
    "PRIX_METRIQUE_VT_3" numeric(16,8) DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PA_DEVISE" numeric(16,8) DEFAULT 0,
    "PV_U_DEVISE" numeric(16,8) DEFAULT 0,
    "PA_HT" numeric(16,8) DEFAULT 0,
    "PV_HT" numeric(16,8) DEFAULT 0,
    "PV_TTC" numeric(16,2) DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE_FOURNISSEUR" integer DEFAULT 1,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_DEVISE_HA" integer DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "SERVICE" boolean DEFAULT false NOT NULL,
    "OBSOLETE" boolean DEFAULT false NOT NULL,
    "GESTION_STOCK" boolean DEFAULT false NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1 NOT NULL,
    "QTE_MIN" integer DEFAULT 1 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "Default"."ARTICLE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 319 (class 1259 OID 36389183)
-- Name: ARTICLE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ARTICLE_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ARTICLE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21420 (class 0 OID 0)
-- Dependencies: 319
-- Name: ARTICLE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ARTICLE_FOURNISSEUR_ID_seq" OWNED BY "Default"."ARTICLE_FOURNISSEUR"."ID";


--
-- TOC entry 1346 (class 1259 OID 36417620)
-- Name: ARTICLE_FOURNISSEUR_SECONDAIRE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ARTICLE_FOURNISSEUR_SECONDAIRE" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."ARTICLE_FOURNISSEUR_SECONDAIRE" OWNER TO openconcerto;

--
-- TOC entry 1345 (class 1259 OID 36417618)
-- Name: ARTICLE_FOURNISSEUR_SECONDAIRE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ARTICLE_FOURNISSEUR_SECONDAIRE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ARTICLE_FOURNISSEUR_SECONDAIRE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21421 (class 0 OID 0)
-- Dependencies: 1345
-- Name: ARTICLE_FOURNISSEUR_SECONDAIRE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ARTICLE_FOURNISSEUR_SECONDAIRE_ID_seq" OWNED BY "Default"."ARTICLE_FOURNISSEUR_SECONDAIRE"."ID";


--
-- TOC entry 320 (class 1259 OID 36389185)
-- Name: ARTICLE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ARTICLE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21422 (class 0 OID 0)
-- Dependencies: 320
-- Name: ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ARTICLE_ID_seq" OWNED BY "Default"."ARTICLE"."ID";


--
-- TOC entry 321 (class 1259 OID 36389187)
-- Name: ARTICLE_TARIF; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ARTICLE_TARIF" (
    "ID" integer NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "ID_TARIF" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "POURCENT_REMISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE" integer DEFAULT 1 NOT NULL
);


ALTER TABLE "Default"."ARTICLE_TARIF" OWNER TO openconcerto;

--
-- TOC entry 1340 (class 1259 OID 36417435)
-- Name: ARTICLE_TARIF_FOURNISSEUR; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ARTICLE_TARIF_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "REF_FOURNISSEUR" character varying(500) DEFAULT ''::character varying NOT NULL,
    "TYPE_REAPPRO" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CONDITIONS" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ACHETEUR" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_PAYS_ORIGINE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRIX_ACHAT_DEVISE_F" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_ACHAT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE" integer DEFAULT 1 NOT NULL,
    "DATE_PRIX" timestamp without time zone,
    "DELAI_REAPPRO" integer DEFAULT 0 NOT NULL,
    "DELAI_TRANSPORT" integer DEFAULT 0 NOT NULL,
    "PRIORITE" integer DEFAULT 0 NOT NULL,
    "COEF_PRIX_MINI" numeric(16,2) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."ARTICLE_TARIF_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 1339 (class 1259 OID 36417433)
-- Name: ARTICLE_TARIF_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ARTICLE_TARIF_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ARTICLE_TARIF_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21423 (class 0 OID 0)
-- Dependencies: 1339
-- Name: ARTICLE_TARIF_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ARTICLE_TARIF_FOURNISSEUR_ID_seq" OWNED BY "Default"."ARTICLE_TARIF_FOURNISSEUR"."ID";


--
-- TOC entry 322 (class 1259 OID 36389203)
-- Name: ARTICLE_TARIF_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ARTICLE_TARIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ARTICLE_TARIF_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21424 (class 0 OID 0)
-- Dependencies: 322
-- Name: ARTICLE_TARIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ARTICLE_TARIF_ID_seq" OWNED BY "Default"."ARTICLE_TARIF"."ID";


--
-- TOC entry 323 (class 1259 OID 36389205)
-- Name: ASSOCIATION_ANALYTIQUE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ASSOCIATION_ANALYTIQUE" (
    "ID" integer NOT NULL,
    "ID_ECRITURE" integer DEFAULT 1,
    "ID_SAISIE_KM_ELEMENT" integer DEFAULT 1,
    "ID_POSTE_ANALYTIQUE" integer DEFAULT 1,
    "POURCENT" numeric(16,8) DEFAULT 100,
    "MONTANT" bigint DEFAULT 0,
    "GESTION_AUTO" boolean DEFAULT false NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."ASSOCIATION_ANALYTIQUE" OWNER TO openconcerto;

--
-- TOC entry 324 (class 1259 OID 36389216)
-- Name: ASSOCIATION_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ASSOCIATION_ANALYTIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ASSOCIATION_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21425 (class 0 OID 0)
-- Dependencies: 324
-- Name: ASSOCIATION_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ASSOCIATION_ANALYTIQUE_ID_seq" OWNED BY "Default"."ASSOCIATION_ANALYTIQUE"."ID";


--
-- TOC entry 325 (class 1259 OID 36389218)
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ASSOCIATION_COMPTE_ANALYTIQUE" (
    "ID" integer NOT NULL,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_AXE_ANALYTIQUE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_REPARTITION_ANALYTIQUE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."ASSOCIATION_COMPTE_ANALYTIQUE" OWNER TO openconcerto;

--
-- TOC entry 326 (class 1259 OID 36389227)
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21426 (class 0 OID 0)
-- Dependencies: 326
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq" OWNED BY "Default"."ASSOCIATION_COMPTE_ANALYTIQUE"."ID";


--
-- TOC entry 327 (class 1259 OID 36389229)
-- Name: ATTACHMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ATTACHMENT" (
    "ID" integer NOT NULL,
    "SOURCE_TABLE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "SOURCE_ID" integer DEFAULT 0 NOT NULL,
    "NAME" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MIMETYPE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FILENAME" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FILESIZE" bigint DEFAULT 0 NOT NULL,
    "STORAGE_PATH" character varying(256) DEFAULT ''::character varying NOT NULL,
    "STORAGE_FILENAME" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DIRECTORY" character varying(256) DEFAULT ''::character varying NOT NULL,
    "THUMBNAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "THUMBNAIL_WIDTH" integer DEFAULT 32 NOT NULL,
    "THUMBNAIL_HEIGHT" integer DEFAULT 32 NOT NULL,
    "TAG" character varying(128) DEFAULT ''::character varying NOT NULL,
    "VERSION" integer DEFAULT 0 NOT NULL,
    "HASH" character varying(32) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_PARENT" integer DEFAULT 1
);


ALTER TABLE "Default"."ATTACHMENT" OWNER TO openconcerto;

--
-- TOC entry 328 (class 1259 OID 36389253)
-- Name: ATTACHMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ATTACHMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ATTACHMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21427 (class 0 OID 0)
-- Dependencies: 328
-- Name: ATTACHMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ATTACHMENT_ID_seq" OWNED BY "Default"."ATTACHMENT"."ID";


--
-- TOC entry 329 (class 1259 OID 36389255)
-- Name: AVOIR_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."AVOIR_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "DATE" date,
    "MONTANT_TTC" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_CLIENT" integer DEFAULT 1,
    "MONTANT_HT" bigint DEFAULT 0,
    "MONTANT_TVA" bigint DEFAULT 0,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "PORT_HT" bigint DEFAULT 0,
    "REMISE_HT" bigint DEFAULT 0,
    "MONTANT_SERVICE" bigint DEFAULT 0,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "SOLDE" boolean DEFAULT false,
    "A_DEDUIRE" boolean DEFAULT false,
    "ENVOYE_EN_AFFACTURAGE" boolean DEFAULT false,
    "DATE_ENVOI_AFFACTURAGE" date,
    "AFFACTURAGE" boolean DEFAULT false,
    "MONTANT_SOLDE" bigint DEFAULT 0,
    "MONTANT_RESTANT" bigint DEFAULT 0,
    "COMPTE_SERVICE_AUTO" boolean DEFAULT false,
    "ID_CONTACT" integer DEFAULT 1,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1,
    "MOTIF" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "AFFACTURE" boolean DEFAULT false,
    "T_DEVISE" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "INFOS" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ID_ADRESSE_LIVRAISON" integer DEFAULT 1,
    "POURCENT_REMISE" numeric(12,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_CLIENT_DEPARTEMENT" integer DEFAULT 1,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0
);


ALTER TABLE "Default"."AVOIR_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 330 (class 1259 OID 36389296)
-- Name: AVOIR_CLIENT_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."AVOIR_CLIENT_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_STYLE" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "QTE" integer DEFAULT 1,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "SERVICE" boolean DEFAULT false,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "T_POIDS" real DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "TARIF_Q18_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "INFOS_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "Q18" boolean DEFAULT false,
    "ID_CONTACT" integer DEFAULT 1,
    "INDICE_0" bigint DEFAULT 0,
    "REFERENTIEL_INSPECTION" character varying(2048) DEFAULT ''::text,
    "CODE_MISSION" character varying(45) DEFAULT ''::character varying,
    "POURCENT_SERVICE" character varying(2048) DEFAULT ''::text,
    "INDICE_N" bigint DEFAULT 0,
    "LOCAL_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "MONTANT_INITIAL" numeric(16,6) DEFAULT 0 NOT NULL,
    "SOUS_ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "DATE_FIN" timestamp without time zone,
    "ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "NOM_MISSION" character varying(256) DEFAULT ''::character varying,
    "DATE" timestamp without time zone,
    "MONTANT_REVISABLE" boolean DEFAULT false,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ACOMPTE" boolean DEFAULT false,
    "POURCENT_ACOMPTE" numeric(6,2) DEFAULT 100 NOT NULL,
    "POURCENT_REMISE" numeric(12,8) DEFAULT 0,
    "SITUATION_ADMIN" character varying(2048) DEFAULT ''::text,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_T_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "T_POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "NB_COLIS" integer DEFAULT 0,
    "MONTANT_REMISE" numeric(16,8),
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "RETOUR_STOCK" boolean DEFAULT false NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "Default"."AVOIR_CLIENT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 331 (class 1259 OID 36389374)
-- Name: AVOIR_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."AVOIR_CLIENT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."AVOIR_CLIENT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21428 (class 0 OID 0)
-- Dependencies: 331
-- Name: AVOIR_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."AVOIR_CLIENT_ELEMENT_ID_seq" OWNED BY "Default"."AVOIR_CLIENT_ELEMENT"."ID";


--
-- TOC entry 332 (class 1259 OID 36389376)
-- Name: AVOIR_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."AVOIR_CLIENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."AVOIR_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21429 (class 0 OID 0)
-- Dependencies: 332
-- Name: AVOIR_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."AVOIR_CLIENT_ID_seq" OWNED BY "Default"."AVOIR_CLIENT"."ID";


--
-- TOC entry 333 (class 1259 OID 36389378)
-- Name: AVOIR_FOURNISSEUR; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."AVOIR_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "DATE" date,
    "SOLDE" boolean DEFAULT false,
    "A_DEDUIRE" boolean DEFAULT false,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "MONTANT_HT" bigint DEFAULT 0,
    "MONTANT_TVA" bigint DEFAULT 0,
    "MONTANT_TTC" bigint DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "IMMO" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "INFOS" character varying(1024) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Default"."AVOIR_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 334 (class 1259 OID 36389400)
-- Name: AVOIR_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."AVOIR_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."AVOIR_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21430 (class 0 OID 0)
-- Dependencies: 334
-- Name: AVOIR_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."AVOIR_FOURNISSEUR_ID_seq" OWNED BY "Default"."AVOIR_FOURNISSEUR"."ID";


--
-- TOC entry 335 (class 1259 OID 36389402)
-- Name: AXE_ANALYTIQUE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."AXE_ANALYTIQUE" (
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "TYPE" character varying(256) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Default"."AXE_ANALYTIQUE" OWNER TO openconcerto;

--
-- TOC entry 336 (class 1259 OID 36389413)
-- Name: AXE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."AXE_ANALYTIQUE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."AXE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21431 (class 0 OID 0)
-- Dependencies: 336
-- Name: AXE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."AXE_ANALYTIQUE_ID_seq" OWNED BY "Default"."AXE_ANALYTIQUE"."ID";


--
-- TOC entry 337 (class 1259 OID 36389415)
-- Name: AYANT_DROIT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."AYANT_DROIT" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_SALARIE" integer DEFAULT 1,
    "ID_AYANT_DROIT_TYPE" integer DEFAULT 1,
    "REGIME_ALSACE" boolean DEFAULT false NOT NULL,
    "NIR" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRENOMS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_ORGANISME_AFFILIATION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_OPTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NIR_OUVRANT_DROIT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DATE_DEBUT_RATTACHEMENT" timestamp without time zone,
    "DATE_FIN_RATTACHEMENT" timestamp without time zone,
    "DATE_NAISSANCE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."AYANT_DROIT" OWNER TO openconcerto;

--
-- TOC entry 338 (class 1259 OID 36389432)
-- Name: AYANT_DROIT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."AYANT_DROIT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."AYANT_DROIT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21432 (class 0 OID 0)
-- Dependencies: 338
-- Name: AYANT_DROIT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."AYANT_DROIT_ID_seq" OWNED BY "Default"."AYANT_DROIT"."ID";


--
-- TOC entry 339 (class 1259 OID 36389434)
-- Name: BANQUE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."BANQUE" (
    "ID" integer NOT NULL,
    "ID_JOURNAL" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RUE" character varying(45) DEFAULT ''::character varying NOT NULL,
    "RUE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "IBAN" character varying(256) DEFAULT ''::character varying NOT NULL,
    "BIC" character varying(256) DEFAULT ''::character varying NOT NULL,
    "VOIE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "VILLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DOMICILIATION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "AFFACTURAGE" boolean DEFAULT false NOT NULL,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."BANQUE" OWNER TO openconcerto;

--
-- TOC entry 340 (class 1259 OID 36389455)
-- Name: BANQUE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."BANQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."BANQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21433 (class 0 OID 0)
-- Dependencies: 340
-- Name: BANQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."BANQUE_ID_seq" OWNED BY "Default"."BANQUE"."ID";


--
-- TOC entry 341 (class 1259 OID 36389457)
-- Name: BON_DE_LIVRAISON; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."BON_DE_LIVRAISON" (
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "DATE" date,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ID_CLIENT" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "TOTAL_HT" bigint DEFAULT 0,
    "TOTAL_TVA" bigint DEFAULT 0,
    "TOTAL_TTC" bigint DEFAULT 0,
    "TOTAL_POIDS" real DEFAULT 0,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "SOURCE" character varying(512) DEFAULT ''::character varying NOT NULL,
    "IDSOURCE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "DATE_LIVRAISON" date,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_ADRESSE_LIVRAISON" integer DEFAULT 1,
    "POURCENT_REMISE" numeric(12,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_CONTACT" integer DEFAULT 1,
    "ID_CLIENT_DEPARTEMENT" integer DEFAULT 1,
    "TOTAL_DEVISE" bigint DEFAULT 0 NOT NULL,
    "TOTAL_SERVICE" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "PORT_HT" bigint DEFAULT 0 NOT NULL,
    "REMISE_HT" bigint DEFAULT 0 NOT NULL,
    "CREATE_VIRTUAL_STOCK" boolean DEFAULT true NOT NULL,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "FRAIS_DOCUMENT_HT" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE_FRAIS_DOCUMENT" integer DEFAULT 1
);


ALTER TABLE "Default"."BON_DE_LIVRAISON" OWNER TO openconcerto;

--
-- TOC entry 342 (class 1259 OID 36389491)
-- Name: BON_DE_LIVRAISON_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."BON_DE_LIVRAISON_ELEMENT" (
    "ID_SAISIE_VENTE_FACTURE_ELEMENT" integer DEFAULT 1,
    "QTE_A_LIVRER" integer DEFAULT 0,
    "QTE_LIVREE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE" integer DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_POIDS" real DEFAULT 0,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "SERVICE" boolean DEFAULT false,
    "ID_STYLE" integer DEFAULT 1,
    "T_POIDS_LIVREE" real DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1 NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "POURCENT_REMISE" numeric(12,8) DEFAULT 0,
    "PV_T_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "T_POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "NB_COLIS" integer DEFAULT 0,
    "MONTANT_REMISE" numeric(16,8),
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_COMMANDE_CLIENT_ELEMENT" integer DEFAULT 1,
    "ID_DEPOT_STOCK" integer DEFAULT 1,
    "ID_DEVIS_ELEMENT" integer DEFAULT 1
);


ALTER TABLE "Default"."BON_DE_LIVRAISON_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 343 (class 1259 OID 36389553)
-- Name: BON_DE_LIVRAISON_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."BON_DE_LIVRAISON_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."BON_DE_LIVRAISON_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21434 (class 0 OID 0)
-- Dependencies: 343
-- Name: BON_DE_LIVRAISON_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."BON_DE_LIVRAISON_ELEMENT_ID_seq" OWNED BY "Default"."BON_DE_LIVRAISON_ELEMENT"."ID";


--
-- TOC entry 344 (class 1259 OID 36389555)
-- Name: BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."BON_DE_LIVRAISON_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."BON_DE_LIVRAISON_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21435 (class 0 OID 0)
-- Dependencies: 344
-- Name: BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."BON_DE_LIVRAISON_ID_seq" OWNED BY "Default"."BON_DE_LIVRAISON"."ID";


--
-- TOC entry 345 (class 1259 OID 36389557)
-- Name: BON_RECEPTION; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."BON_RECEPTION" (
    "ID" integer NOT NULL,
    "DATE" date,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "TOTAL_HT" bigint DEFAULT 0,
    "TOTAL_TTC" bigint DEFAULT 0,
    "TOTAL_TVA" bigint DEFAULT 0,
    "TOTAL_POIDS" real DEFAULT 0,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_COMMANDE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_DEVISE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "CREATE_VIRTUAL_STOCK" boolean DEFAULT true NOT NULL,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "PORT_HT" bigint DEFAULT 0 NOT NULL,
    "REMISE_HT" bigint DEFAULT 0 NOT NULL
);


ALTER TABLE "Default"."BON_RECEPTION" OWNER TO openconcerto;

--
-- TOC entry 346 (class 1259 OID 36389580)
-- Name: BON_RECEPTION_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."BON_RECEPTION_ELEMENT" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "QTE" integer DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "ID_BON_RECEPTION" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_POIDS" real DEFAULT 0,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "SERVICE" boolean DEFAULT false,
    "ID_STYLE" integer DEFAULT 1,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PA_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "QTE_ACHAT" integer DEFAULT 1,
    "PA_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "PA_DEVISE_T" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_CODE_FOURNISSEUR" integer DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_COMMANDE_ELEMENT" integer DEFAULT 1,
    "ID_DEMANDE_ACHAT_ELEMENT" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "QTE_ORIGINE" integer,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "Default"."BON_RECEPTION_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 347 (class 1259 OID 36389633)
-- Name: BON_RECEPTION_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."BON_RECEPTION_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."BON_RECEPTION_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21436 (class 0 OID 0)
-- Dependencies: 347
-- Name: BON_RECEPTION_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."BON_RECEPTION_ELEMENT_ID_seq" OWNED BY "Default"."BON_RECEPTION_ELEMENT"."ID";


--
-- TOC entry 348 (class 1259 OID 36389635)
-- Name: BON_RECEPTION_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."BON_RECEPTION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."BON_RECEPTION_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21437 (class 0 OID 0)
-- Dependencies: 348
-- Name: BON_RECEPTION_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."BON_RECEPTION_ID_seq" OWNED BY "Default"."BON_RECEPTION"."ID";


--
-- TOC entry 349 (class 1259 OID 36389637)
-- Name: CAISSE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CAISSE" (
    "NOM" character varying(2048) DEFAULT ''::text,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_DERNIERE_CLOTURE" integer
);


ALTER TABLE "Default"."CAISSE" OWNER TO openconcerto;

--
-- TOC entry 350 (class 1259 OID 36389647)
-- Name: CAISSE_CLOTURE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CAISSE_CLOTURE" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_ENTREE_JOURNAL" integer,
    "PERIODE" character varying(32) DEFAULT ''::character varying NOT NULL,
    "DEBUT" date NOT NULL,
    "FIN" date NOT NULL,
    "TOTAL_TTC" numeric(16,6) DEFAULT 0 NOT NULL,
    "PREMIER_TICKET" character varying(64) DEFAULT NULL::character varying,
    "PREMIER_TICKET_HASH" character varying(128) DEFAULT NULL::character varying,
    "DERNIER_TICKET" character varying(64) DEFAULT NULL::character varying,
    "DERNIER_TICKET_HASH" character varying(128) DEFAULT NULL::character varying,
    "ARCHIVE" integer DEFAULT 0 NOT NULL
);


ALTER TABLE "Default"."CAISSE_CLOTURE" OWNER TO openconcerto;

--
-- TOC entry 351 (class 1259 OID 36389659)
-- Name: CAISSE_CLOTURE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CAISSE_CLOTURE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CAISSE_CLOTURE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21438 (class 0 OID 0)
-- Dependencies: 351
-- Name: CAISSE_CLOTURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CAISSE_CLOTURE_ID_seq" OWNED BY "Default"."CAISSE_CLOTURE"."ID";


--
-- TOC entry 352 (class 1259 OID 36389661)
-- Name: CAISSE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CAISSE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CAISSE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21439 (class 0 OID 0)
-- Dependencies: 352
-- Name: CAISSE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CAISSE_ID_seq" OWNED BY "Default"."CAISSE"."ID";


--
-- TOC entry 353 (class 1259 OID 36389663)
-- Name: CAISSE_JOURNAL; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CAISSE_JOURNAL" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_CAISSE" integer DEFAULT 1,
    "DATE" timestamp without time zone,
    "ID_USER" integer DEFAULT 1,
    "EVT" character varying(128) DEFAULT ''::character varying NOT NULL,
    "CREATOR" character varying(128) DEFAULT ''::character varying NOT NULL,
    "CREATOR_VERSION" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "HOST_NAME" character varying(128),
    "HOST_USER" character varying(128)
);


ALTER TABLE "Default"."CAISSE_JOURNAL" OWNER TO openconcerto;

--
-- TOC entry 354 (class 1259 OID 36389677)
-- Name: CAISSE_JOURNAL_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CAISSE_JOURNAL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CAISSE_JOURNAL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21440 (class 0 OID 0)
-- Dependencies: 354
-- Name: CAISSE_JOURNAL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CAISSE_JOURNAL_ID_seq" OWNED BY "Default"."CAISSE_JOURNAL"."ID";


--
-- TOC entry 355 (class 1259 OID 36389679)
-- Name: CALENDAR_ITEM; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CALENDAR_ITEM" (
    "ID" integer NOT NULL,
    "START" timestamp without time zone,
    "END" timestamp without time zone,
    "DURATION_S" bigint DEFAULT 0 NOT NULL,
    "SUMMARY" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "DESCRIPTION" character varying(8192) DEFAULT ''::character varying NOT NULL,
    "FLAGS" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "STATUS" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_CALENDAR_ITEM_GROUP" integer,
    "SOURCE_ID" bigint,
    "SOURCE_TABLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "UID" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "LOCATION" character varying(4096) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Default"."CALENDAR_ITEM" OWNER TO openconcerto;

--
-- TOC entry 356 (class 1259 OID 36389695)
-- Name: CALENDAR_ITEM_GROUP; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CALENDAR_ITEM_GROUP" (
    "ID" integer NOT NULL,
    "NAME" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "DESCRIPTION" character varying(8192) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."CALENDAR_ITEM_GROUP" OWNER TO openconcerto;

--
-- TOC entry 357 (class 1259 OID 36389705)
-- Name: CALENDAR_ITEM_GROUP_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CALENDAR_ITEM_GROUP_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CALENDAR_ITEM_GROUP_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21441 (class 0 OID 0)
-- Dependencies: 357
-- Name: CALENDAR_ITEM_GROUP_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CALENDAR_ITEM_GROUP_ID_seq" OWNED BY "Default"."CALENDAR_ITEM_GROUP"."ID";


--
-- TOC entry 358 (class 1259 OID 36389707)
-- Name: CALENDAR_ITEM_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CALENDAR_ITEM_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CALENDAR_ITEM_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21442 (class 0 OID 0)
-- Dependencies: 358
-- Name: CALENDAR_ITEM_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CALENDAR_ITEM_ID_seq" OWNED BY "Default"."CALENDAR_ITEM"."ID";


--
-- TOC entry 359 (class 1259 OID 36389709)
-- Name: CATEGORIE_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CATEGORIE_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."CATEGORIE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 360 (class 1259 OID 36389718)
-- Name: CATEGORIE_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CATEGORIE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CATEGORIE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21443 (class 0 OID 0)
-- Dependencies: 360
-- Name: CATEGORIE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CATEGORIE_CLIENT_ID_seq" OWNED BY "Default"."CATEGORIE_CLIENT"."ID";


--
-- TOC entry 1342 (class 1259 OID 36417475)
-- Name: CATEGORIE_COMPTABLE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CATEGORIE_COMPTABLE" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_TAXE_VENTE" integer DEFAULT 1,
    "ID_TAXE_ACHAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."CATEGORIE_COMPTABLE" OWNER TO openconcerto;

--
-- TOC entry 1341 (class 1259 OID 36417473)
-- Name: CATEGORIE_COMPTABLE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CATEGORIE_COMPTABLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CATEGORIE_COMPTABLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21444 (class 0 OID 0)
-- Dependencies: 1341
-- Name: CATEGORIE_COMPTABLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CATEGORIE_COMPTABLE_ID_seq" OWNED BY "Default"."CATEGORIE_COMPTABLE"."ID";


--
-- TOC entry 361 (class 1259 OID 36389720)
-- Name: CHEQUE_AVOIR_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CHEQUE_AVOIR_CLIENT" (
    "ID" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0 NOT NULL,
    "DECAISSE" boolean DEFAULT false NOT NULL,
    "ID_MOUVEMENT" integer DEFAULT 1 NOT NULL,
    "DATE_AVOIR" date,
    "DATE_MIN_DECAISSE" date,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "DATE_DECAISSE" date,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "DATE" date,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ETS" character varying(2048) DEFAULT ''::text,
    "REG_COMPTA" boolean DEFAULT false,
    "ID_BANQUE" integer DEFAULT 1
);


ALTER TABLE "Default"."CHEQUE_AVOIR_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 362 (class 1259 OID 36389735)
-- Name: CHEQUE_AVOIR_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CHEQUE_AVOIR_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CHEQUE_AVOIR_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21445 (class 0 OID 0)
-- Dependencies: 362
-- Name: CHEQUE_AVOIR_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CHEQUE_AVOIR_CLIENT_ID_seq" OWNED BY "Default"."CHEQUE_AVOIR_CLIENT"."ID";


--
-- TOC entry 363 (class 1259 OID 36389737)
-- Name: CHEQUE_A_ENCAISSER; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CHEQUE_A_ENCAISSER" (
    "ID" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0,
    "ENCAISSE" boolean DEFAULT false,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "DATE_MIN_DEPOT" date,
    "DATE_VENTE" date,
    "DATE_DEPOT" date,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "DATE" date,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ETS" character varying(2048) DEFAULT ''::text,
    "REG_COMPTA" boolean DEFAULT false,
    "ID_BANQUE" integer DEFAULT 1,
    "SANS_VALEUR_ENCAISSEMENT" boolean DEFAULT false NOT NULL,
    "TIERS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_COMPTE_PCE_TIERS" integer DEFAULT 1
);


ALTER TABLE "Default"."CHEQUE_A_ENCAISSER" OWNER TO openconcerto;

--
-- TOC entry 364 (class 1259 OID 36389753)
-- Name: CHEQUE_A_ENCAISSER_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CHEQUE_A_ENCAISSER_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CHEQUE_A_ENCAISSER_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21446 (class 0 OID 0)
-- Dependencies: 364
-- Name: CHEQUE_A_ENCAISSER_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CHEQUE_A_ENCAISSER_ID_seq" OWNED BY "Default"."CHEQUE_A_ENCAISSER"."ID";


--
-- TOC entry 365 (class 1259 OID 36389755)
-- Name: CHEQUE_FOURNISSEUR; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CHEQUE_FOURNISSEUR" (
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0,
    "DECAISSE" boolean DEFAULT false,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "DATE_ACHAT" date,
    "DATE_MIN_DECAISSE" date,
    "DATE_DECAISSE" date,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "DATE" date,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ETS" character varying(2048) DEFAULT ''::text,
    "REG_COMPTA" boolean DEFAULT false,
    "ID_BANQUE" integer DEFAULT 1,
    "SANS_VALEUR_ENCAISSEMENT" boolean DEFAULT false NOT NULL
);


ALTER TABLE "Default"."CHEQUE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 366 (class 1259 OID 36389771)
-- Name: CHEQUE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CHEQUE_FOURNISSEUR_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CHEQUE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21447 (class 0 OID 0)
-- Dependencies: 366
-- Name: CHEQUE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CHEQUE_FOURNISSEUR_ID_seq" OWNED BY "Default"."CHEQUE_FOURNISSEUR"."ID";


--
-- TOC entry 367 (class 1259 OID 36389773)
-- Name: CHIFFRAGE_COMMANDE_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CHIFFRAGE_COMMANDE_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "QTE" numeric(16,8) DEFAULT 0 NOT NULL,
    "PA_HT" numeric(16,8) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,8) DEFAULT 0 NOT NULL,
    "T_PV_HT" numeric(16,8) DEFAULT 0 NOT NULL,
    "T_PA_HT" numeric(16,8) DEFAULT 0 NOT NULL,
    "MARGE" numeric(16,8) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."CHIFFRAGE_COMMANDE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 368 (class 1259 OID 36389787)
-- Name: CHIFFRAGE_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CHIFFRAGE_COMMANDE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CHIFFRAGE_COMMANDE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21448 (class 0 OID 0)
-- Dependencies: 368
-- Name: CHIFFRAGE_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CHIFFRAGE_COMMANDE_CLIENT_ID_seq" OWNED BY "Default"."CHIFFRAGE_COMMANDE_CLIENT"."ID";


--
-- TOC entry 369 (class 1259 OID 36389789)
-- Name: CLASSEMENT_CONVENTIONNEL; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CLASSEMENT_CONVENTIONNEL" (
    "ID" integer NOT NULL,
    "NIVEAU" character varying(45) DEFAULT ''::character varying,
    "COEFF" character varying(45) DEFAULT ''::character varying,
    "INDICE" character varying(45) DEFAULT ''::character varying,
    "POSITION" character varying(45) DEFAULT ''::character varying,
    "ECHELON" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CLASSEMENT_CONVENTIONNEL" OWNER TO openconcerto;

--
-- TOC entry 370 (class 1259 OID 36389800)
-- Name: CLASSEMENT_CONVENTIONNEL_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CLASSEMENT_CONVENTIONNEL_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CLASSEMENT_CONVENTIONNEL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21449 (class 0 OID 0)
-- Dependencies: 370
-- Name: CLASSEMENT_CONVENTIONNEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CLASSEMENT_CONVENTIONNEL_ID_seq" OWNED BY "Default"."CLASSEMENT_CONVENTIONNEL"."ID";


--
-- TOC entry 371 (class 1259 OID 36389802)
-- Name: CLASSE_COMPTE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CLASSE_COMPTE" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "TYPE_NUMERO_COMPTE" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CLASSE_COMPTE" OWNER TO openconcerto;

--
-- TOC entry 372 (class 1259 OID 36389813)
-- Name: CLASSE_COMPTE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CLASSE_COMPTE_ID_seq"
    START WITH 12
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CLASSE_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21450 (class 0 OID 0)
-- Dependencies: 372
-- Name: CLASSE_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CLASSE_COMPTE_ID_seq" OWNED BY "Default"."CLASSE_COMPTE"."ID";


--
-- TOC entry 373 (class 1259 OID 36389815)
-- Name: CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CLIENT" (
    "ID" integer NOT NULL,
    "FORME_JURIDIQUE" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(2048) DEFAULT ''::text,
    "TEL" character varying(100) DEFAULT ''::character varying,
    "MAIL" character varying(100) DEFAULT ''::character varying,
    "FAX" character varying(100) DEFAULT ''::character varying,
    "NUMERO_TVA" character varying(100) DEFAULT ''::character varying,
    "ID_ADRESSE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "RESPONSABLE" character varying(100) DEFAULT ''::character varying,
    "ID_ADRESSE_L" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "TEL_P" character varying(100) DEFAULT ''::character varying,
    "RESPONSABLE_TECH" character varying(100) DEFAULT ''::character varying,
    "TEL_P_TECH" character varying(100) DEFAULT ''::character varying,
    "TEL_TECH" character varying(100) DEFAULT ''::character varying,
    "MAIL_TECH" character varying(100) DEFAULT ''::character varying,
    "RESPONSABLE_COM" character varying(100) DEFAULT ''::character varying,
    "TEL_P_COM" character varying(100) DEFAULT ''::character varying,
    "MAIL_COM" character varying(100) DEFAULT ''::character varying,
    "TEL_COM" character varying(100) DEFAULT ''::character varying,
    "ID_MODE_REGLEMENT" integer DEFAULT 1 NOT NULL,
    "ID_ADRESSE_F" integer DEFAULT 1,
    "FAX_TECH" character varying(100) DEFAULT ''::character varying,
    "FAX_COM" character varying(100) DEFAULT ''::character varying,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "SIRET" character varying(2048) DEFAULT ''::text,
    "RIB" character varying(2048) DEFAULT ''::text,
    "MARCHE_PUBLIC" boolean DEFAULT false,
    "MARCHE_PRIVE" boolean DEFAULT false,
    "AFFACTURAGE" boolean DEFAULT false,
    "MAX_FACTURE" bigint DEFAULT 0,
    "COMPTANT" boolean DEFAULT false,
    "COMPTE_CLIENT_AUTO" boolean DEFAULT false,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_TARIF" integer DEFAULT 1,
    "ID_PAYS" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "BLOQUE_LIVRAISON" boolean DEFAULT false NOT NULL,
    "BLOQUE" boolean DEFAULT false NOT NULL,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1,
    "ID_COMPTE_PCE_PRODUIT" integer DEFAULT 1,
    "ENCOURS_MAX" numeric(16,2) DEFAULT 0 NOT NULL,
    "CATEGORIES" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NOTE_FINANCIERE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "CENTRE_GESTION" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "METHODE_RELANCE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "SITE_INTERNET" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "GROUPE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "TIMBRE_FISCAL" boolean DEFAULT false NOT NULL,
    "OBSOLETE" boolean DEFAULT false NOT NULL,
    "REMIND_DATE" timestamp without time zone,
    "SOLDE_COMPTE" numeric(16,6) DEFAULT 0 NOT NULL,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "COMMENTAIRES" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "CODE_FOURNISSEUR" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CONDITIONS_LIVRAISON" character varying(512) DEFAULT ''::character varying NOT NULL,
    "DATE" date,
    "IBAN" character varying(128) DEFAULT ''::character varying NOT NULL,
    "BIC" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ACCEPTE_EMAIL" boolean DEFAULT false NOT NULL,
    "ACCEPTE_COURRIER" boolean DEFAULT false NOT NULL,
    "ACCEPTE_SMS" boolean DEFAULT false NOT NULL,
    "ACCEPTE_TEL" boolean DEFAULT false NOT NULL,
    "ID_FRAIS_DOCUMENT" integer DEFAULT 1,
    "ID_CATEGORIE_COMPTABLE" integer DEFAULT 1
);


ALTER TABLE "Default"."CLIENT" OWNER TO openconcerto;

--
-- TOC entry 374 (class 1259 OID 36389884)
-- Name: CLIENT_DEPARTEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CLIENT_DEPARTEMENT" (
    "ID" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_ADRESSE" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."CLIENT_DEPARTEMENT" OWNER TO openconcerto;

--
-- TOC entry 375 (class 1259 OID 36389896)
-- Name: CLIENT_DEPARTEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CLIENT_DEPARTEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CLIENT_DEPARTEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21451 (class 0 OID 0)
-- Dependencies: 375
-- Name: CLIENT_DEPARTEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CLIENT_DEPARTEMENT_ID_seq" OWNED BY "Default"."CLIENT_DEPARTEMENT"."ID";


--
-- TOC entry 376 (class 1259 OID 36389898)
-- Name: CLIENT_ID_CLIENT_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CLIENT_ID_CLIENT_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CLIENT_ID_CLIENT_seq" OWNER TO openconcerto;

--
-- TOC entry 21452 (class 0 OID 0)
-- Dependencies: 376
-- Name: CLIENT_ID_CLIENT_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CLIENT_ID_CLIENT_seq" OWNED BY "Default"."CLIENT"."ID";


--
-- TOC entry 377 (class 1259 OID 36389900)
-- Name: CODE_CARACT_ACTIVITE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CODE_CARACT_ACTIVITE" (
    "ID" integer NOT NULL,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CODE_CARACT_ACTIVITE" OWNER TO openconcerto;

--
-- TOC entry 378 (class 1259 OID 36389908)
-- Name: CODE_CARACT_ACTIVITE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CODE_CARACT_ACTIVITE_ID_seq"
    START WITH 12
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_CARACT_ACTIVITE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21453 (class 0 OID 0)
-- Dependencies: 378
-- Name: CODE_CARACT_ACTIVITE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CODE_CARACT_ACTIVITE_ID_seq" OWNED BY "Default"."CODE_CARACT_ACTIVITE"."ID";


--
-- TOC entry 379 (class 1259 OID 36389910)
-- Name: CODE_CONTRAT_TRAVAIL; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CODE_CONTRAT_TRAVAIL" (
    "ID" integer NOT NULL,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "NOM" character varying(128) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CODE_CONTRAT_TRAVAIL" OWNER TO openconcerto;

--
-- TOC entry 380 (class 1259 OID 36389918)
-- Name: CODE_CONTRAT_TRAVAIL_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CODE_CONTRAT_TRAVAIL_ID_seq"
    START WITH 14
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_CONTRAT_TRAVAIL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21454 (class 0 OID 0)
-- Dependencies: 380
-- Name: CODE_CONTRAT_TRAVAIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CODE_CONTRAT_TRAVAIL_ID_seq" OWNED BY "Default"."CODE_CONTRAT_TRAVAIL"."ID";


--
-- TOC entry 381 (class 1259 OID 36389920)
-- Name: CODE_DROIT_CONTRAT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CODE_DROIT_CONTRAT" (
    "ID" integer NOT NULL,
    "CODE" character varying(4) DEFAULT ''::character varying,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CODE_DROIT_CONTRAT" OWNER TO openconcerto;

--
-- TOC entry 382 (class 1259 OID 36389928)
-- Name: CODE_DROIT_CONTRAT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CODE_DROIT_CONTRAT_ID_seq"
    START WITH 4
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_DROIT_CONTRAT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21455 (class 0 OID 0)
-- Dependencies: 382
-- Name: CODE_DROIT_CONTRAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CODE_DROIT_CONTRAT_ID_seq" OWNED BY "Default"."CODE_DROIT_CONTRAT"."ID";


--
-- TOC entry 383 (class 1259 OID 36389930)
-- Name: CODE_EMPLOI; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CODE_EMPLOI" (
    "ID" integer NOT NULL,
    "CODE" character varying(11) DEFAULT ''::character varying,
    "NOM" character varying(195) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CODE_EMPLOI" OWNER TO openconcerto;

--
-- TOC entry 384 (class 1259 OID 36389938)
-- Name: CODE_EMPLOI_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CODE_EMPLOI_ID_seq"
    START WITH 1036
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_EMPLOI_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21456 (class 0 OID 0)
-- Dependencies: 384
-- Name: CODE_EMPLOI_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CODE_EMPLOI_ID_seq" OWNED BY "Default"."CODE_EMPLOI"."ID";


--
-- TOC entry 385 (class 1259 OID 36389940)
-- Name: CODE_FOURNISSEUR; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CODE_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."CODE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 386 (class 1259 OID 36389948)
-- Name: CODE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CODE_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21457 (class 0 OID 0)
-- Dependencies: 386
-- Name: CODE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CODE_FOURNISSEUR_ID_seq" OWNED BY "Default"."CODE_FOURNISSEUR"."ID";


--
-- TOC entry 387 (class 1259 OID 36389950)
-- Name: CODE_PENIBILITE_CONTRAT_SALARIE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CODE_PENIBILITE_CONTRAT_SALARIE" (
    "ID" integer NOT NULL,
    "ID_INFOS_SALARIE_PAYE" integer DEFAULT 1,
    "ID_CODE_PENIBILITE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."CODE_PENIBILITE_CONTRAT_SALARIE" OWNER TO openconcerto;

--
-- TOC entry 388 (class 1259 OID 36389957)
-- Name: CODE_PENIBILITE_CONTRAT_SALARIE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CODE_PENIBILITE_CONTRAT_SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_PENIBILITE_CONTRAT_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21458 (class 0 OID 0)
-- Dependencies: 388
-- Name: CODE_PENIBILITE_CONTRAT_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CODE_PENIBILITE_CONTRAT_SALARIE_ID_seq" OWNED BY "Default"."CODE_PENIBILITE_CONTRAT_SALARIE"."ID";


--
-- TOC entry 389 (class 1259 OID 36389959)
-- Name: CODE_REGIME; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CODE_REGIME" (
    "ID" integer NOT NULL,
    "CODE" character varying(4) DEFAULT ''::character varying,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CODE_REGIME" OWNER TO openconcerto;

--
-- TOC entry 390 (class 1259 OID 36389967)
-- Name: CODE_REGIME_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CODE_REGIME_ID_seq"
    START WITH 23
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_REGIME_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21459 (class 0 OID 0)
-- Dependencies: 390
-- Name: CODE_REGIME_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CODE_REGIME_ID_seq" OWNED BY "Default"."CODE_REGIME"."ID";


--
-- TOC entry 391 (class 1259 OID 36389969)
-- Name: CODE_STATUT_CATEGORIEL; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CODE_STATUT_CATEGORIEL" (
    "ID" integer NOT NULL,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CODE_STATUT_CATEGORIEL" OWNER TO openconcerto;

--
-- TOC entry 392 (class 1259 OID 36389977)
-- Name: CODE_STATUT_CATEGORIEL_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CODE_STATUT_CATEGORIEL_ID_seq"
    START WITH 6
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_STATUT_CATEGORIEL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21460 (class 0 OID 0)
-- Dependencies: 392
-- Name: CODE_STATUT_CATEGORIEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CODE_STATUT_CATEGORIEL_ID_seq" OWNED BY "Default"."CODE_STATUT_CATEGORIEL"."ID";


--
-- TOC entry 393 (class 1259 OID 36389979)
-- Name: CODE_STATUT_CAT_CONV; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CODE_STATUT_CAT_CONV" (
    "ID" integer NOT NULL,
    "CODE" character varying(6) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."CODE_STATUT_CAT_CONV" OWNER TO openconcerto;

--
-- TOC entry 394 (class 1259 OID 36389986)
-- Name: CODE_STATUT_CAT_CONV_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CODE_STATUT_CAT_CONV_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_STATUT_CAT_CONV_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21461 (class 0 OID 0)
-- Dependencies: 394
-- Name: CODE_STATUT_CAT_CONV_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CODE_STATUT_CAT_CONV_ID_seq" OWNED BY "Default"."CODE_STATUT_CAT_CONV"."ID";


--
-- TOC entry 395 (class 1259 OID 36389988)
-- Name: CODE_STATUT_PROF; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CODE_STATUT_PROF" (
    "ID" integer NOT NULL,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "NOM" character varying(256) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CODE_STATUT_PROF" OWNER TO openconcerto;

--
-- TOC entry 396 (class 1259 OID 36389996)
-- Name: CODE_STATUT_PROF_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CODE_STATUT_PROF_ID_seq"
    START WITH 51
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CODE_STATUT_PROF_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21462 (class 0 OID 0)
-- Dependencies: 396
-- Name: CODE_STATUT_PROF_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CODE_STATUT_PROF_ID_seq" OWNED BY "Default"."CODE_STATUT_PROF"."ID";


--
-- TOC entry 397 (class 1259 OID 36389998)
-- Name: COEFF_PRIME; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."COEFF_PRIME" (
    "ID" integer NOT NULL,
    "PRIME_PERSO" real DEFAULT 0,
    "PRIME_RECONSTRUCTION" real DEFAULT 0,
    "PRIME_ANCIENNETE" real DEFAULT 0,
    "PRIME_DEROULEMENT" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."COEFF_PRIME" OWNER TO openconcerto;

--
-- TOC entry 398 (class 1259 OID 36390007)
-- Name: COEFF_PRIME_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."COEFF_PRIME_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."COEFF_PRIME_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21463 (class 0 OID 0)
-- Dependencies: 398
-- Name: COEFF_PRIME_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."COEFF_PRIME_ID_seq" OWNED BY "Default"."COEFF_PRIME"."ID";


--
-- TOC entry 399 (class 1259 OID 36390009)
-- Name: COMMANDE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."COMMANDE" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "DATE" date,
    "DATE_ECHEANCE" date,
    "IDSOURCE" integer DEFAULT 1,
    "SOURCE" character varying(100) DEFAULT ''::character varying,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "T_HT" bigint DEFAULT 0,
    "T_TVA" bigint DEFAULT 0,
    "T_TTC" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "T_SERVICE" bigint DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_DEVISE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "EN_COURS" boolean DEFAULT true,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "DATE_RECEPTION_DEMANDEE" date,
    "DATE_RECEPTION_CONFIRMEE" date,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "PORT_HT" bigint DEFAULT 0 NOT NULL,
    "REMISE_HT" bigint DEFAULT 0 NOT NULL
);


ALTER TABLE "Default"."COMMANDE" OWNER TO openconcerto;

--
-- TOC entry 400 (class 1259 OID 36390038)
-- Name: COMMANDE_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."COMMANDE_CLIENT" (
    "NOM" character varying(2048) DEFAULT ''::text,
    "SOURCE" character varying(100) DEFAULT ''::character varying,
    "IDSOURCE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "DATE" date,
    "ID_CLIENT" integer DEFAULT 1,
    "DATE_ECHEANCE" date,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "T_HT" bigint DEFAULT 0,
    "T_TVA" bigint DEFAULT 0,
    "T_TTC" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "INFOS" character varying(2048) DEFAULT ''::text,
    "T_SERVICE" bigint DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "T_POIDS" real DEFAULT 0,
    "ID_DEVIS" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_ADRESSE_LIVRAISON" integer DEFAULT 1,
    "POURCENT_REMISE" numeric(12,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_CONTACT" integer DEFAULT 1,
    "ID_CLIENT_DEPARTEMENT" integer DEFAULT 1,
    "ETAT_COMMANDE" integer DEFAULT 1 NOT NULL,
    "EMBALLAGE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NUMERO_EXPEDITION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "PORT_HT" bigint DEFAULT 0 NOT NULL,
    "REMISE_HT" bigint DEFAULT 0 NOT NULL,
    "TYPE_EXPEDITION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "DATE_LIVRAISON_PREV" date,
    "FRAIS_DOCUMENT_HT" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE_FRAIS_DOCUMENT" integer DEFAULT 1
);


ALTER TABLE "Default"."COMMANDE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 401 (class 1259 OID 36390073)
-- Name: COMMANDE_CLIENT_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."COMMANDE_CLIENT_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_STYLE" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "SERVICE" boolean DEFAULT false,
    "POIDS" real DEFAULT 0,
    "QTE" integer DEFAULT 0,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "T_POIDS" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1 NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "POURCENT_REMISE" numeric(12,8) DEFAULT 0,
    "PV_T_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "T_POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "NB_COLIS" integer DEFAULT 0,
    "MONTANT_REMISE" numeric(16,8),
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "LIVRE_FORCED" boolean DEFAULT false NOT NULL,
    "LIVRE" boolean DEFAULT false NOT NULL,
    "QTE_LIVREE" numeric(16,6) DEFAULT 0,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "Default"."COMMANDE_CLIENT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 402 (class 1259 OID 36390133)
-- Name: COMMANDE_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."COMMANDE_CLIENT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."COMMANDE_CLIENT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21464 (class 0 OID 0)
-- Dependencies: 402
-- Name: COMMANDE_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."COMMANDE_CLIENT_ELEMENT_ID_seq" OWNED BY "Default"."COMMANDE_CLIENT_ELEMENT"."ID";


--
-- TOC entry 403 (class 1259 OID 36390135)
-- Name: COMMANDE_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."COMMANDE_CLIENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."COMMANDE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21465 (class 0 OID 0)
-- Dependencies: 403
-- Name: COMMANDE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."COMMANDE_CLIENT_ID_seq" OWNED BY "Default"."COMMANDE_CLIENT"."ID";


--
-- TOC entry 404 (class 1259 OID 36390137)
-- Name: COMMANDE_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."COMMANDE_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_STYLE" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "SERVICE" boolean DEFAULT false,
    "POIDS" real DEFAULT 0,
    "QTE" integer DEFAULT 0,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "T_POIDS" real DEFAULT 0,
    "ID_COMMANDE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "T_PA_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1 NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "QTE_ACHAT" integer DEFAULT 1,
    "PA_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "PA_DEVISE_T" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_CODE_FOURNISSEUR" integer DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "RECU_FORCED" boolean DEFAULT false NOT NULL,
    "RECU" boolean DEFAULT true NOT NULL,
    "QTE_RECUE" numeric(16,6) DEFAULT 0,
    "ID_DEMANDE_ACHAT_ELEMENT" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "Default"."COMMANDE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 405 (class 1259 OID 36390192)
-- Name: COMMANDE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."COMMANDE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."COMMANDE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21466 (class 0 OID 0)
-- Dependencies: 405
-- Name: COMMANDE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."COMMANDE_ELEMENT_ID_seq" OWNED BY "Default"."COMMANDE_ELEMENT"."ID";


--
-- TOC entry 406 (class 1259 OID 36390194)
-- Name: COMMANDE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."COMMANDE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."COMMANDE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21467 (class 0 OID 0)
-- Dependencies: 406
-- Name: COMMANDE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."COMMANDE_ID_seq" OWNED BY "Default"."COMMANDE"."ID";


--
-- TOC entry 407 (class 1259 OID 36390196)
-- Name: COMMERCIAL; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."COMMERCIAL" (
    "ID_COMMERCIAL" integer NOT NULL,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "PRENOM" character varying(100) DEFAULT ''::character varying,
    "FONCTION" character varying(100) DEFAULT ''::character varying,
    "TEL_STANDARD" character varying(100) DEFAULT ''::character varying,
    "TEL_DIRECT" character varying(100) DEFAULT ''::character varying,
    "TEL_MOBILE" character varying(100) DEFAULT ''::character varying,
    "TEL_PERSONEL" character varying(100) DEFAULT ''::character varying,
    "FAX" character varying(100) DEFAULT ''::character varying,
    "EMAIL" character varying(100) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "ID_USER_COMMON" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."COMMERCIAL" OWNER TO openconcerto;

--
-- TOC entry 408 (class 1259 OID 36390214)
-- Name: COMMERCIAL_ID_COMMERCIAL_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."COMMERCIAL_ID_COMMERCIAL_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."COMMERCIAL_ID_COMMERCIAL_seq" OWNER TO openconcerto;

--
-- TOC entry 21468 (class 0 OID 0)
-- Dependencies: 408
-- Name: COMMERCIAL_ID_COMMERCIAL_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."COMMERCIAL_ID_COMMERCIAL_seq" OWNED BY "Default"."COMMERCIAL"."ID_COMMERCIAL";


--
-- TOC entry 409 (class 1259 OID 36390216)
-- Name: COMPLETION; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."COMPLETION" (
    "CHAMP" character varying(100) DEFAULT ''::character varying NOT NULL,
    "LABEL" character varying(200) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Default"."COMPLETION" OWNER TO openconcerto;

--
-- TOC entry 410 (class 1259 OID 36390221)
-- Name: COMPTE_CLIENT_TRANSACTION; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."COMPTE_CLIENT_TRANSACTION" (
    "ID" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "DATE" timestamp without time zone,
    "MONTANT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."COMPTE_CLIENT_TRANSACTION" OWNER TO openconcerto;

--
-- TOC entry 411 (class 1259 OID 36390230)
-- Name: COMPTE_CLIENT_TRANSACTION_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."COMPTE_CLIENT_TRANSACTION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."COMPTE_CLIENT_TRANSACTION_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21469 (class 0 OID 0)
-- Dependencies: 411
-- Name: COMPTE_CLIENT_TRANSACTION_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."COMPTE_CLIENT_TRANSACTION_ID_seq" OWNED BY "Default"."COMPTE_CLIENT_TRANSACTION"."ID";


--
-- TOC entry 412 (class 1259 OID 36390232)
-- Name: COMPTE_PCE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."COMPTE_PCE" (
    "ID" integer NOT NULL,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "INFOS" character varying(3072) DEFAULT ''::text,
    "TOTAL_DEBIT" bigint DEFAULT 0,
    "TOTAL_CREDIT" bigint DEFAULT 0,
    "RACINE" boolean DEFAULT false,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_NATURE_COMPTE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "OBSOLETE" boolean DEFAULT false NOT NULL
);


ALTER TABLE "Default"."COMPTE_PCE" OWNER TO openconcerto;

--
-- TOC entry 413 (class 1259 OID 36390249)
-- Name: COMPTE_PCE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."COMPTE_PCE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."COMPTE_PCE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21470 (class 0 OID 0)
-- Dependencies: 413
-- Name: COMPTE_PCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."COMPTE_PCE_ID_seq" OWNED BY "Default"."COMPTE_PCE"."ID";


--
-- TOC entry 414 (class 1259 OID 36390251)
-- Name: COMPTE_PCG; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."COMPTE_PCG" (
    "ID" integer NOT NULL,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "INFOS" character varying(3072) DEFAULT ''::text,
    "ID_TYPE_COMPTE_PCG_BASE" integer DEFAULT 1,
    "ID_TYPE_COMPTE_PCG_AB" integer DEFAULT 1,
    "ID_TYPE_COMPTE_PCG_DEV" integer DEFAULT 1,
    "ID_NATURE_COMPTE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."COMPTE_PCG" OWNER TO openconcerto;

--
-- TOC entry 415 (class 1259 OID 36390267)
-- Name: COMPTE_PCG_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."COMPTE_PCG_ID_seq"
    START WITH 978
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."COMPTE_PCG_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21471 (class 0 OID 0)
-- Dependencies: 415
-- Name: COMPTE_PCG_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."COMPTE_PCG_ID_seq" OWNED BY "Default"."COMPTE_PCG"."ID";


--
-- TOC entry 416 (class 1259 OID 36390269)
-- Name: CONTACT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CONTACT" (
    "ID" integer NOT NULL,
    "NOM" character varying(100) DEFAULT ''::character varying NOT NULL,
    "PRENOM" character varying(100) DEFAULT ''::character varying NOT NULL,
    "TEL_DIRECT" character varying(100) DEFAULT ''::character varying NOT NULL,
    "TEL_MOBILE" character varying(100) DEFAULT ''::character varying NOT NULL,
    "EMAIL" character varying(100) DEFAULT ''::character varying NOT NULL,
    "FAX" character varying(100) DEFAULT ''::character varying NOT NULL,
    "ID_TITRE_PERSONNEL" integer DEFAULT 2 NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "FONCTION" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "TEL_STANDARD" character varying(100) DEFAULT ''::character varying NOT NULL,
    "TEL_PERSONEL" character varying(100) DEFAULT ''::character varying NOT NULL,
    "NO_MAILING" boolean DEFAULT false NOT NULL,
    "DATE_NAISSANCE" date
);


ALTER TABLE "Default"."CONTACT" OWNER TO openconcerto;

--
-- TOC entry 417 (class 1259 OID 36390291)
-- Name: CONTACT_ADMINISTRATIF; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CONTACT_ADMINISTRATIF" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRENOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_DIRECT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_MOBILE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "EMAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FAX" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FONCTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_PERSONEL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_STANDARD" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "N4DS" boolean DEFAULT false,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."CONTACT_ADMINISTRATIF" OWNER TO openconcerto;

--
-- TOC entry 418 (class 1259 OID 36390310)
-- Name: CONTACT_ADMINISTRATIF_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CONTACT_ADMINISTRATIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CONTACT_ADMINISTRATIF_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21472 (class 0 OID 0)
-- Dependencies: 418
-- Name: CONTACT_ADMINISTRATIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CONTACT_ADMINISTRATIF_ID_seq" OWNED BY "Default"."CONTACT_ADMINISTRATIF"."ID";


--
-- TOC entry 419 (class 1259 OID 36390312)
-- Name: CONTACT_FOURNISSEUR; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CONTACT_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRENOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_DIRECT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_MOBILE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "EMAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FAX" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FONCTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_PERSONEL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_STANDARD" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."CONTACT_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 420 (class 1259 OID 36390331)
-- Name: CONTACT_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CONTACT_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CONTACT_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21473 (class 0 OID 0)
-- Dependencies: 420
-- Name: CONTACT_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CONTACT_FOURNISSEUR_ID_seq" OWNED BY "Default"."CONTACT_FOURNISSEUR"."ID";


--
-- TOC entry 421 (class 1259 OID 36390333)
-- Name: CONTACT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CONTACT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CONTACT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21474 (class 0 OID 0)
-- Dependencies: 421
-- Name: CONTACT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CONTACT_ID_seq" OWNED BY "Default"."CONTACT"."ID";


--
-- TOC entry 422 (class 1259 OID 36390335)
-- Name: CONTRAT_PREVOYANCE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CONTRAT_PREVOYANCE" (
    "ID" integer NOT NULL,
    "REFERENCE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DATE_DEBUT" timestamp without time zone,
    "DATE_FIN" timestamp without time zone,
    "CODE_ORGANISME" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_DELEGATAIRE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_UNIQUE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "COTISATION_ETABLISSEMENT" boolean DEFAULT false NOT NULL
);


ALTER TABLE "Default"."CONTRAT_PREVOYANCE" OWNER TO openconcerto;

--
-- TOC entry 423 (class 1259 OID 36390349)
-- Name: CONTRAT_PREVOYANCE_AYANT_DROIT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CONTRAT_PREVOYANCE_AYANT_DROIT" (
    "ID" integer NOT NULL,
    "ID_AYANT_DROIT" integer DEFAULT 1,
    "ID_CONTRAT_PREVOYANCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."CONTRAT_PREVOYANCE_AYANT_DROIT" OWNER TO openconcerto;

--
-- TOC entry 424 (class 1259 OID 36390356)
-- Name: CONTRAT_PREVOYANCE_AYANT_DROIT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CONTRAT_PREVOYANCE_AYANT_DROIT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CONTRAT_PREVOYANCE_AYANT_DROIT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21475 (class 0 OID 0)
-- Dependencies: 424
-- Name: CONTRAT_PREVOYANCE_AYANT_DROIT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CONTRAT_PREVOYANCE_AYANT_DROIT_ID_seq" OWNED BY "Default"."CONTRAT_PREVOYANCE_AYANT_DROIT"."ID";


--
-- TOC entry 425 (class 1259 OID 36390358)
-- Name: CONTRAT_PREVOYANCE_CONTRAT_SALARIE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE" (
    "ID" integer NOT NULL,
    "ID_INFOS_SALARIE_PAYE" integer DEFAULT 1,
    "ID_CONTRAT_PREVOYANCE" integer DEFAULT 1,
    "CODE_OPTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_POPULATION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NB_ENFANT_CHARGE" integer,
    "NB_ADULTE_AYANT_DROIT" integer,
    "NB_AYANT_DROIT" integer,
    "NB_AYANT_DROIT_AUTRE" integer,
    "NB_ENFANT_AYANT_DROIT" integer,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE" OWNER TO openconcerto;

--
-- TOC entry 426 (class 1259 OID 36390370)
-- Name: CONTRAT_PREVOYANCE_CONTRAT_SALARIE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21476 (class 0 OID 0)
-- Dependencies: 426
-- Name: CONTRAT_PREVOYANCE_CONTRAT_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE_ID_seq" OWNED BY "Default"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE"."ID";


--
-- TOC entry 427 (class 1259 OID 36390372)
-- Name: CONTRAT_PREVOYANCE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CONTRAT_PREVOYANCE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CONTRAT_PREVOYANCE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21477 (class 0 OID 0)
-- Dependencies: 427
-- Name: CONTRAT_PREVOYANCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CONTRAT_PREVOYANCE_ID_seq" OWNED BY "Default"."CONTRAT_PREVOYANCE"."ID";


--
-- TOC entry 428 (class 1259 OID 36390374)
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CONTRAT_PREVOYANCE_RUBRIQUE" (
    "ID" integer NOT NULL,
    "ID_RUBRIQUE_COTISATION" integer DEFAULT 1,
    "ID_CONTRAT_PREVOYANCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."CONTRAT_PREVOYANCE_RUBRIQUE" OWNER TO openconcerto;

--
-- TOC entry 429 (class 1259 OID 36390381)
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CONTRAT_PREVOYANCE_RUBRIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CONTRAT_PREVOYANCE_RUBRIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21478 (class 0 OID 0)
-- Dependencies: 429
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CONTRAT_PREVOYANCE_RUBRIQUE_ID_seq" OWNED BY "Default"."CONTRAT_PREVOYANCE_RUBRIQUE"."ID";


--
-- TOC entry 430 (class 1259 OID 36390383)
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE_NET; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CONTRAT_PREVOYANCE_RUBRIQUE_NET" (
    "ID" integer NOT NULL,
    "ID_RUBRIQUE_NET" integer DEFAULT 1,
    "ID_CONTRAT_PREVOYANCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."CONTRAT_PREVOYANCE_RUBRIQUE_NET" OWNER TO openconcerto;

--
-- TOC entry 431 (class 1259 OID 36390390)
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE_NET_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CONTRAT_PREVOYANCE_RUBRIQUE_NET_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CONTRAT_PREVOYANCE_RUBRIQUE_NET_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21479 (class 0 OID 0)
-- Dependencies: 431
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE_NET_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CONTRAT_PREVOYANCE_RUBRIQUE_NET_ID_seq" OWNED BY "Default"."CONTRAT_PREVOYANCE_RUBRIQUE_NET"."ID";


--
-- TOC entry 432 (class 1259 OID 36390392)
-- Name: CONTRAT_SALARIE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CONTRAT_SALARIE" (
    "ID" integer NOT NULL,
    "NATURE" character varying(2048) DEFAULT ''::text,
    "ID_CODE_EMPLOI" integer DEFAULT 1,
    "ID_CODE_CONTRAT_TRAVAIL" integer DEFAULT 1,
    "ID_CODE_DROIT_CONTRAT" integer DEFAULT 1,
    "ID_CODE_CARACT_ACTIVITE" integer DEFAULT 1,
    "ID_CODE_STATUT_PROF" integer DEFAULT 1,
    "ID_CODE_STATUT_CATEGORIEL" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "CODE_IRC_UGRR" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_UGRR" character varying(64) DEFAULT ''::character varying NOT NULL,
    "CODE_IRC_UGRC" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_UGRC" character varying(64) DEFAULT ''::character varying NOT NULL,
    "CODE_IRC_RETRAITE" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_RETRAITE" character varying(64) DEFAULT ''::character varying NOT NULL,
    "ID_CODE_STATUT_CAT_CONV" integer DEFAULT 1,
    "NUMERO" character varying(128) DEFAULT '00000'::character varying NOT NULL,
    "CODE_REGIME_RETRAITE_DSN" character varying(128) DEFAULT '00000'::character varying NOT NULL,
    "DATE_PREV_FIN" timestamp without time zone,
    "ID_CONTRAT_MODALITE_TEMPS" integer DEFAULT 1,
    "ID_CONTRAT_REGIME_MALADIE" integer DEFAULT 1,
    "ID_CONTRAT_REGIME_VIEILLESSE" integer DEFAULT 1,
    "ID_CONTRAT_MOTIF_RECOURS" integer DEFAULT 1,
    "ID_CONTRAT_DETACHE_EXPATRIE" integer DEFAULT 1,
    "ID_CONTRAT_DISPOSITIF_POLITIQUE" integer DEFAULT 1,
    "DATE_DEBUT" timestamp without time zone,
    "DATE_MODIFICATION" timestamp without time zone
);


ALTER TABLE "Default"."CONTRAT_SALARIE" OWNER TO openconcerto;

--
-- TOC entry 433 (class 1259 OID 36390423)
-- Name: CONTRAT_SALARIE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CONTRAT_SALARIE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CONTRAT_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21480 (class 0 OID 0)
-- Dependencies: 433
-- Name: CONTRAT_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CONTRAT_SALARIE_ID_seq" OWNED BY "Default"."CONTRAT_SALARIE"."ID";


--
-- TOC entry 434 (class 1259 OID 36390425)
-- Name: COURRIER_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."COURRIER_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying,
    "ID_MODELE_COURRIER_CLIENT" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "DATE" date,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."COURRIER_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 435 (class 1259 OID 36390439)
-- Name: COURRIER_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."COURRIER_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."COURRIER_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21481 (class 0 OID 0)
-- Dependencies: 435
-- Name: COURRIER_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."COURRIER_CLIENT_ID_seq" OWNED BY "Default"."COURRIER_CLIENT"."ID";


--
-- TOC entry 1334 (class 1259 OID 36417075)
-- Name: COUT_REVIENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."COUT_REVIENT" (
    "ID" integer NOT NULL,
    "CODE" character varying(48) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "POURCENT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."COUT_REVIENT" OWNER TO openconcerto;

--
-- TOC entry 1333 (class 1259 OID 36417073)
-- Name: COUT_REVIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."COUT_REVIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."COUT_REVIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21482 (class 0 OID 0)
-- Dependencies: 1333
-- Name: COUT_REVIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."COUT_REVIENT_ID_seq" OWNED BY "Default"."COUT_REVIENT"."ID";


--
-- TOC entry 436 (class 1259 OID 36390441)
-- Name: CUMULS_CONGES; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CUMULS_CONGES" (
    "ID" integer NOT NULL,
    "RESTANT" real DEFAULT 0,
    "ACQUIS" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."CUMULS_CONGES" OWNER TO openconcerto;

--
-- TOC entry 437 (class 1259 OID 36390449)
-- Name: CUMULS_CONGES_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CUMULS_CONGES_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CUMULS_CONGES_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21483 (class 0 OID 0)
-- Dependencies: 437
-- Name: CUMULS_CONGES_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CUMULS_CONGES_ID_seq" OWNED BY "Default"."CUMULS_CONGES"."ID";


--
-- TOC entry 438 (class 1259 OID 36390451)
-- Name: CUMULS_PAYE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."CUMULS_PAYE" (
    "ID" integer NOT NULL,
    "SAL_BRUT_C" numeric(16,2) DEFAULT 0,
    "COT_PAT_C" numeric(16,2) DEFAULT 0,
    "COT_SAL_C" numeric(16,2) DEFAULT 0,
    "NET_IMP_C" numeric(16,2) DEFAULT 0,
    "NET_A_PAYER_C" numeric(16,2) DEFAULT 0,
    "CSG_C" numeric(16,2) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "HEURE_TRAV_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "TAXE_CM_SAL_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "TAXE_CM_PAT_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "SAL_BRUT_COTISABLE_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "SAL_BRUT_TAXABLE_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "SAL_BASE_BRUT_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "ALLEGEMENT_COTISATION_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "CICE_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "AVANTAGE_NATURE_C" numeric(16,2) DEFAULT 0 NOT NULL
);


ALTER TABLE "Default"."CUMULS_PAYE" OWNER TO openconcerto;

--
-- TOC entry 439 (class 1259 OID 36390472)
-- Name: CUMULS_PAYE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."CUMULS_PAYE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."CUMULS_PAYE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21484 (class 0 OID 0)
-- Dependencies: 439
-- Name: CUMULS_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."CUMULS_PAYE_ID_seq" OWNED BY "Default"."CUMULS_PAYE"."ID";


--
-- TOC entry 440 (class 1259 OID 36390474)
-- Name: DECLARATION_DSN; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."DECLARATION_DSN" (
    "ID" integer NOT NULL,
    "ID_DSN_NATURE" integer DEFAULT 1,
    "DATE" timestamp without time zone,
    "DATE_ENVOI" timestamp without time zone,
    "TEST" boolean DEFAULT false NOT NULL,
    "ENVOYE" boolean DEFAULT false NOT NULL,
    "COMMENTAIRE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "DSN_FILE" character varying(75000) DEFAULT ''::character varying NOT NULL,
    "NUMERO" integer DEFAULT 1 NOT NULL,
    "ANNEE" integer DEFAULT 2016 NOT NULL,
    "ID_MOIS" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_ARRET_TRAVAIL" integer DEFAULT 1,
    "ID_REPRISE_TRAVAIL" integer DEFAULT 1,
    "ID_MOIS_REGUL" integer DEFAULT 1,
    "ANNULE_REMPLACE" boolean DEFAULT false NOT NULL,
    "ID_FIN_CONTRAT" integer DEFAULT 1,
    "NUMERO_REFERENCE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_DECLARATION_DSN_ANNULATION" integer DEFAULT 1,
    "EFFECTIF_CVAE" integer,
    "CODE_INSEE_CVAE" character varying(32) DEFAULT ''::character varying NOT NULL,
    "PERIODE_CVAE_DEBUT" date,
    "PERIODE_CVAE_FIN" date
);


ALTER TABLE "Default"."DECLARATION_DSN" OWNER TO openconcerto;

--
-- TOC entry 441 (class 1259 OID 36390498)
-- Name: DECLARATION_DSN_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."DECLARATION_DSN_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."DECLARATION_DSN_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21485 (class 0 OID 0)
-- Dependencies: 441
-- Name: DECLARATION_DSN_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."DECLARATION_DSN_ID_seq" OWNED BY "Default"."DECLARATION_DSN"."ID";


--
-- TOC entry 442 (class 1259 OID 36390500)
-- Name: DEMANDE_ACHAT_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."DEMANDE_ACHAT_ELEMENT" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "QTE" integer DEFAULT 1 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1 NOT NULL,
    "REPERE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "REFERENCE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_FABRICANT" integer DEFAULT 1,
    "DATE" date,
    "ID_ETAT_DEMANDE_ACHAT_ELEMENT" integer DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "EN_STOCK" boolean DEFAULT false NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8),
    "REPERE_SOURCE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "CODE_SOURCE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "NOM_SOURCE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "NUMERO_SE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "DESCRIPTIF_SE" character varying(512) DEFAULT ''::character varying NOT NULL,
    "REVISION" character varying(48) DEFAULT ''::character varying NOT NULL,
    "P_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_COMMANDE" integer DEFAULT 1,
    "ID_BON_RECEPTION" integer DEFAULT 1,
    "QTE_RECUE" integer DEFAULT 0 NOT NULL,
    "REPRISE" boolean DEFAULT false NOT NULL,
    "IMPORT" boolean DEFAULT false NOT NULL
);


ALTER TABLE "Default"."DEMANDE_ACHAT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 443 (class 1259 OID 36390533)
-- Name: DEMANDE_ACHAT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."DEMANDE_ACHAT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."DEMANDE_ACHAT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21486 (class 0 OID 0)
-- Dependencies: 443
-- Name: DEMANDE_ACHAT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."DEMANDE_ACHAT_ELEMENT_ID_seq" OWNED BY "Default"."DEMANDE_ACHAT_ELEMENT"."ID";


--
-- TOC entry 444 (class 1259 OID 36390535)
-- Name: DEMANDE_PRIX; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."DEMANDE_PRIX" (
    "ID" integer NOT NULL,
    "NUMERO" character varying(256) DEFAULT ''::character varying NOT NULL,
    "OBJET" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "DATE" date,
    "DATE_BUTOIRE" date,
    "T_HT" bigint DEFAULT 0,
    "T_TVA" bigint DEFAULT 0,
    "T_TTC" bigint DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ID_ETAT_DEMANDE_PRIX" integer DEFAULT 1,
    "INFOS" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."DEMANDE_PRIX" OWNER TO openconcerto;

--
-- TOC entry 445 (class 1259 OID 36390551)
-- Name: DEMANDE_PRIX_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."DEMANDE_PRIX_ELEMENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ID_DEMANDE_PRIX" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 2,
    "QTE" integer DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PA_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_POIDS" real DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 5,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_STYLE" integer DEFAULT 1,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "QTE_ACHAT" integer DEFAULT 1 NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "SERVICE" boolean DEFAULT false,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "POIDS" real DEFAULT 0,
    "PA_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "PA_DEVISE_T" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1 NOT NULL,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0 NOT NULL,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_DEMANDE_ACHAT_ELEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8),
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "Default"."DEMANDE_PRIX_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 446 (class 1259 OID 36390600)
-- Name: DEMANDE_PRIX_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."DEMANDE_PRIX_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."DEMANDE_PRIX_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21487 (class 0 OID 0)
-- Dependencies: 446
-- Name: DEMANDE_PRIX_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."DEMANDE_PRIX_ELEMENT_ID_seq" OWNED BY "Default"."DEMANDE_PRIX_ELEMENT"."ID";


--
-- TOC entry 447 (class 1259 OID 36390602)
-- Name: DEMANDE_PRIX_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."DEMANDE_PRIX_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."DEMANDE_PRIX_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21488 (class 0 OID 0)
-- Dependencies: 447
-- Name: DEMANDE_PRIX_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."DEMANDE_PRIX_ID_seq" OWNED BY "Default"."DEMANDE_PRIX"."ID";


--
-- TOC entry 448 (class 1259 OID 36390604)
-- Name: DEPARTEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."DEPARTEMENT" (
    "ID" integer NOT NULL,
    "NUMERO" character varying(10) DEFAULT ''::character varying,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "CHEF_LIEU" character varying(100) DEFAULT ''::character varying,
    "REGION_ADMIN" character varying(100) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."DEPARTEMENT" OWNER TO openconcerto;

--
-- TOC entry 449 (class 1259 OID 36390614)
-- Name: DEPARTEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."DEPARTEMENT_ID_seq"
    START WITH 102
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."DEPARTEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21489 (class 0 OID 0)
-- Dependencies: 449
-- Name: DEPARTEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."DEPARTEMENT_ID_seq" OWNED BY "Default"."DEPARTEMENT"."ID";


--
-- TOC entry 1330 (class 1259 OID 36416965)
-- Name: DEPOT_CHEQUE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."DEPOT_CHEQUE" (
    "ID" integer NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "MONTANT" bigint DEFAULT 0 NOT NULL,
    "DATE" date,
    "ID_BANQUE" integer DEFAULT 1,
    "ID_ECRITURE" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."DEPOT_CHEQUE" OWNER TO openconcerto;

--
-- TOC entry 1332 (class 1259 OID 36417002)
-- Name: DEPOT_CHEQUE_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."DEPOT_CHEQUE_ELEMENT" (
    "ID" integer NOT NULL,
    "NUMERO" character varying(128) DEFAULT ''::character varying NOT NULL,
    "BANQUE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "PIECE" character varying(512) DEFAULT ''::character varying NOT NULL,
    "MONTANT" bigint DEFAULT 0 NOT NULL,
    "DATE" date,
    "ID_CHEQUE_A_ENCAISSER" integer DEFAULT 1,
    "ID_ECRITURE" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_DEPOT_CHEQUE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8),
    "TIERS" character varying(256) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Default"."DEPOT_CHEQUE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1331 (class 1259 OID 36417000)
-- Name: DEPOT_CHEQUE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."DEPOT_CHEQUE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."DEPOT_CHEQUE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21490 (class 0 OID 0)
-- Dependencies: 1331
-- Name: DEPOT_CHEQUE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."DEPOT_CHEQUE_ELEMENT_ID_seq" OWNED BY "Default"."DEPOT_CHEQUE_ELEMENT"."ID";


--
-- TOC entry 1329 (class 1259 OID 36416963)
-- Name: DEPOT_CHEQUE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."DEPOT_CHEQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."DEPOT_CHEQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21491 (class 0 OID 0)
-- Dependencies: 1329
-- Name: DEPOT_CHEQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."DEPOT_CHEQUE_ID_seq" OWNED BY "Default"."DEPOT_CHEQUE"."ID";


--
-- TOC entry 1348 (class 1259 OID 36417673)
-- Name: DEPOT_STOCK; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."DEPOT_STOCK" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "UI_LOCK" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_USER_UI_LOCK" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."DEPOT_STOCK" OWNER TO openconcerto;

--
-- TOC entry 1347 (class 1259 OID 36417671)
-- Name: DEPOT_STOCK_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."DEPOT_STOCK_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."DEPOT_STOCK_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21492 (class 0 OID 0)
-- Dependencies: 1347
-- Name: DEPOT_STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."DEPOT_STOCK_ID_seq" OWNED BY "Default"."DEPOT_STOCK"."ID";


--
-- TOC entry 450 (class 1259 OID 36390616)
-- Name: DEVIS; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."DEVIS" (
    "ID_DEVIS" integer NOT NULL,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "DATE" date,
    "OBJET" character varying(100) DEFAULT ''::character varying,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "T_HT" bigint DEFAULT 0,
    "T_TVA" bigint DEFAULT 0,
    "T_TTC" bigint DEFAULT 0,
    "PORT_HT" bigint DEFAULT 0,
    "REMISE_HT" bigint DEFAULT 0,
    "T_SERVICE" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_ETAT_DEVIS" integer DEFAULT 1,
    "DATE_ENVOI" timestamp without time zone,
    "T_POIDS" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_ADRESSE" integer DEFAULT 1,
    "DATE_VALIDITE" date,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "ID_ADRESSE_LIVRAISON" integer DEFAULT 1,
    "POURCENT_REMISE" numeric(12,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_CONTACT" integer DEFAULT 1,
    "ID_CLIENT_DEPARTEMENT" integer DEFAULT 1,
    "T_HA" bigint DEFAULT 0 NOT NULL,
    "DUNNING_DATE" date,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "T_ACOMPTE" bigint DEFAULT 0 NOT NULL,
    "FRAIS_DOCUMENT_HT" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE_FRAIS_DOCUMENT" integer DEFAULT 1
);


ALTER TABLE "Default"."DEVIS" OWNER TO openconcerto;

--
-- TOC entry 451 (class 1259 OID 36390647)
-- Name: DEVISE_HISTORIQUE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."DEVISE_HISTORIQUE" (
    "ID" integer NOT NULL,
    "DATE" timestamp without time zone,
    "SRC" character varying(8) DEFAULT ''::character varying NOT NULL,
    "DST" character varying(8) DEFAULT ''::character varying NOT NULL,
    "TAUX" numeric(12,6) DEFAULT 1 NOT NULL,
    "TAUX_COMMERCIAL" numeric(12,6) DEFAULT 1 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."DEVISE_HISTORIQUE" OWNER TO openconcerto;

--
-- TOC entry 452 (class 1259 OID 36390656)
-- Name: DEVISE_HISTORIQUE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."DEVISE_HISTORIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."DEVISE_HISTORIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21493 (class 0 OID 0)
-- Dependencies: 452
-- Name: DEVISE_HISTORIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."DEVISE_HISTORIQUE_ID_seq" OWNED BY "Default"."DEVISE_HISTORIQUE"."ID";


--
-- TOC entry 453 (class 1259 OID 36390658)
-- Name: DEVIS_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."DEVIS_ELEMENT" (
    "ID_DEVIS_ELEMENT" integer NOT NULL,
    "ID_STYLE" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "QTE" integer DEFAULT 1,
    "ID_DEVIS" integer DEFAULT 1,
    "SERVICE" boolean DEFAULT false,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "T_POIDS" real DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1 NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "POURCENT_REMISE" numeric(12,8) DEFAULT 0,
    "PV_T_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "T_POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "NB_COLIS" integer DEFAULT 0,
    "MONTANT_REMISE" numeric(16,8),
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_DEPOT_STOCK" integer DEFAULT 1,
    "LIVRE_FORCED" boolean DEFAULT false NOT NULL,
    "LIVRE" boolean DEFAULT false NOT NULL,
    "QTE_LIVREE" numeric(16,6) DEFAULT 0
);


ALTER TABLE "Default"."DEVIS_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 454 (class 1259 OID 36390715)
-- Name: DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq" OWNER TO openconcerto;

--
-- TOC entry 21494 (class 0 OID 0)
-- Dependencies: 454
-- Name: DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq" OWNED BY "Default"."DEVIS_ELEMENT"."ID_DEVIS_ELEMENT";


--
-- TOC entry 455 (class 1259 OID 36390717)
-- Name: DEVIS_ID_DEVIS_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."DEVIS_ID_DEVIS_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."DEVIS_ID_DEVIS_seq" OWNER TO openconcerto;

--
-- TOC entry 21495 (class 0 OID 0)
-- Dependencies: 455
-- Name: DEVIS_ID_DEVIS_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."DEVIS_ID_DEVIS_seq" OWNED BY "Default"."DEVIS"."ID_DEVIS";


--
-- TOC entry 456 (class 1259 OID 36390719)
-- Name: ECHANTILLON_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ECHANTILLON_ELEMENT" (
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "QTE" integer DEFAULT 1,
    "PV_HT" bigint DEFAULT 0,
    "T_PV_HT" bigint DEFAULT 0,
    "T_PV_TTC" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."ECHANTILLON_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 457 (class 1259 OID 36390733)
-- Name: ECHANTILLON_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ECHANTILLON_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ECHANTILLON_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21496 (class 0 OID 0)
-- Dependencies: 457
-- Name: ECHANTILLON_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ECHANTILLON_ELEMENT_ID_seq" OWNED BY "Default"."ECHANTILLON_ELEMENT"."ID";


--
-- TOC entry 458 (class 1259 OID 36390735)
-- Name: ECHEANCE_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ECHEANCE_CLIENT" (
    "ID" integer NOT NULL,
    "MONTANT" bigint DEFAULT 0,
    "DATE" date,
    "NOMBRE_RELANCE" integer DEFAULT 0,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_CLIENT" integer DEFAULT 1,
    "REGLE" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "RETOUR_NATEXIS" boolean DEFAULT false,
    "REG_COMPTA" boolean DEFAULT false,
    "DATE_LAST_RELANCE" date,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "TIERS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_COMPTE_PCE_TIERS" integer DEFAULT 1
);


ALTER TABLE "Default"."ECHEANCE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 459 (class 1259 OID 36390751)
-- Name: ECHEANCE_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ECHEANCE_CLIENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ECHEANCE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21497 (class 0 OID 0)
-- Dependencies: 459
-- Name: ECHEANCE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ECHEANCE_CLIENT_ID_seq" OWNED BY "Default"."ECHEANCE_CLIENT"."ID";


--
-- TOC entry 460 (class 1259 OID 36390753)
-- Name: ECHEANCE_FOURNISSEUR; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ECHEANCE_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "MONTANT" bigint DEFAULT 0,
    "DATE" date,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "REGLE" boolean DEFAULT false,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "REG_COMPTA" boolean DEFAULT false
);


ALTER TABLE "Default"."ECHEANCE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 461 (class 1259 OID 36390764)
-- Name: ECHEANCE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ECHEANCE_FOURNISSEUR_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ECHEANCE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21498 (class 0 OID 0)
-- Dependencies: 461
-- Name: ECHEANCE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ECHEANCE_FOURNISSEUR_ID_seq" OWNED BY "Default"."ECHEANCE_FOURNISSEUR"."ID";


--
-- TOC entry 462 (class 1259 OID 36390766)
-- Name: ECRITURE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ECRITURE" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "DATE" date,
    "DEBIT" bigint DEFAULT 0,
    "CREDIT" bigint DEFAULT 0,
    "ID_JOURNAL" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "VALIDE" boolean DEFAULT false,
    "ORDRE" numeric(16,8),
    "POINTEE" character varying(45) DEFAULT ''::character varying,
    "DATE_POINTEE" date,
    "DATE_VALIDE" date,
    "IDUSER_CREATE" integer DEFAULT 1,
    "IDUSER_VALIDE" integer DEFAULT 1,
    "IDUSER_DELETE" integer DEFAULT 1,
    "LETTRAGE" character varying(256) DEFAULT ''::character varying,
    "DATE_LETTRAGE" date,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "JOURNAL_NOM" character varying(2048) DEFAULT ''::text,
    "JOURNAL_CODE" character varying(2048) DEFAULT ''::text,
    "COMPTE_NOM" character varying(2048) DEFAULT ''::text,
    "COMPTE_NUMERO" character varying(2048) DEFAULT ''::text,
    "DATE_EXPORT" date,
    "CODE_CLIENT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM_PIECE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "CLOTURE" boolean DEFAULT false NOT NULL,
    "RAN" boolean DEFAULT false NOT NULL,
    "DATE_ECHEANCE" date
);


ALTER TABLE "Default"."ECRITURE" OWNER TO openconcerto;

--
-- TOC entry 463 (class 1259 OID 36390793)
-- Name: ECRITURE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ECRITURE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ECRITURE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21499 (class 0 OID 0)
-- Dependencies: 463
-- Name: ECRITURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ECRITURE_ID_seq" OWNED BY "Default"."ECRITURE"."ID";


--
-- TOC entry 464 (class 1259 OID 36390795)
-- Name: EMPLOYEUR_MULTIPLE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."EMPLOYEUR_MULTIPLE" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."EMPLOYEUR_MULTIPLE" OWNER TO openconcerto;

--
-- TOC entry 465 (class 1259 OID 36390802)
-- Name: EMPLOYEUR_MULTIPLE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."EMPLOYEUR_MULTIPLE_ID_seq"
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."EMPLOYEUR_MULTIPLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21500 (class 0 OID 0)
-- Dependencies: 465
-- Name: EMPLOYEUR_MULTIPLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."EMPLOYEUR_MULTIPLE_ID_seq" OWNED BY "Default"."EMPLOYEUR_MULTIPLE"."ID";


--
-- TOC entry 466 (class 1259 OID 36390804)
-- Name: ENCAISSER_MONTANT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ENCAISSER_MONTANT" (
    "ID" integer NOT NULL,
    "DATE" date,
    "MONTANT" bigint DEFAULT 0,
    "ID_ECHEANCE_CLIENT" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NOM" character varying(200),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_TICKET_CAISSE" integer DEFAULT 1,
    "ACOMPTE" boolean DEFAULT false NOT NULL,
    "ID_DEVIS" integer DEFAULT 1,
    "TIERS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_COMPTE_PCE_TIERS" integer DEFAULT 1
);


ALTER TABLE "Default"."ENCAISSER_MONTANT" OWNER TO openconcerto;

--
-- TOC entry 467 (class 1259 OID 36390818)
-- Name: ENCAISSER_MONTANT_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ENCAISSER_MONTANT_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_ECHEANCE_CLIENT" integer DEFAULT 1,
    "ID_MOUVEMENT_ECHEANCE" integer DEFAULT 1,
    "ID_ENCAISSER_MONTANT" integer DEFAULT 1,
    "MONTANT_REGLE" bigint DEFAULT 0,
    "MONTANT_A_REGLER" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "DATE" date
);


ALTER TABLE "Default"."ENCAISSER_MONTANT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 468 (class 1259 OID 36390828)
-- Name: ENCAISSER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ENCAISSER_MONTANT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ENCAISSER_MONTANT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21501 (class 0 OID 0)
-- Dependencies: 468
-- Name: ENCAISSER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ENCAISSER_MONTANT_ELEMENT_ID_seq" OWNED BY "Default"."ENCAISSER_MONTANT_ELEMENT"."ID";


--
-- TOC entry 469 (class 1259 OID 36390830)
-- Name: ENCAISSER_MONTANT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ENCAISSER_MONTANT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ENCAISSER_MONTANT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21502 (class 0 OID 0)
-- Dependencies: 469
-- Name: ENCAISSER_MONTANT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ENCAISSER_MONTANT_ID_seq" OWNED BY "Default"."ENCAISSER_MONTANT"."ID";


--
-- TOC entry 470 (class 1259 OID 36390832)
-- Name: ETAT_CIVIL; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ETAT_CIVIL" (
    "ID" integer NOT NULL,
    "ID_ADRESSE" integer DEFAULT 1,
    "DATE_NAISSANCE" date,
    "NUMERO_SS" character varying(45) DEFAULT ''::character varying,
    "NB_ENFANTS" integer DEFAULT 0,
    "COMMUNE_NAISSANCE" character varying(45) DEFAULT ''::character varying,
    "ID_DEPARTEMENT_NAISSANCE" integer DEFAULT 1,
    "ID_PAYS_NAISSANCE" integer DEFAULT 1,
    "TELEPHONE" character varying(45) DEFAULT ''::character varying,
    "MAIL" character varying(45) DEFAULT ''::character varying,
    "PORTABLE" character varying(45) DEFAULT ''::character varying,
    "NB_PERS_A_CHARGE" integer DEFAULT 0,
    "ID_SITUATION_FAMILIALE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "NATIONNALITE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CNPS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TYPE_PIECE_IDENTITE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NUMERO_PIECE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM_PERE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM_MERE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CONJOINT_NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CONJOINT_DATE_NAISSANCE" date,
    "CONJOINT_LIEU_NAISSANCE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CONJOINT_PROFESSION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DATE_DEBUT_PIECE" date,
    "DATE_FIN_PIECE" date,
    "NTT" character varying(50) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Default"."ETAT_CIVIL" OWNER TO openconcerto;

--
-- TOC entry 471 (class 1259 OID 36390861)
-- Name: ETAT_CIVIL_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ETAT_CIVIL_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ETAT_CIVIL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21503 (class 0 OID 0)
-- Dependencies: 471
-- Name: ETAT_CIVIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ETAT_CIVIL_ID_seq" OWNED BY "Default"."ETAT_CIVIL"."ID";


--
-- TOC entry 472 (class 1259 OID 36390863)
-- Name: ETAT_DEMANDE_ACHAT_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ETAT_DEMANDE_ACHAT_ELEMENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "COLOR" integer,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."ETAT_DEMANDE_ACHAT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 473 (class 1259 OID 36390868)
-- Name: ETAT_DEMANDE_ACHAT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ETAT_DEMANDE_ACHAT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ETAT_DEMANDE_ACHAT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21504 (class 0 OID 0)
-- Dependencies: 473
-- Name: ETAT_DEMANDE_ACHAT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ETAT_DEMANDE_ACHAT_ELEMENT_ID_seq" OWNED BY "Default"."ETAT_DEMANDE_ACHAT_ELEMENT"."ID";


--
-- TOC entry 474 (class 1259 OID 36390870)
-- Name: ETAT_DEMANDE_PRIX; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ETAT_DEMANDE_PRIX" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."ETAT_DEMANDE_PRIX" OWNER TO openconcerto;

--
-- TOC entry 475 (class 1259 OID 36390875)
-- Name: ETAT_DEMANDE_PRIX_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ETAT_DEMANDE_PRIX_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ETAT_DEMANDE_PRIX_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21505 (class 0 OID 0)
-- Dependencies: 475
-- Name: ETAT_DEMANDE_PRIX_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ETAT_DEMANDE_PRIX_ID_seq" OWNED BY "Default"."ETAT_DEMANDE_PRIX"."ID";


--
-- TOC entry 476 (class 1259 OID 36390877)
-- Name: ETAT_DEVIS; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ETAT_DEVIS" (
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."ETAT_DEVIS" OWNER TO openconcerto;

--
-- TOC entry 477 (class 1259 OID 36390885)
-- Name: ETAT_DEVIS_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ETAT_DEVIS_ID_seq"
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ETAT_DEVIS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21506 (class 0 OID 0)
-- Dependencies: 477
-- Name: ETAT_DEVIS_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ETAT_DEVIS_ID_seq" OWNED BY "Default"."ETAT_DEVIS"."ID";


--
-- TOC entry 478 (class 1259 OID 36390887)
-- Name: ETAT_RAPPORT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ETAT_RAPPORT" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048),
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."ETAT_RAPPORT" OWNER TO openconcerto;

--
-- TOC entry 479 (class 1259 OID 36390897)
-- Name: ETAT_RAPPORT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ETAT_RAPPORT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ETAT_RAPPORT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21507 (class 0 OID 0)
-- Dependencies: 479
-- Name: ETAT_RAPPORT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ETAT_RAPPORT_ID_seq" OWNED BY "Default"."ETAT_RAPPORT"."ID";


--
-- TOC entry 1326 (class 1259 OID 36416899)
-- Name: ETAT_STOCK; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ETAT_STOCK" (
    "ID" integer NOT NULL,
    "DATE" date,
    "MONTANT_HA" numeric(16,8) DEFAULT 0,
    "MONTANT_VT" numeric(16,8) DEFAULT 0,
    "INVENTAIRE" boolean DEFAULT false NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."ETAT_STOCK" OWNER TO openconcerto;

--
-- TOC entry 1328 (class 1259 OID 36416913)
-- Name: ETAT_STOCK_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."ETAT_STOCK_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_ETAT_STOCK" integer DEFAULT 1,
    "PA" numeric(16,8) DEFAULT 0,
    "PV" numeric(16,8) DEFAULT 0,
    "T_PA" numeric(16,8) DEFAULT 0,
    "T_PV" numeric(16,8) DEFAULT 0,
    "QTE" numeric(16,8) DEFAULT 0,
    "ECART" numeric(16,8) DEFAULT 0,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."ETAT_STOCK_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1327 (class 1259 OID 36416911)
-- Name: ETAT_STOCK_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ETAT_STOCK_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ETAT_STOCK_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21508 (class 0 OID 0)
-- Dependencies: 1327
-- Name: ETAT_STOCK_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ETAT_STOCK_ELEMENT_ID_seq" OWNED BY "Default"."ETAT_STOCK_ELEMENT"."ID";


--
-- TOC entry 1325 (class 1259 OID 36416897)
-- Name: ETAT_STOCK_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."ETAT_STOCK_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."ETAT_STOCK_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21509 (class 0 OID 0)
-- Dependencies: 1325
-- Name: ETAT_STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."ETAT_STOCK_ID_seq" OWNED BY "Default"."ETAT_STOCK"."ID";


--
-- TOC entry 480 (class 1259 OID 36390899)
-- Name: FABRICANT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."FABRICANT" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."FABRICANT" OWNER TO openconcerto;

--
-- TOC entry 481 (class 1259 OID 36390904)
-- Name: FABRICANT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."FABRICANT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."FABRICANT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21510 (class 0 OID 0)
-- Dependencies: 481
-- Name: FABRICANT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."FABRICANT_ID_seq" OWNED BY "Default"."FABRICANT"."ID";


--
-- TOC entry 482 (class 1259 OID 36390906)
-- Name: FACTURATION_COMMANDE_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."FACTURATION_COMMANDE_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TYPE_FACTURE" integer DEFAULT 1 NOT NULL,
    "CHOICE" boolean DEFAULT false NOT NULL,
    "ID_TYPE_REGLEMENT" integer DEFAULT 1,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "AJOURS" integer DEFAULT 0 NOT NULL,
    "MONTANT" numeric(16,8) DEFAULT 0 NOT NULL,
    "POURCENT" numeric(16,8) DEFAULT 0 NOT NULL,
    "COMPTANT" boolean DEFAULT false NOT NULL,
    "DATE_PREVISIONNELLE" date,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8),
    "FIN_MOIS" boolean DEFAULT false NOT NULL,
    "LENJOUR" integer DEFAULT 0 NOT NULL
);


ALTER TABLE "Default"."FACTURATION_COMMANDE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 483 (class 1259 OID 36390923)
-- Name: FACTURATION_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."FACTURATION_COMMANDE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."FACTURATION_COMMANDE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21511 (class 0 OID 0)
-- Dependencies: 483
-- Name: FACTURATION_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."FACTURATION_COMMANDE_CLIENT_ID_seq" OWNED BY "Default"."FACTURATION_COMMANDE_CLIENT"."ID";


--
-- TOC entry 484 (class 1259 OID 36390925)
-- Name: FACTURE_FOURNISSEUR; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."FACTURE_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NUMERO" character varying(45) DEFAULT ''::character varying NOT NULL,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "DATE" date,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_AVOIR_FOURNISSEUR" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "T_HT" bigint DEFAULT 0,
    "T_TVA" bigint DEFAULT 0,
    "T_TTC" bigint DEFAULT 0,
    "T_SERVICE" bigint DEFAULT 0,
    "T_DEVISE" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "TAUX_APPLIQUE" numeric(12,6) DEFAULT 1,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "PORT_HT" bigint DEFAULT 0 NOT NULL,
    "REMISE_HT" bigint DEFAULT 0 NOT NULL,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "NET_A_PAYER" bigint DEFAULT 0 NOT NULL,
    "AVOIR_TTC" bigint DEFAULT 0 NOT NULL
);


ALTER TABLE "Default"."FACTURE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 485 (class 1259 OID 36390955)
-- Name: FACTURE_FOURNISSEUR_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."FACTURE_FOURNISSEUR_ELEMENT" (
    "ID" integer NOT NULL,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_TTC" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PA_TTC" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 0 NOT NULL,
    "PA_DEVISE_T" numeric(16,6) DEFAULT 0 NOT NULL,
    "PA_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE" integer DEFAULT 1 NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1 NOT NULL,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "POIDS" real DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "CODE" character varying(45) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DATE" date,
    "ID_STYLE" integer DEFAULT 1,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ID_FACTURE_FOURNISSEUR" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 5,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_CODE_FOURNISSEUR" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_DEMANDE_ACHAT_ELEMENT" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "Default"."FACTURE_FOURNISSEUR_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 486 (class 1259 OID 36391006)
-- Name: FACTURE_FOURNISSEUR_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."FACTURE_FOURNISSEUR_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."FACTURE_FOURNISSEUR_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21512 (class 0 OID 0)
-- Dependencies: 486
-- Name: FACTURE_FOURNISSEUR_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."FACTURE_FOURNISSEUR_ELEMENT_ID_seq" OWNED BY "Default"."FACTURE_FOURNISSEUR_ELEMENT"."ID";


--
-- TOC entry 487 (class 1259 OID 36391008)
-- Name: FACTURE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."FACTURE_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."FACTURE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21513 (class 0 OID 0)
-- Dependencies: 487
-- Name: FACTURE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."FACTURE_FOURNISSEUR_ID_seq" OWNED BY "Default"."FACTURE_FOURNISSEUR"."ID";


--
-- TOC entry 488 (class 1259 OID 36391010)
-- Name: FAMILLE_ARTICLE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."FAMILLE_ARTICLE" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_FAMILLE_ARTICLE_PERE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1
);


ALTER TABLE "Default"."FAMILLE_ARTICLE" OWNER TO openconcerto;

--
-- TOC entry 489 (class 1259 OID 36391021)
-- Name: FAMILLE_ARTICLE_FOURNISSEUR; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."FAMILLE_ARTICLE_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ID_FAMILLE_ARTICLE_FOURNISSEUR_PERE" integer,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."FAMILLE_ARTICLE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 490 (class 1259 OID 36391031)
-- Name: FAMILLE_ARTICLE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."FAMILLE_ARTICLE_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."FAMILLE_ARTICLE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21514 (class 0 OID 0)
-- Dependencies: 490
-- Name: FAMILLE_ARTICLE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."FAMILLE_ARTICLE_FOURNISSEUR_ID_seq" OWNED BY "Default"."FAMILLE_ARTICLE_FOURNISSEUR"."ID";


--
-- TOC entry 491 (class 1259 OID 36391033)
-- Name: FAMILLE_ARTICLE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."FAMILLE_ARTICLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."FAMILLE_ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21515 (class 0 OID 0)
-- Dependencies: 491
-- Name: FAMILLE_ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."FAMILLE_ARTICLE_ID_seq" OWNED BY "Default"."FAMILLE_ARTICLE"."ID";


--
-- TOC entry 492 (class 1259 OID 36391035)
-- Name: FICHE_PAYE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."FICHE_PAYE" (
    "ID" integer NOT NULL,
    "ANNEE" integer DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_SALARIE" integer DEFAULT 1,
    "ID_PROFIL_PAYE" integer DEFAULT 1,
    "SAL_BRUT" numeric(16,2) DEFAULT 0,
    "COT_PAT" numeric(16,2) DEFAULT 0,
    "COT_SAL" numeric(16,2) DEFAULT 0,
    "NET_IMP" numeric(16,2) DEFAULT 0,
    "NET_A_PAYER" numeric(16,2) DEFAULT 0,
    "ACOMPTE" numeric(16,2) DEFAULT 0,
    "ID_MOIS" integer DEFAULT 1,
    "VALIDE" boolean DEFAULT false,
    "CSG" numeric(16,2) DEFAULT 0,
    "DU" date,
    "AU" date,
    "CONGES_ACQUIS" real DEFAULT 0,
    "ID_CUMULS_PAYE" integer DEFAULT 1,
    "ID_CUMULS_CONGES" integer DEFAULT 1,
    "ID_VARIABLE_SALARIE" integer DEFAULT 1,
    "ID_REGLEMENT_PAYE" integer DEFAULT 1,
    "NATURE_EMPLOI" character varying(150) DEFAULT ''::character varying,
    "ID_IDCC" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_INFOS_SALARIE_PAYE" integer DEFAULT 1,
    "SAL_BASE_BRUT" numeric(16,2) DEFAULT 0 NOT NULL,
    "TAXE_CM_SAL" numeric(16,2) DEFAULT 0 NOT NULL,
    "TAXE_CM_PAT" numeric(16,2) DEFAULT 0 NOT NULL,
    "SAL_BRUT_COTISABLE" numeric(16,2) DEFAULT 0 NOT NULL,
    "SAL_BRUT_TAXABLE" numeric(16,2) DEFAULT 0 NOT NULL,
    "ALLEGEMENT_COTISATION" numeric(16,2) DEFAULT 0 NOT NULL,
    "CICE" numeric(16,2) DEFAULT 0 NOT NULL,
    "AVANTAGE_NATURE" numeric(16,2) DEFAULT 0 NOT NULL,
    "HEURE_TRAV" numeric(16,2) DEFAULT 0 NOT NULL,
    "DETAILS_CONGES" character varying(512) DEFAULT ''::character varying NOT NULL,
    "REDUCTION_GVT" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_PAS" integer DEFAULT 1,
    "TOTAL_PAS" numeric(16,2) DEFAULT 0 NOT NULL,
    "NET_AVANT_PAS" numeric(16,2) DEFAULT 0 NOT NULL
);


ALTER TABLE "Default"."FICHE_PAYE" OWNER TO openconcerto;

--
-- TOC entry 493 (class 1259 OID 36391073)
-- Name: FICHE_PAYE_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."FICHE_PAYE_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_FICHE_PAYE" integer DEFAULT 1,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "IDSOURCE" integer DEFAULT 1,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "NB_BASE" numeric(16,6) DEFAULT 0,
    "TAUX_SAL" numeric(16,6) DEFAULT 0,
    "TAUX_PAT" numeric(16,6) DEFAULT 0,
    "MONTANT_SAL_AJ" numeric(16,2) DEFAULT 0,
    "MONTANT_PAT" numeric(16,2) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "POSITION" integer DEFAULT 0,
    "MONTANT_SAL_DED" numeric(16,2) DEFAULT 0,
    "VALIDE" boolean DEFAULT false,
    "IMPRESSION" boolean DEFAULT true,
    "IN_PERIODE" boolean DEFAULT true,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_STYLE" integer DEFAULT 1
);


ALTER TABLE "Default"."FICHE_PAYE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 494 (class 1259 OID 36391097)
-- Name: FICHE_PAYE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."FICHE_PAYE_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."FICHE_PAYE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21516 (class 0 OID 0)
-- Dependencies: 494
-- Name: FICHE_PAYE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."FICHE_PAYE_ELEMENT_ID_seq" OWNED BY "Default"."FICHE_PAYE_ELEMENT"."ID";


--
-- TOC entry 495 (class 1259 OID 36391099)
-- Name: FICHE_PAYE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."FICHE_PAYE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."FICHE_PAYE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21517 (class 0 OID 0)
-- Dependencies: 495
-- Name: FICHE_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."FICHE_PAYE_ID_seq" OWNED BY "Default"."FICHE_PAYE"."ID";


--
-- TOC entry 496 (class 1259 OID 36391101)
-- Name: FIN_CONTRAT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."FIN_CONTRAT" (
    "ID" integer NOT NULL,
    "ID_FICHE_PAYE" integer DEFAULT 1,
    "ID_MOTIF_FIN_CONTRAT" integer DEFAULT 1,
    "DATE_FIN" timestamp without time zone,
    "DATE_NOTIFICATION" timestamp without time zone,
    "DATE_SIGNATURE_CONVENTION" timestamp without time zone,
    "DATE_ENGAGEMENT_PROCEDURE" timestamp without time zone,
    "DERNIER_JOUR_TRAV_PAYE" timestamp without time zone,
    "TRANSACTION_EN_COURS" boolean DEFAULT false NOT NULL,
    "PORTABILITE_PREVOYANCE" boolean DEFAULT false NOT NULL,
    "NB_DIF_RESTANT" integer,
    "NB_MOIS_CSP" integer,
    "SALAIRE_NET_HORAIRE" numeric(16,8),
    "INDEMNITE_VERSE" numeric(16,8),
    "ID_TYPE_PREAVIS" integer DEFAULT 1,
    "DATE_DEBUT_PREAVIS" timestamp without time zone,
    "DATE_FIN_PREAVIS" timestamp without time zone,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."FIN_CONTRAT" OWNER TO openconcerto;

--
-- TOC entry 497 (class 1259 OID 36391115)
-- Name: FIN_CONTRAT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."FIN_CONTRAT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."FIN_CONTRAT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21518 (class 0 OID 0)
-- Dependencies: 497
-- Name: FIN_CONTRAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."FIN_CONTRAT_ID_seq" OWNED BY "Default"."FIN_CONTRAT"."ID";


--
-- TOC entry 498 (class 1259 OID 36391117)
-- Name: FOURNISSEUR; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."FOURNISSEUR" (
    "ID_FOURNISSEUR" integer NOT NULL,
    "TYPE" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(2048) DEFAULT ''::text,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_ADRESSE_E" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "UE" boolean DEFAULT false NOT NULL,
    "ID_COMPTE_PCE" integer DEFAULT 1 NOT NULL,
    "ID_MODE_REGLEMENT" integer DEFAULT 1 NOT NULL,
    "TEL" character varying(2048) DEFAULT ''::text,
    "FAX" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_LANGUE" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "RESPONSABLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_P" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ID_COMPTE_PCE_CHARGE" integer DEFAULT 1,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "NUMERO_TVA" character varying(128) DEFAULT ''::character varying NOT NULL,
    "SIRET" character varying(128) DEFAULT ''::character varying NOT NULL,
    "IBAN" character varying(128) DEFAULT ''::character varying NOT NULL,
    "BIC" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_CATEGORIE_COMPTABLE" integer DEFAULT 1
);


ALTER TABLE "Default"."FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 499 (class 1259 OID 36391146)
-- Name: FOURNISSEUR_ID_FOURNISSEUR_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."FOURNISSEUR_ID_FOURNISSEUR_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."FOURNISSEUR_ID_FOURNISSEUR_seq" OWNER TO openconcerto;

--
-- TOC entry 21519 (class 0 OID 0)
-- Dependencies: 499
-- Name: FOURNISSEUR_ID_FOURNISSEUR_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."FOURNISSEUR_ID_FOURNISSEUR_seq" OWNED BY "Default"."FOURNISSEUR"."ID_FOURNISSEUR";


--
-- TOC entry 1336 (class 1259 OID 36417168)
-- Name: FRAIS_DOCUMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."FRAIS_DOCUMENT" (
    "ID" integer NOT NULL,
    "CODE" character varying(48) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MONTANT_HT" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "MONTANT_TTC" bigint DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."FRAIS_DOCUMENT" OWNER TO openconcerto;

--
-- TOC entry 1335 (class 1259 OID 36417166)
-- Name: FRAIS_DOCUMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."FRAIS_DOCUMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."FRAIS_DOCUMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21520 (class 0 OID 0)
-- Dependencies: 1335
-- Name: FRAIS_DOCUMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."FRAIS_DOCUMENT_ID_seq" OWNED BY "Default"."FRAIS_DOCUMENT"."ID";


--
-- TOC entry 500 (class 1259 OID 36391148)
-- Name: FWK_MODULE_DEP; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."FWK_MODULE_DEP" (
    "ID_MODULE" integer NOT NULL,
    "ID_MODULE_NEEDED" integer NOT NULL
);


ALTER TABLE "Default"."FWK_MODULE_DEP" OWNER TO openconcerto;

--
-- TOC entry 501 (class 1259 OID 36391151)
-- Name: FWK_MODULE_METADATA; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."FWK_MODULE_METADATA" (
    "ID" integer NOT NULL,
    "MODULE_NAME" character varying(128) DEFAULT ''::character varying NOT NULL,
    "TABLE" character varying(128),
    "FIELD" character varying(128),
    "KEY" boolean,
    "MODULE_VERSION" bigint NOT NULL
);


ALTER TABLE "Default"."FWK_MODULE_METADATA" OWNER TO openconcerto;

--
-- TOC entry 502 (class 1259 OID 36391155)
-- Name: FWK_MODULE_METADATA_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."FWK_MODULE_METADATA_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."FWK_MODULE_METADATA_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21521 (class 0 OID 0)
-- Dependencies: 502
-- Name: FWK_MODULE_METADATA_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."FWK_MODULE_METADATA_ID_seq" OWNED BY "Default"."FWK_MODULE_METADATA"."ID";


--
-- TOC entry 503 (class 1259 OID 36391157)
-- Name: FWK_SCHEMA_METADATA; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."FWK_SCHEMA_METADATA" (
    "NAME" character varying(100) DEFAULT ''::character varying NOT NULL,
    "VALUE" character varying(250) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Default"."FWK_SCHEMA_METADATA" OWNER TO openconcerto;

--
-- TOC entry 504 (class 1259 OID 36391162)
-- Name: FWK_UNDEFINED_IDS; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."FWK_UNDEFINED_IDS" (
    "TABLENAME" character varying(250) DEFAULT ''::character varying NOT NULL,
    "UNDEFINED_ID" integer DEFAULT 0
);


ALTER TABLE "Default"."FWK_UNDEFINED_IDS" OWNER TO openconcerto;

--
-- TOC entry 505 (class 1259 OID 36391167)
-- Name: IDCC; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."IDCC" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."IDCC" OWNER TO openconcerto;

--
-- TOC entry 506 (class 1259 OID 36391178)
-- Name: IDCC_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."IDCC_ID_seq"
    START WITH 996
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."IDCC_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21522 (class 0 OID 0)
-- Dependencies: 506
-- Name: IDCC_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."IDCC_ID_seq" OWNED BY "Default"."IDCC"."ID";


--
-- TOC entry 507 (class 1259 OID 36391180)
-- Name: INFOS_SALARIE_PAYE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."INFOS_SALARIE_PAYE" (
    "ID" integer NOT NULL,
    "ID_IDCC" integer DEFAULT 1,
    "ID_CONTRAT_SALARIE" integer DEFAULT 1,
    "ID_CLASSEMENT_CONVENTIONNEL" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "DUREE_HEBDO" real DEFAULT 0,
    "DUREE_MOIS" real DEFAULT 0,
    "DATE_ARRIVE" date,
    "CONGES_PAYES" real DEFAULT 0,
    "TAUX_AT" real DEFAULT 0,
    "SALAIRE_MOIS" real DEFAULT 0,
    "DATE_SORTIE" date,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "CODE_AT" character varying(18) DEFAULT ''::character varying NOT NULL,
    "CODE_SECTION_AT" character varying(18) DEFAULT ''::character varying NOT NULL,
    "ID_COEFF_PRIME" integer DEFAULT 1,
    "ID_SALARIE" integer DEFAULT 1
);


ALTER TABLE "Default"."INFOS_SALARIE_PAYE" OWNER TO openconcerto;

--
-- TOC entry 508 (class 1259 OID 36391198)
-- Name: INFOS_SALARIE_PAYE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."INFOS_SALARIE_PAYE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."INFOS_SALARIE_PAYE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21523 (class 0 OID 0)
-- Dependencies: 508
-- Name: INFOS_SALARIE_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."INFOS_SALARIE_PAYE_ID_seq" OWNED BY "Default"."INFOS_SALARIE_PAYE"."ID";


--
-- TOC entry 509 (class 1259 OID 36391200)
-- Name: JOURNAL; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."JOURNAL" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "PAR_DEFAUT" boolean DEFAULT false,
    "TYPE_BANQUE" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."JOURNAL" OWNER TO openconcerto;

--
-- TOC entry 510 (class 1259 OID 36391211)
-- Name: JOURNAL_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."JOURNAL_ID_seq"
    START WITH 7
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."JOURNAL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21524 (class 0 OID 0)
-- Dependencies: 510
-- Name: JOURNAL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."JOURNAL_ID_seq" OWNED BY "Default"."JOURNAL"."ID";


--
-- TOC entry 511 (class 1259 OID 36391213)
-- Name: LANGUE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."LANGUE" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CHEMIN" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."LANGUE" OWNER TO openconcerto;

--
-- TOC entry 512 (class 1259 OID 36391224)
-- Name: LANGUE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."LANGUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."LANGUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21525 (class 0 OID 0)
-- Dependencies: 512
-- Name: LANGUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."LANGUE_ID_seq" OWNED BY "Default"."LANGUE"."ID";


--
-- TOC entry 513 (class 1259 OID 36391226)
-- Name: METRIQUE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."METRIQUE" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "UNITE" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."METRIQUE" OWNER TO openconcerto;

--
-- TOC entry 514 (class 1259 OID 36391234)
-- Name: METRIQUE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."METRIQUE_ID_seq"
    START WITH 4
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."METRIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21526 (class 0 OID 0)
-- Dependencies: 514
-- Name: METRIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."METRIQUE_ID_seq" OWNED BY "Default"."METRIQUE"."ID";


--
-- TOC entry 515 (class 1259 OID 36391236)
-- Name: MODELE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."MODELE" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TYPE_MODELE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."MODELE" OWNER TO openconcerto;

--
-- TOC entry 516 (class 1259 OID 36391243)
-- Name: MODELE_COURRIER_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."MODELE_COURRIER_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "CODE" character varying(10) DEFAULT ''::character varying,
    "LOCATION" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "CONTENU" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."MODELE_COURRIER_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 517 (class 1259 OID 36391257)
-- Name: MODELE_COURRIER_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."MODELE_COURRIER_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."MODELE_COURRIER_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21527 (class 0 OID 0)
-- Dependencies: 517
-- Name: MODELE_COURRIER_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."MODELE_COURRIER_CLIENT_ID_seq" OWNED BY "Default"."MODELE_COURRIER_CLIENT"."ID";


--
-- TOC entry 518 (class 1259 OID 36391259)
-- Name: MODELE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."MODELE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."MODELE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21528 (class 0 OID 0)
-- Dependencies: 518
-- Name: MODELE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."MODELE_ID_seq" OWNED BY "Default"."MODELE"."ID";


--
-- TOC entry 519 (class 1259 OID 36391261)
-- Name: MODE_REGLEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."MODE_REGLEMENT" (
    "ID_MODE_REGLEMENT" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(2048) DEFAULT ''::text,
    "AJOURS" integer DEFAULT 0,
    "LENJOUR" integer DEFAULT 0,
    "ID_TYPE_REGLEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "FIN_MOIS" boolean DEFAULT false,
    "COMPTANT" boolean DEFAULT false,
    "DATE_DEPOT" date,
    "DATE_FACTURE" boolean DEFAULT false,
    "DATE" date,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ETS" character varying(2048) DEFAULT ''::text,
    "DATE_VIREMENT" date,
    "ID_BANQUE" integer DEFAULT 1,
    "ID_SEPA_MANDATE" integer
);


ALTER TABLE "Default"."MODE_REGLEMENT" OWNER TO openconcerto;

--
-- TOC entry 520 (class 1259 OID 36391281)
-- Name: MODE_REGLEMENT_ID_MODE_REGLEMENT_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."MODE_REGLEMENT_ID_MODE_REGLEMENT_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."MODE_REGLEMENT_ID_MODE_REGLEMENT_seq" OWNER TO openconcerto;

--
-- TOC entry 21529 (class 0 OID 0)
-- Dependencies: 520
-- Name: MODE_REGLEMENT_ID_MODE_REGLEMENT_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."MODE_REGLEMENT_ID_MODE_REGLEMENT_seq" OWNED BY "Default"."MODE_REGLEMENT"."ID_MODE_REGLEMENT";


--
-- TOC entry 521 (class 1259 OID 36391283)
-- Name: MODE_REGLEMENT_PAYE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."MODE_REGLEMENT_PAYE" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "Default"."MODE_REGLEMENT_PAYE" OWNER TO openconcerto;

--
-- TOC entry 522 (class 1259 OID 36391287)
-- Name: MODE_REGLEMENT_PAYE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."MODE_REGLEMENT_PAYE_ID_seq"
    START WITH 4
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."MODE_REGLEMENT_PAYE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21530 (class 0 OID 0)
-- Dependencies: 522
-- Name: MODE_REGLEMENT_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."MODE_REGLEMENT_PAYE_ID_seq" OWNED BY "Default"."MODE_REGLEMENT_PAYE"."ID";


--
-- TOC entry 523 (class 1259 OID 36391289)
-- Name: MODE_VENTE_ARTICLE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."MODE_VENTE_ARTICLE" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0.00000000,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."MODE_VENTE_ARTICLE" OWNER TO openconcerto;

--
-- TOC entry 524 (class 1259 OID 36391307)
-- Name: MODE_VENTE_ARTICLE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."MODE_VENTE_ARTICLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."MODE_VENTE_ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21531 (class 0 OID 0)
-- Dependencies: 524
-- Name: MODE_VENTE_ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."MODE_VENTE_ARTICLE_ID_seq" OWNED BY "Default"."MODE_VENTE_ARTICLE"."ID";


--
-- TOC entry 525 (class 1259 OID 36391309)
-- Name: MOIS; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."MOIS" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."MOIS" OWNER TO openconcerto;

--
-- TOC entry 526 (class 1259 OID 36391316)
-- Name: MOIS_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."MOIS_ID_seq"
    START WITH 14
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."MOIS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21532 (class 0 OID 0)
-- Dependencies: 526
-- Name: MOIS_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."MOIS_ID_seq" OWNED BY "Default"."MOIS"."ID";


--
-- TOC entry 527 (class 1259 OID 36391318)
-- Name: MOUVEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."MOUVEMENT" (
    "ID" integer NOT NULL,
    "NUMERO" integer DEFAULT 0,
    "IDSOURCE" integer DEFAULT 1,
    "SOURCE" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_MOUVEMENT_PERE" integer DEFAULT 1,
    "ID_PIECE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL
);


ALTER TABLE "Default"."MOUVEMENT" OWNER TO openconcerto;

--
-- TOC entry 528 (class 1259 OID 36391333)
-- Name: MOUVEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."MOUVEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."MOUVEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21533 (class 0 OID 0)
-- Dependencies: 528
-- Name: MOUVEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."MOUVEMENT_ID_seq" OWNED BY "Default"."MOUVEMENT"."ID";


--
-- TOC entry 529 (class 1259 OID 36391335)
-- Name: MOUVEMENT_STOCK; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."MOUVEMENT_STOCK" (
    "ID" integer NOT NULL,
    "QTE" real DEFAULT 0,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "IDSOURCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NUMERO" character varying(150) DEFAULT ''::character varying,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "DATE" date,
    "ID_ARTICLE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "REEL" boolean DEFAULT true NOT NULL,
    "CLOTURE" boolean DEFAULT false NOT NULL,
    "OUVERTURE" boolean DEFAULT false NOT NULL,
    "ID_ETAT_STOCK" integer DEFAULT 1,
    "ID_STOCK" integer DEFAULT 1,
    "SOURCE_ELEMENTID" integer DEFAULT 1 NOT NULL
);


ALTER TABLE "Default"."MOUVEMENT_STOCK" OWNER TO openconcerto;

--
-- TOC entry 530 (class 1259 OID 36391348)
-- Name: MOUVEMENT_STOCK_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."MOUVEMENT_STOCK_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."MOUVEMENT_STOCK_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21534 (class 0 OID 0)
-- Dependencies: 530
-- Name: MOUVEMENT_STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."MOUVEMENT_STOCK_ID_seq" OWNED BY "Default"."MOUVEMENT_STOCK"."ID";


--
-- TOC entry 531 (class 1259 OID 36391350)
-- Name: NATURE_COMPTE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."NATURE_COMPTE" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."NATURE_COMPTE" OWNER TO openconcerto;

--
-- TOC entry 532 (class 1259 OID 36391360)
-- Name: NATURE_COMPTE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."NATURE_COMPTE_ID_seq"
    START WITH 13
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."NATURE_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21535 (class 0 OID 0)
-- Dependencies: 532
-- Name: NATURE_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."NATURE_COMPTE_ID_seq" OWNED BY "Default"."NATURE_COMPTE"."ID";


--
-- TOC entry 533 (class 1259 OID 36391362)
-- Name: NUMEROTATION_AUTO; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."NUMEROTATION_AUTO" (
    "ID" integer NOT NULL,
    "DEVIS_FORMAT" character varying(45) DEFAULT ''::character varying,
    "DEVIS_START" integer DEFAULT 1,
    "BON_L_FORMAT" character varying(45) DEFAULT ''::character varying,
    "BON_L_START" integer DEFAULT 1,
    "FACT_FORMAT" character varying(45) DEFAULT ''::character varying,
    "FACT_START" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "SALARIE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "SALARIE_START" integer DEFAULT 1,
    "PROPOSITION_FORMAT" character varying(45) DEFAULT ''::character varying,
    "PROPOSITION_START" integer DEFAULT 0,
    "RELANCE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "RELANCE_START" integer DEFAULT 0,
    "COMMANDE_CLIENT_START" integer DEFAULT 0,
    "COMMANDE_CLIENT_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COMMANDE_START" integer DEFAULT 0,
    "COMMANDE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "BON_R_FORMAT" character varying(45) DEFAULT ''::character varying,
    "BON_R_START" integer DEFAULT 0,
    "AFFAIRE_START" integer DEFAULT 0,
    "AFFAIRE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "AVOIR_START" integer DEFAULT 0,
    "AVOIR_FORMAT" character varying(45) DEFAULT ''::character varying,
    "CODE_LETTRAGE" character varying(128) DEFAULT 'AAA'::character varying,
    "COURRIER_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COURRIER_START" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "AVOIR_F_START" integer DEFAULT 0,
    "AVOIR_F_FORMAT" character varying(48) DEFAULT ''::character varying NOT NULL,
    "CLIENT_START" integer DEFAULT 0,
    "CLIENT_FORMAT" character varying(48) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT 'Standard'::character varying,
    "DMD_PRIX_FORMAT" character varying(128) DEFAULT ''::character varying NOT NULL,
    "DMD_PRIX_START" integer DEFAULT 1 NOT NULL
);


ALTER TABLE "Default"."NUMEROTATION_AUTO" OWNER TO openconcerto;

--
-- TOC entry 534 (class 1259 OID 36391403)
-- Name: NUMEROTATION_AUTO_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."NUMEROTATION_AUTO_ID_seq"
    START WITH 3
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."NUMEROTATION_AUTO_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21536 (class 0 OID 0)
-- Dependencies: 534
-- Name: NUMEROTATION_AUTO_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."NUMEROTATION_AUTO_ID_seq" OWNED BY "Default"."NUMEROTATION_AUTO"."ID";


--
-- TOC entry 535 (class 1259 OID 36391405)
-- Name: OBJECTIF_COMMERCIAL; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."OBJECTIF_COMMERCIAL" (
    "ID" integer NOT NULL,
    "MOIS" character varying(32) DEFAULT ''::character varying NOT NULL,
    "ANNEE" integer,
    "MARGE_HT" bigint DEFAULT 0,
    "POURCENT_MARGE" numeric(16,8),
    "CHIFFRE_AFFAIRE" bigint DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."OBJECTIF_COMMERCIAL" OWNER TO openconcerto;

--
-- TOC entry 536 (class 1259 OID 36391414)
-- Name: OBJECTIF_COMMERCIAL_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."OBJECTIF_COMMERCIAL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."OBJECTIF_COMMERCIAL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21537 (class 0 OID 0)
-- Dependencies: 536
-- Name: OBJECTIF_COMMERCIAL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."OBJECTIF_COMMERCIAL_ID_seq" OWNED BY "Default"."OBJECTIF_COMMERCIAL"."ID";


--
-- TOC entry 1338 (class 1259 OID 36417353)
-- Name: PAS; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."PAS" (
    "ID" integer NOT NULL,
    "ID_TYPE_TAUX_PAS" integer DEFAULT 1,
    "CODE_PAS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TAUX_PAS" numeric(16,2) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."PAS" OWNER TO openconcerto;

--
-- TOC entry 1337 (class 1259 OID 36417351)
-- Name: PAS_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."PAS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."PAS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21538 (class 0 OID 0)
-- Dependencies: 1337
-- Name: PAS_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."PAS_ID_seq" OWNED BY "Default"."PAS"."ID";


--
-- TOC entry 537 (class 1259 OID 36391416)
-- Name: PAYS; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."PAYS" (
    "ID" integer NOT NULL,
    "CODE" character varying(15) DEFAULT ''::character varying,
    "NOM" character varying(50) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_TARIF" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1
);


ALTER TABLE "Default"."PAYS" OWNER TO openconcerto;

--
-- TOC entry 538 (class 1259 OID 36391426)
-- Name: PAYS_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."PAYS_ID_seq"
    START WITH 194
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."PAYS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21539 (class 0 OID 0)
-- Dependencies: 538
-- Name: PAYS_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."PAYS_ID_seq" OWNED BY "Default"."PAYS"."ID";


--
-- TOC entry 539 (class 1259 OID 36391428)
-- Name: PIECE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."PIECE" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."PIECE" OWNER TO openconcerto;

--
-- TOC entry 540 (class 1259 OID 36391438)
-- Name: PIECE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."PIECE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."PIECE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21540 (class 0 OID 0)
-- Dependencies: 540
-- Name: PIECE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."PIECE_ID_seq" OWNED BY "Default"."PIECE"."ID";


--
-- TOC entry 541 (class 1259 OID 36391440)
-- Name: POSTE_ANALYTIQUE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."POSTE_ANALYTIQUE" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_AXE_ANALYTIQUE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "DEFAULT" boolean DEFAULT false NOT NULL,
    "OBSOLETE" boolean DEFAULT false NOT NULL
);


ALTER TABLE "Default"."POSTE_ANALYTIQUE" OWNER TO openconcerto;

--
-- TOC entry 542 (class 1259 OID 36391452)
-- Name: POSTE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."POSTE_ANALYTIQUE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."POSTE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21541 (class 0 OID 0)
-- Dependencies: 542
-- Name: POSTE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."POSTE_ANALYTIQUE_ID_seq" OWNED BY "Default"."POSTE_ANALYTIQUE"."ID";


--
-- TOC entry 543 (class 1259 OID 36391454)
-- Name: PREFERENCES; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."PREFERENCES" (
    "NAME" character varying(2048) NOT NULL,
    "VALUE" character varying(2048),
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."PREFERENCES" OWNER TO openconcerto;

--
-- TOC entry 544 (class 1259 OID 36391464)
-- Name: PREFERENCES_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."PREFERENCES_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."PREFERENCES_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21542 (class 0 OID 0)
-- Dependencies: 544
-- Name: PREFERENCES_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."PREFERENCES_ID_seq" OWNED BY "Default"."PREFERENCES"."ID";


--
-- TOC entry 545 (class 1259 OID 36391466)
-- Name: PREFS_COMPTE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."PREFS_COMPTE" (
    "ID" integer NOT NULL,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_TVA_ACHAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_FOURNISSEUR" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE_PRODUIT" integer DEFAULT 1,
    "ID_COMPTE_PCE_TVA_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_CLIENT" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE_SERVICE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACOMPTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACOMPTE_REGL" integer DEFAULT 1,
    "ID_COMPTE_PCE_PAYE" integer DEFAULT 1,
    "ID_COMPTE_PCE_TVA_INTRA" integer DEFAULT 1 NOT NULL,
    "ID_COMPTE_PCE_TVA_IMMO" integer DEFAULT 1,
    "ID_COMPTE_PCE_BILAN_O" integer DEFAULT 1,
    "ID_COMPTE_PCE_RESULTAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_BILAN_F" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT_INTRA" integer DEFAULT 1,
    "ID_JOURNAL_FACTOR" integer DEFAULT 1,
    "ID_COMPTE_PCE_FACTOR" integer DEFAULT 1,
    "ID_COMPTE_PCE_RESULTAT_PERTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_PORT_SOUMIS" integer DEFAULT 1,
    "ID_COMPTE_PCE_PORT_NON_SOUMIS" integer DEFAULT 1,
    "ID_COMPTE_PCE_AVANCE_CLIENT" integer DEFAULT 1,
    "ID_COMPTE_PCE_VALEUR_ENCAISSEMENT" integer DEFAULT 1,
    "ID_JOURNAL_AN" integer DEFAULT 1,
    "CREATE_NUL_SOLDE_ECR" boolean DEFAULT true NOT NULL,
    "AUTO_LETTRAGE" boolean DEFAULT false NOT NULL
);


ALTER TABLE "Default"."PREFS_COMPTE" OWNER TO openconcerto;

--
-- TOC entry 546 (class 1259 OID 36391495)
-- Name: PREFS_COMPTE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."PREFS_COMPTE_ID_seq"
    START WITH 3
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."PREFS_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21543 (class 0 OID 0)
-- Dependencies: 546
-- Name: PREFS_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."PREFS_COMPTE_ID_seq" OWNED BY "Default"."PREFS_COMPTE"."ID";


--
-- TOC entry 547 (class 1259 OID 36391497)
-- Name: REFERENCE_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."REFERENCE_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."REFERENCE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 548 (class 1259 OID 36391508)
-- Name: REFERENCE_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."REFERENCE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."REFERENCE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21544 (class 0 OID 0)
-- Dependencies: 548
-- Name: REFERENCE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."REFERENCE_CLIENT_ID_seq" OWNED BY "Default"."REFERENCE_CLIENT"."ID";


--
-- TOC entry 549 (class 1259 OID 36391510)
-- Name: REGIME_BASE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."REGIME_BASE" (
    "ID" integer NOT NULL,
    "ID_CODE_REGIME_BASE" integer DEFAULT 1,
    "ID_CODE_REGIME_MALADIE" integer DEFAULT 1,
    "ID_CODE_REGIME_AT" integer DEFAULT 1,
    "ID_CODE_REGIME_VIEL_P" integer DEFAULT 1,
    "ID_CODE_REGIME_VIEL_S" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."REGIME_BASE" OWNER TO openconcerto;

--
-- TOC entry 550 (class 1259 OID 36391523)
-- Name: REGIME_BASE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."REGIME_BASE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."REGIME_BASE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21545 (class 0 OID 0)
-- Dependencies: 550
-- Name: REGIME_BASE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."REGIME_BASE_ID_seq" OWNED BY "Default"."REGIME_BASE"."ID";


--
-- TOC entry 551 (class 1259 OID 36391525)
-- Name: REGLEMENT_PAYE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."REGLEMENT_PAYE" (
    "ID" integer NOT NULL,
    "NOM_BANQUE" character varying(45) DEFAULT ''::character varying,
    "RIB" character varying(45) DEFAULT ''::character varying,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "LE" integer DEFAULT 1,
    "ID_MODE_REGLEMENT_PAYE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."REGLEMENT_PAYE" OWNER TO openconcerto;

--
-- TOC entry 552 (class 1259 OID 36391536)
-- Name: REGLEMENT_PAYE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."REGLEMENT_PAYE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."REGLEMENT_PAYE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21546 (class 0 OID 0)
-- Dependencies: 552
-- Name: REGLEMENT_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."REGLEMENT_PAYE_ID_seq" OWNED BY "Default"."REGLEMENT_PAYE"."ID";


--
-- TOC entry 553 (class 1259 OID 36391538)
-- Name: REGLER_MONTANT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."REGLER_MONTANT" (
    "ID" integer NOT NULL,
    "DATE" date,
    "MONTANT" bigint DEFAULT 0,
    "ID_ECHEANCE_FOURNISSEUR" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "Default"."REGLER_MONTANT" OWNER TO openconcerto;

--
-- TOC entry 554 (class 1259 OID 36391547)
-- Name: REGLER_MONTANT_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."REGLER_MONTANT_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_ECHEANCE_FOURNISSEUR" integer DEFAULT 1,
    "ID_REGLER_MONTANT" integer DEFAULT 1,
    "ID_MOUVEMENT_ECHEANCE" integer DEFAULT 1,
    "DATE" date,
    "MONTANT_REGLE" bigint DEFAULT 0,
    "MONTANT_A_REGLER" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."REGLER_MONTANT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 555 (class 1259 OID 36391557)
-- Name: REGLER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."REGLER_MONTANT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."REGLER_MONTANT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21547 (class 0 OID 0)
-- Dependencies: 555
-- Name: REGLER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."REGLER_MONTANT_ELEMENT_ID_seq" OWNED BY "Default"."REGLER_MONTANT_ELEMENT"."ID";


--
-- TOC entry 556 (class 1259 OID 36391559)
-- Name: REGLER_MONTANT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."REGLER_MONTANT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."REGLER_MONTANT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21548 (class 0 OID 0)
-- Dependencies: 556
-- Name: REGLER_MONTANT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."REGLER_MONTANT_ID_seq" OWNED BY "Default"."REGLER_MONTANT"."ID";


--
-- TOC entry 557 (class 1259 OID 36391561)
-- Name: RELANCE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."RELANCE" (
    "ID" integer NOT NULL,
    "DATE" date,
    "ID_TYPE_LETTRE_RELANCE" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_ECHEANCE_CLIENT" integer DEFAULT 1
);


ALTER TABLE "Default"."RELANCE" OWNER TO openconcerto;

--
-- TOC entry 558 (class 1259 OID 36391577)
-- Name: RELANCE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."RELANCE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."RELANCE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21549 (class 0 OID 0)
-- Dependencies: 558
-- Name: RELANCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."RELANCE_ID_seq" OWNED BY "Default"."RELANCE"."ID";


--
-- TOC entry 559 (class 1259 OID 36391579)
-- Name: REPARTITION_ANALYTIQUE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."REPARTITION_ANALYTIQUE" (
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."REPARTITION_ANALYTIQUE" OWNER TO openconcerto;

--
-- TOC entry 560 (class 1259 OID 36391589)
-- Name: REPARTITION_ANALYTIQUE_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."REPARTITION_ANALYTIQUE_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_REPARTITION_ANALYTIQUE" integer DEFAULT 1,
    "ID_POSTE_ANALYTIQUE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "TAUX" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."REPARTITION_ANALYTIQUE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 561 (class 1259 OID 36391598)
-- Name: REPARTITION_ANALYTIQUE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."REPARTITION_ANALYTIQUE_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."REPARTITION_ANALYTIQUE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21550 (class 0 OID 0)
-- Dependencies: 561
-- Name: REPARTITION_ANALYTIQUE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."REPARTITION_ANALYTIQUE_ELEMENT_ID_seq" OWNED BY "Default"."REPARTITION_ANALYTIQUE_ELEMENT"."ID";


--
-- TOC entry 562 (class 1259 OID 36391600)
-- Name: REPARTITION_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."REPARTITION_ANALYTIQUE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."REPARTITION_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21551 (class 0 OID 0)
-- Dependencies: 562
-- Name: REPARTITION_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."REPARTITION_ANALYTIQUE_ID_seq" OWNED BY "Default"."REPARTITION_ANALYTIQUE"."ID";


--
-- TOC entry 563 (class 1259 OID 36391602)
-- Name: REPRISE_TRAVAIL; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."REPRISE_TRAVAIL" (
    "ID" integer NOT NULL,
    "ID_SALARIE" integer DEFAULT 1,
    "DATE_DERNIER_JOUR_TRAV" timestamp without time zone,
    "DATE_FIN_PREV" timestamp without time zone,
    "SUBROGATION" boolean DEFAULT false NOT NULL,
    "DATE_DEBUT_SUBROGATION" timestamp without time zone,
    "DATE_FIN_SUBROGATION" timestamp without time zone,
    "ID_MOTIF_ARRET_TRAVAIL" integer DEFAULT 1,
    "ID_MOTIF_REPRISE_ARRET_TRAVAIL" integer DEFAULT 1,
    "DATE_REPRISE" timestamp without time zone,
    "DATE_ACCIDENT" timestamp without time zone,
    "DATE" timestamp without time zone,
    "COMMENTAIRES" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."REPRISE_TRAVAIL" OWNER TO openconcerto;

--
-- TOC entry 564 (class 1259 OID 36391615)
-- Name: REPRISE_TRAVAIL_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."REPRISE_TRAVAIL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."REPRISE_TRAVAIL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21552 (class 0 OID 0)
-- Dependencies: 564
-- Name: REPRISE_TRAVAIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."REPRISE_TRAVAIL_ID_seq" OWNED BY "Default"."REPRISE_TRAVAIL"."ID";


--
-- TOC entry 565 (class 1259 OID 36391617)
-- Name: SAISIE_ACHAT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."SAISIE_ACHAT" (
    "ID" integer NOT NULL,
    "DATE" date,
    "NOM" character varying(2048) DEFAULT ''::text,
    "MONTANT_TTC" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NUMERO_COMMANDE" character varying(2048) DEFAULT ''::text,
    "NUMERO_FACTURE" character varying(2048) DEFAULT ''::text,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "MONTANT_HT" bigint DEFAULT 0,
    "MONTANT_TVA" bigint DEFAULT 0,
    "IDSOURCE" integer DEFAULT 1,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "ID_COMPTE_PCE" integer DEFAULT 1 NOT NULL,
    "ID_AVOIR_FOURNISSEUR" integer DEFAULT 1,
    "IMMO" boolean DEFAULT false,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."SAISIE_ACHAT" OWNER TO openconcerto;

--
-- TOC entry 566 (class 1259 OID 36391640)
-- Name: SAISIE_ACHAT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."SAISIE_ACHAT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."SAISIE_ACHAT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21553 (class 0 OID 0)
-- Dependencies: 566
-- Name: SAISIE_ACHAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."SAISIE_ACHAT_ID_seq" OWNED BY "Default"."SAISIE_ACHAT"."ID";


--
-- TOC entry 567 (class 1259 OID 36391642)
-- Name: SAISIE_KM; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."SAISIE_KM" (
    "ID" integer NOT NULL,
    "DATE" date,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_JOURNAL" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."SAISIE_KM" OWNER TO openconcerto;

--
-- TOC entry 568 (class 1259 OID 36391652)
-- Name: SAISIE_KM_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."SAISIE_KM_ELEMENT" (
    "ID_SAISIE_KM" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "NUMERO" character varying(100) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "NOM_ECRITURE" character varying(2048) DEFAULT ''::text,
    "DEBIT" bigint DEFAULT 0,
    "CREDIT" bigint DEFAULT 0,
    "ID_ECRITURE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "NOM_PIECE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ANALYTIQUE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "JOUR" integer DEFAULT 1 NOT NULL
);


ALTER TABLE "Default"."SAISIE_KM_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 569 (class 1259 OID 36391671)
-- Name: SAISIE_KM_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."SAISIE_KM_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."SAISIE_KM_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21554 (class 0 OID 0)
-- Dependencies: 569
-- Name: SAISIE_KM_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."SAISIE_KM_ELEMENT_ID_seq" OWNED BY "Default"."SAISIE_KM_ELEMENT"."ID";


--
-- TOC entry 570 (class 1259 OID 36391673)
-- Name: SAISIE_KM_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."SAISIE_KM_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."SAISIE_KM_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21555 (class 0 OID 0)
-- Dependencies: 570
-- Name: SAISIE_KM_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."SAISIE_KM_ID_seq" OWNED BY "Default"."SAISIE_KM"."ID";


--
-- TOC entry 571 (class 1259 OID 36391675)
-- Name: SAISIE_VENTE_COMPTOIR; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."SAISIE_VENTE_COMPTOIR" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_ARTICLE" integer DEFAULT 1,
    "DATE" date,
    "ID_CLIENT" integer DEFAULT 0,
    "MONTANT_TTC" bigint DEFAULT 0,
    "MONTANT_SERVICE" bigint DEFAULT 0,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ECHEANCE" integer DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "MONTANT_HT" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_COMPTE_PCE_PRODUIT" integer DEFAULT 1,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1
);


ALTER TABLE "Default"."SAISIE_VENTE_COMPTOIR" OWNER TO openconcerto;

--
-- TOC entry 572 (class 1259 OID 36391697)
-- Name: SAISIE_VENTE_COMPTOIR_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."SAISIE_VENTE_COMPTOIR_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."SAISIE_VENTE_COMPTOIR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21556 (class 0 OID 0)
-- Dependencies: 572
-- Name: SAISIE_VENTE_COMPTOIR_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."SAISIE_VENTE_COMPTOIR_ID_seq" OWNED BY "Default"."SAISIE_VENTE_COMPTOIR"."ID";


--
-- TOC entry 573 (class 1259 OID 36391699)
-- Name: SAISIE_VENTE_FACTURE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."SAISIE_VENTE_FACTURE" (
    "ID_DEVIS" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "NOM" character varying(250) DEFAULT ''::character varying,
    "DATE" date,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "T_HT" bigint DEFAULT 0,
    "T_TVA" bigint DEFAULT 0,
    "T_TTC" bigint DEFAULT 0,
    "PORT_HT" bigint DEFAULT 0,
    "REMISE_HT" bigint DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "T_SERVICE" bigint DEFAULT 0,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "T_POIDS" real DEFAULT 0,
    "PREVISIONNELLE" boolean DEFAULT false NOT NULL,
    "COMPLEMENT" boolean DEFAULT false NOT NULL,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1,
    "DATE_ENVOI" timestamp without time zone,
    "DATE_REGLEMENT" timestamp without time zone,
    "ACOMPTE" boolean DEFAULT false,
    "POURCENT_ACOMPTE" real DEFAULT 0,
    "ENVOYE_EN_AFFACTURAGE" boolean DEFAULT false,
    "DATE_ENVOI_AFFACTURAGE" date,
    "AFFACTURAGE" boolean DEFAULT false,
    "ID_CONTACT" integer DEFAULT 1,
    "TYPE_INTERVENTION" character varying(2048) DEFAULT ''::text,
    "ID_REFERENCE_CLIENT" integer DEFAULT 1,
    "COMPTE_SERVICE_AUTO" boolean DEFAULT false,
    "T_AVOIR_TTC" bigint DEFAULT 0,
    "REF_CLIENT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "CREATION_DATE" timestamp without time zone,
    "T_HA" bigint DEFAULT 0,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE" integer DEFAULT 1,
    "ID_MOIS_CCIP" integer DEFAULT 1,
    "RETOUR_NATEXIS" boolean DEFAULT false,
    "CONTROLE_TECHNIQUE" boolean DEFAULT false,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "POURCENT_FACTURABLE" numeric(16,8),
    "MONTANT_FACTURABLE" numeric(16,8),
    "SOLDE" boolean DEFAULT false,
    "PARTIAL" boolean DEFAULT false,
    "ID_ADRESSE_LIVRAISON" integer DEFAULT 1,
    "POURCENT_REMISE" numeric(12,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_CLIENT_DEPARTEMENT" integer DEFAULT 1,
    "CREATE_VIRTUAL_STOCK" boolean DEFAULT true NOT NULL,
    "SOUMIS_TIMBRE_FISCAL" boolean DEFAULT false,
    "TAUX_TIMBRE_FISCAL" numeric(16,4) DEFAULT 1,
    "TOTAL_TIMBRE_FISCAL" bigint DEFAULT 0,
    "NET_A_PAYER" bigint DEFAULT 0,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "T_ACOMPTE" bigint DEFAULT 0 NOT NULL,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "ID_SDD_MESSAGE" integer,
    "SDD_EndToEndId" character varying(35) DEFAULT ''::character varying NOT NULL,
    "FRAIS_DOCUMENT_HT" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE_FRAIS_DOCUMENT" integer DEFAULT 1
);


ALTER TABLE "Default"."SAISIE_VENTE_FACTURE" OWNER TO openconcerto;

--
-- TOC entry 574 (class 1259 OID 36391759)
-- Name: SAISIE_VENTE_FACTURE_ELEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."SAISIE_VENTE_FACTURE_ELEMENT" (
    "LIVREE" boolean DEFAULT false,
    "QTE_LIVREE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_STYLE" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "QTE" integer DEFAULT 0,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "SERVICE" boolean DEFAULT false,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_POIDS" real DEFAULT 0,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1 NOT NULL,
    "CODE_MISSION" character varying(45) DEFAULT ''::character varying,
    "NOM_MISSION" character varying(256) DEFAULT ''::character varying,
    "ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "SOUS_ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "INDICE_0" bigint DEFAULT 0,
    "INDICE_N" bigint DEFAULT 0,
    "MONTANT_INITIAL" numeric(16,6) DEFAULT 0 NOT NULL,
    "REFERENTIEL_INSPECTION" character varying(2048) DEFAULT ''::text,
    "OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "INFOS_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "LOCAL_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "Q18" boolean DEFAULT false,
    "TARIF_Q18_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "MONTANT_REVISABLE" boolean DEFAULT false,
    "POURCENT_SERVICE" character varying(2048) DEFAULT ''::text,
    "DATE" date,
    "ID_CONTACT" integer DEFAULT 1,
    "DATE_FIN" timestamp without time zone,
    "POURCENT_CCIP" character varying(256) DEFAULT ''::character varying NOT NULL,
    "SITUATION_ADMIN" character varying(2048) DEFAULT ''::text,
    "ACOMPTE" boolean DEFAULT false,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "POURCENT_REMISE" numeric(12,8) DEFAULT 0,
    "POURCENT_ACOMPTE" numeric(6,2) DEFAULT 100 NOT NULL,
    "REPARTITION_POURCENT" numeric(6,2) DEFAULT 0 NOT NULL,
    "ID_TICKET_CAISSE" integer DEFAULT 1,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_T_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "T_POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "NB_COLIS" integer DEFAULT 0,
    "MONTANT_FACTURABLE" numeric(16,8),
    "POURCENT_FACTURABLE" numeric(16,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_COMMANDE_CLIENT_ELEMENT" integer DEFAULT 1,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "Default"."SAISIE_VENTE_FACTURE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 575 (class 1259 OID 36391842)
-- Name: SAISIE_VENTE_FACTURE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."SAISIE_VENTE_FACTURE_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."SAISIE_VENTE_FACTURE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21557 (class 0 OID 0)
-- Dependencies: 575
-- Name: SAISIE_VENTE_FACTURE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."SAISIE_VENTE_FACTURE_ELEMENT_ID_seq" OWNED BY "Default"."SAISIE_VENTE_FACTURE_ELEMENT"."ID";


--
-- TOC entry 576 (class 1259 OID 36391844)
-- Name: SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."SAISIE_VENTE_FACTURE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."SAISIE_VENTE_FACTURE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21558 (class 0 OID 0)
-- Dependencies: 576
-- Name: SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."SAISIE_VENTE_FACTURE_ID_seq" OWNED BY "Default"."SAISIE_VENTE_FACTURE"."ID";


--
-- TOC entry 577 (class 1259 OID 36391846)
-- Name: SALARIE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."SALARIE" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "PRENOM" character varying(45) DEFAULT ''::character varying,
    "NOM_JEUNE_FILLE" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_ETAT_CIVIL" integer DEFAULT 1,
    "ID_REGLEMENT_PAYE" integer DEFAULT 1,
    "ID_INFOS_SALARIE_PAYE" integer DEFAULT 1,
    "ID_FICHE_PAYE" integer DEFAULT 1,
    "ID_CUMULS_PAYE" integer DEFAULT 1,
    "DERNIER_MOIS" integer DEFAULT 0,
    "DERNIERE_ANNEE" integer DEFAULT 0,
    "ID_CUMULS_CONGES" integer DEFAULT 1,
    "ID_VARIABLE_SALARIE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "ID_PAS" integer DEFAULT 1
);


ALTER TABLE "Default"."SALARIE" OWNER TO openconcerto;

--
-- TOC entry 578 (class 1259 OID 36391865)
-- Name: SALARIE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."SALARIE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."SALARIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21559 (class 0 OID 0)
-- Dependencies: 578
-- Name: SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."SALARIE_ID_seq" OWNED BY "Default"."SALARIE"."ID";


--
-- TOC entry 579 (class 1259 OID 36391867)
-- Name: SEPA_DIRECT_DEBIT_MESSAGE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."SEPA_DIRECT_DEBIT_MESSAGE" (
    "ID" integer NOT NULL,
    "MessageIdentification" character varying(35) DEFAULT ''::character varying NOT NULL,
    "CreationDateTime" timestamp without time zone NOT NULL,
    "NumberOfTransactions" integer DEFAULT 0 NOT NULL,
    "ControlSum" numeric(16,6) DEFAULT 0 NOT NULL,
    "XML" text NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."SEPA_DIRECT_DEBIT_MESSAGE" OWNER TO openconcerto;

--
-- TOC entry 580 (class 1259 OID 36391877)
-- Name: SEPA_DIRECT_DEBIT_MESSAGE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."SEPA_DIRECT_DEBIT_MESSAGE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."SEPA_DIRECT_DEBIT_MESSAGE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21560 (class 0 OID 0)
-- Dependencies: 580
-- Name: SEPA_DIRECT_DEBIT_MESSAGE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."SEPA_DIRECT_DEBIT_MESSAGE_ID_seq" OWNED BY "Default"."SEPA_DIRECT_DEBIT_MESSAGE"."ID";


--
-- TOC entry 581 (class 1259 OID 36391879)
-- Name: SEPA_MANDATE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."SEPA_MANDATE" (
    "ID" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "MandateIdentification" character varying(35) DEFAULT ''::character varying NOT NULL,
    "DateOfSignature" date,
    "SequenceType" character varying(8) DEFAULT ''::character varying NOT NULL,
    "ACTIVE" boolean DEFAULT true NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "Default"."SEPA_MANDATE" OWNER TO openconcerto;

--
-- TOC entry 582 (class 1259 OID 36391887)
-- Name: SEPA_MANDATE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."SEPA_MANDATE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."SEPA_MANDATE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21561 (class 0 OID 0)
-- Dependencies: 582
-- Name: SEPA_MANDATE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."SEPA_MANDATE_ID_seq" OWNED BY "Default"."SEPA_MANDATE"."ID";


--
-- TOC entry 583 (class 1259 OID 36391889)
-- Name: SITUATION_FAMILIALE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."SITUATION_FAMILIALE" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."SITUATION_FAMILIALE" OWNER TO openconcerto;

--
-- TOC entry 584 (class 1259 OID 36391897)
-- Name: SITUATION_FAMILIALE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."SITUATION_FAMILIALE_ID_seq"
    START WITH 7
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."SITUATION_FAMILIALE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21562 (class 0 OID 0)
-- Dependencies: 584
-- Name: SITUATION_FAMILIALE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."SITUATION_FAMILIALE_ID_seq" OWNED BY "Default"."SITUATION_FAMILIALE"."ID";


--
-- TOC entry 585 (class 1259 OID 36391899)
-- Name: STOCK; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."STOCK" (
    "ID" integer NOT NULL,
    "QTE_REEL" real DEFAULT 0,
    "QTE_TH" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "QTE_RECEPT_ATTENTE" real DEFAULT 0,
    "QTE_LIV_ATTENTE" real DEFAULT 0,
    "ID_DEPOT_STOCK" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "QTE_MIN" real DEFAULT 0
);


ALTER TABLE "Default"."STOCK" OWNER TO openconcerto;

--
-- TOC entry 586 (class 1259 OID 36391909)
-- Name: STOCK_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."STOCK_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."STOCK_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21563 (class 0 OID 0)
-- Dependencies: 586
-- Name: STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."STOCK_ID_seq" OWNED BY "Default"."STOCK"."ID";


--
-- TOC entry 587 (class 1259 OID 36391911)
-- Name: STYLE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."STYLE" (
    "ID_STYLE" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "Default"."STYLE" OWNER TO openconcerto;

--
-- TOC entry 588 (class 1259 OID 36391920)
-- Name: STYLE_ID_STYLE_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."STYLE_ID_STYLE_seq"
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."STYLE_ID_STYLE_seq" OWNER TO openconcerto;

--
-- TOC entry 21564 (class 0 OID 0)
-- Dependencies: 588
-- Name: STYLE_ID_STYLE_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."STYLE_ID_STYLE_seq" OWNED BY "Default"."STYLE"."ID_STYLE";


--
-- TOC entry 589 (class 1259 OID 36391922)
-- Name: TARIF; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."TARIF" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."TARIF" OWNER TO openconcerto;

--
-- TOC entry 590 (class 1259 OID 36391930)
-- Name: TARIF_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."TARIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."TARIF_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21565 (class 0 OID 0)
-- Dependencies: 590
-- Name: TARIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."TARIF_ID_seq" OWNED BY "Default"."TARIF"."ID";


--
-- TOC entry 591 (class 1259 OID 36391932)
-- Name: TARIF_QUANTITE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."TARIF_QUANTITE" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "QUANTITE" numeric(16,3) DEFAULT 1 NOT NULL,
    "POURCENT_REMISE" numeric(16,3),
    "PRIX_METRIQUE_VT_1" numeric(16,6),
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."TARIF_QUANTITE" OWNER TO openconcerto;

--
-- TOC entry 592 (class 1259 OID 36391939)
-- Name: TARIF_QUANTITE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."TARIF_QUANTITE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."TARIF_QUANTITE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21566 (class 0 OID 0)
-- Dependencies: 592
-- Name: TARIF_QUANTITE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."TARIF_QUANTITE_ID_seq" OWNED BY "Default"."TARIF_QUANTITE"."ID";


--
-- TOC entry 593 (class 1259 OID 36391941)
-- Name: TAXE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."TAXE" (
    "ID_TAXE" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "TAUX" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "CODE" character varying(2048) DEFAULT ''::text,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_COMPTE_PCE_DED" integer DEFAULT 1,
    "ID_COMPTE_PCE_COLLECTE" integer DEFAULT 1,
    "DEFAULT" boolean DEFAULT false,
    "ID_COMPTE_PCE_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE_SERVICE" integer DEFAULT 1,
    "ID_COMPTE_PCE_COLLECTE_INTRA" integer DEFAULT 1,
    "ID_COMPTE_PCE_DED_INTRA" integer DEFAULT 1
);


ALTER TABLE "Default"."TAXE" OWNER TO openconcerto;

--
-- TOC entry 594 (class 1259 OID 36391961)
-- Name: TAXE_COMPLEMENTAIRE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."TAXE_COMPLEMENTAIRE" (
    "ID" integer NOT NULL,
    "ID_COMPTE_PCE_PRODUITS" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "POURCENT" numeric(16,6) DEFAULT 0 NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."TAXE_COMPLEMENTAIRE" OWNER TO openconcerto;

--
-- TOC entry 595 (class 1259 OID 36391971)
-- Name: TAXE_COMPLEMENTAIRE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."TAXE_COMPLEMENTAIRE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."TAXE_COMPLEMENTAIRE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21567 (class 0 OID 0)
-- Dependencies: 595
-- Name: TAXE_COMPLEMENTAIRE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."TAXE_COMPLEMENTAIRE_ID_seq" OWNED BY "Default"."TAXE_COMPLEMENTAIRE"."ID";


--
-- TOC entry 596 (class 1259 OID 36391973)
-- Name: TAXE_ID_TAXE_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."TAXE_ID_TAXE_seq"
    START WITH 6
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."TAXE_ID_TAXE_seq" OWNER TO openconcerto;

--
-- TOC entry 21568 (class 0 OID 0)
-- Dependencies: 596
-- Name: TAXE_ID_TAXE_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."TAXE_ID_TAXE_seq" OWNED BY "Default"."TAXE"."ID_TAXE";


--
-- TOC entry 597 (class 1259 OID 36391975)
-- Name: TICKET_CAISSE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."TICKET_CAISSE" (
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "DATE" timestamp without time zone,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "TOTAL_TTC" bigint DEFAULT 0,
    "TOTAL_TVA" bigint DEFAULT 0,
    "TOTAL_HT" bigint DEFAULT 0,
    "ID_CAISSE" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "FILE_HASH" character varying(128) DEFAULT NULL::character varying,
    "FILE_HASH_PREVIOUS" character varying(128) DEFAULT NULL::character varying
);


ALTER TABLE "Default"."TICKET_CAISSE" OWNER TO openconcerto;

--
-- TOC entry 598 (class 1259 OID 36391994)
-- Name: TICKET_CAISSE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."TICKET_CAISSE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."TICKET_CAISSE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21569 (class 0 OID 0)
-- Dependencies: 598
-- Name: TICKET_CAISSE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."TICKET_CAISSE_ID_seq" OWNED BY "Default"."TICKET_CAISSE"."ID";


--
-- TOC entry 599 (class 1259 OID 36391996)
-- Name: TITRE_PERSONNEL; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."TITRE_PERSONNEL" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "SEXE_M" boolean DEFAULT true,
    "CODE" character varying(8) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."TITRE_PERSONNEL" OWNER TO openconcerto;

--
-- TOC entry 600 (class 1259 OID 36392005)
-- Name: TITRE_PERSONNEL_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."TITRE_PERSONNEL_ID_seq"
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."TITRE_PERSONNEL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21570 (class 0 OID 0)
-- Dependencies: 600
-- Name: TITRE_PERSONNEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."TITRE_PERSONNEL_ID_seq" OWNED BY "Default"."TITRE_PERSONNEL"."ID";


--
-- TOC entry 601 (class 1259 OID 36392007)
-- Name: TR_BON_DE_LIVRAISON; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."TR_BON_DE_LIVRAISON" (
    "ID" integer NOT NULL,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1
);


ALTER TABLE "Default"."TR_BON_DE_LIVRAISON" OWNER TO openconcerto;

--
-- TOC entry 602 (class 1259 OID 36392014)
-- Name: TR_BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."TR_BON_DE_LIVRAISON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."TR_BON_DE_LIVRAISON_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21571 (class 0 OID 0)
-- Dependencies: 602
-- Name: TR_BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."TR_BON_DE_LIVRAISON_ID_seq" OWNED BY "Default"."TR_BON_DE_LIVRAISON"."ID";


--
-- TOC entry 603 (class 1259 OID 36392016)
-- Name: TR_BON_RECEPTION; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."TR_BON_RECEPTION" (
    "ID" integer NOT NULL,
    "ID_BON_RECEPTION" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_SAISIE_ACHAT" integer DEFAULT 1,
    "ID_FACTURE_FOURNISSEUR" integer DEFAULT 1
);


ALTER TABLE "Default"."TR_BON_RECEPTION" OWNER TO openconcerto;

--
-- TOC entry 604 (class 1259 OID 36392024)
-- Name: TR_BON_RECEPTION_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."TR_BON_RECEPTION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."TR_BON_RECEPTION_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21572 (class 0 OID 0)
-- Dependencies: 604
-- Name: TR_BON_RECEPTION_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."TR_BON_RECEPTION_ID_seq" OWNED BY "Default"."TR_BON_RECEPTION"."ID";


--
-- TOC entry 605 (class 1259 OID 36392026)
-- Name: TR_COMMANDE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."TR_COMMANDE" (
    "ID" integer NOT NULL,
    "ID_COMMANDE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_SAISIE_ACHAT" integer DEFAULT 1,
    "ID_BON_RECEPTION" integer DEFAULT 1
);


ALTER TABLE "Default"."TR_COMMANDE" OWNER TO openconcerto;

--
-- TOC entry 606 (class 1259 OID 36392034)
-- Name: TR_COMMANDE_CLIENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."TR_COMMANDE_CLIENT" (
    "ID" integer NOT NULL,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_COMMANDE" integer DEFAULT 1,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1
);


ALTER TABLE "Default"."TR_COMMANDE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 607 (class 1259 OID 36392043)
-- Name: TR_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."TR_COMMANDE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."TR_COMMANDE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21573 (class 0 OID 0)
-- Dependencies: 607
-- Name: TR_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."TR_COMMANDE_CLIENT_ID_seq" OWNED BY "Default"."TR_COMMANDE_CLIENT"."ID";


--
-- TOC entry 608 (class 1259 OID 36392045)
-- Name: TR_COMMANDE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."TR_COMMANDE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."TR_COMMANDE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21574 (class 0 OID 0)
-- Dependencies: 608
-- Name: TR_COMMANDE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."TR_COMMANDE_ID_seq" OWNED BY "Default"."TR_COMMANDE"."ID";


--
-- TOC entry 609 (class 1259 OID 36392047)
-- Name: TR_DEVIS; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."TR_DEVIS" (
    "ID" integer NOT NULL,
    "ID_DEVIS" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_COMMANDE" integer DEFAULT 1,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1
);


ALTER TABLE "Default"."TR_DEVIS" OWNER TO openconcerto;

--
-- TOC entry 610 (class 1259 OID 36392056)
-- Name: TR_DEVIS_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."TR_DEVIS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."TR_DEVIS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21575 (class 0 OID 0)
-- Dependencies: 610
-- Name: TR_DEVIS_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."TR_DEVIS_ID_seq" OWNED BY "Default"."TR_DEVIS"."ID";


--
-- TOC entry 611 (class 1259 OID 36392058)
-- Name: TR_SAISIE_ACHAT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."TR_SAISIE_ACHAT" (
    "ID" integer NOT NULL,
    "ID_SAISIE_ACHAT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_AVOIR_FOURNISSEUR" integer DEFAULT 1
);


ALTER TABLE "Default"."TR_SAISIE_ACHAT" OWNER TO openconcerto;

--
-- TOC entry 612 (class 1259 OID 36392065)
-- Name: TR_SAISIE_ACHAT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."TR_SAISIE_ACHAT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."TR_SAISIE_ACHAT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21576 (class 0 OID 0)
-- Dependencies: 612
-- Name: TR_SAISIE_ACHAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."TR_SAISIE_ACHAT_ID_seq" OWNED BY "Default"."TR_SAISIE_ACHAT"."ID";


--
-- TOC entry 613 (class 1259 OID 36392067)
-- Name: TR_SAISIE_VENTE_FACTURE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."TR_SAISIE_VENTE_FACTURE" (
    "ID" integer NOT NULL,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "ID_COMMANDE" integer DEFAULT 1,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1
);


ALTER TABLE "Default"."TR_SAISIE_VENTE_FACTURE" OWNER TO openconcerto;

--
-- TOC entry 614 (class 1259 OID 36392076)
-- Name: TR_SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."TR_SAISIE_VENTE_FACTURE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."TR_SAISIE_VENTE_FACTURE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21577 (class 0 OID 0)
-- Dependencies: 614
-- Name: TR_SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."TR_SAISIE_VENTE_FACTURE_ID_seq" OWNED BY "Default"."TR_SAISIE_VENTE_FACTURE"."ID";


--
-- TOC entry 615 (class 1259 OID 36392078)
-- Name: TYPE_COMPTE_PCG; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."TYPE_COMPTE_PCG" (
    "ID" integer NOT NULL,
    "RACINE" boolean DEFAULT false,
    "NOM" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "Default"."TYPE_COMPTE_PCG" OWNER TO openconcerto;

--
-- TOC entry 616 (class 1259 OID 36392086)
-- Name: TYPE_COMPTE_PCG_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."TYPE_COMPTE_PCG_ID_seq"
    START WITH 8
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."TYPE_COMPTE_PCG_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21578 (class 0 OID 0)
-- Dependencies: 616
-- Name: TYPE_COMPTE_PCG_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."TYPE_COMPTE_PCG_ID_seq" OWNED BY "Default"."TYPE_COMPTE_PCG"."ID";


--
-- TOC entry 617 (class 1259 OID 36392088)
-- Name: TYPE_LETTRE_RELANCE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."TYPE_LETTRE_RELANCE" (
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "MODELE" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."TYPE_LETTRE_RELANCE" OWNER TO openconcerto;

--
-- TOC entry 618 (class 1259 OID 36392099)
-- Name: TYPE_LETTRE_RELANCE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."TYPE_LETTRE_RELANCE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."TYPE_LETTRE_RELANCE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21579 (class 0 OID 0)
-- Dependencies: 618
-- Name: TYPE_LETTRE_RELANCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."TYPE_LETTRE_RELANCE_ID_seq" OWNED BY "Default"."TYPE_LETTRE_RELANCE"."ID";


--
-- TOC entry 619 (class 1259 OID 36392101)
-- Name: TYPE_REGLEMENT; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."TYPE_REGLEMENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "COMPTANT" boolean DEFAULT false,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_COMPTE_PCE_CLIENT" integer DEFAULT 1,
    "ID_COMPTE_PCE_FOURN" integer DEFAULT 1,
    "ECHEANCE" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "Default"."TYPE_REGLEMENT" OWNER TO openconcerto;

--
-- TOC entry 620 (class 1259 OID 36392116)
-- Name: TYPE_REGLEMENT_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."TYPE_REGLEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."TYPE_REGLEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21580 (class 0 OID 0)
-- Dependencies: 620
-- Name: TYPE_REGLEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."TYPE_REGLEMENT_ID_seq" OWNED BY "Default"."TYPE_REGLEMENT"."ID";


--
-- TOC entry 621 (class 1259 OID 36392118)
-- Name: UNITE_VENTE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."UNITE_VENTE" (
    "ID" integer NOT NULL,
    "CODE" character varying(32) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "A_LA_PIECE" boolean DEFAULT false,
    "INFOS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."UNITE_VENTE" OWNER TO openconcerto;

--
-- TOC entry 622 (class 1259 OID 36392130)
-- Name: UNITE_VENTE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."UNITE_VENTE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."UNITE_VENTE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21581 (class 0 OID 0)
-- Dependencies: 622
-- Name: UNITE_VENTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."UNITE_VENTE_ID_seq" OWNED BY "Default"."UNITE_VENTE"."ID";


--
-- TOC entry 623 (class 1259 OID 36392132)
-- Name: VARIABLE_SALARIE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."VARIABLE_SALARIE" (
    "ID" integer NOT NULL,
    "HEURE_ABS" real DEFAULT 0,
    "HEURE_110" real DEFAULT 0,
    "HEURE_125" real DEFAULT 0,
    "HEURE_150" real DEFAULT 0,
    "HEURE_200" real DEFAULT 0,
    "CONGES_PRIS" real DEFAULT 0,
    "HEURE_TRAV" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "HEURE_200_DEFAULT_VAL" real DEFAULT 0,
    "HEURE_ABS_DEFAULT_VAL" real DEFAULT 0,
    "HEURE_150_DEFAULT_VAL" real DEFAULT 0,
    "HEURE_110_DEFAULT_VAL" real DEFAULT 0,
    "HEURE_125_DEFAULT_VAL" real DEFAULT 0,
    "CONGES_PRIS_DEFAULT_VAL" real DEFAULT 0,
    "IJSS_BRUT" real DEFAULT 0,
    "IJSS_BRUT_DEFAULT_VAL" real DEFAULT 0,
    "IJSS_NET" real DEFAULT 0,
    "IJSS_NET_DEFAULT_VAL" real DEFAULT 0,
    "FRAIS_PRO" real DEFAULT 0,
    "FRAIS_PRO_DEFAULT_VAL" real DEFAULT 0,
    "RBT_TRANSPORT" real DEFAULT 0,
    "RBT_TRANSPORT_DEFAULT_VAL" real DEFAULT 0
);


ALTER TABLE "Default"."VARIABLE_SALARIE" OWNER TO openconcerto;

--
-- TOC entry 624 (class 1259 OID 36392157)
-- Name: VARIABLE_SALARIE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."VARIABLE_SALARIE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."VARIABLE_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21582 (class 0 OID 0)
-- Dependencies: 624
-- Name: VARIABLE_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."VARIABLE_SALARIE_ID_seq" OWNED BY "Default"."VARIABLE_SALARIE"."ID";


--
-- TOC entry 625 (class 1259 OID 36392159)
-- Name: VILLE; Type: TABLE; Schema: Default; Owner: openconcerto
--

CREATE TABLE "Default"."VILLE" (
    "ID" integer NOT NULL,
    "X_LAMBERT" bigint DEFAULT 0,
    "Y_LAMBERT" bigint DEFAULT 0,
    "POPULATION" bigint DEFAULT 0,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "CODE_POSTAL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "Default"."VILLE" OWNER TO openconcerto;

--
-- TOC entry 626 (class 1259 OID 36392172)
-- Name: VILLE_ID_seq; Type: SEQUENCE; Schema: Default; Owner: openconcerto
--

CREATE SEQUENCE "Default"."VILLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "Default"."VILLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21583 (class 0 OID 0)
-- Dependencies: 626
-- Name: VILLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: Default; Owner: openconcerto
--

ALTER SEQUENCE "Default"."VILLE_ID_seq" OWNED BY "Default"."VILLE"."ID";


--
-- TOC entry 627 (class 1259 OID 36392174)
-- Name: ACOMPTE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ACOMPTE" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MONTANT" real DEFAULT 0,
    "ID_SALARIE" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."ACOMPTE" OWNER TO openconcerto;

--
-- TOC entry 628 (class 1259 OID 36392183)
-- Name: ACOMPTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ACOMPTE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ACOMPTE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21584 (class 0 OID 0)
-- Dependencies: 628
-- Name: ACOMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ACOMPTE_ID_seq" OWNED BY "OpenConcerto42"."ACOMPTE"."ID";


--
-- TOC entry 629 (class 1259 OID 36392185)
-- Name: ADRESSE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ADRESSE" (
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID_ADRESSE" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "DEST" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CEDEX" integer,
    "RUE" character varying(2048) DEFAULT ''::text,
    "ID_CLIENT" integer DEFAULT 1,
    "HAS_CEDEX" boolean DEFAULT false,
    "VILLE" character varying(2048) DEFAULT ''::text,
    "PAYS" character varying(100) DEFAULT ''::character varying,
    "CODE_POSTAL" character varying(256) DEFAULT ''::character varying,
    "PROVINCE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "LIBELLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TYPE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "EMAIL_CONTACT" character varying(256) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."ADRESSE" OWNER TO openconcerto;

--
-- TOC entry 630 (class 1259 OID 36392205)
-- Name: ADRESSE_ID_ADRESSE_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ADRESSE_ID_ADRESSE_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ADRESSE_ID_ADRESSE_seq" OWNER TO openconcerto;

--
-- TOC entry 21585 (class 0 OID 0)
-- Dependencies: 630
-- Name: ADRESSE_ID_ADRESSE_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ADRESSE_ID_ADRESSE_seq" OWNED BY "OpenConcerto42"."ADRESSE"."ID_ADRESSE";


--
-- TOC entry 631 (class 1259 OID 36392207)
-- Name: ARRET_TRAVAIL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ARRET_TRAVAIL" (
    "ID" integer NOT NULL,
    "ID_SALARIE" integer DEFAULT 1,
    "DATE_DERNIER_JOUR_TRAV" timestamp without time zone,
    "DATE_FIN_PREV" timestamp without time zone,
    "SUBROGATION" boolean DEFAULT false NOT NULL,
    "DATE_DEBUT_SUBROGATION" timestamp without time zone,
    "DATE_FIN_SUBROGATION" timestamp without time zone,
    "ID_MOTIF_ARRET_TRAVAIL" integer DEFAULT 1,
    "ID_MOTIF_REPRISE_ARRET_TRAVAIL" integer DEFAULT 1,
    "DATE_REPRISE" timestamp without time zone,
    "DATE_ACCIDENT" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "DATE" timestamp without time zone,
    "COMMENTAIRES" character varying(2048) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."ARRET_TRAVAIL" OWNER TO openconcerto;

--
-- TOC entry 632 (class 1259 OID 36392220)
-- Name: ARRET_TRAVAIL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ARRET_TRAVAIL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ARRET_TRAVAIL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21586 (class 0 OID 0)
-- Dependencies: 632
-- Name: ARRET_TRAVAIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ARRET_TRAVAIL_ID_seq" OWNED BY "OpenConcerto42"."ARRET_TRAVAIL"."ID";


--
-- TOC entry 633 (class 1259 OID 36392222)
-- Name: ARTICLE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ARTICLE" (
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "POIDS" real DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "CREATION_AUTO" boolean DEFAULT false,
    "ORDRE" numeric(16,8),
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_STOCK" integer DEFAULT 1,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "OBSOLETE" boolean DEFAULT false,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "CODE_BARRE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "GESTION_STOCK" boolean DEFAULT true,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "QTE_MIN" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_DEVISE_HA" integer DEFAULT 1,
    "PA_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "SKU" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ID_TAXE_COMPLEMENTAIRE" integer DEFAULT 1,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "ID_FABRICANT" integer DEFAULT 1,
    "TARE" numeric(16,8) DEFAULT 0,
    "IFCO" integer DEFAULT 0 NOT NULL,
    "MASQUE_CAISSE" boolean DEFAULT false NOT NULL,
    "ADDITIONAL_TICKET_COPY" boolean DEFAULT false NOT NULL,
    "MATIERE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1 NOT NULL,
    "ID_COUT_REVIENT" integer DEFAULT 1,
    "MARGE_WITH_COUT_REVIENT" boolean DEFAULT false NOT NULL,
    "AUTO_PRIX_ACHAT_NOMENCLATURE" boolean DEFAULT false NOT NULL,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."ARTICLE" OWNER TO openconcerto;

--
-- TOC entry 1320 (class 1259 OID 36416271)
-- Name: ARTICLE_CATEGORIE_COMPTABLE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ARTICLE_CATEGORIE_COMPTABLE" (
    "ID" integer NOT NULL,
    "ID_CATEGORIE_COMPTABLE" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_TAXE_ACHAT" integer DEFAULT 1,
    "ID_TAXE_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."ARTICLE_CATEGORIE_COMPTABLE" OWNER TO openconcerto;

--
-- TOC entry 1319 (class 1259 OID 36416269)
-- Name: ARTICLE_CATEGORIE_COMPTABLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ARTICLE_CATEGORIE_COMPTABLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ARTICLE_CATEGORIE_COMPTABLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21587 (class 0 OID 0)
-- Dependencies: 1319
-- Name: ARTICLE_CATEGORIE_COMPTABLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ARTICLE_CATEGORIE_COMPTABLE_ID_seq" OWNED BY "OpenConcerto42"."ARTICLE_CATEGORIE_COMPTABLE"."ID";


--
-- TOC entry 634 (class 1259 OID 36392279)
-- Name: ARTICLE_CODE_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ARTICLE_CODE_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "CODE" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."ARTICLE_CODE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 635 (class 1259 OID 36392290)
-- Name: ARTICLE_CODE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ARTICLE_CODE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ARTICLE_CODE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21588 (class 0 OID 0)
-- Dependencies: 635
-- Name: ARTICLE_CODE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ARTICLE_CODE_CLIENT_ID_seq" OWNED BY "OpenConcerto42"."ARTICLE_CODE_CLIENT"."ID";


--
-- TOC entry 636 (class 1259 OID 36392292)
-- Name: ARTICLE_DESIGNATION; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ARTICLE_DESIGNATION" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1,
    "NOM" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."ARTICLE_DESIGNATION" OWNER TO openconcerto;

--
-- TOC entry 637 (class 1259 OID 36392303)
-- Name: ARTICLE_DESIGNATION_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ARTICLE_DESIGNATION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ARTICLE_DESIGNATION_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21589 (class 0 OID 0)
-- Dependencies: 637
-- Name: ARTICLE_DESIGNATION_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ARTICLE_DESIGNATION_ID_seq" OWNED BY "OpenConcerto42"."ARTICLE_DESIGNATION"."ID";


--
-- TOC entry 638 (class 1259 OID 36392305)
-- Name: ARTICLE_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ARTICLE_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_ARTICLE_PARENT" integer DEFAULT 1,
    "QTE" integer DEFAULT 1 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1 NOT NULL,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."ARTICLE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 639 (class 1259 OID 36392315)
-- Name: ARTICLE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ARTICLE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ARTICLE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21590 (class 0 OID 0)
-- Dependencies: 639
-- Name: ARTICLE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ARTICLE_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."ARTICLE_ELEMENT"."ID";


--
-- TOC entry 640 (class 1259 OID 36392317)
-- Name: ARTICLE_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ARTICLE_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying NOT NULL,
    "CODE_BARRE" character varying(45) DEFAULT ''::character varying NOT NULL,
    "CODE_DOUANIER" character varying(45) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0,
    "PRIX_METRIQUE_HA_2" numeric(16,8) DEFAULT 0,
    "PRIX_METRIQUE_HA_3" numeric(16,8) DEFAULT 0,
    "PRIX_METRIQUE_VT_1" numeric(16,8) DEFAULT 0,
    "PRIX_METRIQUE_VT_2" numeric(16,8) DEFAULT 0,
    "PRIX_METRIQUE_VT_3" numeric(16,8) DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PA_DEVISE" numeric(16,8) DEFAULT 0,
    "PV_U_DEVISE" numeric(16,8) DEFAULT 0,
    "PA_HT" numeric(16,8) DEFAULT 0,
    "PV_HT" numeric(16,8) DEFAULT 0,
    "PV_TTC" numeric(16,2) DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE_FOURNISSEUR" integer DEFAULT 1,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_DEVISE_HA" integer DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "SERVICE" boolean DEFAULT false NOT NULL,
    "OBSOLETE" boolean DEFAULT false NOT NULL,
    "GESTION_STOCK" boolean DEFAULT false NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1 NOT NULL,
    "QTE_MIN" integer DEFAULT 1 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."ARTICLE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 641 (class 1259 OID 36392366)
-- Name: ARTICLE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ARTICLE_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ARTICLE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21591 (class 0 OID 0)
-- Dependencies: 641
-- Name: ARTICLE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ARTICLE_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto42"."ARTICLE_FOURNISSEUR"."ID";


--
-- TOC entry 1322 (class 1259 OID 36416324)
-- Name: ARTICLE_FOURNISSEUR_SECONDAIRE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ARTICLE_FOURNISSEUR_SECONDAIRE" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."ARTICLE_FOURNISSEUR_SECONDAIRE" OWNER TO openconcerto;

--
-- TOC entry 1321 (class 1259 OID 36416322)
-- Name: ARTICLE_FOURNISSEUR_SECONDAIRE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ARTICLE_FOURNISSEUR_SECONDAIRE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ARTICLE_FOURNISSEUR_SECONDAIRE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21592 (class 0 OID 0)
-- Dependencies: 1321
-- Name: ARTICLE_FOURNISSEUR_SECONDAIRE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ARTICLE_FOURNISSEUR_SECONDAIRE_ID_seq" OWNED BY "OpenConcerto42"."ARTICLE_FOURNISSEUR_SECONDAIRE"."ID";


--
-- TOC entry 642 (class 1259 OID 36392368)
-- Name: ARTICLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ARTICLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21593 (class 0 OID 0)
-- Dependencies: 642
-- Name: ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ARTICLE_ID_seq" OWNED BY "OpenConcerto42"."ARTICLE"."ID";


--
-- TOC entry 643 (class 1259 OID 36392370)
-- Name: ARTICLE_TARIF; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ARTICLE_TARIF" (
    "ID" integer NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "ID_TARIF" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "POURCENT_REMISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE" integer DEFAULT 1 NOT NULL
);


ALTER TABLE "OpenConcerto42"."ARTICLE_TARIF" OWNER TO openconcerto;

--
-- TOC entry 1316 (class 1259 OID 36416139)
-- Name: ARTICLE_TARIF_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ARTICLE_TARIF_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "REF_FOURNISSEUR" character varying(500) DEFAULT ''::character varying NOT NULL,
    "TYPE_REAPPRO" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CONDITIONS" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ACHETEUR" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_PAYS_ORIGINE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRIX_ACHAT_DEVISE_F" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_ACHAT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE" integer DEFAULT 1 NOT NULL,
    "DATE_PRIX" timestamp without time zone,
    "DELAI_REAPPRO" integer DEFAULT 0 NOT NULL,
    "DELAI_TRANSPORT" integer DEFAULT 0 NOT NULL,
    "PRIORITE" integer DEFAULT 0 NOT NULL,
    "COEF_PRIX_MINI" numeric(16,2) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."ARTICLE_TARIF_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 1315 (class 1259 OID 36416137)
-- Name: ARTICLE_TARIF_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ARTICLE_TARIF_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ARTICLE_TARIF_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21594 (class 0 OID 0)
-- Dependencies: 1315
-- Name: ARTICLE_TARIF_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ARTICLE_TARIF_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto42"."ARTICLE_TARIF_FOURNISSEUR"."ID";


--
-- TOC entry 644 (class 1259 OID 36392386)
-- Name: ARTICLE_TARIF_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ARTICLE_TARIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ARTICLE_TARIF_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21595 (class 0 OID 0)
-- Dependencies: 644
-- Name: ARTICLE_TARIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ARTICLE_TARIF_ID_seq" OWNED BY "OpenConcerto42"."ARTICLE_TARIF"."ID";


--
-- TOC entry 645 (class 1259 OID 36392388)
-- Name: ASSOCIATION_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ASSOCIATION_ANALYTIQUE" (
    "ID" integer NOT NULL,
    "ID_ECRITURE" integer DEFAULT 1,
    "ID_SAISIE_KM_ELEMENT" integer DEFAULT 1,
    "ID_POSTE_ANALYTIQUE" integer DEFAULT 1,
    "POURCENT" numeric(16,8) DEFAULT 100,
    "MONTANT" bigint DEFAULT 0,
    "GESTION_AUTO" boolean DEFAULT false NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."ASSOCIATION_ANALYTIQUE" OWNER TO openconcerto;

--
-- TOC entry 646 (class 1259 OID 36392399)
-- Name: ASSOCIATION_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ASSOCIATION_ANALYTIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ASSOCIATION_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21596 (class 0 OID 0)
-- Dependencies: 646
-- Name: ASSOCIATION_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ASSOCIATION_ANALYTIQUE_ID_seq" OWNED BY "OpenConcerto42"."ASSOCIATION_ANALYTIQUE"."ID";


--
-- TOC entry 647 (class 1259 OID 36392401)
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ASSOCIATION_COMPTE_ANALYTIQUE" (
    "ID_REPARTITION_ANALYTIQUE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_AXE_ANALYTIQUE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."ASSOCIATION_COMPTE_ANALYTIQUE" OWNER TO openconcerto;

--
-- TOC entry 648 (class 1259 OID 36392410)
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21597 (class 0 OID 0)
-- Dependencies: 648
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq" OWNED BY "OpenConcerto42"."ASSOCIATION_COMPTE_ANALYTIQUE"."ID";


--
-- TOC entry 649 (class 1259 OID 36392412)
-- Name: ATTACHMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ATTACHMENT" (
    "ID" integer NOT NULL,
    "SOURCE_TABLE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "SOURCE_ID" integer DEFAULT 0 NOT NULL,
    "NAME" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MIMETYPE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FILENAME" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FILESIZE" bigint DEFAULT 0 NOT NULL,
    "STORAGE_PATH" character varying(256) DEFAULT ''::character varying NOT NULL,
    "STORAGE_FILENAME" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DIRECTORY" character varying(256) DEFAULT ''::character varying NOT NULL,
    "THUMBNAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "THUMBNAIL_WIDTH" integer DEFAULT 32 NOT NULL,
    "THUMBNAIL_HEIGHT" integer DEFAULT 32 NOT NULL,
    "TAG" character varying(128) DEFAULT ''::character varying NOT NULL,
    "VERSION" integer DEFAULT 0 NOT NULL,
    "HASH" character varying(32) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_PARENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."ATTACHMENT" OWNER TO openconcerto;

--
-- TOC entry 650 (class 1259 OID 36392436)
-- Name: ATTACHMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ATTACHMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ATTACHMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21598 (class 0 OID 0)
-- Dependencies: 650
-- Name: ATTACHMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ATTACHMENT_ID_seq" OWNED BY "OpenConcerto42"."ATTACHMENT"."ID";


--
-- TOC entry 651 (class 1259 OID 36392438)
-- Name: AVOIR_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."AVOIR_CLIENT" (
    "MONTANT_SOLDE" bigint DEFAULT 0,
    "SOLDE" boolean DEFAULT false,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "MONTANT_SERVICE" bigint DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "MOTIF" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ENVOYE_EN_AFFACTURAGE" boolean DEFAULT false,
    "REMISE_HT" bigint DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "NOM" character varying(256) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "MONTANT_TTC" bigint DEFAULT 0,
    "MONTANT_HT" bigint DEFAULT 0,
    "PORT_HT" bigint DEFAULT 0,
    "ID_ADRESSE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "DATE_ENVOI_AFFACTURAGE" date,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_CONTACT" integer DEFAULT 1,
    "DATE" date,
    "AFFACTURE" boolean DEFAULT false,
    "MONTANT_TVA" bigint DEFAULT 0,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "COMPTE_SERVICE_AUTO" boolean DEFAULT false,
    "AFFACTURAGE" boolean DEFAULT false,
    "A_DEDUIRE" boolean DEFAULT false,
    "ID_TAXE" integer DEFAULT 1,
    "MONTANT_RESTANT" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "T_DEVISE" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "INFOS" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ID_ADRESSE_LIVRAISON" integer DEFAULT 1,
    "POURCENT_REMISE" numeric(12,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_CLIENT_DEPARTEMENT" integer DEFAULT 1,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."AVOIR_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 652 (class 1259 OID 36392479)
-- Name: AVOIR_CLIENT_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."AVOIR_CLIENT_ELEMENT" (
    "INDICE_N" bigint DEFAULT 0,
    "ID_CONTACT" integer DEFAULT 1,
    "LOCAL_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "POURCENT_SERVICE" character varying(2048) DEFAULT ''::text,
    "SOUS_ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_STYLE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "POIDS" real DEFAULT 0,
    "POURCENT_ACOMPTE" numeric(6,2) DEFAULT 100 NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "MONTANT_REVISABLE" boolean DEFAULT false,
    "TARIF_Q18_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "DATE" timestamp without time zone,
    "ID_TAXE" integer DEFAULT 1,
    "CODE_MISSION" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "DATE_FIN" timestamp without time zone,
    "ACOMPTE" boolean DEFAULT false,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "Q18" boolean DEFAULT false,
    "T_POIDS" real DEFAULT 0,
    "MONTANT_INITIAL" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "POURCENT_REMISE" numeric(12,8) DEFAULT 0,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "NOM_MISSION" character varying(256) DEFAULT ''::character varying,
    "QTE" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "SERVICE" boolean DEFAULT false,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "INDICE_0" bigint DEFAULT 0,
    "INFOS_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "REFERENTIEL_INSPECTION" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "SITUATION_ADMIN" character varying(2048) DEFAULT ''::text,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_T_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "T_POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "NB_COLIS" integer DEFAULT 0,
    "MONTANT_REMISE" numeric(16,8),
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "RETOUR_STOCK" boolean DEFAULT false NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."AVOIR_CLIENT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 653 (class 1259 OID 36392557)
-- Name: AVOIR_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."AVOIR_CLIENT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."AVOIR_CLIENT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21599 (class 0 OID 0)
-- Dependencies: 653
-- Name: AVOIR_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."AVOIR_CLIENT_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."AVOIR_CLIENT_ELEMENT"."ID";


--
-- TOC entry 654 (class 1259 OID 36392559)
-- Name: AVOIR_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."AVOIR_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."AVOIR_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21600 (class 0 OID 0)
-- Dependencies: 654
-- Name: AVOIR_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."AVOIR_CLIENT_ID_seq" OWNED BY "OpenConcerto42"."AVOIR_CLIENT"."ID";


--
-- TOC entry 655 (class 1259 OID 36392561)
-- Name: AVOIR_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."AVOIR_FOURNISSEUR" (
    "SOLDE" boolean DEFAULT false,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "MONTANT_TVA" bigint DEFAULT 0,
    "DATE" date,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "A_DEDUIRE" boolean DEFAULT false,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "IMMO" boolean DEFAULT false,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "MONTANT_HT" bigint DEFAULT 0,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "MONTANT_TTC" bigint DEFAULT 0,
    "INFOS" character varying(1024) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."AVOIR_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 656 (class 1259 OID 36392583)
-- Name: AVOIR_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."AVOIR_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."AVOIR_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21601 (class 0 OID 0)
-- Dependencies: 656
-- Name: AVOIR_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."AVOIR_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto42"."AVOIR_FOURNISSEUR"."ID";


--
-- TOC entry 657 (class 1259 OID 36392585)
-- Name: AXE_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."AXE_ANALYTIQUE" (
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "TYPE" character varying(256) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."AXE_ANALYTIQUE" OWNER TO openconcerto;

--
-- TOC entry 658 (class 1259 OID 36392596)
-- Name: AXE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."AXE_ANALYTIQUE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."AXE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21602 (class 0 OID 0)
-- Dependencies: 658
-- Name: AXE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."AXE_ANALYTIQUE_ID_seq" OWNED BY "OpenConcerto42"."AXE_ANALYTIQUE"."ID";


--
-- TOC entry 659 (class 1259 OID 36392598)
-- Name: AYANT_DROIT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."AYANT_DROIT" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_SALARIE" integer DEFAULT 1,
    "ID_AYANT_DROIT_TYPE" integer DEFAULT 1,
    "REGIME_ALSACE" boolean DEFAULT false NOT NULL,
    "NIR" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRENOMS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_ORGANISME_AFFILIATION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_OPTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NIR_OUVRANT_DROIT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DATE_DEBUT_RATTACHEMENT" timestamp without time zone,
    "DATE_FIN_RATTACHEMENT" timestamp without time zone,
    "DATE_NAISSANCE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."AYANT_DROIT" OWNER TO openconcerto;

--
-- TOC entry 660 (class 1259 OID 36392615)
-- Name: AYANT_DROIT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."AYANT_DROIT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."AYANT_DROIT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21603 (class 0 OID 0)
-- Dependencies: 660
-- Name: AYANT_DROIT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."AYANT_DROIT_ID_seq" OWNED BY "OpenConcerto42"."AYANT_DROIT"."ID";


--
-- TOC entry 661 (class 1259 OID 36392617)
-- Name: BANQUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."BANQUE" (
    "ID" integer NOT NULL,
    "ID_JOURNAL" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RUE" character varying(45) DEFAULT ''::character varying NOT NULL,
    "RUE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "IBAN" character varying(256) DEFAULT ''::character varying NOT NULL,
    "BIC" character varying(256) DEFAULT ''::character varying NOT NULL,
    "VOIE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "VILLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DOMICILIATION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "AFFACTURAGE" boolean DEFAULT false NOT NULL,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."BANQUE" OWNER TO openconcerto;

--
-- TOC entry 662 (class 1259 OID 36392638)
-- Name: BANQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."BANQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."BANQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21604 (class 0 OID 0)
-- Dependencies: 662
-- Name: BANQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."BANQUE_ID_seq" OWNED BY "OpenConcerto42"."BANQUE"."ID";


--
-- TOC entry 663 (class 1259 OID 36392640)
-- Name: BON_DE_LIVRAISON; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."BON_DE_LIVRAISON" (
    "ID_USER_COMMON_CREATE" integer,
    "DATE" date,
    "ID" integer NOT NULL,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "TOTAL_TTC" bigint DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "TOTAL_TVA" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "TOTAL_HT" bigint DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "TOTAL_POIDS" real DEFAULT 0,
    "SOURCE" character varying(512) DEFAULT ''::character varying NOT NULL,
    "IDSOURCE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "DATE_LIVRAISON" date,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_ADRESSE_LIVRAISON" integer DEFAULT 1,
    "POURCENT_REMISE" numeric(12,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_CONTACT" integer DEFAULT 1,
    "ID_CLIENT_DEPARTEMENT" integer DEFAULT 1,
    "TOTAL_DEVISE" bigint DEFAULT 0 NOT NULL,
    "TOTAL_SERVICE" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "PORT_HT" bigint DEFAULT 0 NOT NULL,
    "REMISE_HT" bigint DEFAULT 0 NOT NULL,
    "CREATE_VIRTUAL_STOCK" boolean DEFAULT true NOT NULL,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "FRAIS_DOCUMENT_HT" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE_FRAIS_DOCUMENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."BON_DE_LIVRAISON" OWNER TO openconcerto;

--
-- TOC entry 664 (class 1259 OID 36392674)
-- Name: BON_DE_LIVRAISON_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."BON_DE_LIVRAISON_ELEMENT" (
    "T_POIDS" real DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_A_LIVRER" integer DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE" integer DEFAULT 0,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_STYLE" integer DEFAULT 1,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "POIDS" real DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "T_POIDS_LIVREE" real DEFAULT 0,
    "ID" integer NOT NULL,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_SAISIE_VENTE_FACTURE_ELEMENT" integer DEFAULT 1,
    "QTE_LIVREE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_TAXE" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "POURCENT_REMISE" numeric(12,8) DEFAULT 0,
    "PV_T_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "T_POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "NB_COLIS" integer DEFAULT 0,
    "MONTANT_REMISE" numeric(16,8),
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_COMMANDE_CLIENT_ELEMENT" integer DEFAULT 1,
    "ID_DEPOT_STOCK" integer DEFAULT 1,
    "ID_DEVIS_ELEMENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."BON_DE_LIVRAISON_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 665 (class 1259 OID 36392736)
-- Name: BON_DE_LIVRAISON_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."BON_DE_LIVRAISON_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."BON_DE_LIVRAISON_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21605 (class 0 OID 0)
-- Dependencies: 665
-- Name: BON_DE_LIVRAISON_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."BON_DE_LIVRAISON_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."BON_DE_LIVRAISON_ELEMENT"."ID";


--
-- TOC entry 666 (class 1259 OID 36392738)
-- Name: BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."BON_DE_LIVRAISON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."BON_DE_LIVRAISON_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21606 (class 0 OID 0)
-- Dependencies: 666
-- Name: BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."BON_DE_LIVRAISON_ID_seq" OWNED BY "OpenConcerto42"."BON_DE_LIVRAISON"."ID";


--
-- TOC entry 667 (class 1259 OID 36392740)
-- Name: BON_RECEPTION; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."BON_RECEPTION" (
    "ID_USER_COMMON_CREATE" integer,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "TOTAL_TVA" bigint DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_COMMANDE" integer DEFAULT 1,
    "TOTAL_HT" bigint DEFAULT 0,
    "DATE" date,
    "TOTAL_TTC" bigint DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "TOTAL_POIDS" real DEFAULT 0,
    "ID_DEVISE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "CREATE_VIRTUAL_STOCK" boolean DEFAULT true NOT NULL,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "PORT_HT" bigint DEFAULT 0 NOT NULL,
    "REMISE_HT" bigint DEFAULT 0 NOT NULL
);


ALTER TABLE "OpenConcerto42"."BON_RECEPTION" OWNER TO openconcerto;

--
-- TOC entry 668 (class 1259 OID 36392763)
-- Name: BON_RECEPTION_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."BON_RECEPTION_ELEMENT" (
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_STYLE" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "POIDS" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "T_PA_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "SERVICE" boolean DEFAULT false,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_BON_RECEPTION" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1,
    "PA_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "PA_DEVISE_T" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_CODE_FOURNISSEUR" integer DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_COMMANDE_ELEMENT" integer DEFAULT 1,
    "ID_DEMANDE_ACHAT_ELEMENT" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "QTE_ORIGINE" integer,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."BON_RECEPTION_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 669 (class 1259 OID 36392816)
-- Name: BON_RECEPTION_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."BON_RECEPTION_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."BON_RECEPTION_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21607 (class 0 OID 0)
-- Dependencies: 669
-- Name: BON_RECEPTION_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."BON_RECEPTION_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."BON_RECEPTION_ELEMENT"."ID";


--
-- TOC entry 670 (class 1259 OID 36392818)
-- Name: BON_RECEPTION_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."BON_RECEPTION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."BON_RECEPTION_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21608 (class 0 OID 0)
-- Dependencies: 670
-- Name: BON_RECEPTION_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."BON_RECEPTION_ID_seq" OWNED BY "OpenConcerto42"."BON_RECEPTION"."ID";


--
-- TOC entry 671 (class 1259 OID 36392820)
-- Name: CAISSE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CAISSE" (
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID_DERNIERE_CLOTURE" integer
);


ALTER TABLE "OpenConcerto42"."CAISSE" OWNER TO openconcerto;

--
-- TOC entry 672 (class 1259 OID 36392830)
-- Name: CAISSE_CLOTURE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CAISSE_CLOTURE" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_ENTREE_JOURNAL" integer,
    "PERIODE" character varying(32) DEFAULT ''::character varying NOT NULL,
    "DEBUT" date NOT NULL,
    "FIN" date NOT NULL,
    "TOTAL_TTC" numeric(16,6) DEFAULT 0 NOT NULL,
    "PREMIER_TICKET" character varying(64) DEFAULT NULL::character varying,
    "PREMIER_TICKET_HASH" character varying(128) DEFAULT NULL::character varying,
    "DERNIER_TICKET" character varying(64) DEFAULT NULL::character varying,
    "DERNIER_TICKET_HASH" character varying(128) DEFAULT NULL::character varying,
    "ARCHIVE" integer DEFAULT 0 NOT NULL
);


ALTER TABLE "OpenConcerto42"."CAISSE_CLOTURE" OWNER TO openconcerto;

--
-- TOC entry 673 (class 1259 OID 36392842)
-- Name: CAISSE_CLOTURE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CAISSE_CLOTURE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CAISSE_CLOTURE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21609 (class 0 OID 0)
-- Dependencies: 673
-- Name: CAISSE_CLOTURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CAISSE_CLOTURE_ID_seq" OWNED BY "OpenConcerto42"."CAISSE_CLOTURE"."ID";


--
-- TOC entry 674 (class 1259 OID 36392844)
-- Name: CAISSE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CAISSE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CAISSE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21610 (class 0 OID 0)
-- Dependencies: 674
-- Name: CAISSE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CAISSE_ID_seq" OWNED BY "OpenConcerto42"."CAISSE"."ID";


--
-- TOC entry 675 (class 1259 OID 36392846)
-- Name: CAISSE_JOURNAL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CAISSE_JOURNAL" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_CAISSE" integer DEFAULT 1,
    "DATE" timestamp without time zone,
    "ID_USER" integer DEFAULT 1,
    "EVT" character varying(128) DEFAULT ''::character varying NOT NULL,
    "CREATOR" character varying(128) DEFAULT ''::character varying NOT NULL,
    "CREATOR_VERSION" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "HOST_NAME" character varying(128),
    "HOST_USER" character varying(128)
);


ALTER TABLE "OpenConcerto42"."CAISSE_JOURNAL" OWNER TO openconcerto;

--
-- TOC entry 676 (class 1259 OID 36392860)
-- Name: CAISSE_JOURNAL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CAISSE_JOURNAL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CAISSE_JOURNAL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21611 (class 0 OID 0)
-- Dependencies: 676
-- Name: CAISSE_JOURNAL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CAISSE_JOURNAL_ID_seq" OWNED BY "OpenConcerto42"."CAISSE_JOURNAL"."ID";


--
-- TOC entry 677 (class 1259 OID 36392862)
-- Name: CALENDAR_ITEM; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CALENDAR_ITEM" (
    "ID" integer NOT NULL,
    "START" timestamp without time zone,
    "END" timestamp without time zone,
    "DURATION_S" bigint DEFAULT 0 NOT NULL,
    "SUMMARY" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "DESCRIPTION" character varying(8192) DEFAULT ''::character varying NOT NULL,
    "FLAGS" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "STATUS" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_CALENDAR_ITEM_GROUP" integer,
    "SOURCE_ID" bigint,
    "SOURCE_TABLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "UID" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "LOCATION" character varying(4096) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."CALENDAR_ITEM" OWNER TO openconcerto;

--
-- TOC entry 678 (class 1259 OID 36392878)
-- Name: CALENDAR_ITEM_GROUP; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CALENDAR_ITEM_GROUP" (
    "ID" integer NOT NULL,
    "NAME" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "DESCRIPTION" character varying(8192) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."CALENDAR_ITEM_GROUP" OWNER TO openconcerto;

--
-- TOC entry 679 (class 1259 OID 36392888)
-- Name: CALENDAR_ITEM_GROUP_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CALENDAR_ITEM_GROUP_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CALENDAR_ITEM_GROUP_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21612 (class 0 OID 0)
-- Dependencies: 679
-- Name: CALENDAR_ITEM_GROUP_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CALENDAR_ITEM_GROUP_ID_seq" OWNED BY "OpenConcerto42"."CALENDAR_ITEM_GROUP"."ID";


--
-- TOC entry 680 (class 1259 OID 36392890)
-- Name: CALENDAR_ITEM_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CALENDAR_ITEM_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CALENDAR_ITEM_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21613 (class 0 OID 0)
-- Dependencies: 680
-- Name: CALENDAR_ITEM_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CALENDAR_ITEM_ID_seq" OWNED BY "OpenConcerto42"."CALENDAR_ITEM"."ID";


--
-- TOC entry 681 (class 1259 OID 36392892)
-- Name: CATEGORIE_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CATEGORIE_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."CATEGORIE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 682 (class 1259 OID 36392901)
-- Name: CATEGORIE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CATEGORIE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CATEGORIE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21614 (class 0 OID 0)
-- Dependencies: 682
-- Name: CATEGORIE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CATEGORIE_CLIENT_ID_seq" OWNED BY "OpenConcerto42"."CATEGORIE_CLIENT"."ID";


--
-- TOC entry 1318 (class 1259 OID 36416179)
-- Name: CATEGORIE_COMPTABLE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CATEGORIE_COMPTABLE" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_TAXE_VENTE" integer DEFAULT 1,
    "ID_TAXE_ACHAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."CATEGORIE_COMPTABLE" OWNER TO openconcerto;

--
-- TOC entry 1317 (class 1259 OID 36416177)
-- Name: CATEGORIE_COMPTABLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CATEGORIE_COMPTABLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CATEGORIE_COMPTABLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21615 (class 0 OID 0)
-- Dependencies: 1317
-- Name: CATEGORIE_COMPTABLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CATEGORIE_COMPTABLE_ID_seq" OWNED BY "OpenConcerto42"."CATEGORIE_COMPTABLE"."ID";


--
-- TOC entry 683 (class 1259 OID 36392903)
-- Name: CHEQUE_AVOIR_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CHEQUE_AVOIR_CLIENT" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "DATE_MIN_DECAISSE" date,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "DECAISSE" boolean DEFAULT false,
    "DATE_AVOIR" date,
    "ID_USER_COMMON_CREATE" integer,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "DATE" date,
    "ID_CLIENT" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "DATE_DECAISSE" date,
    "ARCHIVE" integer DEFAULT 0,
    "REG_COMPTA" boolean DEFAULT false,
    "ETS" character varying(2048) DEFAULT ''::text,
    "MONTANT" bigint DEFAULT 0,
    "ID_BANQUE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."CHEQUE_AVOIR_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 684 (class 1259 OID 36392918)
-- Name: CHEQUE_AVOIR_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CHEQUE_AVOIR_CLIENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CHEQUE_AVOIR_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21616 (class 0 OID 0)
-- Dependencies: 684
-- Name: CHEQUE_AVOIR_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CHEQUE_AVOIR_CLIENT_ID_seq" OWNED BY "OpenConcerto42"."CHEQUE_AVOIR_CLIENT"."ID";


--
-- TOC entry 685 (class 1259 OID 36392920)
-- Name: CHEQUE_A_ENCAISSER; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CHEQUE_A_ENCAISSER" (
    "ORDRE" numeric(16,8),
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "DATE_MIN_DEPOT" date,
    "DATE_VENTE" date,
    "ID_USER_COMMON_MODIFY" integer,
    "ARCHIVE" integer DEFAULT 0,
    "ENCAISSE" boolean DEFAULT false,
    "ID_USER_COMMON_CREATE" integer,
    "CREATION_DATE" timestamp without time zone,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "DATE" date,
    "ETS" character varying(2048) DEFAULT ''::text,
    "MONTANT" bigint DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "REG_COMPTA" boolean DEFAULT false,
    "DATE_DEPOT" date,
    "ID_BANQUE" integer DEFAULT 1,
    "SANS_VALEUR_ENCAISSEMENT" boolean DEFAULT false NOT NULL,
    "TIERS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_COMPTE_PCE_TIERS" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."CHEQUE_A_ENCAISSER" OWNER TO openconcerto;

--
-- TOC entry 686 (class 1259 OID 36392936)
-- Name: CHEQUE_A_ENCAISSER_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CHEQUE_A_ENCAISSER_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CHEQUE_A_ENCAISSER_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21617 (class 0 OID 0)
-- Dependencies: 686
-- Name: CHEQUE_A_ENCAISSER_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CHEQUE_A_ENCAISSER_ID_seq" OWNED BY "OpenConcerto42"."CHEQUE_A_ENCAISSER"."ID";


--
-- TOC entry 687 (class 1259 OID 36392938)
-- Name: CHEQUE_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CHEQUE_FOURNISSEUR" (
    "ORDRE" numeric(16,8),
    "ETS" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "DATE_MIN_DECAISSE" date,
    "DATE_ACHAT" date,
    "CREATION_DATE" timestamp without time zone,
    "MONTANT" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "DATE_DECAISSE" date,
    "DATE" date,
    "ID_USER_COMMON_CREATE" integer,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "DECAISSE" boolean DEFAULT false,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "REG_COMPTA" boolean DEFAULT false,
    "ID_BANQUE" integer DEFAULT 1,
    "SANS_VALEUR_ENCAISSEMENT" boolean DEFAULT false NOT NULL
);


ALTER TABLE "OpenConcerto42"."CHEQUE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 688 (class 1259 OID 36392954)
-- Name: CHEQUE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CHEQUE_FOURNISSEUR_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CHEQUE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21618 (class 0 OID 0)
-- Dependencies: 688
-- Name: CHEQUE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CHEQUE_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto42"."CHEQUE_FOURNISSEUR"."ID";


--
-- TOC entry 689 (class 1259 OID 36392956)
-- Name: CHIFFRAGE_COMMANDE_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CHIFFRAGE_COMMANDE_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "QTE" numeric(16,8) DEFAULT 0 NOT NULL,
    "PA_HT" numeric(16,8) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,8) DEFAULT 0 NOT NULL,
    "T_PV_HT" numeric(16,8) DEFAULT 0 NOT NULL,
    "T_PA_HT" numeric(16,8) DEFAULT 0 NOT NULL,
    "MARGE" numeric(16,8) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."CHIFFRAGE_COMMANDE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 690 (class 1259 OID 36392970)
-- Name: CHIFFRAGE_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CHIFFRAGE_COMMANDE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CHIFFRAGE_COMMANDE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21619 (class 0 OID 0)
-- Dependencies: 690
-- Name: CHIFFRAGE_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CHIFFRAGE_COMMANDE_CLIENT_ID_seq" OWNED BY "OpenConcerto42"."CHIFFRAGE_COMMANDE_CLIENT"."ID";


--
-- TOC entry 691 (class 1259 OID 36392972)
-- Name: CLASSEMENT_CONVENTIONNEL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CLASSEMENT_CONVENTIONNEL" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "COEFF" character varying(45) DEFAULT ''::character varying,
    "ECHELON" character varying(45) DEFAULT ''::character varying,
    "NIVEAU" character varying(45) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "POSITION" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "INDICE" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."CLASSEMENT_CONVENTIONNEL" OWNER TO openconcerto;

--
-- TOC entry 692 (class 1259 OID 36392983)
-- Name: CLASSEMENT_CONVENTIONNEL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CLASSEMENT_CONVENTIONNEL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CLASSEMENT_CONVENTIONNEL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21620 (class 0 OID 0)
-- Dependencies: 692
-- Name: CLASSEMENT_CONVENTIONNEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CLASSEMENT_CONVENTIONNEL_ID_seq" OWNED BY "OpenConcerto42"."CLASSEMENT_CONVENTIONNEL"."ID";


--
-- TOC entry 693 (class 1259 OID 36392985)
-- Name: CLASSE_COMPTE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CLASSE_COMPTE" (
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "TYPE_NUMERO_COMPTE" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."CLASSE_COMPTE" OWNER TO openconcerto;

--
-- TOC entry 694 (class 1259 OID 36392996)
-- Name: CLASSE_COMPTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CLASSE_COMPTE_ID_seq"
    START WITH 12
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CLASSE_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21621 (class 0 OID 0)
-- Dependencies: 694
-- Name: CLASSE_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CLASSE_COMPTE_ID_seq" OWNED BY "OpenConcerto42"."CLASSE_COMPTE"."ID";


--
-- TOC entry 695 (class 1259 OID 36392998)
-- Name: CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CLIENT" (
    "ID_USER_COMMON_MODIFY" integer,
    "TEL_TECH" character varying(100) DEFAULT ''::character varying,
    "TEL_P_COM" character varying(100) DEFAULT ''::character varying,
    "MAIL_TECH" character varying(100) DEFAULT ''::character varying,
    "NUMERO_TVA" character varying(100) DEFAULT ''::character varying,
    "TEL_COM" character varying(100) DEFAULT ''::character varying,
    "FAX_TECH" character varying(100) DEFAULT ''::character varying,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "MAX_FACTURE" bigint DEFAULT 0,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "AFFACTURAGE" boolean DEFAULT false,
    "RIB" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ID_ADRESSE_F" integer DEFAULT 1,
    "COMPTE_CLIENT_AUTO" boolean DEFAULT false,
    "MAIL_COM" character varying(100) DEFAULT ''::character varying,
    "FAX_COM" character varying(100) DEFAULT ''::character varying,
    "FAX" character varying(100) DEFAULT ''::character varying,
    "RESPONSABLE_COM" character varying(100) DEFAULT ''::character varying,
    "TEL_P" character varying(100) DEFAULT ''::character varying,
    "RESPONSABLE_TECH" character varying(100) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "TEL" character varying(100) DEFAULT ''::character varying,
    "TEL_P_TECH" character varying(100) DEFAULT ''::character varying,
    "RESPONSABLE" character varying(100) DEFAULT ''::character varying,
    "COMPTANT" boolean DEFAULT false,
    "ID_ADRESSE_L" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "MAIL" character varying(100) DEFAULT ''::character varying,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer,
    "MARCHE_PUBLIC" boolean DEFAULT false,
    "MARCHE_PRIVE" boolean DEFAULT false,
    "FORME_JURIDIQUE" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "SIRET" character varying(2048) DEFAULT ''::text,
    "ID_TARIF" integer DEFAULT 1,
    "ID_PAYS" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "BLOQUE_LIVRAISON" boolean DEFAULT false NOT NULL,
    "BLOQUE" boolean DEFAULT false NOT NULL,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1,
    "ID_COMPTE_PCE_PRODUIT" integer DEFAULT 1,
    "ENCOURS_MAX" numeric(16,2) DEFAULT 0 NOT NULL,
    "CATEGORIES" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NOTE_FINANCIERE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "CENTRE_GESTION" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "METHODE_RELANCE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "SITE_INTERNET" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "GROUPE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "TIMBRE_FISCAL" boolean DEFAULT false NOT NULL,
    "OBSOLETE" boolean DEFAULT false NOT NULL,
    "REMIND_DATE" timestamp without time zone,
    "SOLDE_COMPTE" numeric(16,6) DEFAULT 0 NOT NULL,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "COMMENTAIRES" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "CODE_FOURNISSEUR" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CONDITIONS_LIVRAISON" character varying(512) DEFAULT ''::character varying NOT NULL,
    "DATE" date,
    "IBAN" character varying(128) DEFAULT ''::character varying NOT NULL,
    "BIC" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ACCEPTE_EMAIL" boolean DEFAULT false NOT NULL,
    "ACCEPTE_COURRIER" boolean DEFAULT false NOT NULL,
    "ACCEPTE_SMS" boolean DEFAULT false NOT NULL,
    "ACCEPTE_TEL" boolean DEFAULT false NOT NULL,
    "ID_FRAIS_DOCUMENT" integer DEFAULT 1,
    "ID_CATEGORIE_COMPTABLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."CLIENT" OWNER TO openconcerto;

--
-- TOC entry 696 (class 1259 OID 36393067)
-- Name: CLIENT_DEPARTEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CLIENT_DEPARTEMENT" (
    "ID" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_ADRESSE" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."CLIENT_DEPARTEMENT" OWNER TO openconcerto;

--
-- TOC entry 697 (class 1259 OID 36393079)
-- Name: CLIENT_DEPARTEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CLIENT_DEPARTEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CLIENT_DEPARTEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21622 (class 0 OID 0)
-- Dependencies: 697
-- Name: CLIENT_DEPARTEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CLIENT_DEPARTEMENT_ID_seq" OWNED BY "OpenConcerto42"."CLIENT_DEPARTEMENT"."ID";


--
-- TOC entry 698 (class 1259 OID 36393081)
-- Name: CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21623 (class 0 OID 0)
-- Dependencies: 698
-- Name: CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CLIENT_ID_seq" OWNED BY "OpenConcerto42"."CLIENT"."ID";


--
-- TOC entry 699 (class 1259 OID 36393083)
-- Name: CODE_CARACT_ACTIVITE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CODE_CARACT_ACTIVITE" (
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."CODE_CARACT_ACTIVITE" OWNER TO openconcerto;

--
-- TOC entry 700 (class 1259 OID 36393091)
-- Name: CODE_CARACT_ACTIVITE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CODE_CARACT_ACTIVITE_ID_seq"
    START WITH 12
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_CARACT_ACTIVITE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21624 (class 0 OID 0)
-- Dependencies: 700
-- Name: CODE_CARACT_ACTIVITE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CODE_CARACT_ACTIVITE_ID_seq" OWNED BY "OpenConcerto42"."CODE_CARACT_ACTIVITE"."ID";


--
-- TOC entry 701 (class 1259 OID 36393093)
-- Name: CODE_CONTRAT_TRAVAIL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CODE_CONTRAT_TRAVAIL" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "NOM" character varying(128) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto42"."CODE_CONTRAT_TRAVAIL" OWNER TO openconcerto;

--
-- TOC entry 702 (class 1259 OID 36393101)
-- Name: CODE_CONTRAT_TRAVAIL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CODE_CONTRAT_TRAVAIL_ID_seq"
    START WITH 14
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_CONTRAT_TRAVAIL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21625 (class 0 OID 0)
-- Dependencies: 702
-- Name: CODE_CONTRAT_TRAVAIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CODE_CONTRAT_TRAVAIL_ID_seq" OWNED BY "OpenConcerto42"."CODE_CONTRAT_TRAVAIL"."ID";


--
-- TOC entry 703 (class 1259 OID 36393103)
-- Name: CODE_DROIT_CONTRAT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CODE_DROIT_CONTRAT" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CODE" character varying(4) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."CODE_DROIT_CONTRAT" OWNER TO openconcerto;

--
-- TOC entry 704 (class 1259 OID 36393111)
-- Name: CODE_DROIT_CONTRAT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CODE_DROIT_CONTRAT_ID_seq"
    START WITH 4
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_DROIT_CONTRAT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21626 (class 0 OID 0)
-- Dependencies: 704
-- Name: CODE_DROIT_CONTRAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CODE_DROIT_CONTRAT_ID_seq" OWNED BY "OpenConcerto42"."CODE_DROIT_CONTRAT"."ID";


--
-- TOC entry 705 (class 1259 OID 36393113)
-- Name: CODE_EMPLOI; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CODE_EMPLOI" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "CODE" character varying(11) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "NOM" character varying(195) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."CODE_EMPLOI" OWNER TO openconcerto;

--
-- TOC entry 706 (class 1259 OID 36393121)
-- Name: CODE_EMPLOI_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CODE_EMPLOI_ID_seq"
    START WITH 1036
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_EMPLOI_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21627 (class 0 OID 0)
-- Dependencies: 706
-- Name: CODE_EMPLOI_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CODE_EMPLOI_ID_seq" OWNED BY "OpenConcerto42"."CODE_EMPLOI"."ID";


--
-- TOC entry 707 (class 1259 OID 36393123)
-- Name: CODE_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CODE_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."CODE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 708 (class 1259 OID 36393131)
-- Name: CODE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CODE_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21628 (class 0 OID 0)
-- Dependencies: 708
-- Name: CODE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CODE_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto42"."CODE_FOURNISSEUR"."ID";


--
-- TOC entry 709 (class 1259 OID 36393133)
-- Name: CODE_PENIBILITE_CONTRAT_SALARIE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CODE_PENIBILITE_CONTRAT_SALARIE" (
    "ID" integer NOT NULL,
    "ID_INFOS_SALARIE_PAYE" integer DEFAULT 1,
    "ID_CODE_PENIBILITE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."CODE_PENIBILITE_CONTRAT_SALARIE" OWNER TO openconcerto;

--
-- TOC entry 710 (class 1259 OID 36393140)
-- Name: CODE_PENIBILITE_CONTRAT_SALARIE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CODE_PENIBILITE_CONTRAT_SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_PENIBILITE_CONTRAT_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21629 (class 0 OID 0)
-- Dependencies: 710
-- Name: CODE_PENIBILITE_CONTRAT_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CODE_PENIBILITE_CONTRAT_SALARIE_ID_seq" OWNED BY "OpenConcerto42"."CODE_PENIBILITE_CONTRAT_SALARIE"."ID";


--
-- TOC entry 711 (class 1259 OID 36393142)
-- Name: CODE_REGIME; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CODE_REGIME" (
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "CODE" character varying(4) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."CODE_REGIME" OWNER TO openconcerto;

--
-- TOC entry 712 (class 1259 OID 36393150)
-- Name: CODE_REGIME_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CODE_REGIME_ID_seq"
    START WITH 23
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_REGIME_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21630 (class 0 OID 0)
-- Dependencies: 712
-- Name: CODE_REGIME_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CODE_REGIME_ID_seq" OWNED BY "OpenConcerto42"."CODE_REGIME"."ID";


--
-- TOC entry 713 (class 1259 OID 36393152)
-- Name: CODE_STATUT_CATEGORIEL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CODE_STATUT_CATEGORIEL" (
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."CODE_STATUT_CATEGORIEL" OWNER TO openconcerto;

--
-- TOC entry 714 (class 1259 OID 36393160)
-- Name: CODE_STATUT_CATEGORIEL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CODE_STATUT_CATEGORIEL_ID_seq"
    START WITH 6
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_STATUT_CATEGORIEL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21631 (class 0 OID 0)
-- Dependencies: 714
-- Name: CODE_STATUT_CATEGORIEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CODE_STATUT_CATEGORIEL_ID_seq" OWNED BY "OpenConcerto42"."CODE_STATUT_CATEGORIEL"."ID";


--
-- TOC entry 715 (class 1259 OID 36393162)
-- Name: CODE_STATUT_CAT_CONV; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CODE_STATUT_CAT_CONV" (
    "ID" integer NOT NULL,
    "CODE" character varying(6) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."CODE_STATUT_CAT_CONV" OWNER TO openconcerto;

--
-- TOC entry 716 (class 1259 OID 36393169)
-- Name: CODE_STATUT_CAT_CONV_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CODE_STATUT_CAT_CONV_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_STATUT_CAT_CONV_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21632 (class 0 OID 0)
-- Dependencies: 716
-- Name: CODE_STATUT_CAT_CONV_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CODE_STATUT_CAT_CONV_ID_seq" OWNED BY "OpenConcerto42"."CODE_STATUT_CAT_CONV"."ID";


--
-- TOC entry 717 (class 1259 OID 36393171)
-- Name: CODE_STATUT_PROF; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CODE_STATUT_PROF" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "NOM" character varying(256) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."CODE_STATUT_PROF" OWNER TO openconcerto;

--
-- TOC entry 718 (class 1259 OID 36393179)
-- Name: CODE_STATUT_PROF_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CODE_STATUT_PROF_ID_seq"
    START WITH 51
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CODE_STATUT_PROF_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21633 (class 0 OID 0)
-- Dependencies: 718
-- Name: CODE_STATUT_PROF_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CODE_STATUT_PROF_ID_seq" OWNED BY "OpenConcerto42"."CODE_STATUT_PROF"."ID";


--
-- TOC entry 719 (class 1259 OID 36393181)
-- Name: COEFF_PRIME; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."COEFF_PRIME" (
    "ID" integer NOT NULL,
    "PRIME_PERSO" real DEFAULT 0,
    "PRIME_RECONSTRUCTION" real DEFAULT 0,
    "PRIME_ANCIENNETE" real DEFAULT 0,
    "PRIME_DEROULEMENT" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."COEFF_PRIME" OWNER TO openconcerto;

--
-- TOC entry 720 (class 1259 OID 36393190)
-- Name: COEFF_PRIME_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."COEFF_PRIME_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COEFF_PRIME_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21634 (class 0 OID 0)
-- Dependencies: 720
-- Name: COEFF_PRIME_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."COEFF_PRIME_ID_seq" OWNED BY "OpenConcerto42"."COEFF_PRIME"."ID";


--
-- TOC entry 721 (class 1259 OID 36393192)
-- Name: COMMANDE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."COMMANDE" (
    "ID_USER_COMMON_CREATE" integer,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "DATE_ECHEANCE" date,
    "SOURCE" character varying(100) DEFAULT ''::character varying,
    "T_HT" bigint DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "T_TVA" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "ORDRE" numeric(16,8),
    "DATE" date,
    "T_SERVICE" bigint DEFAULT 0,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "T_TTC" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "IDSOURCE" integer DEFAULT 1,
    "T_POIDS" real DEFAULT 0,
    "ID_DEVISE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "EN_COURS" boolean DEFAULT true,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "DATE_RECEPTION_DEMANDEE" date,
    "DATE_RECEPTION_CONFIRMEE" date,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "PORT_HT" bigint DEFAULT 0 NOT NULL,
    "REMISE_HT" bigint DEFAULT 0 NOT NULL
);


ALTER TABLE "OpenConcerto42"."COMMANDE" OWNER TO openconcerto;

--
-- TOC entry 722 (class 1259 OID 36393221)
-- Name: COMMANDE_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."COMMANDE_CLIENT" (
    "MODIFICATION_DATE" timestamp without time zone,
    "T_POIDS" real DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "T_SERVICE" bigint DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "DATE_ECHEANCE" date,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "T_TTC" bigint DEFAULT 0,
    "T_TVA" bigint DEFAULT 0,
    "SOURCE" character varying(100) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer,
    "T_HT" bigint DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "DATE" date,
    "CREATION_DATE" timestamp without time zone,
    "IDSOURCE" integer DEFAULT 1,
    "ID_DEVIS" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_ADRESSE_LIVRAISON" integer DEFAULT 1,
    "POURCENT_REMISE" numeric(12,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_CONTACT" integer DEFAULT 1,
    "ID_CLIENT_DEPARTEMENT" integer DEFAULT 1,
    "ETAT_COMMANDE" integer DEFAULT 1 NOT NULL,
    "EMBALLAGE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NUMERO_EXPEDITION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "PORT_HT" bigint DEFAULT 0 NOT NULL,
    "REMISE_HT" bigint DEFAULT 0 NOT NULL,
    "TYPE_EXPEDITION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "DATE_LIVRAISON_PREV" date,
    "FRAIS_DOCUMENT_HT" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE_FRAIS_DOCUMENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."COMMANDE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 723 (class 1259 OID 36393256)
-- Name: COMMANDE_CLIENT_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."COMMANDE_CLIENT_ELEMENT" (
    "ORDRE" numeric(16,8),
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE" integer DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "SERVICE" boolean DEFAULT false,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "POIDS" real DEFAULT 0,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_POIDS" real DEFAULT 0,
    "ID_STYLE" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "POURCENT_REMISE" numeric(12,8) DEFAULT 0,
    "PV_T_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "T_POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "NB_COLIS" integer DEFAULT 0,
    "MONTANT_REMISE" numeric(16,8),
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "LIVRE_FORCED" boolean DEFAULT false NOT NULL,
    "LIVRE" boolean DEFAULT false NOT NULL,
    "QTE_LIVREE" numeric(16,6) DEFAULT 0,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."COMMANDE_CLIENT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 724 (class 1259 OID 36393316)
-- Name: COMMANDE_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."COMMANDE_CLIENT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COMMANDE_CLIENT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21635 (class 0 OID 0)
-- Dependencies: 724
-- Name: COMMANDE_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."COMMANDE_CLIENT_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."COMMANDE_CLIENT_ELEMENT"."ID";


--
-- TOC entry 725 (class 1259 OID 36393318)
-- Name: COMMANDE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."COMMANDE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COMMANDE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21636 (class 0 OID 0)
-- Dependencies: 725
-- Name: COMMANDE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."COMMANDE_CLIENT_ID_seq" OWNED BY "OpenConcerto42"."COMMANDE_CLIENT"."ID";


--
-- TOC entry 726 (class 1259 OID 36393320)
-- Name: COMMANDE_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."COMMANDE_ELEMENT" (
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "T_POIDS" real DEFAULT 0,
    "T_PA_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_TAXE" integer DEFAULT 1,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_STYLE" integer DEFAULT 1,
    "QTE" integer DEFAULT 0,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "POIDS" real DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "ID_COMMANDE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1,
    "PA_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "PA_DEVISE_T" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_CODE_FOURNISSEUR" integer DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "RECU_FORCED" boolean DEFAULT false NOT NULL,
    "RECU" boolean DEFAULT true NOT NULL,
    "QTE_RECUE" numeric(16,6) DEFAULT 0,
    "ID_DEMANDE_ACHAT_ELEMENT" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."COMMANDE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 727 (class 1259 OID 36393375)
-- Name: COMMANDE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."COMMANDE_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COMMANDE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21637 (class 0 OID 0)
-- Dependencies: 727
-- Name: COMMANDE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."COMMANDE_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."COMMANDE_ELEMENT"."ID";


--
-- TOC entry 728 (class 1259 OID 36393377)
-- Name: COMMANDE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."COMMANDE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COMMANDE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21638 (class 0 OID 0)
-- Dependencies: 728
-- Name: COMMANDE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."COMMANDE_ID_seq" OWNED BY "OpenConcerto42"."COMMANDE"."ID";


--
-- TOC entry 729 (class 1259 OID 36393379)
-- Name: COMMERCIAL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."COMMERCIAL" (
    "FONCTION" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer,
    "ORDRE" numeric(16,8),
    "FAX" character varying(100) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "TEL_MOBILE" character varying(100) DEFAULT ''::character varying,
    "ID_COMMERCIAL" integer NOT NULL,
    "TEL_STANDARD" character varying(100) DEFAULT ''::character varying,
    "PRENOM" character varying(100) DEFAULT ''::character varying,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "TEL_DIRECT" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer,
    "EMAIL" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON" integer DEFAULT 1,
    "TEL_PERSONEL" character varying(100) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto42"."COMMERCIAL" OWNER TO openconcerto;

--
-- TOC entry 730 (class 1259 OID 36393397)
-- Name: COMMERCIAL_ID_COMMERCIAL_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."COMMERCIAL_ID_COMMERCIAL_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COMMERCIAL_ID_COMMERCIAL_seq" OWNER TO openconcerto;

--
-- TOC entry 21639 (class 0 OID 0)
-- Dependencies: 730
-- Name: COMMERCIAL_ID_COMMERCIAL_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."COMMERCIAL_ID_COMMERCIAL_seq" OWNED BY "OpenConcerto42"."COMMERCIAL"."ID_COMMERCIAL";


--
-- TOC entry 731 (class 1259 OID 36393399)
-- Name: COMPLETION; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."COMPLETION" (
    "CHAMP" character varying(100) DEFAULT ''::character varying NOT NULL,
    "LABEL" character varying(200) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."COMPLETION" OWNER TO openconcerto;

--
-- TOC entry 732 (class 1259 OID 36393404)
-- Name: COMPTE_CLIENT_TRANSACTION; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."COMPTE_CLIENT_TRANSACTION" (
    "ID" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "DATE" timestamp without time zone,
    "MONTANT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."COMPTE_CLIENT_TRANSACTION" OWNER TO openconcerto;

--
-- TOC entry 733 (class 1259 OID 36393413)
-- Name: COMPTE_CLIENT_TRANSACTION_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."COMPTE_CLIENT_TRANSACTION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COMPTE_CLIENT_TRANSACTION_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21640 (class 0 OID 0)
-- Dependencies: 733
-- Name: COMPTE_CLIENT_TRANSACTION_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."COMPTE_CLIENT_TRANSACTION_ID_seq" OWNED BY "OpenConcerto42"."COMPTE_CLIENT_TRANSACTION"."ID";


--
-- TOC entry 734 (class 1259 OID 36393415)
-- Name: COMPTE_PCE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."COMPTE_PCE" (
    "CREATION_DATE" timestamp without time zone,
    "ID_NATURE_COMPTE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "TOTAL_CREDIT" bigint DEFAULT 0,
    "INFOS" character varying(3072) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "TOTAL_DEBIT" bigint DEFAULT 0,
    "ORDRE" numeric(16,8),
    "RACINE" boolean DEFAULT false,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "OBSOLETE" boolean DEFAULT false NOT NULL
);


ALTER TABLE "OpenConcerto42"."COMPTE_PCE" OWNER TO openconcerto;

--
-- TOC entry 735 (class 1259 OID 36393432)
-- Name: COMPTE_PCE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."COMPTE_PCE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COMPTE_PCE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21641 (class 0 OID 0)
-- Dependencies: 735
-- Name: COMPTE_PCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."COMPTE_PCE_ID_seq" OWNED BY "OpenConcerto42"."COMPTE_PCE"."ID";


--
-- TOC entry 736 (class 1259 OID 36393434)
-- Name: COMPTE_PCG; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."COMPTE_PCG" (
    "ARCHIVE" integer DEFAULT 0,
    "ID_TYPE_COMPTE_PCG_BASE" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID_NATURE_COMPTE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "INFOS" character varying(3072) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_TYPE_COMPTE_PCG_DEV" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_TYPE_COMPTE_PCG_AB" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."COMPTE_PCG" OWNER TO openconcerto;

--
-- TOC entry 737 (class 1259 OID 36393450)
-- Name: COMPTE_PCG_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."COMPTE_PCG_ID_seq"
    START WITH 978
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COMPTE_PCG_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21642 (class 0 OID 0)
-- Dependencies: 737
-- Name: COMPTE_PCG_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."COMPTE_PCG_ID_seq" OWNED BY "OpenConcerto42"."COMPTE_PCG"."ID";


--
-- TOC entry 738 (class 1259 OID 36393452)
-- Name: CONTACT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CONTACT" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "FAX" character varying(100) DEFAULT ''::character varying,
    "TEL_MOBILE" character varying(100) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "PRENOM" character varying(100) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_CLIENT" integer DEFAULT 1,
    "TEL_PERSONEL" character varying(100) DEFAULT ''::character varying,
    "ID_TITRE_PERSONNEL" integer DEFAULT 2,
    "TEL_DIRECT" character varying(100) DEFAULT ''::character varying,
    "EMAIL" character varying(100) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "TEL_STANDARD" character varying(100) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "FONCTION" character varying(2048) DEFAULT ''::text,
    "NO_MAILING" boolean DEFAULT false NOT NULL,
    "DATE_NAISSANCE" date
);


ALTER TABLE "OpenConcerto42"."CONTACT" OWNER TO openconcerto;

--
-- TOC entry 739 (class 1259 OID 36393474)
-- Name: CONTACT_ADMINISTRATIF; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CONTACT_ADMINISTRATIF" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRENOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_DIRECT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_MOBILE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "EMAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FAX" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FONCTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_PERSONEL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_STANDARD" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "N4DS" boolean DEFAULT false,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."CONTACT_ADMINISTRATIF" OWNER TO openconcerto;

--
-- TOC entry 740 (class 1259 OID 36393493)
-- Name: CONTACT_ADMINISTRATIF_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CONTACT_ADMINISTRATIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CONTACT_ADMINISTRATIF_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21643 (class 0 OID 0)
-- Dependencies: 740
-- Name: CONTACT_ADMINISTRATIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CONTACT_ADMINISTRATIF_ID_seq" OWNED BY "OpenConcerto42"."CONTACT_ADMINISTRATIF"."ID";


--
-- TOC entry 741 (class 1259 OID 36393495)
-- Name: CONTACT_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CONTACT_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRENOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_DIRECT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_MOBILE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "EMAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FAX" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FONCTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_PERSONEL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_STANDARD" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."CONTACT_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 742 (class 1259 OID 36393514)
-- Name: CONTACT_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CONTACT_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CONTACT_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21644 (class 0 OID 0)
-- Dependencies: 742
-- Name: CONTACT_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CONTACT_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto42"."CONTACT_FOURNISSEUR"."ID";


--
-- TOC entry 743 (class 1259 OID 36393516)
-- Name: CONTACT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CONTACT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CONTACT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21645 (class 0 OID 0)
-- Dependencies: 743
-- Name: CONTACT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CONTACT_ID_seq" OWNED BY "OpenConcerto42"."CONTACT"."ID";


--
-- TOC entry 744 (class 1259 OID 36393518)
-- Name: CONTRAT_PREVOYANCE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CONTRAT_PREVOYANCE" (
    "ID" integer NOT NULL,
    "REFERENCE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DATE_DEBUT" timestamp without time zone,
    "DATE_FIN" timestamp without time zone,
    "CODE_ORGANISME" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_DELEGATAIRE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_UNIQUE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "COTISATION_ETABLISSEMENT" boolean DEFAULT false NOT NULL
);


ALTER TABLE "OpenConcerto42"."CONTRAT_PREVOYANCE" OWNER TO openconcerto;

--
-- TOC entry 745 (class 1259 OID 36393532)
-- Name: CONTRAT_PREVOYANCE_AYANT_DROIT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CONTRAT_PREVOYANCE_AYANT_DROIT" (
    "ID" integer NOT NULL,
    "ID_AYANT_DROIT" integer DEFAULT 1,
    "ID_CONTRAT_PREVOYANCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."CONTRAT_PREVOYANCE_AYANT_DROIT" OWNER TO openconcerto;

--
-- TOC entry 746 (class 1259 OID 36393539)
-- Name: CONTRAT_PREVOYANCE_AYANT_DROIT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CONTRAT_PREVOYANCE_AYANT_DROIT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CONTRAT_PREVOYANCE_AYANT_DROIT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21646 (class 0 OID 0)
-- Dependencies: 746
-- Name: CONTRAT_PREVOYANCE_AYANT_DROIT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CONTRAT_PREVOYANCE_AYANT_DROIT_ID_seq" OWNED BY "OpenConcerto42"."CONTRAT_PREVOYANCE_AYANT_DROIT"."ID";


--
-- TOC entry 747 (class 1259 OID 36393541)
-- Name: CONTRAT_PREVOYANCE_CONTRAT_SALARIE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE" (
    "ID" integer NOT NULL,
    "ID_INFOS_SALARIE_PAYE" integer DEFAULT 1,
    "ID_CONTRAT_PREVOYANCE" integer DEFAULT 1,
    "CODE_OPTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_POPULATION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NB_ENFANT_CHARGE" integer,
    "NB_ADULTE_AYANT_DROIT" integer,
    "NB_AYANT_DROIT" integer,
    "NB_AYANT_DROIT_AUTRE" integer,
    "NB_ENFANT_AYANT_DROIT" integer,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE" OWNER TO openconcerto;

--
-- TOC entry 748 (class 1259 OID 36393553)
-- Name: CONTRAT_PREVOYANCE_CONTRAT_SALARIE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21647 (class 0 OID 0)
-- Dependencies: 748
-- Name: CONTRAT_PREVOYANCE_CONTRAT_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE_ID_seq" OWNED BY "OpenConcerto42"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE"."ID";


--
-- TOC entry 749 (class 1259 OID 36393555)
-- Name: CONTRAT_PREVOYANCE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CONTRAT_PREVOYANCE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CONTRAT_PREVOYANCE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21648 (class 0 OID 0)
-- Dependencies: 749
-- Name: CONTRAT_PREVOYANCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CONTRAT_PREVOYANCE_ID_seq" OWNED BY "OpenConcerto42"."CONTRAT_PREVOYANCE"."ID";


--
-- TOC entry 750 (class 1259 OID 36393557)
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CONTRAT_PREVOYANCE_RUBRIQUE" (
    "ID" integer NOT NULL,
    "ID_RUBRIQUE_COTISATION" integer DEFAULT 1,
    "ID_CONTRAT_PREVOYANCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."CONTRAT_PREVOYANCE_RUBRIQUE" OWNER TO openconcerto;

--
-- TOC entry 751 (class 1259 OID 36393564)
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CONTRAT_PREVOYANCE_RUBRIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CONTRAT_PREVOYANCE_RUBRIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21649 (class 0 OID 0)
-- Dependencies: 751
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CONTRAT_PREVOYANCE_RUBRIQUE_ID_seq" OWNED BY "OpenConcerto42"."CONTRAT_PREVOYANCE_RUBRIQUE"."ID";


--
-- TOC entry 752 (class 1259 OID 36393566)
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE_NET; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CONTRAT_PREVOYANCE_RUBRIQUE_NET" (
    "ID" integer NOT NULL,
    "ID_RUBRIQUE_NET" integer DEFAULT 1,
    "ID_CONTRAT_PREVOYANCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."CONTRAT_PREVOYANCE_RUBRIQUE_NET" OWNER TO openconcerto;

--
-- TOC entry 753 (class 1259 OID 36393573)
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE_NET_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CONTRAT_PREVOYANCE_RUBRIQUE_NET_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CONTRAT_PREVOYANCE_RUBRIQUE_NET_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21650 (class 0 OID 0)
-- Dependencies: 753
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE_NET_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CONTRAT_PREVOYANCE_RUBRIQUE_NET_ID_seq" OWNED BY "OpenConcerto42"."CONTRAT_PREVOYANCE_RUBRIQUE_NET"."ID";


--
-- TOC entry 754 (class 1259 OID 36393575)
-- Name: CONTRAT_SALARIE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CONTRAT_SALARIE" (
    "ID_CODE_STATUT_CATEGORIEL" integer DEFAULT 1,
    "ID_CODE_DROIT_CONTRAT" integer DEFAULT 1,
    "ID_CODE_STATUT_PROF" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_CODE_CARACT_ACTIVITE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_CODE_CONTRAT_TRAVAIL" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NATURE" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "ID_CODE_EMPLOI" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "CODE_IRC_UGRR" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_UGRR" character varying(64) DEFAULT ''::character varying NOT NULL,
    "CODE_IRC_UGRC" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_UGRC" character varying(64) DEFAULT ''::character varying NOT NULL,
    "CODE_IRC_RETRAITE" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_RETRAITE" character varying(64) DEFAULT ''::character varying NOT NULL,
    "ID_CODE_STATUT_CAT_CONV" integer DEFAULT 1,
    "NUMERO" character varying(128) DEFAULT '00000'::character varying NOT NULL,
    "CODE_REGIME_RETRAITE_DSN" character varying(128) DEFAULT '00000'::character varying NOT NULL,
    "DATE_PREV_FIN" timestamp without time zone,
    "ID_CONTRAT_MODALITE_TEMPS" integer DEFAULT 1,
    "ID_CONTRAT_REGIME_MALADIE" integer DEFAULT 1,
    "ID_CONTRAT_REGIME_VIEILLESSE" integer DEFAULT 1,
    "ID_CONTRAT_MOTIF_RECOURS" integer DEFAULT 1,
    "ID_CONTRAT_DETACHE_EXPATRIE" integer DEFAULT 1,
    "ID_CONTRAT_DISPOSITIF_POLITIQUE" integer DEFAULT 1,
    "DATE_DEBUT" timestamp without time zone,
    "DATE_MODIFICATION" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."CONTRAT_SALARIE" OWNER TO openconcerto;

--
-- TOC entry 755 (class 1259 OID 36393606)
-- Name: CONTRAT_SALARIE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CONTRAT_SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CONTRAT_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21651 (class 0 OID 0)
-- Dependencies: 755
-- Name: CONTRAT_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CONTRAT_SALARIE_ID_seq" OWNED BY "OpenConcerto42"."CONTRAT_SALARIE"."ID";


--
-- TOC entry 756 (class 1259 OID 36393608)
-- Name: COURRIER_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."COURRIER_CLIENT" (
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(256) DEFAULT ''::character varying,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID_CLIENT" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ID_ADRESSE" integer DEFAULT 1,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "DATE" date,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_MODELE_COURRIER_CLIENT" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer
);


ALTER TABLE "OpenConcerto42"."COURRIER_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 757 (class 1259 OID 36393622)
-- Name: COURRIER_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."COURRIER_CLIENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COURRIER_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21652 (class 0 OID 0)
-- Dependencies: 757
-- Name: COURRIER_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."COURRIER_CLIENT_ID_seq" OWNED BY "OpenConcerto42"."COURRIER_CLIENT"."ID";


--
-- TOC entry 1310 (class 1259 OID 36415779)
-- Name: COUT_REVIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."COUT_REVIENT" (
    "ID" integer NOT NULL,
    "CODE" character varying(48) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "POURCENT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."COUT_REVIENT" OWNER TO openconcerto;

--
-- TOC entry 1309 (class 1259 OID 36415777)
-- Name: COUT_REVIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."COUT_REVIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."COUT_REVIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21653 (class 0 OID 0)
-- Dependencies: 1309
-- Name: COUT_REVIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."COUT_REVIENT_ID_seq" OWNED BY "OpenConcerto42"."COUT_REVIENT"."ID";


--
-- TOC entry 758 (class 1259 OID 36393624)
-- Name: CUMULS_CONGES; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CUMULS_CONGES" (
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "RESTANT" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ACQUIS" real DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto42"."CUMULS_CONGES" OWNER TO openconcerto;

--
-- TOC entry 759 (class 1259 OID 36393632)
-- Name: CUMULS_CONGES_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CUMULS_CONGES_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CUMULS_CONGES_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21654 (class 0 OID 0)
-- Dependencies: 759
-- Name: CUMULS_CONGES_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CUMULS_CONGES_ID_seq" OWNED BY "OpenConcerto42"."CUMULS_CONGES"."ID";


--
-- TOC entry 760 (class 1259 OID 36393634)
-- Name: CUMULS_PAYE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."CUMULS_PAYE" (
    "NET_IMP_C" numeric(16,2) DEFAULT 0,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "COT_PAT_C" numeric(16,2) DEFAULT 0,
    "COT_SAL_C" numeric(16,2) DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "SAL_BRUT_C" numeric(16,2) DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NET_A_PAYER_C" numeric(16,2) DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "CSG_C" numeric(16,2) DEFAULT 0,
    "HEURE_TRAV_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "TAXE_CM_SAL_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "TAXE_CM_PAT_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "SAL_BRUT_COTISABLE_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "SAL_BRUT_TAXABLE_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "SAL_BASE_BRUT_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "ALLEGEMENT_COTISATION_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "CICE_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "AVANTAGE_NATURE_C" numeric(16,2) DEFAULT 0 NOT NULL
);


ALTER TABLE "OpenConcerto42"."CUMULS_PAYE" OWNER TO openconcerto;

--
-- TOC entry 761 (class 1259 OID 36393655)
-- Name: CUMULS_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."CUMULS_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."CUMULS_PAYE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21655 (class 0 OID 0)
-- Dependencies: 761
-- Name: CUMULS_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."CUMULS_PAYE_ID_seq" OWNED BY "OpenConcerto42"."CUMULS_PAYE"."ID";


--
-- TOC entry 762 (class 1259 OID 36393657)
-- Name: DECLARATION_DSN; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."DECLARATION_DSN" (
    "ID" integer NOT NULL,
    "ID_DSN_NATURE" integer DEFAULT 1,
    "DATE" timestamp without time zone,
    "DATE_ENVOI" timestamp without time zone,
    "TEST" boolean DEFAULT false NOT NULL,
    "ENVOYE" boolean DEFAULT false NOT NULL,
    "COMMENTAIRE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "DSN_FILE" character varying(75000) DEFAULT ''::character varying NOT NULL,
    "NUMERO" integer DEFAULT 1 NOT NULL,
    "ANNEE" integer DEFAULT 2016 NOT NULL,
    "ID_MOIS" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_ARRET_TRAVAIL" integer DEFAULT 1,
    "ID_REPRISE_TRAVAIL" integer DEFAULT 1,
    "ID_MOIS_REGUL" integer DEFAULT 1,
    "ANNULE_REMPLACE" boolean DEFAULT false NOT NULL,
    "ID_FIN_CONTRAT" integer DEFAULT 1,
    "NUMERO_REFERENCE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_DECLARATION_DSN_ANNULATION" integer DEFAULT 1,
    "EFFECTIF_CVAE" integer,
    "CODE_INSEE_CVAE" character varying(32) DEFAULT ''::character varying NOT NULL,
    "PERIODE_CVAE_DEBUT" date,
    "PERIODE_CVAE_FIN" date
);


ALTER TABLE "OpenConcerto42"."DECLARATION_DSN" OWNER TO openconcerto;

--
-- TOC entry 763 (class 1259 OID 36393681)
-- Name: DECLARATION_DSN_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."DECLARATION_DSN_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."DECLARATION_DSN_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21656 (class 0 OID 0)
-- Dependencies: 763
-- Name: DECLARATION_DSN_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."DECLARATION_DSN_ID_seq" OWNED BY "OpenConcerto42"."DECLARATION_DSN"."ID";


--
-- TOC entry 764 (class 1259 OID 36393683)
-- Name: DEMANDE_ACHAT_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."DEMANDE_ACHAT_ELEMENT" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "QTE" integer DEFAULT 1 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1 NOT NULL,
    "REPERE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "REFERENCE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_FABRICANT" integer DEFAULT 1,
    "DATE" date,
    "ID_ETAT_DEMANDE_ACHAT_ELEMENT" integer DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "EN_STOCK" boolean DEFAULT false NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8),
    "REPERE_SOURCE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "CODE_SOURCE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "NOM_SOURCE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "NUMERO_SE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "DESCRIPTIF_SE" character varying(512) DEFAULT ''::character varying NOT NULL,
    "REVISION" character varying(48) DEFAULT ''::character varying NOT NULL,
    "P_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_COMMANDE" integer DEFAULT 1,
    "ID_BON_RECEPTION" integer DEFAULT 1,
    "QTE_RECUE" integer DEFAULT 0 NOT NULL,
    "REPRISE" boolean DEFAULT false NOT NULL,
    "IMPORT" boolean DEFAULT false NOT NULL
);


ALTER TABLE "OpenConcerto42"."DEMANDE_ACHAT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 765 (class 1259 OID 36393716)
-- Name: DEMANDE_ACHAT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."DEMANDE_ACHAT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."DEMANDE_ACHAT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21657 (class 0 OID 0)
-- Dependencies: 765
-- Name: DEMANDE_ACHAT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."DEMANDE_ACHAT_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."DEMANDE_ACHAT_ELEMENT"."ID";


--
-- TOC entry 766 (class 1259 OID 36393718)
-- Name: DEMANDE_PRIX; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."DEMANDE_PRIX" (
    "ID" integer NOT NULL,
    "NUMERO" character varying(256) DEFAULT ''::character varying NOT NULL,
    "OBJET" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "DATE" date,
    "DATE_BUTOIRE" date,
    "T_HT" bigint DEFAULT 0,
    "T_TVA" bigint DEFAULT 0,
    "T_TTC" bigint DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ID_ETAT_DEMANDE_PRIX" integer DEFAULT 1,
    "INFOS" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."DEMANDE_PRIX" OWNER TO openconcerto;

--
-- TOC entry 767 (class 1259 OID 36393734)
-- Name: DEMANDE_PRIX_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."DEMANDE_PRIX_ELEMENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ID_DEMANDE_PRIX" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 2,
    "QTE" integer DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PA_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_POIDS" real DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 5,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_STYLE" integer DEFAULT 1,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "QTE_ACHAT" integer DEFAULT 1 NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "SERVICE" boolean DEFAULT false,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "POIDS" real DEFAULT 0,
    "PA_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "PA_DEVISE_T" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1 NOT NULL,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0 NOT NULL,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_DEMANDE_ACHAT_ELEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8),
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."DEMANDE_PRIX_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 768 (class 1259 OID 36393783)
-- Name: DEMANDE_PRIX_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."DEMANDE_PRIX_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."DEMANDE_PRIX_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21658 (class 0 OID 0)
-- Dependencies: 768
-- Name: DEMANDE_PRIX_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."DEMANDE_PRIX_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."DEMANDE_PRIX_ELEMENT"."ID";


--
-- TOC entry 769 (class 1259 OID 36393785)
-- Name: DEMANDE_PRIX_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."DEMANDE_PRIX_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."DEMANDE_PRIX_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21659 (class 0 OID 0)
-- Dependencies: 769
-- Name: DEMANDE_PRIX_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."DEMANDE_PRIX_ID_seq" OWNED BY "OpenConcerto42"."DEMANDE_PRIX"."ID";


--
-- TOC entry 770 (class 1259 OID 36393787)
-- Name: DEPARTEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."DEPARTEMENT" (
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "NUMERO" character varying(10) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "CHEF_LIEU" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "REGION_ADMIN" character varying(100) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."DEPARTEMENT" OWNER TO openconcerto;

--
-- TOC entry 771 (class 1259 OID 36393797)
-- Name: DEPARTEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."DEPARTEMENT_ID_seq"
    START WITH 102
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."DEPARTEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21660 (class 0 OID 0)
-- Dependencies: 771
-- Name: DEPARTEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."DEPARTEMENT_ID_seq" OWNED BY "OpenConcerto42"."DEPARTEMENT"."ID";


--
-- TOC entry 1306 (class 1259 OID 36415669)
-- Name: DEPOT_CHEQUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."DEPOT_CHEQUE" (
    "ID" integer NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "MONTANT" bigint DEFAULT 0 NOT NULL,
    "DATE" date,
    "ID_BANQUE" integer DEFAULT 1,
    "ID_ECRITURE" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."DEPOT_CHEQUE" OWNER TO openconcerto;

--
-- TOC entry 1308 (class 1259 OID 36415706)
-- Name: DEPOT_CHEQUE_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."DEPOT_CHEQUE_ELEMENT" (
    "ID" integer NOT NULL,
    "NUMERO" character varying(128) DEFAULT ''::character varying NOT NULL,
    "BANQUE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "PIECE" character varying(512) DEFAULT ''::character varying NOT NULL,
    "MONTANT" bigint DEFAULT 0 NOT NULL,
    "DATE" date,
    "ID_CHEQUE_A_ENCAISSER" integer DEFAULT 1,
    "ID_ECRITURE" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_DEPOT_CHEQUE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8),
    "TIERS" character varying(256) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."DEPOT_CHEQUE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1307 (class 1259 OID 36415704)
-- Name: DEPOT_CHEQUE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."DEPOT_CHEQUE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."DEPOT_CHEQUE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21661 (class 0 OID 0)
-- Dependencies: 1307
-- Name: DEPOT_CHEQUE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."DEPOT_CHEQUE_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."DEPOT_CHEQUE_ELEMENT"."ID";


--
-- TOC entry 1305 (class 1259 OID 36415667)
-- Name: DEPOT_CHEQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."DEPOT_CHEQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."DEPOT_CHEQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21662 (class 0 OID 0)
-- Dependencies: 1305
-- Name: DEPOT_CHEQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."DEPOT_CHEQUE_ID_seq" OWNED BY "OpenConcerto42"."DEPOT_CHEQUE"."ID";


--
-- TOC entry 1324 (class 1259 OID 36416377)
-- Name: DEPOT_STOCK; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."DEPOT_STOCK" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "UI_LOCK" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_USER_UI_LOCK" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."DEPOT_STOCK" OWNER TO openconcerto;

--
-- TOC entry 1323 (class 1259 OID 36416375)
-- Name: DEPOT_STOCK_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."DEPOT_STOCK_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."DEPOT_STOCK_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21663 (class 0 OID 0)
-- Dependencies: 1323
-- Name: DEPOT_STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."DEPOT_STOCK_ID_seq" OWNED BY "OpenConcerto42"."DEPOT_STOCK"."ID";


--
-- TOC entry 772 (class 1259 OID 36393799)
-- Name: DEVIS; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."DEVIS" (
    "REMISE_HT" bigint DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_DEVIS" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "T_TTC" bigint DEFAULT 0,
    "T_HT" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "DATE" date,
    "DATE_ENVOI" timestamp without time zone,
    "ID_ETAT_DEVIS" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "T_SERVICE" bigint DEFAULT 0,
    "PORT_HT" bigint DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer,
    "ORDRE" numeric(16,8),
    "T_TVA" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "OBJET" character varying(100) DEFAULT ''::character varying,
    "T_POIDS" real DEFAULT 0,
    "ID_ADRESSE" integer DEFAULT 1 NOT NULL,
    "DATE_VALIDITE" date,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "ID_ADRESSE_LIVRAISON" integer DEFAULT 1,
    "POURCENT_REMISE" numeric(12,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_CONTACT" integer DEFAULT 1,
    "ID_CLIENT_DEPARTEMENT" integer DEFAULT 1,
    "T_HA" bigint DEFAULT 0 NOT NULL,
    "DUNNING_DATE" date,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "T_ACOMPTE" bigint DEFAULT 0 NOT NULL,
    "FRAIS_DOCUMENT_HT" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE_FRAIS_DOCUMENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."DEVIS" OWNER TO openconcerto;

--
-- TOC entry 773 (class 1259 OID 36393830)
-- Name: DEVISE_HISTORIQUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."DEVISE_HISTORIQUE" (
    "ID" integer NOT NULL,
    "DATE" timestamp without time zone,
    "SRC" character varying(8) DEFAULT ''::character varying NOT NULL,
    "DST" character varying(8) DEFAULT ''::character varying NOT NULL,
    "TAUX" numeric(12,6) DEFAULT 1 NOT NULL,
    "TAUX_COMMERCIAL" numeric(12,6) DEFAULT 1 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."DEVISE_HISTORIQUE" OWNER TO openconcerto;

--
-- TOC entry 774 (class 1259 OID 36393839)
-- Name: DEVISE_HISTORIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."DEVISE_HISTORIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."DEVISE_HISTORIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21664 (class 0 OID 0)
-- Dependencies: 774
-- Name: DEVISE_HISTORIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."DEVISE_HISTORIQUE_ID_seq" OWNED BY "OpenConcerto42"."DEVISE_HISTORIQUE"."ID";


--
-- TOC entry 775 (class 1259 OID 36393841)
-- Name: DEVIS_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."DEVIS_ELEMENT" (
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(45) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_DEVIS" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_DEVIS_ELEMENT" integer NOT NULL,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_STYLE" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_POIDS" real DEFAULT 0,
    "ORDRE" numeric(16,8),
    "SERVICE" boolean DEFAULT false,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "QTE" integer DEFAULT 1,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "POURCENT_REMISE" numeric(12,8) DEFAULT 0,
    "PV_T_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "T_POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "NB_COLIS" integer DEFAULT 0,
    "MONTANT_REMISE" numeric(16,8),
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_DEPOT_STOCK" integer DEFAULT 1,
    "LIVRE_FORCED" boolean DEFAULT false NOT NULL,
    "LIVRE" boolean DEFAULT false NOT NULL,
    "QTE_LIVREE" numeric(16,6) DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."DEVIS_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 776 (class 1259 OID 36393898)
-- Name: DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq" OWNER TO openconcerto;

--
-- TOC entry 21665 (class 0 OID 0)
-- Dependencies: 776
-- Name: DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq" OWNED BY "OpenConcerto42"."DEVIS_ELEMENT"."ID_DEVIS_ELEMENT";


--
-- TOC entry 777 (class 1259 OID 36393900)
-- Name: DEVIS_ID_DEVIS_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."DEVIS_ID_DEVIS_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."DEVIS_ID_DEVIS_seq" OWNER TO openconcerto;

--
-- TOC entry 21666 (class 0 OID 0)
-- Dependencies: 777
-- Name: DEVIS_ID_DEVIS_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."DEVIS_ID_DEVIS_seq" OWNED BY "OpenConcerto42"."DEVIS"."ID_DEVIS";


--
-- TOC entry 778 (class 1259 OID 36393902)
-- Name: ECHANTILLON_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ECHANTILLON_ELEMENT" (
    "ID_TAXE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "T_PV_TTC" bigint DEFAULT 0,
    "PV_HT" bigint DEFAULT 0,
    "QTE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "T_PV_HT" bigint DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."ECHANTILLON_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 779 (class 1259 OID 36393916)
-- Name: ECHANTILLON_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ECHANTILLON_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ECHANTILLON_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21667 (class 0 OID 0)
-- Dependencies: 779
-- Name: ECHANTILLON_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ECHANTILLON_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."ECHANTILLON_ELEMENT"."ID";


--
-- TOC entry 780 (class 1259 OID 36393918)
-- Name: ECHEANCE_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ECHEANCE_CLIENT" (
    "REGLE" boolean DEFAULT false,
    "DATE" date,
    "NOMBRE_RELANCE" integer DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "REG_COMPTA" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "RETOUR_NATEXIS" boolean DEFAULT false,
    "MONTANT" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "DATE_LAST_RELANCE" date,
    "ID" integer NOT NULL,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "TIERS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_COMPTE_PCE_TIERS" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."ECHEANCE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 781 (class 1259 OID 36393934)
-- Name: ECHEANCE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ECHEANCE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ECHEANCE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21668 (class 0 OID 0)
-- Dependencies: 781
-- Name: ECHEANCE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ECHEANCE_CLIENT_ID_seq" OWNED BY "OpenConcerto42"."ECHEANCE_CLIENT"."ID";


--
-- TOC entry 782 (class 1259 OID 36393936)
-- Name: ECHEANCE_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ECHEANCE_FOURNISSEUR" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0,
    "REGLE" boolean DEFAULT false,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "DATE" date,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "REG_COMPTA" boolean DEFAULT false
);


ALTER TABLE "OpenConcerto42"."ECHEANCE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 783 (class 1259 OID 36393947)
-- Name: ECHEANCE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ECHEANCE_FOURNISSEUR_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ECHEANCE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21669 (class 0 OID 0)
-- Dependencies: 783
-- Name: ECHEANCE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ECHEANCE_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto42"."ECHEANCE_FOURNISSEUR"."ID";


--
-- TOC entry 784 (class 1259 OID 36393949)
-- Name: ECRITURE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ECRITURE" (
    "DATE_POINTEE" date,
    "ID" integer NOT NULL,
    "DATE" date,
    "DEBIT" bigint DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREDIT" bigint DEFAULT 0,
    "DATE_VALIDE" date,
    "JOURNAL_CODE" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "ID_JOURNAL" integer DEFAULT 1,
    "IDUSER_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer,
    "DATE_LETTRAGE" date,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "LETTRAGE" character varying(256) DEFAULT ''::character varying,
    "COMPTE_NOM" character varying(2048) DEFAULT ''::text,
    "JOURNAL_NOM" character varying(2048) DEFAULT ''::text,
    "IDUSER_VALIDE" integer DEFAULT 1,
    "VALIDE" boolean DEFAULT false,
    "CREATION_DATE" timestamp without time zone,
    "POINTEE" character varying(45) DEFAULT ''::character varying,
    "COMPTE_NUMERO" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "IDUSER_DELETE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "DATE_EXPORT" date,
    "CODE_CLIENT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM_PIECE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "CLOTURE" boolean DEFAULT false NOT NULL,
    "RAN" boolean DEFAULT false NOT NULL,
    "DATE_ECHEANCE" date
);


ALTER TABLE "OpenConcerto42"."ECRITURE" OWNER TO openconcerto;

--
-- TOC entry 785 (class 1259 OID 36393976)
-- Name: ECRITURE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ECRITURE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ECRITURE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21670 (class 0 OID 0)
-- Dependencies: 785
-- Name: ECRITURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ECRITURE_ID_seq" OWNED BY "OpenConcerto42"."ECRITURE"."ID";


--
-- TOC entry 786 (class 1259 OID 36393978)
-- Name: EMPLOYEUR_MULTIPLE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."EMPLOYEUR_MULTIPLE" (
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."EMPLOYEUR_MULTIPLE" OWNER TO openconcerto;

--
-- TOC entry 787 (class 1259 OID 36393985)
-- Name: EMPLOYEUR_MULTIPLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."EMPLOYEUR_MULTIPLE_ID_seq"
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."EMPLOYEUR_MULTIPLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21671 (class 0 OID 0)
-- Dependencies: 787
-- Name: EMPLOYEUR_MULTIPLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."EMPLOYEUR_MULTIPLE_ID_seq" OWNED BY "OpenConcerto42"."EMPLOYEUR_MULTIPLE"."ID";


--
-- TOC entry 788 (class 1259 OID 36393987)
-- Name: ENCAISSER_MONTANT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ENCAISSER_MONTANT" (
    "ID_MOUVEMENT" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "NOM" character varying(200),
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "DATE" date,
    "ID_ECHEANCE_CLIENT" integer DEFAULT 1,
    "ID_TICKET_CAISSE" integer DEFAULT 1,
    "ACOMPTE" boolean DEFAULT false NOT NULL,
    "ID_DEVIS" integer DEFAULT 1,
    "TIERS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_COMPTE_PCE_TIERS" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."ENCAISSER_MONTANT" OWNER TO openconcerto;

--
-- TOC entry 789 (class 1259 OID 36394001)
-- Name: ENCAISSER_MONTANT_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ENCAISSER_MONTANT_ELEMENT" (
    "ORDRE" numeric(16,8) DEFAULT 0,
    "MONTANT_REGLE" bigint DEFAULT 0,
    "DATE" date,
    "ID" integer NOT NULL,
    "ID_ECHEANCE_CLIENT" integer DEFAULT 1,
    "ID_ENCAISSER_MONTANT" integer DEFAULT 1,
    "ID_MOUVEMENT_ECHEANCE" integer DEFAULT 1,
    "MONTANT_A_REGLER" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."ENCAISSER_MONTANT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 790 (class 1259 OID 36394011)
-- Name: ENCAISSER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ENCAISSER_MONTANT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ENCAISSER_MONTANT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21672 (class 0 OID 0)
-- Dependencies: 790
-- Name: ENCAISSER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ENCAISSER_MONTANT_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."ENCAISSER_MONTANT_ELEMENT"."ID";


--
-- TOC entry 791 (class 1259 OID 36394013)
-- Name: ENCAISSER_MONTANT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ENCAISSER_MONTANT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ENCAISSER_MONTANT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21673 (class 0 OID 0)
-- Dependencies: 791
-- Name: ENCAISSER_MONTANT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ENCAISSER_MONTANT_ID_seq" OWNED BY "OpenConcerto42"."ENCAISSER_MONTANT"."ID";


--
-- TOC entry 792 (class 1259 OID 36394015)
-- Name: ETAT_CIVIL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ETAT_CIVIL" (
    "ARCHIVE" integer DEFAULT 0,
    "NB_PERS_A_CHARGE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "NB_ENFANTS" integer DEFAULT 0,
    "TELEPHONE" character varying(45) DEFAULT ''::character varying,
    "DATE_NAISSANCE" date,
    "ID_ADRESSE" integer DEFAULT 1,
    "COMMUNE_NAISSANCE" character varying(45) DEFAULT ''::character varying,
    "ID_SITUATION_FAMILIALE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_PAYS_NAISSANCE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "PORTABLE" character varying(45) DEFAULT ''::character varying,
    "MAIL" character varying(45) DEFAULT ''::character varying,
    "ID_DEPARTEMENT_NAISSANCE" integer DEFAULT 1,
    "NUMERO_SS" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "NATIONNALITE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CNPS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TYPE_PIECE_IDENTITE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NUMERO_PIECE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM_PERE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM_MERE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CONJOINT_NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CONJOINT_DATE_NAISSANCE" date,
    "CONJOINT_LIEU_NAISSANCE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CONJOINT_PROFESSION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DATE_DEBUT_PIECE" date,
    "DATE_FIN_PIECE" date,
    "NTT" character varying(50) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."ETAT_CIVIL" OWNER TO openconcerto;

--
-- TOC entry 793 (class 1259 OID 36394044)
-- Name: ETAT_CIVIL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ETAT_CIVIL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ETAT_CIVIL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21674 (class 0 OID 0)
-- Dependencies: 793
-- Name: ETAT_CIVIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ETAT_CIVIL_ID_seq" OWNED BY "OpenConcerto42"."ETAT_CIVIL"."ID";


--
-- TOC entry 794 (class 1259 OID 36394046)
-- Name: ETAT_DEMANDE_ACHAT_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ETAT_DEMANDE_ACHAT_ELEMENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "COLOR" integer,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."ETAT_DEMANDE_ACHAT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 795 (class 1259 OID 36394051)
-- Name: ETAT_DEMANDE_ACHAT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ETAT_DEMANDE_ACHAT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ETAT_DEMANDE_ACHAT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21675 (class 0 OID 0)
-- Dependencies: 795
-- Name: ETAT_DEMANDE_ACHAT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ETAT_DEMANDE_ACHAT_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."ETAT_DEMANDE_ACHAT_ELEMENT"."ID";


--
-- TOC entry 796 (class 1259 OID 36394053)
-- Name: ETAT_DEMANDE_PRIX; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ETAT_DEMANDE_PRIX" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."ETAT_DEMANDE_PRIX" OWNER TO openconcerto;

--
-- TOC entry 797 (class 1259 OID 36394058)
-- Name: ETAT_DEMANDE_PRIX_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ETAT_DEMANDE_PRIX_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ETAT_DEMANDE_PRIX_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21676 (class 0 OID 0)
-- Dependencies: 797
-- Name: ETAT_DEMANDE_PRIX_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ETAT_DEMANDE_PRIX_ID_seq" OWNED BY "OpenConcerto42"."ETAT_DEMANDE_PRIX"."ID";


--
-- TOC entry 798 (class 1259 OID 36394060)
-- Name: ETAT_DEVIS; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ETAT_DEVIS" (
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto42"."ETAT_DEVIS" OWNER TO openconcerto;

--
-- TOC entry 799 (class 1259 OID 36394068)
-- Name: ETAT_DEVIS_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ETAT_DEVIS_ID_seq"
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ETAT_DEVIS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21677 (class 0 OID 0)
-- Dependencies: 799
-- Name: ETAT_DEVIS_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ETAT_DEVIS_ID_seq" OWNED BY "OpenConcerto42"."ETAT_DEVIS"."ID";


--
-- TOC entry 800 (class 1259 OID 36394070)
-- Name: ETAT_RAPPORT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ETAT_RAPPORT" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(2048),
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."ETAT_RAPPORT" OWNER TO openconcerto;

--
-- TOC entry 801 (class 1259 OID 36394080)
-- Name: ETAT_RAPPORT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ETAT_RAPPORT_ID_seq"
    START WITH 3
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ETAT_RAPPORT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21678 (class 0 OID 0)
-- Dependencies: 801
-- Name: ETAT_RAPPORT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ETAT_RAPPORT_ID_seq" OWNED BY "OpenConcerto42"."ETAT_RAPPORT"."ID";


--
-- TOC entry 1302 (class 1259 OID 36415603)
-- Name: ETAT_STOCK; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ETAT_STOCK" (
    "ID" integer NOT NULL,
    "DATE" date,
    "MONTANT_HA" numeric(16,8) DEFAULT 0,
    "MONTANT_VT" numeric(16,8) DEFAULT 0,
    "INVENTAIRE" boolean DEFAULT false NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."ETAT_STOCK" OWNER TO openconcerto;

--
-- TOC entry 1304 (class 1259 OID 36415617)
-- Name: ETAT_STOCK_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."ETAT_STOCK_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_ETAT_STOCK" integer DEFAULT 1,
    "PA" numeric(16,8) DEFAULT 0,
    "PV" numeric(16,8) DEFAULT 0,
    "T_PA" numeric(16,8) DEFAULT 0,
    "T_PV" numeric(16,8) DEFAULT 0,
    "QTE" numeric(16,8) DEFAULT 0,
    "ECART" numeric(16,8) DEFAULT 0,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."ETAT_STOCK_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1303 (class 1259 OID 36415615)
-- Name: ETAT_STOCK_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ETAT_STOCK_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ETAT_STOCK_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21679 (class 0 OID 0)
-- Dependencies: 1303
-- Name: ETAT_STOCK_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ETAT_STOCK_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."ETAT_STOCK_ELEMENT"."ID";


--
-- TOC entry 1301 (class 1259 OID 36415601)
-- Name: ETAT_STOCK_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."ETAT_STOCK_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."ETAT_STOCK_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21680 (class 0 OID 0)
-- Dependencies: 1301
-- Name: ETAT_STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."ETAT_STOCK_ID_seq" OWNED BY "OpenConcerto42"."ETAT_STOCK"."ID";


--
-- TOC entry 802 (class 1259 OID 36394082)
-- Name: FABRICANT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."FABRICANT" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."FABRICANT" OWNER TO openconcerto;

--
-- TOC entry 803 (class 1259 OID 36394087)
-- Name: FABRICANT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."FABRICANT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."FABRICANT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21681 (class 0 OID 0)
-- Dependencies: 803
-- Name: FABRICANT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."FABRICANT_ID_seq" OWNED BY "OpenConcerto42"."FABRICANT"."ID";


--
-- TOC entry 804 (class 1259 OID 36394089)
-- Name: FACTURATION_COMMANDE_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."FACTURATION_COMMANDE_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TYPE_FACTURE" integer DEFAULT 1 NOT NULL,
    "CHOICE" boolean DEFAULT false NOT NULL,
    "ID_TYPE_REGLEMENT" integer DEFAULT 1,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "AJOURS" integer DEFAULT 0 NOT NULL,
    "MONTANT" numeric(16,8) DEFAULT 0 NOT NULL,
    "POURCENT" numeric(16,8) DEFAULT 0 NOT NULL,
    "COMPTANT" boolean DEFAULT false NOT NULL,
    "DATE_PREVISIONNELLE" date,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8),
    "FIN_MOIS" boolean DEFAULT false NOT NULL,
    "LENJOUR" integer DEFAULT 0 NOT NULL
);


ALTER TABLE "OpenConcerto42"."FACTURATION_COMMANDE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 805 (class 1259 OID 36394106)
-- Name: FACTURATION_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."FACTURATION_COMMANDE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."FACTURATION_COMMANDE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21682 (class 0 OID 0)
-- Dependencies: 805
-- Name: FACTURATION_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."FACTURATION_COMMANDE_CLIENT_ID_seq" OWNED BY "OpenConcerto42"."FACTURATION_COMMANDE_CLIENT"."ID";


--
-- TOC entry 806 (class 1259 OID 36394108)
-- Name: FACTURE_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."FACTURE_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NUMERO" character varying(45) DEFAULT ''::character varying NOT NULL,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "DATE" date,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_AVOIR_FOURNISSEUR" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "T_HT" bigint DEFAULT 0,
    "T_TVA" bigint DEFAULT 0,
    "T_TTC" bigint DEFAULT 0,
    "T_SERVICE" bigint DEFAULT 0,
    "T_DEVISE" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "TAUX_APPLIQUE" numeric(12,6) DEFAULT 1,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "PORT_HT" bigint DEFAULT 0 NOT NULL,
    "REMISE_HT" bigint DEFAULT 0 NOT NULL,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "NET_A_PAYER" bigint DEFAULT 0 NOT NULL,
    "AVOIR_TTC" bigint DEFAULT 0 NOT NULL
);


ALTER TABLE "OpenConcerto42"."FACTURE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 807 (class 1259 OID 36394138)
-- Name: FACTURE_FOURNISSEUR_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."FACTURE_FOURNISSEUR_ELEMENT" (
    "ID" integer NOT NULL,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_TTC" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PA_TTC" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 0 NOT NULL,
    "PA_DEVISE_T" numeric(16,6) DEFAULT 0 NOT NULL,
    "PA_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE" integer DEFAULT 1 NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1 NOT NULL,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "POIDS" real DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "CODE" character varying(45) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DATE" date,
    "ID_STYLE" integer DEFAULT 1,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ID_FACTURE_FOURNISSEUR" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 5,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_CODE_FOURNISSEUR" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_DEMANDE_ACHAT_ELEMENT" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."FACTURE_FOURNISSEUR_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 808 (class 1259 OID 36394189)
-- Name: FACTURE_FOURNISSEUR_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."FACTURE_FOURNISSEUR_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."FACTURE_FOURNISSEUR_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21683 (class 0 OID 0)
-- Dependencies: 808
-- Name: FACTURE_FOURNISSEUR_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."FACTURE_FOURNISSEUR_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."FACTURE_FOURNISSEUR_ELEMENT"."ID";


--
-- TOC entry 809 (class 1259 OID 36394191)
-- Name: FACTURE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."FACTURE_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."FACTURE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21684 (class 0 OID 0)
-- Dependencies: 809
-- Name: FACTURE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."FACTURE_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto42"."FACTURE_FOURNISSEUR"."ID";


--
-- TOC entry 810 (class 1259 OID 36394193)
-- Name: FAMILLE_ARTICLE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."FAMILLE_ARTICLE" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ID_FAMILLE_ARTICLE_PERE" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."FAMILLE_ARTICLE" OWNER TO openconcerto;

--
-- TOC entry 811 (class 1259 OID 36394204)
-- Name: FAMILLE_ARTICLE_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."FAMILLE_ARTICLE_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ID_FAMILLE_ARTICLE_FOURNISSEUR_PERE" integer,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."FAMILLE_ARTICLE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 812 (class 1259 OID 36394214)
-- Name: FAMILLE_ARTICLE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."FAMILLE_ARTICLE_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."FAMILLE_ARTICLE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21685 (class 0 OID 0)
-- Dependencies: 812
-- Name: FAMILLE_ARTICLE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."FAMILLE_ARTICLE_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto42"."FAMILLE_ARTICLE_FOURNISSEUR"."ID";


--
-- TOC entry 813 (class 1259 OID 36394216)
-- Name: FAMILLE_ARTICLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."FAMILLE_ARTICLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."FAMILLE_ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21686 (class 0 OID 0)
-- Dependencies: 813
-- Name: FAMILLE_ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."FAMILLE_ARTICLE_ID_seq" OWNED BY "OpenConcerto42"."FAMILLE_ARTICLE"."ID";


--
-- TOC entry 814 (class 1259 OID 36394218)
-- Name: FICHE_PAYE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."FICHE_PAYE" (
    "ACOMPTE" numeric(16,2) DEFAULT 0,
    "NET_IMP" numeric(16,2) DEFAULT 0,
    "CONGES_ACQUIS" real DEFAULT 0,
    "NATURE_EMPLOI" character varying(150) DEFAULT ''::character varying,
    "ID_CUMULS_PAYE" integer DEFAULT 1,
    "ID_IDCC" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer,
    "DU" date,
    "ORDRE" numeric(16,8),
    "ID_REGLEMENT_PAYE" integer DEFAULT 1,
    "ID_VARIABLE_SALARIE" integer DEFAULT 1,
    "ID_CUMULS_CONGES" integer DEFAULT 1,
    "COT_PAT" numeric(16,2) DEFAULT 0,
    "ANNEE" integer DEFAULT 0,
    "AU" date,
    "CREATION_DATE" timestamp without time zone,
    "NET_A_PAYER" numeric(16,2) DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "SAL_BRUT" numeric(16,2) DEFAULT 0,
    "VALIDE" boolean DEFAULT false,
    "CSG" numeric(16,2) DEFAULT 0,
    "COT_SAL" numeric(16,2) DEFAULT 0,
    "ID_MOIS" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_SALARIE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_PROFIL_PAYE" integer DEFAULT 1,
    "ID_INFOS_SALARIE_PAYE" integer DEFAULT 1,
    "SAL_BASE_BRUT" numeric(16,2) DEFAULT 0 NOT NULL,
    "TAXE_CM_SAL" numeric(16,2) DEFAULT 0 NOT NULL,
    "TAXE_CM_PAT" numeric(16,2) DEFAULT 0 NOT NULL,
    "SAL_BRUT_COTISABLE" numeric(16,2) DEFAULT 0 NOT NULL,
    "SAL_BRUT_TAXABLE" numeric(16,2) DEFAULT 0 NOT NULL,
    "ALLEGEMENT_COTISATION" numeric(16,2) DEFAULT 0 NOT NULL,
    "CICE" numeric(16,2) DEFAULT 0 NOT NULL,
    "AVANTAGE_NATURE" numeric(16,2) DEFAULT 0 NOT NULL,
    "HEURE_TRAV" numeric(16,2) DEFAULT 0 NOT NULL,
    "DETAILS_CONGES" character varying(512) DEFAULT ''::character varying NOT NULL,
    "REDUCTION_GVT" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_PAS" integer DEFAULT 1,
    "TOTAL_PAS" numeric(16,2) DEFAULT 0 NOT NULL,
    "NET_AVANT_PAS" numeric(16,2) DEFAULT 0 NOT NULL
);


ALTER TABLE "OpenConcerto42"."FICHE_PAYE" OWNER TO openconcerto;

--
-- TOC entry 815 (class 1259 OID 36394256)
-- Name: FICHE_PAYE_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."FICHE_PAYE_ELEMENT" (
    "IN_PERIODE" boolean DEFAULT true,
    "ID_FICHE_PAYE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "VALIDE" boolean DEFAULT false,
    "ID" integer NOT NULL,
    "TAUX_PAT" numeric(16,6) DEFAULT 0,
    "IMPRESSION" boolean DEFAULT true,
    "MONTANT_SAL_AJ" numeric(16,2) DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "TAUX_SAL" numeric(16,6) DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MONTANT_SAL_DED" numeric(16,2) DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NB_BASE" numeric(16,6) DEFAULT 0,
    "IDSOURCE" integer DEFAULT 1,
    "POSITION" integer DEFAULT 0,
    "MONTANT_PAT" numeric(16,2) DEFAULT 0,
    "ID_STYLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."FICHE_PAYE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 816 (class 1259 OID 36394280)
-- Name: FICHE_PAYE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."FICHE_PAYE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."FICHE_PAYE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21687 (class 0 OID 0)
-- Dependencies: 816
-- Name: FICHE_PAYE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."FICHE_PAYE_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."FICHE_PAYE_ELEMENT"."ID";


--
-- TOC entry 817 (class 1259 OID 36394282)
-- Name: FICHE_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."FICHE_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."FICHE_PAYE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21688 (class 0 OID 0)
-- Dependencies: 817
-- Name: FICHE_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."FICHE_PAYE_ID_seq" OWNED BY "OpenConcerto42"."FICHE_PAYE"."ID";


--
-- TOC entry 818 (class 1259 OID 36394284)
-- Name: FIN_CONTRAT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."FIN_CONTRAT" (
    "ID" integer NOT NULL,
    "ID_FICHE_PAYE" integer DEFAULT 1,
    "ID_MOTIF_FIN_CONTRAT" integer DEFAULT 1,
    "DATE_FIN" timestamp without time zone,
    "DATE_NOTIFICATION" timestamp without time zone,
    "DATE_SIGNATURE_CONVENTION" timestamp without time zone,
    "DATE_ENGAGEMENT_PROCEDURE" timestamp without time zone,
    "DERNIER_JOUR_TRAV_PAYE" timestamp without time zone,
    "TRANSACTION_EN_COURS" boolean DEFAULT false NOT NULL,
    "PORTABILITE_PREVOYANCE" boolean DEFAULT false NOT NULL,
    "NB_DIF_RESTANT" integer,
    "NB_MOIS_CSP" integer,
    "SALAIRE_NET_HORAIRE" numeric(16,8),
    "INDEMNITE_VERSE" numeric(16,8),
    "ID_TYPE_PREAVIS" integer DEFAULT 1,
    "DATE_DEBUT_PREAVIS" timestamp without time zone,
    "DATE_FIN_PREAVIS" timestamp without time zone,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."FIN_CONTRAT" OWNER TO openconcerto;

--
-- TOC entry 819 (class 1259 OID 36394298)
-- Name: FIN_CONTRAT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."FIN_CONTRAT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."FIN_CONTRAT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21689 (class 0 OID 0)
-- Dependencies: 819
-- Name: FIN_CONTRAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."FIN_CONTRAT_ID_seq" OWNED BY "OpenConcerto42"."FIN_CONTRAT"."ID";


--
-- TOC entry 820 (class 1259 OID 36394300)
-- Name: FOURNISSEUR; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."FOURNISSEUR" (
    "CREATION_DATE" timestamp without time zone,
    "CODE" character varying(2048) DEFAULT ''::text,
    "UE" boolean DEFAULT false,
    "TYPE" character varying(2048) DEFAULT ''::text,
    "TEL" character varying(2048) DEFAULT ''::text,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_ADRESSE_E" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "FAX" character varying(2048) DEFAULT ''::text,
    "ID_FOURNISSEUR" integer NOT NULL,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_CREATE" integer,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_LANGUE" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "RESPONSABLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_P" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ID_COMPTE_PCE_CHARGE" integer DEFAULT 1,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "NUMERO_TVA" character varying(128) DEFAULT ''::character varying NOT NULL,
    "SIRET" character varying(128) DEFAULT ''::character varying NOT NULL,
    "IBAN" character varying(128) DEFAULT ''::character varying NOT NULL,
    "BIC" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_CATEGORIE_COMPTABLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 821 (class 1259 OID 36394329)
-- Name: FOURNISSEUR_ID_FOURNISSEUR_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."FOURNISSEUR_ID_FOURNISSEUR_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."FOURNISSEUR_ID_FOURNISSEUR_seq" OWNER TO openconcerto;

--
-- TOC entry 21690 (class 0 OID 0)
-- Dependencies: 821
-- Name: FOURNISSEUR_ID_FOURNISSEUR_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."FOURNISSEUR_ID_FOURNISSEUR_seq" OWNED BY "OpenConcerto42"."FOURNISSEUR"."ID_FOURNISSEUR";


--
-- TOC entry 1312 (class 1259 OID 36415872)
-- Name: FRAIS_DOCUMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."FRAIS_DOCUMENT" (
    "ID" integer NOT NULL,
    "CODE" character varying(48) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MONTANT_HT" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "MONTANT_TTC" bigint DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."FRAIS_DOCUMENT" OWNER TO openconcerto;

--
-- TOC entry 1311 (class 1259 OID 36415870)
-- Name: FRAIS_DOCUMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."FRAIS_DOCUMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."FRAIS_DOCUMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21691 (class 0 OID 0)
-- Dependencies: 1311
-- Name: FRAIS_DOCUMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."FRAIS_DOCUMENT_ID_seq" OWNED BY "OpenConcerto42"."FRAIS_DOCUMENT"."ID";


--
-- TOC entry 822 (class 1259 OID 36394331)
-- Name: FWK_MODULE_DEP; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."FWK_MODULE_DEP" (
    "ID_MODULE" integer NOT NULL,
    "ID_MODULE_NEEDED" integer NOT NULL
);


ALTER TABLE "OpenConcerto42"."FWK_MODULE_DEP" OWNER TO openconcerto;

--
-- TOC entry 823 (class 1259 OID 36394334)
-- Name: FWK_MODULE_METADATA; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."FWK_MODULE_METADATA" (
    "ID" integer NOT NULL,
    "MODULE_NAME" character varying(128) DEFAULT ''::character varying NOT NULL,
    "TABLE" character varying(128),
    "FIELD" character varying(128),
    "KEY" boolean,
    "MODULE_VERSION" bigint NOT NULL
);


ALTER TABLE "OpenConcerto42"."FWK_MODULE_METADATA" OWNER TO openconcerto;

--
-- TOC entry 824 (class 1259 OID 36394338)
-- Name: FWK_MODULE_METADATA_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."FWK_MODULE_METADATA_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."FWK_MODULE_METADATA_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21692 (class 0 OID 0)
-- Dependencies: 824
-- Name: FWK_MODULE_METADATA_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."FWK_MODULE_METADATA_ID_seq" OWNED BY "OpenConcerto42"."FWK_MODULE_METADATA"."ID";


--
-- TOC entry 825 (class 1259 OID 36394340)
-- Name: FWK_SCHEMA_METADATA; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."FWK_SCHEMA_METADATA" (
    "VALUE" character varying(250) DEFAULT ''::character varying,
    "NAME" character varying(100) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."FWK_SCHEMA_METADATA" OWNER TO openconcerto;

--
-- TOC entry 826 (class 1259 OID 36394345)
-- Name: FWK_UNDEFINED_IDS; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."FWK_UNDEFINED_IDS" (
    "UNDEFINED_ID" integer DEFAULT 0,
    "TABLENAME" character varying(250) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."FWK_UNDEFINED_IDS" OWNER TO openconcerto;

--
-- TOC entry 827 (class 1259 OID 36394350)
-- Name: IDCC; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."IDCC" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto42"."IDCC" OWNER TO openconcerto;

--
-- TOC entry 828 (class 1259 OID 36394361)
-- Name: IDCC_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."IDCC_ID_seq"
    START WITH 996
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."IDCC_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21693 (class 0 OID 0)
-- Dependencies: 828
-- Name: IDCC_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."IDCC_ID_seq" OWNED BY "OpenConcerto42"."IDCC"."ID";


--
-- TOC entry 829 (class 1259 OID 36394363)
-- Name: INFOS_SALARIE_PAYE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."INFOS_SALARIE_PAYE" (
    "DUREE_MOIS" real DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_CLASSEMENT_CONVENTIONNEL" integer DEFAULT 1,
    "DATE_SORTIE" date,
    "SALAIRE_MOIS" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_CONTRAT_SALARIE" integer DEFAULT 1,
    "TAUX_AT" real DEFAULT 0,
    "DATE_ARRIVE" date,
    "DUREE_HEBDO" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "CONGES_PAYES" real DEFAULT 0,
    "ID_IDCC" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "CODE_AT" character varying(18) DEFAULT ''::character varying NOT NULL,
    "CODE_SECTION_AT" character varying(18) DEFAULT ''::character varying NOT NULL,
    "ID_COEFF_PRIME" integer DEFAULT 1,
    "ID_SALARIE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."INFOS_SALARIE_PAYE" OWNER TO openconcerto;

--
-- TOC entry 830 (class 1259 OID 36394381)
-- Name: INFOS_SALARIE_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."INFOS_SALARIE_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."INFOS_SALARIE_PAYE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21694 (class 0 OID 0)
-- Dependencies: 830
-- Name: INFOS_SALARIE_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."INFOS_SALARIE_PAYE_ID_seq" OWNED BY "OpenConcerto42"."INFOS_SALARIE_PAYE"."ID";


--
-- TOC entry 831 (class 1259 OID 36394383)
-- Name: JOURNAL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."JOURNAL" (
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ARCHIVE" integer DEFAULT 0,
    "CODE" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "TYPE_BANQUE" boolean DEFAULT false,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "PAR_DEFAUT" boolean DEFAULT false,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer
);


ALTER TABLE "OpenConcerto42"."JOURNAL" OWNER TO openconcerto;

--
-- TOC entry 832 (class 1259 OID 36394394)
-- Name: JOURNAL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."JOURNAL_ID_seq"
    START WITH 7
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."JOURNAL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21695 (class 0 OID 0)
-- Dependencies: 832
-- Name: JOURNAL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."JOURNAL_ID_seq" OWNED BY "OpenConcerto42"."JOURNAL"."ID";


--
-- TOC entry 833 (class 1259 OID 36394396)
-- Name: LANGUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."LANGUE" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CHEMIN" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."LANGUE" OWNER TO openconcerto;

--
-- TOC entry 834 (class 1259 OID 36394407)
-- Name: LANGUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."LANGUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."LANGUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21696 (class 0 OID 0)
-- Dependencies: 834
-- Name: LANGUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."LANGUE_ID_seq" OWNED BY "OpenConcerto42"."LANGUE"."ID";


--
-- TOC entry 835 (class 1259 OID 36394409)
-- Name: METRIQUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."METRIQUE" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "UNITE" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "NOM" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto42"."METRIQUE" OWNER TO openconcerto;

--
-- TOC entry 836 (class 1259 OID 36394417)
-- Name: METRIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."METRIQUE_ID_seq"
    START WITH 4
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."METRIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21697 (class 0 OID 0)
-- Dependencies: 836
-- Name: METRIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."METRIQUE_ID_seq" OWNED BY "OpenConcerto42"."METRIQUE"."ID";


--
-- TOC entry 837 (class 1259 OID 36394419)
-- Name: MODELE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."MODELE" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TYPE_MODELE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."MODELE" OWNER TO openconcerto;

--
-- TOC entry 838 (class 1259 OID 36394426)
-- Name: MODELE_COURRIER_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."MODELE_COURRIER_CLIENT" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "CODE" character varying(10) DEFAULT ''::character varying,
    "LOCATION" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "CONTENU" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."MODELE_COURRIER_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 839 (class 1259 OID 36394440)
-- Name: MODELE_COURRIER_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."MODELE_COURRIER_CLIENT_ID_seq"
    START WITH 10
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."MODELE_COURRIER_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21698 (class 0 OID 0)
-- Dependencies: 839
-- Name: MODELE_COURRIER_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."MODELE_COURRIER_CLIENT_ID_seq" OWNED BY "OpenConcerto42"."MODELE_COURRIER_CLIENT"."ID";


--
-- TOC entry 840 (class 1259 OID 36394442)
-- Name: MODELE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."MODELE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."MODELE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21699 (class 0 OID 0)
-- Dependencies: 840
-- Name: MODELE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."MODELE_ID_seq" OWNED BY "OpenConcerto42"."MODELE"."ID";


--
-- TOC entry 841 (class 1259 OID 36394444)
-- Name: MODE_REGLEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."MODE_REGLEMENT" (
    "DATE_FACTURE" boolean DEFAULT false,
    "ID_TYPE_REGLEMENT" integer DEFAULT 1,
    "DATE" date,
    "COMPTANT" boolean DEFAULT false,
    "ID_MODE_REGLEMENT" integer NOT NULL,
    "LENJOUR" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ETS" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "CODE" character varying(2048) DEFAULT ''::text,
    "AJOURS" integer DEFAULT 0,
    "DATE_VIREMENT" date,
    "ORDRE" numeric(16,8),
    "DATE_DEPOT" date,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "FIN_MOIS" boolean DEFAULT false,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_BANQUE" integer DEFAULT 1,
    "ID_SEPA_MANDATE" integer
);


ALTER TABLE "OpenConcerto42"."MODE_REGLEMENT" OWNER TO openconcerto;

--
-- TOC entry 842 (class 1259 OID 36394464)
-- Name: MODE_REGLEMENT_ID_MODE_REGLEMENT_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."MODE_REGLEMENT_ID_MODE_REGLEMENT_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."MODE_REGLEMENT_ID_MODE_REGLEMENT_seq" OWNER TO openconcerto;

--
-- TOC entry 21700 (class 0 OID 0)
-- Dependencies: 842
-- Name: MODE_REGLEMENT_ID_MODE_REGLEMENT_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."MODE_REGLEMENT_ID_MODE_REGLEMENT_seq" OWNED BY "OpenConcerto42"."MODE_REGLEMENT"."ID_MODE_REGLEMENT";


--
-- TOC entry 843 (class 1259 OID 36394466)
-- Name: MODE_REGLEMENT_PAYE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."MODE_REGLEMENT_PAYE" (
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto42"."MODE_REGLEMENT_PAYE" OWNER TO openconcerto;

--
-- TOC entry 844 (class 1259 OID 36394470)
-- Name: MODE_REGLEMENT_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."MODE_REGLEMENT_PAYE_ID_seq"
    START WITH 4
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."MODE_REGLEMENT_PAYE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21701 (class 0 OID 0)
-- Dependencies: 844
-- Name: MODE_REGLEMENT_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."MODE_REGLEMENT_PAYE_ID_seq" OWNED BY "OpenConcerto42"."MODE_REGLEMENT_PAYE"."ID";


--
-- TOC entry 845 (class 1259 OID 36394472)
-- Name: MODE_VENTE_ARTICLE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."MODE_VENTE_ARTICLE" (
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "ID" integer NOT NULL,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "ORDRE" numeric(16,8) DEFAULT 0.00000000,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."MODE_VENTE_ARTICLE" OWNER TO openconcerto;

--
-- TOC entry 846 (class 1259 OID 36394490)
-- Name: MODE_VENTE_ARTICLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."MODE_VENTE_ARTICLE_ID_seq"
    START WITH 7
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."MODE_VENTE_ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21702 (class 0 OID 0)
-- Dependencies: 846
-- Name: MODE_VENTE_ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."MODE_VENTE_ARTICLE_ID_seq" OWNED BY "OpenConcerto42"."MODE_VENTE_ARTICLE"."ID";


--
-- TOC entry 847 (class 1259 OID 36394492)
-- Name: MOIS; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."MOIS" (
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "NOM" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto42"."MOIS" OWNER TO openconcerto;

--
-- TOC entry 848 (class 1259 OID 36394499)
-- Name: MOIS_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."MOIS_ID_seq"
    START WITH 14
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."MOIS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21703 (class 0 OID 0)
-- Dependencies: 848
-- Name: MOIS_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."MOIS_ID_seq" OWNED BY "OpenConcerto42"."MOIS"."ID";


--
-- TOC entry 849 (class 1259 OID 36394501)
-- Name: MOUVEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."MOUVEMENT" (
    "ID_MOUVEMENT_PERE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_PIECE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "IDSOURCE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "NUMERO" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "SOURCE" character varying(2048) DEFAULT ''::text,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL
);


ALTER TABLE "OpenConcerto42"."MOUVEMENT" OWNER TO openconcerto;

--
-- TOC entry 850 (class 1259 OID 36394516)
-- Name: MOUVEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."MOUVEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."MOUVEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21704 (class 0 OID 0)
-- Dependencies: 850
-- Name: MOUVEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."MOUVEMENT_ID_seq" OWNED BY "OpenConcerto42"."MOUVEMENT"."ID";


--
-- TOC entry 851 (class 1259 OID 36394518)
-- Name: MOUVEMENT_STOCK; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."MOUVEMENT_STOCK" (
    "QTE" real DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NOM" character varying(45) DEFAULT ''::character varying,
    "NUMERO" character varying(150) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "IDSOURCE" integer DEFAULT 1,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "DATE" date,
    "REEL" boolean DEFAULT true NOT NULL,
    "CLOTURE" boolean DEFAULT false NOT NULL,
    "OUVERTURE" boolean DEFAULT false NOT NULL,
    "ID_ETAT_STOCK" integer DEFAULT 1,
    "ID_STOCK" integer DEFAULT 1,
    "SOURCE_ELEMENTID" integer DEFAULT 1 NOT NULL
);


ALTER TABLE "OpenConcerto42"."MOUVEMENT_STOCK" OWNER TO openconcerto;

--
-- TOC entry 852 (class 1259 OID 36394531)
-- Name: MOUVEMENT_STOCK_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."MOUVEMENT_STOCK_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."MOUVEMENT_STOCK_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21705 (class 0 OID 0)
-- Dependencies: 852
-- Name: MOUVEMENT_STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."MOUVEMENT_STOCK_ID_seq" OWNED BY "OpenConcerto42"."MOUVEMENT_STOCK"."ID";


--
-- TOC entry 853 (class 1259 OID 36394533)
-- Name: NATURE_COMPTE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."NATURE_COMPTE" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."NATURE_COMPTE" OWNER TO openconcerto;

--
-- TOC entry 854 (class 1259 OID 36394543)
-- Name: NATURE_COMPTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."NATURE_COMPTE_ID_seq"
    START WITH 13
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."NATURE_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21706 (class 0 OID 0)
-- Dependencies: 854
-- Name: NATURE_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."NATURE_COMPTE_ID_seq" OWNED BY "OpenConcerto42"."NATURE_COMPTE"."ID";


--
-- TOC entry 855 (class 1259 OID 36394545)
-- Name: NUMEROTATION_AUTO; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."NUMEROTATION_AUTO" (
    "FACT_START" integer DEFAULT 1,
    "AFFAIRE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "RELANCE_START" integer DEFAULT 0,
    "SALARIE_START" integer DEFAULT 1,
    "FACT_FORMAT" character varying(45) DEFAULT ''::character varying,
    "DEVIS_FORMAT" character varying(45) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "AFFAIRE_START" integer DEFAULT 0,
    "CODE_LETTRAGE" character varying(128) DEFAULT 'AAA'::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "SALARIE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "BON_L_START" integer DEFAULT 1,
    "AVOIR_START" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "RELANCE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "PROPOSITION_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COMMANDE_CLIENT_START" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "AVOIR_FORMAT" character varying(45) DEFAULT ''::character varying,
    "PROPOSITION_START" integer DEFAULT 0,
    "BON_R_START" integer DEFAULT 0,
    "BON_R_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COMMANDE_CLIENT_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COMMANDE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COMMANDE_START" integer DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "BON_L_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COURRIER_START" integer DEFAULT 1,
    "COURRIER_FORMAT" character varying(45) DEFAULT ''::character varying,
    "DEVIS_START" integer DEFAULT 1,
    "AVOIR_F_START" integer DEFAULT 0,
    "AVOIR_F_FORMAT" character varying(48) DEFAULT ''::character varying NOT NULL,
    "CLIENT_START" integer DEFAULT 0,
    "CLIENT_FORMAT" character varying(48) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT 'Standard'::character varying,
    "DMD_PRIX_FORMAT" character varying(128) DEFAULT ''::character varying NOT NULL,
    "DMD_PRIX_START" integer DEFAULT 1 NOT NULL
);


ALTER TABLE "OpenConcerto42"."NUMEROTATION_AUTO" OWNER TO openconcerto;

--
-- TOC entry 856 (class 1259 OID 36394586)
-- Name: NUMEROTATION_AUTO_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."NUMEROTATION_AUTO_ID_seq"
    START WITH 3
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."NUMEROTATION_AUTO_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21707 (class 0 OID 0)
-- Dependencies: 856
-- Name: NUMEROTATION_AUTO_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."NUMEROTATION_AUTO_ID_seq" OWNED BY "OpenConcerto42"."NUMEROTATION_AUTO"."ID";


--
-- TOC entry 857 (class 1259 OID 36394588)
-- Name: OBJECTIF_COMMERCIAL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."OBJECTIF_COMMERCIAL" (
    "ID" integer NOT NULL,
    "MOIS" character varying(32) DEFAULT ''::character varying NOT NULL,
    "ANNEE" integer,
    "MARGE_HT" bigint DEFAULT 0,
    "POURCENT_MARGE" numeric(16,8),
    "CHIFFRE_AFFAIRE" bigint DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."OBJECTIF_COMMERCIAL" OWNER TO openconcerto;

--
-- TOC entry 858 (class 1259 OID 36394597)
-- Name: OBJECTIF_COMMERCIAL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."OBJECTIF_COMMERCIAL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."OBJECTIF_COMMERCIAL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21708 (class 0 OID 0)
-- Dependencies: 858
-- Name: OBJECTIF_COMMERCIAL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."OBJECTIF_COMMERCIAL_ID_seq" OWNED BY "OpenConcerto42"."OBJECTIF_COMMERCIAL"."ID";


--
-- TOC entry 1314 (class 1259 OID 36416057)
-- Name: PAS; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."PAS" (
    "ID" integer NOT NULL,
    "ID_TYPE_TAUX_PAS" integer DEFAULT 1,
    "CODE_PAS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TAUX_PAS" numeric(16,2) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."PAS" OWNER TO openconcerto;

--
-- TOC entry 1313 (class 1259 OID 36416055)
-- Name: PAS_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."PAS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."PAS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21709 (class 0 OID 0)
-- Dependencies: 1313
-- Name: PAS_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."PAS_ID_seq" OWNED BY "OpenConcerto42"."PAS"."ID";


--
-- TOC entry 859 (class 1259 OID 36394599)
-- Name: PAYS; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."PAYS" (
    "CODE" character varying(15) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(50) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "ID_TARIF" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."PAYS" OWNER TO openconcerto;

--
-- TOC entry 860 (class 1259 OID 36394609)
-- Name: PAYS_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."PAYS_ID_seq"
    START WITH 194
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."PAYS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21710 (class 0 OID 0)
-- Dependencies: 860
-- Name: PAYS_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."PAYS_ID_seq" OWNED BY "OpenConcerto42"."PAYS"."ID";


--
-- TOC entry 861 (class 1259 OID 36394611)
-- Name: PIECE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."PIECE" (
    "ORDRE" numeric(16,8),
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."PIECE" OWNER TO openconcerto;

--
-- TOC entry 862 (class 1259 OID 36394621)
-- Name: PIECE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."PIECE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."PIECE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21711 (class 0 OID 0)
-- Dependencies: 862
-- Name: PIECE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."PIECE_ID_seq" OWNED BY "OpenConcerto42"."PIECE"."ID";


--
-- TOC entry 863 (class 1259 OID 36394623)
-- Name: POSTE_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."POSTE_ANALYTIQUE" (
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID_AXE_ANALYTIQUE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "DEFAULT" boolean DEFAULT false NOT NULL,
    "OBSOLETE" boolean DEFAULT false NOT NULL
);


ALTER TABLE "OpenConcerto42"."POSTE_ANALYTIQUE" OWNER TO openconcerto;

--
-- TOC entry 864 (class 1259 OID 36394635)
-- Name: POSTE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."POSTE_ANALYTIQUE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."POSTE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21712 (class 0 OID 0)
-- Dependencies: 864
-- Name: POSTE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."POSTE_ANALYTIQUE_ID_seq" OWNED BY "OpenConcerto42"."POSTE_ANALYTIQUE"."ID";


--
-- TOC entry 865 (class 1259 OID 36394637)
-- Name: PREFERENCES; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."PREFERENCES" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "VALUE" character varying(2048),
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "NAME" character varying(2048)
);


ALTER TABLE "OpenConcerto42"."PREFERENCES" OWNER TO openconcerto;

--
-- TOC entry 866 (class 1259 OID 36394647)
-- Name: PREFERENCES_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."PREFERENCES_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."PREFERENCES_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21713 (class 0 OID 0)
-- Dependencies: 866
-- Name: PREFERENCES_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."PREFERENCES_ID_seq" OWNED BY "OpenConcerto42"."PREFERENCES"."ID";


--
-- TOC entry 867 (class 1259 OID 36394649)
-- Name: PREFS_COMPTE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."PREFS_COMPTE" (
    "ID_COMPTE_PCE_TVA_ACHAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_TVA_IMMO" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_RESULTAT_PERTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE_SERVICE" integer DEFAULT 1,
    "ID_COMPTE_PCE_BILAN_F" integer DEFAULT 1,
    "ID_COMPTE_PCE_BILAN_O" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE_PRODUIT" integer DEFAULT 1,
    "ID_COMPTE_PCE_CLIENT" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_COMPTE_PCE_ACHAT_INTRA" integer DEFAULT 1,
    "ID_COMPTE_PCE_TVA_INTRA" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACOMPTE_REGL" integer DEFAULT 1,
    "ID_JOURNAL_FACTOR" integer DEFAULT 1,
    "ID_COMPTE_PCE_RESULTAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACOMPTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_FACTOR" integer DEFAULT 1,
    "ID_COMPTE_PCE_FOURNISSEUR" integer DEFAULT 1,
    "ID_COMPTE_PCE_PAYE" integer DEFAULT 1,
    "ID_COMPTE_PCE_TVA_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_PORT_SOUMIS" integer DEFAULT 1,
    "ID_COMPTE_PCE_PORT_NON_SOUMIS" integer DEFAULT 1,
    "ID_COMPTE_PCE_AVANCE_CLIENT" integer DEFAULT 1,
    "ID_COMPTE_PCE_VALEUR_ENCAISSEMENT" integer DEFAULT 1,
    "ID_JOURNAL_AN" integer DEFAULT 1,
    "CREATE_NUL_SOLDE_ECR" boolean DEFAULT true NOT NULL,
    "AUTO_LETTRAGE" boolean DEFAULT false NOT NULL
);


ALTER TABLE "OpenConcerto42"."PREFS_COMPTE" OWNER TO openconcerto;

--
-- TOC entry 868 (class 1259 OID 36394678)
-- Name: PREFS_COMPTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."PREFS_COMPTE_ID_seq"
    START WITH 3
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."PREFS_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21714 (class 0 OID 0)
-- Dependencies: 868
-- Name: PREFS_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."PREFS_COMPTE_ID_seq" OWNED BY "OpenConcerto42"."PREFS_COMPTE"."ID";


--
-- TOC entry 869 (class 1259 OID 36394680)
-- Name: PREF_NODE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."PREF_NODE" (
    "ID" integer NOT NULL,
    "ID_PARENT" integer,
    "NAME" character varying(80) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."PREF_NODE" OWNER TO openconcerto;

--
-- TOC entry 870 (class 1259 OID 36394684)
-- Name: PREF_NODE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."PREF_NODE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."PREF_NODE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21715 (class 0 OID 0)
-- Dependencies: 870
-- Name: PREF_NODE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."PREF_NODE_ID_seq" OWNED BY "OpenConcerto42"."PREF_NODE"."ID";


--
-- TOC entry 871 (class 1259 OID 36394686)
-- Name: PREF_VALUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."PREF_VALUE" (
    "ID_NODE" integer NOT NULL,
    "NAME" character varying(80) DEFAULT ''::character varying NOT NULL,
    "VALUE" character varying(8192) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."PREF_VALUE" OWNER TO openconcerto;

--
-- TOC entry 872 (class 1259 OID 36394694)
-- Name: REFERENCE_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."REFERENCE_CLIENT" (
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."REFERENCE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 873 (class 1259 OID 36394705)
-- Name: REFERENCE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."REFERENCE_CLIENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."REFERENCE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21716 (class 0 OID 0)
-- Dependencies: 873
-- Name: REFERENCE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."REFERENCE_CLIENT_ID_seq" OWNED BY "OpenConcerto42"."REFERENCE_CLIENT"."ID";


--
-- TOC entry 874 (class 1259 OID 36394707)
-- Name: REGIME_BASE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."REGIME_BASE" (
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_CODE_REGIME_MALADIE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_CODE_REGIME_VIEL_P" integer DEFAULT 1,
    "ID_CODE_REGIME_AT" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_CODE_REGIME_VIEL_S" integer DEFAULT 1,
    "ID_CODE_REGIME_BASE" integer DEFAULT 1,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto42"."REGIME_BASE" OWNER TO openconcerto;

--
-- TOC entry 875 (class 1259 OID 36394720)
-- Name: REGIME_BASE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."REGIME_BASE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."REGIME_BASE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21717 (class 0 OID 0)
-- Dependencies: 875
-- Name: REGIME_BASE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."REGIME_BASE_ID_seq" OWNED BY "OpenConcerto42"."REGIME_BASE"."ID";


--
-- TOC entry 876 (class 1259 OID 36394722)
-- Name: REGLEMENT_PAYE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."REGLEMENT_PAYE" (
    "ID" integer NOT NULL,
    "LE" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "NOM_BANQUE" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_MODE_REGLEMENT_PAYE" integer DEFAULT 1,
    "RIB" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto42"."REGLEMENT_PAYE" OWNER TO openconcerto;

--
-- TOC entry 877 (class 1259 OID 36394733)
-- Name: REGLEMENT_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."REGLEMENT_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."REGLEMENT_PAYE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21718 (class 0 OID 0)
-- Dependencies: 877
-- Name: REGLEMENT_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."REGLEMENT_PAYE_ID_seq" OWNED BY "OpenConcerto42"."REGLEMENT_PAYE"."ID";


--
-- TOC entry 878 (class 1259 OID 36394735)
-- Name: REGLER_MONTANT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."REGLER_MONTANT" (
    "ID_ECHEANCE_FOURNISSEUR" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer,
    "DATE" date,
    "ID" integer NOT NULL,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto42"."REGLER_MONTANT" OWNER TO openconcerto;

--
-- TOC entry 879 (class 1259 OID 36394744)
-- Name: REGLER_MONTANT_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."REGLER_MONTANT_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_ECHEANCE_FOURNISSEUR" integer DEFAULT 1,
    "ID_REGLER_MONTANT" integer DEFAULT 1,
    "ID_MOUVEMENT_ECHEANCE" integer DEFAULT 1,
    "DATE" date,
    "MONTANT_REGLE" bigint DEFAULT 0,
    "MONTANT_A_REGLER" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."REGLER_MONTANT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 880 (class 1259 OID 36394754)
-- Name: REGLER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."REGLER_MONTANT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."REGLER_MONTANT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21719 (class 0 OID 0)
-- Dependencies: 880
-- Name: REGLER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."REGLER_MONTANT_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."REGLER_MONTANT_ELEMENT"."ID";


--
-- TOC entry 881 (class 1259 OID 36394756)
-- Name: REGLER_MONTANT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."REGLER_MONTANT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."REGLER_MONTANT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21720 (class 0 OID 0)
-- Dependencies: 881
-- Name: REGLER_MONTANT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."REGLER_MONTANT_ID_seq" OWNED BY "OpenConcerto42"."REGLER_MONTANT"."ID";


--
-- TOC entry 882 (class 1259 OID 36394758)
-- Name: RELANCE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."RELANCE" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ID_CLIENT" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_TYPE_LETTRE_RELANCE" integer DEFAULT 1,
    "DATE" date,
    "MONTANT" bigint DEFAULT 0,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8),
    "ID_ECHEANCE_CLIENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."RELANCE" OWNER TO openconcerto;

--
-- TOC entry 883 (class 1259 OID 36394774)
-- Name: RELANCE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."RELANCE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."RELANCE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21721 (class 0 OID 0)
-- Dependencies: 883
-- Name: RELANCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."RELANCE_ID_seq" OWNED BY "OpenConcerto42"."RELANCE"."ID";


--
-- TOC entry 884 (class 1259 OID 36394776)
-- Name: REPARTITION_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."REPARTITION_ANALYTIQUE" (
    "NOM" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."REPARTITION_ANALYTIQUE" OWNER TO openconcerto;

--
-- TOC entry 885 (class 1259 OID 36394786)
-- Name: REPARTITION_ANALYTIQUE_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."REPARTITION_ANALYTIQUE_ELEMENT" (
    "MODIFICATION_DATE" timestamp without time zone,
    "TAUX" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_POSTE_ANALYTIQUE" integer DEFAULT 1,
    "ID_REPARTITION_ANALYTIQUE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."REPARTITION_ANALYTIQUE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 886 (class 1259 OID 36394795)
-- Name: REPARTITION_ANALYTIQUE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."REPARTITION_ANALYTIQUE_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."REPARTITION_ANALYTIQUE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21722 (class 0 OID 0)
-- Dependencies: 886
-- Name: REPARTITION_ANALYTIQUE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."REPARTITION_ANALYTIQUE_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."REPARTITION_ANALYTIQUE_ELEMENT"."ID";


--
-- TOC entry 887 (class 1259 OID 36394797)
-- Name: REPARTITION_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."REPARTITION_ANALYTIQUE_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."REPARTITION_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21723 (class 0 OID 0)
-- Dependencies: 887
-- Name: REPARTITION_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."REPARTITION_ANALYTIQUE_ID_seq" OWNED BY "OpenConcerto42"."REPARTITION_ANALYTIQUE"."ID";


--
-- TOC entry 888 (class 1259 OID 36394799)
-- Name: REPRISE_TRAVAIL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."REPRISE_TRAVAIL" (
    "ID" integer NOT NULL,
    "ID_SALARIE" integer DEFAULT 1,
    "DATE_DERNIER_JOUR_TRAV" timestamp without time zone,
    "DATE_FIN_PREV" timestamp without time zone,
    "SUBROGATION" boolean DEFAULT false NOT NULL,
    "DATE_DEBUT_SUBROGATION" timestamp without time zone,
    "DATE_FIN_SUBROGATION" timestamp without time zone,
    "ID_MOTIF_ARRET_TRAVAIL" integer DEFAULT 1,
    "ID_MOTIF_REPRISE_ARRET_TRAVAIL" integer DEFAULT 1,
    "DATE_REPRISE" timestamp without time zone,
    "DATE_ACCIDENT" timestamp without time zone,
    "DATE" timestamp without time zone,
    "COMMENTAIRES" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."REPRISE_TRAVAIL" OWNER TO openconcerto;

--
-- TOC entry 889 (class 1259 OID 36394812)
-- Name: REPRISE_TRAVAIL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."REPRISE_TRAVAIL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."REPRISE_TRAVAIL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21724 (class 0 OID 0)
-- Dependencies: 889
-- Name: REPRISE_TRAVAIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."REPRISE_TRAVAIL_ID_seq" OWNED BY "OpenConcerto42"."REPRISE_TRAVAIL"."ID";


--
-- TOC entry 890 (class 1259 OID 36394814)
-- Name: SAISIE_ACHAT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."SAISIE_ACHAT" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "MONTANT_TTC" bigint DEFAULT 0,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_AVOIR_FOURNISSEUR" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "IMMO" boolean DEFAULT false,
    "MONTANT_HT" bigint DEFAULT 0,
    "NUMERO_COMMANDE" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer,
    "DATE" date,
    "MONTANT_TVA" bigint DEFAULT 0,
    "NUMERO_FACTURE" character varying(2048) DEFAULT ''::text,
    "IDSOURCE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto42"."SAISIE_ACHAT" OWNER TO openconcerto;

--
-- TOC entry 891 (class 1259 OID 36394837)
-- Name: SAISIE_ACHAT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."SAISIE_ACHAT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SAISIE_ACHAT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21725 (class 0 OID 0)
-- Dependencies: 891
-- Name: SAISIE_ACHAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."SAISIE_ACHAT_ID_seq" OWNED BY "OpenConcerto42"."SAISIE_ACHAT"."ID";


--
-- TOC entry 892 (class 1259 OID 36394839)
-- Name: SAISIE_KM; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."SAISIE_KM" (
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID" integer NOT NULL,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "DATE" date,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "ID_JOURNAL" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto42"."SAISIE_KM" OWNER TO openconcerto;

--
-- TOC entry 893 (class 1259 OID 36394849)
-- Name: SAISIE_KM_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."SAISIE_KM_ELEMENT" (
    "ID" integer NOT NULL,
    "CREDIT" bigint DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NOM_ECRITURE" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NUMERO" character varying(100) DEFAULT ''::character varying,
    "ID_ECRITURE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_SAISIE_KM" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "DEBIT" bigint DEFAULT 0,
    "NOM_PIECE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ANALYTIQUE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "JOUR" integer DEFAULT 1 NOT NULL
);


ALTER TABLE "OpenConcerto42"."SAISIE_KM_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 894 (class 1259 OID 36394868)
-- Name: SAISIE_KM_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."SAISIE_KM_ELEMENT_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SAISIE_KM_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21726 (class 0 OID 0)
-- Dependencies: 894
-- Name: SAISIE_KM_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."SAISIE_KM_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."SAISIE_KM_ELEMENT"."ID";


--
-- TOC entry 895 (class 1259 OID 36394870)
-- Name: SAISIE_KM_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."SAISIE_KM_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SAISIE_KM_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21727 (class 0 OID 0)
-- Dependencies: 895
-- Name: SAISIE_KM_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."SAISIE_KM_ID_seq" OWNED BY "OpenConcerto42"."SAISIE_KM"."ID";


--
-- TOC entry 896 (class 1259 OID 36394872)
-- Name: SAISIE_VENTE_COMPTOIR; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."SAISIE_VENTE_COMPTOIR" (
    "CREATION_DATE" timestamp without time zone,
    "ECHEANCE" integer DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "DATE" date,
    "ID" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_TAXE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "MONTANT_TTC" bigint DEFAULT 0,
    "MONTANT_HT" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "MONTANT_SERVICE" bigint DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_COMPTE_PCE_PRODUIT" integer DEFAULT 1,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."SAISIE_VENTE_COMPTOIR" OWNER TO openconcerto;

--
-- TOC entry 897 (class 1259 OID 36394894)
-- Name: SAISIE_VENTE_COMPTOIR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."SAISIE_VENTE_COMPTOIR_ID_seq"
    START WITH 2
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SAISIE_VENTE_COMPTOIR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21728 (class 0 OID 0)
-- Dependencies: 897
-- Name: SAISIE_VENTE_COMPTOIR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."SAISIE_VENTE_COMPTOIR_ID_seq" OWNED BY "OpenConcerto42"."SAISIE_VENTE_COMPTOIR"."ID";


--
-- TOC entry 898 (class 1259 OID 36394896)
-- Name: SAISIE_VENTE_FACTURE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."SAISIE_VENTE_FACTURE" (
    "PREVISIONNELLE" boolean DEFAULT false,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "POURCENT_ACOMPTE" real DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "DATE_REGLEMENT" timestamp without time zone,
    "ID_ADRESSE" integer DEFAULT 1,
    "T_AVOIR_TTC" bigint DEFAULT 0,
    "PORT_HT" bigint DEFAULT 0,
    "COMPLEMENT" boolean DEFAULT false,
    "T_TTC" bigint DEFAULT 0,
    "ENVOYE_EN_AFFACTURAGE" boolean DEFAULT false,
    "T_TVA" bigint DEFAULT 0,
    "DATE_ENVOI_AFFACTURAGE" date,
    "T_POIDS" real DEFAULT 0,
    "DATE_ENVOI" timestamp without time zone,
    "ACOMPTE" boolean DEFAULT false,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "ID_DEVIS" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "RETOUR_NATEXIS" boolean DEFAULT false,
    "TYPE_INTERVENTION" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "REMISE_HT" bigint DEFAULT 0,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "T_SERVICE" bigint DEFAULT 0,
    "ID_COMPTE_PCE_VENTE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_MOIS_CCIP" integer DEFAULT 1,
    "ID_CONTACT" integer DEFAULT 1,
    "DATE" date,
    "ID_CLIENT" integer DEFAULT 1,
    "AFFACTURAGE" boolean DEFAULT false,
    "ID_USER_COMMON_CREATE" integer,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "NOM" character varying(250) DEFAULT ''::character varying,
    "T_HA" bigint DEFAULT 0,
    "REF_CLIENT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "COMPTE_SERVICE_AUTO" boolean DEFAULT false,
    "ID_REFERENCE_CLIENT" integer DEFAULT 1,
    "T_HT" bigint DEFAULT 0,
    "CONTROLE_TECHNIQUE" boolean DEFAULT false,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "POURCENT_FACTURABLE" numeric(16,8),
    "MONTANT_FACTURABLE" numeric(16,8),
    "SOLDE" boolean DEFAULT false,
    "PARTIAL" boolean DEFAULT false,
    "ID_ADRESSE_LIVRAISON" integer DEFAULT 1,
    "POURCENT_REMISE" numeric(12,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_CLIENT_DEPARTEMENT" integer DEFAULT 1,
    "CREATE_VIRTUAL_STOCK" boolean DEFAULT true NOT NULL,
    "SOUMIS_TIMBRE_FISCAL" boolean DEFAULT false,
    "TAUX_TIMBRE_FISCAL" numeric(16,4) DEFAULT 1,
    "TOTAL_TIMBRE_FISCAL" bigint DEFAULT 0,
    "NET_A_PAYER" bigint DEFAULT 0,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "T_ACOMPTE" bigint DEFAULT 0 NOT NULL,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "ID_SDD_MESSAGE" integer,
    "SDD_EndToEndId" character varying(35) DEFAULT ''::character varying NOT NULL,
    "FRAIS_DOCUMENT_HT" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE_FRAIS_DOCUMENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."SAISIE_VENTE_FACTURE" OWNER TO openconcerto;

--
-- TOC entry 899 (class 1259 OID 36394956)
-- Name: SAISIE_VENTE_FACTURE_ELEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."SAISIE_VENTE_FACTURE_ELEMENT" (
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "Q18" boolean DEFAULT false,
    "OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "INDICE_0" bigint DEFAULT 0,
    "LOCAL_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "SOUS_ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "CODE_MISSION" character varying(45) DEFAULT ''::character varying,
    "TARIF_Q18_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "POURCENT_CCIP" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_CONTACT" integer DEFAULT 1,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_LIVREE" integer DEFAULT 0,
    "POURCENT_SERVICE" character varying(2048) DEFAULT ''::text,
    "POIDS" real DEFAULT 0,
    "LIVREE" boolean DEFAULT false,
    "SITUATION_ADMIN" character varying(2048) DEFAULT ''::text,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID" integer NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "POURCENT_ACOMPTE" numeric(6,2) DEFAULT 100 NOT NULL,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "REFERENTIEL_INSPECTION" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "MONTANT_INITIAL" numeric(16,6) DEFAULT 0 NOT NULL,
    "MONTANT_REVISABLE" boolean DEFAULT false,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "INDICE_N" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_STYLE" integer DEFAULT 1,
    "REPARTITION_POURCENT" numeric(6,2) DEFAULT 0 NOT NULL,
    "DATE_FIN" timestamp without time zone,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "DATE" date,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "QTE" integer DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "POURCENT_REMISE" numeric(12,8) DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "T_POIDS" real DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "INFOS_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "NOM_MISSION" character varying(256) DEFAULT ''::character varying,
    "ACOMPTE" boolean DEFAULT false,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_TICKET_CAISSE" integer DEFAULT 1,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_T_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "T_POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "NB_COLIS" integer DEFAULT 0,
    "MONTANT_FACTURABLE" numeric(16,8),
    "POURCENT_FACTURABLE" numeric(16,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_COMMANDE_CLIENT_ELEMENT" integer DEFAULT 1,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."SAISIE_VENTE_FACTURE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 900 (class 1259 OID 36395038)
-- Name: SAISIE_VENTE_FACTURE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."SAISIE_VENTE_FACTURE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SAISIE_VENTE_FACTURE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21729 (class 0 OID 0)
-- Dependencies: 900
-- Name: SAISIE_VENTE_FACTURE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."SAISIE_VENTE_FACTURE_ELEMENT_ID_seq" OWNED BY "OpenConcerto42"."SAISIE_VENTE_FACTURE_ELEMENT"."ID";


--
-- TOC entry 901 (class 1259 OID 36395040)
-- Name: SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."SAISIE_VENTE_FACTURE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SAISIE_VENTE_FACTURE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21730 (class 0 OID 0)
-- Dependencies: 901
-- Name: SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."SAISIE_VENTE_FACTURE_ID_seq" OWNED BY "OpenConcerto42"."SAISIE_VENTE_FACTURE"."ID";


--
-- TOC entry 902 (class 1259 OID 36395042)
-- Name: SALARIE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."SALARIE" (
    "ID_CUMULS_PAYE" integer DEFAULT 1,
    "PRENOM" character varying(45) DEFAULT ''::character varying,
    "ID_FICHE_PAYE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID_INFOS_SALARIE_PAYE" integer DEFAULT 1,
    "ID_REGLEMENT_PAYE" integer DEFAULT 1,
    "ID_CUMULS_CONGES" integer DEFAULT 1,
    "DERNIER_MOIS" integer DEFAULT 0,
    "ID_VARIABLE_SALARIE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "DERNIERE_ANNEE" integer DEFAULT 0,
    "NOM_JEUNE_FILLE" character varying(45) DEFAULT ''::character varying,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_ETAT_CIVIL" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "ID_PAS" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."SALARIE" OWNER TO openconcerto;

--
-- TOC entry 903 (class 1259 OID 36395061)
-- Name: SALARIE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SALARIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21731 (class 0 OID 0)
-- Dependencies: 903
-- Name: SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."SALARIE_ID_seq" OWNED BY "OpenConcerto42"."SALARIE"."ID";


--
-- TOC entry 904 (class 1259 OID 36395063)
-- Name: SEPA_DIRECT_DEBIT_MESSAGE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."SEPA_DIRECT_DEBIT_MESSAGE" (
    "ID" integer NOT NULL,
    "MessageIdentification" character varying(35) DEFAULT ''::character varying NOT NULL,
    "CreationDateTime" timestamp without time zone NOT NULL,
    "NumberOfTransactions" integer DEFAULT 0 NOT NULL,
    "ControlSum" numeric(16,6) DEFAULT 0 NOT NULL,
    "XML" text NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."SEPA_DIRECT_DEBIT_MESSAGE" OWNER TO openconcerto;

--
-- TOC entry 905 (class 1259 OID 36395073)
-- Name: SEPA_DIRECT_DEBIT_MESSAGE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."SEPA_DIRECT_DEBIT_MESSAGE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SEPA_DIRECT_DEBIT_MESSAGE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21732 (class 0 OID 0)
-- Dependencies: 905
-- Name: SEPA_DIRECT_DEBIT_MESSAGE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."SEPA_DIRECT_DEBIT_MESSAGE_ID_seq" OWNED BY "OpenConcerto42"."SEPA_DIRECT_DEBIT_MESSAGE"."ID";


--
-- TOC entry 906 (class 1259 OID 36395075)
-- Name: SEPA_MANDATE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."SEPA_MANDATE" (
    "ID" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "MandateIdentification" character varying(35) DEFAULT ''::character varying NOT NULL,
    "DateOfSignature" date,
    "SequenceType" character varying(8) DEFAULT ''::character varying NOT NULL,
    "ACTIVE" boolean DEFAULT true NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto42"."SEPA_MANDATE" OWNER TO openconcerto;

--
-- TOC entry 907 (class 1259 OID 36395083)
-- Name: SEPA_MANDATE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."SEPA_MANDATE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SEPA_MANDATE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21733 (class 0 OID 0)
-- Dependencies: 907
-- Name: SEPA_MANDATE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."SEPA_MANDATE_ID_seq" OWNED BY "OpenConcerto42"."SEPA_MANDATE"."ID";


--
-- TOC entry 908 (class 1259 OID 36395085)
-- Name: SITUATION_FAMILIALE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."SITUATION_FAMILIALE" (
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."SITUATION_FAMILIALE" OWNER TO openconcerto;

--
-- TOC entry 909 (class 1259 OID 36395093)
-- Name: SITUATION_FAMILIALE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."SITUATION_FAMILIALE_ID_seq"
    START WITH 7
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."SITUATION_FAMILIALE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21734 (class 0 OID 0)
-- Dependencies: 909
-- Name: SITUATION_FAMILIALE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."SITUATION_FAMILIALE_ID_seq" OWNED BY "OpenConcerto42"."SITUATION_FAMILIALE"."ID";


--
-- TOC entry 910 (class 1259 OID 36395095)
-- Name: STOCK; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."STOCK" (
    "QTE_REEL" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "QTE_TH" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "QTE_RECEPT_ATTENTE" real DEFAULT 0,
    "QTE_LIV_ATTENTE" real DEFAULT 0,
    "ID_DEPOT_STOCK" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "QTE_MIN" real DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."STOCK" OWNER TO openconcerto;

--
-- TOC entry 911 (class 1259 OID 36395105)
-- Name: STOCK_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."STOCK_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."STOCK_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21735 (class 0 OID 0)
-- Dependencies: 911
-- Name: STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."STOCK_ID_seq" OWNED BY "OpenConcerto42"."STOCK"."ID";


--
-- TOC entry 912 (class 1259 OID 36395107)
-- Name: STYLE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."STYLE" (
    "ID_STYLE" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CODE" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto42"."STYLE" OWNER TO openconcerto;

--
-- TOC entry 913 (class 1259 OID 36395116)
-- Name: STYLE_ID_STYLE_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."STYLE_ID_STYLE_seq"
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."STYLE_ID_STYLE_seq" OWNER TO openconcerto;

--
-- TOC entry 21736 (class 0 OID 0)
-- Dependencies: 913
-- Name: STYLE_ID_STYLE_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."STYLE_ID_STYLE_seq" OWNED BY "OpenConcerto42"."STYLE"."ID_STYLE";


--
-- TOC entry 914 (class 1259 OID 36395118)
-- Name: TARIF; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."TARIF" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."TARIF" OWNER TO openconcerto;

--
-- TOC entry 915 (class 1259 OID 36395126)
-- Name: TARIF_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."TARIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TARIF_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21737 (class 0 OID 0)
-- Dependencies: 915
-- Name: TARIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."TARIF_ID_seq" OWNED BY "OpenConcerto42"."TARIF"."ID";


--
-- TOC entry 916 (class 1259 OID 36395128)
-- Name: TARIF_QUANTITE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."TARIF_QUANTITE" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "QUANTITE" numeric(16,3) DEFAULT 1 NOT NULL,
    "POURCENT_REMISE" numeric(16,3),
    "PRIX_METRIQUE_VT_1" numeric(16,6),
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."TARIF_QUANTITE" OWNER TO openconcerto;

--
-- TOC entry 917 (class 1259 OID 36395135)
-- Name: TARIF_QUANTITE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."TARIF_QUANTITE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TARIF_QUANTITE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21738 (class 0 OID 0)
-- Dependencies: 917
-- Name: TARIF_QUANTITE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."TARIF_QUANTITE_ID_seq" OWNED BY "OpenConcerto42"."TARIF_QUANTITE"."ID";


--
-- TOC entry 918 (class 1259 OID 36395137)
-- Name: TAXE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."TAXE" (
    "CODE" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ID_TAXE" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "TAUX" real DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_COMPTE_PCE_COLLECTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_DED" integer DEFAULT 1,
    "DEFAULT" boolean DEFAULT false,
    "ID_COMPTE_PCE_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE_SERVICE" integer DEFAULT 1,
    "ID_COMPTE_PCE_COLLECTE_INTRA" integer DEFAULT 1,
    "ID_COMPTE_PCE_DED_INTRA" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."TAXE" OWNER TO openconcerto;

--
-- TOC entry 919 (class 1259 OID 36395157)
-- Name: TAXE_COMPLEMENTAIRE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."TAXE_COMPLEMENTAIRE" (
    "ID" integer NOT NULL,
    "ID_COMPTE_PCE_PRODUITS" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "POURCENT" numeric(16,6) DEFAULT 0 NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."TAXE_COMPLEMENTAIRE" OWNER TO openconcerto;

--
-- TOC entry 920 (class 1259 OID 36395167)
-- Name: TAXE_COMPLEMENTAIRE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."TAXE_COMPLEMENTAIRE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TAXE_COMPLEMENTAIRE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21739 (class 0 OID 0)
-- Dependencies: 920
-- Name: TAXE_COMPLEMENTAIRE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."TAXE_COMPLEMENTAIRE_ID_seq" OWNED BY "OpenConcerto42"."TAXE_COMPLEMENTAIRE"."ID";


--
-- TOC entry 921 (class 1259 OID 36395169)
-- Name: TAXE_ID_TAXE_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."TAXE_ID_TAXE_seq"
    START WITH 6
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TAXE_ID_TAXE_seq" OWNER TO openconcerto;

--
-- TOC entry 21740 (class 0 OID 0)
-- Dependencies: 921
-- Name: TAXE_ID_TAXE_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."TAXE_ID_TAXE_seq" OWNED BY "OpenConcerto42"."TAXE"."ID_TAXE";


--
-- TOC entry 922 (class 1259 OID 36395171)
-- Name: TICKET_CAISSE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."TICKET_CAISSE" (
    "DATE" timestamp without time zone,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "TOTAL_TVA" bigint DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "TOTAL_HT" bigint DEFAULT 0,
    "TOTAL_TTC" bigint DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_CAISSE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "FILE_HASH" character varying(128) DEFAULT NULL::character varying,
    "FILE_HASH_PREVIOUS" character varying(128) DEFAULT NULL::character varying
);


ALTER TABLE "OpenConcerto42"."TICKET_CAISSE" OWNER TO openconcerto;

--
-- TOC entry 923 (class 1259 OID 36395190)
-- Name: TICKET_CAISSE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."TICKET_CAISSE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TICKET_CAISSE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21741 (class 0 OID 0)
-- Dependencies: 923
-- Name: TICKET_CAISSE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."TICKET_CAISSE_ID_seq" OWNED BY "OpenConcerto42"."TICKET_CAISSE"."ID";


--
-- TOC entry 924 (class 1259 OID 36395192)
-- Name: TITRE_PERSONNEL; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."TITRE_PERSONNEL" (
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "SEXE_M" boolean DEFAULT true,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CODE" character varying(8) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "NOM" character varying(45) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."TITRE_PERSONNEL" OWNER TO openconcerto;

--
-- TOC entry 925 (class 1259 OID 36395201)
-- Name: TITRE_PERSONNEL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."TITRE_PERSONNEL_ID_seq"
    START WITH 5
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TITRE_PERSONNEL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21742 (class 0 OID 0)
-- Dependencies: 925
-- Name: TITRE_PERSONNEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."TITRE_PERSONNEL_ID_seq" OWNED BY "OpenConcerto42"."TITRE_PERSONNEL"."ID";


--
-- TOC entry 926 (class 1259 OID 36395203)
-- Name: TR_BON_DE_LIVRAISON; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."TR_BON_DE_LIVRAISON" (
    "ID" integer NOT NULL,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."TR_BON_DE_LIVRAISON" OWNER TO openconcerto;

--
-- TOC entry 927 (class 1259 OID 36395210)
-- Name: TR_BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."TR_BON_DE_LIVRAISON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TR_BON_DE_LIVRAISON_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21743 (class 0 OID 0)
-- Dependencies: 927
-- Name: TR_BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."TR_BON_DE_LIVRAISON_ID_seq" OWNED BY "OpenConcerto42"."TR_BON_DE_LIVRAISON"."ID";


--
-- TOC entry 928 (class 1259 OID 36395212)
-- Name: TR_BON_RECEPTION; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."TR_BON_RECEPTION" (
    "ID" integer NOT NULL,
    "ID_BON_RECEPTION" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_SAISIE_ACHAT" integer DEFAULT 1,
    "ID_FACTURE_FOURNISSEUR" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."TR_BON_RECEPTION" OWNER TO openconcerto;

--
-- TOC entry 929 (class 1259 OID 36395220)
-- Name: TR_BON_RECEPTION_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."TR_BON_RECEPTION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TR_BON_RECEPTION_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21744 (class 0 OID 0)
-- Dependencies: 929
-- Name: TR_BON_RECEPTION_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."TR_BON_RECEPTION_ID_seq" OWNED BY "OpenConcerto42"."TR_BON_RECEPTION"."ID";


--
-- TOC entry 930 (class 1259 OID 36395222)
-- Name: TR_COMMANDE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."TR_COMMANDE" (
    "ID" integer NOT NULL,
    "ID_COMMANDE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_SAISIE_ACHAT" integer DEFAULT 1,
    "ID_BON_RECEPTION" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."TR_COMMANDE" OWNER TO openconcerto;

--
-- TOC entry 931 (class 1259 OID 36395230)
-- Name: TR_COMMANDE_CLIENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."TR_COMMANDE_CLIENT" (
    "ID" integer NOT NULL,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1,
    "ID_COMMANDE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."TR_COMMANDE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 932 (class 1259 OID 36395239)
-- Name: TR_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."TR_COMMANDE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TR_COMMANDE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21745 (class 0 OID 0)
-- Dependencies: 932
-- Name: TR_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."TR_COMMANDE_CLIENT_ID_seq" OWNED BY "OpenConcerto42"."TR_COMMANDE_CLIENT"."ID";


--
-- TOC entry 933 (class 1259 OID 36395241)
-- Name: TR_COMMANDE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."TR_COMMANDE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TR_COMMANDE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21746 (class 0 OID 0)
-- Dependencies: 933
-- Name: TR_COMMANDE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."TR_COMMANDE_ID_seq" OWNED BY "OpenConcerto42"."TR_COMMANDE"."ID";


--
-- TOC entry 934 (class 1259 OID 36395243)
-- Name: TR_DEVIS; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."TR_DEVIS" (
    "ID" integer NOT NULL,
    "ID_DEVIS" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "ID_COMMANDE" integer DEFAULT 1,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."TR_DEVIS" OWNER TO openconcerto;

--
-- TOC entry 935 (class 1259 OID 36395252)
-- Name: TR_DEVIS_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."TR_DEVIS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TR_DEVIS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21747 (class 0 OID 0)
-- Dependencies: 935
-- Name: TR_DEVIS_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."TR_DEVIS_ID_seq" OWNED BY "OpenConcerto42"."TR_DEVIS"."ID";


--
-- TOC entry 936 (class 1259 OID 36395254)
-- Name: TR_SAISIE_ACHAT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."TR_SAISIE_ACHAT" (
    "ID" integer NOT NULL,
    "ID_SAISIE_ACHAT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_AVOIR_FOURNISSEUR" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."TR_SAISIE_ACHAT" OWNER TO openconcerto;

--
-- TOC entry 937 (class 1259 OID 36395261)
-- Name: TR_SAISIE_ACHAT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."TR_SAISIE_ACHAT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TR_SAISIE_ACHAT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21748 (class 0 OID 0)
-- Dependencies: 937
-- Name: TR_SAISIE_ACHAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."TR_SAISIE_ACHAT_ID_seq" OWNED BY "OpenConcerto42"."TR_SAISIE_ACHAT"."ID";


--
-- TOC entry 938 (class 1259 OID 36395263)
-- Name: TR_SAISIE_VENTE_FACTURE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."TR_SAISIE_VENTE_FACTURE" (
    "ID" integer NOT NULL,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "ID_COMMANDE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto42"."TR_SAISIE_VENTE_FACTURE" OWNER TO openconcerto;

--
-- TOC entry 939 (class 1259 OID 36395272)
-- Name: TR_SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."TR_SAISIE_VENTE_FACTURE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TR_SAISIE_VENTE_FACTURE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21749 (class 0 OID 0)
-- Dependencies: 939
-- Name: TR_SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."TR_SAISIE_VENTE_FACTURE_ID_seq" OWNED BY "OpenConcerto42"."TR_SAISIE_VENTE_FACTURE"."ID";


--
-- TOC entry 940 (class 1259 OID 36395274)
-- Name: TYPE_COMPTE_PCG; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."TYPE_COMPTE_PCG" (
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "RACINE" boolean DEFAULT false
);


ALTER TABLE "OpenConcerto42"."TYPE_COMPTE_PCG" OWNER TO openconcerto;

--
-- TOC entry 941 (class 1259 OID 36395282)
-- Name: TYPE_COMPTE_PCG_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."TYPE_COMPTE_PCG_ID_seq"
    START WITH 8
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TYPE_COMPTE_PCG_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21750 (class 0 OID 0)
-- Dependencies: 941
-- Name: TYPE_COMPTE_PCG_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."TYPE_COMPTE_PCG_ID_seq" OWNED BY "OpenConcerto42"."TYPE_COMPTE_PCG"."ID";


--
-- TOC entry 942 (class 1259 OID 36395284)
-- Name: TYPE_LETTRE_RELANCE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."TYPE_LETTRE_RELANCE" (
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8),
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "MODELE" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto42"."TYPE_LETTRE_RELANCE" OWNER TO openconcerto;

--
-- TOC entry 943 (class 1259 OID 36395295)
-- Name: TYPE_LETTRE_RELANCE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."TYPE_LETTRE_RELANCE_ID_seq"
    START WITH 3
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TYPE_LETTRE_RELANCE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21751 (class 0 OID 0)
-- Dependencies: 943
-- Name: TYPE_LETTRE_RELANCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."TYPE_LETTRE_RELANCE_ID_seq" OWNED BY "OpenConcerto42"."TYPE_LETTRE_RELANCE"."ID";


--
-- TOC entry 944 (class 1259 OID 36395297)
-- Name: TYPE_REGLEMENT; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."TYPE_REGLEMENT" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_COMPTE_PCE_FOURN" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ECHEANCE" boolean DEFAULT false,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_COMPTE_PCE_CLIENT" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "COMPTANT" boolean DEFAULT false
);


ALTER TABLE "OpenConcerto42"."TYPE_REGLEMENT" OWNER TO openconcerto;

--
-- TOC entry 945 (class 1259 OID 36395311)
-- Name: TYPE_REGLEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."TYPE_REGLEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."TYPE_REGLEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21752 (class 0 OID 0)
-- Dependencies: 945
-- Name: TYPE_REGLEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."TYPE_REGLEMENT_ID_seq" OWNED BY "OpenConcerto42"."TYPE_REGLEMENT"."ID";


--
-- TOC entry 946 (class 1259 OID 36395313)
-- Name: UNITE_VENTE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."UNITE_VENTE" (
    "ID" integer NOT NULL,
    "CODE" character varying(32) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "A_LA_PIECE" boolean DEFAULT false,
    "INFOS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."UNITE_VENTE" OWNER TO openconcerto;

--
-- TOC entry 947 (class 1259 OID 36395325)
-- Name: UNITE_VENTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."UNITE_VENTE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."UNITE_VENTE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21753 (class 0 OID 0)
-- Dependencies: 947
-- Name: UNITE_VENTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."UNITE_VENTE_ID_seq" OWNED BY "OpenConcerto42"."UNITE_VENTE"."ID";


--
-- TOC entry 948 (class 1259 OID 36395327)
-- Name: VARIABLE_SALARIE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."VARIABLE_SALARIE" (
    "HEURE_TRAV" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "CONGES_PRIS" real DEFAULT 0,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "HEURE_150" real DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "HEURE_200" real DEFAULT 0,
    "HEURE_110" real DEFAULT 0,
    "HEURE_ABS" real DEFAULT 0,
    "HEURE_125" real DEFAULT 0,
    "HEURE_110_DEFAULT_VAL" real DEFAULT 0,
    "CONGES_PRIS_DEFAULT_VAL" real DEFAULT 0,
    "HEURE_150_DEFAULT_VAL" real DEFAULT 0,
    "HEURE_ABS_DEFAULT_VAL" real DEFAULT 0,
    "HEURE_125_DEFAULT_VAL" real DEFAULT 0,
    "HEURE_200_DEFAULT_VAL" real DEFAULT 0,
    "IJSS_BRUT" real DEFAULT 0,
    "IJSS_BRUT_DEFAULT_VAL" real DEFAULT 0,
    "IJSS_NET" real DEFAULT 0,
    "IJSS_NET_DEFAULT_VAL" real DEFAULT 0,
    "FRAIS_PRO" real DEFAULT 0,
    "FRAIS_PRO_DEFAULT_VAL" real DEFAULT 0,
    "RBT_TRANSPORT" real DEFAULT 0,
    "RBT_TRANSPORT_DEFAULT_VAL" real DEFAULT 0
);


ALTER TABLE "OpenConcerto42"."VARIABLE_SALARIE" OWNER TO openconcerto;

--
-- TOC entry 949 (class 1259 OID 36395352)
-- Name: VARIABLE_SALARIE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."VARIABLE_SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."VARIABLE_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21754 (class 0 OID 0)
-- Dependencies: 949
-- Name: VARIABLE_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."VARIABLE_SALARIE_ID_seq" OWNED BY "OpenConcerto42"."VARIABLE_SALARIE"."ID";


--
-- TOC entry 950 (class 1259 OID 36395354)
-- Name: VILLE; Type: TABLE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE TABLE "OpenConcerto42"."VILLE" (
    "ID" integer NOT NULL,
    "X_LAMBERT" bigint DEFAULT 0,
    "Y_LAMBERT" bigint DEFAULT 0,
    "POPULATION" bigint DEFAULT 0,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "CODE_POSTAL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto42"."VILLE" OWNER TO openconcerto;

--
-- TOC entry 951 (class 1259 OID 36395367)
-- Name: VILLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto42; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto42"."VILLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto42"."VILLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21755 (class 0 OID 0)
-- Dependencies: 951
-- Name: VILLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto42"."VILLE_ID_seq" OWNED BY "OpenConcerto42"."VILLE"."ID";


--
-- TOC entry 952 (class 1259 OID 36395369)
-- Name: ACOMPTE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ACOMPTE" (
    "ID_SALARIE" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "MONTANT" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."ACOMPTE" OWNER TO openconcerto;

--
-- TOC entry 953 (class 1259 OID 36395378)
-- Name: ACOMPTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ACOMPTE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ACOMPTE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21756 (class 0 OID 0)
-- Dependencies: 953
-- Name: ACOMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ACOMPTE_ID_seq" OWNED BY "OpenConcerto48"."ACOMPTE"."ID";


--
-- TOC entry 954 (class 1259 OID 36395380)
-- Name: ADRESSE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ADRESSE" (
    "RUE" character varying(2048) DEFAULT ''::text,
    "CEDEX" integer,
    "DEST" character varying(2048) DEFAULT ''::text,
    "ID_ADRESSE" integer NOT NULL,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "PAYS" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_CLIENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "HAS_CEDEX" boolean DEFAULT false,
    "VILLE" character varying(2048) DEFAULT ''::text,
    "CODE_POSTAL" character varying(256) DEFAULT ''::character varying,
    "PROVINCE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "LIBELLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TYPE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "EMAIL_CONTACT" character varying(256) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto48"."ADRESSE" OWNER TO openconcerto;

--
-- TOC entry 955 (class 1259 OID 36395400)
-- Name: ADRESSE_ID_ADRESSE_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ADRESSE_ID_ADRESSE_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ADRESSE_ID_ADRESSE_seq" OWNER TO openconcerto;

--
-- TOC entry 21757 (class 0 OID 0)
-- Dependencies: 955
-- Name: ADRESSE_ID_ADRESSE_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ADRESSE_ID_ADRESSE_seq" OWNED BY "OpenConcerto48"."ADRESSE"."ID_ADRESSE";


--
-- TOC entry 956 (class 1259 OID 36395402)
-- Name: ARRET_TRAVAIL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ARRET_TRAVAIL" (
    "ID" integer NOT NULL,
    "ID_SALARIE" integer DEFAULT 1,
    "DATE_DERNIER_JOUR_TRAV" timestamp without time zone,
    "DATE_FIN_PREV" timestamp without time zone,
    "SUBROGATION" boolean DEFAULT false NOT NULL,
    "DATE_DEBUT_SUBROGATION" timestamp without time zone,
    "DATE_FIN_SUBROGATION" timestamp without time zone,
    "ID_MOTIF_ARRET_TRAVAIL" integer DEFAULT 1,
    "ID_MOTIF_REPRISE_ARRET_TRAVAIL" integer DEFAULT 1,
    "DATE_REPRISE" timestamp without time zone,
    "DATE_ACCIDENT" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "DATE" timestamp without time zone,
    "COMMENTAIRES" character varying(2048) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto48"."ARRET_TRAVAIL" OWNER TO openconcerto;

--
-- TOC entry 957 (class 1259 OID 36395415)
-- Name: ARRET_TRAVAIL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ARRET_TRAVAIL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ARRET_TRAVAIL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21758 (class 0 OID 0)
-- Dependencies: 957
-- Name: ARRET_TRAVAIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ARRET_TRAVAIL_ID_seq" OWNED BY "OpenConcerto48"."ARRET_TRAVAIL"."ID";


--
-- TOC entry 958 (class 1259 OID 36395417)
-- Name: ARTICLE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ARTICLE" (
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "CREATION_AUTO" boolean DEFAULT false,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8),
    "PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_STOCK" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "CODE" character varying(45) DEFAULT ''::text,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "SERVICE" boolean DEFAULT false,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "OBSOLETE" boolean DEFAULT false,
    "POIDS" real DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "CODE_BARRE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "GESTION_STOCK" boolean DEFAULT true,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "QTE_MIN" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_DEVISE_HA" integer DEFAULT 1,
    "PA_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "SKU" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ID_TAXE_COMPLEMENTAIRE" integer DEFAULT 1,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "ID_FABRICANT" integer DEFAULT 1,
    "TARE" numeric(16,8) DEFAULT 0,
    "IFCO" integer DEFAULT 0 NOT NULL,
    "MASQUE_CAISSE" boolean DEFAULT false NOT NULL,
    "ADDITIONAL_TICKET_COPY" boolean DEFAULT false NOT NULL,
    "MATIERE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1 NOT NULL,
    "ID_COUT_REVIENT" integer DEFAULT 1,
    "MARGE_WITH_COUT_REVIENT" boolean DEFAULT false NOT NULL,
    "AUTO_PRIX_ACHAT_NOMENCLATURE" boolean DEFAULT false NOT NULL,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."ARTICLE" OWNER TO openconcerto;

--
-- TOC entry 1296 (class 1259 OID 36414975)
-- Name: ARTICLE_CATEGORIE_COMPTABLE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ARTICLE_CATEGORIE_COMPTABLE" (
    "ID" integer NOT NULL,
    "ID_CATEGORIE_COMPTABLE" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_TAXE_ACHAT" integer DEFAULT 1,
    "ID_TAXE_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."ARTICLE_CATEGORIE_COMPTABLE" OWNER TO openconcerto;

--
-- TOC entry 1295 (class 1259 OID 36414973)
-- Name: ARTICLE_CATEGORIE_COMPTABLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ARTICLE_CATEGORIE_COMPTABLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ARTICLE_CATEGORIE_COMPTABLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21759 (class 0 OID 0)
-- Dependencies: 1295
-- Name: ARTICLE_CATEGORIE_COMPTABLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ARTICLE_CATEGORIE_COMPTABLE_ID_seq" OWNED BY "OpenConcerto48"."ARTICLE_CATEGORIE_COMPTABLE"."ID";


--
-- TOC entry 959 (class 1259 OID 36395474)
-- Name: ARTICLE_CODE_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ARTICLE_CODE_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "CODE" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."ARTICLE_CODE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 960 (class 1259 OID 36395485)
-- Name: ARTICLE_CODE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ARTICLE_CODE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ARTICLE_CODE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21760 (class 0 OID 0)
-- Dependencies: 960
-- Name: ARTICLE_CODE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ARTICLE_CODE_CLIENT_ID_seq" OWNED BY "OpenConcerto48"."ARTICLE_CODE_CLIENT"."ID";


--
-- TOC entry 961 (class 1259 OID 36395487)
-- Name: ARTICLE_DESIGNATION; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ARTICLE_DESIGNATION" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1,
    "NOM" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."ARTICLE_DESIGNATION" OWNER TO openconcerto;

--
-- TOC entry 962 (class 1259 OID 36395498)
-- Name: ARTICLE_DESIGNATION_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ARTICLE_DESIGNATION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ARTICLE_DESIGNATION_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21761 (class 0 OID 0)
-- Dependencies: 962
-- Name: ARTICLE_DESIGNATION_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ARTICLE_DESIGNATION_ID_seq" OWNED BY "OpenConcerto48"."ARTICLE_DESIGNATION"."ID";


--
-- TOC entry 963 (class 1259 OID 36395500)
-- Name: ARTICLE_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ARTICLE_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_ARTICLE_PARENT" integer DEFAULT 1,
    "QTE" integer DEFAULT 1 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1 NOT NULL,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."ARTICLE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 964 (class 1259 OID 36395510)
-- Name: ARTICLE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ARTICLE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ARTICLE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21762 (class 0 OID 0)
-- Dependencies: 964
-- Name: ARTICLE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ARTICLE_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."ARTICLE_ELEMENT"."ID";


--
-- TOC entry 965 (class 1259 OID 36395512)
-- Name: ARTICLE_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ARTICLE_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying NOT NULL,
    "CODE_BARRE" character varying(45) DEFAULT ''::character varying NOT NULL,
    "CODE_DOUANIER" character varying(45) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0,
    "PRIX_METRIQUE_HA_2" numeric(16,8) DEFAULT 0,
    "PRIX_METRIQUE_HA_3" numeric(16,8) DEFAULT 0,
    "PRIX_METRIQUE_VT_1" numeric(16,8) DEFAULT 0,
    "PRIX_METRIQUE_VT_2" numeric(16,8) DEFAULT 0,
    "PRIX_METRIQUE_VT_3" numeric(16,8) DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PA_DEVISE" numeric(16,8) DEFAULT 0,
    "PV_U_DEVISE" numeric(16,8) DEFAULT 0,
    "PA_HT" numeric(16,8) DEFAULT 0,
    "PV_HT" numeric(16,8) DEFAULT 0,
    "PV_TTC" numeric(16,2) DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE_FOURNISSEUR" integer DEFAULT 1,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_DEVISE_HA" integer DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "SERVICE" boolean DEFAULT false NOT NULL,
    "OBSOLETE" boolean DEFAULT false NOT NULL,
    "GESTION_STOCK" boolean DEFAULT false NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1 NOT NULL,
    "QTE_MIN" integer DEFAULT 1 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."ARTICLE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 966 (class 1259 OID 36395561)
-- Name: ARTICLE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ARTICLE_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ARTICLE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21763 (class 0 OID 0)
-- Dependencies: 966
-- Name: ARTICLE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ARTICLE_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto48"."ARTICLE_FOURNISSEUR"."ID";


--
-- TOC entry 1298 (class 1259 OID 36415028)
-- Name: ARTICLE_FOURNISSEUR_SECONDAIRE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ARTICLE_FOURNISSEUR_SECONDAIRE" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."ARTICLE_FOURNISSEUR_SECONDAIRE" OWNER TO openconcerto;

--
-- TOC entry 1297 (class 1259 OID 36415026)
-- Name: ARTICLE_FOURNISSEUR_SECONDAIRE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ARTICLE_FOURNISSEUR_SECONDAIRE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ARTICLE_FOURNISSEUR_SECONDAIRE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21764 (class 0 OID 0)
-- Dependencies: 1297
-- Name: ARTICLE_FOURNISSEUR_SECONDAIRE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ARTICLE_FOURNISSEUR_SECONDAIRE_ID_seq" OWNED BY "OpenConcerto48"."ARTICLE_FOURNISSEUR_SECONDAIRE"."ID";


--
-- TOC entry 967 (class 1259 OID 36395563)
-- Name: ARTICLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ARTICLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21765 (class 0 OID 0)
-- Dependencies: 967
-- Name: ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ARTICLE_ID_seq" OWNED BY "OpenConcerto48"."ARTICLE"."ID";


--
-- TOC entry 968 (class 1259 OID 36395565)
-- Name: ARTICLE_TARIF; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ARTICLE_TARIF" (
    "ID" integer NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "ID_TARIF" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "POURCENT_REMISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE" integer DEFAULT 1 NOT NULL
);


ALTER TABLE "OpenConcerto48"."ARTICLE_TARIF" OWNER TO openconcerto;

--
-- TOC entry 1292 (class 1259 OID 36414843)
-- Name: ARTICLE_TARIF_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ARTICLE_TARIF_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "REF_FOURNISSEUR" character varying(500) DEFAULT ''::character varying NOT NULL,
    "TYPE_REAPPRO" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CONDITIONS" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ACHETEUR" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_PAYS_ORIGINE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRIX_ACHAT_DEVISE_F" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_ACHAT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE" integer DEFAULT 1 NOT NULL,
    "DATE_PRIX" timestamp without time zone,
    "DELAI_REAPPRO" integer DEFAULT 0 NOT NULL,
    "DELAI_TRANSPORT" integer DEFAULT 0 NOT NULL,
    "PRIORITE" integer DEFAULT 0 NOT NULL,
    "COEF_PRIX_MINI" numeric(16,2) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."ARTICLE_TARIF_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 1291 (class 1259 OID 36414841)
-- Name: ARTICLE_TARIF_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ARTICLE_TARIF_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ARTICLE_TARIF_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21766 (class 0 OID 0)
-- Dependencies: 1291
-- Name: ARTICLE_TARIF_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ARTICLE_TARIF_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto48"."ARTICLE_TARIF_FOURNISSEUR"."ID";


--
-- TOC entry 969 (class 1259 OID 36395581)
-- Name: ARTICLE_TARIF_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ARTICLE_TARIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ARTICLE_TARIF_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21767 (class 0 OID 0)
-- Dependencies: 969
-- Name: ARTICLE_TARIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ARTICLE_TARIF_ID_seq" OWNED BY "OpenConcerto48"."ARTICLE_TARIF"."ID";


--
-- TOC entry 970 (class 1259 OID 36395583)
-- Name: ASSOCIATION_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ASSOCIATION_ANALYTIQUE" (
    "ID" integer NOT NULL,
    "ID_ECRITURE" integer DEFAULT 1,
    "ID_SAISIE_KM_ELEMENT" integer DEFAULT 1,
    "ID_POSTE_ANALYTIQUE" integer DEFAULT 1,
    "POURCENT" numeric(16,8) DEFAULT 100,
    "MONTANT" bigint DEFAULT 0,
    "GESTION_AUTO" boolean DEFAULT false NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."ASSOCIATION_ANALYTIQUE" OWNER TO openconcerto;

--
-- TOC entry 971 (class 1259 OID 36395594)
-- Name: ASSOCIATION_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ASSOCIATION_ANALYTIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ASSOCIATION_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21768 (class 0 OID 0)
-- Dependencies: 971
-- Name: ASSOCIATION_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ASSOCIATION_ANALYTIQUE_ID_seq" OWNED BY "OpenConcerto48"."ASSOCIATION_ANALYTIQUE"."ID";


--
-- TOC entry 972 (class 1259 OID 36395596)
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ASSOCIATION_COMPTE_ANALYTIQUE" (
    "ORDRE" numeric(16,8),
    "ID_AXE_ANALYTIQUE" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_REPARTITION_ANALYTIQUE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."ASSOCIATION_COMPTE_ANALYTIQUE" OWNER TO openconcerto;

--
-- TOC entry 973 (class 1259 OID 36395605)
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21769 (class 0 OID 0)
-- Dependencies: 973
-- Name: ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq" OWNED BY "OpenConcerto48"."ASSOCIATION_COMPTE_ANALYTIQUE"."ID";


--
-- TOC entry 974 (class 1259 OID 36395607)
-- Name: ATTACHMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ATTACHMENT" (
    "ID" integer NOT NULL,
    "SOURCE_TABLE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "SOURCE_ID" integer DEFAULT 0 NOT NULL,
    "NAME" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MIMETYPE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FILENAME" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FILESIZE" bigint DEFAULT 0 NOT NULL,
    "STORAGE_PATH" character varying(256) DEFAULT ''::character varying NOT NULL,
    "STORAGE_FILENAME" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DIRECTORY" character varying(256) DEFAULT ''::character varying NOT NULL,
    "THUMBNAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "THUMBNAIL_WIDTH" integer DEFAULT 32 NOT NULL,
    "THUMBNAIL_HEIGHT" integer DEFAULT 32 NOT NULL,
    "TAG" character varying(128) DEFAULT ''::character varying NOT NULL,
    "VERSION" integer DEFAULT 0 NOT NULL,
    "HASH" character varying(32) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_PARENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."ATTACHMENT" OWNER TO openconcerto;

--
-- TOC entry 975 (class 1259 OID 36395631)
-- Name: ATTACHMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ATTACHMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ATTACHMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21770 (class 0 OID 0)
-- Dependencies: 975
-- Name: ATTACHMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ATTACHMENT_ID_seq" OWNED BY "OpenConcerto48"."ATTACHMENT"."ID";


--
-- TOC entry 976 (class 1259 OID 36395633)
-- Name: AVOIR_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."AVOIR_CLIENT" (
    "MONTANT_TTC" bigint DEFAULT 0,
    "ENVOYE_EN_AFFACTURAGE" boolean DEFAULT false,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1,
    "ID_CONTACT" integer DEFAULT 1,
    "MONTANT_RESTANT" bigint DEFAULT 0,
    "AFFACTURAGE" boolean DEFAULT false,
    "MODIFICATION_DATE" timestamp without time zone,
    "MONTANT_TVA" bigint DEFAULT 0,
    "MONTANT_HT" bigint DEFAULT 0,
    "REMISE_HT" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "SOLDE" boolean DEFAULT false,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "DATE_ENVOI_AFFACTURAGE" date,
    "MONTANT_SOLDE" bigint DEFAULT 0,
    "MOTIF" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ORDRE" numeric(16,8),
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "A_DEDUIRE" boolean DEFAULT false,
    "PORT_HT" bigint DEFAULT 0,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer,
    "MONTANT_SERVICE" bigint DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "DATE" date,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "AFFACTURE" boolean DEFAULT false,
    "COMPTE_SERVICE_AUTO" boolean DEFAULT false,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_ADRESSE" integer DEFAULT 1,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "T_DEVISE" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "INFOS" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ID_ADRESSE_LIVRAISON" integer DEFAULT 1,
    "POURCENT_REMISE" numeric(12,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_CLIENT_DEPARTEMENT" integer DEFAULT 1,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."AVOIR_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 977 (class 1259 OID 36395674)
-- Name: AVOIR_CLIENT_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."AVOIR_CLIENT_ELEMENT" (
    "CODE" character varying(45) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "POURCENT_SERVICE" character varying(2048) DEFAULT ''::text,
    "CODE_MISSION" character varying(45) DEFAULT ''::character varying,
    "SOUS_ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "DATE_FIN" timestamp without time zone,
    "Q18" boolean DEFAULT false,
    "ID_STYLE" integer DEFAULT 1,
    "INFOS_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "REFERENTIEL_INSPECTION" character varying(2048) DEFAULT ''::text,
    "OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "DATE" timestamp without time zone,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "SERVICE" boolean DEFAULT false,
    "MONTANT_REVISABLE" boolean DEFAULT false,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "SITUATION_ADMIN" character varying(2048) DEFAULT ''::text,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "POURCENT_ACOMPTE" numeric(6,2) DEFAULT 100 NOT NULL,
    "MONTANT_INITIAL" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "INDICE_0" bigint DEFAULT 0,
    "ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_CONTACT" integer DEFAULT 1,
    "QTE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "POURCENT_REMISE" numeric(12,8) DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "LOCAL_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "NOM_MISSION" character varying(256) DEFAULT ''::character varying,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "TARIF_Q18_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "POIDS" real DEFAULT 0,
    "INDICE_N" bigint DEFAULT 0,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ACOMPTE" boolean DEFAULT false,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_POIDS" real DEFAULT 0,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_T_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "T_POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "NB_COLIS" integer DEFAULT 0,
    "MONTANT_REMISE" numeric(16,8),
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "RETOUR_STOCK" boolean DEFAULT false NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."AVOIR_CLIENT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 978 (class 1259 OID 36395752)
-- Name: AVOIR_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."AVOIR_CLIENT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."AVOIR_CLIENT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21771 (class 0 OID 0)
-- Dependencies: 978
-- Name: AVOIR_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."AVOIR_CLIENT_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."AVOIR_CLIENT_ELEMENT"."ID";


--
-- TOC entry 979 (class 1259 OID 36395754)
-- Name: AVOIR_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."AVOIR_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."AVOIR_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21772 (class 0 OID 0)
-- Dependencies: 979
-- Name: AVOIR_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."AVOIR_CLIENT_ID_seq" OWNED BY "OpenConcerto48"."AVOIR_CLIENT"."ID";


--
-- TOC entry 980 (class 1259 OID 36395756)
-- Name: AVOIR_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."AVOIR_FOURNISSEUR" (
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "IMMO" boolean DEFAULT false,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "A_DEDUIRE" boolean DEFAULT false,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "MONTANT_TTC" bigint DEFAULT 0,
    "MONTANT_TVA" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "SOLDE" boolean DEFAULT false,
    "ID_USER_COMMON_CREATE" integer,
    "DATE" date,
    "MONTANT_HT" bigint DEFAULT 0,
    "INFOS" character varying(1024) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto48"."AVOIR_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 981 (class 1259 OID 36395778)
-- Name: AVOIR_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."AVOIR_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."AVOIR_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21773 (class 0 OID 0)
-- Dependencies: 981
-- Name: AVOIR_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."AVOIR_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto48"."AVOIR_FOURNISSEUR"."ID";


--
-- TOC entry 982 (class 1259 OID 36395780)
-- Name: AXE_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."AXE_ANALYTIQUE" (
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "TYPE" character varying(256) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto48"."AXE_ANALYTIQUE" OWNER TO openconcerto;

--
-- TOC entry 983 (class 1259 OID 36395791)
-- Name: AXE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."AXE_ANALYTIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."AXE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21774 (class 0 OID 0)
-- Dependencies: 983
-- Name: AXE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."AXE_ANALYTIQUE_ID_seq" OWNED BY "OpenConcerto48"."AXE_ANALYTIQUE"."ID";


--
-- TOC entry 984 (class 1259 OID 36395793)
-- Name: AYANT_DROIT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."AYANT_DROIT" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_SALARIE" integer DEFAULT 1,
    "ID_AYANT_DROIT_TYPE" integer DEFAULT 1,
    "REGIME_ALSACE" boolean DEFAULT false NOT NULL,
    "NIR" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRENOMS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_ORGANISME_AFFILIATION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_OPTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NIR_OUVRANT_DROIT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DATE_DEBUT_RATTACHEMENT" timestamp without time zone,
    "DATE_FIN_RATTACHEMENT" timestamp without time zone,
    "DATE_NAISSANCE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."AYANT_DROIT" OWNER TO openconcerto;

--
-- TOC entry 985 (class 1259 OID 36395810)
-- Name: AYANT_DROIT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."AYANT_DROIT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."AYANT_DROIT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21775 (class 0 OID 0)
-- Dependencies: 985
-- Name: AYANT_DROIT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."AYANT_DROIT_ID_seq" OWNED BY "OpenConcerto48"."AYANT_DROIT"."ID";


--
-- TOC entry 986 (class 1259 OID 36395812)
-- Name: BANQUE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."BANQUE" (
    "ID" integer NOT NULL,
    "ID_JOURNAL" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RUE" character varying(45) DEFAULT ''::character varying NOT NULL,
    "RUE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "IBAN" character varying(256) DEFAULT ''::character varying NOT NULL,
    "BIC" character varying(256) DEFAULT ''::character varying NOT NULL,
    "VOIE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "VILLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DOMICILIATION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "AFFACTURAGE" boolean DEFAULT false NOT NULL,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."BANQUE" OWNER TO openconcerto;

--
-- TOC entry 987 (class 1259 OID 36395833)
-- Name: BANQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."BANQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."BANQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21776 (class 0 OID 0)
-- Dependencies: 987
-- Name: BANQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."BANQUE_ID_seq" OWNED BY "OpenConcerto48"."BANQUE"."ID";


--
-- TOC entry 988 (class 1259 OID 36395835)
-- Name: BON_DE_LIVRAISON; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."BON_DE_LIVRAISON" (
    "ARCHIVE" integer DEFAULT 0,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "TOTAL_POIDS" real DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "TOTAL_HT" bigint DEFAULT 0,
    "ORDRE" numeric(16,8),
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "DATE" date,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "TOTAL_TTC" bigint DEFAULT 0,
    "TOTAL_TVA" bigint DEFAULT 0,
    "SOURCE" character varying(512) DEFAULT ''::character varying NOT NULL,
    "IDSOURCE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "DATE_LIVRAISON" date,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_ADRESSE_LIVRAISON" integer DEFAULT 1,
    "POURCENT_REMISE" numeric(12,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_CONTACT" integer DEFAULT 1,
    "ID_CLIENT_DEPARTEMENT" integer DEFAULT 1,
    "TOTAL_DEVISE" bigint DEFAULT 0 NOT NULL,
    "TOTAL_SERVICE" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "PORT_HT" bigint DEFAULT 0 NOT NULL,
    "REMISE_HT" bigint DEFAULT 0 NOT NULL,
    "CREATE_VIRTUAL_STOCK" boolean DEFAULT true NOT NULL,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "FRAIS_DOCUMENT_HT" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE_FRAIS_DOCUMENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."BON_DE_LIVRAISON" OWNER TO openconcerto;

--
-- TOC entry 989 (class 1259 OID 36395869)
-- Name: BON_DE_LIVRAISON_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."BON_DE_LIVRAISON_ELEMENT" (
    "T_POIDS_LIVREE" real DEFAULT 0,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_STYLE" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "T_POIDS" real DEFAULT 0,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "POIDS" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1,
    "QTE_LIVREE" integer DEFAULT 0,
    "QTE" integer DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "SERVICE" boolean DEFAULT false,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_SAISIE_VENTE_FACTURE_ELEMENT" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "QTE_A_LIVRER" integer DEFAULT 0,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "POURCENT_REMISE" numeric(12,8) DEFAULT 0,
    "PV_T_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "T_POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "NB_COLIS" integer DEFAULT 0,
    "MONTANT_REMISE" numeric(16,8),
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_COMMANDE_CLIENT_ELEMENT" integer DEFAULT 1,
    "ID_DEPOT_STOCK" integer DEFAULT 1,
    "ID_DEVIS_ELEMENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."BON_DE_LIVRAISON_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 990 (class 1259 OID 36395931)
-- Name: BON_DE_LIVRAISON_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."BON_DE_LIVRAISON_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."BON_DE_LIVRAISON_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21777 (class 0 OID 0)
-- Dependencies: 990
-- Name: BON_DE_LIVRAISON_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."BON_DE_LIVRAISON_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."BON_DE_LIVRAISON_ELEMENT"."ID";


--
-- TOC entry 991 (class 1259 OID 36395933)
-- Name: BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."BON_DE_LIVRAISON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."BON_DE_LIVRAISON_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21778 (class 0 OID 0)
-- Dependencies: 991
-- Name: BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."BON_DE_LIVRAISON_ID_seq" OWNED BY "OpenConcerto48"."BON_DE_LIVRAISON"."ID";


--
-- TOC entry 992 (class 1259 OID 36395935)
-- Name: BON_RECEPTION; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."BON_RECEPTION" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "TOTAL_TTC" bigint DEFAULT 0,
    "DATE" date,
    "TOTAL_POIDS" real DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "TOTAL_HT" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID_COMMANDE" integer DEFAULT 1,
    "TOTAL_TVA" bigint DEFAULT 0,
    "ID_DEVISE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "CREATE_VIRTUAL_STOCK" boolean DEFAULT true NOT NULL,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "PORT_HT" bigint DEFAULT 0 NOT NULL,
    "REMISE_HT" bigint DEFAULT 0 NOT NULL
);


ALTER TABLE "OpenConcerto48"."BON_RECEPTION" OWNER TO openconcerto;

--
-- TOC entry 993 (class 1259 OID 36395958)
-- Name: BON_RECEPTION_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."BON_RECEPTION_ELEMENT" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "ID_TAXE" integer DEFAULT 1,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "T_PA_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "ORDRE" numeric(16,8),
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_STYLE" integer DEFAULT 1,
    "ID_BON_RECEPTION" integer DEFAULT 1,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "T_POIDS" real DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "POIDS" real DEFAULT 0,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID" integer NOT NULL,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "QTE_ACHAT" integer DEFAULT 1,
    "PA_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "PA_DEVISE_T" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_CODE_FOURNISSEUR" integer DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_COMMANDE_ELEMENT" integer DEFAULT 1,
    "ID_DEMANDE_ACHAT_ELEMENT" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "QTE_ORIGINE" integer,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."BON_RECEPTION_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 994 (class 1259 OID 36396011)
-- Name: BON_RECEPTION_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."BON_RECEPTION_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."BON_RECEPTION_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21779 (class 0 OID 0)
-- Dependencies: 994
-- Name: BON_RECEPTION_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."BON_RECEPTION_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."BON_RECEPTION_ELEMENT"."ID";


--
-- TOC entry 995 (class 1259 OID 36396013)
-- Name: BON_RECEPTION_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."BON_RECEPTION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."BON_RECEPTION_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21780 (class 0 OID 0)
-- Dependencies: 995
-- Name: BON_RECEPTION_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."BON_RECEPTION_ID_seq" OWNED BY "OpenConcerto48"."BON_RECEPTION"."ID";


--
-- TOC entry 996 (class 1259 OID 36396015)
-- Name: CAISSE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CAISSE" (
    "ARCHIVE" integer DEFAULT 0,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_DERNIERE_CLOTURE" integer
);


ALTER TABLE "OpenConcerto48"."CAISSE" OWNER TO openconcerto;

--
-- TOC entry 997 (class 1259 OID 36396025)
-- Name: CAISSE_CLOTURE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CAISSE_CLOTURE" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_ENTREE_JOURNAL" integer,
    "PERIODE" character varying(32) DEFAULT ''::character varying NOT NULL,
    "DEBUT" date NOT NULL,
    "FIN" date NOT NULL,
    "TOTAL_TTC" numeric(16,6) DEFAULT 0 NOT NULL,
    "PREMIER_TICKET" character varying(64) DEFAULT NULL::character varying,
    "PREMIER_TICKET_HASH" character varying(128) DEFAULT NULL::character varying,
    "DERNIER_TICKET" character varying(64) DEFAULT NULL::character varying,
    "DERNIER_TICKET_HASH" character varying(128) DEFAULT NULL::character varying,
    "ARCHIVE" integer DEFAULT 0 NOT NULL
);


ALTER TABLE "OpenConcerto48"."CAISSE_CLOTURE" OWNER TO openconcerto;

--
-- TOC entry 998 (class 1259 OID 36396037)
-- Name: CAISSE_CLOTURE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CAISSE_CLOTURE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CAISSE_CLOTURE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21781 (class 0 OID 0)
-- Dependencies: 998
-- Name: CAISSE_CLOTURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CAISSE_CLOTURE_ID_seq" OWNED BY "OpenConcerto48"."CAISSE_CLOTURE"."ID";


--
-- TOC entry 999 (class 1259 OID 36396039)
-- Name: CAISSE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CAISSE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CAISSE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21782 (class 0 OID 0)
-- Dependencies: 999
-- Name: CAISSE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CAISSE_ID_seq" OWNED BY "OpenConcerto48"."CAISSE"."ID";


--
-- TOC entry 1000 (class 1259 OID 36396041)
-- Name: CAISSE_JOURNAL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CAISSE_JOURNAL" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_CAISSE" integer DEFAULT 1,
    "DATE" timestamp without time zone,
    "ID_USER" integer DEFAULT 1,
    "EVT" character varying(128) DEFAULT ''::character varying NOT NULL,
    "CREATOR" character varying(128) DEFAULT ''::character varying NOT NULL,
    "CREATOR_VERSION" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "HOST_NAME" character varying(128),
    "HOST_USER" character varying(128)
);


ALTER TABLE "OpenConcerto48"."CAISSE_JOURNAL" OWNER TO openconcerto;

--
-- TOC entry 1001 (class 1259 OID 36396055)
-- Name: CAISSE_JOURNAL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CAISSE_JOURNAL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CAISSE_JOURNAL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21783 (class 0 OID 0)
-- Dependencies: 1001
-- Name: CAISSE_JOURNAL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CAISSE_JOURNAL_ID_seq" OWNED BY "OpenConcerto48"."CAISSE_JOURNAL"."ID";


--
-- TOC entry 1002 (class 1259 OID 36396057)
-- Name: CALENDAR_ITEM; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CALENDAR_ITEM" (
    "ID" integer NOT NULL,
    "START" timestamp without time zone,
    "END" timestamp without time zone,
    "DURATION_S" bigint DEFAULT 0 NOT NULL,
    "SUMMARY" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "DESCRIPTION" character varying(8192) DEFAULT ''::character varying NOT NULL,
    "FLAGS" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "STATUS" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_CALENDAR_ITEM_GROUP" integer,
    "SOURCE_ID" bigint,
    "SOURCE_TABLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "UID" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "LOCATION" character varying(4096) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto48"."CALENDAR_ITEM" OWNER TO openconcerto;

--
-- TOC entry 1003 (class 1259 OID 36396073)
-- Name: CALENDAR_ITEM_GROUP; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CALENDAR_ITEM_GROUP" (
    "ID" integer NOT NULL,
    "NAME" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "DESCRIPTION" character varying(8192) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."CALENDAR_ITEM_GROUP" OWNER TO openconcerto;

--
-- TOC entry 1004 (class 1259 OID 36396083)
-- Name: CALENDAR_ITEM_GROUP_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CALENDAR_ITEM_GROUP_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CALENDAR_ITEM_GROUP_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21784 (class 0 OID 0)
-- Dependencies: 1004
-- Name: CALENDAR_ITEM_GROUP_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CALENDAR_ITEM_GROUP_ID_seq" OWNED BY "OpenConcerto48"."CALENDAR_ITEM_GROUP"."ID";


--
-- TOC entry 1005 (class 1259 OID 36396085)
-- Name: CALENDAR_ITEM_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CALENDAR_ITEM_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CALENDAR_ITEM_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21785 (class 0 OID 0)
-- Dependencies: 1005
-- Name: CALENDAR_ITEM_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CALENDAR_ITEM_ID_seq" OWNED BY "OpenConcerto48"."CALENDAR_ITEM"."ID";


--
-- TOC entry 1006 (class 1259 OID 36396087)
-- Name: CATEGORIE_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CATEGORIE_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."CATEGORIE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 1007 (class 1259 OID 36396096)
-- Name: CATEGORIE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CATEGORIE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CATEGORIE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21786 (class 0 OID 0)
-- Dependencies: 1007
-- Name: CATEGORIE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CATEGORIE_CLIENT_ID_seq" OWNED BY "OpenConcerto48"."CATEGORIE_CLIENT"."ID";


--
-- TOC entry 1294 (class 1259 OID 36414883)
-- Name: CATEGORIE_COMPTABLE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CATEGORIE_COMPTABLE" (
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_TAXE_VENTE" integer DEFAULT 1,
    "ID_TAXE_ACHAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."CATEGORIE_COMPTABLE" OWNER TO openconcerto;

--
-- TOC entry 1293 (class 1259 OID 36414881)
-- Name: CATEGORIE_COMPTABLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CATEGORIE_COMPTABLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CATEGORIE_COMPTABLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21787 (class 0 OID 0)
-- Dependencies: 1293
-- Name: CATEGORIE_COMPTABLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CATEGORIE_COMPTABLE_ID_seq" OWNED BY "OpenConcerto48"."CATEGORIE_COMPTABLE"."ID";


--
-- TOC entry 1008 (class 1259 OID 36396098)
-- Name: CHEQUE_AVOIR_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CHEQUE_AVOIR_CLIENT" (
    "CREATION_DATE" timestamp without time zone,
    "DATE_AVOIR" date,
    "DECAISSE" boolean DEFAULT false,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "REG_COMPTA" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_USER_COMMON_CREATE" integer,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ETS" character varying(2048) DEFAULT ''::text,
    "DATE" date,
    "DATE_DECAISSE" date,
    "MONTANT" bigint DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "DATE_MIN_DECAISSE" date,
    "ID_BANQUE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."CHEQUE_AVOIR_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 1009 (class 1259 OID 36396113)
-- Name: CHEQUE_AVOIR_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CHEQUE_AVOIR_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CHEQUE_AVOIR_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21788 (class 0 OID 0)
-- Dependencies: 1009
-- Name: CHEQUE_AVOIR_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CHEQUE_AVOIR_CLIENT_ID_seq" OWNED BY "OpenConcerto48"."CHEQUE_AVOIR_CLIENT"."ID";


--
-- TOC entry 1010 (class 1259 OID 36396115)
-- Name: CHEQUE_A_ENCAISSER; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CHEQUE_A_ENCAISSER" (
    "DATE_MIN_DEPOT" date,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer,
    "MONTANT" bigint DEFAULT 0,
    "ETS" character varying(2048) DEFAULT ''::text,
    "DATE" date,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "DATE_VENTE" date,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "DATE_DEPOT" date,
    "ENCAISSE" boolean DEFAULT false,
    "REG_COMPTA" boolean DEFAULT false,
    "ID_BANQUE" integer DEFAULT 1,
    "SANS_VALEUR_ENCAISSEMENT" boolean DEFAULT false NOT NULL,
    "TIERS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_COMPTE_PCE_TIERS" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."CHEQUE_A_ENCAISSER" OWNER TO openconcerto;

--
-- TOC entry 1011 (class 1259 OID 36396131)
-- Name: CHEQUE_A_ENCAISSER_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CHEQUE_A_ENCAISSER_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CHEQUE_A_ENCAISSER_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21789 (class 0 OID 0)
-- Dependencies: 1011
-- Name: CHEQUE_A_ENCAISSER_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CHEQUE_A_ENCAISSER_ID_seq" OWNED BY "OpenConcerto48"."CHEQUE_A_ENCAISSER"."ID";


--
-- TOC entry 1012 (class 1259 OID 36396133)
-- Name: CHEQUE_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CHEQUE_FOURNISSEUR" (
    "DATE_DECAISSE" date,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "DATE_MIN_DECAISSE" date,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "REG_COMPTA" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "DATE_ACHAT" date,
    "CREATION_DATE" timestamp without time zone,
    "DATE" date,
    "MONTANT" bigint DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "DECAISSE" boolean DEFAULT false,
    "ETS" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "ID_BANQUE" integer DEFAULT 1,
    "SANS_VALEUR_ENCAISSEMENT" boolean DEFAULT false NOT NULL
);


ALTER TABLE "OpenConcerto48"."CHEQUE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 1013 (class 1259 OID 36396149)
-- Name: CHEQUE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CHEQUE_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CHEQUE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21790 (class 0 OID 0)
-- Dependencies: 1013
-- Name: CHEQUE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CHEQUE_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto48"."CHEQUE_FOURNISSEUR"."ID";


--
-- TOC entry 1014 (class 1259 OID 36396151)
-- Name: CHIFFRAGE_COMMANDE_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CHIFFRAGE_COMMANDE_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "QTE" numeric(16,8) DEFAULT 0 NOT NULL,
    "PA_HT" numeric(16,8) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,8) DEFAULT 0 NOT NULL,
    "T_PV_HT" numeric(16,8) DEFAULT 0 NOT NULL,
    "T_PA_HT" numeric(16,8) DEFAULT 0 NOT NULL,
    "MARGE" numeric(16,8) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."CHIFFRAGE_COMMANDE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 1015 (class 1259 OID 36396165)
-- Name: CHIFFRAGE_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CHIFFRAGE_COMMANDE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CHIFFRAGE_COMMANDE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21791 (class 0 OID 0)
-- Dependencies: 1015
-- Name: CHIFFRAGE_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CHIFFRAGE_COMMANDE_CLIENT_ID_seq" OWNED BY "OpenConcerto48"."CHIFFRAGE_COMMANDE_CLIENT"."ID";


--
-- TOC entry 1016 (class 1259 OID 36396167)
-- Name: CLASSEMENT_CONVENTIONNEL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CLASSEMENT_CONVENTIONNEL" (
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ECHELON" character varying(45) DEFAULT ''::character varying,
    "INDICE" character varying(45) DEFAULT ''::character varying,
    "POSITION" character varying(45) DEFAULT ''::character varying,
    "NIVEAU" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "COEFF" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto48"."CLASSEMENT_CONVENTIONNEL" OWNER TO openconcerto;

--
-- TOC entry 1017 (class 1259 OID 36396178)
-- Name: CLASSEMENT_CONVENTIONNEL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CLASSEMENT_CONVENTIONNEL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CLASSEMENT_CONVENTIONNEL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21792 (class 0 OID 0)
-- Dependencies: 1017
-- Name: CLASSEMENT_CONVENTIONNEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CLASSEMENT_CONVENTIONNEL_ID_seq" OWNED BY "OpenConcerto48"."CLASSEMENT_CONVENTIONNEL"."ID";


--
-- TOC entry 1018 (class 1259 OID 36396180)
-- Name: CLASSE_COMPTE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CLASSE_COMPTE" (
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "TYPE_NUMERO_COMPTE" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."CLASSE_COMPTE" OWNER TO openconcerto;

--
-- TOC entry 1019 (class 1259 OID 36396191)
-- Name: CLASSE_COMPTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CLASSE_COMPTE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CLASSE_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21793 (class 0 OID 0)
-- Dependencies: 1019
-- Name: CLASSE_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CLASSE_COMPTE_ID_seq" OWNED BY "OpenConcerto48"."CLASSE_COMPTE"."ID";


--
-- TOC entry 1020 (class 1259 OID 36396193)
-- Name: CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CLIENT" (
    "ID_ADRESSE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "TEL_COM" character varying(100) DEFAULT ''::character varying,
    "MAX_FACTURE" bigint DEFAULT 0,
    "TEL_P" character varying(100) DEFAULT ''::character varying,
    "TEL" character varying(100) DEFAULT ''::character varying,
    "ID_ADRESSE_F" integer DEFAULT 1,
    "MAIL_COM" character varying(100) DEFAULT ''::character varying,
    "TEL_P_TECH" character varying(100) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "FAX_COM" character varying(100) DEFAULT ''::character varying,
    "RESPONSABLE_COM" character varying(100) DEFAULT ''::character varying,
    "COMPTE_CLIENT_AUTO" boolean DEFAULT false,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "NUMERO_TVA" character varying(100) DEFAULT ''::character varying,
    "ID_ADRESSE_L" integer DEFAULT 1,
    "CODE" character varying(2048) DEFAULT ''::text,
    "SIRET" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer,
    "FORME_JURIDIQUE" character varying(2048) DEFAULT ''::text,
    "RESPONSABLE_TECH" character varying(100) DEFAULT ''::character varying,
    "TEL_P_COM" character varying(100) DEFAULT ''::character varying,
    "MARCHE_PRIVE" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "COMPTANT" boolean DEFAULT false,
    "RESPONSABLE" character varying(100) DEFAULT ''::character varying,
    "RIB" character varying(2048) DEFAULT ''::text,
    "MARCHE_PUBLIC" boolean DEFAULT false,
    "FAX" character varying(100) DEFAULT ''::character varying,
    "TEL_TECH" character varying(100) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "AFFACTURAGE" boolean DEFAULT false,
    "ORDRE" numeric(16,8),
    "MAIL" character varying(100) DEFAULT ''::character varying,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "MAIL_TECH" character varying(100) DEFAULT ''::character varying,
    "FAX_TECH" character varying(100) DEFAULT ''::character varying,
    "ID_TARIF" integer DEFAULT 1,
    "ID_PAYS" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "BLOQUE_LIVRAISON" boolean DEFAULT false NOT NULL,
    "BLOQUE" boolean DEFAULT false NOT NULL,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1,
    "ID_COMPTE_PCE_PRODUIT" integer DEFAULT 1,
    "ENCOURS_MAX" numeric(16,2) DEFAULT 0 NOT NULL,
    "CATEGORIES" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NOTE_FINANCIERE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "CENTRE_GESTION" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "METHODE_RELANCE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "SITE_INTERNET" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "GROUPE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "TIMBRE_FISCAL" boolean DEFAULT false NOT NULL,
    "OBSOLETE" boolean DEFAULT false NOT NULL,
    "REMIND_DATE" timestamp without time zone,
    "SOLDE_COMPTE" numeric(16,6) DEFAULT 0 NOT NULL,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "COMMENTAIRES" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "CODE_FOURNISSEUR" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CONDITIONS_LIVRAISON" character varying(512) DEFAULT ''::character varying NOT NULL,
    "DATE" date,
    "IBAN" character varying(128) DEFAULT ''::character varying NOT NULL,
    "BIC" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ACCEPTE_EMAIL" boolean DEFAULT false NOT NULL,
    "ACCEPTE_COURRIER" boolean DEFAULT false NOT NULL,
    "ACCEPTE_SMS" boolean DEFAULT false NOT NULL,
    "ACCEPTE_TEL" boolean DEFAULT false NOT NULL,
    "ID_FRAIS_DOCUMENT" integer DEFAULT 1,
    "ID_CATEGORIE_COMPTABLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."CLIENT" OWNER TO openconcerto;

--
-- TOC entry 1021 (class 1259 OID 36396262)
-- Name: CLIENT_DEPARTEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CLIENT_DEPARTEMENT" (
    "ID" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_ADRESSE" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."CLIENT_DEPARTEMENT" OWNER TO openconcerto;

--
-- TOC entry 1022 (class 1259 OID 36396274)
-- Name: CLIENT_DEPARTEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CLIENT_DEPARTEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CLIENT_DEPARTEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21794 (class 0 OID 0)
-- Dependencies: 1022
-- Name: CLIENT_DEPARTEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CLIENT_DEPARTEMENT_ID_seq" OWNED BY "OpenConcerto48"."CLIENT_DEPARTEMENT"."ID";


--
-- TOC entry 1023 (class 1259 OID 36396276)
-- Name: CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21795 (class 0 OID 0)
-- Dependencies: 1023
-- Name: CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CLIENT_ID_seq" OWNED BY "OpenConcerto48"."CLIENT"."ID";


--
-- TOC entry 1024 (class 1259 OID 36396278)
-- Name: CODE_CARACT_ACTIVITE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CODE_CARACT_ACTIVITE" (
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "CODE" character varying(5) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto48"."CODE_CARACT_ACTIVITE" OWNER TO openconcerto;

--
-- TOC entry 1025 (class 1259 OID 36396286)
-- Name: CODE_CARACT_ACTIVITE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CODE_CARACT_ACTIVITE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_CARACT_ACTIVITE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21796 (class 0 OID 0)
-- Dependencies: 1025
-- Name: CODE_CARACT_ACTIVITE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CODE_CARACT_ACTIVITE_ID_seq" OWNED BY "OpenConcerto48"."CODE_CARACT_ACTIVITE"."ID";


--
-- TOC entry 1026 (class 1259 OID 36396288)
-- Name: CODE_CONTRAT_TRAVAIL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CODE_CONTRAT_TRAVAIL" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(128) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."CODE_CONTRAT_TRAVAIL" OWNER TO openconcerto;

--
-- TOC entry 1027 (class 1259 OID 36396296)
-- Name: CODE_CONTRAT_TRAVAIL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CODE_CONTRAT_TRAVAIL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_CONTRAT_TRAVAIL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21797 (class 0 OID 0)
-- Dependencies: 1027
-- Name: CODE_CONTRAT_TRAVAIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CODE_CONTRAT_TRAVAIL_ID_seq" OWNED BY "OpenConcerto48"."CODE_CONTRAT_TRAVAIL"."ID";


--
-- TOC entry 1028 (class 1259 OID 36396298)
-- Name: CODE_DROIT_CONTRAT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CODE_DROIT_CONTRAT" (
    "ORDRE" numeric(16,8),
    "CODE" character varying(4) DEFAULT ''::character varying,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."CODE_DROIT_CONTRAT" OWNER TO openconcerto;

--
-- TOC entry 1029 (class 1259 OID 36396306)
-- Name: CODE_DROIT_CONTRAT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CODE_DROIT_CONTRAT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_DROIT_CONTRAT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21798 (class 0 OID 0)
-- Dependencies: 1029
-- Name: CODE_DROIT_CONTRAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CODE_DROIT_CONTRAT_ID_seq" OWNED BY "OpenConcerto48"."CODE_DROIT_CONTRAT"."ID";


--
-- TOC entry 1030 (class 1259 OID 36396308)
-- Name: CODE_EMPLOI; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CODE_EMPLOI" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "CODE" character varying(11) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(195) DEFAULT ''::character varying,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto48"."CODE_EMPLOI" OWNER TO openconcerto;

--
-- TOC entry 1031 (class 1259 OID 36396316)
-- Name: CODE_EMPLOI_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CODE_EMPLOI_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_EMPLOI_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21799 (class 0 OID 0)
-- Dependencies: 1031
-- Name: CODE_EMPLOI_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CODE_EMPLOI_ID_seq" OWNED BY "OpenConcerto48"."CODE_EMPLOI"."ID";


--
-- TOC entry 1032 (class 1259 OID 36396318)
-- Name: CODE_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CODE_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."CODE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 1033 (class 1259 OID 36396326)
-- Name: CODE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CODE_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21800 (class 0 OID 0)
-- Dependencies: 1033
-- Name: CODE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CODE_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto48"."CODE_FOURNISSEUR"."ID";


--
-- TOC entry 1034 (class 1259 OID 36396328)
-- Name: CODE_PENIBILITE_CONTRAT_SALARIE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CODE_PENIBILITE_CONTRAT_SALARIE" (
    "ID" integer NOT NULL,
    "ID_INFOS_SALARIE_PAYE" integer DEFAULT 1,
    "ID_CODE_PENIBILITE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."CODE_PENIBILITE_CONTRAT_SALARIE" OWNER TO openconcerto;

--
-- TOC entry 1035 (class 1259 OID 36396335)
-- Name: CODE_PENIBILITE_CONTRAT_SALARIE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CODE_PENIBILITE_CONTRAT_SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_PENIBILITE_CONTRAT_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21801 (class 0 OID 0)
-- Dependencies: 1035
-- Name: CODE_PENIBILITE_CONTRAT_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CODE_PENIBILITE_CONTRAT_SALARIE_ID_seq" OWNED BY "OpenConcerto48"."CODE_PENIBILITE_CONTRAT_SALARIE"."ID";


--
-- TOC entry 1036 (class 1259 OID 36396337)
-- Name: CODE_REGIME; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CODE_REGIME" (
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "CODE" character varying(4) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_CREATE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."CODE_REGIME" OWNER TO openconcerto;

--
-- TOC entry 1037 (class 1259 OID 36396345)
-- Name: CODE_REGIME_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CODE_REGIME_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_REGIME_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21802 (class 0 OID 0)
-- Dependencies: 1037
-- Name: CODE_REGIME_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CODE_REGIME_ID_seq" OWNED BY "OpenConcerto48"."CODE_REGIME"."ID";


--
-- TOC entry 1038 (class 1259 OID 36396347)
-- Name: CODE_STATUT_CATEGORIEL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CODE_STATUT_CATEGORIEL" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."CODE_STATUT_CATEGORIEL" OWNER TO openconcerto;

--
-- TOC entry 1039 (class 1259 OID 36396355)
-- Name: CODE_STATUT_CATEGORIEL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CODE_STATUT_CATEGORIEL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_STATUT_CATEGORIEL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21803 (class 0 OID 0)
-- Dependencies: 1039
-- Name: CODE_STATUT_CATEGORIEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CODE_STATUT_CATEGORIEL_ID_seq" OWNED BY "OpenConcerto48"."CODE_STATUT_CATEGORIEL"."ID";


--
-- TOC entry 1040 (class 1259 OID 36396357)
-- Name: CODE_STATUT_CAT_CONV; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CODE_STATUT_CAT_CONV" (
    "ID" integer NOT NULL,
    "CODE" character varying(6) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."CODE_STATUT_CAT_CONV" OWNER TO openconcerto;

--
-- TOC entry 1041 (class 1259 OID 36396364)
-- Name: CODE_STATUT_CAT_CONV_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CODE_STATUT_CAT_CONV_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_STATUT_CAT_CONV_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21804 (class 0 OID 0)
-- Dependencies: 1041
-- Name: CODE_STATUT_CAT_CONV_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CODE_STATUT_CAT_CONV_ID_seq" OWNED BY "OpenConcerto48"."CODE_STATUT_CAT_CONV"."ID";


--
-- TOC entry 1042 (class 1259 OID 36396366)
-- Name: CODE_STATUT_PROF; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CODE_STATUT_PROF" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CODE" character varying(5) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(256) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."CODE_STATUT_PROF" OWNER TO openconcerto;

--
-- TOC entry 1043 (class 1259 OID 36396374)
-- Name: CODE_STATUT_PROF_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CODE_STATUT_PROF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CODE_STATUT_PROF_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21805 (class 0 OID 0)
-- Dependencies: 1043
-- Name: CODE_STATUT_PROF_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CODE_STATUT_PROF_ID_seq" OWNED BY "OpenConcerto48"."CODE_STATUT_PROF"."ID";


--
-- TOC entry 1044 (class 1259 OID 36396376)
-- Name: COEFF_PRIME; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."COEFF_PRIME" (
    "ID" integer NOT NULL,
    "PRIME_PERSO" real DEFAULT 0,
    "PRIME_RECONSTRUCTION" real DEFAULT 0,
    "PRIME_ANCIENNETE" real DEFAULT 0,
    "PRIME_DEROULEMENT" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."COEFF_PRIME" OWNER TO openconcerto;

--
-- TOC entry 1045 (class 1259 OID 36396385)
-- Name: COEFF_PRIME_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."COEFF_PRIME_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COEFF_PRIME_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21806 (class 0 OID 0)
-- Dependencies: 1045
-- Name: COEFF_PRIME_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."COEFF_PRIME_ID_seq" OWNED BY "OpenConcerto48"."COEFF_PRIME"."ID";


--
-- TOC entry 1046 (class 1259 OID 36396387)
-- Name: COMMANDE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."COMMANDE" (
    "T_POIDS" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "DATE" date,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "SOURCE" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer,
    "T_SERVICE" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "T_TTC" bigint DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "IDSOURCE" integer DEFAULT 1,
    "DATE_ECHEANCE" date,
    "T_HT" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "T_TVA" bigint DEFAULT 0,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8),
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_DEVISE" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "EN_COURS" boolean DEFAULT true,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "DATE_RECEPTION_DEMANDEE" date,
    "DATE_RECEPTION_CONFIRMEE" date,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "PORT_HT" bigint DEFAULT 0 NOT NULL,
    "REMISE_HT" bigint DEFAULT 0 NOT NULL
);


ALTER TABLE "OpenConcerto48"."COMMANDE" OWNER TO openconcerto;

--
-- TOC entry 1047 (class 1259 OID 36396416)
-- Name: COMMANDE_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."COMMANDE_CLIENT" (
    "DATE" date,
    "SOURCE" character varying(100) DEFAULT ''::character varying,
    "T_TTC" bigint DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "DATE_ECHEANCE" date,
    "T_SERVICE" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "T_TVA" bigint DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "T_HT" bigint DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer,
    "T_POIDS" real DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "IDSOURCE" integer DEFAULT 1,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ID_DEVIS" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_ADRESSE_LIVRAISON" integer DEFAULT 1,
    "POURCENT_REMISE" numeric(12,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_CONTACT" integer DEFAULT 1,
    "ID_CLIENT_DEPARTEMENT" integer DEFAULT 1,
    "ETAT_COMMANDE" integer DEFAULT 1 NOT NULL,
    "EMBALLAGE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NUMERO_EXPEDITION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "PORT_HT" bigint DEFAULT 0 NOT NULL,
    "REMISE_HT" bigint DEFAULT 0 NOT NULL,
    "TYPE_EXPEDITION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "DATE_LIVRAISON_PREV" date,
    "FRAIS_DOCUMENT_HT" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE_FRAIS_DOCUMENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."COMMANDE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 1048 (class 1259 OID 36396451)
-- Name: COMMANDE_CLIENT_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."COMMANDE_CLIENT_ELEMENT" (
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "QTE" integer DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "T_POIDS" real DEFAULT 0,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "SERVICE" boolean DEFAULT false,
    "ORDRE" numeric(16,8),
    "ID_METRIQUE_3" integer DEFAULT 1,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID" integer NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "POIDS" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_STYLE" integer DEFAULT 1,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "POURCENT_REMISE" numeric(12,8) DEFAULT 0,
    "PV_T_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "T_POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "NB_COLIS" integer DEFAULT 0,
    "MONTANT_REMISE" numeric(16,8),
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "LIVRE_FORCED" boolean DEFAULT false NOT NULL,
    "LIVRE" boolean DEFAULT false NOT NULL,
    "QTE_LIVREE" numeric(16,6) DEFAULT 0,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."COMMANDE_CLIENT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1049 (class 1259 OID 36396511)
-- Name: COMMANDE_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."COMMANDE_CLIENT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COMMANDE_CLIENT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21807 (class 0 OID 0)
-- Dependencies: 1049
-- Name: COMMANDE_CLIENT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."COMMANDE_CLIENT_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."COMMANDE_CLIENT_ELEMENT"."ID";


--
-- TOC entry 1050 (class 1259 OID 36396513)
-- Name: COMMANDE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."COMMANDE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COMMANDE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21808 (class 0 OID 0)
-- Dependencies: 1050
-- Name: COMMANDE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."COMMANDE_CLIENT_ID_seq" OWNED BY "OpenConcerto48"."COMMANDE_CLIENT"."ID";


--
-- TOC entry 1051 (class 1259 OID 36396515)
-- Name: COMMANDE_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."COMMANDE_ELEMENT" (
    "ID_COMMANDE" integer DEFAULT 1,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_POIDS" real DEFAULT 0,
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_STYLE" integer DEFAULT 1,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PA_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8),
    "POIDS" real DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "QTE" integer DEFAULT 0,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "SERVICE" boolean DEFAULT false,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1,
    "PA_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "PA_DEVISE_T" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_CODE_FOURNISSEUR" integer DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "RECU_FORCED" boolean DEFAULT false NOT NULL,
    "RECU" boolean DEFAULT true NOT NULL,
    "QTE_RECUE" numeric(16,6) DEFAULT 0,
    "ID_DEMANDE_ACHAT_ELEMENT" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."COMMANDE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1052 (class 1259 OID 36396570)
-- Name: COMMANDE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."COMMANDE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COMMANDE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21809 (class 0 OID 0)
-- Dependencies: 1052
-- Name: COMMANDE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."COMMANDE_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."COMMANDE_ELEMENT"."ID";


--
-- TOC entry 1053 (class 1259 OID 36396572)
-- Name: COMMANDE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."COMMANDE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COMMANDE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21810 (class 0 OID 0)
-- Dependencies: 1053
-- Name: COMMANDE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."COMMANDE_ID_seq" OWNED BY "OpenConcerto48"."COMMANDE"."ID";


--
-- TOC entry 1054 (class 1259 OID 36396574)
-- Name: COMMERCIAL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."COMMERCIAL" (
    "ID_COMMERCIAL" integer NOT NULL,
    "FONCTION" character varying(100) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "TEL_DIRECT" character varying(100) DEFAULT ''::character varying,
    "TEL_MOBILE" character varying(100) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "TEL_PERSONEL" character varying(100) DEFAULT ''::character varying,
    "FAX" character varying(100) DEFAULT ''::character varying,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "PRENOM" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON" integer DEFAULT 1,
    "TEL_STANDARD" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer,
    "EMAIL" character varying(100) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto48"."COMMERCIAL" OWNER TO openconcerto;

--
-- TOC entry 1055 (class 1259 OID 36396592)
-- Name: COMMERCIAL_ID_COMMERCIAL_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."COMMERCIAL_ID_COMMERCIAL_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COMMERCIAL_ID_COMMERCIAL_seq" OWNER TO openconcerto;

--
-- TOC entry 21811 (class 0 OID 0)
-- Dependencies: 1055
-- Name: COMMERCIAL_ID_COMMERCIAL_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."COMMERCIAL_ID_COMMERCIAL_seq" OWNED BY "OpenConcerto48"."COMMERCIAL"."ID_COMMERCIAL";


--
-- TOC entry 1056 (class 1259 OID 36396594)
-- Name: COMPLETION; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."COMPLETION" (
    "CHAMP" character varying(100) DEFAULT ''::character varying NOT NULL,
    "LABEL" character varying(200) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto48"."COMPLETION" OWNER TO openconcerto;

--
-- TOC entry 1057 (class 1259 OID 36396599)
-- Name: COMPTE_CLIENT_TRANSACTION; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."COMPTE_CLIENT_TRANSACTION" (
    "ID" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "DATE" timestamp without time zone,
    "MONTANT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."COMPTE_CLIENT_TRANSACTION" OWNER TO openconcerto;

--
-- TOC entry 1058 (class 1259 OID 36396608)
-- Name: COMPTE_CLIENT_TRANSACTION_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."COMPTE_CLIENT_TRANSACTION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COMPTE_CLIENT_TRANSACTION_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21812 (class 0 OID 0)
-- Dependencies: 1058
-- Name: COMPTE_CLIENT_TRANSACTION_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."COMPTE_CLIENT_TRANSACTION_ID_seq" OWNED BY "OpenConcerto48"."COMPTE_CLIENT_TRANSACTION"."ID";


--
-- TOC entry 1059 (class 1259 OID 36396610)
-- Name: COMPTE_PCE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."COMPTE_PCE" (
    "TOTAL_DEBIT" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "INFOS" character varying(3072) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "TOTAL_CREDIT" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_NATURE_COMPTE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "RACINE" boolean DEFAULT false,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "OBSOLETE" boolean DEFAULT false NOT NULL
);


ALTER TABLE "OpenConcerto48"."COMPTE_PCE" OWNER TO openconcerto;

--
-- TOC entry 1060 (class 1259 OID 36396627)
-- Name: COMPTE_PCE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."COMPTE_PCE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COMPTE_PCE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21813 (class 0 OID 0)
-- Dependencies: 1060
-- Name: COMPTE_PCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."COMPTE_PCE_ID_seq" OWNED BY "OpenConcerto48"."COMPTE_PCE"."ID";


--
-- TOC entry 1061 (class 1259 OID 36396629)
-- Name: COMPTE_PCG; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."COMPTE_PCG" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "INFOS" character varying(3072) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_TYPE_COMPTE_PCG_AB" integer DEFAULT 1,
    "ID_NATURE_COMPTE" integer DEFAULT 1,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "ID_TYPE_COMPTE_PCG_BASE" integer DEFAULT 1,
    "ID_TYPE_COMPTE_PCG_DEV" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8),
    "NOM" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto48"."COMPTE_PCG" OWNER TO openconcerto;

--
-- TOC entry 1062 (class 1259 OID 36396645)
-- Name: COMPTE_PCG_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."COMPTE_PCG_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COMPTE_PCG_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21814 (class 0 OID 0)
-- Dependencies: 1062
-- Name: COMPTE_PCG_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."COMPTE_PCG_ID_seq" OWNED BY "OpenConcerto48"."COMPTE_PCG"."ID";


--
-- TOC entry 1063 (class 1259 OID 36396647)
-- Name: CONTACT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CONTACT" (
    "ID_CLIENT" integer DEFAULT 1,
    "TEL_MOBILE" character varying(100) DEFAULT ''::character varying,
    "TEL_DIRECT" character varying(100) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "FONCTION" character varying(2048) DEFAULT ''::text,
    "EMAIL" character varying(100) DEFAULT ''::character varying,
    "PRENOM" character varying(100) DEFAULT ''::character varying,
    "TEL_PERSONEL" character varying(100) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_TITRE_PERSONNEL" integer DEFAULT 2,
    "FAX" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "TEL_STANDARD" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "NO_MAILING" boolean DEFAULT false NOT NULL,
    "DATE_NAISSANCE" date
);


ALTER TABLE "OpenConcerto48"."CONTACT" OWNER TO openconcerto;

--
-- TOC entry 1064 (class 1259 OID 36396669)
-- Name: CONTACT_ADMINISTRATIF; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CONTACT_ADMINISTRATIF" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRENOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_DIRECT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_MOBILE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "EMAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FAX" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FONCTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_PERSONEL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_STANDARD" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "N4DS" boolean DEFAULT false,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."CONTACT_ADMINISTRATIF" OWNER TO openconcerto;

--
-- TOC entry 1065 (class 1259 OID 36396688)
-- Name: CONTACT_ADMINISTRATIF_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CONTACT_ADMINISTRATIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CONTACT_ADMINISTRATIF_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21815 (class 0 OID 0)
-- Dependencies: 1065
-- Name: CONTACT_ADMINISTRATIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CONTACT_ADMINISTRATIF_ID_seq" OWNED BY "OpenConcerto48"."CONTACT_ADMINISTRATIF"."ID";


--
-- TOC entry 1066 (class 1259 OID 36396690)
-- Name: CONTACT_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CONTACT_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "PRENOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_DIRECT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_MOBILE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "EMAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FAX" character varying(256) DEFAULT ''::character varying NOT NULL,
    "FONCTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_PERSONEL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_STANDARD" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."CONTACT_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 1067 (class 1259 OID 36396709)
-- Name: CONTACT_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CONTACT_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CONTACT_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21816 (class 0 OID 0)
-- Dependencies: 1067
-- Name: CONTACT_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CONTACT_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto48"."CONTACT_FOURNISSEUR"."ID";


--
-- TOC entry 1068 (class 1259 OID 36396711)
-- Name: CONTACT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CONTACT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CONTACT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21817 (class 0 OID 0)
-- Dependencies: 1068
-- Name: CONTACT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CONTACT_ID_seq" OWNED BY "OpenConcerto48"."CONTACT"."ID";


--
-- TOC entry 1069 (class 1259 OID 36396713)
-- Name: CONTRAT_PREVOYANCE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CONTRAT_PREVOYANCE" (
    "ID" integer NOT NULL,
    "REFERENCE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DATE_DEBUT" timestamp without time zone,
    "DATE_FIN" timestamp without time zone,
    "CODE_ORGANISME" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_DELEGATAIRE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_UNIQUE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "COTISATION_ETABLISSEMENT" boolean DEFAULT false NOT NULL
);


ALTER TABLE "OpenConcerto48"."CONTRAT_PREVOYANCE" OWNER TO openconcerto;

--
-- TOC entry 1070 (class 1259 OID 36396727)
-- Name: CONTRAT_PREVOYANCE_AYANT_DROIT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CONTRAT_PREVOYANCE_AYANT_DROIT" (
    "ID" integer NOT NULL,
    "ID_AYANT_DROIT" integer DEFAULT 1,
    "ID_CONTRAT_PREVOYANCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."CONTRAT_PREVOYANCE_AYANT_DROIT" OWNER TO openconcerto;

--
-- TOC entry 1071 (class 1259 OID 36396734)
-- Name: CONTRAT_PREVOYANCE_AYANT_DROIT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CONTRAT_PREVOYANCE_AYANT_DROIT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CONTRAT_PREVOYANCE_AYANT_DROIT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21818 (class 0 OID 0)
-- Dependencies: 1071
-- Name: CONTRAT_PREVOYANCE_AYANT_DROIT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CONTRAT_PREVOYANCE_AYANT_DROIT_ID_seq" OWNED BY "OpenConcerto48"."CONTRAT_PREVOYANCE_AYANT_DROIT"."ID";


--
-- TOC entry 1072 (class 1259 OID 36396736)
-- Name: CONTRAT_PREVOYANCE_CONTRAT_SALARIE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE" (
    "ID" integer NOT NULL,
    "ID_INFOS_SALARIE_PAYE" integer DEFAULT 1,
    "ID_CONTRAT_PREVOYANCE" integer DEFAULT 1,
    "CODE_OPTION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CODE_POPULATION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NB_ENFANT_CHARGE" integer,
    "NB_ADULTE_AYANT_DROIT" integer,
    "NB_AYANT_DROIT" integer,
    "NB_AYANT_DROIT_AUTRE" integer,
    "NB_ENFANT_AYANT_DROIT" integer,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE" OWNER TO openconcerto;

--
-- TOC entry 1073 (class 1259 OID 36396748)
-- Name: CONTRAT_PREVOYANCE_CONTRAT_SALARIE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21819 (class 0 OID 0)
-- Dependencies: 1073
-- Name: CONTRAT_PREVOYANCE_CONTRAT_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE_ID_seq" OWNED BY "OpenConcerto48"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE"."ID";


--
-- TOC entry 1074 (class 1259 OID 36396750)
-- Name: CONTRAT_PREVOYANCE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CONTRAT_PREVOYANCE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CONTRAT_PREVOYANCE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21820 (class 0 OID 0)
-- Dependencies: 1074
-- Name: CONTRAT_PREVOYANCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CONTRAT_PREVOYANCE_ID_seq" OWNED BY "OpenConcerto48"."CONTRAT_PREVOYANCE"."ID";


--
-- TOC entry 1075 (class 1259 OID 36396752)
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CONTRAT_PREVOYANCE_RUBRIQUE" (
    "ID" integer NOT NULL,
    "ID_RUBRIQUE_COTISATION" integer DEFAULT 1,
    "ID_CONTRAT_PREVOYANCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."CONTRAT_PREVOYANCE_RUBRIQUE" OWNER TO openconcerto;

--
-- TOC entry 1076 (class 1259 OID 36396759)
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CONTRAT_PREVOYANCE_RUBRIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CONTRAT_PREVOYANCE_RUBRIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21821 (class 0 OID 0)
-- Dependencies: 1076
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CONTRAT_PREVOYANCE_RUBRIQUE_ID_seq" OWNED BY "OpenConcerto48"."CONTRAT_PREVOYANCE_RUBRIQUE"."ID";


--
-- TOC entry 1077 (class 1259 OID 36396761)
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE_NET; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CONTRAT_PREVOYANCE_RUBRIQUE_NET" (
    "ID" integer NOT NULL,
    "ID_RUBRIQUE_NET" integer DEFAULT 1,
    "ID_CONTRAT_PREVOYANCE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."CONTRAT_PREVOYANCE_RUBRIQUE_NET" OWNER TO openconcerto;

--
-- TOC entry 1078 (class 1259 OID 36396768)
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE_NET_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CONTRAT_PREVOYANCE_RUBRIQUE_NET_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CONTRAT_PREVOYANCE_RUBRIQUE_NET_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21822 (class 0 OID 0)
-- Dependencies: 1078
-- Name: CONTRAT_PREVOYANCE_RUBRIQUE_NET_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CONTRAT_PREVOYANCE_RUBRIQUE_NET_ID_seq" OWNED BY "OpenConcerto48"."CONTRAT_PREVOYANCE_RUBRIQUE_NET"."ID";


--
-- TOC entry 1079 (class 1259 OID 36396770)
-- Name: CONTRAT_SALARIE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CONTRAT_SALARIE" (
    "NATURE" character varying(2048) DEFAULT ''::text,
    "ID_CODE_STATUT_PROF" integer DEFAULT 1,
    "ID_CODE_CARACT_ACTIVITE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID_CODE_DROIT_CONTRAT" integer DEFAULT 1,
    "ID_CODE_EMPLOI" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ID_CODE_STATUT_CATEGORIEL" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_CODE_CONTRAT_TRAVAIL" integer DEFAULT 1,
    "CODE_IRC_UGRR" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_UGRR" character varying(64) DEFAULT ''::character varying NOT NULL,
    "CODE_IRC_UGRC" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_UGRC" character varying(64) DEFAULT ''::character varying NOT NULL,
    "CODE_IRC_RETRAITE" character varying(18) DEFAULT ''::character varying NOT NULL,
    "NUMERO_RATTACHEMENT_RETRAITE" character varying(64) DEFAULT ''::character varying NOT NULL,
    "ID_CODE_STATUT_CAT_CONV" integer DEFAULT 1,
    "NUMERO" character varying(128) DEFAULT '00000'::character varying NOT NULL,
    "CODE_REGIME_RETRAITE_DSN" character varying(128) DEFAULT '00000'::character varying NOT NULL,
    "DATE_PREV_FIN" timestamp without time zone,
    "ID_CONTRAT_MODALITE_TEMPS" integer DEFAULT 1,
    "ID_CONTRAT_REGIME_MALADIE" integer DEFAULT 1,
    "ID_CONTRAT_REGIME_VIEILLESSE" integer DEFAULT 1,
    "ID_CONTRAT_MOTIF_RECOURS" integer DEFAULT 1,
    "ID_CONTRAT_DETACHE_EXPATRIE" integer DEFAULT 1,
    "ID_CONTRAT_DISPOSITIF_POLITIQUE" integer DEFAULT 1,
    "DATE_DEBUT" timestamp without time zone,
    "DATE_MODIFICATION" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."CONTRAT_SALARIE" OWNER TO openconcerto;

--
-- TOC entry 1080 (class 1259 OID 36396801)
-- Name: CONTRAT_SALARIE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CONTRAT_SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CONTRAT_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21823 (class 0 OID 0)
-- Dependencies: 1080
-- Name: CONTRAT_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CONTRAT_SALARIE_ID_seq" OWNED BY "OpenConcerto48"."CONTRAT_SALARIE"."ID";


--
-- TOC entry 1081 (class 1259 OID 36396803)
-- Name: COURRIER_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."COURRIER_CLIENT" (
    "ID_USER_COMMON_CREATE" integer,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(256) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_MODELE_COURRIER_CLIENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "DATE" date,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8) DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."COURRIER_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 1082 (class 1259 OID 36396817)
-- Name: COURRIER_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."COURRIER_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COURRIER_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21824 (class 0 OID 0)
-- Dependencies: 1082
-- Name: COURRIER_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."COURRIER_CLIENT_ID_seq" OWNED BY "OpenConcerto48"."COURRIER_CLIENT"."ID";


--
-- TOC entry 1286 (class 1259 OID 36414483)
-- Name: COUT_REVIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."COUT_REVIENT" (
    "ID" integer NOT NULL,
    "CODE" character varying(48) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "POURCENT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."COUT_REVIENT" OWNER TO openconcerto;

--
-- TOC entry 1285 (class 1259 OID 36414481)
-- Name: COUT_REVIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."COUT_REVIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."COUT_REVIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21825 (class 0 OID 0)
-- Dependencies: 1285
-- Name: COUT_REVIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."COUT_REVIENT_ID_seq" OWNED BY "OpenConcerto48"."COUT_REVIENT"."ID";


--
-- TOC entry 1083 (class 1259 OID 36396819)
-- Name: CUMULS_CONGES; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CUMULS_CONGES" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ACQUIS" real DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "RESTANT" real DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."CUMULS_CONGES" OWNER TO openconcerto;

--
-- TOC entry 1084 (class 1259 OID 36396827)
-- Name: CUMULS_CONGES_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CUMULS_CONGES_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CUMULS_CONGES_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21826 (class 0 OID 0)
-- Dependencies: 1084
-- Name: CUMULS_CONGES_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CUMULS_CONGES_ID_seq" OWNED BY "OpenConcerto48"."CUMULS_CONGES"."ID";


--
-- TOC entry 1085 (class 1259 OID 36396829)
-- Name: CUMULS_PAYE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."CUMULS_PAYE" (
    "ORDRE" numeric(16,8),
    "NET_A_PAYER_C" numeric(16,2) DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "COT_PAT_C" numeric(16,2) DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "COT_SAL_C" numeric(16,2) DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "SAL_BRUT_C" numeric(16,2) DEFAULT 0,
    "CSG_C" numeric(16,2) DEFAULT 0,
    "ID" integer NOT NULL,
    "NET_IMP_C" numeric(16,2) DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "HEURE_TRAV_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "TAXE_CM_SAL_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "TAXE_CM_PAT_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "SAL_BRUT_COTISABLE_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "SAL_BRUT_TAXABLE_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "SAL_BASE_BRUT_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "ALLEGEMENT_COTISATION_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "CICE_C" numeric(16,2) DEFAULT 0 NOT NULL,
    "AVANTAGE_NATURE_C" numeric(16,2) DEFAULT 0 NOT NULL
);


ALTER TABLE "OpenConcerto48"."CUMULS_PAYE" OWNER TO openconcerto;

--
-- TOC entry 1086 (class 1259 OID 36396850)
-- Name: CUMULS_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."CUMULS_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."CUMULS_PAYE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21827 (class 0 OID 0)
-- Dependencies: 1086
-- Name: CUMULS_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."CUMULS_PAYE_ID_seq" OWNED BY "OpenConcerto48"."CUMULS_PAYE"."ID";


--
-- TOC entry 1087 (class 1259 OID 36396852)
-- Name: DECLARATION_DSN; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."DECLARATION_DSN" (
    "ID" integer NOT NULL,
    "ID_DSN_NATURE" integer DEFAULT 1,
    "DATE" timestamp without time zone,
    "DATE_ENVOI" timestamp without time zone,
    "TEST" boolean DEFAULT false NOT NULL,
    "ENVOYE" boolean DEFAULT false NOT NULL,
    "COMMENTAIRE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "DSN_FILE" character varying(75000) DEFAULT ''::character varying NOT NULL,
    "NUMERO" integer DEFAULT 1 NOT NULL,
    "ANNEE" integer DEFAULT 2016 NOT NULL,
    "ID_MOIS" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_ARRET_TRAVAIL" integer DEFAULT 1,
    "ID_REPRISE_TRAVAIL" integer DEFAULT 1,
    "ID_MOIS_REGUL" integer DEFAULT 1,
    "ANNULE_REMPLACE" boolean DEFAULT false NOT NULL,
    "ID_FIN_CONTRAT" integer DEFAULT 1,
    "NUMERO_REFERENCE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_DECLARATION_DSN_ANNULATION" integer DEFAULT 1,
    "EFFECTIF_CVAE" integer,
    "CODE_INSEE_CVAE" character varying(32) DEFAULT ''::character varying NOT NULL,
    "PERIODE_CVAE_DEBUT" date,
    "PERIODE_CVAE_FIN" date
);


ALTER TABLE "OpenConcerto48"."DECLARATION_DSN" OWNER TO openconcerto;

--
-- TOC entry 1088 (class 1259 OID 36396876)
-- Name: DECLARATION_DSN_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."DECLARATION_DSN_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."DECLARATION_DSN_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21828 (class 0 OID 0)
-- Dependencies: 1088
-- Name: DECLARATION_DSN_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."DECLARATION_DSN_ID_seq" OWNED BY "OpenConcerto48"."DECLARATION_DSN"."ID";


--
-- TOC entry 1089 (class 1259 OID 36396878)
-- Name: DEMANDE_ACHAT_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."DEMANDE_ACHAT_ELEMENT" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "QTE" integer DEFAULT 1 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1 NOT NULL,
    "REPERE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "REFERENCE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_FABRICANT" integer DEFAULT 1,
    "DATE" date,
    "ID_ETAT_DEMANDE_ACHAT_ELEMENT" integer DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "EN_STOCK" boolean DEFAULT false NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8),
    "REPERE_SOURCE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "CODE_SOURCE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "NOM_SOURCE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "NUMERO_SE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "DESCRIPTIF_SE" character varying(512) DEFAULT ''::character varying NOT NULL,
    "REVISION" character varying(48) DEFAULT ''::character varying NOT NULL,
    "P_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_COMMANDE" integer DEFAULT 1,
    "ID_BON_RECEPTION" integer DEFAULT 1,
    "QTE_RECUE" integer DEFAULT 0 NOT NULL,
    "REPRISE" boolean DEFAULT false NOT NULL,
    "IMPORT" boolean DEFAULT false NOT NULL
);


ALTER TABLE "OpenConcerto48"."DEMANDE_ACHAT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1090 (class 1259 OID 36396911)
-- Name: DEMANDE_ACHAT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."DEMANDE_ACHAT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."DEMANDE_ACHAT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21829 (class 0 OID 0)
-- Dependencies: 1090
-- Name: DEMANDE_ACHAT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."DEMANDE_ACHAT_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."DEMANDE_ACHAT_ELEMENT"."ID";


--
-- TOC entry 1091 (class 1259 OID 36396913)
-- Name: DEMANDE_PRIX; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."DEMANDE_PRIX" (
    "ID" integer NOT NULL,
    "NUMERO" character varying(256) DEFAULT ''::character varying NOT NULL,
    "OBJET" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "DATE" date,
    "DATE_BUTOIRE" date,
    "T_HT" bigint DEFAULT 0,
    "T_TVA" bigint DEFAULT 0,
    "T_TTC" bigint DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ID_ETAT_DEMANDE_PRIX" integer DEFAULT 1,
    "INFOS" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."DEMANDE_PRIX" OWNER TO openconcerto;

--
-- TOC entry 1092 (class 1259 OID 36396929)
-- Name: DEMANDE_PRIX_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."DEMANDE_PRIX_ELEMENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ID_DEMANDE_PRIX" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 2,
    "QTE" integer DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PA_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_POIDS" real DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 5,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_STYLE" integer DEFAULT 1,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "QTE_ACHAT" integer DEFAULT 1 NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "SERVICE" boolean DEFAULT false,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "POIDS" real DEFAULT 0,
    "PA_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "PA_DEVISE_T" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1 NOT NULL,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0 NOT NULL,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_DEMANDE_ACHAT_ELEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8),
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."DEMANDE_PRIX_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1093 (class 1259 OID 36396978)
-- Name: DEMANDE_PRIX_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."DEMANDE_PRIX_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."DEMANDE_PRIX_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21830 (class 0 OID 0)
-- Dependencies: 1093
-- Name: DEMANDE_PRIX_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."DEMANDE_PRIX_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."DEMANDE_PRIX_ELEMENT"."ID";


--
-- TOC entry 1094 (class 1259 OID 36396980)
-- Name: DEMANDE_PRIX_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."DEMANDE_PRIX_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."DEMANDE_PRIX_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21831 (class 0 OID 0)
-- Dependencies: 1094
-- Name: DEMANDE_PRIX_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."DEMANDE_PRIX_ID_seq" OWNED BY "OpenConcerto48"."DEMANDE_PRIX"."ID";


--
-- TOC entry 1095 (class 1259 OID 36396982)
-- Name: DEPARTEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."DEPARTEMENT" (
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NOM" character varying(100) DEFAULT ''::character varying,
    "REGION_ADMIN" character varying(100) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "CHEF_LIEU" character varying(100) DEFAULT ''::character varying,
    "NUMERO" character varying(10) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."DEPARTEMENT" OWNER TO openconcerto;

--
-- TOC entry 1096 (class 1259 OID 36396992)
-- Name: DEPARTEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."DEPARTEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."DEPARTEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21832 (class 0 OID 0)
-- Dependencies: 1096
-- Name: DEPARTEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."DEPARTEMENT_ID_seq" OWNED BY "OpenConcerto48"."DEPARTEMENT"."ID";


--
-- TOC entry 1282 (class 1259 OID 36414373)
-- Name: DEPOT_CHEQUE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."DEPOT_CHEQUE" (
    "ID" integer NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "MONTANT" bigint DEFAULT 0 NOT NULL,
    "DATE" date,
    "ID_BANQUE" integer DEFAULT 1,
    "ID_ECRITURE" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."DEPOT_CHEQUE" OWNER TO openconcerto;

--
-- TOC entry 1284 (class 1259 OID 36414410)
-- Name: DEPOT_CHEQUE_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."DEPOT_CHEQUE_ELEMENT" (
    "ID" integer NOT NULL,
    "NUMERO" character varying(128) DEFAULT ''::character varying NOT NULL,
    "BANQUE" character varying(128) DEFAULT ''::character varying NOT NULL,
    "PIECE" character varying(512) DEFAULT ''::character varying NOT NULL,
    "MONTANT" bigint DEFAULT 0 NOT NULL,
    "DATE" date,
    "ID_CHEQUE_A_ENCAISSER" integer DEFAULT 1,
    "ID_ECRITURE" integer DEFAULT 1,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_DEPOT_CHEQUE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8),
    "TIERS" character varying(256) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto48"."DEPOT_CHEQUE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1283 (class 1259 OID 36414408)
-- Name: DEPOT_CHEQUE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."DEPOT_CHEQUE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."DEPOT_CHEQUE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21833 (class 0 OID 0)
-- Dependencies: 1283
-- Name: DEPOT_CHEQUE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."DEPOT_CHEQUE_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."DEPOT_CHEQUE_ELEMENT"."ID";


--
-- TOC entry 1281 (class 1259 OID 36414371)
-- Name: DEPOT_CHEQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."DEPOT_CHEQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."DEPOT_CHEQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21834 (class 0 OID 0)
-- Dependencies: 1281
-- Name: DEPOT_CHEQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."DEPOT_CHEQUE_ID_seq" OWNED BY "OpenConcerto48"."DEPOT_CHEQUE"."ID";


--
-- TOC entry 1300 (class 1259 OID 36415081)
-- Name: DEPOT_STOCK; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."DEPOT_STOCK" (
    "ID" integer NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "UI_LOCK" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_USER_UI_LOCK" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."DEPOT_STOCK" OWNER TO openconcerto;

--
-- TOC entry 1299 (class 1259 OID 36415079)
-- Name: DEPOT_STOCK_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."DEPOT_STOCK_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."DEPOT_STOCK_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21835 (class 0 OID 0)
-- Dependencies: 1299
-- Name: DEPOT_STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."DEPOT_STOCK_ID_seq" OWNED BY "OpenConcerto48"."DEPOT_STOCK"."ID";


--
-- TOC entry 1097 (class 1259 OID 36396994)
-- Name: DEVIS; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."DEVIS" (
    "T_POIDS" real DEFAULT 0,
    "DATE_ENVOI" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "T_SERVICE" bigint DEFAULT 0,
    "ID_DEVIS" integer NOT NULL,
    "ORDRE" numeric(16,8),
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_ETAT_DEVIS" integer DEFAULT 1,
    "T_TTC" bigint DEFAULT 0,
    "OBJET" character varying(100) DEFAULT ''::character varying,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "PORT_HT" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "REMISE_HT" bigint DEFAULT 0,
    "T_HT" bigint DEFAULT 0,
    "DATE" date,
    "T_TVA" bigint DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "DATE_VALIDITE" date,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "ID_ADRESSE_LIVRAISON" integer DEFAULT 1,
    "POURCENT_REMISE" numeric(12,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_CONTACT" integer DEFAULT 1,
    "ID_CLIENT_DEPARTEMENT" integer DEFAULT 1,
    "T_HA" bigint DEFAULT 0 NOT NULL,
    "DUNNING_DATE" date,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "T_ACOMPTE" bigint DEFAULT 0 NOT NULL,
    "FRAIS_DOCUMENT_HT" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE_FRAIS_DOCUMENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."DEVIS" OWNER TO openconcerto;

--
-- TOC entry 1098 (class 1259 OID 36397025)
-- Name: DEVISE_HISTORIQUE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."DEVISE_HISTORIQUE" (
    "ID" integer NOT NULL,
    "DATE" timestamp without time zone,
    "SRC" character varying(8) DEFAULT ''::character varying NOT NULL,
    "DST" character varying(8) DEFAULT ''::character varying NOT NULL,
    "TAUX" numeric(12,6) DEFAULT 1 NOT NULL,
    "TAUX_COMMERCIAL" numeric(12,6) DEFAULT 1 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."DEVISE_HISTORIQUE" OWNER TO openconcerto;

--
-- TOC entry 1099 (class 1259 OID 36397034)
-- Name: DEVISE_HISTORIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."DEVISE_HISTORIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."DEVISE_HISTORIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21836 (class 0 OID 0)
-- Dependencies: 1099
-- Name: DEVISE_HISTORIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."DEVISE_HISTORIQUE_ID_seq" OWNED BY "OpenConcerto48"."DEVISE_HISTORIQUE"."ID";


--
-- TOC entry 1100 (class 1259 OID 36397036)
-- Name: DEVIS_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."DEVIS_ELEMENT" (
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE" integer DEFAULT 1,
    "SERVICE" boolean DEFAULT false,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_TAXE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_STYLE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_DEVIS" integer DEFAULT 1,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "POIDS" real DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "T_POIDS" real DEFAULT 0,
    "CODE" character varying(45) DEFAULT ''::text,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_DEVIS_ELEMENT" integer NOT NULL,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "POURCENT_REMISE" numeric(12,8) DEFAULT 0,
    "PV_T_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "T_POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "NB_COLIS" integer DEFAULT 0,
    "MONTANT_REMISE" numeric(16,8),
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_DEPOT_STOCK" integer DEFAULT 1,
    "LIVRE_FORCED" boolean DEFAULT false NOT NULL,
    "LIVRE" boolean DEFAULT false NOT NULL,
    "QTE_LIVREE" numeric(16,6) DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."DEVIS_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1101 (class 1259 OID 36397093)
-- Name: DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq" OWNER TO openconcerto;

--
-- TOC entry 21837 (class 0 OID 0)
-- Dependencies: 1101
-- Name: DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq" OWNED BY "OpenConcerto48"."DEVIS_ELEMENT"."ID_DEVIS_ELEMENT";


--
-- TOC entry 1102 (class 1259 OID 36397095)
-- Name: DEVIS_ID_DEVIS_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."DEVIS_ID_DEVIS_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."DEVIS_ID_DEVIS_seq" OWNER TO openconcerto;

--
-- TOC entry 21838 (class 0 OID 0)
-- Dependencies: 1102
-- Name: DEVIS_ID_DEVIS_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."DEVIS_ID_DEVIS_seq" OWNED BY "OpenConcerto48"."DEVIS"."ID_DEVIS";


--
-- TOC entry 1103 (class 1259 OID 36397097)
-- Name: ECHANTILLON_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ECHANTILLON_ELEMENT" (
    "ID_TAXE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "PV_HT" bigint DEFAULT 0,
    "T_PV_HT" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "QTE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "T_PV_TTC" bigint DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."ECHANTILLON_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1104 (class 1259 OID 36397111)
-- Name: ECHANTILLON_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ECHANTILLON_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ECHANTILLON_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21839 (class 0 OID 0)
-- Dependencies: 1104
-- Name: ECHANTILLON_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ECHANTILLON_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."ECHANTILLON_ELEMENT"."ID";


--
-- TOC entry 1105 (class 1259 OID 36397113)
-- Name: ECHEANCE_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ECHEANCE_CLIENT" (
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "REG_COMPTA" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "DATE_LAST_RELANCE" date,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_CREATE" integer,
    "MONTANT" bigint DEFAULT 0,
    "REGLE" boolean DEFAULT false,
    "ARCHIVE" integer DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_CLIENT" integer DEFAULT 1,
    "RETOUR_NATEXIS" boolean DEFAULT false,
    "NOMBRE_RELANCE" integer DEFAULT 0,
    "DATE" date,
    "ID" integer NOT NULL,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "TIERS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_COMPTE_PCE_TIERS" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."ECHEANCE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 1106 (class 1259 OID 36397129)
-- Name: ECHEANCE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ECHEANCE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ECHEANCE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21840 (class 0 OID 0)
-- Dependencies: 1106
-- Name: ECHEANCE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ECHEANCE_CLIENT_ID_seq" OWNED BY "OpenConcerto48"."ECHEANCE_CLIENT"."ID";


--
-- TOC entry 1107 (class 1259 OID 36397131)
-- Name: ECHEANCE_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ECHEANCE_FOURNISSEUR" (
    "ID_MOUVEMENT" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "REGLE" boolean DEFAULT false,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "DATE" date,
    "REG_COMPTA" boolean DEFAULT false
);


ALTER TABLE "OpenConcerto48"."ECHEANCE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 1108 (class 1259 OID 36397142)
-- Name: ECHEANCE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ECHEANCE_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ECHEANCE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21841 (class 0 OID 0)
-- Dependencies: 1108
-- Name: ECHEANCE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ECHEANCE_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto48"."ECHEANCE_FOURNISSEUR"."ID";


--
-- TOC entry 1109 (class 1259 OID 36397144)
-- Name: ECRITURE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ECRITURE" (
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "DATE_POINTEE" date,
    "DATE_LETTRAGE" date,
    "JOURNAL_NOM" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer,
    "POINTEE" character varying(45) DEFAULT ''::character varying,
    "DATE" date,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "DEBIT" bigint DEFAULT 0,
    "CREDIT" bigint DEFAULT 0,
    "ID_JOURNAL" integer DEFAULT 1,
    "IDUSER_VALIDE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "IDUSER_CREATE" integer DEFAULT 1,
    "COMPTE_NUMERO" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "COMPTE_NOM" character varying(2048) DEFAULT ''::text,
    "LETTRAGE" character varying(256) DEFAULT ''::character varying,
    "NOM" character varying(2048) DEFAULT ''::text,
    "JOURNAL_CODE" character varying(2048) DEFAULT ''::text,
    "VALIDE" boolean DEFAULT false,
    "ID_USER_COMMON_MODIFY" integer,
    "ORDRE" numeric(16,8),
    "IDUSER_DELETE" integer DEFAULT 1,
    "DATE_VALIDE" date,
    "DATE_EXPORT" date,
    "CODE_CLIENT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM_PIECE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "CLOTURE" boolean DEFAULT false NOT NULL,
    "RAN" boolean DEFAULT false NOT NULL,
    "DATE_ECHEANCE" date
);


ALTER TABLE "OpenConcerto48"."ECRITURE" OWNER TO openconcerto;

--
-- TOC entry 1110 (class 1259 OID 36397171)
-- Name: ECRITURE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ECRITURE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ECRITURE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21842 (class 0 OID 0)
-- Dependencies: 1110
-- Name: ECRITURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ECRITURE_ID_seq" OWNED BY "OpenConcerto48"."ECRITURE"."ID";


--
-- TOC entry 1111 (class 1259 OID 36397173)
-- Name: EMPLOYEUR_MULTIPLE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."EMPLOYEUR_MULTIPLE" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."EMPLOYEUR_MULTIPLE" OWNER TO openconcerto;

--
-- TOC entry 1112 (class 1259 OID 36397180)
-- Name: EMPLOYEUR_MULTIPLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."EMPLOYEUR_MULTIPLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."EMPLOYEUR_MULTIPLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21843 (class 0 OID 0)
-- Dependencies: 1112
-- Name: EMPLOYEUR_MULTIPLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."EMPLOYEUR_MULTIPLE_ID_seq" OWNED BY "OpenConcerto48"."EMPLOYEUR_MULTIPLE"."ID";


--
-- TOC entry 1113 (class 1259 OID 36397182)
-- Name: ENCAISSER_MONTANT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ENCAISSER_MONTANT" (
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MONTANT" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_ECHEANCE_CLIENT" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "NOM" character varying(200),
    "MODIFICATION_DATE" timestamp without time zone,
    "DATE" date,
    "ID_CLIENT" integer DEFAULT 1,
    "ID_TICKET_CAISSE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ACOMPTE" boolean DEFAULT false NOT NULL,
    "ID_DEVIS" integer DEFAULT 1,
    "TIERS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_COMPTE_PCE_TIERS" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."ENCAISSER_MONTANT" OWNER TO openconcerto;

--
-- TOC entry 1114 (class 1259 OID 36397196)
-- Name: ENCAISSER_MONTANT_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ENCAISSER_MONTANT_ELEMENT" (
    "MONTANT_A_REGLER" bigint DEFAULT 0,
    "MONTANT_REGLE" bigint DEFAULT 0,
    "ID_MOUVEMENT_ECHEANCE" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID_ENCAISSER_MONTANT" integer DEFAULT 1,
    "ID_ECHEANCE_CLIENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "DATE" date
);


ALTER TABLE "OpenConcerto48"."ENCAISSER_MONTANT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1115 (class 1259 OID 36397206)
-- Name: ENCAISSER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ENCAISSER_MONTANT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ENCAISSER_MONTANT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21844 (class 0 OID 0)
-- Dependencies: 1115
-- Name: ENCAISSER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ENCAISSER_MONTANT_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."ENCAISSER_MONTANT_ELEMENT"."ID";


--
-- TOC entry 1116 (class 1259 OID 36397208)
-- Name: ENCAISSER_MONTANT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ENCAISSER_MONTANT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ENCAISSER_MONTANT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21845 (class 0 OID 0)
-- Dependencies: 1116
-- Name: ENCAISSER_MONTANT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ENCAISSER_MONTANT_ID_seq" OWNED BY "OpenConcerto48"."ENCAISSER_MONTANT"."ID";


--
-- TOC entry 1117 (class 1259 OID 36397210)
-- Name: ETAT_CIVIL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ETAT_CIVIL" (
    "ID_DEPARTEMENT_NAISSANCE" integer DEFAULT 1,
    "PORTABLE" character varying(45) DEFAULT ''::character varying,
    "ID_SITUATION_FAMILIALE" integer DEFAULT 1,
    "MAIL" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "DATE_NAISSANCE" date,
    "NB_PERS_A_CHARGE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "COMMUNE_NAISSANCE" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "NB_ENFANTS" integer DEFAULT 0,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_PAYS_NAISSANCE" integer DEFAULT 1,
    "NUMERO_SS" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "TELEPHONE" character varying(45) DEFAULT ''::character varying,
    "NATIONNALITE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CNPS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TYPE_PIECE_IDENTITE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NUMERO_PIECE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM_PERE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM_MERE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CONJOINT_NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CONJOINT_DATE_NAISSANCE" date,
    "CONJOINT_LIEU_NAISSANCE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CONJOINT_PROFESSION" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DATE_DEBUT_PIECE" date,
    "DATE_FIN_PIECE" date,
    "NTT" character varying(50) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto48"."ETAT_CIVIL" OWNER TO openconcerto;

--
-- TOC entry 1118 (class 1259 OID 36397239)
-- Name: ETAT_CIVIL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ETAT_CIVIL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ETAT_CIVIL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21846 (class 0 OID 0)
-- Dependencies: 1118
-- Name: ETAT_CIVIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ETAT_CIVIL_ID_seq" OWNED BY "OpenConcerto48"."ETAT_CIVIL"."ID";


--
-- TOC entry 1119 (class 1259 OID 36397241)
-- Name: ETAT_DEMANDE_ACHAT_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ETAT_DEMANDE_ACHAT_ELEMENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "COLOR" integer,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."ETAT_DEMANDE_ACHAT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1120 (class 1259 OID 36397246)
-- Name: ETAT_DEMANDE_ACHAT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ETAT_DEMANDE_ACHAT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ETAT_DEMANDE_ACHAT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21847 (class 0 OID 0)
-- Dependencies: 1120
-- Name: ETAT_DEMANDE_ACHAT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ETAT_DEMANDE_ACHAT_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."ETAT_DEMANDE_ACHAT_ELEMENT"."ID";


--
-- TOC entry 1121 (class 1259 OID 36397248)
-- Name: ETAT_DEMANDE_PRIX; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ETAT_DEMANDE_PRIX" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."ETAT_DEMANDE_PRIX" OWNER TO openconcerto;

--
-- TOC entry 1122 (class 1259 OID 36397253)
-- Name: ETAT_DEMANDE_PRIX_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ETAT_DEMANDE_PRIX_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ETAT_DEMANDE_PRIX_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21848 (class 0 OID 0)
-- Dependencies: 1122
-- Name: ETAT_DEMANDE_PRIX_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ETAT_DEMANDE_PRIX_ID_seq" OWNED BY "OpenConcerto48"."ETAT_DEMANDE_PRIX"."ID";


--
-- TOC entry 1123 (class 1259 OID 36397255)
-- Name: ETAT_DEVIS; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ETAT_DEVIS" (
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."ETAT_DEVIS" OWNER TO openconcerto;

--
-- TOC entry 1124 (class 1259 OID 36397263)
-- Name: ETAT_DEVIS_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ETAT_DEVIS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ETAT_DEVIS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21849 (class 0 OID 0)
-- Dependencies: 1124
-- Name: ETAT_DEVIS_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ETAT_DEVIS_ID_seq" OWNED BY "OpenConcerto48"."ETAT_DEVIS"."ID";


--
-- TOC entry 1125 (class 1259 OID 36397265)
-- Name: ETAT_RAPPORT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ETAT_RAPPORT" (
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "NOM" character varying(2048),
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto48"."ETAT_RAPPORT" OWNER TO openconcerto;

--
-- TOC entry 1126 (class 1259 OID 36397275)
-- Name: ETAT_RAPPORT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ETAT_RAPPORT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ETAT_RAPPORT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21850 (class 0 OID 0)
-- Dependencies: 1126
-- Name: ETAT_RAPPORT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ETAT_RAPPORT_ID_seq" OWNED BY "OpenConcerto48"."ETAT_RAPPORT"."ID";


--
-- TOC entry 1278 (class 1259 OID 36414307)
-- Name: ETAT_STOCK; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ETAT_STOCK" (
    "ID" integer NOT NULL,
    "DATE" date,
    "MONTANT_HA" numeric(16,8) DEFAULT 0,
    "MONTANT_VT" numeric(16,8) DEFAULT 0,
    "INVENTAIRE" boolean DEFAULT false NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."ETAT_STOCK" OWNER TO openconcerto;

--
-- TOC entry 1280 (class 1259 OID 36414321)
-- Name: ETAT_STOCK_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."ETAT_STOCK_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_ETAT_STOCK" integer DEFAULT 1,
    "PA" numeric(16,8) DEFAULT 0,
    "PV" numeric(16,8) DEFAULT 0,
    "T_PA" numeric(16,8) DEFAULT 0,
    "T_PV" numeric(16,8) DEFAULT 0,
    "QTE" numeric(16,8) DEFAULT 0,
    "ECART" numeric(16,8) DEFAULT 0,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."ETAT_STOCK_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1279 (class 1259 OID 36414319)
-- Name: ETAT_STOCK_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ETAT_STOCK_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ETAT_STOCK_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21851 (class 0 OID 0)
-- Dependencies: 1279
-- Name: ETAT_STOCK_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ETAT_STOCK_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."ETAT_STOCK_ELEMENT"."ID";


--
-- TOC entry 1277 (class 1259 OID 36414305)
-- Name: ETAT_STOCK_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."ETAT_STOCK_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."ETAT_STOCK_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21852 (class 0 OID 0)
-- Dependencies: 1277
-- Name: ETAT_STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."ETAT_STOCK_ID_seq" OWNED BY "OpenConcerto48"."ETAT_STOCK"."ID";


--
-- TOC entry 1127 (class 1259 OID 36397277)
-- Name: FABRICANT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."FABRICANT" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."FABRICANT" OWNER TO openconcerto;

--
-- TOC entry 1128 (class 1259 OID 36397282)
-- Name: FABRICANT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."FABRICANT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."FABRICANT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21853 (class 0 OID 0)
-- Dependencies: 1128
-- Name: FABRICANT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."FABRICANT_ID_seq" OWNED BY "OpenConcerto48"."FABRICANT"."ID";


--
-- TOC entry 1129 (class 1259 OID 36397284)
-- Name: FACTURATION_COMMANDE_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."FACTURATION_COMMANDE_CLIENT" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TYPE_FACTURE" integer DEFAULT 1 NOT NULL,
    "CHOICE" boolean DEFAULT false NOT NULL,
    "ID_TYPE_REGLEMENT" integer DEFAULT 1,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "AJOURS" integer DEFAULT 0 NOT NULL,
    "MONTANT" numeric(16,8) DEFAULT 0 NOT NULL,
    "POURCENT" numeric(16,8) DEFAULT 0 NOT NULL,
    "COMPTANT" boolean DEFAULT false NOT NULL,
    "DATE_PREVISIONNELLE" date,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8),
    "FIN_MOIS" boolean DEFAULT false NOT NULL,
    "LENJOUR" integer DEFAULT 0 NOT NULL
);


ALTER TABLE "OpenConcerto48"."FACTURATION_COMMANDE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 1130 (class 1259 OID 36397301)
-- Name: FACTURATION_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."FACTURATION_COMMANDE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."FACTURATION_COMMANDE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21854 (class 0 OID 0)
-- Dependencies: 1130
-- Name: FACTURATION_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."FACTURATION_COMMANDE_CLIENT_ID_seq" OWNED BY "OpenConcerto48"."FACTURATION_COMMANDE_CLIENT"."ID";


--
-- TOC entry 1131 (class 1259 OID 36397303)
-- Name: FACTURE_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."FACTURE_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NUMERO" character varying(45) DEFAULT ''::character varying NOT NULL,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "DATE" date,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_AVOIR_FOURNISSEUR" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "T_HT" bigint DEFAULT 0,
    "T_TVA" bigint DEFAULT 0,
    "T_TTC" bigint DEFAULT 0,
    "T_SERVICE" bigint DEFAULT 0,
    "T_DEVISE" bigint DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "TAUX_APPLIQUE" numeric(12,6) DEFAULT 1,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "PORT_HT" bigint DEFAULT 0 NOT NULL,
    "REMISE_HT" bigint DEFAULT 0 NOT NULL,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "NET_A_PAYER" bigint DEFAULT 0 NOT NULL,
    "AVOIR_TTC" bigint DEFAULT 0 NOT NULL
);


ALTER TABLE "OpenConcerto48"."FACTURE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 1132 (class 1259 OID 36397333)
-- Name: FACTURE_FOURNISSEUR_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."FACTURE_FOURNISSEUR_ELEMENT" (
    "ID" integer NOT NULL,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PV_TTC" numeric(16,6) DEFAULT 0 NOT NULL,
    "T_PA_TTC" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 0 NOT NULL,
    "PA_DEVISE_T" numeric(16,6) DEFAULT 0 NOT NULL,
    "PA_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE" integer DEFAULT 1 NOT NULL,
    "QTE_ACHAT" integer DEFAULT 1 NOT NULL,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "T_POIDS" real DEFAULT 0,
    "POIDS" real DEFAULT 0,
    "SERVICE" boolean DEFAULT false,
    "CODE" character varying(45) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DATE" date,
    "ID_STYLE" integer DEFAULT 1,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ID_FACTURE_FOURNISSEUR" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 5,
    "ID_UNITE_VENTE" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_CODE_FOURNISSEUR" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_DEMANDE_ACHAT_ELEMENT" integer DEFAULT 1,
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."FACTURE_FOURNISSEUR_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1133 (class 1259 OID 36397384)
-- Name: FACTURE_FOURNISSEUR_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."FACTURE_FOURNISSEUR_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."FACTURE_FOURNISSEUR_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21855 (class 0 OID 0)
-- Dependencies: 1133
-- Name: FACTURE_FOURNISSEUR_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."FACTURE_FOURNISSEUR_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."FACTURE_FOURNISSEUR_ELEMENT"."ID";


--
-- TOC entry 1134 (class 1259 OID 36397386)
-- Name: FACTURE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."FACTURE_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."FACTURE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21856 (class 0 OID 0)
-- Dependencies: 1134
-- Name: FACTURE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."FACTURE_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto48"."FACTURE_FOURNISSEUR"."ID";


--
-- TOC entry 1135 (class 1259 OID 36397388)
-- Name: FAMILLE_ARTICLE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."FAMILLE_ARTICLE" (
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "ID_FAMILLE_ARTICLE_PERE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."FAMILLE_ARTICLE" OWNER TO openconcerto;

--
-- TOC entry 1136 (class 1259 OID 36397399)
-- Name: FAMILLE_ARTICLE_FOURNISSEUR; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."FAMILLE_ARTICLE_FOURNISSEUR" (
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ID_FAMILLE_ARTICLE_FOURNISSEUR_PERE" integer,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."FAMILLE_ARTICLE_FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 1137 (class 1259 OID 36397409)
-- Name: FAMILLE_ARTICLE_FOURNISSEUR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."FAMILLE_ARTICLE_FOURNISSEUR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."FAMILLE_ARTICLE_FOURNISSEUR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21857 (class 0 OID 0)
-- Dependencies: 1137
-- Name: FAMILLE_ARTICLE_FOURNISSEUR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."FAMILLE_ARTICLE_FOURNISSEUR_ID_seq" OWNED BY "OpenConcerto48"."FAMILLE_ARTICLE_FOURNISSEUR"."ID";


--
-- TOC entry 1138 (class 1259 OID 36397411)
-- Name: FAMILLE_ARTICLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."FAMILLE_ARTICLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."FAMILLE_ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21858 (class 0 OID 0)
-- Dependencies: 1138
-- Name: FAMILLE_ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."FAMILLE_ARTICLE_ID_seq" OWNED BY "OpenConcerto48"."FAMILLE_ARTICLE"."ID";


--
-- TOC entry 1139 (class 1259 OID 36397413)
-- Name: FICHE_PAYE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."FICHE_PAYE" (
    "ID_VARIABLE_SALARIE" integer DEFAULT 1,
    "VALIDE" boolean DEFAULT false,
    "DU" date,
    "NET_A_PAYER" numeric(16,2) DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NET_IMP" numeric(16,2) DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_CUMULS_CONGES" integer DEFAULT 1,
    "ID_IDCC" integer DEFAULT 1,
    "COT_PAT" numeric(16,2) DEFAULT 0,
    "ID_REGLEMENT_PAYE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NATURE_EMPLOI" character varying(150) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "SAL_BRUT" numeric(16,2) DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "AU" date,
    "ACOMPTE" numeric(16,2) DEFAULT 0,
    "ID_MOIS" integer DEFAULT 1,
    "ID_CUMULS_PAYE" integer DEFAULT 1,
    "COT_SAL" numeric(16,2) DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "CONGES_ACQUIS" real DEFAULT 0,
    "CSG" numeric(16,2) DEFAULT 0,
    "ANNEE" integer DEFAULT 0,
    "ID_SALARIE" integer DEFAULT 1,
    "ID_PROFIL_PAYE" integer DEFAULT 1,
    "ID_INFOS_SALARIE_PAYE" integer DEFAULT 1,
    "SAL_BASE_BRUT" numeric(16,2) DEFAULT 0 NOT NULL,
    "TAXE_CM_SAL" numeric(16,2) DEFAULT 0 NOT NULL,
    "TAXE_CM_PAT" numeric(16,2) DEFAULT 0 NOT NULL,
    "SAL_BRUT_COTISABLE" numeric(16,2) DEFAULT 0 NOT NULL,
    "SAL_BRUT_TAXABLE" numeric(16,2) DEFAULT 0 NOT NULL,
    "ALLEGEMENT_COTISATION" numeric(16,2) DEFAULT 0 NOT NULL,
    "CICE" numeric(16,2) DEFAULT 0 NOT NULL,
    "AVANTAGE_NATURE" numeric(16,2) DEFAULT 0 NOT NULL,
    "HEURE_TRAV" numeric(16,2) DEFAULT 0 NOT NULL,
    "DETAILS_CONGES" character varying(512) DEFAULT ''::character varying NOT NULL,
    "REDUCTION_GVT" numeric(16,2) DEFAULT 0 NOT NULL,
    "ID_PAS" integer DEFAULT 1,
    "TOTAL_PAS" numeric(16,2) DEFAULT 0 NOT NULL,
    "NET_AVANT_PAS" numeric(16,2) DEFAULT 0 NOT NULL
);


ALTER TABLE "OpenConcerto48"."FICHE_PAYE" OWNER TO openconcerto;

--
-- TOC entry 1140 (class 1259 OID 36397451)
-- Name: FICHE_PAYE_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."FICHE_PAYE_ELEMENT" (
    "ID_FICHE_PAYE" integer DEFAULT 1,
    "POSITION" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "TAUX_SAL" numeric(16,6) DEFAULT 0,
    "NB_BASE" numeric(16,6) DEFAULT 0,
    "IDSOURCE" integer DEFAULT 1,
    "TAUX_PAT" numeric(16,6) DEFAULT 0,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "MONTANT_PAT" numeric(16,2) DEFAULT 0,
    "ID" integer NOT NULL,
    "VALIDE" boolean DEFAULT false,
    "CREATION_DATE" timestamp without time zone,
    "MONTANT_SAL_AJ" numeric(16,2) DEFAULT 0,
    "MONTANT_SAL_DED" numeric(16,2) DEFAULT 0,
    "IN_PERIODE" boolean DEFAULT true,
    "IMPRESSION" boolean DEFAULT true,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_STYLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."FICHE_PAYE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1141 (class 1259 OID 36397475)
-- Name: FICHE_PAYE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."FICHE_PAYE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."FICHE_PAYE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21859 (class 0 OID 0)
-- Dependencies: 1141
-- Name: FICHE_PAYE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."FICHE_PAYE_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."FICHE_PAYE_ELEMENT"."ID";


--
-- TOC entry 1142 (class 1259 OID 36397477)
-- Name: FICHE_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."FICHE_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."FICHE_PAYE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21860 (class 0 OID 0)
-- Dependencies: 1142
-- Name: FICHE_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."FICHE_PAYE_ID_seq" OWNED BY "OpenConcerto48"."FICHE_PAYE"."ID";


--
-- TOC entry 1143 (class 1259 OID 36397479)
-- Name: FIN_CONTRAT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."FIN_CONTRAT" (
    "ID" integer NOT NULL,
    "ID_FICHE_PAYE" integer DEFAULT 1,
    "ID_MOTIF_FIN_CONTRAT" integer DEFAULT 1,
    "DATE_FIN" timestamp without time zone,
    "DATE_NOTIFICATION" timestamp without time zone,
    "DATE_SIGNATURE_CONVENTION" timestamp without time zone,
    "DATE_ENGAGEMENT_PROCEDURE" timestamp without time zone,
    "DERNIER_JOUR_TRAV_PAYE" timestamp without time zone,
    "TRANSACTION_EN_COURS" boolean DEFAULT false NOT NULL,
    "PORTABILITE_PREVOYANCE" boolean DEFAULT false NOT NULL,
    "NB_DIF_RESTANT" integer,
    "NB_MOIS_CSP" integer,
    "SALAIRE_NET_HORAIRE" numeric(16,8),
    "INDEMNITE_VERSE" numeric(16,8),
    "ID_TYPE_PREAVIS" integer DEFAULT 1,
    "DATE_DEBUT_PREAVIS" timestamp without time zone,
    "DATE_FIN_PREAVIS" timestamp without time zone,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."FIN_CONTRAT" OWNER TO openconcerto;

--
-- TOC entry 1144 (class 1259 OID 36397493)
-- Name: FIN_CONTRAT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."FIN_CONTRAT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."FIN_CONTRAT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21861 (class 0 OID 0)
-- Dependencies: 1144
-- Name: FIN_CONTRAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."FIN_CONTRAT_ID_seq" OWNED BY "OpenConcerto48"."FIN_CONTRAT"."ID";


--
-- TOC entry 1145 (class 1259 OID 36397495)
-- Name: FOURNISSEUR; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."FOURNISSEUR" (
    "TYPE" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_CREATE" integer,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "CODE" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "ID_ADRESSE" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer NOT NULL,
    "UE" boolean DEFAULT false,
    "ID_ADRESSE_E" integer DEFAULT 1,
    "FAX" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "TEL" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_LANGUE" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "RESPONSABLE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TEL_P" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MAIL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "INFOS" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ID_COMPTE_PCE_CHARGE" integer DEFAULT 1,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "NUMERO_TVA" character varying(128) DEFAULT ''::character varying NOT NULL,
    "SIRET" character varying(128) DEFAULT ''::character varying NOT NULL,
    "IBAN" character varying(128) DEFAULT ''::character varying NOT NULL,
    "BIC" character varying(128) DEFAULT ''::character varying NOT NULL,
    "ID_CATEGORIE_COMPTABLE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."FOURNISSEUR" OWNER TO openconcerto;

--
-- TOC entry 1146 (class 1259 OID 36397524)
-- Name: FOURNISSEUR_ID_FOURNISSEUR_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."FOURNISSEUR_ID_FOURNISSEUR_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."FOURNISSEUR_ID_FOURNISSEUR_seq" OWNER TO openconcerto;

--
-- TOC entry 21862 (class 0 OID 0)
-- Dependencies: 1146
-- Name: FOURNISSEUR_ID_FOURNISSEUR_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."FOURNISSEUR_ID_FOURNISSEUR_seq" OWNED BY "OpenConcerto48"."FOURNISSEUR"."ID_FOURNISSEUR";


--
-- TOC entry 1288 (class 1259 OID 36414576)
-- Name: FRAIS_DOCUMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."FRAIS_DOCUMENT" (
    "ID" integer NOT NULL,
    "CODE" character varying(48) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "MONTANT_HT" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE" integer DEFAULT 1,
    "MONTANT_TTC" bigint DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."FRAIS_DOCUMENT" OWNER TO openconcerto;

--
-- TOC entry 1287 (class 1259 OID 36414574)
-- Name: FRAIS_DOCUMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."FRAIS_DOCUMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."FRAIS_DOCUMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21863 (class 0 OID 0)
-- Dependencies: 1287
-- Name: FRAIS_DOCUMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."FRAIS_DOCUMENT_ID_seq" OWNED BY "OpenConcerto48"."FRAIS_DOCUMENT"."ID";


--
-- TOC entry 1147 (class 1259 OID 36397526)
-- Name: FWK_MODULE_DEP; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."FWK_MODULE_DEP" (
    "ID_MODULE" integer NOT NULL,
    "ID_MODULE_NEEDED" integer NOT NULL
);


ALTER TABLE "OpenConcerto48"."FWK_MODULE_DEP" OWNER TO openconcerto;

--
-- TOC entry 1148 (class 1259 OID 36397529)
-- Name: FWK_MODULE_METADATA; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."FWK_MODULE_METADATA" (
    "ID" integer NOT NULL,
    "MODULE_NAME" character varying(128) DEFAULT ''::character varying NOT NULL,
    "TABLE" character varying(128),
    "FIELD" character varying(128),
    "KEY" boolean,
    "MODULE_VERSION" bigint NOT NULL
);


ALTER TABLE "OpenConcerto48"."FWK_MODULE_METADATA" OWNER TO openconcerto;

--
-- TOC entry 1149 (class 1259 OID 36397533)
-- Name: FWK_MODULE_METADATA_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."FWK_MODULE_METADATA_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."FWK_MODULE_METADATA_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21864 (class 0 OID 0)
-- Dependencies: 1149
-- Name: FWK_MODULE_METADATA_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."FWK_MODULE_METADATA_ID_seq" OWNED BY "OpenConcerto48"."FWK_MODULE_METADATA"."ID";


--
-- TOC entry 1150 (class 1259 OID 36397535)
-- Name: FWK_SCHEMA_METADATA; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."FWK_SCHEMA_METADATA" (
    "NAME" character varying(100) DEFAULT ''::character varying NOT NULL,
    "VALUE" character varying(250) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto48"."FWK_SCHEMA_METADATA" OWNER TO openconcerto;

--
-- TOC entry 1151 (class 1259 OID 36397540)
-- Name: FWK_UNDEFINED_IDS; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."FWK_UNDEFINED_IDS" (
    "UNDEFINED_ID" integer DEFAULT 0,
    "TABLENAME" character varying(250) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto48"."FWK_UNDEFINED_IDS" OWNER TO openconcerto;

--
-- TOC entry 1152 (class 1259 OID 36397545)
-- Name: IDCC; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."IDCC" (
    "ORDRE" numeric(16,8),
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."IDCC" OWNER TO openconcerto;

--
-- TOC entry 1153 (class 1259 OID 36397556)
-- Name: IDCC_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."IDCC_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."IDCC_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21865 (class 0 OID 0)
-- Dependencies: 1153
-- Name: IDCC_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."IDCC_ID_seq" OWNED BY "OpenConcerto48"."IDCC"."ID";


--
-- TOC entry 1154 (class 1259 OID 36397558)
-- Name: INFOS_SALARIE_PAYE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."INFOS_SALARIE_PAYE" (
    "DUREE_HEBDO" real DEFAULT 0,
    "ORDRE" numeric(16,8),
    "TAUX_AT" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "SALAIRE_MOIS" real DEFAULT 0,
    "ID_CONTRAT_SALARIE" integer DEFAULT 1,
    "CONGES_PAYES" real DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "DATE_SORTIE" date,
    "ID_IDCC" integer DEFAULT 1,
    "DATE_ARRIVE" date,
    "DUREE_MOIS" real DEFAULT 0,
    "ID_CLASSEMENT_CONVENTIONNEL" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "CODE_AT" character varying(18) DEFAULT ''::character varying NOT NULL,
    "CODE_SECTION_AT" character varying(18) DEFAULT ''::character varying NOT NULL,
    "ID_COEFF_PRIME" integer DEFAULT 1,
    "ID_SALARIE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."INFOS_SALARIE_PAYE" OWNER TO openconcerto;

--
-- TOC entry 1155 (class 1259 OID 36397576)
-- Name: INFOS_SALARIE_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."INFOS_SALARIE_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."INFOS_SALARIE_PAYE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21866 (class 0 OID 0)
-- Dependencies: 1155
-- Name: INFOS_SALARIE_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."INFOS_SALARIE_PAYE_ID_seq" OWNED BY "OpenConcerto48"."INFOS_SALARIE_PAYE"."ID";


--
-- TOC entry 1156 (class 1259 OID 36397578)
-- Name: JOURNAL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."JOURNAL" (
    "PAR_DEFAUT" boolean DEFAULT false,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "TYPE_BANQUE" boolean DEFAULT false,
    "CODE" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."JOURNAL" OWNER TO openconcerto;

--
-- TOC entry 1157 (class 1259 OID 36397589)
-- Name: JOURNAL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."JOURNAL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."JOURNAL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21867 (class 0 OID 0)
-- Dependencies: 1157
-- Name: JOURNAL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."JOURNAL_ID_seq" OWNED BY "OpenConcerto48"."JOURNAL"."ID";


--
-- TOC entry 1158 (class 1259 OID 36397591)
-- Name: LANGUE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."LANGUE" (
    "ID" integer NOT NULL,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CHEMIN" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."LANGUE" OWNER TO openconcerto;

--
-- TOC entry 1159 (class 1259 OID 36397602)
-- Name: LANGUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."LANGUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."LANGUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21868 (class 0 OID 0)
-- Dependencies: 1159
-- Name: LANGUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."LANGUE_ID_seq" OWNED BY "OpenConcerto48"."LANGUE"."ID";


--
-- TOC entry 1160 (class 1259 OID 36397604)
-- Name: METRIQUE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."METRIQUE" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "UNITE" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto48"."METRIQUE" OWNER TO openconcerto;

--
-- TOC entry 1161 (class 1259 OID 36397612)
-- Name: METRIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."METRIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."METRIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21869 (class 0 OID 0)
-- Dependencies: 1161
-- Name: METRIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."METRIQUE_ID_seq" OWNED BY "OpenConcerto48"."METRIQUE"."ID";


--
-- TOC entry 1162 (class 1259 OID 36397614)
-- Name: MODELE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."MODELE" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_TYPE_MODELE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."MODELE" OWNER TO openconcerto;

--
-- TOC entry 1163 (class 1259 OID 36397621)
-- Name: MODELE_COURRIER_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."MODELE_COURRIER_CLIENT" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CODE" character varying(10) DEFAULT ''::character varying,
    "LOCATION" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "CONTENU" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."MODELE_COURRIER_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 1164 (class 1259 OID 36397635)
-- Name: MODELE_COURRIER_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."MODELE_COURRIER_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."MODELE_COURRIER_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21870 (class 0 OID 0)
-- Dependencies: 1164
-- Name: MODELE_COURRIER_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."MODELE_COURRIER_CLIENT_ID_seq" OWNED BY "OpenConcerto48"."MODELE_COURRIER_CLIENT"."ID";


--
-- TOC entry 1165 (class 1259 OID 36397637)
-- Name: MODELE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."MODELE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."MODELE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21871 (class 0 OID 0)
-- Dependencies: 1165
-- Name: MODELE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."MODELE_ID_seq" OWNED BY "OpenConcerto48"."MODELE"."ID";


--
-- TOC entry 1166 (class 1259 OID 36397639)
-- Name: MODE_REGLEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."MODE_REGLEMENT" (
    "FIN_MOIS" boolean DEFAULT false,
    "ORDRE" numeric(16,8),
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "DATE_VIREMENT" date,
    "DATE_FACTURE" boolean DEFAULT false,
    "LENJOUR" integer DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_TYPE_REGLEMENT" integer DEFAULT 1,
    "ETS" character varying(2048) DEFAULT ''::text,
    "COMPTANT" boolean DEFAULT false,
    "DATE_DEPOT" date,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CODE" character varying(2048) DEFAULT ''::text,
    "AJOURS" integer DEFAULT 0,
    "DATE" date,
    "ID_MODE_REGLEMENT" integer NOT NULL,
    "ID_BANQUE" integer DEFAULT 1,
    "ID_SEPA_MANDATE" integer
);


ALTER TABLE "OpenConcerto48"."MODE_REGLEMENT" OWNER TO openconcerto;

--
-- TOC entry 1167 (class 1259 OID 36397659)
-- Name: MODE_REGLEMENT_ID_MODE_REGLEMENT_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."MODE_REGLEMENT_ID_MODE_REGLEMENT_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."MODE_REGLEMENT_ID_MODE_REGLEMENT_seq" OWNER TO openconcerto;

--
-- TOC entry 21872 (class 0 OID 0)
-- Dependencies: 1167
-- Name: MODE_REGLEMENT_ID_MODE_REGLEMENT_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."MODE_REGLEMENT_ID_MODE_REGLEMENT_seq" OWNED BY "OpenConcerto48"."MODE_REGLEMENT"."ID_MODE_REGLEMENT";


--
-- TOC entry 1168 (class 1259 OID 36397661)
-- Name: MODE_REGLEMENT_PAYE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."MODE_REGLEMENT_PAYE" (
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto48"."MODE_REGLEMENT_PAYE" OWNER TO openconcerto;

--
-- TOC entry 1169 (class 1259 OID 36397665)
-- Name: MODE_REGLEMENT_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."MODE_REGLEMENT_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."MODE_REGLEMENT_PAYE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21873 (class 0 OID 0)
-- Dependencies: 1169
-- Name: MODE_REGLEMENT_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."MODE_REGLEMENT_PAYE_ID_seq" OWNED BY "OpenConcerto48"."MODE_REGLEMENT_PAYE"."ID";


--
-- TOC entry 1170 (class 1259 OID 36397667)
-- Name: MODE_VENTE_ARTICLE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."MODE_VENTE_ARTICLE" (
    "CREATION_DATE" timestamp without time zone,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "PRIX_METRIQUE_VT_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_2" bigint DEFAULT 0,
    "PRIX_METRIQUE_HA_1" bigint DEFAULT 0,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8) DEFAULT 0.00000000,
    "PRIX_METRIQUE_HA_3" bigint DEFAULT 0,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "PRIX_METRIQUE_VT_3" bigint DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "PRIX_METRIQUE_VT_1" bigint DEFAULT 0,
    "ID_METRIQUE_2" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."MODE_VENTE_ARTICLE" OWNER TO openconcerto;

--
-- TOC entry 1171 (class 1259 OID 36397685)
-- Name: MODE_VENTE_ARTICLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."MODE_VENTE_ARTICLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."MODE_VENTE_ARTICLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21874 (class 0 OID 0)
-- Dependencies: 1171
-- Name: MODE_VENTE_ARTICLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."MODE_VENTE_ARTICLE_ID_seq" OWNED BY "OpenConcerto48"."MODE_VENTE_ARTICLE"."ID";


--
-- TOC entry 1172 (class 1259 OID 36397687)
-- Name: MOIS; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."MOIS" (
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."MOIS" OWNER TO openconcerto;

--
-- TOC entry 1173 (class 1259 OID 36397694)
-- Name: MOIS_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."MOIS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."MOIS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21875 (class 0 OID 0)
-- Dependencies: 1173
-- Name: MOIS_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."MOIS_ID_seq" OWNED BY "OpenConcerto48"."MOIS"."ID";


--
-- TOC entry 1174 (class 1259 OID 36397696)
-- Name: MOUVEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."MOUVEMENT" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "SOURCE" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "ID_MOUVEMENT_PERE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_PIECE" integer DEFAULT 1,
    "IDSOURCE" integer DEFAULT 1,
    "NUMERO" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL
);


ALTER TABLE "OpenConcerto48"."MOUVEMENT" OWNER TO openconcerto;

--
-- TOC entry 1175 (class 1259 OID 36397711)
-- Name: MOUVEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."MOUVEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."MOUVEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21876 (class 0 OID 0)
-- Dependencies: 1175
-- Name: MOUVEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."MOUVEMENT_ID_seq" OWNED BY "OpenConcerto48"."MOUVEMENT"."ID";


--
-- TOC entry 1176 (class 1259 OID 36397713)
-- Name: MOUVEMENT_STOCK; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."MOUVEMENT_STOCK" (
    "ID" integer NOT NULL,
    "DATE" date,
    "NUMERO" character varying(150) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_ARTICLE" integer DEFAULT 1,
    "QTE" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "IDSOURCE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "REEL" boolean DEFAULT true NOT NULL,
    "CLOTURE" boolean DEFAULT false NOT NULL,
    "OUVERTURE" boolean DEFAULT false NOT NULL,
    "ID_ETAT_STOCK" integer DEFAULT 1,
    "ID_STOCK" integer DEFAULT 1,
    "SOURCE_ELEMENTID" integer DEFAULT 1 NOT NULL
);


ALTER TABLE "OpenConcerto48"."MOUVEMENT_STOCK" OWNER TO openconcerto;

--
-- TOC entry 1177 (class 1259 OID 36397726)
-- Name: MOUVEMENT_STOCK_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."MOUVEMENT_STOCK_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."MOUVEMENT_STOCK_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21877 (class 0 OID 0)
-- Dependencies: 1177
-- Name: MOUVEMENT_STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."MOUVEMENT_STOCK_ID_seq" OWNED BY "OpenConcerto48"."MOUVEMENT_STOCK"."ID";


--
-- TOC entry 1178 (class 1259 OID 36397728)
-- Name: NATURE_COMPTE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."NATURE_COMPTE" (
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."NATURE_COMPTE" OWNER TO openconcerto;

--
-- TOC entry 1179 (class 1259 OID 36397738)
-- Name: NATURE_COMPTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."NATURE_COMPTE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."NATURE_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21878 (class 0 OID 0)
-- Dependencies: 1179
-- Name: NATURE_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."NATURE_COMPTE_ID_seq" OWNED BY "OpenConcerto48"."NATURE_COMPTE"."ID";


--
-- TOC entry 1180 (class 1259 OID 36397740)
-- Name: NUMEROTATION_AUTO; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."NUMEROTATION_AUTO" (
    "BON_L_FORMAT" character varying(45) DEFAULT ''::character varying,
    "RELANCE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COURRIER_START" integer DEFAULT 1,
    "AFFAIRE_START" integer DEFAULT 0,
    "DEVIS_FORMAT" character varying(45) DEFAULT ''::character varying,
    "AVOIR_START" integer DEFAULT 0,
    "SALARIE_START" integer DEFAULT 1,
    "PROPOSITION_START" integer DEFAULT 0,
    "BON_R_START" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "FACT_START" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "FACT_FORMAT" character varying(45) DEFAULT ''::character varying,
    "SALARIE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "ARCHIVE" integer DEFAULT 0,
    "COMMANDE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COMMANDE_CLIENT_START" integer DEFAULT 0,
    "COMMANDE_START" integer DEFAULT 0,
    "BON_R_FORMAT" character varying(45) DEFAULT ''::character varying,
    "BON_L_START" integer DEFAULT 1,
    "DEVIS_START" integer DEFAULT 1,
    "RELANCE_START" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "PROPOSITION_FORMAT" character varying(45) DEFAULT ''::character varying,
    "AFFAIRE_FORMAT" character varying(45) DEFAULT ''::character varying,
    "COURRIER_FORMAT" character varying(45) DEFAULT ''::character varying,
    "AVOIR_FORMAT" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "CODE_LETTRAGE" character varying(128) DEFAULT 'AAA'::character varying,
    "COMMANDE_CLIENT_FORMAT" character varying(45) DEFAULT ''::character varying,
    "AVOIR_F_START" integer DEFAULT 0,
    "AVOIR_F_FORMAT" character varying(48) DEFAULT ''::character varying NOT NULL,
    "CLIENT_START" integer DEFAULT 0,
    "CLIENT_FORMAT" character varying(48) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT 'Standard'::character varying,
    "DMD_PRIX_FORMAT" character varying(128) DEFAULT ''::character varying NOT NULL,
    "DMD_PRIX_START" integer DEFAULT 1 NOT NULL
);


ALTER TABLE "OpenConcerto48"."NUMEROTATION_AUTO" OWNER TO openconcerto;

--
-- TOC entry 1181 (class 1259 OID 36397781)
-- Name: NUMEROTATION_AUTO_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."NUMEROTATION_AUTO_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."NUMEROTATION_AUTO_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21879 (class 0 OID 0)
-- Dependencies: 1181
-- Name: NUMEROTATION_AUTO_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."NUMEROTATION_AUTO_ID_seq" OWNED BY "OpenConcerto48"."NUMEROTATION_AUTO"."ID";


--
-- TOC entry 1182 (class 1259 OID 36397783)
-- Name: OBJECTIF_COMMERCIAL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."OBJECTIF_COMMERCIAL" (
    "ID" integer NOT NULL,
    "MOIS" character varying(32) DEFAULT ''::character varying NOT NULL,
    "ANNEE" integer,
    "MARGE_HT" bigint DEFAULT 0,
    "POURCENT_MARGE" numeric(16,8),
    "CHIFFRE_AFFAIRE" bigint DEFAULT 0,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."OBJECTIF_COMMERCIAL" OWNER TO openconcerto;

--
-- TOC entry 1183 (class 1259 OID 36397792)
-- Name: OBJECTIF_COMMERCIAL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."OBJECTIF_COMMERCIAL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."OBJECTIF_COMMERCIAL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21880 (class 0 OID 0)
-- Dependencies: 1183
-- Name: OBJECTIF_COMMERCIAL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."OBJECTIF_COMMERCIAL_ID_seq" OWNED BY "OpenConcerto48"."OBJECTIF_COMMERCIAL"."ID";


--
-- TOC entry 1290 (class 1259 OID 36414761)
-- Name: PAS; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."PAS" (
    "ID" integer NOT NULL,
    "ID_TYPE_TAUX_PAS" integer DEFAULT 1,
    "CODE_PAS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "TAUX_PAS" numeric(16,2) DEFAULT 0 NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."PAS" OWNER TO openconcerto;

--
-- TOC entry 1289 (class 1259 OID 36414759)
-- Name: PAS_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."PAS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."PAS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21881 (class 0 OID 0)
-- Dependencies: 1289
-- Name: PAS_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."PAS_ID_seq" OWNED BY "OpenConcerto48"."PAS"."ID";


--
-- TOC entry 1184 (class 1259 OID 36397794)
-- Name: PAYS; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."PAYS" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "NOM" character varying(50) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "CODE" character varying(15) DEFAULT ''::character varying,
    "ID_TARIF" integer DEFAULT 1,
    "ID_LANGUE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."PAYS" OWNER TO openconcerto;

--
-- TOC entry 1185 (class 1259 OID 36397804)
-- Name: PAYS_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."PAYS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."PAYS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21882 (class 0 OID 0)
-- Dependencies: 1185
-- Name: PAYS_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."PAYS_ID_seq" OWNED BY "OpenConcerto48"."PAYS"."ID";


--
-- TOC entry 1186 (class 1259 OID 36397806)
-- Name: PIECE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."PIECE" (
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto48"."PIECE" OWNER TO openconcerto;

--
-- TOC entry 1187 (class 1259 OID 36397816)
-- Name: PIECE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."PIECE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."PIECE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21883 (class 0 OID 0)
-- Dependencies: 1187
-- Name: PIECE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."PIECE_ID_seq" OWNED BY "OpenConcerto48"."PIECE"."ID";


--
-- TOC entry 1188 (class 1259 OID 36397818)
-- Name: POSTE_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."POSTE_ANALYTIQUE" (
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_AXE_ANALYTIQUE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "DEFAULT" boolean DEFAULT false NOT NULL,
    "OBSOLETE" boolean DEFAULT false NOT NULL
);


ALTER TABLE "OpenConcerto48"."POSTE_ANALYTIQUE" OWNER TO openconcerto;

--
-- TOC entry 1189 (class 1259 OID 36397830)
-- Name: POSTE_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."POSTE_ANALYTIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."POSTE_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21884 (class 0 OID 0)
-- Dependencies: 1189
-- Name: POSTE_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."POSTE_ANALYTIQUE_ID_seq" OWNED BY "OpenConcerto48"."POSTE_ANALYTIQUE"."ID";


--
-- TOC entry 1190 (class 1259 OID 36397832)
-- Name: PREFERENCES; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."PREFERENCES" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "NAME" character varying(2048),
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "VALUE" character varying(2048),
    "CREATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."PREFERENCES" OWNER TO openconcerto;

--
-- TOC entry 1191 (class 1259 OID 36397842)
-- Name: PREFERENCES_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."PREFERENCES_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."PREFERENCES_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21885 (class 0 OID 0)
-- Dependencies: 1191
-- Name: PREFERENCES_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."PREFERENCES_ID_seq" OWNED BY "OpenConcerto48"."PREFERENCES"."ID";


--
-- TOC entry 1192 (class 1259 OID 36397844)
-- Name: PREFS_COMPTE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."PREFS_COMPTE" (
    "ID_COMPTE_PCE_TVA_IMMO" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE_SERVICE" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE_PRODUIT" integer DEFAULT 1,
    "ID_COMPTE_PCE_BILAN_O" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACOMPTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_TVA_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_BILAN_F" integer DEFAULT 1,
    "ID_COMPTE_PCE_CLIENT" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACHAT_INTRA" integer DEFAULT 1,
    "ID_COMPTE_PCE_RESULTAT_PERTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_ACOMPTE_REGL" integer DEFAULT 1,
    "ID_COMPTE_PCE_FACTOR" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ID_COMPTE_PCE_TVA_ACHAT" integer DEFAULT 1,
    "ID_COMPTE_PCE_PAYE" integer DEFAULT 1,
    "ID_COMPTE_PCE_FOURNISSEUR" integer DEFAULT 1,
    "ID_COMPTE_PCE_TVA_INTRA" integer DEFAULT 1,
    "ID_COMPTE_PCE_RESULTAT" integer DEFAULT 1,
    "ID_JOURNAL_FACTOR" integer DEFAULT 1,
    "ID_COMPTE_PCE_PORT_SOUMIS" integer DEFAULT 1,
    "ID_COMPTE_PCE_PORT_NON_SOUMIS" integer DEFAULT 1,
    "ID_COMPTE_PCE_AVANCE_CLIENT" integer DEFAULT 1,
    "ID_COMPTE_PCE_VALEUR_ENCAISSEMENT" integer DEFAULT 1,
    "ID_JOURNAL_AN" integer DEFAULT 1,
    "CREATE_NUL_SOLDE_ECR" boolean DEFAULT true NOT NULL,
    "AUTO_LETTRAGE" boolean DEFAULT false NOT NULL
);


ALTER TABLE "OpenConcerto48"."PREFS_COMPTE" OWNER TO openconcerto;

--
-- TOC entry 1193 (class 1259 OID 36397873)
-- Name: PREFS_COMPTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."PREFS_COMPTE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."PREFS_COMPTE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21886 (class 0 OID 0)
-- Dependencies: 1193
-- Name: PREFS_COMPTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."PREFS_COMPTE_ID_seq" OWNED BY "OpenConcerto48"."PREFS_COMPTE"."ID";


--
-- TOC entry 1194 (class 1259 OID 36397875)
-- Name: REFERENCE_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."REFERENCE_CLIENT" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto48"."REFERENCE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 1195 (class 1259 OID 36397886)
-- Name: REFERENCE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."REFERENCE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."REFERENCE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21887 (class 0 OID 0)
-- Dependencies: 1195
-- Name: REFERENCE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."REFERENCE_CLIENT_ID_seq" OWNED BY "OpenConcerto48"."REFERENCE_CLIENT"."ID";


--
-- TOC entry 1196 (class 1259 OID 36397888)
-- Name: REGIME_BASE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."REGIME_BASE" (
    "ID_CODE_REGIME_MALADIE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ID_CODE_REGIME_VIEL_S" integer DEFAULT 1,
    "NOM" character varying(128) DEFAULT ''::character varying NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID" integer NOT NULL,
    "ID_CODE_REGIME_BASE" integer DEFAULT 1,
    "ID_CODE_REGIME_AT" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_CODE_REGIME_VIEL_P" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."REGIME_BASE" OWNER TO openconcerto;

--
-- TOC entry 1197 (class 1259 OID 36397901)
-- Name: REGIME_BASE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."REGIME_BASE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."REGIME_BASE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21888 (class 0 OID 0)
-- Dependencies: 1197
-- Name: REGIME_BASE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."REGIME_BASE_ID_seq" OWNED BY "OpenConcerto48"."REGIME_BASE"."ID";


--
-- TOC entry 1198 (class 1259 OID 36397903)
-- Name: REGLEMENT_PAYE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."REGLEMENT_PAYE" (
    "MODIFICATION_DATE" timestamp without time zone,
    "ARCHIVE" integer DEFAULT 0,
    "RIB" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "NOM_BANQUE" character varying(45) DEFAULT ''::character varying,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "LE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_MODE_REGLEMENT_PAYE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."REGLEMENT_PAYE" OWNER TO openconcerto;

--
-- TOC entry 1199 (class 1259 OID 36397914)
-- Name: REGLEMENT_PAYE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."REGLEMENT_PAYE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."REGLEMENT_PAYE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21889 (class 0 OID 0)
-- Dependencies: 1199
-- Name: REGLEMENT_PAYE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."REGLEMENT_PAYE_ID_seq" OWNED BY "OpenConcerto48"."REGLEMENT_PAYE"."ID";


--
-- TOC entry 1200 (class 1259 OID 36397916)
-- Name: REGLER_MONTANT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."REGLER_MONTANT" (
    "CREATION_DATE" timestamp without time zone,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "MONTANT" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "ID_USER_COMMON_MODIFY" integer,
    "ID" integer NOT NULL,
    "DATE" date,
    "ARCHIVE" integer DEFAULT 0,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "ID_ECHEANCE_FOURNISSEUR" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE "OpenConcerto48"."REGLER_MONTANT" OWNER TO openconcerto;

--
-- TOC entry 1201 (class 1259 OID 36397925)
-- Name: REGLER_MONTANT_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."REGLER_MONTANT_ELEMENT" (
    "ID" integer NOT NULL,
    "ID_ECHEANCE_FOURNISSEUR" integer DEFAULT 1,
    "ID_REGLER_MONTANT" integer DEFAULT 1,
    "ID_MOUVEMENT_ECHEANCE" integer DEFAULT 1,
    "DATE" date,
    "MONTANT_REGLE" bigint DEFAULT 0,
    "MONTANT_A_REGLER" bigint DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."REGLER_MONTANT_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1202 (class 1259 OID 36397935)
-- Name: REGLER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."REGLER_MONTANT_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."REGLER_MONTANT_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21890 (class 0 OID 0)
-- Dependencies: 1202
-- Name: REGLER_MONTANT_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."REGLER_MONTANT_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."REGLER_MONTANT_ELEMENT"."ID";


--
-- TOC entry 1203 (class 1259 OID 36397937)
-- Name: REGLER_MONTANT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."REGLER_MONTANT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."REGLER_MONTANT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21891 (class 0 OID 0)
-- Dependencies: 1203
-- Name: REGLER_MONTANT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."REGLER_MONTANT_ID_seq" OWNED BY "OpenConcerto48"."REGLER_MONTANT"."ID";


--
-- TOC entry 1204 (class 1259 OID 36397939)
-- Name: RELANCE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."RELANCE" (
    "ARCHIVE" integer DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_TYPE_LETTRE_RELANCE" integer DEFAULT 1,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "DATE" date,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "MONTANT" bigint DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_ECHEANCE_CLIENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."RELANCE" OWNER TO openconcerto;

--
-- TOC entry 1205 (class 1259 OID 36397955)
-- Name: RELANCE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."RELANCE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."RELANCE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21892 (class 0 OID 0)
-- Dependencies: 1205
-- Name: RELANCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."RELANCE_ID_seq" OWNED BY "OpenConcerto48"."RELANCE"."ID";


--
-- TOC entry 1206 (class 1259 OID 36397957)
-- Name: REPARTITION_ANALYTIQUE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."REPARTITION_ANALYTIQUE" (
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."REPARTITION_ANALYTIQUE" OWNER TO openconcerto;

--
-- TOC entry 1207 (class 1259 OID 36397967)
-- Name: REPARTITION_ANALYTIQUE_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."REPARTITION_ANALYTIQUE_ELEMENT" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_REPARTITION_ANALYTIQUE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ID_POSTE_ANALYTIQUE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "TAUX" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone
);


ALTER TABLE "OpenConcerto48"."REPARTITION_ANALYTIQUE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1208 (class 1259 OID 36397976)
-- Name: REPARTITION_ANALYTIQUE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."REPARTITION_ANALYTIQUE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."REPARTITION_ANALYTIQUE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21893 (class 0 OID 0)
-- Dependencies: 1208
-- Name: REPARTITION_ANALYTIQUE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."REPARTITION_ANALYTIQUE_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."REPARTITION_ANALYTIQUE_ELEMENT"."ID";


--
-- TOC entry 1209 (class 1259 OID 36397978)
-- Name: REPARTITION_ANALYTIQUE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."REPARTITION_ANALYTIQUE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."REPARTITION_ANALYTIQUE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21894 (class 0 OID 0)
-- Dependencies: 1209
-- Name: REPARTITION_ANALYTIQUE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."REPARTITION_ANALYTIQUE_ID_seq" OWNED BY "OpenConcerto48"."REPARTITION_ANALYTIQUE"."ID";


--
-- TOC entry 1210 (class 1259 OID 36397980)
-- Name: REPRISE_TRAVAIL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."REPRISE_TRAVAIL" (
    "ID" integer NOT NULL,
    "ID_SALARIE" integer DEFAULT 1,
    "DATE_DERNIER_JOUR_TRAV" timestamp without time zone,
    "DATE_FIN_PREV" timestamp without time zone,
    "SUBROGATION" boolean DEFAULT false NOT NULL,
    "DATE_DEBUT_SUBROGATION" timestamp without time zone,
    "DATE_FIN_SUBROGATION" timestamp without time zone,
    "ID_MOTIF_ARRET_TRAVAIL" integer DEFAULT 1,
    "ID_MOTIF_REPRISE_ARRET_TRAVAIL" integer DEFAULT 1,
    "DATE_REPRISE" timestamp without time zone,
    "DATE_ACCIDENT" timestamp without time zone,
    "DATE" timestamp without time zone,
    "COMMENTAIRES" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."REPRISE_TRAVAIL" OWNER TO openconcerto;

--
-- TOC entry 1211 (class 1259 OID 36397993)
-- Name: REPRISE_TRAVAIL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."REPRISE_TRAVAIL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."REPRISE_TRAVAIL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21895 (class 0 OID 0)
-- Dependencies: 1211
-- Name: REPRISE_TRAVAIL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."REPRISE_TRAVAIL_ID_seq" OWNED BY "OpenConcerto48"."REPRISE_TRAVAIL"."ID";


--
-- TOC entry 1212 (class 1259 OID 36397995)
-- Name: SAISIE_ACHAT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."SAISIE_ACHAT" (
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "ID_TAXE" integer DEFAULT 1,
    "NUMERO_COMMANDE" character varying(2048) DEFAULT ''::text,
    "NOM" character varying(2048) DEFAULT ''::text,
    "MONTANT_TVA" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "IMMO" boolean DEFAULT false,
    "ID" integer NOT NULL,
    "MONTANT_TTC" bigint DEFAULT 0,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_AVOIR_FOURNISSEUR" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_USER_COMMON_MODIFY" integer,
    "ARCHIVE" integer DEFAULT 0,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "DATE" date,
    "MODIFICATION_DATE" timestamp without time zone,
    "IDSOURCE" integer DEFAULT 1,
    "MONTANT_HT" bigint DEFAULT 0,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "SOURCE" character varying(45) DEFAULT ''::character varying,
    "ORDRE" numeric(16,8),
    "NUMERO_FACTURE" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto48"."SAISIE_ACHAT" OWNER TO openconcerto;

--
-- TOC entry 1213 (class 1259 OID 36398018)
-- Name: SAISIE_ACHAT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."SAISIE_ACHAT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SAISIE_ACHAT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21896 (class 0 OID 0)
-- Dependencies: 1213
-- Name: SAISIE_ACHAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."SAISIE_ACHAT_ID_seq" OWNED BY "OpenConcerto48"."SAISIE_ACHAT"."ID";


--
-- TOC entry 1214 (class 1259 OID 36398020)
-- Name: SAISIE_KM; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."SAISIE_KM" (
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_CREATE" integer,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer,
    "ARCHIVE" integer DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_JOURNAL" integer DEFAULT 1,
    "DATE" date,
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto48"."SAISIE_KM" OWNER TO openconcerto;

--
-- TOC entry 1215 (class 1259 OID 36398030)
-- Name: SAISIE_KM_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."SAISIE_KM_ELEMENT" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NUMERO" character varying(100) DEFAULT ''::character varying,
    "NOM_ECRITURE" character varying(2048) DEFAULT ''::text,
    "ID_SAISIE_KM" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "DEBIT" bigint DEFAULT 0,
    "ORDRE" numeric(16,8),
    "CREDIT" bigint DEFAULT 0,
    "ID_ECRITURE" integer DEFAULT 1,
    "NOM" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "NOM_PIECE" character varying(1024) DEFAULT ''::character varying NOT NULL,
    "ANALYTIQUE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "JOUR" integer DEFAULT 1 NOT NULL
);


ALTER TABLE "OpenConcerto48"."SAISIE_KM_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1216 (class 1259 OID 36398049)
-- Name: SAISIE_KM_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."SAISIE_KM_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SAISIE_KM_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21897 (class 0 OID 0)
-- Dependencies: 1216
-- Name: SAISIE_KM_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."SAISIE_KM_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."SAISIE_KM_ELEMENT"."ID";


--
-- TOC entry 1217 (class 1259 OID 36398051)
-- Name: SAISIE_KM_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."SAISIE_KM_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SAISIE_KM_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21898 (class 0 OID 0)
-- Dependencies: 1217
-- Name: SAISIE_KM_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."SAISIE_KM_ID_seq" OWNED BY "OpenConcerto48"."SAISIE_KM"."ID";


--
-- TOC entry 1218 (class 1259 OID 36398053)
-- Name: SAISIE_VENTE_COMPTOIR; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."SAISIE_VENTE_COMPTOIR" (
    "ID_USER_COMMON_CREATE" integer,
    "ARCHIVE" integer DEFAULT 0,
    "ID_ARTICLE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "NOM" character varying(2048) DEFAULT ''::text,
    "ECHEANCE" integer DEFAULT 0,
    "ID_TAXE" integer DEFAULT 1,
    "MONTANT_TTC" bigint DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "MONTANT_HT" bigint DEFAULT 0,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "ID_CLIENT" integer DEFAULT 0,
    "DATE" date,
    "MONTANT_SERVICE" bigint DEFAULT 0,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_FOURNISSEUR" integer DEFAULT 1,
    "ID_COMPTE_PCE_PRODUIT" integer DEFAULT 1,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."SAISIE_VENTE_COMPTOIR" OWNER TO openconcerto;

--
-- TOC entry 1219 (class 1259 OID 36398075)
-- Name: SAISIE_VENTE_COMPTOIR_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."SAISIE_VENTE_COMPTOIR_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SAISIE_VENTE_COMPTOIR_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21899 (class 0 OID 0)
-- Dependencies: 1219
-- Name: SAISIE_VENTE_COMPTOIR_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."SAISIE_VENTE_COMPTOIR_ID_seq" OWNED BY "OpenConcerto48"."SAISIE_VENTE_COMPTOIR"."ID";


--
-- TOC entry 1220 (class 1259 OID 36398077)
-- Name: SAISIE_VENTE_FACTURE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."SAISIE_VENTE_FACTURE" (
    "NOM" character varying(250) DEFAULT ''::character varying,
    "T_TTC" bigint DEFAULT 0,
    "ID_COMPTE_PCE_SERVICE" integer DEFAULT 1,
    "T_POIDS" real DEFAULT 0,
    "DATE_ENVOI" timestamp without time zone,
    "ID_TAXE" integer DEFAULT 1,
    "COMPLEMENT" boolean DEFAULT false,
    "ACOMPTE" boolean DEFAULT false,
    "T_AVOIR_TTC" bigint DEFAULT 0,
    "T_HT" bigint DEFAULT 0,
    "ID_COMPTE_PCE_VENTE" integer DEFAULT 1,
    "REMISE_HT" bigint DEFAULT 0,
    "NUMERO" character varying(45) DEFAULT ''::character varying,
    "ID_CLIENT" integer DEFAULT 1,
    "PREVISIONNELLE" boolean DEFAULT false,
    "DATE" date,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "ID_MODE_REGLEMENT" integer DEFAULT 1,
    "COMPTE_SERVICE_AUTO" boolean DEFAULT false,
    "AFFACTURAGE" boolean DEFAULT false,
    "POURCENT_ACOMPTE" real DEFAULT 0,
    "T_SERVICE" bigint DEFAULT 0,
    "ID_REFERENCE_CLIENT" integer DEFAULT 1,
    "CONTROLE_TECHNIQUE" boolean DEFAULT false,
    "ID_MOIS_CCIP" integer DEFAULT 1,
    "INFOS" character varying(2048) DEFAULT ''::text,
    "DATE_ENVOI_AFFACTURAGE" date,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "ID_ADRESSE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "PORT_HT" bigint DEFAULT 0,
    "ORDRE" numeric(16,8),
    "ID_USER_COMMON_MODIFY" integer,
    "REF_CLIENT" character varying(256) DEFAULT ''::character varying NOT NULL,
    "DATE_REGLEMENT" timestamp without time zone,
    "ID_DEVIS" integer DEFAULT 1,
    "RETOUR_NATEXIS" boolean DEFAULT false,
    "T_TVA" bigint DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer,
    "ENVOYE_EN_AFFACTURAGE" boolean DEFAULT false,
    "ID" integer NOT NULL,
    "ID_CONTACT" integer DEFAULT 1,
    "TYPE_INTERVENTION" character varying(2048) DEFAULT ''::text,
    "T_HA" bigint DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "CREATION_DATE" timestamp without time zone,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "T_DEVISE" bigint DEFAULT 0,
    "ID_TARIF" integer DEFAULT 1,
    "ID_MODELE" integer DEFAULT 1,
    "ID_TAXE_PORT" integer DEFAULT 1,
    "POURCENT_FACTURABLE" numeric(16,8),
    "MONTANT_FACTURABLE" numeric(16,8),
    "SOLDE" boolean DEFAULT false,
    "PARTIAL" boolean DEFAULT false,
    "ID_ADRESSE_LIVRAISON" integer DEFAULT 1,
    "POURCENT_REMISE" numeric(12,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_CLIENT_DEPARTEMENT" integer DEFAULT 1,
    "CREATE_VIRTUAL_STOCK" boolean DEFAULT true NOT NULL,
    "SOUMIS_TIMBRE_FISCAL" boolean DEFAULT false,
    "TAUX_TIMBRE_FISCAL" numeric(16,4) DEFAULT 1,
    "TOTAL_TIMBRE_FISCAL" bigint DEFAULT 0,
    "NET_A_PAYER" bigint DEFAULT 0,
    "T_ECO_CONTRIBUTION" bigint DEFAULT 0,
    "T_ACOMPTE" bigint DEFAULT 0 NOT NULL,
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "ID_SDD_MESSAGE" integer,
    "SDD_EndToEndId" character varying(35) DEFAULT ''::character varying NOT NULL,
    "FRAIS_DOCUMENT_HT" bigint DEFAULT 0 NOT NULL,
    "ID_TAXE_FRAIS_DOCUMENT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."SAISIE_VENTE_FACTURE" OWNER TO openconcerto;

--
-- TOC entry 1221 (class 1259 OID 36398137)
-- Name: SAISIE_VENTE_FACTURE_ELEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."SAISIE_VENTE_FACTURE_ELEMENT" (
    "T_PV_TTC" numeric(16,2) DEFAULT 0 NOT NULL,
    "MONTANT_REVISABLE" boolean DEFAULT false,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ID_TICKET_CAISSE" integer DEFAULT 1,
    "PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_METRIQUE_3" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "T_PV_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "NOM_MISSION" character varying(256) DEFAULT ''::character varying,
    "T_POIDS" real DEFAULT 0,
    "ORDRE" numeric(16,8),
    "TARIF_Q18_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE" integer DEFAULT 0,
    "REFERENTIEL_INSPECTION" character varying(2048) DEFAULT ''::text,
    "CODE_MISSION" character varying(45) DEFAULT ''::character varying,
    "VALEUR_METRIQUE_1" real DEFAULT 0,
    "ID_STYLE" integer DEFAULT 1,
    "Q18" boolean DEFAULT false,
    "PRIX_METRIQUE_HA_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_CONTACT" integer DEFAULT 1,
    "DATE_FIN" timestamp without time zone,
    "POIDS" real DEFAULT 0,
    "VALEUR_METRIQUE_3" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_METRIQUE_1" integer DEFAULT 1,
    "CREATION_DATE" timestamp without time zone,
    "PRIX_METRIQUE_VT_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "LIVREE" boolean DEFAULT false,
    "VALEUR_METRIQUE_2" real DEFAULT 0,
    "DATE" date,
    "SERVICE" boolean DEFAULT false,
    "ID_TAXE" integer DEFAULT 1,
    "INFOS_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "T_PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "POURCENT_REMISE" numeric(12,8) DEFAULT 0,
    "PRIX_METRIQUE_HA_2" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_3" numeric(16,6) DEFAULT 0 NOT NULL,
    "ID" integer NOT NULL,
    "MONTANT_INITIAL" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_LIVREE" integer DEFAULT 0,
    "ACOMPTE" boolean DEFAULT false,
    "LOCAL_OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "REPARTITION_POURCENT" numeric(6,2) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_VT_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "PRIX_METRIQUE_HA_1" numeric(16,6) DEFAULT 0 NOT NULL,
    "ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "ID_METRIQUE_2" integer DEFAULT 1,
    "POURCENT_CCIP" character varying(256) DEFAULT ''::character varying NOT NULL,
    "POURCENT_ACOMPTE" numeric(6,2) DEFAULT 100 NOT NULL,
    "POURCENT_SERVICE" character varying(2048) DEFAULT ''::text,
    "OBJET_INSPECTE" character varying(2048) DEFAULT ''::text,
    "INDICE_0" bigint DEFAULT 0,
    "SOUS_ACTIVITE" character varying(45) DEFAULT ''::character varying,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "PA_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "INDICE_N" bigint DEFAULT 0,
    "SITUATION_ADMIN" character varying(2048) DEFAULT ''::text,
    "ID_MODE_VENTE_ARTICLE" integer DEFAULT 1,
    "QTE_ACHAT" integer DEFAULT 1,
    "CODE_DOUANIER" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_PAYS" integer DEFAULT 1,
    "ID_DEVISE" integer DEFAULT 1,
    "PV_U_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "PV_T_DEVISE" numeric(16,6) DEFAULT 0 NOT NULL,
    "TAUX_DEVISE" numeric(16,8) DEFAULT 1,
    "DESCRIPTIF" character varying(2048) DEFAULT ''::character varying NOT NULL,
    "MARGE_HT" numeric(16,6) DEFAULT 0 NOT NULL,
    "QTE_UNITAIRE" numeric(16,6) DEFAULT 1,
    "ID_UNITE_VENTE" integer DEFAULT 2,
    "ID_ARTICLE" integer DEFAULT 1,
    "POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "T_POIDS_COLIS_NET" numeric(16,8) DEFAULT 1,
    "NB_COLIS" integer DEFAULT 0,
    "MONTANT_FACTURABLE" numeric(16,8),
    "POURCENT_FACTURABLE" numeric(16,8),
    "MONTANT_REMISE" numeric(16,8),
    "ID_FAMILLE_ARTICLE" integer DEFAULT 1,
    "NIVEAU" integer DEFAULT 1 NOT NULL,
    "ID_ECO_CONTRIBUTION" integer DEFAULT 1,
    "ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "T_ECO_CONTRIBUTION" numeric(16,2) DEFAULT 0,
    "ID_COMMANDE_CLIENT_ELEMENT" integer DEFAULT 1,
    "ID_DEPOT_STOCK" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."SAISIE_VENTE_FACTURE_ELEMENT" OWNER TO openconcerto;

--
-- TOC entry 1222 (class 1259 OID 36398219)
-- Name: SAISIE_VENTE_FACTURE_ELEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."SAISIE_VENTE_FACTURE_ELEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SAISIE_VENTE_FACTURE_ELEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21900 (class 0 OID 0)
-- Dependencies: 1222
-- Name: SAISIE_VENTE_FACTURE_ELEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."SAISIE_VENTE_FACTURE_ELEMENT_ID_seq" OWNED BY "OpenConcerto48"."SAISIE_VENTE_FACTURE_ELEMENT"."ID";


--
-- TOC entry 1223 (class 1259 OID 36398221)
-- Name: SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."SAISIE_VENTE_FACTURE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SAISIE_VENTE_FACTURE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21901 (class 0 OID 0)
-- Dependencies: 1223
-- Name: SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."SAISIE_VENTE_FACTURE_ID_seq" OWNED BY "OpenConcerto48"."SAISIE_VENTE_FACTURE"."ID";


--
-- TOC entry 1224 (class 1259 OID 36398223)
-- Name: SALARIE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."SALARIE" (
    "CREATION_DATE" timestamp without time zone,
    "DERNIER_MOIS" integer DEFAULT 0,
    "PRENOM" character varying(45) DEFAULT ''::character varying,
    "ID" integer NOT NULL,
    "CODE" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer,
    "ID_VARIABLE_SALARIE" integer DEFAULT 1,
    "DERNIERE_ANNEE" integer DEFAULT 0,
    "ID_ETAT_CIVIL" integer DEFAULT 1,
    "ID_CUMULS_PAYE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NOM_JEUNE_FILLE" character varying(45) DEFAULT ''::character varying,
    "ID_INFOS_SALARIE_PAYE" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_TITRE_PERSONNEL" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_FICHE_PAYE" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer,
    "ID_REGLEMENT_PAYE" integer DEFAULT 1,
    "ID_CUMULS_CONGES" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "ATTACHMENTS" integer DEFAULT 0 NOT NULL,
    "ID_PAS" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."SALARIE" OWNER TO openconcerto;

--
-- TOC entry 1225 (class 1259 OID 36398242)
-- Name: SALARIE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SALARIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21902 (class 0 OID 0)
-- Dependencies: 1225
-- Name: SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."SALARIE_ID_seq" OWNED BY "OpenConcerto48"."SALARIE"."ID";


--
-- TOC entry 1226 (class 1259 OID 36398244)
-- Name: SEPA_DIRECT_DEBIT_MESSAGE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."SEPA_DIRECT_DEBIT_MESSAGE" (
    "ID" integer NOT NULL,
    "MessageIdentification" character varying(35) DEFAULT ''::character varying NOT NULL,
    "CreationDateTime" timestamp without time zone NOT NULL,
    "NumberOfTransactions" integer DEFAULT 0 NOT NULL,
    "ControlSum" numeric(16,6) DEFAULT 0 NOT NULL,
    "XML" text NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."SEPA_DIRECT_DEBIT_MESSAGE" OWNER TO openconcerto;

--
-- TOC entry 1227 (class 1259 OID 36398254)
-- Name: SEPA_DIRECT_DEBIT_MESSAGE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."SEPA_DIRECT_DEBIT_MESSAGE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SEPA_DIRECT_DEBIT_MESSAGE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21903 (class 0 OID 0)
-- Dependencies: 1227
-- Name: SEPA_DIRECT_DEBIT_MESSAGE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."SEPA_DIRECT_DEBIT_MESSAGE_ID_seq" OWNED BY "OpenConcerto48"."SEPA_DIRECT_DEBIT_MESSAGE"."ID";


--
-- TOC entry 1228 (class 1259 OID 36398256)
-- Name: SEPA_MANDATE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."SEPA_MANDATE" (
    "ID" integer NOT NULL,
    "ID_CLIENT" integer DEFAULT 1,
    "MandateIdentification" character varying(35) DEFAULT ''::character varying NOT NULL,
    "DateOfSignature" date,
    "SequenceType" character varying(8) DEFAULT ''::character varying NOT NULL,
    "ACTIVE" boolean DEFAULT true NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8)
);


ALTER TABLE "OpenConcerto48"."SEPA_MANDATE" OWNER TO openconcerto;

--
-- TOC entry 1229 (class 1259 OID 36398264)
-- Name: SEPA_MANDATE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."SEPA_MANDATE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SEPA_MANDATE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21904 (class 0 OID 0)
-- Dependencies: 1229
-- Name: SEPA_MANDATE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."SEPA_MANDATE_ID_seq" OWNED BY "OpenConcerto48"."SEPA_MANDATE"."ID";


--
-- TOC entry 1230 (class 1259 OID 36398266)
-- Name: SITUATION_FAMILIALE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."SITUATION_FAMILIALE" (
    "CODE" character varying(256) DEFAULT ''::character varying NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "ORDRE" numeric(16,8),
    "NOM" character varying(45) DEFAULT ''::character varying,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL
);


ALTER TABLE "OpenConcerto48"."SITUATION_FAMILIALE" OWNER TO openconcerto;

--
-- TOC entry 1231 (class 1259 OID 36398274)
-- Name: SITUATION_FAMILIALE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."SITUATION_FAMILIALE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."SITUATION_FAMILIALE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21905 (class 0 OID 0)
-- Dependencies: 1231
-- Name: SITUATION_FAMILIALE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."SITUATION_FAMILIALE_ID_seq" OWNED BY "OpenConcerto48"."SITUATION_FAMILIALE"."ID";


--
-- TOC entry 1232 (class 1259 OID 36398276)
-- Name: STOCK; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."STOCK" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "MODIFICATION_DATE" timestamp without time zone,
    "QTE_REEL" real DEFAULT 0,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ORDRE" numeric(16,8),
    "QTE_TH" real DEFAULT 0,
    "QTE_RECEPT_ATTENTE" real DEFAULT 0,
    "QTE_LIV_ATTENTE" real DEFAULT 0,
    "ID_DEPOT_STOCK" integer DEFAULT 1,
    "ID_ARTICLE" integer DEFAULT 1,
    "QTE_MIN" real DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."STOCK" OWNER TO openconcerto;

--
-- TOC entry 1233 (class 1259 OID 36398286)
-- Name: STOCK_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."STOCK_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."STOCK_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21906 (class 0 OID 0)
-- Dependencies: 1233
-- Name: STOCK_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."STOCK_ID_seq" OWNED BY "OpenConcerto48"."STOCK"."ID";


--
-- TOC entry 1234 (class 1259 OID 36398288)
-- Name: STYLE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."STYLE" (
    "CODE" character varying(2048) DEFAULT ''::text,
    "ID_STYLE" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text
);


ALTER TABLE "OpenConcerto48"."STYLE" OWNER TO openconcerto;

--
-- TOC entry 1235 (class 1259 OID 36398297)
-- Name: STYLE_ID_STYLE_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."STYLE_ID_STYLE_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."STYLE_ID_STYLE_seq" OWNER TO openconcerto;

--
-- TOC entry 21907 (class 0 OID 0)
-- Dependencies: 1235
-- Name: STYLE_ID_STYLE_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."STYLE_ID_STYLE_seq" OWNED BY "OpenConcerto48"."STYLE"."ID_STYLE";


--
-- TOC entry 1236 (class 1259 OID 36398299)
-- Name: TARIF; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."TARIF" (
    "ID" integer NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ID_DEVISE" integer DEFAULT 1,
    "ID_TAXE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."TARIF" OWNER TO openconcerto;

--
-- TOC entry 1237 (class 1259 OID 36398307)
-- Name: TARIF_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."TARIF_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TARIF_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21908 (class 0 OID 0)
-- Dependencies: 1237
-- Name: TARIF_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."TARIF_ID_seq" OWNED BY "OpenConcerto48"."TARIF"."ID";


--
-- TOC entry 1238 (class 1259 OID 36398309)
-- Name: TARIF_QUANTITE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."TARIF_QUANTITE" (
    "ID" integer NOT NULL,
    "ID_ARTICLE" integer DEFAULT 1,
    "QUANTITE" numeric(16,3) DEFAULT 1 NOT NULL,
    "POURCENT_REMISE" numeric(16,3),
    "PRIX_METRIQUE_VT_1" numeric(16,6),
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."TARIF_QUANTITE" OWNER TO openconcerto;

--
-- TOC entry 1239 (class 1259 OID 36398316)
-- Name: TARIF_QUANTITE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."TARIF_QUANTITE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TARIF_QUANTITE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21909 (class 0 OID 0)
-- Dependencies: 1239
-- Name: TARIF_QUANTITE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."TARIF_QUANTITE_ID_seq" OWNED BY "OpenConcerto48"."TARIF_QUANTITE"."ID";


--
-- TOC entry 1240 (class 1259 OID 36398318)
-- Name: TAXE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."TAXE" (
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "TAUX" real DEFAULT 0,
    "ID_COMPTE_PCE_COLLECTE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "ID_COMPTE_PCE_DED" integer DEFAULT 1,
    "CODE" character varying(2048) DEFAULT ''::text,
    "CREATION_DATE" timestamp without time zone,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ARCHIVE" integer DEFAULT 0,
    "ID_TAXE" integer NOT NULL,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "DEFAULT" boolean DEFAULT false,
    "ID_COMPTE_PCE_VENTE" integer DEFAULT 1,
    "ID_COMPTE_PCE_VENTE_SERVICE" integer DEFAULT 1,
    "ID_COMPTE_PCE_COLLECTE_INTRA" integer DEFAULT 1,
    "ID_COMPTE_PCE_DED_INTRA" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."TAXE" OWNER TO openconcerto;

--
-- TOC entry 1241 (class 1259 OID 36398338)
-- Name: TAXE_COMPLEMENTAIRE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."TAXE_COMPLEMENTAIRE" (
    "ID" integer NOT NULL,
    "ID_COMPTE_PCE_PRODUITS" integer DEFAULT 1,
    "ID_COMPTE_PCE" integer DEFAULT 1,
    "POURCENT" numeric(16,6) DEFAULT 0 NOT NULL,
    "CODE" character varying(25) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."TAXE_COMPLEMENTAIRE" OWNER TO openconcerto;

--
-- TOC entry 1242 (class 1259 OID 36398348)
-- Name: TAXE_COMPLEMENTAIRE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."TAXE_COMPLEMENTAIRE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TAXE_COMPLEMENTAIRE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21910 (class 0 OID 0)
-- Dependencies: 1242
-- Name: TAXE_COMPLEMENTAIRE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."TAXE_COMPLEMENTAIRE_ID_seq" OWNED BY "OpenConcerto48"."TAXE_COMPLEMENTAIRE"."ID";


--
-- TOC entry 1243 (class 1259 OID 36398350)
-- Name: TAXE_ID_TAXE_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."TAXE_ID_TAXE_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TAXE_ID_TAXE_seq" OWNER TO openconcerto;

--
-- TOC entry 21911 (class 0 OID 0)
-- Dependencies: 1243
-- Name: TAXE_ID_TAXE_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."TAXE_ID_TAXE_seq" OWNED BY "OpenConcerto48"."TAXE"."ID_TAXE";


--
-- TOC entry 1244 (class 1259 OID 36398352)
-- Name: TICKET_CAISSE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."TICKET_CAISSE" (
    "ID_CAISSE" integer DEFAULT 1,
    "ORDRE" numeric(16,8) DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ID_COMMERCIAL" integer DEFAULT 1,
    "TOTAL_HT" bigint DEFAULT 0,
    "ID_CLIENT" integer DEFAULT 1,
    "TOTAL_TVA" bigint DEFAULT 0,
    "NUMERO" character varying(2048) DEFAULT ''::text,
    "TOTAL_TTC" bigint DEFAULT 0,
    "ID_MOUVEMENT" integer DEFAULT 1,
    "FILE_HASH" character varying(128) DEFAULT NULL::character varying,
    "FILE_HASH_PREVIOUS" character varying(128) DEFAULT NULL::character varying
);


ALTER TABLE "OpenConcerto48"."TICKET_CAISSE" OWNER TO openconcerto;

--
-- TOC entry 1245 (class 1259 OID 36398371)
-- Name: TICKET_CAISSE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."TICKET_CAISSE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TICKET_CAISSE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21912 (class 0 OID 0)
-- Dependencies: 1245
-- Name: TICKET_CAISSE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."TICKET_CAISSE_ID_seq" OWNED BY "OpenConcerto48"."TICKET_CAISSE"."ID";


--
-- TOC entry 1246 (class 1259 OID 36398373)
-- Name: TITRE_PERSONNEL; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."TITRE_PERSONNEL" (
    "ARCHIVE" integer DEFAULT 0,
    "ID" integer NOT NULL,
    "CREATION_DATE" timestamp without time zone,
    "SEXE_M" boolean DEFAULT true,
    "ORDRE" numeric(16,8),
    "NOM" character varying(45) DEFAULT ''::character varying,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "CODE" character varying(8) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto48"."TITRE_PERSONNEL" OWNER TO openconcerto;

--
-- TOC entry 1247 (class 1259 OID 36398382)
-- Name: TITRE_PERSONNEL_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."TITRE_PERSONNEL_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TITRE_PERSONNEL_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21913 (class 0 OID 0)
-- Dependencies: 1247
-- Name: TITRE_PERSONNEL_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."TITRE_PERSONNEL_ID_seq" OWNED BY "OpenConcerto48"."TITRE_PERSONNEL"."ID";


--
-- TOC entry 1248 (class 1259 OID 36398384)
-- Name: TR_BON_DE_LIVRAISON; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."TR_BON_DE_LIVRAISON" (
    "ID" integer NOT NULL,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."TR_BON_DE_LIVRAISON" OWNER TO openconcerto;

--
-- TOC entry 1249 (class 1259 OID 36398391)
-- Name: TR_BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."TR_BON_DE_LIVRAISON_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TR_BON_DE_LIVRAISON_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21914 (class 0 OID 0)
-- Dependencies: 1249
-- Name: TR_BON_DE_LIVRAISON_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."TR_BON_DE_LIVRAISON_ID_seq" OWNED BY "OpenConcerto48"."TR_BON_DE_LIVRAISON"."ID";


--
-- TOC entry 1250 (class 1259 OID 36398393)
-- Name: TR_BON_RECEPTION; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."TR_BON_RECEPTION" (
    "ID" integer NOT NULL,
    "ID_BON_RECEPTION" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_SAISIE_ACHAT" integer DEFAULT 1,
    "ID_FACTURE_FOURNISSEUR" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."TR_BON_RECEPTION" OWNER TO openconcerto;

--
-- TOC entry 1251 (class 1259 OID 36398401)
-- Name: TR_BON_RECEPTION_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."TR_BON_RECEPTION_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TR_BON_RECEPTION_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21915 (class 0 OID 0)
-- Dependencies: 1251
-- Name: TR_BON_RECEPTION_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."TR_BON_RECEPTION_ID_seq" OWNED BY "OpenConcerto48"."TR_BON_RECEPTION"."ID";


--
-- TOC entry 1252 (class 1259 OID 36398403)
-- Name: TR_COMMANDE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."TR_COMMANDE" (
    "ID" integer NOT NULL,
    "ID_COMMANDE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_BON_RECEPTION" integer DEFAULT 1,
    "ID_SAISIE_ACHAT" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."TR_COMMANDE" OWNER TO openconcerto;

--
-- TOC entry 1253 (class 1259 OID 36398411)
-- Name: TR_COMMANDE_CLIENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."TR_COMMANDE_CLIENT" (
    "ID" integer NOT NULL,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1,
    "ID_COMMANDE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."TR_COMMANDE_CLIENT" OWNER TO openconcerto;

--
-- TOC entry 1254 (class 1259 OID 36398420)
-- Name: TR_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."TR_COMMANDE_CLIENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TR_COMMANDE_CLIENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21916 (class 0 OID 0)
-- Dependencies: 1254
-- Name: TR_COMMANDE_CLIENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."TR_COMMANDE_CLIENT_ID_seq" OWNED BY "OpenConcerto48"."TR_COMMANDE_CLIENT"."ID";


--
-- TOC entry 1255 (class 1259 OID 36398422)
-- Name: TR_COMMANDE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."TR_COMMANDE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TR_COMMANDE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21917 (class 0 OID 0)
-- Dependencies: 1255
-- Name: TR_COMMANDE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."TR_COMMANDE_ID_seq" OWNED BY "OpenConcerto48"."TR_COMMANDE"."ID";


--
-- TOC entry 1256 (class 1259 OID 36398424)
-- Name: TR_DEVIS; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."TR_DEVIS" (
    "ID" integer NOT NULL,
    "ID_DEVIS" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_COMMANDE_CLIENT" integer DEFAULT 1,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ID_COMMANDE" integer DEFAULT 1,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."TR_DEVIS" OWNER TO openconcerto;

--
-- TOC entry 1257 (class 1259 OID 36398433)
-- Name: TR_DEVIS_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."TR_DEVIS_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TR_DEVIS_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21918 (class 0 OID 0)
-- Dependencies: 1257
-- Name: TR_DEVIS_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."TR_DEVIS_ID_seq" OWNED BY "OpenConcerto48"."TR_DEVIS"."ID";


--
-- TOC entry 1258 (class 1259 OID 36398435)
-- Name: TR_SAISIE_ACHAT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."TR_SAISIE_ACHAT" (
    "ID" integer NOT NULL,
    "ID_SAISIE_ACHAT" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_AVOIR_FOURNISSEUR" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."TR_SAISIE_ACHAT" OWNER TO openconcerto;

--
-- TOC entry 1259 (class 1259 OID 36398442)
-- Name: TR_SAISIE_ACHAT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."TR_SAISIE_ACHAT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TR_SAISIE_ACHAT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21919 (class 0 OID 0)
-- Dependencies: 1259
-- Name: TR_SAISIE_ACHAT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."TR_SAISIE_ACHAT_ID_seq" OWNED BY "OpenConcerto48"."TR_SAISIE_ACHAT"."ID";


--
-- TOC entry 1260 (class 1259 OID 36398444)
-- Name: TR_SAISIE_VENTE_FACTURE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."TR_SAISIE_VENTE_FACTURE" (
    "ID" integer NOT NULL,
    "ID_SAISIE_VENTE_FACTURE" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric,
    "ID_AVOIR_CLIENT" integer DEFAULT 1,
    "ID_BON_DE_LIVRAISON" integer DEFAULT 1,
    "ID_COMMANDE" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."TR_SAISIE_VENTE_FACTURE" OWNER TO openconcerto;

--
-- TOC entry 1261 (class 1259 OID 36398453)
-- Name: TR_SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."TR_SAISIE_VENTE_FACTURE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TR_SAISIE_VENTE_FACTURE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21920 (class 0 OID 0)
-- Dependencies: 1261
-- Name: TR_SAISIE_VENTE_FACTURE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."TR_SAISIE_VENTE_FACTURE_ID_seq" OWNED BY "OpenConcerto48"."TR_SAISIE_VENTE_FACTURE"."ID";


--
-- TOC entry 1262 (class 1259 OID 36398455)
-- Name: TYPE_COMPTE_PCG; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."TYPE_COMPTE_PCG" (
    "ID" integer NOT NULL,
    "NOM" character varying(2048) DEFAULT ''::text,
    "RACINE" boolean DEFAULT false
);


ALTER TABLE "OpenConcerto48"."TYPE_COMPTE_PCG" OWNER TO openconcerto;

--
-- TOC entry 1263 (class 1259 OID 36398463)
-- Name: TYPE_COMPTE_PCG_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."TYPE_COMPTE_PCG_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TYPE_COMPTE_PCG_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21921 (class 0 OID 0)
-- Dependencies: 1263
-- Name: TYPE_COMPTE_PCG_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."TYPE_COMPTE_PCG_ID_seq" OWNED BY "OpenConcerto48"."TYPE_COMPTE_PCG"."ID";


--
-- TOC entry 1264 (class 1259 OID 36398465)
-- Name: TYPE_LETTRE_RELANCE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."TYPE_LETTRE_RELANCE" (
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ID" integer NOT NULL,
    "ARCHIVE" integer DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "ORDRE" numeric(16,8),
    "MODELE" character varying(2048) DEFAULT ''::text,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "NOM" character varying(45) DEFAULT ''::character varying
);


ALTER TABLE "OpenConcerto48"."TYPE_LETTRE_RELANCE" OWNER TO openconcerto;

--
-- TOC entry 1265 (class 1259 OID 36398476)
-- Name: TYPE_LETTRE_RELANCE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."TYPE_LETTRE_RELANCE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TYPE_LETTRE_RELANCE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21922 (class 0 OID 0)
-- Dependencies: 1265
-- Name: TYPE_LETTRE_RELANCE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."TYPE_LETTRE_RELANCE_ID_seq" OWNED BY "OpenConcerto48"."TYPE_LETTRE_RELANCE"."ID";


--
-- TOC entry 1266 (class 1259 OID 36398478)
-- Name: TYPE_REGLEMENT; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."TYPE_REGLEMENT" (
    "COMPTANT" boolean DEFAULT false,
    "CREATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ECHEANCE" boolean DEFAULT false,
    "ID_COMPTE_PCE_CLIENT" integer DEFAULT 1,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID_USER_COMMON_CREATE" integer DEFAULT 1,
    "ID_USER_COMMON_MODIFY" integer DEFAULT 1,
    "ARCHIVE" integer DEFAULT 0,
    "NOM" character varying(2048) DEFAULT ''::text,
    "ORDRE" numeric(16,8),
    "ID_COMPTE_PCE_FOURN" integer DEFAULT 1
);


ALTER TABLE "OpenConcerto48"."TYPE_REGLEMENT" OWNER TO openconcerto;

--
-- TOC entry 1267 (class 1259 OID 36398492)
-- Name: TYPE_REGLEMENT_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."TYPE_REGLEMENT_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."TYPE_REGLEMENT_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21923 (class 0 OID 0)
-- Dependencies: 1267
-- Name: TYPE_REGLEMENT_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."TYPE_REGLEMENT_ID_seq" OWNED BY "OpenConcerto48"."TYPE_REGLEMENT"."ID";


--
-- TOC entry 1268 (class 1259 OID 36398494)
-- Name: UNITE_VENTE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."UNITE_VENTE" (
    "ID" integer NOT NULL,
    "CODE" character varying(32) DEFAULT ''::character varying NOT NULL,
    "NOM" character varying(256) DEFAULT ''::character varying NOT NULL,
    "A_LA_PIECE" boolean DEFAULT false,
    "INFOS" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."UNITE_VENTE" OWNER TO openconcerto;

--
-- TOC entry 1269 (class 1259 OID 36398506)
-- Name: UNITE_VENTE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."UNITE_VENTE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."UNITE_VENTE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21924 (class 0 OID 0)
-- Dependencies: 1269
-- Name: UNITE_VENTE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."UNITE_VENTE_ID_seq" OWNED BY "OpenConcerto48"."UNITE_VENTE"."ID";


--
-- TOC entry 1270 (class 1259 OID 36398508)
-- Name: VARIABLE_SALARIE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."VARIABLE_SALARIE" (
    "HEURE_200" real DEFAULT 0,
    "MODIFICATION_DATE" timestamp without time zone,
    "ID" integer NOT NULL,
    "ID_USER_COMMON_CREATE" integer,
    "HEURE_125" real DEFAULT 0,
    "ID_USER_COMMON_MODIFY" integer,
    "ORDRE" numeric(16,8),
    "CONGES_PRIS" real DEFAULT 0,
    "ARCHIVE" integer DEFAULT 0,
    "HEURE_TRAV" real DEFAULT 0,
    "HEURE_ABS" real DEFAULT 0,
    "HEURE_150" real DEFAULT 0,
    "HEURE_110" real DEFAULT 0,
    "CREATION_DATE" timestamp without time zone,
    "CONGES_PRIS_DEFAULT_VAL" real DEFAULT 0,
    "HEURE_200_DEFAULT_VAL" real DEFAULT 0,
    "HEURE_150_DEFAULT_VAL" real DEFAULT 0,
    "HEURE_110_DEFAULT_VAL" real DEFAULT 0,
    "HEURE_ABS_DEFAULT_VAL" real DEFAULT 0,
    "HEURE_125_DEFAULT_VAL" real DEFAULT 0,
    "IJSS_BRUT" real DEFAULT 0,
    "IJSS_BRUT_DEFAULT_VAL" real DEFAULT 0,
    "IJSS_NET" real DEFAULT 0,
    "IJSS_NET_DEFAULT_VAL" real DEFAULT 0,
    "FRAIS_PRO" real DEFAULT 0,
    "FRAIS_PRO_DEFAULT_VAL" real DEFAULT 0,
    "RBT_TRANSPORT" real DEFAULT 0,
    "RBT_TRANSPORT_DEFAULT_VAL" real DEFAULT 0
);


ALTER TABLE "OpenConcerto48"."VARIABLE_SALARIE" OWNER TO openconcerto;

--
-- TOC entry 1271 (class 1259 OID 36398533)
-- Name: VARIABLE_SALARIE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."VARIABLE_SALARIE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."VARIABLE_SALARIE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21925 (class 0 OID 0)
-- Dependencies: 1271
-- Name: VARIABLE_SALARIE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."VARIABLE_SALARIE_ID_seq" OWNED BY "OpenConcerto48"."VARIABLE_SALARIE"."ID";


--
-- TOC entry 1272 (class 1259 OID 36398535)
-- Name: VILLE; Type: TABLE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE TABLE "OpenConcerto48"."VILLE" (
    "ID" integer NOT NULL,
    "X_LAMBERT" bigint DEFAULT 0,
    "Y_LAMBERT" bigint DEFAULT 0,
    "POPULATION" bigint DEFAULT 0,
    "NOM" character varying(512) DEFAULT ''::character varying NOT NULL,
    "CODE_POSTAL" character varying(256) DEFAULT ''::character varying NOT NULL,
    "ARCHIVE" integer DEFAULT 0 NOT NULL,
    "ORDRE" numeric(16,8) DEFAULT NULL::numeric
);


ALTER TABLE "OpenConcerto48"."VILLE" OWNER TO openconcerto;

--
-- TOC entry 1273 (class 1259 OID 36398548)
-- Name: VILLE_ID_seq; Type: SEQUENCE; Schema: OpenConcerto48; Owner: openconcerto
--

CREATE SEQUENCE "OpenConcerto48"."VILLE_ID_seq"
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE "OpenConcerto48"."VILLE_ID_seq" OWNER TO openconcerto;

--
-- TOC entry 21926 (class 0 OID 0)
-- Dependencies: 1273
-- Name: VILLE_ID_seq; Type: SEQUENCE OWNED BY; Schema: OpenConcerto48; Owner: openconcerto
--

ALTER SEQUENCE "OpenConcerto48"."VILLE_ID_seq" OWNED BY "OpenConcerto48"."VILLE"."ID";


--
-- TOC entry 1274 (class 1259 OID 36398550)
-- Name: FWK_SCHEMA_METADATA; Type: TABLE; Schema: public; Owner: openconcerto
--

CREATE TABLE public."FWK_SCHEMA_METADATA" (
    "NAME" character varying(100) DEFAULT ''::character varying NOT NULL,
    "VALUE" character varying(250) DEFAULT ''::character varying NOT NULL
);


ALTER TABLE public."FWK_SCHEMA_METADATA" OWNER TO openconcerto;

--
-- TOC entry 5827 (class 2604 OID 36398555)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."ACCES_SOCIETE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."ACCES_SOCIETE_ID_seq"'::regclass);


--
-- TOC entry 5832 (class 2604 OID 36398556)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."ADRESSE_COMMON" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."ADRESSE_COMMON_ID_seq"'::regclass);


--
-- TOC entry 5840 (class 2604 OID 36398557)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."AYANT_DROIT_TYPE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."AYANT_DROIT_TYPE_ID_seq"'::regclass);


--
-- TOC entry 5845 (class 2604 OID 36398558)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."CAISSE_COTISATION" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."CAISSE_COTISATION_ID_seq"'::regclass);


--
-- TOC entry 5858 (class 2604 OID 36398559)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."CAISSE_COTISATION_RENSEIGNEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."CAISSE_COTISATION_RENSEIGNEMENT_ID_seq"'::regclass);


--
-- TOC entry 5873 (class 2604 OID 36398560)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."CAISSE_MODE_PAIEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."CAISSE_MODE_PAIEMENT_ID_seq"'::regclass);


--
-- TOC entry 5878 (class 2604 OID 36398561)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."CODE_BASE_ASSUJETTIE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."CODE_BASE_ASSUJETTIE_ID_seq"'::regclass);


--
-- TOC entry 5883 (class 2604 OID 36398562)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."CODE_CAISSE_TYPE_RUBRIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."CODE_CAISSE_TYPE_RUBRIQUE_ID_seq"'::regclass);


--
-- TOC entry 5889 (class 2604 OID 36398563)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."CODE_COTISATION_ETABLISSEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."CODE_COTISATION_ETABLISSEMENT_ID_seq"'::regclass);


--
-- TOC entry 5894 (class 2604 OID 36398564)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."CODE_COTISATION_INDIVIDUELLE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."CODE_COTISATION_INDIVIDUELLE_ID_seq"'::regclass);


--
-- TOC entry 5899 (class 2604 OID 36398565)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."CODE_PENIBILITE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."CODE_PENIBILITE_ID_seq"'::regclass);


--
-- TOC entry 5904 (class 2604 OID 36398566)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."CODE_TYPE_RUBRIQUE_BRUT" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."CODE_TYPE_RUBRIQUE_BRUT_ID_seq"'::regclass);


--
-- TOC entry 5912 (class 2604 OID 36398567)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."COMPTE_PCE_DEFAULT" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."COMPTE_PCE_DEFAULT_ID_seq"'::regclass);


--
-- TOC entry 5919 (class 2604 OID 36398568)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."CONNEXION" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."CONNEXION_ID_seq"'::regclass);


--
-- TOC entry 5921 (class 2604 OID 36398569)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."CONTRAT_DETACHE_EXPATRIE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."CONTRAT_DETACHE_EXPATRIE_ID_seq"'::regclass);


--
-- TOC entry 5926 (class 2604 OID 36398570)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."CONTRAT_DISPOSITIF_POLITIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."CONTRAT_DISPOSITIF_POLITIQUE_ID_seq"'::regclass);


--
-- TOC entry 5931 (class 2604 OID 36398571)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."CONTRAT_MODALITE_TEMPS" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."CONTRAT_MODALITE_TEMPS_ID_seq"'::regclass);


--
-- TOC entry 5936 (class 2604 OID 36398572)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."CONTRAT_MOTIF_RECOURS" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."CONTRAT_MOTIF_RECOURS_ID_seq"'::regclass);


--
-- TOC entry 5941 (class 2604 OID 36398573)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."CONTRAT_REGIME_MALADIE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."CONTRAT_REGIME_MALADIE_ID_seq"'::regclass);


--
-- TOC entry 5946 (class 2604 OID 36398574)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."CONTRAT_REGIME_VIEILLESSE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."CONTRAT_REGIME_VIEILLESSE_ID_seq"'::regclass);


--
-- TOC entry 5951 (class 2604 OID 36398575)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."DEVISE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."DEVISE_ID_seq"'::regclass);


--
-- TOC entry 5960 (class 2604 OID 36398576)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."DSN_NATURE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."DSN_NATURE_ID_seq"'::regclass);


--
-- TOC entry 5965 (class 2604 OID 36398577)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."DSN_REGIME_LOCAL" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."DSN_REGIME_LOCAL_ID_seq"'::regclass);


--
-- TOC entry 5970 (class 2604 OID 36398578)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."DSN_TYPE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."DSN_TYPE_ID_seq"'::regclass);


--
-- TOC entry 5975 (class 2604 OID 36398579)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."ECO_CONTRIBUTION" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."ECO_CONTRIBUTION_ID_seq"'::regclass);


--
-- TOC entry 5982 (class 2604 OID 36398580)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."EXERCICE_COMMON" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."EXERCICE_COMMON_ID_seq"'::regclass);


--
-- TOC entry 5988 (class 2604 OID 36398581)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."FAMILLE_ECO_CONTRIBUTION" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."FAMILLE_ECO_CONTRIBUTION_ID_seq"'::regclass);


--
-- TOC entry 5992 (class 2604 OID 36398582)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."FWK_RIV_METADATA" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."FWK_RIV_METADATA_ID_seq"'::regclass);


--
-- TOC entry 5999 (class 2604 OID 36398583)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."IMPRESSION_RUBRIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."IMPRESSION_RUBRIQUE_ID_seq"'::regclass);


--
-- TOC entry 6003 (class 2604 OID 36398584)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."INDICE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."INDICE_ID_seq"'::regclass);


--
-- TOC entry 6018 (class 2604 OID 36398585)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."MOTIF_ARRET_TRAVAIL" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."MOTIF_ARRET_TRAVAIL_ID_seq"'::regclass);


--
-- TOC entry 6023 (class 2604 OID 36398586)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."MOTIF_FIN_CONTRAT" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."MOTIF_FIN_CONTRAT_ID_seq"'::regclass);


--
-- TOC entry 6028 (class 2604 OID 36398587)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."MOTIF_REPRISE_ARRET_TRAVAIL" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."MOTIF_REPRISE_ARRET_TRAVAIL_ID_seq"'::regclass);


--
-- TOC entry 6033 (class 2604 OID 36398588)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."OBJET" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."OBJET_ID_seq"'::regclass);


--
-- TOC entry 6038 (class 2604 OID 36398589)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."PERIODE_VALIDITE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."PERIODE_VALIDITE_ID_seq"'::regclass);


--
-- TOC entry 6053 (class 2604 OID 36398590)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."PREF_NODE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."PREF_NODE_ID_seq"'::regclass);


--
-- TOC entry 6057 (class 2604 OID 36398591)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."PROFIL_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."PROFIL_PAYE_ID_seq"'::regclass);


--
-- TOC entry 6061 (class 2604 OID 36398592)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."PROFIL_PAYE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."PROFIL_PAYE_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 6069 (class 2604 OID 36398593)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."RIGHT" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."RIGHT_ID_seq"'::regclass);


--
-- TOC entry 6074 (class 2604 OID 36398594)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."RUBRIQUE_BRUT" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."RUBRIQUE_BRUT_ID_seq"'::regclass);


--
-- TOC entry 6093 (class 2604 OID 36398595)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."RUBRIQUE_COMM" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."RUBRIQUE_COMM_ID_seq"'::regclass);


--
-- TOC entry 6109 (class 2604 OID 36398596)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."RUBRIQUE_COTISATION" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."RUBRIQUE_COTISATION_ID_seq"'::regclass);


--
-- TOC entry 6135 (class 2604 OID 36398597)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."RUBRIQUE_NET" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."RUBRIQUE_NET_ID_seq"'::regclass);


--
-- TOC entry 6158 (class 2604 OID 36398598)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."SERVICE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."SERVICE_ID_seq"'::regclass);


--
-- TOC entry 6163 (class 2604 OID 36398599)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."SOCIETE_COMMON" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."SOCIETE_COMMON_ID_seq"'::regclass);


--
-- TOC entry 6186 (class 2604 OID 36398600)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."STOCK" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."STOCK_ID_seq"'::regclass);


--
-- TOC entry 6191 (class 2604 OID 36398601)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."TACHE_COMMON" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."TACHE_COMMON_ID_seq"'::regclass);


--
-- TOC entry 6203 (class 2604 OID 36398602)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."TACHE_LISTENER_COMMON" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."TACHE_LISTENER_COMMON_ID_seq"'::regclass);


--
-- TOC entry 6208 (class 2604 OID 36398603)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."TACHE_RIGHTS" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."TACHE_RIGHTS_ID_seq"'::regclass);


--
-- TOC entry 6216 (class 2604 OID 36398604)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."TYPE_COMPOSANT_BASE_ASSUJETTIE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."TYPE_COMPOSANT_BASE_ASSUJETTIE_ID_seq"'::regclass);


--
-- TOC entry 6221 (class 2604 OID 36398605)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."TYPE_MODELE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."TYPE_MODELE_ID_seq"'::regclass);


--
-- TOC entry 6227 (class 2604 OID 36398606)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."TYPE_PREAVIS" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."TYPE_PREAVIS_ID_seq"'::regclass);


--
-- TOC entry 6232 (class 2604 OID 36398607)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."TYPE_RUBRIQUE_BRUT" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."TYPE_RUBRIQUE_BRUT_ID_seq"'::regclass);


--
-- TOC entry 6236 (class 2604 OID 36398608)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."TYPE_RUBRIQUE_NET" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."TYPE_RUBRIQUE_NET_ID_seq"'::regclass);


--
-- TOC entry 13240 (class 2604 OID 36414194)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."TYPE_TAUX_PAS" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."TYPE_TAUX_PAS_ID_seq"'::regclass);


--
-- TOC entry 6240 (class 2604 OID 36398609)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."USER_COMMON" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."USER_COMMON_ID_seq"'::regclass);


--
-- TOC entry 6256 (class 2604 OID 36398610)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."USER_RIGHT" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."USER_RIGHT_ID_seq"'::regclass);


--
-- TOC entry 6260 (class 2604 OID 36398611)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."VARIABLE_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."VARIABLE_PAYE_ID_seq"'::regclass);


--
-- TOC entry 6268 (class 2604 OID 36398612)
-- Name: ID; Type: DEFAULT; Schema: Common; Owner: openconcerto
--

ALTER TABLE ONLY "Common"."VILLE" ALTER COLUMN "ID" SET DEFAULT nextval('"Common"."VILLE_ID_seq"'::regclass);


--
-- TOC entry 6274 (class 2604 OID 36398613)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ACOMPTE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ACOMPTE_ID_seq"'::regclass);


--
-- TOC entry 6282 (class 2604 OID 36398614)
-- Name: ID_ADRESSE; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ADRESSE" ALTER COLUMN "ID_ADRESSE" SET DEFAULT nextval('"Default"."ADRESSE_ID_ADRESSE_seq"'::regclass);


--
-- TOC entry 6296 (class 2604 OID 36398615)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ARRET_TRAVAIL" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ARRET_TRAVAIL_ID_seq"'::regclass);


--
-- TOC entry 6304 (class 2604 OID 36398616)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ARTICLE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ARTICLE_ID_seq"'::regclass);


--
-- TOC entry 13505 (class 2604 OID 36417570)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ARTICLE_CATEGORIE_COMPTABLE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ARTICLE_CATEGORIE_COMPTABLE_ID_seq"'::regclass);


--
-- TOC entry 6362 (class 2604 OID 36398617)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ARTICLE_CODE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ARTICLE_CODE_CLIENT_ID_seq"'::regclass);


--
-- TOC entry 6368 (class 2604 OID 36398618)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ARTICLE_DESIGNATION" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ARTICLE_DESIGNATION_ID_seq"'::regclass);


--
-- TOC entry 6374 (class 2604 OID 36398619)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ARTICLE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ARTICLE_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 6382 (class 2604 OID 36398620)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ARTICLE_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ARTICLE_FOURNISSEUR_ID_seq"'::regclass);


--
-- TOC entry 13513 (class 2604 OID 36417623)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ARTICLE_FOURNISSEUR_SECONDAIRE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ARTICLE_FOURNISSEUR_SECONDAIRE_ID_seq"'::regclass);


--
-- TOC entry 6426 (class 2604 OID 36398621)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ARTICLE_TARIF" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ARTICLE_TARIF_ID_seq"'::regclass);


--
-- TOC entry 13482 (class 2604 OID 36417438)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ARTICLE_TARIF_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ARTICLE_TARIF_FOURNISSEUR_ID_seq"'::regclass);


--
-- TOC entry 6440 (class 2604 OID 36398622)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ASSOCIATION_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ASSOCIATION_ANALYTIQUE_ID_seq"'::regclass);


--
-- TOC entry 6449 (class 2604 OID 36398623)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ASSOCIATION_COMPTE_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq"'::regclass);


--
-- TOC entry 6456 (class 2604 OID 36398624)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ATTACHMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ATTACHMENT_ID_seq"'::regclass);


--
-- TOC entry 6475 (class 2604 OID 36398625)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."AVOIR_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."AVOIR_CLIENT_ID_seq"'::regclass);


--
-- TOC entry 6511 (class 2604 OID 36398626)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."AVOIR_CLIENT_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."AVOIR_CLIENT_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 6585 (class 2604 OID 36398627)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."AVOIR_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."AVOIR_FOURNISSEUR_ID_seq"'::regclass);


--
-- TOC entry 6603 (class 2604 OID 36398628)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."AXE_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."AXE_ANALYTIQUE_ID_seq"'::regclass);


--
-- TOC entry 6608 (class 2604 OID 36398629)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."AYANT_DROIT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."AYANT_DROIT_ID_seq"'::regclass);


--
-- TOC entry 6620 (class 2604 OID 36398630)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."BANQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."BANQUE_ID_seq"'::regclass);


--
-- TOC entry 6637 (class 2604 OID 36398631)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."BON_DE_LIVRAISON" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."BON_DE_LIVRAISON_ID_seq"'::regclass);


--
-- TOC entry 6670 (class 2604 OID 36398632)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."BON_DE_LIVRAISON_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."BON_DE_LIVRAISON_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 6726 (class 2604 OID 36398633)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."BON_RECEPTION" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."BON_RECEPTION_ID_seq"'::regclass);


--
-- TOC entry 6744 (class 2604 OID 36398634)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."BON_RECEPTION_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."BON_RECEPTION_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 6797 (class 2604 OID 36398635)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CAISSE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CAISSE_ID_seq"'::regclass);


--
-- TOC entry 6798 (class 2604 OID 36398636)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CAISSE_CLOTURE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CAISSE_CLOTURE_ID_seq"'::regclass);


--
-- TOC entry 6808 (class 2604 OID 36398637)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CAISSE_JOURNAL" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CAISSE_JOURNAL_ID_seq"'::regclass);


--
-- TOC entry 6817 (class 2604 OID 36398638)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CALENDAR_ITEM" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CALENDAR_ITEM_ID_seq"'::regclass);


--
-- TOC entry 6828 (class 2604 OID 36398639)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CALENDAR_ITEM_GROUP" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CALENDAR_ITEM_GROUP_ID_seq"'::regclass);


--
-- TOC entry 6833 (class 2604 OID 36398640)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CATEGORIE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CATEGORIE_CLIENT_ID_seq"'::regclass);


--
-- TOC entry 13498 (class 2604 OID 36417478)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CATEGORIE_COMPTABLE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CATEGORIE_COMPTABLE_ID_seq"'::regclass);


--
-- TOC entry 6837 (class 2604 OID 36398641)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CHEQUE_AVOIR_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CHEQUE_AVOIR_CLIENT_ID_seq"'::regclass);


--
-- TOC entry 6848 (class 2604 OID 36398642)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CHEQUE_A_ENCAISSER" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CHEQUE_A_ENCAISSER_ID_seq"'::regclass);


--
-- TOC entry 6862 (class 2604 OID 36398643)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CHEQUE_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CHEQUE_FOURNISSEUR_ID_seq"'::regclass);


--
-- TOC entry 6872 (class 2604 OID 36398644)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CHIFFRAGE_COMMANDE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CHIFFRAGE_COMMANDE_CLIENT_ID_seq"'::regclass);


--
-- TOC entry 6884 (class 2604 OID 36398645)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CLASSEMENT_CONVENTIONNEL" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CLASSEMENT_CONVENTIONNEL_ID_seq"'::regclass);


--
-- TOC entry 6893 (class 2604 OID 36398646)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CLASSE_COMPTE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CLASSE_COMPTE_ID_seq"'::regclass);


--
-- TOC entry 6899 (class 2604 OID 36398647)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CLIENT_ID_CLIENT_seq"'::regclass);


--
-- TOC entry 6965 (class 2604 OID 36398648)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CLIENT_DEPARTEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CLIENT_DEPARTEMENT_ID_seq"'::regclass);


--
-- TOC entry 6972 (class 2604 OID 36398649)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CODE_CARACT_ACTIVITE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CODE_CARACT_ACTIVITE_ID_seq"'::regclass);


--
-- TOC entry 6978 (class 2604 OID 36398650)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CODE_CONTRAT_TRAVAIL" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CODE_CONTRAT_TRAVAIL_ID_seq"'::regclass);


--
-- TOC entry 6984 (class 2604 OID 36398651)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CODE_DROIT_CONTRAT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CODE_DROIT_CONTRAT_ID_seq"'::regclass);


--
-- TOC entry 6990 (class 2604 OID 36398652)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CODE_EMPLOI" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CODE_EMPLOI_ID_seq"'::regclass);


--
-- TOC entry 6996 (class 2604 OID 36398653)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CODE_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CODE_FOURNISSEUR_ID_seq"'::regclass);


--
-- TOC entry 7002 (class 2604 OID 36398654)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CODE_PENIBILITE_CONTRAT_SALARIE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CODE_PENIBILITE_CONTRAT_SALARIE_ID_seq"'::regclass);


--
-- TOC entry 7007 (class 2604 OID 36398655)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CODE_REGIME" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CODE_REGIME_ID_seq"'::regclass);


--
-- TOC entry 7013 (class 2604 OID 36398656)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CODE_STATUT_CATEGORIEL" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CODE_STATUT_CATEGORIEL_ID_seq"'::regclass);


--
-- TOC entry 7019 (class 2604 OID 36398657)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CODE_STATUT_CAT_CONV" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CODE_STATUT_CAT_CONV_ID_seq"'::regclass);


--
-- TOC entry 7024 (class 2604 OID 36398658)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CODE_STATUT_PROF" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CODE_STATUT_PROF_ID_seq"'::regclass);


--
-- TOC entry 7030 (class 2604 OID 36398659)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."COEFF_PRIME" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."COEFF_PRIME_ID_seq"'::regclass);


--
-- TOC entry 7037 (class 2604 OID 36398660)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."COMMANDE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."COMMANDE_ID_seq"'::regclass);


--
-- TOC entry 7064 (class 2604 OID 36398661)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."COMMANDE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."COMMANDE_CLIENT_ID_seq"'::regclass);


--
-- TOC entry 7093 (class 2604 OID 36398662)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."COMMANDE_CLIENT_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."COMMANDE_CLIENT_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 7149 (class 2604 OID 36398663)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."COMMANDE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."COMMANDE_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 7200 (class 2604 OID 36398664)
-- Name: ID_COMMERCIAL; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."COMMERCIAL" ALTER COLUMN "ID_COMMERCIAL" SET DEFAULT nextval('"Default"."COMMERCIAL_ID_COMMERCIAL_seq"'::regclass);


--
-- TOC entry 7215 (class 2604 OID 36398665)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."COMPTE_CLIENT_TRANSACTION" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."COMPTE_CLIENT_TRANSACTION_ID_seq"'::regclass);


--
-- TOC entry 7222 (class 2604 OID 36398666)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."COMPTE_PCE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."COMPTE_PCE_ID_seq"'::regclass);


--
-- TOC entry 7234 (class 2604 OID 36398667)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."COMPTE_PCG" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."COMPTE_PCG_ID_seq"'::regclass);


--
-- TOC entry 7245 (class 2604 OID 36398668)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CONTACT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CONTACT_ID_seq"'::regclass);


--
-- TOC entry 7262 (class 2604 OID 36398669)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CONTACT_ADMINISTRATIF" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CONTACT_ADMINISTRATIF_ID_seq"'::regclass);


--
-- TOC entry 7276 (class 2604 OID 36398670)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CONTACT_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CONTACT_FOURNISSEUR_ID_seq"'::regclass);


--
-- TOC entry 7290 (class 2604 OID 36398671)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CONTRAT_PREVOYANCE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CONTRAT_PREVOYANCE_ID_seq"'::regclass);


--
-- TOC entry 7299 (class 2604 OID 36398672)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CONTRAT_PREVOYANCE_AYANT_DROIT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CONTRAT_PREVOYANCE_AYANT_DROIT_ID_seq"'::regclass);


--
-- TOC entry 7304 (class 2604 OID 36398673)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CONTRAT_PREVOYANCE_CONTRAT_SALARIE_ID_seq"'::regclass);


--
-- TOC entry 7311 (class 2604 OID 36398674)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CONTRAT_PREVOYANCE_RUBRIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CONTRAT_PREVOYANCE_RUBRIQUE_ID_seq"'::regclass);


--
-- TOC entry 7316 (class 2604 OID 36398675)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CONTRAT_PREVOYANCE_RUBRIQUE_NET" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CONTRAT_PREVOYANCE_RUBRIQUE_NET_ID_seq"'::regclass);


--
-- TOC entry 7321 (class 2604 OID 36398676)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CONTRAT_SALARIE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CONTRAT_SALARIE_ID_seq"'::regclass);


--
-- TOC entry 7347 (class 2604 OID 36398677)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."COURRIER_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."COURRIER_CLIENT_ID_seq"'::regclass);


--
-- TOC entry 13465 (class 2604 OID 36417078)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."COUT_REVIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."COUT_REVIENT_ID_seq"'::regclass);


--
-- TOC entry 7356 (class 2604 OID 36398678)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CUMULS_CONGES" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CUMULS_CONGES_ID_seq"'::regclass);


--
-- TOC entry 7362 (class 2604 OID 36398679)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."CUMULS_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."CUMULS_PAYE_ID_seq"'::regclass);


--
-- TOC entry 7381 (class 2604 OID 36398680)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."DECLARATION_DSN" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."DECLARATION_DSN_ID_seq"'::regclass);


--
-- TOC entry 7400 (class 2604 OID 36398681)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."DEMANDE_ACHAT_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."DEMANDE_ACHAT_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 7428 (class 2604 OID 36398682)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."DEMANDE_PRIX" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."DEMANDE_PRIX_ID_seq"'::regclass);


--
-- TOC entry 7439 (class 2604 OID 36398683)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."DEMANDE_PRIX_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."DEMANDE_PRIX_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 7484 (class 2604 OID 36398684)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."DEPARTEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."DEPARTEMENT_ID_seq"'::regclass);


--
-- TOC entry 13447 (class 2604 OID 36416968)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."DEPOT_CHEQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."DEPOT_CHEQUE_ID_seq"'::regclass);


--
-- TOC entry 13454 (class 2604 OID 36417005)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."DEPOT_CHEQUE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."DEPOT_CHEQUE_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 13517 (class 2604 OID 36417676)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."DEPOT_STOCK" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."DEPOT_STOCK_ID_seq"'::regclass);


--
-- TOC entry 7492 (class 2604 OID 36398685)
-- Name: ID_DEVIS; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."DEVIS" ALTER COLUMN "ID_DEVIS" SET DEFAULT nextval('"Default"."DEVIS_ID_DEVIS_seq"'::regclass);


--
-- TOC entry 7520 (class 2604 OID 36398686)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."DEVISE_HISTORIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."DEVISE_HISTORIQUE_ID_seq"'::regclass);


--
-- TOC entry 7527 (class 2604 OID 36398687)
-- Name: ID_DEVIS_ELEMENT; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."DEVIS_ELEMENT" ALTER COLUMN "ID_DEVIS_ELEMENT" SET DEFAULT nextval('"Default"."DEVIS_ELEMENT_ID_DEVIS_ELEMENT_seq"'::regclass);


--
-- TOC entry 7583 (class 2604 OID 36398688)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ECHANTILLON_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ECHANTILLON_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 7595 (class 2604 OID 36398689)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ECHEANCE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ECHEANCE_CLIENT_ID_seq"'::regclass);


--
-- TOC entry 7608 (class 2604 OID 36398690)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ECHEANCE_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ECHEANCE_FOURNISSEUR_ID_seq"'::regclass);


--
-- TOC entry 7617 (class 2604 OID 36398691)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ECRITURE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ECRITURE_ID_seq"'::regclass);


--
-- TOC entry 7639 (class 2604 OID 36398692)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."EMPLOYEUR_MULTIPLE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."EMPLOYEUR_MULTIPLE_ID_seq"'::regclass);


--
-- TOC entry 7644 (class 2604 OID 36398693)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ENCAISSER_MONTANT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ENCAISSER_MONTANT_ID_seq"'::regclass);


--
-- TOC entry 7658 (class 2604 OID 36398694)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ENCAISSER_MONTANT_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ENCAISSER_MONTANT_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 7666 (class 2604 OID 36398695)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ETAT_CIVIL" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ETAT_CIVIL_ID_seq"'::regclass);


--
-- TOC entry 7691 (class 2604 OID 36398696)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ETAT_DEMANDE_ACHAT_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ETAT_DEMANDE_ACHAT_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 7694 (class 2604 OID 36398697)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ETAT_DEMANDE_PRIX" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ETAT_DEMANDE_PRIX_ID_seq"'::regclass);


--
-- TOC entry 7698 (class 2604 OID 36398698)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ETAT_DEVIS" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ETAT_DEVIS_ID_seq"'::regclass);


--
-- TOC entry 7703 (class 2604 OID 36398699)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ETAT_RAPPORT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ETAT_RAPPORT_ID_seq"'::regclass);


--
-- TOC entry 13430 (class 2604 OID 36416902)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ETAT_STOCK" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ETAT_STOCK_ID_seq"'::regclass);


--
-- TOC entry 13435 (class 2604 OID 36416916)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."ETAT_STOCK_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."ETAT_STOCK_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 7708 (class 2604 OID 36398700)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."FABRICANT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."FABRICANT_ID_seq"'::regclass);


--
-- TOC entry 7711 (class 2604 OID 36398701)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."FACTURATION_COMMANDE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."FACTURATION_COMMANDE_CLIENT_ID_seq"'::regclass);


--
-- TOC entry 7726 (class 2604 OID 36398702)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."FACTURE_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."FACTURE_FOURNISSEUR_ID_seq"'::regclass);


--
-- TOC entry 7753 (class 2604 OID 36398703)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."FACTURE_FOURNISSEUR_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."FACTURE_FOURNISSEUR_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 7800 (class 2604 OID 36398704)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."FAMILLE_ARTICLE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."FAMILLE_ARTICLE_ID_seq"'::regclass);


--
-- TOC entry 7809 (class 2604 OID 36398705)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."FAMILLE_ARTICLE_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."FAMILLE_ARTICLE_FOURNISSEUR_ID_seq"'::regclass);


--
-- TOC entry 7814 (class 2604 OID 36398706)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."FICHE_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."FICHE_PAYE_ID_seq"'::regclass);


--
-- TOC entry 7850 (class 2604 OID 36398707)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."FICHE_PAYE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."FICHE_PAYE_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 7869 (class 2604 OID 36398708)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."FIN_CONTRAT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."FIN_CONTRAT_ID_seq"'::regclass);


--
-- TOC entry 7878 (class 2604 OID 36398709)
-- Name: ID_FOURNISSEUR; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."FOURNISSEUR" ALTER COLUMN "ID_FOURNISSEUR" SET DEFAULT nextval('"Default"."FOURNISSEUR_ID_FOURNISSEUR_seq"'::regclass);


--
-- TOC entry 13470 (class 2604 OID 36417171)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."FRAIS_DOCUMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."FRAIS_DOCUMENT_ID_seq"'::regclass);


--
-- TOC entry 7903 (class 2604 OID 36398710)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."FWK_MODULE_METADATA" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."FWK_MODULE_METADATA_ID_seq"'::regclass);


--
-- TOC entry 7909 (class 2604 OID 36398711)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."IDCC" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."IDCC_ID_seq"'::regclass);


--
-- TOC entry 7915 (class 2604 OID 36398712)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."INFOS_SALARIE_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."INFOS_SALARIE_PAYE_ID_seq"'::regclass);


--
-- TOC entry 7931 (class 2604 OID 36398713)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."JOURNAL" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."JOURNAL_ID_seq"'::regclass);


--
-- TOC entry 7937 (class 2604 OID 36398714)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."LANGUE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."LANGUE_ID_seq"'::regclass);


--
-- TOC entry 7943 (class 2604 OID 36398715)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."METRIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."METRIQUE_ID_seq"'::regclass);


--
-- TOC entry 7949 (class 2604 OID 36398716)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."MODELE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."MODELE_ID_seq"'::regclass);


--
-- TOC entry 7954 (class 2604 OID 36398717)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."MODELE_COURRIER_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."MODELE_COURRIER_CLIENT_ID_seq"'::regclass);


--
-- TOC entry 7963 (class 2604 OID 36398718)
-- Name: ID_MODE_REGLEMENT; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."MODE_REGLEMENT" ALTER COLUMN "ID_MODE_REGLEMENT" SET DEFAULT nextval('"Default"."MODE_REGLEMENT_ID_MODE_REGLEMENT_seq"'::regclass);


--
-- TOC entry 7978 (class 2604 OID 36398719)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."MODE_REGLEMENT_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."MODE_REGLEMENT_PAYE_ID_seq"'::regclass);


--
-- TOC entry 7980 (class 2604 OID 36398720)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."MODE_VENTE_ARTICLE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."MODE_VENTE_ARTICLE_ID_seq"'::regclass);


--
-- TOC entry 7996 (class 2604 OID 36398721)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."MOIS" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."MOIS_ID_seq"'::regclass);


--
-- TOC entry 8001 (class 2604 OID 36398722)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."MOUVEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."MOUVEMENT_ID_seq"'::regclass);


--
-- TOC entry 8011 (class 2604 OID 36398723)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."MOUVEMENT_STOCK" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."MOUVEMENT_STOCK_ID_seq"'::regclass);


--
-- TOC entry 8027 (class 2604 OID 36398724)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."NATURE_COMPTE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."NATURE_COMPTE_ID_seq"'::regclass);


--
-- TOC entry 8032 (class 2604 OID 36398725)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."NUMEROTATION_AUTO" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."NUMEROTATION_AUTO_ID_seq"'::regclass);


--
-- TOC entry 8068 (class 2604 OID 36398726)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."OBJECTIF_COMMERCIAL" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."OBJECTIF_COMMERCIAL_ID_seq"'::regclass);


--
-- TOC entry 13477 (class 2604 OID 36417356)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."PAS" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."PAS_ID_seq"'::regclass);


--
-- TOC entry 8075 (class 2604 OID 36398727)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."PAYS" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."PAYS_ID_seq"'::regclass);


--
-- TOC entry 8083 (class 2604 OID 36398728)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."PIECE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."PIECE_ID_seq"'::regclass);


--
-- TOC entry 8088 (class 2604 OID 36398729)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."POSTE_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."POSTE_ANALYTIQUE_ID_seq"'::regclass);


--
-- TOC entry 8096 (class 2604 OID 36398730)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."PREFERENCES" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."PREFERENCES_ID_seq"'::regclass);


--
-- TOC entry 8101 (class 2604 OID 36398731)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."PREFS_COMPTE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."PREFS_COMPTE_ID_seq"'::regclass);


--
-- TOC entry 8128 (class 2604 OID 36398732)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."REFERENCE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."REFERENCE_CLIENT_ID_seq"'::regclass);


--
-- TOC entry 8134 (class 2604 OID 36398733)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."REGIME_BASE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."REGIME_BASE_ID_seq"'::regclass);


--
-- TOC entry 8145 (class 2604 OID 36398734)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."REGLEMENT_PAYE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."REGLEMENT_PAYE_ID_seq"'::regclass);


--
-- TOC entry 8154 (class 2604 OID 36398735)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."REGLER_MONTANT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."REGLER_MONTANT_ID_seq"'::regclass);


--
-- TOC entry 8161 (class 2604 OID 36398736)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."REGLER_MONTANT_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."REGLER_MONTANT_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 8169 (class 2604 OID 36398737)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."RELANCE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."RELANCE_ID_seq"'::regclass);


--
-- TOC entry 8180 (class 2604 OID 36398738)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."REPARTITION_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."REPARTITION_ANALYTIQUE_ID_seq"'::regclass);


--
-- TOC entry 8185 (class 2604 OID 36398739)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."REPARTITION_ANALYTIQUE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."REPARTITION_ANALYTIQUE_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 8192 (class 2604 OID 36398740)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."REPRISE_TRAVAIL" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."REPRISE_TRAVAIL_ID_seq"'::regclass);


--
-- TOC entry 8200 (class 2604 OID 36398741)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."SAISIE_ACHAT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."SAISIE_ACHAT_ID_seq"'::regclass);


--
-- TOC entry 8218 (class 2604 OID 36398742)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."SAISIE_KM" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."SAISIE_KM_ID_seq"'::regclass);


--
-- TOC entry 8224 (class 2604 OID 36398743)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."SAISIE_KM_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."SAISIE_KM_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 8237 (class 2604 OID 36398744)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."SAISIE_VENTE_COMPTOIR" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."SAISIE_VENTE_COMPTOIR_ID_seq"'::regclass);


--
-- TOC entry 8255 (class 2604 OID 36398745)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."SAISIE_VENTE_FACTURE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."SAISIE_VENTE_FACTURE_ID_seq"'::regclass);


--
-- TOC entry 8313 (class 2604 OID 36398746)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."SAISIE_VENTE_FACTURE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."SAISIE_VENTE_FACTURE_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 8389 (class 2604 OID 36398747)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."SALARIE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."SALARIE_ID_seq"'::regclass);


--
-- TOC entry 8407 (class 2604 OID 36398748)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."SEPA_DIRECT_DEBIT_MESSAGE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."SEPA_DIRECT_DEBIT_MESSAGE_ID_seq"'::regclass);


--
-- TOC entry 8412 (class 2604 OID 36398749)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."SEPA_MANDATE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."SEPA_MANDATE_ID_seq"'::regclass);


--
-- TOC entry 8418 (class 2604 OID 36398750)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."SITUATION_FAMILIALE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."SITUATION_FAMILIALE_ID_seq"'::regclass);


--
-- TOC entry 8424 (class 2604 OID 36398751)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."STOCK" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."STOCK_ID_seq"'::regclass);


--
-- TOC entry 8435 (class 2604 OID 36398752)
-- Name: ID_STYLE; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."STYLE" ALTER COLUMN "ID_STYLE" SET DEFAULT nextval('"Default"."STYLE_ID_STYLE_seq"'::regclass);


--
-- TOC entry 8439 (class 2604 OID 36398753)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."TARIF" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."TARIF_ID_seq"'::regclass);


--
-- TOC entry 8445 (class 2604 OID 36398754)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."TARIF_QUANTITE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."TARIF_QUANTITE_ID_seq"'::regclass);


--
-- TOC entry 8450 (class 2604 OID 36398755)
-- Name: ID_TAXE; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."TAXE" ALTER COLUMN "ID_TAXE" SET DEFAULT nextval('"Default"."TAXE_ID_TAXE_seq"'::regclass);


--
-- TOC entry 8465 (class 2604 OID 36398756)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."TAXE_COMPLEMENTAIRE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."TAXE_COMPLEMENTAIRE_ID_seq"'::regclass);


--
-- TOC entry 8473 (class 2604 OID 36398757)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."TICKET_CAISSE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."TICKET_CAISSE_ID_seq"'::regclass);


--
-- TOC entry 8487 (class 2604 OID 36398758)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."TITRE_PERSONNEL" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."TITRE_PERSONNEL_ID_seq"'::regclass);


--
-- TOC entry 8494 (class 2604 OID 36398759)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."TR_BON_DE_LIVRAISON" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."TR_BON_DE_LIVRAISON_ID_seq"'::regclass);


--
-- TOC entry 8499 (class 2604 OID 36398760)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."TR_BON_RECEPTION" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."TR_BON_RECEPTION_ID_seq"'::regclass);


--
-- TOC entry 8505 (class 2604 OID 36398761)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."TR_COMMANDE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."TR_COMMANDE_ID_seq"'::regclass);


--
-- TOC entry 8511 (class 2604 OID 36398762)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."TR_COMMANDE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."TR_COMMANDE_CLIENT_ID_seq"'::regclass);


--
-- TOC entry 8518 (class 2604 OID 36398763)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."TR_DEVIS" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."TR_DEVIS_ID_seq"'::regclass);


--
-- TOC entry 8526 (class 2604 OID 36398764)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."TR_SAISIE_ACHAT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."TR_SAISIE_ACHAT_ID_seq"'::regclass);


--
-- TOC entry 8531 (class 2604 OID 36398765)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."TR_SAISIE_VENTE_FACTURE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."TR_SAISIE_VENTE_FACTURE_ID_seq"'::regclass);


--
-- TOC entry 8538 (class 2604 OID 36398766)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."TYPE_COMPTE_PCG" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."TYPE_COMPTE_PCG_ID_seq"'::regclass);


--
-- TOC entry 8541 (class 2604 OID 36398767)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."TYPE_LETTRE_RELANCE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."TYPE_LETTRE_RELANCE_ID_seq"'::regclass);


--
-- TOC entry 8547 (class 2604 OID 36398768)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."TYPE_REGLEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."TYPE_REGLEMENT_ID_seq"'::regclass);


--
-- TOC entry 8556 (class 2604 OID 36398769)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."UNITE_VENTE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."UNITE_VENTE_ID_seq"'::regclass);


--
-- TOC entry 8563 (class 2604 OID 36398770)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."VARIABLE_SALARIE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."VARIABLE_SALARIE_ID_seq"'::regclass);


--
-- TOC entry 8586 (class 2604 OID 36398771)
-- Name: ID; Type: DEFAULT; Schema: Default; Owner: openconcerto
--

ALTER TABLE ONLY "Default"."VILLE" ALTER COLUMN "ID" SET DEFAULT nextval('"Default"."VILLE_ID_seq"'::regclass);


--
-- TOC entry 8599 (class 2604 OID 36398772)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."ACOMPTE" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."ACOMPTE_ID_seq"'::regclass);


--
-- TOC entry 8601 (class 2604 OID 36398773)
-- Name: ID_ADRESSE; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."ADRESSE" ALTER COLUMN "ID_ADRESSE" SET DEFAULT nextval('"OpenConcerto42"."ADRESSE_ID_ADRESSE_seq"'::regclass);


--
-- TOC entry 8616 (class 2604 OID 36398774)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."ARRET_TRAVAIL" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."ARRET_TRAVAIL_ID_seq"'::regclass);


--
-- TOC entry 8646 (class 2604 OID 36398775)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."ARTICLE" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."ARTICLE_ID_seq"'::regclass);


--
-- TOC entry 13412 (class 2604 OID 36416274)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."ARTICLE_CATEGORIE_COMPTABLE" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."ARTICLE_CATEGORIE_COMPTABLE_ID_seq"'::regclass);


--
-- TOC entry 8682 (class 2604 OID 36398776)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."ARTICLE_CODE_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."ARTICLE_CODE_CLIENT_ID_seq"'::regclass);


--
-- TOC entry 8688 (class 2604 OID 36398777)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."ARTICLE_DESIGNATION" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."ARTICLE_DESIGNATION_ID_seq"'::regclass);


--
-- TOC entry 8694 (class 2604 OID 36398778)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."ARTICLE_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."ARTICLE_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 8702 (class 2604 OID 36398779)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."ARTICLE_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."ARTICLE_FOURNISSEUR_ID_seq"'::regclass);


--
-- TOC entry 13420 (class 2604 OID 36416327)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."ARTICLE_FOURNISSEUR_SECONDAIRE" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."ARTICLE_FOURNISSEUR_SECONDAIRE_ID_seq"'::regclass);


--
-- TOC entry 8746 (class 2604 OID 36398780)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."ARTICLE_TARIF" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."ARTICLE_TARIF_ID_seq"'::regclass);


--
-- TOC entry 13389 (class 2604 OID 36416142)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."ARTICLE_TARIF_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."ARTICLE_TARIF_FOURNISSEUR_ID_seq"'::regclass);


--
-- TOC entry 8760 (class 2604 OID 36398781)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."ASSOCIATION_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."ASSOCIATION_ANALYTIQUE_ID_seq"'::regclass);


--
-- TOC entry 8774 (class 2604 OID 36398782)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."ASSOCIATION_COMPTE_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."ASSOCIATION_COMPTE_ANALYTIQUE_ID_seq"'::regclass);


--
-- TOC entry 8776 (class 2604 OID 36398783)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."ATTACHMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."ATTACHMENT_ID_seq"'::regclass);


--
-- TOC entry 8799 (class 2604 OID 36398784)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."AVOIR_CLIENT" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."AVOIR_CLIENT_ID_seq"'::regclass);


--
-- TOC entry 8879 (class 2604 OID 36398785)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."AVOIR_CLIENT_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."AVOIR_CLIENT_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 8913 (class 2604 OID 36398786)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."AVOIR_FOURNISSEUR" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."AVOIR_FOURNISSEUR_ID_seq"'::regclass);


--
-- TOC entry 8926 (class 2604 OID 36398787)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."AXE_ANALYTIQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."AXE_ANALYTIQUE_ID_seq"'::regclass);


--
-- TOC entry 8928 (class 2604 OID 36398788)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."AYANT_DROIT" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."AYANT_DROIT_ID_seq"'::regclass);


--
-- TOC entry 8940 (class 2604 OID 36398789)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."BANQUE" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."BANQUE_ID_seq"'::regclass);


--
-- TOC entry 8956 (class 2604 OID 36398790)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."BON_DE_LIVRAISON" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."BON_DE_LIVRAISON_ID_seq"'::regclass);


--
-- TOC entry 9015 (class 2604 OID 36398791)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALTER TABLE ONLY "OpenConcerto42"."BON_DE_LIVRAISON_ELEMENT" ALTER COLUMN "ID" SET DEFAULT nextval('"OpenConcerto42"."BON_DE_LIVRAISON_ELEMENT_ID_seq"'::regclass);


--
-- TOC entry 9047 (class 2604 OID 36398792)
-- Name: ID; Type: DEFAULT; Schema: OpenConcerto42; Owner: openconcerto
--

ALT