/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.customerrelationship.lead.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.importer.DataImporter;
import org.openconcerto.modules.customerrelationship.lead.importer.AdresseCSV;
import org.openconcerto.modules.customerrelationship.lead.importer.LeadCSV;
import org.openconcerto.modules.customerrelationship.lead.importer.LineCSV;
import org.openconcerto.openoffice.ContentType;
import org.openconcerto.openoffice.ODPackage;
import org.openconcerto.openoffice.spreadsheet.Cell;
import org.openconcerto.openoffice.spreadsheet.Sheet;
import org.openconcerto.openoffice.spreadsheet.SpreadSheet;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.utils.cc.IdentityHashSet;
import org.openconcerto.utils.text.CSVReader;
import org.openconcerto.utils.text.CharsetHelper;

public class LeadImporter {
    public LeadCSV createLead(int i, Sheet sheet, int idAdr, int id) {
        Cell cell0 = sheet.getImmutableCellAt(0, i);
        String societeName = cell0.getValue().toString().trim();
        Cell cell1 = sheet.getImmutableCellAt(1, i);
        String loc = cell1.getValue().toString().trim();
        LeadCSV leadLine = new LeadCSV(id, societeName, loc);
        leadLine.setIdAdr(idAdr);
        Cell cell2 = sheet.getImmutableCellAt(2, i);
        String siret = cell2.getValue().toString().trim();
        leadLine.setSiret(siret);
        Cell cell3 = sheet.getImmutableCellAt(3, i);
        String ape = cell3.getValue().toString().trim();
        leadLine.setApe(ape);
        Cell cell4 = sheet.getImmutableCellAt(4, i);
        String tel = cell4.getValue().toString().trim();
        leadLine.setPhone(tel);
        Cell cell5 = sheet.getImmutableCellAt(5, i);
        String fax = cell5.getValue().toString().trim();
        leadLine.setFax(fax);
        Cell cell10 = sheet.getImmutableCellAt(10, i);
        String secteur = cell10.getValue().toString().trim();
        leadLine.setSecteur(secteur);
        Cell cell11 = sheet.getImmutableCellAt(11, i);
        String effectif = cell11.getValue().toString().trim();
        leadLine.setEffectif(effectif);
        Cell cell12 = sheet.getImmutableCellAt(12, i);
        String origine = cell12.getValue().toString().trim();
        leadLine.setOrigine(origine);
        Cell cell14 = sheet.getImmutableCellAt(14, i);
        String statut = cell14.getValue().toString().trim();
        leadLine.setStatut(statut);
        Cell cell15 = sheet.getImmutableCellAt(15, i);
        String prenom = cell15.getValue().toString().trim();
        leadLine.setPrenom(prenom);
        Cell cell16 = sheet.getImmutableCellAt(16, i);
        String nom = cell16.getValue().toString().trim();
        leadLine.setNom(nom);
        Cell cell17 = sheet.getImmutableCellAt(17, i);
        String civi = cell17.getValue().toString().trim();
        leadLine.setCivilite(civi);
        Cell cell18 = sheet.getImmutableCellAt(18, i);
        String mail = cell18.getValue().toString().trim();
        leadLine.setMail(mail);
        Cell cell19 = sheet.getImmutableCellAt(19, i);
        String cell = cell19.getValue().toString().trim();
        leadLine.setCell(cell);
        Cell cell20 = sheet.getImmutableCellAt(20, i);
        String infos = cell20.getValue().toString().trim();
        leadLine.setInfos(infos);
        Cell cell21 = sheet.getImmutableCellAt(21, i);
        String desc = cell21.getValue().toString().trim();
        leadLine.setDesc(desc);
        Cell cell22 = sheet.getImmutableCellAt(22, i);
        String conv = cell22.getValue().toString().trim();
        leadLine.setConverti(conv);
        Cell cell23 = sheet.getImmutableCellAt(23, i);
        String budget = cell23.getValue().toString().trim();
        leadLine.setBudget(budget);
        Cell cell24 = sheet.getImmutableCellAt(24, i);
        String com = cell24.getValue().toString().trim();
        leadLine.setCom(com);
        Cell cell25 = sheet.getImmutableCellAt(25, i);
        String dispo = cell25.getValue().toString().trim();
        leadLine.setDispo(dispo);
        Cell cell26 = sheet.getImmutableCellAt(26, i);
        String cat = cell26.getValue().toString().trim();
        leadLine.setCategorie(cat);
        Cell cell27 = sheet.getImmutableCellAt(27, i);
        String type = cell27.getValue().toString().trim();
        leadLine.setTypeT(type);
        return leadLine;
    }

    public AdresseCSV createAdresse(int i, Sheet sheet, int id) {
        Cell cell6 = sheet.getImmutableCellAt(6, i);
        String street = cell6.getValue().toString().trim();
        Cell cell7 = sheet.getImmutableCellAt(7, i);
        String street2 = cell7.getValue().toString().trim();
        if (street2 != null && street2.trim().length() > 0) {
            street = String.valueOf(street) + "\n" + street2;
        }
        Cell cell8 = sheet.getImmutableCellAt(8, i);
        String ville = cell8.getValue().toString().trim();
        Cell cell9 = sheet.getImmutableCellAt(9, i);
        String cp = cell9.getValue().toString().trim();
        AdresseCSV adrLine = new AdresseCSV(id, street, ville, cp);
        return adrLine;
    }

    public Map<Object, LeadCSV> exportLead(DBRoot root, File dir2save, File sheetFile) throws Exception {
        ArrayList<String[]> adresse = new ArrayList<String[]>();
        ArrayList<String[]> leadList = new ArrayList<String[]>();
        HashMap<Object, LeadCSV> leadMap = new HashMap<Object, LeadCSV>();
        ODPackage pkg = new ODPackage(sheetFile);
        if (pkg.getContentType().getType() != ContentType.SPREADSHEET) {
            throw new IOException("Pas un tableur");
        }
        SpreadSheet calc = pkg.getSpreadSheet();
        Sheet commandesSheet = calc.getSheet(0);
        int sheetCount = commandesSheet.getRowCount();
        int s = 1;
        while (s < sheetCount) {
            Cell cell0 = commandesSheet.getImmutableCellAt(0, s);
            String societeName = cell0.getValue().toString().trim();
            Cell cell16 = commandesSheet.getImmutableCellAt(16, s);
            String name = cell16.getValue().toString().trim();
            if (societeName.trim().length() == 0 && name.trim().length() == 0) break;
            int idAdr = adresse.size();
            AdresseCSV adr = this.createAdresse(s, commandesSheet, idAdr);
            adresse.add(adr.toCSVLine());
            LeadCSV lead = this.createLead(s, commandesSheet, idAdr, leadList.size());
            leadList.add(lead.toCSVLine());
            leadMap.put(lead.getId(), lead);
            ++s;
        }
        DataImporter importer = new DataImporter(root.getTable("LEAD"));
        File csvFile = new File(dir2save, "Lead.csv");
        csvFile.createNewFile();
        importer.exportModelToCSV(csvFile, leadList);
        DataImporter importerAdr = new DataImporter(root.getTable("ADRESSE"));
        File csvFile2 = new File(dir2save, "Address.csv");
        csvFile2.createNewFile();
        importerAdr.exportModelToCSV(csvFile2, adresse);
        return leadMap;
    }

    public void importFromFile(File csvFileDir, DBRoot root) throws Exception {
        SQLRowValues rowValsLead = new SQLRowValues(root.getTable("LEAD"));
        rowValsLead.put("COMPANY", null);
        rowValsLead.put("APE", null);
        rowValsLead.putRowValues("ID_ADRESSE").putNulls(new String[]{"VILLE", "RUE"});
        SQLRowValuesListFetcher fecther = SQLRowValuesListFetcher.create((SQLRowValues)rowValsLead);
        List existingLeads = fecther.fetch();
        ArrayList<String> existingHashLead = new ArrayList<String>(existingLeads.size());
        for (SQLRowValues sqlRowValues : existingLeads) {
            existingHashLead.add(String.valueOf(sqlRowValues.getString("APE")) + "----" + sqlRowValues.getString("COMPANY") + "----" + sqlRowValues.getForeign("ID_ADRESSE").getString("RUE") + "----" + sqlRowValues.getForeign("ID_ADRESSE").getString("VILLE"));
        }
        CSVImporter<AdresseCSV> adr = new CSVImporter<AdresseCSV>(this){

            @Override
            public AdresseCSV convert(String[] line) {
                return AdresseCSV.fromCSVLine(line);
            }
        };
        Map mapAdr = adr.importFrom(new File(csvFileDir, "Address.csv"));
        HashMap<Object, SQLRowValues> mapAdrRows = new HashMap<Object, SQLRowValues>();
        for (Object o : mapAdr.keySet()) {
            AdresseCSV c = (AdresseCSV)mapAdr.get(o);
            mapAdrRows.put(c.getId(), c.toSQLRowValues(root));
        }
        CSVImporter<LeadCSV> client = new CSVImporter<LeadCSV>(this){

            @Override
            public LeadCSV convert(String[] line) {
                return LeadCSV.fromCSVLine(line);
            }
        };
        Map mapClient = client.importFrom(new File(csvFileDir, "Lead.csv"));
        HashMap<Object, SQLRowValues> mapCliRows = new HashMap<Object, SQLRowValues>();
        for (Object o : mapClient.keySet()) {
            LeadCSV c = (LeadCSV)mapClient.get(o);
            String hashLead = String.valueOf(c.getApe()) + "----" + c.getName() + "----" + ((AdresseCSV)mapAdr.get(c.getIdAdr())).getStreet() + "----" + ((AdresseCSV)mapAdr.get(c.getIdAdr())).getCity();
            if (!existingHashLead.contains(hashLead)) {
                mapCliRows.put(c.getId(), c.toSQLRowValues(root, mapAdrRows));
                continue;
            }
            System.err.println("Prospect d\u00e9j\u00e0 existant " + c.getName() + " --> Non import\u00e9");
        }
        IdentityHashSet graphs = new IdentityHashSet();
        for (Object c : mapCliRows.keySet()) {
            graphs.add(((SQLRowValues)mapCliRows.get(c)).getGraph());
        }
        for (SQLRowValuesCluster graph : graphs) {
            graph.store(SQLRowValuesCluster.StoreMode.COMMIT);
        }
    }

    abstract class CSVImporter<T extends LineCSV> {
        CSVImporter() {
        }

        public Map<Object, T> importFrom(File csvFile) throws IOException {
            int start;
            HashMap<Object, T> map = new HashMap<Object, T>();
            Charset cs = CharsetHelper.guessEncoding((File)csvFile, (int)4096, (Charset)Charset.forName("Cp1252"));
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csvFile), cs));
            String l = r.readLine();
            if (l == null) {
                r.close();
                return null;
            }
            char separator = ',';
            int cCount = 0;
            int scCount = 0;
            int i = 0;
            while (i < l.length()) {
                char c = l.charAt(i);
                if (c == ',') {
                    ++cCount;
                } else if (c == ';') {
                    ++scCount;
                }
                ++i;
            }
            r.close();
            if (scCount > cCount) {
                separator = ';';
            }
            CSVReader csvReader = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(csvFile), cs), separator);
            List lines = csvReader.readAll();
            int rowCount = lines.size();
            int i2 = start = 0;
            while (i2 < rowCount) {
                String[] values = (String[])lines.get(i2);
                T convertedLine = this.convert(values);
                map.put(((LineCSV)convertedLine).getId(), convertedLine);
                ++i2;
            }
            csvReader.close();
            return map;
        }

        public abstract T convert(String[] var1);
    }
}

