/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.customerrelationship.lead.importer;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.openconcerto.modules.customerrelationship.lead.importer.LineCSV;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class LeadCSV
extends LineCSV {
    public static final int ID = 0;
    public static final int CODE = 1;
    public static final int NAME = 2;
    public static final int ID_ADR = 3;
    public static final int LOCALISATION = 4;
    public static final int PHONE = 5;
    public static final int MAIL = 6;
    public static final int CELL = 7;
    public static final int FAX = 8;
    public static final int CONTACT = 9;
    public static final int SECTEUR = 10;
    public static final int EFFECTIF = 11;
    public static final int ORIGINE = 12;
    public static final int SIRET = 13;
    public static final int APE = 14;
    public static final int COM = 15;
    public static final int STATUT = 16;
    public static final int PRENOM = 17;
    public static final int NOM = 18;
    public static final int CIVILITE = 19;
    public static final int DESC = 20;
    public static final int CONVERTI = 21;
    public static final int BUDGET = 22;
    public static final int DISPO = 23;
    public static final int CATEGORIE = 24;
    public static final int TYPE_TRAVAUX = 25;
    public static final int INFOS = 26;
    public static final int SIZE = 27;
    private Object idAdr;
    private String code;
    private String name;
    private String localisation;
    private String contact;
    private String phone;
    private String cell;
    private String mail;
    private String fax;
    private String com;
    private String origine;
    private String secteur;
    private String effectif;
    private String siret;
    private String ape;
    private String statut;
    private String prenom;
    private String nom;
    private String civilite;
    private String desc;
    private String converti;
    private String budget;
    private String dispo;
    private String categorie;
    private String typeT;
    private String infos;

    public LeadCSV(Object id, String name, String loc) {
        this.id = id;
        this.localisation = loc;
        this.name = name;
    }

    public void setInfos(String infos) {
        this.infos = infos;
    }

    public String getInfos() {
        return this.infos;
    }

    public void setBudget(String budget) {
        this.budget = budget;
    }

    public String getBudget() {
        return this.budget;
    }

    public void setCategorie(String categorie) {
        this.categorie = categorie;
    }

    public String getCategorie() {
        return this.categorie;
    }

    public void setCivilite(String civilite) {
        this.civilite = civilite;
    }

    public String getCivilite() {
        return this.civilite;
    }

    public String getConverti() {
        return this.converti;
    }

    public void setConverti(String converti) {
        this.converti = converti;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getDispo() {
        return this.dispo;
    }

    public void setDispo(String dispo) {
        this.dispo = dispo;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public String getPrenom() {
        return this.prenom;
    }

    public void setPrenom(String prenom) {
        this.prenom = prenom;
    }

    public String getStatut() {
        return this.statut;
    }

    public void setStatut(String statut) {
        this.statut = statut;
    }

    public String getTypeT() {
        return this.typeT;
    }

    public void setTypeT(String typeT) {
        this.typeT = typeT;
    }

    public String getSiret() {
        return this.siret;
    }

    public void setSiret(String siret) {
        this.siret = siret;
    }

    public String getApe() {
        return this.ape;
    }

    public void setApe(String ape) {
        this.ape = ape;
    }

    public String getCell() {
        return this.cell;
    }

    public String getCom() {
        return this.com;
    }

    public void setCom(String com) {
        this.com = com;
    }

    public String getEffectif() {
        return this.effectif;
    }

    public void setEffectif(String effectif) {
        this.effectif = effectif;
    }

    public String getLocalisation() {
        return this.localisation;
    }

    public void setLocalisation(String localisation) {
        this.localisation = localisation;
    }

    public String getOrigine() {
        return this.origine;
    }

    public void setOrigine(String origine) {
        this.origine = origine;
    }

    public String getSecteur() {
        return this.secteur;
    }

    public void setSecteur(String secteur) {
        this.secteur = secteur;
    }

    public void setCell(String cell) {
        this.cell = cell;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getMail() {
        return this.mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getIdAdr() {
        return this.idAdr;
    }

    public void setIdAdr(Object idAdr) {
        this.idAdr = idAdr;
    }

    public String[] toCSVLine() {
        String[] values = new String[27];
        values[0] = this.id.toString();
        values[1] = this.code;
        values[2] = this.name;
        values[3] = String.valueOf(this.idAdr);
        values[5] = this.phone;
        values[6] = this.mail;
        values[7] = this.cell;
        values[8] = this.fax;
        values[9] = this.contact;
        values[4] = this.localisation;
        values[10] = this.secteur;
        values[11] = this.effectif;
        values[12] = this.origine;
        values[15] = this.com;
        values[14] = this.ape;
        values[13] = this.siret;
        values[16] = this.statut;
        values[17] = this.prenom;
        values[18] = this.nom;
        values[19] = this.civilite;
        values[20] = this.desc;
        values[21] = this.converti;
        values[22] = this.budget;
        values[23] = this.dispo;
        values[24] = this.categorie;
        values[25] = this.typeT;
        values[26] = this.infos;
        return values;
    }

    public SQLRowValues toSQLRowValues(DBRoot root, Map<Object, SQLRowValues> adresse) {
        SQLRowValues rowVals = new SQLRowValues(root.getTable("LEAD"));
        rowVals.put("COMPANY", (Object)this.getName());
        rowVals.put("ID_ADRESSE", (Object)adresse.get(this.getIdAdr()));
        rowVals.put("PHONE", (Object)this.getPhone());
        rowVals.put("EMAIL", (Object)this.getMail());
        rowVals.put("MOBILE", (Object)this.getCell());
        rowVals.put("FAX", (Object)this.getFax());
        rowVals.put("NAME", (Object)this.getContact());
        rowVals.put("LOCALISATION", (Object)this.getLocalisation());
        rowVals.put("INDUSTRY", (Object)this.getSecteur());
        try {
            rowVals.put("EMPLOYEES", (Object)Integer.valueOf(this.getEffectif()));
        }
        catch (Exception e) {
            System.err.println("Unable to parse " + this.getEffectif());
        }
        rowVals.put("SOURCE", (Object)this.getOrigine());
        int idCom = -1;
        if (this.getCom() != null) {
            if (this.getCom().toUpperCase().contains("YANN")) {
                idCom = 3;
            } else if (this.getCom().toUpperCase().contains("ERIC")) {
                idCom = 4;
            } else if (this.getCom().toUpperCase().contains("MARC")) {
                idCom = 2;
            }
        }
        if (idCom != -1) {
            rowVals.put("ID_COMMERCIAL", idCom);
        }
        rowVals.put("SIRET", (Object)this.getSiret());
        rowVals.put("APE", (Object)this.getApe());
        rowVals.put("DATE", (Object)new Date());
        int idCiv = 1;
        if (this.getCivilite() != null) {
            if (this.getCivilite().equalsIgnoreCase("Mr.")) {
                idCiv = 2;
            } else if (this.getCivilite().equalsIgnoreCase("Mrs.")) {
                idCiv = 3;
            }
        }
        if (idCiv != -1) {
            rowVals.put("ID_TITRE_PERSONNEL", idCiv);
        }
        rowVals.put("NAME", (Object)this.getNom());
        rowVals.put("FIRSTNAME", (Object)this.getPrenom());
        rowVals.put("INFORMATION", (Object)this.getDesc());
        rowVals.put("DISPO", (Object)this.getDispo());
        rowVals.put("INDUSTRY", (Object)this.getTypeT());
        rowVals.put("STATUS", (Object)this.getStatut());
        rowVals.put("INFOS", (Object)this.getInfos());
        if (this.getConverti().equalsIgnoreCase("1")) {
            SQLInjector inj = SQLInjector.getInjector((SQLTable)root.getTable("LEAD"), (SQLTable)root.getTable("CLIENT"));
            SQLRowValues rowValsCli = inj.createRowValuesFrom(Arrays.asList(rowVals));
            SQLRowValues rowValsAdr = new SQLRowValues(rowVals.getForeign("ID_ADRESSE").asRowValues());
            rowValsCli.put("ID_ADRESSE", (Object)rowValsAdr);
            SQLRowValues rowValsContact = SQLInjector.getInjector((SQLTable)root.getTable("LEAD"), (SQLTable)root.getTable("CONTACT")).createRowValuesFrom(Arrays.asList(rowVals));
            rowValsContact.put("ID_CLIENT", (Object)rowValsCli);
            rowVals.put("ID_CLIENT", (Object)rowValsCli);
        }
        return rowVals;
    }

    public boolean isDigitsOrChar(String s) {
        boolean ok = true;
        int i = 0;
        while (i < s.length()) {
            char charAt = s.charAt(i);
            ok &= charAt == ' ' || charAt >= '0' && charAt <= '9' || charAt >= 'a' && charAt <= 'z' || charAt >= 'A' && charAt <= 'Z';
            ++i;
        }
        return ok;
    }

    public static LeadCSV fromCSVLine(String[] line) {
        LeadCSV cli = new LeadCSV(line[0], line[2], line[4]);
        cli.setCell(line[7]);
        cli.setContact(line[9]);
        cli.setFax(line[8]);
        cli.setIdAdr(line[3]);
        cli.setMail(line[6]);
        cli.setPhone(line[5]);
        cli.setSecteur(line[10]);
        cli.setEffectif(line[11]);
        cli.setOrigine(line[12]);
        cli.setCom(line[15]);
        cli.setSiret(line[13]);
        cli.setApe(line[14]);
        cli.setPrenom(line[17]);
        cli.setNom(line[18]);
        cli.setCivilite(line[19]);
        cli.setDesc(line[20]);
        cli.setConverti(line[21]);
        cli.setBudget(line[22]);
        cli.setDispo(line[23]);
        cli.setCategorie(line[24]);
        cli.setTypeT(line[25]);
        cli.setStatut(line[16]);
        cli.setInfos(line[26]);
        return cli;
    }
}

