/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.customerrelationship.lead.importer;

import org.openconcerto.modules.customerrelationship.lead.importer.LineCSV;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLRowValues;

public class AdresseCSV
extends LineCSV {
    public static final int ID = 0;
    public static final int STREET = 1;
    public static final int CITY = 2;
    public static final int CODE = 3;
    public static final int ID_LEAD = 4;
    private String code;
    private String city;
    private String street;

    public AdresseCSV(Object id, String street, String city, String code) {
        this.id = id;
        this.code = code;
        this.city = city;
        this.street = street;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String[] toCSVLine() {
        String[] values = new String[10];
        values[0] = this.id.toString();
        values[3] = this.code;
        values[2] = this.city;
        values[1] = String.valueOf(this.street);
        return values;
    }

    public static AdresseCSV fromCSVLine(String[] line) {
        AdresseCSV adr = new AdresseCSV(line[0], line[1], line[2], line[3]);
        return adr;
    }

    public SQLRowValues toSQLRowValues(DBRoot root) {
        SQLRowValues rowVals = new SQLRowValues(root.getTable("ADRESSE"));
        rowVals.put("RUE", (Object)this.getStreet());
        rowVals.put("VILLE", (Object)this.getCity());
        rowVals.put("CODE_POSTAL", (Object)this.getCode());
        rowVals.put("PAYS", (Object)"France");
        return rowVals;
    }
}

