/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.customerrelationship.lead;

import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.ComponentsContext;
import org.openconcerto.erp.modules.DBContext;
import org.openconcerto.erp.modules.MenuContext;
import org.openconcerto.erp.modules.ModuleFactory;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.modules.ModulePackager;
import org.openconcerto.erp.modules.RuntimeModuleFactory;
import org.openconcerto.modules.customerrelationship.lead.LeadContactSQLInjector;
import org.openconcerto.modules.customerrelationship.lead.LeadCustomerSQLInjector;
import org.openconcerto.modules.customerrelationship.lead.LeadGroup;
import org.openconcerto.modules.customerrelationship.lead.LeadListAction;
import org.openconcerto.modules.customerrelationship.lead.LeadSQLElement;
import org.openconcerto.modules.customerrelationship.lead.ServiceSQLElement;
import org.openconcerto.modules.customerrelationship.lead.SuiviClientProspectListAction;
import org.openconcerto.modules.customerrelationship.lead.call.CustomerCallSQLElement;
import org.openconcerto.modules.customerrelationship.lead.call.CustomerCallServiceSQLElement;
import org.openconcerto.modules.customerrelationship.lead.call.LeadCallSQLElement;
import org.openconcerto.modules.customerrelationship.lead.call.LeadCallServiceSQLElement;
import org.openconcerto.modules.customerrelationship.lead.importer.LeadImporter;
import org.openconcerto.modules.customerrelationship.lead.visit.CustomerVisitSQLElement;
import org.openconcerto.modules.customerrelationship.lead.visit.CustomerVisitServiceSQLElement;
import org.openconcerto.modules.customerrelationship.lead.visit.LeadVisitSQLElement;
import org.openconcerto.modules.customerrelationship.lead.visit.LeadVisitServiceSQLElement;
import org.openconcerto.openoffice.ContentTypeVersioned;
import org.openconcerto.sql.element.GlobalMapper;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRequestLog;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.SQLCreateTable;
import org.openconcerto.sql.utils.SQLCreateTableBase;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.utils.ExceptionHandler;

public final class Module
extends AbstractModule {
    public static final String TABLE_LEAD = "LEAD";
    public static final String TABLE_LEAD_CALL = "LEAD_CALL";
    public static final String TABLE_CUSTOMER_CALL = "CUSTOMER_CALL";
    public static final String TABLE_LEAD_VISIT = "LEAD_VISIT";
    public static final String TABLE_CUSTOMER_VISIT = "CUSTOMER_VISIT";
    public static final String TABLE_SERVICE = "SERVICE";
    public static final String TABLE_LEAD_CALL_SERVICE = "LEAD_CALL_SERVICE";
    public static final String TABLE_CUSTOMER_CALL_SERVICE = "CUSTOMER_CALL_SERVICE";
    public static final String TABLE_LEAD_VISIT_SERVICE = "LEAD_VISIT_SERVICE";
    public static final String TABLE_CUSTOMER_VISIT_SERVICE = "CUSTOMER_VISIT_SERVICE";

    public Module(ModuleFactory f) throws IOException {
        super(f);
    }

    protected void install(DBContext ctxt) {
        super.install(ctxt);
        if (ctxt.getRoot().getTable(TABLE_LEAD) == null) {
            SQLCreateTable createTable1;
            SQLCreateTable createTable = ctxt.getCreateTable(TABLE_LEAD);
            createTable.addVarCharColumn("NUMBER", 20);
            createTable.addDateAndTimeColumn("DATE");
            createTable.addVarCharColumn("FIRSTNAME", 64);
            createTable.addVarCharColumn("NAME", 64);
            createTable.addVarCharColumn("COMPANY", 64);
            createTable.addVarCharColumn("PHONE", 16);
            createTable.addVarCharColumn("MOBILE", 16);
            createTable.addVarCharColumn("FAX", 16);
            createTable.addVarCharColumn("EMAIL", 32);
            createTable.addVarCharColumn("WEBSITE", 64);
            createTable.addVarCharColumn("SOURCE", 200);
            createTable.addVarCharColumn("STATUS", 50);
            createTable.addForeignColumn("ADRESSE");
            createTable.addForeignColumn("COMMERCIAL");
            createTable.addVarCharColumn("INFORMATION", 512);
            createTable.addVarCharColumn("INDUSTRY", 200);
            createTable.addVarCharColumn("RATING", 200);
            createTable.addIntegerColumn("REVENUE", 0);
            createTable.addIntegerColumn("EMPLOYEES", 0);
            createTable.addVarCharColumn("ROLE", 128);
            createTable.addForeignColumn("CLIENT");
            createTable.addVarCharColumn("LOCALISATION", 256);
            createTable.addVarCharColumn("INFOS", 128);
            createTable.addForeignColumn("TITRE_PERSONNEL");
            createTable.addDateAndTimeColumn("REMIND_DATE");
            createTable.addVarCharColumn("APE", 128);
            createTable.addVarCharColumn("SIRET", 256);
            createTable.addVarCharColumn("DISPO", 256);
            createTable.addBooleanColumn("MAILING", Boolean.FALSE, false);
            SQLCreateTable createLCall = ctxt.getCreateTable(TABLE_LEAD_CALL);
            createLCall.addDateAndTimeColumn("DATE");
            createLCall.addForeignColumn((SQLCreateTableBase)createTable);
            createLCall.addVarCharColumn("INFORMATION", 10240);
            createLCall.addDateAndTimeColumn("NEXTCONTACT_DATE");
            createLCall.addVarCharColumn("NEXTCONTACT_INFO", 1024);
            SQLCreateTable createCCall = ctxt.getCreateTable(TABLE_CUSTOMER_CALL);
            createCCall.addDateAndTimeColumn("DATE");
            createCCall.addForeignColumn("CLIENT");
            createCCall.addVarCharColumn("INFORMATION", 10240);
            createCCall.addDateAndTimeColumn("NEXTCONTACT_DATE");
            createCCall.addVarCharColumn("NEXTCONTACT_INFO", 1024);
            SQLCreateTable createLV = ctxt.getCreateTable(TABLE_LEAD_VISIT);
            createLV.addDateAndTimeColumn("DATE");
            createLV.addForeignColumn((SQLCreateTableBase)createTable);
            createLV.addVarCharColumn("INFORMATION", 10240);
            createLV.addDateAndTimeColumn("NEXTCONTACT_DATE");
            createLV.addVarCharColumn("NEXTCONTACT_INFO", 1024);
            SQLCreateTable createCV = ctxt.getCreateTable(TABLE_CUSTOMER_VISIT);
            createCV.addDateAndTimeColumn("DATE");
            createCV.addForeignColumn("CLIENT");
            createCV.addVarCharColumn("INFORMATION", 10240);
            createCV.addDateAndTimeColumn("NEXTCONTACT_DATE");
            createCV.addVarCharColumn("NEXTCONTACT_INFO", 1024);
            SQLCreateTable createService = ctxt.getCreateTable(TABLE_SERVICE);
            createService.addVarCharColumn("NAME", 256);
            if (ctxt.getRoot().getTable(TABLE_LEAD_CALL_SERVICE) == null) {
                createTable1 = ctxt.getCreateTable(TABLE_LEAD_CALL_SERVICE);
                createTable1.addForeignColumn((SQLCreateTableBase)createLCall);
                createTable1.addForeignColumn((SQLCreateTableBase)createService);
            }
            if (ctxt.getRoot().getTable(TABLE_CUSTOMER_CALL_SERVICE) == null) {
                createTable1 = ctxt.getCreateTable(TABLE_CUSTOMER_CALL_SERVICE);
                createTable1.addForeignColumn((SQLCreateTableBase)createCCall);
                createTable1.addForeignColumn((SQLCreateTableBase)createService);
            }
            if (ctxt.getRoot().getTable(TABLE_LEAD_VISIT_SERVICE) == null) {
                createTable1 = ctxt.getCreateTable(TABLE_LEAD_VISIT_SERVICE);
                createTable1.addForeignColumn((SQLCreateTableBase)createLV);
                createTable1.addForeignColumn((SQLCreateTableBase)createService);
            }
            if (ctxt.getRoot().getTable(TABLE_CUSTOMER_VISIT_SERVICE) == null) {
                createTable1 = ctxt.getCreateTable(TABLE_CUSTOMER_VISIT_SERVICE);
                createTable1.addForeignColumn((SQLCreateTableBase)createCV);
                createTable1.addForeignColumn((SQLCreateTableBase)createService);
            }
        }
    }

    protected void setupElements(final SQLElementDirectory dir) {
        super.setupElements(dir);
        LeadSQLElement element = new LeadSQLElement(this);
        GlobalMapper.getInstance().map(String.valueOf(element.getCode()) + ".default", (Object)new LeadGroup());
        dir.addSQLElement((SQLElement)element);
        dir.addSQLElement((SQLElement)new LeadCallSQLElement(this));
        dir.addSQLElement((SQLElement)new CustomerCallSQLElement(this));
        dir.addSQLElement((SQLElement)new LeadVisitSQLElement(this));
        dir.addSQLElement((SQLElement)new CustomerVisitSQLElement(this));
        dir.addSQLElement((SQLElement)new ServiceSQLElement(this));
        dir.addSQLElement((SQLElement)new LeadCallServiceSQLElement(this));
        dir.addSQLElement((SQLElement)new CustomerCallServiceSQLElement(this));
        dir.addSQLElement((SQLElement)new LeadVisitServiceSQLElement(this));
        dir.addSQLElement((SQLElement)new CustomerVisitServiceSQLElement(this));
        RowAction.PredicateRowAction addCallAction = new RowAction.PredicateRowAction(new AbstractAction("Appeler"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow sRow = IListe.get((EventObject)e).getSelectedRow().asRow();
                SQLElement eCall = dir.getElement(Module.TABLE_CUSTOMER_CALL);
                SQLTable table = eCall.getTable();
                EditFrame editFrame = new EditFrame(eCall);
                SQLRowValues sqlRowValues = new SQLRowValues(table);
                sqlRowValues.put("ID_CLIENT", (Object)sRow.getIDNumber());
                editFrame.getSQLComponent().select((SQLRowAccessor)sqlRowValues);
                FrameUtil.show((Window)editFrame);
            }
        }, true){};
        addCallAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        dir.getElement("CLIENT").getRowActions().add(addCallAction);
        RowAction.PredicateRowAction addVisitAction = new RowAction.PredicateRowAction(new AbstractAction("Enregister une visite"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow sRow = IListe.get((EventObject)e).getSelectedRow().asRow();
                SQLElement eCall = dir.getElement(Module.TABLE_CUSTOMER_VISIT);
                SQLTable table = eCall.getTable();
                EditFrame editFrame = new EditFrame(eCall);
                SQLRowValues sqlRowValues = new SQLRowValues(table);
                sqlRowValues.put("ID_CLIENT", (Object)sRow.getIDNumber());
                editFrame.getSQLComponent().select((SQLRowAccessor)sqlRowValues);
                FrameUtil.show((Window)editFrame);
            }
        }, true){};
        addVisitAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        dir.getElement("CLIENT").getRowActions().add(addVisitAction);
    }

    protected void setupComponents(ComponentsContext ctxt) {
    }

    protected void setupMenu(final MenuContext ctxt) {
        ctxt.addMenuItem((Action)((Object)new LeadListAction()), "menu.list");
        ctxt.addMenuItem((Action)new CreateFrameAbstractAction("Liste des services"){

            public JFrame createFrame() {
                JFrame frame = new JFrame("Services propos\u00e9s");
                frame.setContentPane((Container)new ListeAddPanel(ctxt.getElement(Module.TABLE_SERVICE)));
                return frame;
            }
        }, "menu.organization");
        ctxt.addMenuItem((Action)((Object)new SuiviClientProspectListAction()), "menu.list");
        ctxt.addMenuItem((Action)new AbstractAction("Import de prospects"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame frame = (Frame)SwingThreadUtils.getAncestorOrSelf(Frame.class, (Component)((Component)e.getSource()));
                final FileDialog fd = new FileDialog(frame, "Import de prospects", 0);
                fd.setFilenameFilter(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith("." + ContentTypeVersioned.SPREADSHEET.getExtension());
                    }
                });
                fd.setVisible(true);
                if (fd.getFile() != null) {
                    final DBRoot rootSociete = ((ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance()).getRootSociete();
                    try {
                        SQLUtils.executeAtomic((SQLDataSource)rootSociete.getDBSystemRoot().getDataSource(), (ConnectionHandlerNoSetup)new ConnectionHandlerNoSetup<Object, IOException>(){

                            public Object handle(SQLDataSource ds) throws SQLException, IOException {
                                File f = new File(fd.getDirectory());
                                LeadImporter imp = new LeadImporter();
                                try {
                                    imp.exportLead(rootSociete, f, new File(fd.getDirectory(), fd.getFile()));
                                    imp.importFromFile(f, rootSociete);
                                }
                                catch (Exception exn) {
                                    exn.printStackTrace();
                                }
                                return null;
                            }
                        });
                    }
                    catch (IOException exn) {
                        ExceptionHandler.handle((Component)frame, (String)"Erreur lors de la lecture du fichier", (Throwable)exn);
                    }
                    catch (SQLException exn) {
                        ExceptionHandler.handle((Component)frame, (String)"Erreur lors de l'insertion dans la base", (Throwable)exn);
                    }
                }
            }
        }, "menu.file");
    }

    protected void start() {
        new LeadCustomerSQLInjector();
        new LeadContactSQLInjector();
    }

    protected void stop() {
    }

    public static void main(String[] args) throws IOException {
        System.setProperty("org.openconcerto.quickLogin", "true");
        File propsFile = new File("module.properties");
        System.out.println(propsFile.getAbsolutePath());
        RuntimeModuleFactory factory = new RuntimeModuleFactory(propsFile);
        SQLRequestLog.setEnabled((boolean)true);
        SQLRequestLog.showFrame();
        ModulePackager modulePackager = new ModulePackager(propsFile, new File("bin/"));
        modulePackager.writeToDir(new File("../OpenConcerto/Modules"));
        ModuleManager.getInstance().addFactories(new File("../OpenConcerto/Modules"));
        ModuleManager.getInstance().addFactoryAndStart((ModuleFactory)factory, false);
        Gestion.main((String[])args);
    }
}

