/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.customerrelationship.lead;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.erp.modules.AbstractModule;
import org.openconcerto.erp.modules.ModuleElement;
import org.openconcerto.modules.customerrelationship.lead.LeadSQLComponent;
import org.openconcerto.modules.customerrelationship.lead.RemindDateRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.GlobalMapper;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.EditPanelListener;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.ui.EmailComposer;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.group.Group;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.cc.ITransformer;

public class LeadSQLElement
extends ModuleElement {
    public static final String ELEMENT_CODE = "customerrelationship.lead";
    public static String CODE_NOT_RESTRICT = "VIEW_ALL_LEADS";

    public LeadSQLElement(AbstractModule module) {
        super(module, "LEAD");
        this.setL18nLocation(LeadSQLElement.class);
        RowAction.PredicateRowAction addCallAction = new RowAction.PredicateRowAction(new AbstractAction("Appeler"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow sRow = IListe.get((EventObject)e).getSelectedRow().asRow();
                SQLTable table = LeadSQLElement.this.getTable().getTable("LEAD_CALL");
                SQLElement eCall = LeadSQLElement.this.getDirectory().getElement(table);
                EditFrame editFrame = new EditFrame(eCall);
                SQLRowValues sqlRowValues = new SQLRowValues(table);
                sqlRowValues.put("ID_LEAD", (Object)sRow.getIDNumber());
                editFrame.getSQLComponent().select((SQLRowAccessor)sqlRowValues);
                FrameUtil.show((Window)editFrame);
            }
        }, true){};
        addCallAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(addCallAction);
        RowAction.PredicateRowAction addVisitAction = new RowAction.PredicateRowAction(new AbstractAction("Enregister une visite"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow sRow = IListe.get((EventObject)e).getSelectedRow().asRow();
                SQLTable table = LeadSQLElement.this.getTable().getTable("LEAD_VISIT");
                SQLElement eCall = LeadSQLElement.this.getDirectory().getElement(table);
                EditFrame editFrame = new EditFrame(eCall);
                SQLRowValues sqlRowValues = new SQLRowValues(table);
                sqlRowValues.put("ID_LEAD", (Object)sRow.getIDNumber());
                editFrame.getSQLComponent().select((SQLRowAccessor)sqlRowValues);
                FrameUtil.show((Window)editFrame);
            }
        }, true){};
        addVisitAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(addVisitAction);
        this.setRowActions();
    }

    protected void _initTableSource(SQLTableModelSource source) {
        super._initTableSource(source);
        if (!UserRightsManager.getCurrentUserRights().haveRight(CODE_NOT_RESTRICT)) {
            SQLRow row = Configuration.getInstance().getRoot().findTable("USER_COMMON").getRow(UserManager.getInstance().getCurrentUser().getId());
            List rows = row.getReferentRows(Configuration.getInstance().getRoot().findTable("COMMERCIAL").getField("ID_USER_COMMON"));
            final ArrayList<Integer> listComm = new ArrayList<Integer>();
            for (SQLRow sqlRow : rows) {
                listComm.add(sqlRow.getID());
            }
            if (!listComm.isEmpty()) {
                source.getReq().setSelectTransf((ITransformer)new ITransformer<SQLSelect, SQLSelect>(){

                    public SQLSelect transformChecked(SQLSelect input) {
                        SQLField field = input.getTable("LEAD").getField("ID_COMMERCIAL");
                        Where w = new Where((FieldRef)field, (Collection)listComm);
                        w = w.or(new Where((FieldRef)field, "IS", null));
                        w = w.or(new Where((FieldRef)field, "=", LeadSQLElement.this.getTable().getTable("COMMERCIAL").getUndefinedID()));
                        input.setWhere(w);
                        return input;
                    }
                });
            }
        }
        BaseSQLTableModelColumn adresse = new BaseSQLTableModelColumn("Adresse", String.class){

            protected Object show_(SQLRowAccessor r) {
                SQLRowAccessor rAdr = r.getForeign("ID_ADRESSE");
                if (rAdr != null && !rAdr.isUndefined()) {
                    return rAdr.getString("RUE");
                }
                return "";
            }

            public Set<FieldPath> getPaths() {
                Path p = new Path(LeadSQLElement.this.getTable());
                p = (Path)p.add(LeadSQLElement.this.getTable().getTable("ADRESSE"));
                return CollectionUtils.createSet((Object[])new FieldPath[]{new FieldPath(p, "RUE")});
            }
        };
        source.getColumns().add(adresse);
        BaseSQLTableModelColumn cp = new BaseSQLTableModelColumn("Code Postal", String.class){

            protected Object show_(SQLRowAccessor r) {
                SQLRowAccessor rAdr = r.getForeign("ID_ADRESSE");
                if (rAdr != null && !rAdr.isUndefined()) {
                    return rAdr.getString("CODE_POSTAL");
                }
                return "";
            }

            public Set<FieldPath> getPaths() {
                Path p = new Path(LeadSQLElement.this.getTable());
                p = (Path)p.add(LeadSQLElement.this.getTable().getTable("ADRESSE"));
                return CollectionUtils.createSet((Object[])new FieldPath[]{new FieldPath(p, "CODE_POSTAL")});
            }
        };
        source.getColumns().add(cp);
        BaseSQLTableModelColumn ville = new BaseSQLTableModelColumn("Ville", String.class){

            protected Object show_(SQLRowAccessor r) {
                SQLRowAccessor rAdr = r.getForeign("ID_ADRESSE");
                if (rAdr != null && !rAdr.isUndefined()) {
                    return rAdr.getString("VILLE");
                }
                return "";
            }

            public Set<FieldPath> getPaths() {
                Path p = new Path(LeadSQLElement.this.getTable());
                p = (Path)p.add(LeadSQLElement.this.getTable().getTable("ADRESSE"));
                return CollectionUtils.createSet((Object[])new FieldPath[]{new FieldPath(p, "VILLE")});
            }
        };
        source.getColumns().add(ville);
        if (this.getTable().contains("REMIND_DATE")) {
            BaseSQLTableModelColumn dateRemind = new BaseSQLTableModelColumn("Date de rappel", Date.class){

                protected Object show_(SQLRowAccessor r) {
                    Calendar c = r.getDate("REMIND_DATE");
                    if (c == null) {
                        return null;
                    }
                    return c.getTime();
                }

                public Set<FieldPath> getPaths() {
                    Path p = new Path(LeadSQLElement.this.getTable());
                    return CollectionUtils.createSet((Object[])new FieldPath[]{new FieldPath(p, "REMIND_DATE")});
                }
            };
            dateRemind.setRenderer((TableCellRenderer)new RemindDateRenderer());
            source.getColumns().add(dateRemind);
        }
    }

    private void setRowActions() {
        AbstractAction action = new AbstractAction("Transf\u00e9rer en client"){

            @Override
            public void actionPerformed(ActionEvent e) {
                final SQLRow row = IListe.get((EventObject)e).getSelectedRow().asRow();
                SQLRow foreign = row.getForeign("ID_CLIENT");
                if (foreign == null || foreign.isUndefined()) {
                    SQLRowValues rowVals = SQLInjector.getInjector((SQLTable)row.getTable(), (SQLTable)row.getTable().getTable("CLIENT")).createRowValuesFrom(row);
                    SQLRow adresse = row.getForeign("ID_ADRESSE");
                    if (adresse != null && !adresse.isUndefined()) {
                        SQLRowValues rowValsAdr = new SQLRowValues(adresse.asRowValues());
                        rowVals.put("ID_ADRESSE", (Object)rowValsAdr);
                    }
                    SQLRowValues rowValsContact = SQLInjector.getInjector((SQLTable)row.getTable(), (SQLTable)row.getTable().getTable("CONTACT")).createRowValuesFrom(row);
                    rowValsContact.put("ID_CLIENT", (Object)rowVals);
                    EditFrame frame = new EditFrame(Configuration.getInstance().getDirectory().getElement("CLIENT"), EditPanel.EditMode.CREATION);
                    frame.getSQLComponent().select((SQLRowAccessor)rowVals);
                    frame.setVisible(true);
                    frame.addEditPanelListener(new EditPanelListener(){

                        public void modified() {
                        }

                        public void inserted(int id) {
                            SQLRowValues rowVals = row.asRowValues();
                            rowVals.put("ID_CLIENT", id);
                            rowVals.put("STATUS", (Object)"Acquis");
                            try {
                                rowVals.commit();
                            }
                            catch (SQLException exn) {
                                exn.printStackTrace();
                            }
                        }

                        public void deleted() {
                        }

                        public void cancelled() {
                        }
                    });
                } else {
                    JOptionPane.showMessageDialog(null, "Ce prospect a d\u00e9j\u00e0 \u00e9t\u00e9 transf\u00e9r\u00e9 en client!");
                }
            }
        };
        RowAction.PredicateRowAction transfertClient = new RowAction.PredicateRowAction((Action)action, true);
        transfertClient.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(transfertClient);
        AbstractAction actionMail = new AbstractAction("Envoyer un e-mail"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LeadSQLElement.this.sendMail(IListe.get((EventObject)e).getSelectedRows());
            }
        };
        RowAction.PredicateRowAction mail = new RowAction.PredicateRowAction((Action)actionMail, true);
        mail.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.getRowActions().add(mail);
    }

    protected void sendMail(List<SQLRowValues> l) {
        String mail = "";
        for (SQLRowAccessor sQLRowAccessor : l) {
            String string = sQLRowAccessor.getString("EMAIL");
            if (string == null || string.trim().length() <= 0) continue;
            mail = String.valueOf(mail) + string + ";";
        }
        try {
            EmailComposer.getInstance().compose(mail, "", "", new File[0]);
        }
        catch (Exception exception) {
            ExceptionHandler.handle(null, (String)"Impossible de cr\u00e9er le courriel", (Throwable)exception);
        }
    }

    protected String createCode() {
        return ELEMENT_CODE;
    }

    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_COMMERCIAL");
        l.add("DATE");
        l.add("COMPANY");
        l.add("LOCALISATION");
        l.add("ID_TITRE_PERSONNEL");
        l.add("NAME");
        l.add("FIRSTNAME");
        l.add("PHONE");
        l.add("MOBILE");
        l.add("EMAIL");
        l.add("SOURCE");
        l.add("INFORMATION");
        l.add("INFOS");
        return l;
    }

    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("COMPANY");
        l.add("FIRSTNAME");
        l.add("NAME");
        return l;
    }

    protected List<String> getPrivateFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_ADRESSE");
        return l;
    }

    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, this.getComboFields());
    }

    public SQLComponent createComponent() {
        String groupId = String.valueOf(this.getCode()) + ".default";
        Group group = GlobalMapper.getInstance().getGroup(groupId);
        if (group == null) {
            throw new IllegalStateException("No group found for id " + groupId);
        }
        return this.createComponent(group);
    }

    protected SQLComponent createComponent(Group group) {
        return new LeadSQLComponent((SQLElement)this, group);
    }
}

