/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.customerrelationship.lead;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.PanelFrame;
import org.openconcerto.utils.CollectionUtils;

public class LeadListAction
extends CreateFrameAbstractAction {
    private SQLElement eltProspect = Configuration.getInstance().getDirectory().getElement("LEAD");

    public JFrame createFrame() {
        PanelFrame frame = new PanelFrame((Container)this.getPanel(), "Liste des prospects");
        return frame;
    }

    public LeadListAction() {
        super("Liste des propects");
    }

    public JPanel getPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 0;
        JTabbedPane tabbedPane = new JTabbedPane();
        HashMap<IListe, SQLField> listeFilter = new HashMap<IListe, SQLField>();
        ListeAddPanel panelAll = this.createPanel(null);
        listeFilter.put(panelAll.getListe(), panelAll.getListe().getModel().getTable().getField("DATE"));
        tabbedPane.add("Tous", (Component)panelAll);
        ListeAddPanel panelEmpty = this.createPanel("");
        listeFilter.put(panelEmpty.getListe(), panelEmpty.getListe().getModel().getTable().getField("DATE"));
        tabbedPane.add("Sans statut", (Component)panelEmpty);
        SQLSelect selStatus = new SQLSelect();
        selStatus.addSelect((FieldRef)this.eltProspect.getTable().getField("STATUS"));
        selStatus.addGroupBy((FieldRef)this.eltProspect.getTable().getField("STATUS"));
        selStatus.addFieldOrder((FieldRef)this.eltProspect.getTable().getField("STATUS"));
        System.err.println(selStatus.asString());
        List listStatus = Configuration.getInstance().getBase().getDataSource().executeCol(selStatus.asString());
        for (String status : listStatus) {
            if (status == null || status.trim().length() <= 0) continue;
            ListeAddPanel p = this.createPanel(status);
            listeFilter.put(p.getListe(), p.getListe().getModel().getTable().getField("DATE"));
            tabbedPane.add(status, (Component)p);
        }
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        panel.add((Component)tabbedPane, c);
        IListFilterDatePanel panelDate = new IListFilterDatePanel(listeFilter, IListFilterDatePanel.getDefaultMap());
        c.gridy = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        ++c.gridy;
        panel.add((Component)panelDate, c);
        return panel;
    }

    private ListeAddPanel createPanel(String status) {
        SQLTableModelSourceOnline source = this.eltProspect.getTableSource(true);
        if (status != null) {
            Where wAttente = new Where((FieldRef)this.eltProspect.getTable().getField("STATUS"), "=", (Object)status);
            source.getReq().setWhere(wAttente);
        } else {
            source.getColumns().add(new BaseSQLTableModelColumn("Transf\u00e9rer en client", Boolean.class){

                protected Object show_(SQLRowAccessor r) {
                    if (r.getForeign("ID_CLIENT") != null && !r.isForeignEmpty("ID_CLIENT")) {
                        return true;
                    }
                    return false;
                }

                public Set<FieldPath> getPaths() {
                    Path p = new Path(LeadListAction.this.eltProspect.getTable());
                    return CollectionUtils.createSet((Object[])new FieldPath[]{new FieldPath(p, "ID_CLIENT")});
                }
            });
        }
        ListeAddPanel pane = new ListeAddPanel(this.eltProspect, new IListe((SQLTableModelSource)source), "Status" + status);
        pane.getListe().setOpaque(false);
        pane.setOpaque(false);
        return pane;
    }
}

