/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.customerrelationship.lead;

import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class LeadCustomerSQLInjector
extends SQLInjector {
    private static final SQLTable customerTable = Configuration.getInstance().getDirectory().getElement("CLIENT").getTable();
    private static final SQLTable leadTable = Configuration.getInstance().getDirectory().getElement("LEAD").getTable();

    public LeadCustomerSQLInjector() {
        super(leadTable, customerTable, false);
        this.createDefaultMap();
        this.map(leadTable.getField("NAME"), customerTable.getField("RESPONSABLE"));
        this.map(leadTable.getField("COMPANY"), customerTable.getField("NOM"));
        this.map(leadTable.getField("PHONE"), customerTable.getField("TEL"));
        this.map(leadTable.getField("MOBILE"), customerTable.getField("TEL_P"));
        this.map(leadTable.getField("FAX"), customerTable.getField("FAX"));
        this.map(leadTable.getField("EMAIL"), customerTable.getField("MAIL"));
        this.map(leadTable.getField("MOBILE"), customerTable.getField("TEL_P"));
        this.map(this.getSource().getField("INFOS"), this.getDestination().getField("INFOS"));
        this.remove(leadTable.getField("ID_ADRESSE"), customerTable.getField("ID_ADRESSE"));
    }

    protected void merge(SQLRowAccessor srcRow, SQLRowValues rowVals) {
        super.merge(srcRow, rowVals);
        if (rowVals.getString("NOM") == null || rowVals.getString("NOM").trim().length() == 0) {
            rowVals.put("NOM", (Object)srcRow.getString("NAME"));
        }
    }
}

