/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.modules.customerrelationship.lead;

import java.awt.Dimension;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.openconcerto.erp.modules.ModuleElement;
import org.openconcerto.sql.element.GroupSQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.QuickAssignPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.group.Group;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.ITransformer;

public class GroupSQLComponentWithService
extends GroupSQLComponent {
    public GroupSQLComponentWithService(ModuleElement element, Group group) {
        super((SQLElement)element, group);
    }

    public JComponent getLabel(String id) {
        if (id.equals("ibd.services")) {
            return new JLabel("Services propos\u00e9s");
        }
        return super.getLabel(id);
    }

    public JComponent createEditor(String id) {
        if (id.equals("ibd.services")) {
            SQLElement serviceElement = this.getElement().getDirectory().getElement("SERVICE");
            ArrayList<SQLTableElement> tableElements = new ArrayList<SQLTableElement>();
            tableElements.add(new SQLTableElement(serviceElement.getTable().getField("NAME")));
            RowValuesTableModel model = new RowValuesTableModel(serviceElement, tableElements, serviceElement.getTable().getKey(), false);
            QuickAssignPanel table = new QuickAssignPanel(serviceElement, "ID", model);
            table.setMinimumSize(new Dimension(200, 150));
            table.setPreferredSize(new Dimension(200, 150));
            return table;
        }
        return super.createEditor(id);
    }

    QuickAssignPanel getQuickAssignPanel() {
        return (QuickAssignPanel)this.getEditor("ibd.services");
    }

    public void select(final SQLRowAccessor row) {
        QuickAssignPanel panel = this.getQuickAssignPanel();
        panel.getModel().clearRows();
        if (row != null) {
            final SQLTable associationTable = this.getServiceAssociationTable();
            SQLRowValues graph = new SQLRowValues(associationTable);
            graph.put("ID", null);
            graph.putRowValues("ID_SERVICE").put("NAME", null);
            final String tableName = this.getElement().getTable().getName();
            SQLRowValuesListFetcher f = new SQLRowValuesListFetcher(graph);
            f.setSelTransf((ITransformer)new ITransformer<SQLSelect, SQLSelect>(){

                public SQLSelect transformChecked(SQLSelect input) {
                    input.setWhere(new Where((FieldRef)associationTable.getField("ID_" + tableName), "=", row.getID()));
                    return input;
                }
            });
            List associations = f.fetch();
            for (SQLRowValues r : associations) {
                panel.getModel().addRow(r.getForeign("ID_SERVICE").asRowValues());
            }
        }
        super.select(row);
    }

    public int insert(SQLRow order) {
        int id = super.insert(order);
        this.insertAssociatedServiceTo(id);
        SQLRow row = this.getTable().getRow(id);
        String field = "ID_LEAD";
        if (this.getTable().contains("ID_CLIENT")) {
            field = "ID_CLIENT";
        }
        SQLRowValues rowVals = row.getForeign(field).createEmptyUpdateRow();
        rowVals.put("REMIND_DATE", row.getObject("NEXTCONTACT_DATE"));
        try {
            rowVals.update();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return id;
    }

    public void update() {
        super.update();
        SQLTable associationTable = this.getServiceAssociationTable();
        String query = "DELETE FROM " + associationTable.getSQL() + " WHERE \"ID_" + this.getElement().getTable().getName() + "\" = " + this.getSelectedID();
        associationTable.getDBSystemRoot().getDataSource().execute(query);
        this.insertAssociatedServiceTo(this.getSelectedID());
        SQLRow row = this.getTable().getRow(this.getSelectedID());
        String field = "ID_LEAD";
        if (this.getTable().contains("ID_CLIENT")) {
            field = "ID_CLIENT";
        }
        SQLRowValues rowVals = row.getForeign(field).createEmptyUpdateRow();
        rowVals.put("REMIND_DATE", row.getObject("NEXTCONTACT_DATE"));
        try {
            rowVals.update();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void insertAssociatedServiceTo(int id) {
        SQLTable associationTable = this.getServiceAssociationTable();
        QuickAssignPanel panel = this.getQuickAssignPanel();
        String tableName = this.getElement().getTable().getName();
        int stop = panel.getModel().getRowCount();
        int i = 0;
        while (i < stop) {
            SQLRowValues rService = panel.getModel().getRowValuesAt(i);
            SQLRowValues rAccess = new SQLRowValues(associationTable);
            rAccess.put("ID_" + tableName, id);
            rAccess.put("ID_SERVICE", rService.getID());
            try {
                rAccess.commit();
            }
            catch (SQLException e) {
                ExceptionHandler.handle((String)"Unable to store service assocation", (Throwable)e);
            }
            ++i;
        }
    }

    SQLTable getServiceAssociationTable() {
        SQLTable table = this.getElement().getTable();
        return table.getTable(String.valueOf(table.getName()) + "_SERVICE");
    }
}

